/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkNumber;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.TypeConvertingVisitor;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.EnhancedAttributeValue;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.SdkNumberStringConverter;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public final class SdkNumberAttributeConverter
implements AttributeConverter<SdkNumber> {
    private static final Visitor VISITOR = new Visitor();
    private static final SdkNumberStringConverter STRING_CONVERTER = SdkNumberStringConverter.create();

    private SdkNumberAttributeConverter() {
    }

    public static SdkNumberAttributeConverter create() {
        return new SdkNumberAttributeConverter();
    }

    @Override
    public EnhancedType<SdkNumber> type() {
        return EnhancedType.of(SdkNumber.class);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.N;
    }

    @Override
    public AttributeValue transformFrom(SdkNumber input) {
        return (AttributeValue)AttributeValue.builder().n(STRING_CONVERTER.toString(input)).build();
    }

    @Override
    public SdkNumber transformTo(AttributeValue input) {
        if (input.n() != null) {
            return EnhancedAttributeValue.fromNumber(input.n()).convert(VISITOR);
        }
        return EnhancedAttributeValue.fromAttributeValue(input).convert(VISITOR);
    }

    private static final class Visitor
    extends TypeConvertingVisitor<SdkNumber> {
        private Visitor() {
            super(SdkNumber.class, SdkNumberAttributeConverter.class);
        }

        @Override
        public SdkNumber convertString(String value) {
            return STRING_CONVERTER.fromString(value);
        }

        @Override
        public SdkNumber convertNumber(String value) {
            return STRING_CONVERTER.fromString(value);
        }
    }
}

