/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.algorithms.contextmanager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ml.common.contextmanager.ContextManagementTemplate;
import org.opensearch.ml.common.contextmanager.ContextManager;
import org.opensearch.ml.common.contextmanager.ContextManagerConfig;
import org.opensearch.ml.engine.algorithms.contextmanager.SlidingWindowManager;
import org.opensearch.ml.engine.algorithms.contextmanager.SummarizationManager;
import org.opensearch.ml.engine.algorithms.contextmanager.ToolsOutputTruncateManager;
import org.opensearch.transport.client.Client;

public class ContextManagerFactory {
    @Generated
    private static final Logger log = LogManager.getLogger(ContextManagerFactory.class);

    public static List<ContextManager> createContextManagers(ContextManagementTemplate template, Client client) {
        ArrayList<ContextManager> managers = new ArrayList<ContextManager>();
        try {
            for (Map.Entry entry : template.getHooks().entrySet()) {
                String hookName = (String)entry.getKey();
                List configs = (List)entry.getValue();
                log.debug("Processing hook '{}' with {} configurations", (Object)hookName, (Object)configs.size());
                for (ContextManagerConfig config : configs) {
                    try {
                        ContextManager manager = ContextManagerFactory.createContextManager(config, client);
                        if (manager == null) continue;
                        managers.add(manager);
                        log.debug("Created context manager: {} for hook: {}", (Object)config.getType(), (Object)hookName);
                    }
                    catch (Exception e) {
                        log.error("Failed to create context manager of type '{}' for hook '{}': {}", (Object)config.getType(), (Object)hookName, (Object)e.getMessage(), (Object)e);
                    }
                }
            }
            log.info("Successfully created {} context managers from template '{}'", (Object)managers.size(), (Object)template.getName());
        }
        catch (Exception e) {
            log.error("Failed to create context managers from template '{}': {}", (Object)template.getName(), (Object)e.getMessage(), (Object)e);
        }
        return managers;
    }

    public static ContextManager createContextManager(ContextManagerConfig config, Client client) {
        try {
            String type = config.getType();
            Map managerConfig = config.getConfig();
            log.debug("Creating context manager of type: {}", (Object)type);
            switch (type) {
                case "ToolsOutputTruncateManager": {
                    return ContextManagerFactory.createToolsOutputTruncateManager(managerConfig);
                }
                case "SummarizationManager": {
                    return ContextManagerFactory.createSummarizationManager(managerConfig, client);
                }
                case "SlidingWindowManager": {
                    return ContextManagerFactory.createMemoryManager(managerConfig);
                }
                case "ConversationManager": {
                    return ContextManagerFactory.createConversationManager(managerConfig, client);
                }
            }
            throw new IllegalArgumentException("Unknown context manager type: " + type);
        }
        catch (Exception e) {
            log.error("Failed to create context manager: {}", (Object)e.getMessage(), (Object)e);
            throw e;
        }
    }

    private static ContextManager createToolsOutputTruncateManager(Map<String, Object> config) {
        log.debug("Creating ToolsOutputTruncateManager with config: {}", config);
        ToolsOutputTruncateManager manager = new ToolsOutputTruncateManager();
        manager.initialize(config != null ? config : new HashMap());
        return manager;
    }

    private static ContextManager createSummarizationManager(Map<String, Object> config, Client client) {
        log.debug("Creating SummarizationManager with config: {}", config);
        SummarizationManager manager = new SummarizationManager(client);
        manager.initialize(config != null ? config : new HashMap());
        return manager;
    }

    private static ContextManager createMemoryManager(Map<String, Object> config) {
        log.debug("Creating SlidingWindowManager (MemoryManager) with config: {}", config);
        SlidingWindowManager manager = new SlidingWindowManager();
        manager.initialize(config != null ? config : new HashMap());
        return manager;
    }

    private static ContextManager createConversationManager(Map<String, Object> config, Client client) {
        log.debug("Creating ConversationManager (using SummarizationManager as placeholder) with config: {}", config);
        SummarizationManager manager = new SummarizationManager(client);
        manager.initialize(config != null ? config : new HashMap());
        return manager;
    }
}

