/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.referral;

import org.ldaptive.Connection;
import org.ldaptive.DeleteOperation;
import org.ldaptive.DeleteRequest;
import org.ldaptive.LdapURL;
import org.ldaptive.Operation;
import org.ldaptive.referral.AbstractReferralHandler;
import org.ldaptive.referral.ReferralConnectionFactory;

public class DeleteReferralHandler
extends AbstractReferralHandler<DeleteRequest, Void> {
    public DeleteReferralHandler() {
        this(10, 0, DEFAULT_CONNECTION_FACTORY);
    }

    public DeleteReferralHandler(ReferralConnectionFactory factory) {
        this(10, 0, factory);
    }

    public DeleteReferralHandler(int limit) {
        this(limit, 0, DEFAULT_CONNECTION_FACTORY);
    }

    public DeleteReferralHandler(int limit, ReferralConnectionFactory factory) {
        this(limit, 0, factory);
    }

    private DeleteReferralHandler(int limit, int depth, ReferralConnectionFactory factory) {
        super(limit, depth, factory);
    }

    @Override
    protected DeleteRequest createReferralRequest(DeleteRequest request, LdapURL url) {
        DeleteRequest referralRequest = new DeleteRequest();
        referralRequest.setControls(request.getControls());
        referralRequest.setIntermediateResponseHandlers(request.getIntermediateResponseHandlers());
        referralRequest.setReferralHandler(new DeleteReferralHandler(this.getReferralLimit(), this.getReferralDepth() + 1, this.getReferralConnectionFactory()));
        if (!url.getEntry().isDefaultBaseDn()) {
            referralRequest.setDn(url.getEntry().getBaseDn());
        } else {
            referralRequest.setDn(request.getDn());
        }
        return referralRequest;
    }

    @Override
    protected Operation<DeleteRequest, Void> createReferralOperation(Connection conn) {
        return new DeleteOperation(conn);
    }
}

