/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM PromiseRejectionEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "EventBinding.h"
#include "PromiseRejectionEvent.h"
#include "PromiseRejectionEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/PromiseRejectionEvent.h"
#include "mozilla/dom/RootedDictionary.h"

namespace mozilla::dom {


NS_IMPL_CYCLE_COLLECTION_CLASS(PromiseRejectionEvent)

NS_IMPL_ADDREF_INHERITED(PromiseRejectionEvent, Event)
NS_IMPL_RELEASE_INHERITED(PromiseRejectionEvent, Event)

NS_IMPL_CYCLE_COLLECTION_TRAVERSE_BEGIN_INHERITED(PromiseRejectionEvent, Event)
NS_IMPL_CYCLE_COLLECTION_TRAVERSE_END

NS_IMPL_CYCLE_COLLECTION_TRACE_BEGIN_INHERITED(PromiseRejectionEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_TRACE_JS_MEMBER_CALLBACK(mPromise)
  NS_IMPL_CYCLE_COLLECTION_TRACE_JS_MEMBER_CALLBACK(mReason)
NS_IMPL_CYCLE_COLLECTION_TRACE_END

NS_IMPL_CYCLE_COLLECTION_UNLINK_BEGIN_INHERITED(PromiseRejectionEvent, Event)
  tmp->mPromise = nullptr;
  tmp->mReason.setUndefined();
NS_IMPL_CYCLE_COLLECTION_UNLINK_END

NS_INTERFACE_MAP_BEGIN_CYCLE_COLLECTION(PromiseRejectionEvent)
NS_INTERFACE_MAP_END_INHERITING(Event)

PromiseRejectionEvent::PromiseRejectionEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

PromiseRejectionEvent::~PromiseRejectionEvent()
{
  mozilla::DropJSObjects(this);
}

void
PromiseRejectionEvent::GetReason(JS::MutableHandle<JS::Value> aRetVal) const
{
  JS::ExposeValueToActiveJS(mReason);
  aRetVal.set(mReason);
}

PromiseRejectionEvent*
PromiseRejectionEvent::AsPromiseRejectionEvent()
{
  return this;
}

JSObject*
PromiseRejectionEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return PromiseRejectionEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<PromiseRejectionEvent>
PromiseRejectionEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const PromiseRejectionEventInit& aEventInitDict)
{
  RefPtr<PromiseRejectionEvent> e = new PromiseRejectionEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mPromise = aEventInitDict.mPromise;
  e->mReason = aEventInitDict.mReason;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  mozilla::HoldJSObjects(e.get());
  return e.forget();
}

already_AddRefed<PromiseRejectionEvent>
PromiseRejectionEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const PromiseRejectionEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

void
PromiseRejectionEvent::GetRejectedPromise(JSContext* cx, JS::MutableHandle<JSObject*> aRetVal) const
{
  if (mPromise) {
    JS::ExposeObjectToActiveJS(mPromise);
  }
  aRetVal.set(mPromise);
  return;
}

void
PromiseRejectionEvent::GetReason(JSContext* cx, JS::MutableHandle<JS::Value> aRetVal) const
{
  GetReason(aRetVal);
}


} // namespace mozilla::dom
