/* backend-store.c generated by valac 0.56.18, the Vala compiler
 * generated from backend-store.vala, do not modify */

/*
 * Copyright (C) 2008 Nokia Corporation.
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *          Travis Reitter <travis.reitter@collabora.co.uk>
 *
 * This file was originally part of Rygel.
 */

#include "folks/folks.h"
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "folks/small-set.h"
#include <gio/gio.h>
#include <gmodule.h>
#include "folks-internal.h"
#include "config.h"
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	FOLKS_BACKEND_STORE_0_PROPERTY,
	FOLKS_BACKEND_STORE_ENABLED_BACKENDS_PROPERTY,
	FOLKS_BACKEND_STORE_IS_PREPARED_PROPERTY,
	FOLKS_BACKEND_STORE_NUM_PROPERTIES
};
static GParamSpec* folks_backend_store_properties[FOLKS_BACKEND_STORE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef void (*FolksBackendStoreModuleFinalizeFunc) (FolksBackendStore* store);
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _folks_internal_profile_block_free0(var) ((var == NULL) ? NULL : (var = (folks_internal_profile_block_free (var), NULL)))
typedef struct _FolksBackendStorePrepareData FolksBackendStorePrepareData;
typedef struct _Block1Data Block1Data;
typedef struct _FolksBackendStoreLoadBackendsData FolksBackendStoreLoadBackendsData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _FolksBackendStoreBackendLoadIfNeededData FolksBackendStoreBackendLoadIfNeededData;
typedef struct _FolksBackendStoreBackendUnloadIfNeededData FolksBackendStoreBackendUnloadIfNeededData;
typedef struct _FolksBackendStoreEnableBackendData FolksBackendStoreEnableBackendData;
typedef struct _FolksBackendStoreDisableBackendData FolksBackendStoreDisableBackendData;
typedef struct _FolksBackendStoreGetModulesFromDirData FolksBackendStoreGetModulesFromDirData;
#define _g_module_close0(var) ((var == NULL) ? NULL : (var = (g_module_close (var), NULL)))
typedef void (*FolksBackendStoreModuleInitFunc) (FolksBackendStore* store);
typedef struct _FolksBackendStoreGetFileInfoData FolksBackendStoreGetFileInfoData;
typedef struct _FolksBackendStoreLoadDisabledBackendNamesData FolksBackendStoreLoadDisabledBackendNamesData;
typedef struct _FolksBackendStoreSaveKeyFileData FolksBackendStoreSaveKeyFileData;
enum  {
	FOLKS_BACKEND_STORE_BACKEND_AVAILABLE_SIGNAL,
	FOLKS_BACKEND_STORE_NUM_SIGNALS
};
static guint folks_backend_store_signals[FOLKS_BACKEND_STORE_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FolksBackendStorePrivate {
	GeeHashMap* _backend_hash;
	FolksSmallSet* _backends_allowed;
	FolksSmallSet* _backends_disabled;
	GeeHashMap* _prepared_backends;
	GeeMap* _prepared_backends_ro;
	GFile* _config_file;
	GKeyFile* _backends_key_file;
	GeeHashMap* _modules;
	gboolean _is_prepared;
	FolksDebug* _debug;
};

struct _FolksBackendStorePrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksBackendStore* self;
	FolksInternalProfileBlock* profiling;
	FolksInternalProfileBlock* _tmp0_;
	FolksInternalProfileBlock* _tmp1_;
};

struct _Block1Data {
	int _ref_count_;
	FolksBackendStore* self;
	gint backends_remaining;
	gpointer _async_data_;
};

struct _FolksBackendStoreLoadBackendsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksBackendStore* self;
	Block1Data* _data1_;
	FolksInternalProfileBlock* profiling;
	FolksInternalProfileBlock* _tmp0_;
	GeeIterator* _backend_existing_it;
	GeeHashMap* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	GeeCollection* _tmp4_;
	GeeIterator* _tmp5_;
	GeeIterator* _tmp6_;
	GeeIterator* _tmp7_;
	FolksBackend* backend_existing;
	GeeIterator* _tmp8_;
	gpointer _tmp9_;
	FolksBackend* _tmp10_;
	gchar* _path;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* path;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	GeeHashMap* modules;
	GeeHashMap* _tmp19_;
	gchar** path_split;
	const gchar* _tmp20_;
	gchar** _tmp21_;
	gchar** _tmp22_;
	gint path_split_length1;
	gint _path_split_size_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	gchar** subpath_collection;
	gint subpath_collection_length1;
	gint _subpath_collection_size_;
	gint subpath_it;
	const gchar* subpath;
	GFile* file;
	const gchar* _tmp24_;
	GFile* _tmp25_;
	gboolean is_file;
	gboolean is_dir;
	GFile* _tmp26_;
	gboolean _tmp27_;
	gboolean _tmp28_;
	GeeHashMap* _tmp29_;
	const gchar* _tmp30_;
	GFile* _tmp31_;
	GeeHashMap* cur_modules;
	GFile* _tmp32_;
	GeeHashMap* _tmp33_;
	GeeHashMap* _tmp34_;
	GeeIterator* _entry_it;
	GeeHashMap* _tmp35_;
	GeeSet* _tmp36_;
	GeeSet* _tmp37_;
	GeeSet* _tmp38_;
	GeeIterator* _tmp39_;
	GeeIterator* _tmp40_;
	GeeIterator* _tmp41_;
	GeeMapEntry* entry;
	GeeIterator* _tmp42_;
	gpointer _tmp43_;
	GeeHashMap* _tmp44_;
	GeeMapEntry* _tmp45_;
	gconstpointer _tmp46_;
	gconstpointer _tmp47_;
	GeeMapEntry* _tmp48_;
	gconstpointer _tmp49_;
	gconstpointer _tmp50_;
	const gchar* _tmp51_;
	GeeIterator* _module_it;
	GeeHashMap* _tmp52_;
	GeeCollection* _tmp53_;
	GeeCollection* _tmp54_;
	GeeCollection* _tmp55_;
	GeeIterator* _tmp56_;
	GeeIterator* _tmp57_;
	GeeIterator* _tmp58_;
	GFile* module;
	GeeIterator* _tmp59_;
	gpointer _tmp60_;
	GFile* _tmp61_;
	GeeIterator* _backend_it;
	GeeHashMap* _tmp62_;
	GeeCollection* _tmp63_;
	GeeCollection* _tmp64_;
	GeeCollection* _tmp65_;
	GeeIterator* _tmp66_;
	GeeIterator* _tmp67_;
	GeeIterator* _tmp68_;
	FolksBackend* backend;
	GeeIterator* _tmp69_;
	gpointer _tmp70_;
	gint _tmp71_;
	FolksBackend* _tmp72_;
	gint _tmp73_;
	FolksInternalProfileBlock* _tmp74_;
};

struct _FolksBackendStoreBackendLoadIfNeededData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksBackendStore* self;
	FolksBackend* backend;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GeeHashMap* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GeeHashMap* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	GError* e;
	GError* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GError* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	GError* _tmp17_;
	const gchar* _tmp18_;
	GError* _inner_error0_;
};

struct _FolksBackendStoreBackendUnloadIfNeededData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksBackendStore* self;
	FolksBackend* backend;
	gboolean result;
	gboolean unloaded;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	FolksBackend* backend_existing;
	GeeHashMap* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gpointer _tmp5_;
	FolksBackend* _tmp6_;
	FolksBackend* _tmp7_;
	GError* e;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	GError* _tmp10_;
	const gchar* _tmp11_;
	GeeHashMap* _tmp12_;
	FolksBackend* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	GError* _inner_error0_;
};

struct _FolksBackendStoreEnableBackendData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksBackendStore* self;
	gchar* name;
	GKeyFile* _tmp0_;
};

struct _FolksBackendStoreDisableBackendData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksBackendStore* self;
	gchar* name;
	GKeyFile* _tmp0_;
};

struct _FolksBackendStoreGetModulesFromDirData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksBackendStore* self;
	GFile* dir;
	GeeHashMap* result;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* attributes;
	gchar* _tmp2_;
	GList* infos;
	GFileEnumerator* enumerator;
	const gchar* _tmp3_;
	GFileEnumerator* _tmp4_;
	GList* _tmp5_;
	GFileEnumerator* _tmp6_;
	GList* _tmp7_;
	GList* _tmp8_;
	GError* _error_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GeeHashMap* modules_final;
	GeeHashMap* _tmp13_;
	gchar* _path;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	GList* _tmp16_;
	GList* info_collection;
	GList* info_it;
	GFileInfo* _tmp17_;
	GFileInfo* info;
	GFile* file;
	GFileInfo* _tmp18_;
	const gchar* _tmp19_;
	GFile* _tmp20_;
	GFileInfo* _tmp21_;
	GFile* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	GFileInfo* _tmp25_;
	const gchar* _tmp26_;
	GFile* old_file;
	GFile* _tmp27_;
	GFile* _tmp28_;
	GFileInfo* _tmp29_;
	const gchar* _tmp30_;
	GFile* _tmp31_;
	GFileInfo* _tmp32_;
	GFile* _tmp33_;
	const gchar* _tmp34_;
	GFileInfo* _tmp35_;
	GFileInfo* _tmp36_;
	GError* _vala1__error_;
	GFile* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	GFile* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	GError* _tmp43_;
	const gchar* _tmp44_;
	GFileType file_type;
	GFileInfo* _tmp45_;
	const gchar* content_type;
	GFileInfo* _tmp46_;
	const gchar* _tmp47_;
	gchar* mime;
	const gchar* _tmp48_;
	gchar* _tmp49_;
	GeeHashMap* modules;
	GFile* _tmp50_;
	GeeHashMap* _tmp51_;
	GeeHashMap* _tmp52_;
	GeeIterator* _entry_it;
	GeeHashMap* _tmp53_;
	GeeSet* _tmp54_;
	GeeSet* _tmp55_;
	GeeSet* _tmp56_;
	GeeIterator* _tmp57_;
	GeeIterator* _tmp58_;
	GeeIterator* _tmp59_;
	GeeMapEntry* entry;
	GeeIterator* _tmp60_;
	gpointer _tmp61_;
	GeeHashMap* _tmp62_;
	GeeMapEntry* _tmp63_;
	gconstpointer _tmp64_;
	gconstpointer _tmp65_;
	GeeMapEntry* _tmp66_;
	gconstpointer _tmp67_;
	gconstpointer _tmp68_;
	const gchar* _tmp69_;
	gchar* path;
	GFile* _tmp70_;
	gchar* _tmp71_;
	const gchar* _tmp72_;
	GeeHashMap* _tmp73_;
	const gchar* _tmp74_;
	GFile* _tmp75_;
	const gchar* _tmp76_;
	GFile* _tmp77_;
	gchar* _tmp78_;
	gchar* _tmp79_;
	gboolean _tmp80_;
	gboolean _tmp81_;
	gboolean _tmp82_;
	const gchar* _tmp83_;
	const gchar* _tmp84_;
	const gchar* _tmp85_;
	const gchar* _tmp86_;
	GFile* _tmp87_;
	gchar* _tmp88_;
	gchar* _tmp89_;
	const gchar* _tmp90_;
	gchar* _tmp91_;
	gchar* _tmp92_;
	GError* _inner_error0_;
};

struct _FolksBackendStoreGetFileInfoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GFile* file;
	gboolean is_file;
	gboolean is_dir;
	GFileInfo* file_info;
	GFileInfo* _tmp0_;
	GFileInfo* _tmp1_;
	GFileInfo* _tmp2_;
	GError* _error_;
	GError* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GFileInfo* _tmp8_;
	GFileInfo* _tmp9_;
	GError* _inner_error0_;
};

struct _FolksBackendStoreLoadDisabledBackendNamesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksBackendStore* self;
	gchar* envvar;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar** tokens;
	const gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint tokens_length1;
	gint _tokens_size_;
	FolksSmallSet* _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar** s_collection;
	gint s_collection_length1;
	gint _s_collection_size_;
	gint s_it;
	const gchar* s;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	FolksSmallSet* _tmp10_;
	const gchar* _tmp11_;
	FolksSmallSet* _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gchar** _vala1_s_collection;
	gint _vala1_s_collection_length1;
	gint __vala1_s_collection_size_;
	gint _vala1_s_it;
	const gchar* _vala1_s;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar** _vala1_tokens;
	const gchar* _tmp18_;
	gchar** _tmp19_;
	gchar** _tmp20_;
	gint _vala1_tokens_length1;
	gint __vala1_tokens_size_;
	FolksSmallSet* _tmp21_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	gchar** _vala2_s_collection;
	gint _vala2_s_collection_length1;
	gint __vala2_s_collection_size_;
	gint _vala2_s_it;
	const gchar* _vala2_s;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	FolksSmallSet* _tmp25_;
	const gchar* _tmp26_;
	GFile* file;
	const gchar* path;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	GFile* _tmp30_;
	GFile* _tmp31_;
	GFile* _tmp32_;
	GFile* _tmp33_;
	GFile* _tmp34_;
	GFile* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	const gchar* _tmp38_;
	GFile* _tmp39_;
	const gchar* _tmp40_;
	GFile* _tmp41_;
	GFile* _tmp42_;
	GKeyFile* key_file;
	GKeyFile* _tmp43_;
	guint8* contents;
	gint contents_length1;
	gint _contents_size_;
	GFile* _tmp44_;
	guint8* _tmp45_;
	gsize _tmp46_;
	const gchar* contents_s;
	guint8* _tmp47_;
	gint _tmp47__length1;
	const gchar* _tmp48_;
	gint _tmp49_;
	gint _tmp50_;
	GKeyFile* _tmp51_;
	const gchar* _tmp52_;
	const gchar* _tmp53_;
	gint _tmp54_;
	gint _tmp55_;
	GError* e1;
	GError* _tmp56_;
	GFile* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	GError* _tmp60_;
	const gchar* _tmp61_;
	GKeyFile* _tmp62_;
	GError* _inner_error1_;
	GKeyFile* _tmp63_;
	GError* _inner_error0_;
};

struct _FolksBackendStoreSaveKeyFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksBackendStore* self;
	gchar* key_file_data;
	GKeyFile* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GFile* _tmp5_;
	guint8* _tmp6_;
	gint _tmp6__length1;
	gint _tmp7_;
	guint8* _tmp8_;
	gint _tmp8__length1;
	GError* e;
	GFile* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GError* _tmp12_;
	const gchar* _tmp13_;
	GError* _inner_error0_;
};

static gint FolksBackendStore_private_offset;
static gpointer folks_backend_store_parent_class = NULL;
static FolksBackendStore* folks_backend_store__instance;
static FolksBackendStore* folks_backend_store__instance = NULL;
gchar* folks_backend_store_KEY_FILE_GROUP_ALL_OTHERS = NULL;

static void _folks_backend_store_debug_print_status (FolksBackendStore* self,
                                              FolksDebug* debug);
static void __folks_backend_store_debug_print_status_folks_debug_print_status (FolksDebug* _sender,
                                                                        gpointer self);
static FolksBackendStore* folks_backend_store_new (void);
static FolksBackendStore* folks_backend_store_construct (GType object_type);
static void folks_backend_store_prepare_data_free (gpointer _data);
static gboolean folks_backend_store_prepare_co (FolksBackendStorePrepareData* _data_);
static void _folks_backend_store_load_disabled_backend_names (FolksBackendStore* self,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
static void _folks_backend_store_load_disabled_backend_names_finish (FolksBackendStore* self,
                                                              GAsyncResult* _res_);
static void folks_backend_store_prepare_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_);
static void folks_backend_store_load_backends_data_free (gpointer _data);
static gboolean folks_backend_store_load_backends_co (FolksBackendStoreLoadBackendsData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void folks_backend_store_load_backends_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static void _folks_backend_store_backend_unload_if_needed (FolksBackendStore* self,
                                                    FolksBackend* backend,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
static gboolean _folks_backend_store_backend_unload_if_needed_finish (FolksBackendStore* self,
                                                               GAsyncResult* _res_);
static void _folks_backend_store_get_file_info (GFile* file,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
static void _folks_backend_store_get_file_info_finish (GAsyncResult* _res_,
                                                gboolean* is_file,
                                                gboolean* is_dir);
static void _folks_backend_store_get_modules_from_dir (FolksBackendStore* self,
                                                GFile* dir,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
static GeeHashMap* _folks_backend_store_get_modules_from_dir_finish (FolksBackendStore* self,
                                                              GAsyncResult* _res_);
static void _folks_backend_store_load_module_from_file (FolksBackendStore* self,
                                                 GFile* file);
static void _folks_backend_store_backend_load_if_needed (FolksBackendStore* self,
                                                  FolksBackend* backend,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_);
static void _folks_backend_store_backend_load_if_needed_finish (FolksBackendStore* self,
                                                         GAsyncResult* _res_);
static void ____lambda66_ (Block1Data* _data1_,
                    GObject* o,
                    GAsyncResult* r);
static void _____lambda66__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static void _folks_backend_store_backend_load_if_needed_data_free (gpointer _data);
static gboolean _folks_backend_store_backend_load_if_needed_co (FolksBackendStoreBackendLoadIfNeededData* _data_);
static gboolean _folks_backend_store_backend_is_enabled (FolksBackendStore* self,
                                                  const gchar* name);
static void _folks_backend_store_backend_load_if_needed_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_);
static void _folks_backend_store_backend_unload_if_needed_data_free (gpointer _data);
static gboolean _folks_backend_store_backend_unload_if_needed_co (FolksBackendStoreBackendUnloadIfNeededData* _data_);
static void _folks_backend_store_backend_unload_if_needed_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_);
VALA_EXTERN void _folks_debug_register_domain (FolksDebug* self,
                                   const gchar* domain);
static void folks_backend_store_enable_backend_data_free (gpointer _data);
static gboolean folks_backend_store_enable_backend_co (FolksBackendStoreEnableBackendData* _data_);
static void _folks_backend_store_save_key_file (FolksBackendStore* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
static void _folks_backend_store_save_key_file_finish (FolksBackendStore* self,
                                                GAsyncResult* _res_);
static void folks_backend_store_enable_backend_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_);
static void folks_backend_store_disable_backend_data_free (gpointer _data);
static gboolean folks_backend_store_disable_backend_co (FolksBackendStoreDisableBackendData* _data_);
static void folks_backend_store_disable_backend_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
static void _folks_backend_store_get_modules_from_dir_data_free (gpointer _data);
static gboolean _folks_backend_store_get_modules_from_dir_co (FolksBackendStoreGetModulesFromDirData* _data_);
static void _folks_backend_store_get_modules_from_dir_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void _folks_backend_store_get_file_info_data_free (gpointer _data);
static gboolean _folks_backend_store_get_file_info_co (FolksBackendStoreGetFileInfoData* _data_);
static void _folks_backend_store_get_file_info_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_);
static void _folks_backend_store_load_disabled_backend_names_data_free (gpointer _data);
static gboolean _folks_backend_store_load_disabled_backend_names_co (FolksBackendStoreLoadDisabledBackendNamesData* _data_);
static void _folks_backend_store_load_disabled_backend_names_ready (GObject* source_object,
                                                             GAsyncResult* _res_,
                                                             gpointer _user_data_);
static void _folks_backend_store_save_key_file_data_free (gpointer _data);
static gboolean _folks_backend_store_save_key_file_co (FolksBackendStoreSaveKeyFileData* _data_);
static void _folks_backend_store_save_key_file_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_);
static void folks_backend_store_set_enabled_backends (FolksBackendStore* self,
                                               GeeMap* value);
static void folks_backend_store_set_is_prepared (FolksBackendStore* self,
                                          gboolean value);
static GObject * folks_backend_store_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void folks_backend_store_finalize (GObject * obj);
static GType folks_backend_store_get_type_once (void);
static void _vala_folks_backend_store_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_folks_backend_store_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
folks_backend_store_get_instance_private (FolksBackendStore* self)
{
	return G_STRUCT_MEMBER_P (self, FolksBackendStore_private_offset);
}

static void
__folks_backend_store_debug_print_status_folks_debug_print_status (FolksDebug* _sender,
                                                                   gpointer self)
{
	_folks_backend_store_debug_print_status ((FolksBackendStore*) self, _sender);
}

/**
   * Create a new BackendStore.
   */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

FolksBackendStore*
folks_backend_store_dup (void)
{
	FolksBackendStore* _tmp0_;
	FolksBackendStore* _tmp3_;
	FolksBackendStore* _tmp4_;
	FolksBackendStore* result;
	_tmp0_ = folks_backend_store__instance;
	if (_tmp0_ == NULL) {
		FolksBackendStore* new_instance = NULL;
		FolksBackendStore* _tmp1_;
		FolksBackendStore* _tmp2_;
		_tmp1_ = folks_backend_store_new ();
		new_instance = _tmp1_;
		_tmp2_ = new_instance;
		folks_backend_store__instance = _tmp2_;
		result = new_instance;
		return result;
	}
	_tmp3_ = folks_backend_store__instance;
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, FOLKS_TYPE_BACKEND_STORE, FolksBackendStore));
	result = _tmp4_;
	return result;
}

static FolksBackendStore*
folks_backend_store_construct (GType object_type)
{
	FolksBackendStore * self = NULL;
	self = (FolksBackendStore*) g_object_new (object_type, NULL);
	return self;
}

static FolksBackendStore*
folks_backend_store_new (void)
{
	return folks_backend_store_construct (FOLKS_TYPE_BACKEND_STORE);
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static void
_folks_backend_store_debug_print_status (FolksBackendStore* self,
                                         FolksDebug* debug)
{
	static const char domain[] = FOLKS_DEBUG_STATUS_LOG_DOMAIN;
	static const GLogLevelFlags level = G_LOG_LEVEL_INFO;
	GeeHashMap* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (debug != NULL);
	folks_debug_print_heading (debug, domain, level, "BackendStore (%p)", self);
	_tmp0_ = self->priv->_backend_hash;
	_tmp1_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	folks_debug_print_line (debug, domain, level, "%u Backends:", (guint) _tmp2_);
	folks_debug_indent (debug);
	{
		GeeIterator* _backend_it = NULL;
		GeeHashMap* _tmp3_;
		GeeCollection* _tmp4_;
		GeeCollection* _tmp5_;
		GeeCollection* _tmp6_;
		GeeIterator* _tmp7_;
		GeeIterator* _tmp8_;
		_tmp3_ = self->priv->_backend_hash;
		_tmp4_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = _tmp5_;
		_tmp7_ = gee_iterable_iterator ((GeeIterable*) _tmp6_);
		_tmp8_ = _tmp7_;
		_g_object_unref0 (_tmp6_);
		_backend_it = _tmp8_;
		while (TRUE) {
			GeeIterator* _tmp9_;
			FolksBackend* backend = NULL;
			GeeIterator* _tmp10_;
			gpointer _tmp11_;
			FolksBackend* _tmp12_;
			const gchar* _tmp13_ = NULL;
			FolksBackend* _tmp14_;
			gboolean _tmp15_;
			gboolean _tmp16_;
			const gchar* _tmp17_ = NULL;
			FolksBackend* _tmp18_;
			gboolean _tmp19_;
			gboolean _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			FolksBackend* _tmp23_;
			const gchar* _tmp24_;
			const gchar* _tmp25_;
			FolksBackend* _tmp26_;
			GeeMap* _tmp27_;
			GeeMap* _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			_tmp9_ = _backend_it;
			if (!gee_iterator_next (_tmp9_)) {
				break;
			}
			_tmp10_ = _backend_it;
			_tmp11_ = gee_iterator_get (_tmp10_);
			backend = (FolksBackend*) _tmp11_;
			_tmp12_ = backend;
			folks_debug_print_heading (debug, domain, level, "Backend (%p)", _tmp12_);
			_tmp14_ = backend;
			_tmp15_ = folks_backend_get_is_prepared (_tmp14_);
			_tmp16_ = _tmp15_;
			if (_tmp16_) {
				_tmp13_ = "yes";
			} else {
				_tmp13_ = "no";
			}
			_tmp18_ = backend;
			_tmp19_ = folks_backend_get_is_quiescent (_tmp18_);
			_tmp20_ = _tmp19_;
			if (_tmp20_) {
				_tmp17_ = "yes";
			} else {
				_tmp17_ = "no";
			}
			_tmp21_ = g_strdup_printf ("%u", ((GObject*) self)->ref_count);
			_tmp22_ = _tmp21_;
			_tmp23_ = backend;
			_tmp24_ = folks_backend_get_name (_tmp23_);
			_tmp25_ = _tmp24_;
			folks_debug_print_key_value_pairs (debug, domain, level, "Ref. count", _tmp22_, "Name", _tmp25_, "Prepared?", _tmp13_, "Quiescent?", _tmp17_, NULL);
			_g_free0 (_tmp22_);
			_tmp26_ = backend;
			_tmp27_ = folks_backend_get_persona_stores (_tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = gee_map_get_size (_tmp28_);
			_tmp30_ = _tmp29_;
			folks_debug_print_line (debug, domain, level, "%u PersonaStores:", (guint) _tmp30_);
			folks_debug_indent (debug);
			{
				GeeIterator* _persona_store_it = NULL;
				FolksBackend* _tmp31_;
				GeeMap* _tmp32_;
				GeeMap* _tmp33_;
				GeeCollection* _tmp34_;
				GeeCollection* _tmp35_;
				GeeCollection* _tmp36_;
				GeeIterator* _tmp37_;
				GeeIterator* _tmp38_;
				_tmp31_ = backend;
				_tmp32_ = folks_backend_get_persona_stores (_tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = gee_map_get_values (_tmp33_);
				_tmp35_ = _tmp34_;
				_tmp36_ = _tmp35_;
				_tmp37_ = gee_iterable_iterator ((GeeIterable*) _tmp36_);
				_tmp38_ = _tmp37_;
				_g_object_unref0 (_tmp36_);
				_persona_store_it = _tmp38_;
				while (TRUE) {
					GeeIterator* _tmp39_;
					FolksPersonaStore* persona_store = NULL;
					GeeIterator* _tmp40_;
					gpointer _tmp41_;
					gchar* trust_level = NULL;
					FolksPersonaStore* _tmp42_;
					FolksPersonaStoreTrust _tmp43_;
					FolksPersonaStoreTrust _tmp44_;
					gchar* writeable_props = NULL;
					FolksPersonaStore* _tmp48_;
					gchar** _tmp49_;
					gint _tmp49__length1;
					gint _tmp50_ = 0;
					gchar** _tmp51_;
					gint _tmp51__length1;
					gchar* _tmp52_;
					FolksPersonaStore* _tmp53_;
					const gchar* _tmp54_ = NULL;
					FolksPersonaStore* _tmp55_;
					gboolean _tmp56_;
					gboolean _tmp57_;
					const gchar* _tmp58_ = NULL;
					FolksPersonaStore* _tmp59_;
					gboolean _tmp60_;
					gboolean _tmp61_;
					const gchar* _tmp62_ = NULL;
					FolksPersonaStore* _tmp63_;
					gboolean _tmp64_;
					gboolean _tmp65_;
					gchar* _tmp66_;
					gchar* _tmp67_;
					FolksPersonaStore* _tmp68_;
					const gchar* _tmp69_;
					const gchar* _tmp70_;
					const gchar* _tmp71_;
					const gchar* _tmp72_;
					FolksPersonaStore* _tmp73_;
					GeeMap* _tmp74_;
					GeeMap* _tmp75_;
					gint _tmp76_;
					gint _tmp77_;
					gchar* _tmp78_;
					gchar* _tmp79_;
					_tmp39_ = _persona_store_it;
					if (!gee_iterator_next (_tmp39_)) {
						break;
					}
					_tmp40_ = _persona_store_it;
					_tmp41_ = gee_iterator_get (_tmp40_);
					persona_store = (FolksPersonaStore*) _tmp41_;
					trust_level = NULL;
					_tmp42_ = persona_store;
					_tmp43_ = folks_persona_store_get_trust_level (_tmp42_);
					_tmp44_ = _tmp43_;
					switch (_tmp44_) {
						case FOLKS_PERSONA_STORE_TRUST_NONE:
						{
							gchar* _tmp45_;
							_tmp45_ = g_strdup ("none");
							_g_free0 (trust_level);
							trust_level = _tmp45_;
							break;
						}
						case FOLKS_PERSONA_STORE_TRUST_PARTIAL:
						{
							gchar* _tmp46_;
							_tmp46_ = g_strdup ("partial");
							_g_free0 (trust_level);
							trust_level = _tmp46_;
							break;
						}
						case FOLKS_PERSONA_STORE_TRUST_FULL:
						{
							gchar* _tmp47_;
							_tmp47_ = g_strdup ("full");
							_g_free0 (trust_level);
							trust_level = _tmp47_;
							break;
						}
						default:
						{
							g_assert_not_reached ();
						}
					}
					_tmp48_ = persona_store;
					_tmp49_ = folks_persona_store_get_always_writeable_properties (_tmp48_, &_tmp50_);
					_tmp49__length1 = _tmp50_;
					_tmp51_ = _tmp49_;
					_tmp51__length1 = _tmp49__length1;
					_tmp52_ = _vala_g_strjoinv (",", _tmp51_, (gint) _tmp51__length1);
					writeable_props = _tmp52_;
					_tmp53_ = persona_store;
					folks_debug_print_heading (debug, domain, level, "PersonaStore (%p)", _tmp53_);
					_tmp55_ = persona_store;
					_tmp56_ = folks_persona_store_get_is_prepared (_tmp55_);
					_tmp57_ = _tmp56_;
					if (_tmp57_) {
						_tmp54_ = "yes";
					} else {
						_tmp54_ = "no";
					}
					_tmp59_ = persona_store;
					_tmp60_ = folks_persona_store_get_is_primary_store (_tmp59_);
					_tmp61_ = _tmp60_;
					if (_tmp61_) {
						_tmp58_ = "yes";
					} else {
						_tmp58_ = "no";
					}
					_tmp63_ = persona_store;
					_tmp64_ = folks_persona_store_get_is_quiescent (_tmp63_);
					_tmp65_ = _tmp64_;
					if (_tmp65_) {
						_tmp62_ = "yes";
					} else {
						_tmp62_ = "no";
					}
					_tmp66_ = g_strdup_printf ("%u", ((GObject*) self)->ref_count);
					_tmp67_ = _tmp66_;
					_tmp68_ = persona_store;
					_tmp69_ = folks_persona_store_get_id (_tmp68_);
					_tmp70_ = _tmp69_;
					_tmp71_ = writeable_props;
					_tmp72_ = trust_level;
					_tmp73_ = persona_store;
					_tmp74_ = folks_persona_store_get_personas (_tmp73_);
					_tmp75_ = _tmp74_;
					_tmp76_ = gee_map_get_size (_tmp75_);
					_tmp77_ = _tmp76_;
					_tmp78_ = g_strdup_printf ("%i", _tmp77_);
					_tmp79_ = _tmp78_;
					folks_debug_print_key_value_pairs (debug, domain, level, "Ref. count", _tmp67_, "ID", _tmp70_, "Prepared?", _tmp54_, "Is primary store?", _tmp58_, "Always writeable properties", _tmp71_, "Quiescent?", _tmp62_, "Trust level", _tmp72_, "Persona count", _tmp79_, NULL);
					_g_free0 (_tmp79_);
					_g_free0 (_tmp67_);
					_g_free0 (writeable_props);
					_g_free0 (trust_level);
					_g_object_unref0 (persona_store);
				}
				_g_object_unref0 (_persona_store_it);
			}
			folks_debug_unindent (debug);
			_g_object_unref0 (backend);
		}
		_g_object_unref0 (_backend_it);
	}
	folks_debug_unindent (debug);
	folks_debug_print_line (debug, domain, level, "%s", "");
}

static void
folks_backend_store_prepare_data_free (gpointer _data)
{
	FolksBackendStorePrepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendStorePrepareData, _data_);
}

void
folks_backend_store_prepare (FolksBackendStore* self,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	FolksBackendStorePrepareData* _data_;
	FolksBackendStore* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (FolksBackendStorePrepareData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_backend_store_prepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_backend_store_prepare_co (_data_);
}

void
folks_backend_store_prepare_finish (FolksBackendStore* self,
                                    GAsyncResult* _res_)
{
	FolksBackendStorePrepareData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/**
   * Prepare the BackendStore for use.
   *
   * This must only ever be called before {@link BackendStore.load_backends} is
   * called for the first time. If it isn't called explicitly,
   * {@link BackendStore.load_backends} will call it.
   *
   * This method is safe to call multiple times concurrently (e.g. an
   * asynchronous call may begin between a subsequent asynchronous call
   * beginning and finishing).
   *
   * @since 0.3.0
   */
static void
folks_backend_store_prepare_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_)
{
	FolksBackendStorePrepareData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_backend_store_prepare_co (_data_);
}

static gboolean
folks_backend_store_prepare_co (FolksBackendStorePrepareData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = folks_internal_profiling_start ("preparing BackendStore", NULL);
	_data_->profiling = _data_->_tmp0_;
	_data_->_state_ = 1;
	_folks_backend_store_load_disabled_backend_names (_data_->self, folks_backend_store_prepare_ready, _data_);
	return FALSE;
	_state_1:
	_folks_backend_store_load_disabled_backend_names_finish (_data_->self, _data_->_res_);
	if (_data_->self->priv->_is_prepared == FALSE) {
		_data_->self->priv->_is_prepared = TRUE;
		g_object_notify ((GObject*) _data_->self, "is-prepared");
	}
	_data_->_tmp1_ = _data_->profiling;
	_data_->profiling = NULL;
	folks_internal_profiling_end (_data_->_tmp1_);
	_folks_internal_profile_block_free0 (_data_->profiling);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
folks_backend_store_load_backends_data_free (gpointer _data)
{
	FolksBackendStoreLoadBackendsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendStoreLoadBackendsData, _data_);
}

void
folks_backend_store_load_backends (FolksBackendStore* self,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	FolksBackendStoreLoadBackendsData* _data_;
	FolksBackendStore* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (FolksBackendStoreLoadBackendsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_backend_store_load_backends_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_backend_store_load_backends_co (_data_);
}

void
folks_backend_store_load_backends_finish (FolksBackendStore* self,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	FolksBackendStoreLoadBackendsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * Find, load, and prepare all backends which are not disabled.
   *
   * Backends will be searched for in the path given by the
   * ``FOLKS_BACKEND_PATH`` environment variable, if it's set. If it's not set,
   * backends will be searched for in a path set at compilation time.
   *
   * This method is not safe to call multiple times concurrently.
   *
   * @throws GLib.Error currently unused
   */
static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		FolksBackendStore* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
folks_backend_store_load_backends_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	FolksBackendStoreLoadBackendsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_backend_store_load_backends_co (_data_);
}

static void
____lambda66_ (Block1Data* _data1_,
               GObject* o,
               GAsyncResult* r)
{
	FolksBackendStore* self;
	gint _tmp0_;
	self = _data1_->self;
	g_return_if_fail (r != NULL);
	_folks_backend_store_backend_load_if_needed_finish (self, r);
	_tmp0_ = _data1_->backends_remaining;
	_data1_->backends_remaining = _tmp0_ - 1;
	if (_data1_->backends_remaining == 0) {
		folks_backend_store_load_backends_co (_data1_->_async_data_);
	}
}

static void
_____lambda66__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	____lambda66_ (self, source_object, res);
	block1_data_unref (self);
}

static gboolean
folks_backend_store_load_backends_co (FolksBackendStoreLoadBackendsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = g_object_ref (_data_->self);
	_data_->_data1_->_async_data_ = _data_;
	_vala_assert (g_module_supported (), "Module.supported()");
	_data_->_tmp0_ = folks_internal_profiling_start ("loading backends in BackendStore", NULL);
	_data_->profiling = _data_->_tmp0_;
	_data_->_state_ = 1;
	folks_backend_store_prepare (_data_->self, folks_backend_store_load_backends_ready, _data_);
	return FALSE;
	_state_1:
	folks_backend_store_prepare_finish (_data_->self, _data_->_res_);
	{
		_data_->_tmp1_ = _data_->self->priv->_backend_hash;
		_data_->_tmp2_ = gee_abstract_map_get_values ((GeeAbstractMap*) _data_->_tmp1_);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp5_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp4_);
		_data_->_tmp6_ = _data_->_tmp5_;
		_g_object_unref0 (_data_->_tmp4_);
		_data_->_backend_existing_it = _data_->_tmp6_;
		while (TRUE) {
			_data_->_tmp7_ = _data_->_backend_existing_it;
			if (!gee_iterator_next (_data_->_tmp7_)) {
				break;
			}
			_data_->_tmp8_ = _data_->_backend_existing_it;
			_data_->_tmp9_ = gee_iterator_get (_data_->_tmp8_);
			_data_->backend_existing = (FolksBackend*) _data_->_tmp9_;
			_data_->_tmp10_ = _data_->backend_existing;
			_data_->_state_ = 2;
			_folks_backend_store_backend_unload_if_needed (_data_->self, _data_->_tmp10_, folks_backend_store_load_backends_ready, _data_);
			return FALSE;
			_state_2:
			_folks_backend_store_backend_unload_if_needed_finish (_data_->self, _data_->_res_);
			_g_object_unref0 (_data_->backend_existing);
		}
		_g_object_unref0 (_data_->_backend_existing_it);
	}
	folks_internal_profiling_point ("unloaded backends in BackendStore");
	_data_->_tmp11_ = g_getenv ("FOLKS_BACKEND_PATH");
	_data_->_tmp12_ = g_strdup (_data_->_tmp11_);
	_data_->_path = _data_->_tmp12_;
	_data_->_tmp13_ = _data_->_path;
	if (_data_->_tmp13_ == NULL) {
		_data_->_tmp14_ = g_strdup (BACKEND_DIR);
		_g_free0 (_data_->path);
		_data_->path = _data_->_tmp14_;
		_data_->_tmp15_ = _data_->path;
		g_debug ("Using built-in backend dir '%s' (override with " "environment variable FOLKS_BACKEND_PATH)", _data_->_tmp15_);
	} else {
		_data_->_tmp16_ = _data_->_path;
		_data_->_tmp17_ = g_strdup ((const gchar*) _data_->_tmp16_);
		_g_free0 (_data_->path);
		_data_->path = _data_->_tmp17_;
		_data_->_tmp18_ = _data_->path;
		g_debug ("Using environment variable FOLKS_BACKEND_PATH = " "'%s' to look for backends", _data_->_tmp18_);
	}
	_data_->_tmp19_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->modules = _data_->_tmp19_;
	_data_->_tmp20_ = _data_->path;
	_data_->_tmp22_ = _data_->_tmp21_ = g_strsplit (_data_->_tmp20_, ":", 0);
	_data_->path_split = _data_->_tmp22_;
	_data_->path_split_length1 = _vala_array_length (_data_->_tmp21_);
	_data_->_path_split_size_ = _data_->path_split_length1;
	_data_->_tmp23_ = _data_->path_split;
	_data_->_tmp23__length1 = _data_->path_split_length1;
	{
		_data_->subpath_collection_length1 = 0;
		_data_->_subpath_collection_size_ = 0;
		_data_->subpath_collection = _data_->_tmp23_;
		_data_->subpath_collection_length1 = _data_->_tmp23__length1;
		for (_data_->subpath_it = 0; _data_->subpath_it < _data_->subpath_collection_length1; _data_->subpath_it = _data_->subpath_it + 1) {
			_data_->subpath = _data_->subpath_collection[_data_->subpath_it];
			{
				_data_->_tmp24_ = _data_->subpath;
				_data_->_tmp25_ = g_file_new_for_path (_data_->_tmp24_);
				_data_->file = _data_->_tmp25_;
				_data_->_tmp26_ = _data_->file;
				_data_->_tmp27_ = FALSE;
				_data_->_tmp28_ = FALSE;
				_data_->_state_ = 3;
				_folks_backend_store_get_file_info (_data_->_tmp26_, folks_backend_store_load_backends_ready, _data_);
				return FALSE;
				_state_3:
				_folks_backend_store_get_file_info_finish (_data_->_res_, &_data_->_tmp27_, &_data_->_tmp28_);
				_data_->is_file = _data_->_tmp27_;
				_data_->is_dir = _data_->_tmp28_;
				if (_data_->is_file) {
					_data_->_tmp29_ = _data_->modules;
					_data_->_tmp30_ = _data_->subpath;
					_data_->_tmp31_ = _data_->file;
					gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp29_, _data_->_tmp30_, _data_->_tmp31_);
				} else {
					if (_data_->is_dir) {
						_data_->_tmp32_ = _data_->file;
						_data_->_state_ = 4;
						_folks_backend_store_get_modules_from_dir (_data_->self, _data_->_tmp32_, folks_backend_store_load_backends_ready, _data_);
						return FALSE;
						_state_4:
						_data_->_tmp33_ = _folks_backend_store_get_modules_from_dir_finish (_data_->self, _data_->_res_);
						_data_->cur_modules = _data_->_tmp33_;
						_data_->_tmp34_ = _data_->cur_modules;
						if (_data_->_tmp34_ != NULL) {
							{
								_data_->_tmp35_ = _data_->cur_modules;
								_data_->_tmp36_ = gee_abstract_map_get_entries ((GeeAbstractMap*) G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp35_, GEE_TYPE_HASH_MAP, GeeHashMap));
								_data_->_tmp37_ = _data_->_tmp36_;
								_data_->_tmp38_ = _data_->_tmp37_;
								_data_->_tmp39_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp38_);
								_data_->_tmp40_ = _data_->_tmp39_;
								_g_object_unref0 (_data_->_tmp38_);
								_data_->_entry_it = _data_->_tmp40_;
								while (TRUE) {
									_data_->_tmp41_ = _data_->_entry_it;
									if (!gee_iterator_next (_data_->_tmp41_)) {
										break;
									}
									_data_->_tmp42_ = _data_->_entry_it;
									_data_->_tmp43_ = gee_iterator_get (_data_->_tmp42_);
									_data_->entry = (GeeMapEntry*) _data_->_tmp43_;
									_data_->_tmp44_ = _data_->modules;
									_data_->_tmp45_ = _data_->entry;
									_data_->_tmp46_ = gee_map_entry_get_key (_data_->_tmp45_);
									_data_->_tmp47_ = _data_->_tmp46_;
									_data_->_tmp48_ = _data_->entry;
									_data_->_tmp49_ = gee_map_entry_get_value (_data_->_tmp48_);
									_data_->_tmp50_ = _data_->_tmp49_;
									gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp44_, (const gchar*) _data_->_tmp47_, (GFile*) _data_->_tmp50_);
									_g_object_unref0 (_data_->entry);
								}
								_g_object_unref0 (_data_->_entry_it);
							}
						}
						_g_object_unref0 (_data_->cur_modules);
					} else {
						_data_->_tmp51_ = _data_->subpath;
						g_critical ("FOLKS_BACKEND_PATH component '%s' is not a regular " "file or directory; ignoring...", _data_->_tmp51_);
						g_assert_not_reached ();
					}
				}
				_g_object_unref0 (_data_->file);
			}
		}
	}
	folks_internal_profiling_point ("found modules in BackendStore");
	{
		_data_->_tmp52_ = _data_->modules;
		_data_->_tmp53_ = gee_abstract_map_get_values ((GeeAbstractMap*) _data_->_tmp52_);
		_data_->_tmp54_ = _data_->_tmp53_;
		_data_->_tmp55_ = _data_->_tmp54_;
		_data_->_tmp56_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp55_);
		_data_->_tmp57_ = _data_->_tmp56_;
		_g_object_unref0 (_data_->_tmp55_);
		_data_->_module_it = _data_->_tmp57_;
		while (TRUE) {
			_data_->_tmp58_ = _data_->_module_it;
			if (!gee_iterator_next (_data_->_tmp58_)) {
				break;
			}
			_data_->_tmp59_ = _data_->_module_it;
			_data_->_tmp60_ = gee_iterator_get (_data_->_tmp59_);
			_data_->module = (GFile*) _data_->_tmp60_;
			_data_->_tmp61_ = _data_->module;
			_folks_backend_store_load_module_from_file (_data_->self, _data_->_tmp61_);
			_g_object_unref0 (_data_->module);
		}
		_g_object_unref0 (_data_->_module_it);
	}
	folks_internal_profiling_point ("loaded modules in BackendStore");
	_data_->_data1_->backends_remaining = 1;
	{
		_data_->_tmp62_ = _data_->self->priv->_backend_hash;
		_data_->_tmp63_ = gee_abstract_map_get_values ((GeeAbstractMap*) _data_->_tmp62_);
		_data_->_tmp64_ = _data_->_tmp63_;
		_data_->_tmp65_ = _data_->_tmp64_;
		_data_->_tmp66_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp65_);
		_data_->_tmp67_ = _data_->_tmp66_;
		_g_object_unref0 (_data_->_tmp65_);
		_data_->_backend_it = _data_->_tmp67_;
		while (TRUE) {
			_data_->_tmp68_ = _data_->_backend_it;
			if (!gee_iterator_next (_data_->_tmp68_)) {
				break;
			}
			_data_->_tmp69_ = _data_->_backend_it;
			_data_->_tmp70_ = gee_iterator_get (_data_->_tmp69_);
			_data_->backend = (FolksBackend*) _data_->_tmp70_;
			_data_->_tmp71_ = _data_->_data1_->backends_remaining;
			_data_->_data1_->backends_remaining = _data_->_tmp71_ + 1;
			_data_->_tmp72_ = _data_->backend;
			_folks_backend_store_backend_load_if_needed (_data_->self, _data_->_tmp72_, _____lambda66__gasync_ready_callback, block1_data_ref (_data_->_data1_));
			_g_object_unref0 (_data_->backend);
		}
		_g_object_unref0 (_data_->_backend_it);
	}
	_data_->_tmp73_ = _data_->_data1_->backends_remaining;
	_data_->_data1_->backends_remaining = _data_->_tmp73_ - 1;
	if (_data_->_data1_->backends_remaining > 0) {
		_data_->_state_ = 5;
		return FALSE;
		_state_5:
		;
	}
	_data_->_tmp74_ = _data_->profiling;
	_data_->profiling = NULL;
	folks_internal_profiling_end (_data_->_tmp74_);
	_data_->path_split = (_vala_array_free (_data_->path_split, _data_->path_split_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->modules);
	_g_free0 (_data_->path);
	_g_free0 (_data_->_path);
	_folks_internal_profile_block_free0 (_data_->profiling);
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_folks_backend_store_backend_load_if_needed_data_free (gpointer _data)
{
	FolksBackendStoreBackendLoadIfNeededData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->backend);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendStoreBackendLoadIfNeededData, _data_);
}

static void
_folks_backend_store_backend_load_if_needed (FolksBackendStore* self,
                                             FolksBackend* backend,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	FolksBackendStoreBackendLoadIfNeededData* _data_;
	FolksBackendStore* _tmp0_;
	FolksBackend* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (backend != NULL);
	_data_ = g_slice_new0 (FolksBackendStoreBackendLoadIfNeededData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, _folks_backend_store_backend_load_if_needed_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (backend);
	_g_object_unref0 (_data_->backend);
	_data_->backend = _tmp1_;
	_folks_backend_store_backend_load_if_needed_co (_data_);
}

static void
_folks_backend_store_backend_load_if_needed_finish (FolksBackendStore* self,
                                                    GAsyncResult* _res_)
{
	FolksBackendStoreBackendLoadIfNeededData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
_folks_backend_store_backend_load_if_needed_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_)
{
	FolksBackendStoreBackendLoadIfNeededData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_folks_backend_store_backend_load_if_needed_co (_data_);
}

static gboolean
_folks_backend_store_backend_load_if_needed_co (FolksBackendStoreBackendLoadIfNeededData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = folks_backend_get_name (_data_->backend);
	_data_->_tmp1_ = _data_->_tmp0_;
	if (_folks_backend_store_backend_is_enabled (_data_->self, _data_->_tmp1_)) {
		_data_->_tmp2_ = _data_->self->priv->_prepared_backends;
		_data_->_tmp3_ = folks_backend_get_name (_data_->backend);
		_data_->_tmp4_ = _data_->_tmp3_;
		if (!gee_abstract_map_has_key ((GeeAbstractMap*) _data_->_tmp2_, _data_->_tmp4_)) {
			{
				_data_->_state_ = 1;
				folks_backend_prepare (_data_->backend, _folks_backend_store_backend_load_if_needed_ready, _data_);
				return FALSE;
				_state_1:
				folks_backend_prepare_finish (_data_->backend, _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_data_->_tmp5_ = folks_backend_get_name (_data_->backend);
				_data_->_tmp6_ = _data_->_tmp5_;
				g_debug ("backend-store.vala:418: New backend '%s' prepared", _data_->_tmp6_);
				_data_->_tmp7_ = _data_->self->priv->_prepared_backends;
				_data_->_tmp8_ = folks_backend_get_name (_data_->backend);
				_data_->_tmp9_ = _data_->_tmp8_;
				gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp7_, _data_->_tmp9_, _data_->backend);
				g_signal_emit (_data_->self, folks_backend_store_signals[FOLKS_BACKEND_STORE_BACKEND_AVAILABLE_SIGNAL], 0, _data_->backend);
			}
			goto __finally0;
			__catch0_g_error:
			{
				_data_->e = _data_->_inner_error0_;
				_data_->_inner_error0_ = NULL;
				_data_->_tmp10_ = _data_->e;
				if (g_error_matches (_data_->_tmp10_, G_DBUS_ERROR, G_DBUS_ERROR_SERVICE_UNKNOWN)) {
					_data_->_tmp11_ = folks_backend_get_name (_data_->backend);
					_data_->_tmp12_ = _data_->_tmp11_;
					_data_->_tmp13_ = _data_->e;
					_data_->_tmp14_ = _data_->_tmp13_->message;
					g_debug ("backend-store.vala:430: Error preparing Backend '%s': %s", _data_->_tmp12_, _data_->_tmp14_);
				} else {
					_data_->_tmp15_ = folks_backend_get_name (_data_->backend);
					_data_->_tmp16_ = _data_->_tmp15_;
					_data_->_tmp17_ = _data_->e;
					_data_->_tmp18_ = _data_->_tmp17_->message;
					g_warning ("backend-store.vala:435: Error preparing Backend '%s': %s", _data_->_tmp16_, _data_->_tmp18_);
				}
				_g_error_free0 (_data_->e);
			}
			__finally0:
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_folks_backend_store_backend_unload_if_needed_data_free (gpointer _data)
{
	FolksBackendStoreBackendUnloadIfNeededData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->backend);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendStoreBackendUnloadIfNeededData, _data_);
}

static void
_folks_backend_store_backend_unload_if_needed (FolksBackendStore* self,
                                               FolksBackend* backend,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	FolksBackendStoreBackendUnloadIfNeededData* _data_;
	FolksBackendStore* _tmp0_;
	FolksBackend* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (backend != NULL);
	_data_ = g_slice_new0 (FolksBackendStoreBackendUnloadIfNeededData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, _folks_backend_store_backend_unload_if_needed_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (backend);
	_g_object_unref0 (_data_->backend);
	_data_->backend = _tmp1_;
	_folks_backend_store_backend_unload_if_needed_co (_data_);
}

static gboolean
_folks_backend_store_backend_unload_if_needed_finish (FolksBackendStore* self,
                                                      GAsyncResult* _res_)
{
	gboolean result;
	FolksBackendStoreBackendUnloadIfNeededData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
_folks_backend_store_backend_unload_if_needed_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_)
{
	FolksBackendStoreBackendUnloadIfNeededData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_folks_backend_store_backend_unload_if_needed_co (_data_);
}

static gboolean
_folks_backend_store_backend_unload_if_needed_co (FolksBackendStoreBackendUnloadIfNeededData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->unloaded = FALSE;
	_data_->_tmp0_ = folks_backend_get_name (_data_->backend);
	_data_->_tmp1_ = _data_->_tmp0_;
	if (!_folks_backend_store_backend_is_enabled (_data_->self, _data_->_tmp1_)) {
		_data_->_tmp2_ = _data_->self->priv->_backend_hash;
		_data_->_tmp3_ = folks_backend_get_name (_data_->backend);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _data_->_tmp2_, _data_->_tmp4_);
		_data_->backend_existing = (FolksBackend*) _data_->_tmp5_;
		_data_->_tmp6_ = _data_->backend_existing;
		if (_data_->_tmp6_ != NULL) {
			{
				_data_->_tmp7_ = _data_->backend_existing;
				_data_->_state_ = 1;
				folks_backend_unprepare (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp7_, FOLKS_TYPE_BACKEND, FolksBackend), _folks_backend_store_backend_unload_if_needed_ready, _data_);
				return FALSE;
				_state_1:
				folks_backend_unprepare_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp7_, FOLKS_TYPE_BACKEND, FolksBackend), _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				_data_->e = _data_->_inner_error0_;
				_data_->_inner_error0_ = NULL;
				_data_->_tmp8_ = folks_backend_get_name (_data_->backend);
				_data_->_tmp9_ = _data_->_tmp8_;
				_data_->_tmp10_ = _data_->e;
				_data_->_tmp11_ = _data_->_tmp10_->message;
				g_warning ("backend-store.vala:460: Error unpreparing Backend '%s': %s", _data_->_tmp9_, _data_->_tmp11_);
				_g_error_free0 (_data_->e);
			}
			__finally0:
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->backend_existing);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp12_ = _data_->self->priv->_prepared_backends;
			_data_->_tmp13_ = _data_->backend_existing;
			_data_->_tmp14_ = folks_backend_get_name (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp13_, FOLKS_TYPE_BACKEND, FolksBackend));
			_data_->_tmp15_ = _data_->_tmp14_;
			gee_abstract_map_unset ((GeeAbstractMap*) _data_->_tmp12_, _data_->_tmp15_, NULL);
			_data_->unloaded = TRUE;
		}
		_g_object_unref0 (_data_->backend_existing);
	}
	_data_->result = _data_->unloaded;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
   * Add a new {@link Backend} to the BackendStore.
   *
   * @param backend the {@link Backend} to add
   */
void
folks_backend_store_add_backend (FolksBackendStore* self,
                                 FolksBackend* backend)
{
	FolksBackend* backend_existing = NULL;
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gpointer _tmp3_;
	gboolean _tmp4_ = FALSE;
	FolksBackend* _tmp5_;
	FolksDebug* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	GeeHashMap* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (backend != NULL);
	_tmp0_ = self->priv->_backend_hash;
	_tmp1_ = folks_backend_get_name (backend);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp2_);
	backend_existing = (FolksBackend*) _tmp3_;
	_tmp5_ = backend_existing;
	if (_tmp5_ != NULL) {
		FolksBackend* _tmp6_;
		_tmp6_ = backend_existing;
		_tmp4_ = _tmp6_ != backend;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		FolksBackend* _tmp7_;
		GeeHashMap* _tmp8_;
		FolksBackend* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		_tmp7_ = backend_existing;
		folks_backend_unprepare (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, FOLKS_TYPE_BACKEND, FolksBackend), NULL, NULL);
		_tmp8_ = self->priv->_prepared_backends;
		_tmp9_ = backend_existing;
		_tmp10_ = folks_backend_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, FOLKS_TYPE_BACKEND, FolksBackend));
		_tmp11_ = _tmp10_;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp8_, _tmp11_, NULL);
	}
	_tmp12_ = self->priv->_debug;
	_tmp13_ = folks_backend_get_name (backend);
	_tmp14_ = _tmp13_;
	_folks_debug_register_domain (_tmp12_, _tmp14_);
	_tmp15_ = self->priv->_backend_hash;
	_tmp16_ = folks_backend_get_name (backend);
	_tmp17_ = _tmp16_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, _tmp17_, backend);
	_g_object_unref0 (backend_existing);
}

static gboolean
_folks_backend_store_backend_is_enabled (FolksBackendStore* self,
                                         const gchar* name)
{
	gboolean all_others_enabled = FALSE;
	gboolean _tmp0_ = FALSE;
	FolksSmallSet* _tmp1_;
	gboolean _tmp3_ = FALSE;
	FolksSmallSet* _tmp4_;
	gboolean enabled = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	all_others_enabled = TRUE;
	_tmp1_ = self->priv->_backends_allowed;
	if (_tmp1_ != NULL) {
		FolksSmallSet* _tmp2_;
		_tmp2_ = self->priv->_backends_allowed;
		_tmp0_ = !gee_abstract_collection_contains ((GeeAbstractCollection*) G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, FOLKS_TYPE_SMALL_SET, FolksSmallSet), name);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp4_ = self->priv->_backends_disabled;
	if (_tmp4_ != NULL) {
		FolksSmallSet* _tmp5_;
		_tmp5_ = self->priv->_backends_disabled;
		_tmp3_ = gee_abstract_collection_contains ((GeeAbstractCollection*) G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, FOLKS_TYPE_SMALL_SET, FolksSmallSet), name);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		result = FALSE;
		return result;
	}
	{
		gboolean _tmp6_ = FALSE;
		GKeyFile* _tmp7_;
		const gchar* _tmp8_;
		_tmp7_ = self->priv->_backends_key_file;
		_tmp8_ = folks_backend_store_KEY_FILE_GROUP_ALL_OTHERS;
		_tmp6_ = g_key_file_get_boolean (_tmp7_, _tmp8_, "enabled", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp9_ = FALSE;
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp9_;
		}
		all_others_enabled = _tmp6_;
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError* e = NULL;
		gboolean _tmp10_ = FALSE;
		GError* _tmp11_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = e;
		if (!g_error_matches (_tmp11_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND)) {
			GError* _tmp12_;
			_tmp12_ = e;
			_tmp10_ = !g_error_matches (_tmp12_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_KEY_NOT_FOUND);
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			const gchar* _tmp13_ = NULL;
			if (all_others_enabled) {
				_tmp13_ = "enabled";
			} else {
				_tmp13_ = "disabled";
			}
			g_warning ("Couldn't determine whether to enable or disable " "backends not listed in backend key file. Defaulting to %s.", _tmp13_);
		} else {
			const gchar* _tmp14_ = NULL;
			if (all_others_enabled) {
				_tmp14_ = "Enabling";
			} else {
				_tmp14_ = "Disabling";
			}
			g_debug ("No catch-all entry in the backend key file. %s " "unlisted backends.", _tmp14_);
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp15_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp15_;
	}
	enabled = TRUE;
	{
		gboolean _tmp16_ = FALSE;
		GKeyFile* _tmp17_;
		_tmp17_ = self->priv->_backends_key_file;
		_tmp16_ = g_key_file_get_boolean (_tmp17_, name, "enabled", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp18_ = FALSE;
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp18_;
		}
		enabled = _tmp16_;
	}
	goto __finally1;
	__catch1_g_key_file_error:
	{
		GError* e = NULL;
		gboolean _tmp19_ = FALSE;
		GError* _tmp20_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp20_ = e;
		if (g_error_matches (_tmp20_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND)) {
			_tmp19_ = TRUE;
		} else {
			GError* _tmp21_;
			_tmp21_ = e;
			_tmp19_ = g_error_matches (_tmp21_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_KEY_NOT_FOUND);
		}
		if (_tmp19_) {
			const gchar* _tmp22_ = NULL;
			const gchar* _tmp23_;
			if (all_others_enabled) {
				_tmp22_ = "Enabling";
			} else {
				_tmp22_ = "Disabling";
			}
			_tmp23_ = folks_backend_store_KEY_FILE_GROUP_ALL_OTHERS;
			g_debug ("Found no entry for backend '%s'.enabled in backend " "keyfile. %s according to '%s' setting.", name, _tmp22_, _tmp23_);
			enabled = all_others_enabled;
		} else {
			gboolean _tmp24_ = FALSE;
			GError* _tmp25_;
			_tmp25_ = e;
			if (!g_error_matches (_tmp25_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND)) {
				GError* _tmp26_;
				_tmp26_ = e;
				_tmp24_ = !g_error_matches (_tmp26_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_KEY_NOT_FOUND);
			} else {
				_tmp24_ = FALSE;
			}
			if (_tmp24_) {
				GError* _tmp27_;
				const gchar* _tmp28_;
				_tmp27_ = e;
				_tmp28_ = _tmp27_->message;
				g_warning ("Couldn't check enabled state of backend '%s': %s\n" "Disabling backend.", name, _tmp28_);
				enabled = FALSE;
			}
		}
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp29_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp29_;
	}
	result = enabled;
	return result;
}

/**
   * Get a backend from the store by name. If a backend is returned, its
   * reference count is increased.
   *
   * @param name the backend name to retrieve
   * @return the backend, or ``null`` if none could be found
   *
   * @since 0.3.5
   */
FolksBackend*
folks_backend_store_dup_backend_by_name (FolksBackendStore* self,
                                         const gchar* name)
{
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	FolksBackend* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->_backend_hash;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, name);
	result = (FolksBackend*) _tmp1_;
	return result;
}

/**
   * List the currently loaded backends.
   *
   * @return a list of the backends currently in the BackendStore
   */
GeeCollection*
folks_backend_store_list_backends (FolksBackendStore* self)
{
	GeeHashMap* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	GeeCollection* _tmp4_;
	GeeCollection* _tmp5_;
	GeeCollection* _tmp6_;
	GeeCollection* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_backend_hash;
	_tmp1_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_collection_get_read_only_view (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp3_);
	result = _tmp6_;
	return result;
}

static void
folks_backend_store_enable_backend_data_free (gpointer _data)
{
	FolksBackendStoreEnableBackendData* _data_;
	_data_ = _data;
	_g_free0 (_data_->name);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendStoreEnableBackendData, _data_);
}

void
folks_backend_store_enable_backend (FolksBackendStore* self,
                                    const gchar* name,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	FolksBackendStoreEnableBackendData* _data_;
	FolksBackendStore* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_data_ = g_slice_new0 (FolksBackendStoreEnableBackendData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_backend_store_enable_backend_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (name);
	_g_free0 (_data_->name);
	_data_->name = _tmp1_;
	folks_backend_store_enable_backend_co (_data_);
}

void
folks_backend_store_enable_backend_finish (FolksBackendStore* self,
                                           GAsyncResult* _res_)
{
	FolksBackendStoreEnableBackendData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/**
   * Enable a backend.
   *
   * Mark a backend as enabled, such that the BackendStore will always attempt
   * to load it when {@link BackendStore.load_backends} is called. This will
   * not load the backend if it's not currently loaded.
   *
   * This method is safe to call multiple times concurrently (e.g. an
   * asynchronous call may begin after a previous asynchronous call for the same
   * backend name has begun and before it has finished).
   *
   * If the backend is disallowed by the FOLKS_BACKENDS_ALLOWED
   * and/or FOLKS_BACKENDS_DISABLED environment variables, this method
   * will store the fact that it should be enabled in future, but will
   * not enable it during this application run.
   *
   * @param name the name of the backend to enable
   * @since 0.3.2
   */
static void
folks_backend_store_enable_backend_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_)
{
	FolksBackendStoreEnableBackendData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_backend_store_enable_backend_co (_data_);
}

static gboolean
folks_backend_store_enable_backend_co (FolksBackendStoreEnableBackendData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_backends_key_file;
	g_key_file_set_boolean (_data_->_tmp0_, _data_->name, "enabled", TRUE);
	_data_->_state_ = 1;
	_folks_backend_store_save_key_file (_data_->self, folks_backend_store_enable_backend_ready, _data_);
	return FALSE;
	_state_1:
	_folks_backend_store_save_key_file_finish (_data_->self, _data_->_res_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
folks_backend_store_disable_backend_data_free (gpointer _data)
{
	FolksBackendStoreDisableBackendData* _data_;
	_data_ = _data;
	_g_free0 (_data_->name);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendStoreDisableBackendData, _data_);
}

void
folks_backend_store_disable_backend (FolksBackendStore* self,
                                     const gchar* name,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	FolksBackendStoreDisableBackendData* _data_;
	FolksBackendStore* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_data_ = g_slice_new0 (FolksBackendStoreDisableBackendData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_backend_store_disable_backend_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (name);
	_g_free0 (_data_->name);
	_data_->name = _tmp1_;
	folks_backend_store_disable_backend_co (_data_);
}

void
folks_backend_store_disable_backend_finish (FolksBackendStore* self,
                                            GAsyncResult* _res_)
{
	FolksBackendStoreDisableBackendData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/**
   * Disable a backend.
   *
   * Mark a backend as disabled, such that it won't be loaded even when the
   * client application is restarted. This will not remove the backend if it's
   * already loaded.
   *
   * This method is safe to call multiple times concurrently (e.g. an
   * asynchronous call may begin after a previous asynchronous call for the same
   * backend name has begun and before it has finished).
   *
   * @param name the name of the backend to disable
   * @since 0.3.2
   */
static void
folks_backend_store_disable_backend_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	FolksBackendStoreDisableBackendData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_backend_store_disable_backend_co (_data_);
}

static gboolean
folks_backend_store_disable_backend_co (FolksBackendStoreDisableBackendData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_backends_key_file;
	g_key_file_set_boolean (_data_->_tmp0_, _data_->name, "enabled", FALSE);
	_data_->_state_ = 1;
	_folks_backend_store_save_key_file (_data_->self, folks_backend_store_disable_backend_ready, _data_);
	return FALSE;
	_state_1:
	_folks_backend_store_save_key_file_finish (_data_->self, _data_->_res_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_folks_backend_store_get_modules_from_dir_data_free (gpointer _data)
{
	FolksBackendStoreGetModulesFromDirData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->dir);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendStoreGetModulesFromDirData, _data_);
}

static void
_folks_backend_store_get_modules_from_dir (FolksBackendStore* self,
                                           GFile* dir,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	FolksBackendStoreGetModulesFromDirData* _data_;
	FolksBackendStore* _tmp0_;
	GFile* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dir != NULL);
	_data_ = g_slice_new0 (FolksBackendStoreGetModulesFromDirData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, _folks_backend_store_get_modules_from_dir_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (dir);
	_g_object_unref0 (_data_->dir);
	_data_->dir = _tmp1_;
	_folks_backend_store_get_modules_from_dir_co (_data_);
}

static GeeHashMap*
_folks_backend_store_get_modules_from_dir_finish (FolksBackendStore* self,
                                                  GAsyncResult* _res_)
{
	GeeHashMap* result;
	FolksBackendStoreGetModulesFromDirData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
_folks_backend_store_get_modules_from_dir_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_)
{
	FolksBackendStoreGetModulesFromDirData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_folks_backend_store_get_modules_from_dir_co (_data_);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gboolean
_folks_backend_store_get_modules_from_dir_co (FolksBackendStoreGetModulesFromDirData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_file_get_path (_data_->dir);
	_data_->_tmp1_ = _data_->_tmp0_;
	g_debug ("backend-store.vala:632: Searching for modules in folder '%s' ..", _data_->_tmp1_);
	_g_free0 (_data_->_tmp1_);
	_data_->_tmp2_ = g_strdup (G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_IS_SYMLINK "," G_FILE_ATTRIBUTE_STANDARD_SYMLINK_TARGET "," G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE);
	_data_->attributes = _data_->_tmp2_;
	{
		_data_->_tmp3_ = _data_->attributes;
		_data_->_state_ = 1;
		g_file_enumerate_children_async (_data_->dir, _data_->_tmp3_, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, NULL, _folks_backend_store_get_modules_from_dir_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp4_ = g_file_enumerate_children_finish (_data_->dir, _data_->_res_, &_data_->_inner_error0_);
		_data_->enumerator = _data_->_tmp4_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp6_ = _data_->enumerator;
		_data_->_state_ = 2;
		g_file_enumerator_next_files_async (_data_->_tmp6_, G_MAXINT, G_PRIORITY_DEFAULT, NULL, _folks_backend_store_get_modules_from_dir_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp7_ = g_file_enumerator_next_files_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp5_ = _data_->_tmp7_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->enumerator);
			goto __catch0_g_error;
		}
		_data_->_tmp8_ = _data_->_tmp5_;
		_data_->_tmp5_ = NULL;
		(_data_->infos == NULL) ? NULL : (_data_->infos = (_g_list_free__g_object_unref0_ (_data_->infos), NULL));
		_data_->infos = _data_->_tmp8_;
		(_data_->_tmp5_ == NULL) ? NULL : (_data_->_tmp5_ = (_g_list_free__g_object_unref0_ (_data_->_tmp5_), NULL));
		_g_object_unref0 (_data_->enumerator);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp9_ = g_file_get_path (_data_->dir);
		_data_->_tmp10_ = _data_->_tmp9_;
		_data_->_tmp11_ = _data_->_error_;
		_data_->_tmp12_ = _data_->_tmp11_->message;
		g_critical (_ ("Error listing contents of folder ‘%s’: %s"), _data_->_tmp10_, _data_->_tmp12_);
		_g_free0 (_data_->_tmp10_);
		_data_->result = NULL;
		_g_error_free0 (_data_->_error_);
		(_data_->infos == NULL) ? NULL : (_data_->infos = (_g_list_free__g_object_unref0_ (_data_->infos), NULL));
		_g_free0 (_data_->attributes);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		(_data_->infos == NULL) ? NULL : (_data_->infos = (_g_list_free__g_object_unref0_ (_data_->infos), NULL));
		_g_free0 (_data_->attributes);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp13_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->modules_final = _data_->_tmp13_;
	_data_->_tmp14_ = g_getenv ("FOLKS_BACKEND_PATH");
	_data_->_tmp15_ = g_strdup (_data_->_tmp14_);
	_data_->_path = _data_->_tmp15_;
	_data_->_tmp16_ = _data_->infos;
	{
		_data_->info_collection = _data_->_tmp16_;
		for (_data_->info_it = _data_->info_collection; _data_->info_it != NULL; _data_->info_it = _data_->info_it->next) {
			_data_->_tmp17_ = _g_object_ref0 ((GFileInfo*) _data_->info_it->data);
			_data_->info = _data_->_tmp17_;
			{
				_data_->_tmp18_ = _data_->info;
				_data_->_tmp19_ = g_file_info_get_name (_data_->_tmp18_);
				_data_->_tmp20_ = g_file_get_child (_data_->dir, _data_->_tmp19_);
				_data_->file = _data_->_tmp20_;
				_data_->_tmp21_ = _data_->info;
				if (g_file_info_get_is_symlink (_data_->_tmp21_)) {
					_data_->_tmp22_ = _data_->file;
					_data_->_tmp23_ = g_file_get_path (_data_->_tmp22_);
					_data_->_tmp24_ = _data_->_tmp23_;
					_data_->_tmp25_ = _data_->info;
					_data_->_tmp26_ = g_file_info_get_symlink_target (_data_->_tmp25_);
					g_debug ("backend-store.vala:680: Handling symlink ‘%s’ to ‘%s’.", _data_->_tmp24_, _data_->_tmp26_);
					_g_free0 (_data_->_tmp24_);
					_data_->_tmp27_ = _data_->file;
					_data_->_tmp28_ = _g_object_ref0 (_data_->_tmp27_);
					_data_->old_file = _data_->_tmp28_;
					_data_->_tmp29_ = _data_->info;
					_data_->_tmp30_ = g_file_info_get_symlink_target (_data_->_tmp29_);
					_data_->_tmp31_ = g_file_resolve_relative_path (_data_->dir, _data_->_tmp30_);
					_g_object_unref0 (_data_->file);
					_data_->file = _data_->_tmp31_;
					{
						_data_->_tmp33_ = _data_->file;
						_data_->_tmp34_ = _data_->attributes;
						_data_->_state_ = 3;
						g_file_query_info_async (_data_->_tmp33_, _data_->_tmp34_, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, NULL, _folks_backend_store_get_modules_from_dir_ready, _data_);
						return FALSE;
						_state_3:
						_data_->_tmp35_ = g_file_query_info_finish (_data_->_tmp33_, _data_->_res_, &_data_->_inner_error0_);
						_data_->_tmp32_ = _data_->_tmp35_;
						if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
							goto __catch1_g_error;
						}
						_data_->_tmp36_ = _data_->_tmp32_;
						_data_->_tmp32_ = NULL;
						_g_object_unref0 (_data_->info);
						_data_->info = _data_->_tmp36_;
						_g_object_unref0 (_data_->_tmp32_);
					}
					goto __finally1;
					__catch1_g_error:
					{
						_data_->_vala1__error_ = _data_->_inner_error0_;
						_data_->_inner_error0_ = NULL;
						_data_->_tmp37_ = _data_->file;
						_data_->_tmp38_ = g_file_get_path (_data_->_tmp37_);
						_data_->_tmp39_ = _data_->_tmp38_;
						_data_->_tmp40_ = _data_->old_file;
						_data_->_tmp41_ = g_file_get_path (_data_->_tmp40_);
						_data_->_tmp42_ = _data_->_tmp41_;
						_data_->_tmp43_ = _data_->_vala1__error_;
						_data_->_tmp44_ = _data_->_tmp43_->message;
						g_warning (_ ("Error querying info for target ‘%s’ of symlink ‘%s’: %s"), _data_->_tmp39_, _data_->_tmp42_, _data_->_tmp44_);
						_g_free0 (_data_->_tmp42_);
						_g_free0 (_data_->_tmp39_);
						_g_error_free0 (_data_->_vala1__error_);
						_g_object_unref0 (_data_->old_file);
						_g_object_unref0 (_data_->file);
						_g_object_unref0 (_data_->info);
						continue;
					}
					__finally1:
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						_g_object_unref0 (_data_->old_file);
						_g_object_unref0 (_data_->file);
						_g_object_unref0 (_data_->info);
						_g_free0 (_data_->_path);
						_g_object_unref0 (_data_->modules_final);
						(_data_->infos == NULL) ? NULL : (_data_->infos = (_g_list_free__g_object_unref0_ (_data_->infos), NULL));
						_g_free0 (_data_->attributes);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
						g_clear_error (&_data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
					_g_object_unref0 (_data_->old_file);
				}
				_data_->_tmp45_ = _data_->info;
				_data_->file_type = g_file_info_get_file_type (_data_->_tmp45_);
				_data_->_tmp46_ = _data_->info;
				_data_->_tmp47_ = g_file_info_get_content_type (_data_->_tmp46_);
				_data_->content_type = _data_->_tmp47_;
				_data_->_tmp48_ = _data_->content_type;
				_data_->_tmp49_ = g_content_type_get_mime_type (_data_->_tmp48_);
				_data_->mime = _data_->_tmp49_;
				if (_data_->file_type == G_FILE_TYPE_DIRECTORY) {
					_data_->_tmp50_ = _data_->file;
					_data_->_state_ = 4;
					_folks_backend_store_get_modules_from_dir (_data_->self, _data_->_tmp50_, _folks_backend_store_get_modules_from_dir_ready, _data_);
					return FALSE;
					_state_4:
					_data_->_tmp51_ = _folks_backend_store_get_modules_from_dir_finish (_data_->self, _data_->_res_);
					_data_->modules = _data_->_tmp51_;
					_data_->_tmp52_ = _data_->modules;
					if (_data_->_tmp52_ != NULL) {
						{
							_data_->_tmp53_ = _data_->modules;
							_data_->_tmp54_ = gee_abstract_map_get_entries ((GeeAbstractMap*) G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp53_, GEE_TYPE_HASH_MAP, GeeHashMap));
							_data_->_tmp55_ = _data_->_tmp54_;
							_data_->_tmp56_ = _data_->_tmp55_;
							_data_->_tmp57_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp56_);
							_data_->_tmp58_ = _data_->_tmp57_;
							_g_object_unref0 (_data_->_tmp56_);
							_data_->_entry_it = _data_->_tmp58_;
							while (TRUE) {
								_data_->_tmp59_ = _data_->_entry_it;
								if (!gee_iterator_next (_data_->_tmp59_)) {
									break;
								}
								_data_->_tmp60_ = _data_->_entry_it;
								_data_->_tmp61_ = gee_iterator_get (_data_->_tmp60_);
								_data_->entry = (GeeMapEntry*) _data_->_tmp61_;
								_data_->_tmp62_ = _data_->modules_final;
								_data_->_tmp63_ = _data_->entry;
								_data_->_tmp64_ = gee_map_entry_get_key (_data_->_tmp63_);
								_data_->_tmp65_ = _data_->_tmp64_;
								_data_->_tmp66_ = _data_->entry;
								_data_->_tmp67_ = gee_map_entry_get_value (_data_->_tmp66_);
								_data_->_tmp68_ = _data_->_tmp67_;
								gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp62_, (const gchar*) _data_->_tmp65_, (GFile*) _data_->_tmp68_);
								_g_object_unref0 (_data_->entry);
							}
							_g_object_unref0 (_data_->_entry_it);
						}
					}
					_g_object_unref0 (_data_->modules);
				} else {
					_data_->_tmp69_ = _data_->mime;
					if (g_strcmp0 (_data_->_tmp69_, "application/x-sharedlib") == 0) {
						_data_->_tmp70_ = _data_->file;
						_data_->_tmp71_ = g_file_get_path (_data_->_tmp70_);
						_data_->path = _data_->_tmp71_;
						_data_->_tmp72_ = _data_->path;
						if (_data_->_tmp72_ != NULL) {
							_data_->_tmp73_ = _data_->modules_final;
							_data_->_tmp74_ = _data_->path;
							_data_->_tmp75_ = _data_->file;
							gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp73_, (const gchar*) _data_->_tmp74_, _data_->_tmp75_);
						}
						_g_free0 (_data_->path);
					} else {
						_data_->_tmp76_ = _data_->mime;
						if (_data_->_tmp76_ == NULL) {
							_data_->_tmp77_ = _data_->file;
							_data_->_tmp78_ = g_file_get_path (_data_->_tmp77_);
							_data_->_tmp79_ = _data_->_tmp78_;
							g_warning ("backend-store.vala:730: The content type of '%s' could not be determin" \
"ed. Have you installed shared-mime-info?", _data_->_tmp79_);
							_g_free0 (_data_->_tmp79_);
						} else {
							_data_->_tmp83_ = _data_->_path;
							if (_data_->_tmp83_ == NULL) {
								_data_->_tmp84_ = _data_->mime;
								_data_->_tmp82_ = g_strcmp0 (_data_->_tmp84_, "application/x-sharedlib") != 0;
							} else {
								_data_->_tmp82_ = FALSE;
							}
							if (_data_->_tmp82_) {
								_data_->_tmp85_ = _data_->mime;
								_data_->_tmp81_ = g_strcmp0 (_data_->_tmp85_, "application/x-shared-library-la") != 0;
							} else {
								_data_->_tmp81_ = FALSE;
							}
							if (_data_->_tmp81_) {
								_data_->_tmp86_ = _data_->mime;
								_data_->_tmp80_ = g_strcmp0 (_data_->_tmp86_, "inode/directory") != 0;
							} else {
								_data_->_tmp80_ = FALSE;
							}
							if (_data_->_tmp80_) {
								_data_->_tmp87_ = _data_->file;
								_data_->_tmp88_ = g_file_get_path (_data_->_tmp87_);
								_data_->_tmp89_ = _data_->_tmp88_;
								_data_->_tmp90_ = _data_->mime;
								g_warning ("backend-store.vala:743: The content type of '%s' appears to be '%s' wh" \
"ich looks suspicious. Have you installed shared-mime-info?", _data_->_tmp89_, _data_->_tmp90_);
								_g_free0 (_data_->_tmp89_);
							}
						}
					}
				}
				_g_free0 (_data_->mime);
				_g_object_unref0 (_data_->file);
				_g_object_unref0 (_data_->info);
			}
		}
	}
	_data_->_tmp91_ = g_file_get_path (_data_->dir);
	_data_->_tmp92_ = _data_->_tmp91_;
	g_debug ("backend-store.vala:747: Finished searching for modules in folder '%s'", _data_->_tmp92_);
	_g_free0 (_data_->_tmp92_);
	_data_->result = _data_->modules_final;
	_g_free0 (_data_->_path);
	(_data_->infos == NULL) ? NULL : (_data_->infos = (_g_list_free__g_object_unref0_ (_data_->infos), NULL));
	_g_free0 (_data_->attributes);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_folks_backend_store_load_module_from_file (FolksBackendStore* self,
                                            GFile* file)
{
	gchar* _file_path = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* file_path = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GeeHashMap* _tmp4_;
	const gchar* _tmp5_;
	GModule* _module = NULL;
	const gchar* _tmp6_;
	GModule* _tmp7_;
	GModule* _tmp8_;
	GModule* module = NULL;
	GModule* _tmp11_;
	void* function = NULL;
	GModule* _tmp12_;
	void* _tmp13_ = NULL;
	gboolean _tmp14_;
	FolksBackendStoreModuleInitFunc module_init = NULL;
	void* _tmp17_;
	FolksBackendStoreModuleInitFunc _tmp18_;
	GeeHashMap* _tmp19_;
	const gchar* _tmp20_;
	GModule* _tmp21_;
	GModule* _tmp22_;
	FolksBackendStoreModuleInitFunc _tmp23_;
	GModule* _tmp24_;
	const gchar* _tmp25_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = g_file_get_path (file);
	_file_path = _tmp0_;
	_tmp1_ = _file_path;
	if (_tmp1_ == NULL) {
		_g_free0 (_file_path);
		return;
	}
	_tmp2_ = _file_path;
	_tmp3_ = g_strdup ((const gchar*) _tmp2_);
	file_path = _tmp3_;
	_tmp4_ = self->priv->_modules;
	_tmp5_ = file_path;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp4_, _tmp5_)) {
		_g_free0 (file_path);
		_g_free0 (_file_path);
		return;
	}
	_tmp6_ = file_path;
	_tmp7_ = g_module_open (_tmp6_, G_MODULE_BIND_LOCAL);
	_module = _tmp7_;
	_tmp8_ = _module;
	if (_tmp8_ == NULL) {
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp9_ = file_path;
		_tmp10_ = g_module_error ();
		g_warning ("backend-store.vala:768: Failed to load module from path '%s': %s", _tmp9_, _tmp10_);
		_g_module_close0 (_module);
		_g_free0 (file_path);
		_g_free0 (_file_path);
		return;
	}
	_tmp11_ = _module;
	module = (GModule*) _tmp11_;
	_tmp12_ = module;
	_tmp14_ = g_module_symbol (_tmp12_, "module_init", &_tmp13_);
	function = _tmp13_;
	if (!_tmp14_) {
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp15_ = file_path;
		_tmp16_ = g_module_error ();
		g_warning ("backend-store.vala:782: Failed to find entry point function '%s' in '%" \
"s': %s", "module_init", _tmp15_, _tmp16_);
		_g_module_close0 (_module);
		_g_free0 (file_path);
		_g_free0 (_file_path);
		return;
	}
	_tmp17_ = function;
	module_init = (FolksBackendStoreModuleInitFunc) _tmp17_;
	_tmp18_ = module_init;
	_vala_assert (_tmp18_ != NULL, "module_init != null");
	_tmp19_ = self->priv->_modules;
	_tmp20_ = file_path;
	_tmp21_ = module;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp19_, _tmp20_, _tmp21_);
	_tmp22_ = module;
	g_module_make_resident (_tmp22_);
	_tmp23_ = module_init;
	_tmp23_ (self);
	_tmp24_ = module;
	_tmp25_ = g_module_name (_tmp24_);
	g_debug ("backend-store.vala:800: Loaded module source: '%s'", _tmp25_);
	_g_module_close0 (_module);
	_g_free0 (file_path);
	_g_free0 (_file_path);
}

static void
_folks_backend_store_get_file_info_data_free (gpointer _data)
{
	FolksBackendStoreGetFileInfoData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->file);
	g_slice_free (FolksBackendStoreGetFileInfoData, _data_);
}

static void
_folks_backend_store_get_file_info (GFile* file,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	FolksBackendStoreGetFileInfoData* _data_;
	GFile* _tmp0_;
	g_return_if_fail (file != NULL);
	_data_ = g_slice_new0 (FolksBackendStoreGetFileInfoData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, _folks_backend_store_get_file_info_data_free);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp0_;
	_folks_backend_store_get_file_info_co (_data_);
}

static void
_folks_backend_store_get_file_info_finish (GAsyncResult* _res_,
                                           gboolean* is_file,
                                           gboolean* is_dir)
{
	FolksBackendStoreGetFileInfoData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (is_file) {
		*is_file = _data_->is_file;
	}
	if (is_dir) {
		*is_dir = _data_->is_dir;
	}
}

static void
_folks_backend_store_get_file_info_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_)
{
	FolksBackendStoreGetFileInfoData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_folks_backend_store_get_file_info_co (_data_);
}

static gboolean
_folks_backend_store_get_file_info_co (FolksBackendStoreGetFileInfoData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->is_file = FALSE;
	_data_->is_dir = FALSE;
	{
		_data_->_state_ = 1;
		g_file_query_info_async (_data_->file, G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, NULL, _folks_backend_store_get_file_info_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = g_file_query_info_finish (_data_->file, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp2_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->file_info);
		_data_->file_info = _data_->_tmp2_;
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp3_ = _data_->_error_;
		if (g_error_matches (_data_->_tmp3_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
			_data_->_tmp4_ = g_file_get_path (_data_->file);
			_data_->_tmp5_ = _data_->_tmp4_;
			g_critical (_ ("File or directory ‘%s’ does not exist."), _data_->_tmp5_);
			_g_free0 (_data_->_tmp5_);
		} else {
			_data_->_tmp6_ = g_file_get_path (_data_->file);
			_data_->_tmp7_ = _data_->_tmp6_;
			g_critical (_ ("Failed to get content type for ‘%s’."), _data_->_tmp7_);
			_g_free0 (_data_->_tmp7_);
		}
		_g_error_free0 (_data_->_error_);
		_g_object_unref0 (_data_->file_info);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->file_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp8_ = _data_->file_info;
	_data_->is_file = g_file_info_get_file_type (_data_->_tmp8_) == G_FILE_TYPE_REGULAR;
	_data_->_tmp9_ = _data_->file_info;
	_data_->is_dir = g_file_info_get_file_type (_data_->_tmp9_) == G_FILE_TYPE_DIRECTORY;
	_g_object_unref0 (_data_->file_info);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_folks_backend_store_load_disabled_backend_names_data_free (gpointer _data)
{
	FolksBackendStoreLoadDisabledBackendNamesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendStoreLoadDisabledBackendNamesData, _data_);
}

static void
_folks_backend_store_load_disabled_backend_names (FolksBackendStore* self,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	FolksBackendStoreLoadDisabledBackendNamesData* _data_;
	FolksBackendStore* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (FolksBackendStoreLoadDisabledBackendNamesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, _folks_backend_store_load_disabled_backend_names_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_folks_backend_store_load_disabled_backend_names_co (_data_);
}

static void
_folks_backend_store_load_disabled_backend_names_finish (FolksBackendStore* self,
                                                         GAsyncResult* _res_)
{
	FolksBackendStoreLoadDisabledBackendNamesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
_folks_backend_store_load_disabled_backend_names_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_)
{
	FolksBackendStoreLoadDisabledBackendNamesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_folks_backend_store_load_disabled_backend_names_co (_data_);
}

static gboolean
_folks_backend_store_load_disabled_backend_names_co (FolksBackendStoreLoadDisabledBackendNamesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_getenv ("FOLKS_BACKENDS_ALLOWED");
	_data_->_tmp1_ = g_strdup (_data_->_tmp0_);
	_data_->envvar = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->envvar;
	if (_data_->_tmp2_ != NULL) {
		_data_->_tmp3_ = _data_->envvar;
		_data_->_tmp5_ = _data_->_tmp4_ = g_strsplit_set (_data_->_tmp3_, " ,:", 0);
		_data_->tokens = _data_->_tmp5_;
		_data_->tokens_length1 = _vala_array_length (_data_->_tmp4_);
		_data_->_tokens_size_ = _data_->tokens_length1;
		_data_->_tmp6_ = folks_small_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (_data_->self->priv->_backends_allowed);
		_data_->self->priv->_backends_allowed = _data_->_tmp6_;
		_data_->_tmp7_ = _data_->tokens;
		_data_->_tmp7__length1 = _data_->tokens_length1;
		{
			_data_->s_collection_length1 = 0;
			_data_->_s_collection_size_ = 0;
			_data_->s_collection = _data_->_tmp7_;
			_data_->s_collection_length1 = _data_->_tmp7__length1;
			for (_data_->s_it = 0; _data_->s_it < _data_->s_collection_length1; _data_->s_it = _data_->s_it + 1) {
				_data_->s = _data_->s_collection[_data_->s_it];
				{
					_data_->_tmp8_ = _data_->s;
					if (g_strcmp0 (_data_->_tmp8_, "all") == 0) {
						_g_object_unref0 (_data_->self->priv->_backends_allowed);
						_data_->self->priv->_backends_allowed = NULL;
						break;
					}
					_data_->_tmp9_ = _data_->s;
					if (g_strcmp0 (_data_->_tmp9_, "") != 0) {
						_data_->_tmp10_ = _data_->self->priv->_backends_allowed;
						_data_->_tmp11_ = _data_->s;
						gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp10_, _data_->_tmp11_);
					}
				}
			}
		}
		_data_->_tmp12_ = _data_->self->priv->_backends_allowed;
		if (_data_->_tmp12_ != NULL) {
			g_debug ("backend-store.vala:875: Backends limited by FOLKS_BACKENDS_ALLOWED:");
			_data_->_tmp13_ = _data_->tokens;
			_data_->_tmp13__length1 = _data_->tokens_length1;
			{
				_data_->_vala1_s_collection_length1 = 0;
				_data_->__vala1_s_collection_size_ = 0;
				_data_->_vala1_s_collection = _data_->_tmp13_;
				_data_->_vala1_s_collection_length1 = _data_->_tmp13__length1;
				for (_data_->_vala1_s_it = 0; _data_->_vala1_s_it < _data_->_vala1_s_collection_length1; _data_->_vala1_s_it = _data_->_vala1_s_it + 1) {
					_data_->_vala1_s = _data_->_vala1_s_collection[_data_->_vala1_s_it];
					{
						_data_->_tmp14_ = _data_->_vala1_s;
						g_debug ("backend-store.vala:878: Backend '%s' is allowed", _data_->_tmp14_);
					}
				}
			}
			g_debug ("backend-store.vala:880: All other backends disabled by FOLKS_BACKENDS_" \
"ALLOWED");
		}
		_data_->tokens = (_vala_array_free (_data_->tokens, _data_->tokens_length1, (GDestroyNotify) g_free), NULL);
	}
	_data_->_tmp15_ = g_getenv ("FOLKS_BACKENDS_DISABLED");
	_data_->_tmp16_ = g_strdup (_data_->_tmp15_);
	_g_free0 (_data_->envvar);
	_data_->envvar = _data_->_tmp16_;
	_data_->_tmp17_ = _data_->envvar;
	if (_data_->_tmp17_ != NULL) {
		_data_->_tmp18_ = _data_->envvar;
		_data_->_tmp20_ = _data_->_tmp19_ = g_strsplit_set (_data_->_tmp18_, " ,:", 0);
		_data_->_vala1_tokens = _data_->_tmp20_;
		_data_->_vala1_tokens_length1 = _vala_array_length (_data_->_tmp19_);
		_data_->__vala1_tokens_size_ = _data_->_vala1_tokens_length1;
		_data_->_tmp21_ = folks_small_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (_data_->self->priv->_backends_disabled);
		_data_->self->priv->_backends_disabled = _data_->_tmp21_;
		_data_->_tmp22_ = _data_->_vala1_tokens;
		_data_->_tmp22__length1 = _data_->_vala1_tokens_length1;
		{
			_data_->_vala2_s_collection_length1 = 0;
			_data_->__vala2_s_collection_size_ = 0;
			_data_->_vala2_s_collection = _data_->_tmp22_;
			_data_->_vala2_s_collection_length1 = _data_->_tmp22__length1;
			for (_data_->_vala2_s_it = 0; _data_->_vala2_s_it < _data_->_vala2_s_collection_length1; _data_->_vala2_s_it = _data_->_vala2_s_it + 1) {
				_data_->_vala2_s = _data_->_vala2_s_collection[_data_->_vala2_s_it];
				{
					_data_->_tmp23_ = _data_->_vala2_s;
					if (g_strcmp0 (_data_->_tmp23_, "") != 0) {
						_data_->_tmp24_ = _data_->_vala2_s;
						g_debug ("backend-store.vala:898: Backend '%s' disabled by FOLKS_BACKENDS_DISABL" \
"ED", _data_->_tmp24_);
						_data_->_tmp25_ = _data_->self->priv->_backends_disabled;
						_data_->_tmp26_ = _data_->_vala2_s;
						gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp25_, _data_->_tmp26_);
					}
				}
			}
		}
		_data_->_vala1_tokens = (_vala_array_free (_data_->_vala1_tokens, _data_->_vala1_tokens_length1, (GDestroyNotify) g_free), NULL);
	}
	_data_->_tmp27_ = g_getenv ("FOLKS_BACKEND_STORE_KEY_FILE_PATH");
	_data_->path = _data_->_tmp27_;
	_data_->_tmp28_ = _data_->path;
	if (_data_->_tmp28_ == NULL) {
		_data_->_tmp29_ = g_get_user_data_dir ();
		_data_->_tmp30_ = g_file_new_for_path (_data_->_tmp29_);
		_g_object_unref0 (_data_->file);
		_data_->file = _data_->_tmp30_;
		_data_->_tmp31_ = _data_->file;
		_data_->_tmp32_ = g_file_get_child (_data_->_tmp31_, "folks");
		_g_object_unref0 (_data_->file);
		_data_->file = _data_->_tmp32_;
		_data_->_tmp33_ = _data_->file;
		_data_->_tmp34_ = g_file_get_child (_data_->_tmp33_, "backends.ini");
		_g_object_unref0 (_data_->file);
		_data_->file = _data_->_tmp34_;
		_data_->_tmp35_ = _data_->file;
		_data_->_tmp36_ = g_file_get_path (_data_->_tmp35_);
		_data_->_tmp37_ = _data_->_tmp36_;
		g_debug ("Using built-in backends key file '%s' (override with " "environment variable FOLKS_BACKEND_STORE_KEY_FILE_PATH)", _data_->_tmp37_);
		_g_free0 (_data_->_tmp37_);
	} else {
		_data_->_tmp38_ = _data_->path;
		_data_->_tmp39_ = g_file_new_for_path ((const gchar*) _data_->_tmp38_);
		_g_object_unref0 (_data_->file);
		_data_->file = _data_->_tmp39_;
		_data_->_tmp40_ = _data_->path;
		g_debug ("Using environment variable " "FOLKS_BACKEND_STORE_KEY_FILE_PATH = '%s' to load the backends " "key file.", (const gchar*) _data_->_tmp40_);
	}
	_data_->_tmp41_ = _data_->file;
	_data_->_tmp42_ = _g_object_ref0 (_data_->_tmp41_);
	_g_object_unref0 (_data_->self->priv->_config_file);
	_data_->self->priv->_config_file = _data_->_tmp42_;
	_data_->_tmp43_ = g_key_file_new ();
	_data_->key_file = _data_->_tmp43_;
	{
		_data_->contents_length1 = 0;
		_data_->_contents_size_ = 0;
		_data_->_tmp44_ = _data_->file;
		_data_->_tmp45_ = NULL;
		_data_->_tmp46_ = 0;
		_data_->_state_ = 1;
		g_file_load_contents_async (_data_->_tmp44_, NULL, _folks_backend_store_load_disabled_backend_names_ready, _data_);
		return FALSE;
		_state_1:
		g_file_load_contents_finish (_data_->_tmp44_, _data_->_res_, &_data_->_tmp45_, &_data_->_tmp46_, NULL, &_data_->_inner_error0_);
		_data_->contents = (g_free (_data_->contents), NULL);
		_data_->contents = _data_->_tmp45_;
		_data_->contents_length1 = _data_->_tmp46_;
		_data_->_contents_size_ = _data_->contents_length1;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_data_->contents = (g_free (_data_->contents), NULL);
			goto __catch0_g_error;
		}
		_data_->_tmp47_ = _data_->contents;
		_data_->_tmp47__length1 = _data_->contents_length1;
		_data_->contents_s = (const gchar*) _data_->_tmp47_;
		_data_->_tmp48_ = _data_->contents_s;
		_data_->_tmp49_ = strlen (_data_->_tmp48_);
		_data_->_tmp50_ = _data_->_tmp49_;
		if (_data_->_tmp50_ > 0) {
			_data_->_tmp51_ = _data_->key_file;
			_data_->_tmp52_ = _data_->contents_s;
			_data_->_tmp53_ = _data_->contents_s;
			_data_->_tmp54_ = strlen (_data_->_tmp53_);
			_data_->_tmp55_ = _data_->_tmp54_;
			g_key_file_load_from_data (_data_->_tmp51_, _data_->_tmp52_, (gsize) _data_->_tmp55_, G_KEY_FILE_KEEP_COMMENTS, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_data_->contents = (g_free (_data_->contents), NULL);
				goto __catch0_g_error;
			}
		}
		_data_->contents = (g_free (_data_->contents), NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e1 = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp56_ = _data_->e1;
		if (!g_error_matches (_data_->_tmp56_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
			_data_->_tmp57_ = _data_->file;
			_data_->_tmp58_ = g_file_get_path (_data_->_tmp57_);
			_data_->_tmp59_ = _data_->_tmp58_;
			_data_->_tmp60_ = _data_->e1;
			_data_->_tmp61_ = _data_->_tmp60_->message;
			g_warning ("backend-store.vala:946: The backends key file '%s' could not be loaded" \
": %s", _data_->_tmp59_, _data_->_tmp61_);
			_g_free0 (_data_->_tmp59_);
			_g_error_free0 (_data_->e1);
			{
				_data_->_tmp62_ = _data_->key_file;
				_data_->key_file = NULL;
				_g_key_file_unref0 (_data_->self->priv->_backends_key_file);
				_data_->self->priv->_backends_key_file = _data_->_tmp62_;
			}
			_g_key_file_unref0 (_data_->key_file);
			_g_object_unref0 (_data_->file);
			_g_free0 (_data_->envvar);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_error_free0 (_data_->e1);
	}
	__finally0:
	{
		_data_->_tmp63_ = _data_->key_file;
		_data_->key_file = NULL;
		_g_key_file_unref0 (_data_->self->priv->_backends_key_file);
		_data_->self->priv->_backends_key_file = _data_->_tmp63_;
	}
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_key_file_unref0 (_data_->key_file);
		_g_object_unref0 (_data_->file);
		_g_free0 (_data_->envvar);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_key_file_unref0 (_data_->key_file);
	_g_object_unref0 (_data_->file);
	_g_free0 (_data_->envvar);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_folks_backend_store_save_key_file_data_free (gpointer _data)
{
	FolksBackendStoreSaveKeyFileData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendStoreSaveKeyFileData, _data_);
}

static void
_folks_backend_store_save_key_file (FolksBackendStore* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	FolksBackendStoreSaveKeyFileData* _data_;
	FolksBackendStore* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (FolksBackendStoreSaveKeyFileData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, _folks_backend_store_save_key_file_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_folks_backend_store_save_key_file_co (_data_);
}

static void
_folks_backend_store_save_key_file_finish (FolksBackendStore* self,
                                           GAsyncResult* _res_)
{
	FolksBackendStoreSaveKeyFileData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static void
_folks_backend_store_save_key_file_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_)
{
	FolksBackendStoreSaveKeyFileData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_folks_backend_store_save_key_file_co (_data_);
}

static gboolean
_folks_backend_store_save_key_file_co (FolksBackendStoreSaveKeyFileData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_backends_key_file;
	_data_->_tmp1_ = g_key_file_to_data (_data_->_tmp0_, NULL, NULL);
	_data_->key_file_data = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->self->priv->_config_file;
	_data_->_tmp3_ = g_file_get_path (_data_->_tmp2_);
	_data_->_tmp4_ = _data_->_tmp3_;
	g_debug ("backend-store.vala:964: Saving backend key file '%s'.", _data_->_tmp4_);
	_g_free0 (_data_->_tmp4_);
	{
		_data_->_tmp5_ = _data_->self->priv->_config_file;
		_data_->_tmp7_ = 0;
		_data_->_tmp6_ = string_get_data (_data_->key_file_data, &_data_->_tmp7_);
		_data_->_tmp6__length1 = _data_->_tmp7_;
		_data_->_tmp8_ = _data_->_tmp6_;
		_data_->_tmp8__length1 = _data_->_tmp6__length1;
		_data_->_state_ = 1;
		g_file_replace_contents_async (_data_->_tmp5_, (const char*) _data_->_tmp8_, (gsize) _data_->_tmp8__length1, NULL, FALSE, G_FILE_CREATE_PRIVATE, NULL, _folks_backend_store_save_key_file_ready, _data_);
		return FALSE;
		_state_1:
		g_file_replace_contents_finish (_data_->_tmp5_, _data_->_res_, NULL, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp9_ = _data_->self->priv->_config_file;
		_data_->_tmp10_ = g_file_get_path (_data_->_tmp9_);
		_data_->_tmp11_ = _data_->_tmp10_;
		_data_->_tmp12_ = _data_->e;
		_data_->_tmp13_ = _data_->_tmp12_->message;
		g_warning ("backend-store.vala:981: Could not write updated backend key file '%s':" \
" %s", _data_->_tmp11_, _data_->_tmp13_);
		_g_free0 (_data_->_tmp11_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_free0 (_data_->key_file_data);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_free0 (_data_->key_file_data);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

GeeMap*
folks_backend_store_get_enabled_backends (FolksBackendStore* self)
{
	GeeMap* result;
	GeeMap* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_prepared_backends_ro;
	result = _tmp0_;
	return result;
}

static void
folks_backend_store_set_enabled_backends (FolksBackendStore* self,
                                          GeeMap* value)
{
	g_return_if_fail (self != NULL);
	g_object_notify_by_pspec ((GObject *) self, folks_backend_store_properties[FOLKS_BACKEND_STORE_ENABLED_BACKENDS_PROPERTY]);
}

gboolean
folks_backend_store_get_is_prepared (FolksBackendStore* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_prepared;
	return result;
}

static void
folks_backend_store_set_is_prepared (FolksBackendStore* self,
                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	g_object_notify_by_pspec ((GObject *) self, folks_backend_store_properties[FOLKS_BACKEND_STORE_IS_PREPARED_PROPERTY]);
}

static GObject *
folks_backend_store_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FolksBackendStore * self;
	gchar* debug_no_colour = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* debug_no_color = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_;
	const gchar* _tmp11_;
	FolksDebug* _tmp12_;
	FolksDebug* _tmp13_;
	FolksDebug* _tmp14_;
	GeeHashMap* _tmp15_;
	GeeHashMap* _tmp16_;
	GeeHashMap* _tmp17_;
	GeeHashMap* _tmp18_;
	GeeMap* _tmp19_;
	GeeMap* _tmp20_;
	parent_class = G_OBJECT_CLASS (folks_backend_store_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_BACKEND_STORE, FolksBackendStore);
	_tmp0_ = g_getenv ("FOLKS_DEBUG_NO_COLOUR");
	_tmp1_ = g_strdup (_tmp0_);
	debug_no_colour = _tmp1_;
	_tmp2_ = g_getenv ("FOLKS_DEBUG_NO_COLOR");
	_tmp3_ = g_strdup (_tmp2_);
	debug_no_color = _tmp3_;
	_tmp6_ = debug_no_colour;
	if (_tmp6_ == NULL) {
		_tmp5_ = TRUE;
	} else {
		const gchar* _tmp7_;
		_tmp7_ = debug_no_colour;
		_tmp5_ = g_strcmp0 (_tmp7_, "0") == 0;
	}
	if (_tmp5_) {
		gboolean _tmp8_ = FALSE;
		const gchar* _tmp9_;
		_tmp9_ = debug_no_color;
		if (_tmp9_ == NULL) {
			_tmp8_ = TRUE;
		} else {
			const gchar* _tmp10_;
			_tmp10_ = debug_no_color;
			_tmp8_ = g_strcmp0 (_tmp10_, "0") == 0;
		}
		_tmp4_ = _tmp8_;
	} else {
		_tmp4_ = FALSE;
	}
	_tmp11_ = g_getenv ("G_MESSAGES_DEBUG");
	_tmp12_ = folks_debug_dup_with_flags (_tmp11_, _tmp4_);
	_g_object_unref0 (self->priv->_debug);
	self->priv->_debug = _tmp12_;
	_tmp13_ = self->priv->_debug;
	_folks_debug_register_domain (_tmp13_, G_LOG_DOMAIN);
	_tmp14_ = self->priv->_debug;
	g_signal_connect_object (_tmp14_, "print-status", (GCallback) __folks_backend_store_debug_print_status_folks_debug_print_status, self, 0);
	_tmp15_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_POINTER, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_modules);
	self->priv->_modules = _tmp15_;
	_tmp16_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, FOLKS_TYPE_BACKEND, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_backend_hash);
	self->priv->_backend_hash = _tmp16_;
	_tmp17_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, FOLKS_TYPE_BACKEND, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_prepared_backends);
	self->priv->_prepared_backends = _tmp17_;
	_tmp18_ = self->priv->_prepared_backends;
	_tmp19_ = gee_abstract_map_get_read_only_view ((GeeAbstractMap*) _tmp18_);
	_tmp20_ = _tmp19_;
	_g_object_unref0 (self->priv->_prepared_backends_ro);
	self->priv->_prepared_backends_ro = _tmp20_;
	_g_free0 (debug_no_color);
	_g_free0 (debug_no_colour);
	return obj;
}

static void
folks_backend_store_class_init (FolksBackendStoreClass * klass,
                                gpointer klass_data)
{
	gchar* _tmp0_;
	folks_backend_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FolksBackendStore_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_backend_store_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_backend_store_set_property;
	G_OBJECT_CLASS (klass)->constructor = folks_backend_store_constructor;
	G_OBJECT_CLASS (klass)->finalize = folks_backend_store_finalize;
	/**
	   * The list of backends visible to this store which have not been explicitly
	   * disabled.
	   *
	   * This list will be empty before {@link BackendStore.load_backends} has been
	   * called.
	   *
	   * The backends in this list have been prepared and are ready to use.
	   *
	   * @since 0.5.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKEND_STORE_ENABLED_BACKENDS_PROPERTY, folks_backend_store_properties[FOLKS_BACKEND_STORE_ENABLED_BACKENDS_PROPERTY] = g_param_spec_object ("enabled-backends", "enabled-backends", "enabled-backends", GEE_TYPE_MAP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * Whether {@link BackendStore.prepare} has successfully completed for this
	   * store.
	   *
	   * @since 0.3.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKEND_STORE_IS_PREPARED_PROPERTY, folks_backend_store_properties[FOLKS_BACKEND_STORE_IS_PREPARED_PROPERTY] = g_param_spec_boolean ("is-prepared", "is-prepared", "is-prepared", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * Emitted when a backend has been added to the BackendStore.
	   *
	   * This will not be emitted until after {@link BackendStore.load_backends}
	   * has been called.
	   *
	   * {@link Backend}s referenced in this signal are also included in
	   * {@link BackendStore.enabled_backends}.
	   *
	   * @param backend the new {@link Backend}
	   */
	folks_backend_store_signals[FOLKS_BACKEND_STORE_BACKEND_AVAILABLE_SIGNAL] = g_signal_new ("backend-available", FOLKS_TYPE_BACKEND_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, FOLKS_TYPE_BACKEND);
	_tmp0_ = g_strdup ("all-others");
	folks_backend_store_KEY_FILE_GROUP_ALL_OTHERS = _tmp0_;
}

static void
folks_backend_store_instance_init (FolksBackendStore * self,
                                   gpointer klass)
{
	self->priv = folks_backend_store_get_instance_private (self);
	self->priv->_is_prepared = FALSE;
}

static void
folks_backend_store_finalize (GObject * obj)
{
	FolksBackendStore * self;
	GeeMapIterator* iter = NULL;
	GeeHashMap* _tmp0_;
	GeeMapIterator* _tmp1_;
	GeeHashMap* _tmp6_;
	GeeHashMap* _tmp21_;
	FolksDebug* _tmp22_;
	guint _tmp23_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_BACKEND_STORE, FolksBackendStore);
	_tmp0_ = self->priv->_prepared_backends;
	_tmp1_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp0_);
	iter = _tmp1_;
	while (TRUE) {
		GeeMapIterator* _tmp2_;
		FolksBackend* backend = NULL;
		GeeMapIterator* _tmp3_;
		gpointer _tmp4_;
		FolksBackend* _tmp5_;
		_tmp2_ = iter;
		if (!(gee_map_iterator_next (_tmp2_) == TRUE)) {
			break;
		}
		_tmp3_ = iter;
		_tmp4_ = gee_map_iterator_get_value (_tmp3_);
		backend = (FolksBackend*) _tmp4_;
		_tmp5_ = backend;
		folks_backend_unprepare (_tmp5_, NULL, NULL);
		_g_object_unref0 (backend);
	}
	_tmp6_ = self->priv->_prepared_backends;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp6_);
	{
		GeeIterator* _module_it = NULL;
		GeeHashMap* _tmp7_;
		GeeCollection* _tmp8_;
		GeeCollection* _tmp9_;
		GeeCollection* _tmp10_;
		GeeIterator* _tmp11_;
		GeeIterator* _tmp12_;
		_tmp7_ = self->priv->_modules;
		_tmp8_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_;
		_tmp11_ = gee_iterable_iterator ((GeeIterable*) _tmp10_);
		_tmp12_ = _tmp11_;
		_g_object_unref0 (_tmp10_);
		_module_it = _tmp12_;
		while (TRUE) {
			GeeIterator* _tmp13_;
			GModule* module = NULL;
			GeeIterator* _tmp14_;
			gpointer _tmp15_;
			void* func = NULL;
			GModule* _tmp16_;
			void* _tmp17_ = NULL;
			gboolean _tmp18_;
			_tmp13_ = _module_it;
			if (!gee_iterator_next (_tmp13_)) {
				break;
			}
			_tmp14_ = _module_it;
			_tmp15_ = gee_iterator_get (_tmp14_);
			module = (GModule*) _tmp15_;
			_tmp16_ = module;
			_tmp18_ = g_module_symbol (_tmp16_, "module_finalize", &_tmp17_);
			func = _tmp17_;
			if (_tmp18_) {
				FolksBackendStoreModuleFinalizeFunc module_finalize = NULL;
				void* _tmp19_;
				FolksBackendStoreModuleFinalizeFunc _tmp20_;
				_tmp19_ = func;
				module_finalize = (FolksBackendStoreModuleFinalizeFunc) _tmp19_;
				_tmp20_ = module_finalize;
				_tmp20_ (self);
			}
		}
		_g_object_unref0 (_module_it);
	}
	_tmp21_ = self->priv->_modules;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp21_);
	_tmp22_ = self->priv->_debug;
	g_signal_parse_name ("print-status", FOLKS_TYPE_DEBUG, &_tmp23_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp22_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp23_, 0, NULL, (GCallback) __folks_backend_store_debug_print_status_folks_debug_print_status, self);
	folks_backend_store__instance = NULL;
	_g_object_unref0 (iter);
	_g_object_unref0 (self->priv->_backend_hash);
	_g_object_unref0 (self->priv->_backends_allowed);
	_g_object_unref0 (self->priv->_backends_disabled);
	_g_object_unref0 (self->priv->_prepared_backends);
	_g_object_unref0 (self->priv->_prepared_backends_ro);
	_g_object_unref0 (self->priv->_config_file);
	_g_key_file_unref0 (self->priv->_backends_key_file);
	_g_object_unref0 (self->priv->_modules);
	_g_object_unref0 (self->priv->_debug);
	G_OBJECT_CLASS (folks_backend_store_parent_class)->finalize (obj);
}

/**
 * Responsible for backend loading.
 *
 * The BackendStore manages the set of available Folks backends. The
 * {@link BackendStore.load_backends} function loads all compatible and enabled
 * backends and the {@link BackendStore.backend_available} signal notifies when
 * these backends are ready.
 */
static GType
folks_backend_store_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksBackendStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_backend_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksBackendStore), 0, (GInstanceInitFunc) folks_backend_store_instance_init, NULL };
	GType folks_backend_store_type_id;
	folks_backend_store_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksBackendStore", &g_define_type_info, 0);
	FolksBackendStore_private_offset = g_type_add_instance_private (folks_backend_store_type_id, sizeof (FolksBackendStorePrivate));
	return folks_backend_store_type_id;
}

GType
folks_backend_store_get_type (void)
{
	static volatile gsize folks_backend_store_type_id__once = 0;
	if (g_once_init_enter (&folks_backend_store_type_id__once)) {
		GType folks_backend_store_type_id;
		folks_backend_store_type_id = folks_backend_store_get_type_once ();
		g_once_init_leave (&folks_backend_store_type_id__once, folks_backend_store_type_id);
	}
	return folks_backend_store_type_id__once;
}

static void
_vala_folks_backend_store_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	FolksBackendStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_BACKEND_STORE, FolksBackendStore);
	switch (property_id) {
		case FOLKS_BACKEND_STORE_ENABLED_BACKENDS_PROPERTY:
		g_value_set_object (value, folks_backend_store_get_enabled_backends (self));
		break;
		case FOLKS_BACKEND_STORE_IS_PREPARED_PROPERTY:
		g_value_set_boolean (value, folks_backend_store_get_is_prepared (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_folks_backend_store_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	FolksBackendStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_BACKEND_STORE, FolksBackendStore);
	switch (property_id) {
		case FOLKS_BACKEND_STORE_ENABLED_BACKENDS_PROPERTY:
		folks_backend_store_set_enabled_backends (self, g_value_get_object (value));
		break;
		case FOLKS_BACKEND_STORE_IS_PREPARED_PROPERTY:
		folks_backend_store_set_is_prepared (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

