/* email-details.c generated by valac 0.56.18, the Vala compiler
 * generated from email-details.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 * Copyright (C) 2011 Philip Withnall
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Marco Barisione <marco.barisione@collabora.co.uk>
 *       Philip Withnall <philip@tecnocode.co.uk>
 */

#include "folks/folks.h"
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	FOLKS_EMAIL_FIELD_DETAILS_0_PROPERTY,
	FOLKS_EMAIL_FIELD_DETAILS_NUM_PROPERTIES
};
static GParamSpec* folks_email_field_details_properties[FOLKS_EMAIL_FIELD_DETAILS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _FolksEmailDetailsChangeEmailAddressesData FolksEmailDetailsChangeEmailAddressesData;

struct _FolksEmailDetailsChangeEmailAddressesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksEmailDetails* self;
	GeeSet* email_addresses;
	GError* _tmp0_;
	GError* _inner_error0_;
};

static gpointer folks_email_field_details_parent_class = NULL;

static gboolean folks_email_field_details_real_equal (FolksAbstractFieldDetails* base,
                                               FolksAbstractFieldDetails* that);
static guint folks_email_field_details_real_hash (FolksAbstractFieldDetails* base);
static GType folks_email_field_details_get_type_once (void);
static void folks_email_details_real_change_email_addresses_data_free (gpointer _data);
static void folks_email_details_real_change_email_addresses (FolksEmailDetails* self,
                                                      GeeSet* email_addresses,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_);
static gboolean folks_email_details_real_change_email_addresses_co (FolksEmailDetailsChangeEmailAddressesData* _data_);
static GType folks_email_details_get_type_once (void);

/**
   * Create a new EmailFieldDetails.
   *
   * @param value the value of the field, which should be a valid, non-empty
   * e-mail address
   * @param parameters initial parameters. See
   * {@link AbstractFieldDetails.parameters}. A ``null`` value is equivalent to
   * an empty map of parameters.
   *
   * @return a new EmailFieldDetails
   *
   * @since 0.6.0
   */
FolksEmailFieldDetails*
folks_email_field_details_construct (GType object_type,
                                     const gchar* value,
                                     GeeMultiMap* parameters)
{
	FolksEmailFieldDetails * self = NULL;
	g_return_val_if_fail (value != NULL, NULL);
	self = (FolksEmailFieldDetails*) folks_abstract_field_details_construct (object_type, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free);
	if (g_strcmp0 (value, "") == 0) {
		g_warning ("email-details.vala:55: Empty e-mail address passed to EmailFieldDetail" \
"s.");
	}
	folks_abstract_field_details_set_value ((FolksAbstractFieldDetails*) self, value);
	if (parameters != NULL) {
		folks_abstract_field_details_set_parameters ((FolksAbstractFieldDetails*) self, G_TYPE_CHECK_INSTANCE_CAST (parameters, GEE_TYPE_MULTI_MAP, GeeMultiMap));
	}
	return self;
}

FolksEmailFieldDetails*
folks_email_field_details_new (const gchar* value,
                               GeeMultiMap* parameters)
{
	return folks_email_field_details_construct (FOLKS_TYPE_EMAIL_FIELD_DETAILS, value, parameters);
}

/**
   * {@inheritDoc}
   *
   * @since 0.6.0
   */
static gboolean
folks_email_field_details_real_equal (FolksAbstractFieldDetails* base,
                                      FolksAbstractFieldDetails* that)
{
	FolksEmailFieldDetails * self;
	gboolean result;
	self = (FolksEmailFieldDetails*) base;
	g_return_val_if_fail (that != NULL, FALSE);
	result = FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (folks_email_field_details_parent_class)->equal (G_TYPE_CHECK_INSTANCE_CAST (self, FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails), that);
	return result;
}

/**
   * {@inheritDoc}
   *
   * @since 0.6.0
   */
static guint
folks_email_field_details_real_hash (FolksAbstractFieldDetails* base)
{
	FolksEmailFieldDetails * self;
	guint result;
	self = (FolksEmailFieldDetails*) base;
	result = FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (folks_email_field_details_parent_class)->hash (G_TYPE_CHECK_INSTANCE_CAST (self, FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails));
	return result;
}

static void
folks_email_field_details_class_init (FolksEmailFieldDetailsClass * klass,
                                      gpointer klass_data)
{
	folks_email_field_details_parent_class = g_type_class_peek_parent (klass);
	((FolksAbstractFieldDetailsClass *) klass)->equal = (gboolean (*) (FolksAbstractFieldDetails*, FolksAbstractFieldDetails*)) folks_email_field_details_real_equal;
	((FolksAbstractFieldDetailsClass *) klass)->hash = (guint (*) (FolksAbstractFieldDetails*)) folks_email_field_details_real_hash;
}

static void
folks_email_field_details_instance_init (FolksEmailFieldDetails * self,
                                         gpointer klass)
{
}

/**
 * Object representing a email address that can have some parameters
 * associated with it.
 *
 * See {@link Folks.AbstractFieldDetails} for details on common parameter names
 * and values.
 *
 * @since 0.6.0
 */
static GType
folks_email_field_details_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksEmailFieldDetailsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_email_field_details_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksEmailFieldDetails), 0, (GInstanceInitFunc) folks_email_field_details_instance_init, NULL };
	GType folks_email_field_details_type_id;
	folks_email_field_details_type_id = g_type_register_static (FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, "FolksEmailFieldDetails", &g_define_type_info, 0);
	return folks_email_field_details_type_id;
}

GType
folks_email_field_details_get_type (void)
{
	static volatile gsize folks_email_field_details_type_id__once = 0;
	if (g_once_init_enter (&folks_email_field_details_type_id__once)) {
		GType folks_email_field_details_type_id;
		folks_email_field_details_type_id = folks_email_field_details_get_type_once ();
		g_once_init_leave (&folks_email_field_details_type_id__once, folks_email_field_details_type_id);
	}
	return folks_email_field_details_type_id__once;
}

static void
folks_email_details_real_change_email_addresses_data_free (gpointer _data)
{
	FolksEmailDetailsChangeEmailAddressesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->email_addresses);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksEmailDetailsChangeEmailAddressesData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
folks_email_details_real_change_email_addresses (FolksEmailDetails* self,
                                                 GeeSet* email_addresses,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_)
{
	FolksEmailDetailsChangeEmailAddressesData* _data_;
	FolksEmailDetails* _tmp0_;
	GeeSet* _tmp1_;
	g_return_if_fail (email_addresses != NULL);
	_data_ = g_slice_new0 (FolksEmailDetailsChangeEmailAddressesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_email_details_real_change_email_addresses_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (email_addresses);
	_g_object_unref0 (_data_->email_addresses);
	_data_->email_addresses = _tmp1_;
	folks_email_details_real_change_email_addresses_co (_data_);
}

static void
folks_email_details_real_change_email_addresses_finish (FolksEmailDetails* self,
                                                        GAsyncResult* _res_,
                                                        GError** error)
{
	FolksEmailDetailsChangeEmailAddressesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * Change the contact's set of e-mail addresses.
   *
   * It's preferred to call this rather than setting
   * {@link EmailDetails.email_addresses} directly, as this method gives error
   * notification and will only return once the e-mail addresses have been
   * written to the relevant backing store (or the operation's failed).
   *
   * @param email_addresses the new set of e-mail addresses
   * @throws PropertyError if setting the e-mail addresses failed
   * @since 0.6.2
   */
static gboolean
folks_email_details_real_change_email_addresses_co (FolksEmailDetailsChangeEmailAddressesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_NOT_WRITEABLE, _ ("E-mail addresses are not writeable on this contact."));
	_data_->_inner_error0_ = _data_->_tmp0_;
	if (_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
folks_email_details_change_email_addresses (FolksEmailDetails* self,
                                            GeeSet* email_addresses,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	FolksEmailDetailsIface* _iface_;
	_iface_ = FOLKS_EMAIL_DETAILS_GET_INTERFACE (self);
	if (_iface_->change_email_addresses) {
		_iface_->change_email_addresses (self, email_addresses, _callback_, _user_data_);
	}
}

void
folks_email_details_change_email_addresses_finish (FolksEmailDetails* self,
                                                   GAsyncResult* _res_,
                                                   GError** error)
{
	FolksEmailDetailsIface* _iface_;
	_iface_ = FOLKS_EMAIL_DETAILS_GET_INTERFACE (self);
	if (_iface_->change_email_addresses_finish) {
		_iface_->change_email_addresses_finish (self, _res_, error);
	}
}

GeeSet*
folks_email_details_get_email_addresses (FolksEmailDetails* self)
{
	FolksEmailDetailsIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = FOLKS_EMAIL_DETAILS_GET_INTERFACE (self);
	if (_iface_->get_email_addresses) {
		return _iface_->get_email_addresses (self);
	}
	return NULL;
}

void
folks_email_details_set_email_addresses (FolksEmailDetails* self,
                                         GeeSet* value)
{
	FolksEmailDetailsIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = FOLKS_EMAIL_DETAILS_GET_INTERFACE (self);
	if (_iface_->set_email_addresses) {
		_iface_->set_email_addresses (self, value);
	}
}

static void
folks_email_details_default_init (FolksEmailDetailsIface * iface,
                                  gpointer iface_data)
{
	/**
	   * The email addresses of the contact.
	   *
	   * Each of the values in this property contains just an e-mail address (e.g.
	   * “foo@bar.com”), rather than any other way of formatting an e-mail address
	   * (such as “John Smith &lt;foo@bar.com&gt;”).
	   *
	   * @since 0.6.0
	   */
	g_object_interface_install_property (iface, g_param_spec_object ("email-addresses", "email-addresses", "email-addresses", GEE_TYPE_SET, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	iface->change_email_addresses = folks_email_details_real_change_email_addresses;
	iface->change_email_addresses_finish = folks_email_details_real_change_email_addresses_finish;
}

/**
 * Interface for classes that have email addresses, such as {@link Persona}
 * and {@link Individual}.
 *
 * @since 0.3.5
 */
static GType
folks_email_details_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksEmailDetailsIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_email_details_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType folks_email_details_type_id;
	folks_email_details_type_id = g_type_register_static (G_TYPE_INTERFACE, "FolksEmailDetails", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (folks_email_details_type_id, G_TYPE_OBJECT);
	return folks_email_details_type_id;
}

GType
folks_email_details_get_type (void)
{
	static volatile gsize folks_email_details_type_id__once = 0;
	if (g_once_init_enter (&folks_email_details_type_id__once)) {
		GType folks_email_details_type_id;
		folks_email_details_type_id = folks_email_details_get_type_once ();
		g_once_init_leave (&folks_email_details_type_id__once, folks_email_details_type_id);
	}
	return folks_email_details_type_id__once;
}

