/* local-id-details.c generated by valac 0.56.18, the Vala compiler
 * generated from local-id-details.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 * Copyright (C) 2011 Philip Withnall
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *       Philip Withnall <philip@tecnocode.co.uk>
 */

#include "folks/folks.h"
#include <gio/gio.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _FolksLocalIdDetailsChangeLocalIdsData FolksLocalIdDetailsChangeLocalIdsData;

struct _FolksLocalIdDetailsChangeLocalIdsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksLocalIdDetails* self;
	GeeSet* local_ids;
	GError* _tmp0_;
	GError* _inner_error0_;
};

static void folks_local_id_details_real_change_local_ids_data_free (gpointer _data);
static void folks_local_id_details_real_change_local_ids (FolksLocalIdDetails* self,
                                                   GeeSet* local_ids,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
static gboolean folks_local_id_details_real_change_local_ids_co (FolksLocalIdDetailsChangeLocalIdsData* _data_);
static GType folks_local_id_details_get_type_once (void);

static void
folks_local_id_details_real_change_local_ids_data_free (gpointer _data)
{
	FolksLocalIdDetailsChangeLocalIdsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->local_ids);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksLocalIdDetailsChangeLocalIdsData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
folks_local_id_details_real_change_local_ids (FolksLocalIdDetails* self,
                                              GeeSet* local_ids,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	FolksLocalIdDetailsChangeLocalIdsData* _data_;
	FolksLocalIdDetails* _tmp0_;
	GeeSet* _tmp1_;
	g_return_if_fail (local_ids != NULL);
	_data_ = g_slice_new0 (FolksLocalIdDetailsChangeLocalIdsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_local_id_details_real_change_local_ids_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (local_ids);
	_g_object_unref0 (_data_->local_ids);
	_data_->local_ids = _tmp1_;
	folks_local_id_details_real_change_local_ids_co (_data_);
}

static void
folks_local_id_details_real_change_local_ids_finish (FolksLocalIdDetails* self,
                                                     GAsyncResult* _res_,
                                                     GError** error)
{
	FolksLocalIdDetailsChangeLocalIdsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * Change the contact's local IDs.
   *
   * It's preferred to call this rather than setting
   * {@link LocalIdDetails.local_ids} directly, as this method gives error
   * notification and will only return once the local IDs have been written to
   * the relevant backing store (or the operation's failed).
   *
   * @param local_ids the set of local IDs
   * @throws PropertyError if setting the local IDs failed
   * @since 0.6.2
   */
static gboolean
folks_local_id_details_real_change_local_ids_co (FolksLocalIdDetailsChangeLocalIdsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_NOT_WRITEABLE, _ ("Local IDs are not writeable on this contact."));
	_data_->_inner_error0_ = _data_->_tmp0_;
	if (_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
folks_local_id_details_change_local_ids (FolksLocalIdDetails* self,
                                         GeeSet* local_ids,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	FolksLocalIdDetailsIface* _iface_;
	_iface_ = FOLKS_LOCAL_ID_DETAILS_GET_INTERFACE (self);
	if (_iface_->change_local_ids) {
		_iface_->change_local_ids (self, local_ids, _callback_, _user_data_);
	}
}

void
folks_local_id_details_change_local_ids_finish (FolksLocalIdDetails* self,
                                                GAsyncResult* _res_,
                                                GError** error)
{
	FolksLocalIdDetailsIface* _iface_;
	_iface_ = FOLKS_LOCAL_ID_DETAILS_GET_INTERFACE (self);
	if (_iface_->change_local_ids_finish) {
		_iface_->change_local_ids_finish (self, _res_, error);
	}
}

GeeSet*
folks_local_id_details_get_local_ids (FolksLocalIdDetails* self)
{
	FolksLocalIdDetailsIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = FOLKS_LOCAL_ID_DETAILS_GET_INTERFACE (self);
	if (_iface_->get_local_ids) {
		return _iface_->get_local_ids (self);
	}
	return NULL;
}

void
folks_local_id_details_set_local_ids (FolksLocalIdDetails* self,
                                      GeeSet* value)
{
	FolksLocalIdDetailsIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = FOLKS_LOCAL_ID_DETAILS_GET_INTERFACE (self);
	if (_iface_->set_local_ids) {
		_iface_->set_local_ids (self, value);
	}
}

static void
folks_local_id_details_default_init (FolksLocalIdDetailsIface * iface,
                                     gpointer iface_data)
{
	/**
	   * The IIDs corresponding to {@link Persona}s in a
	   * backend that we fully trust.
	   *
	   * @since 0.5.1
	   */
	g_object_interface_install_property (iface, g_param_spec_object ("local-ids", "local-ids", "local-ids", GEE_TYPE_SET, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	iface->change_local_ids = folks_local_id_details_real_change_local_ids;
	iface->change_local_ids_finish = folks_local_id_details_real_change_local_ids_finish;
}

/**
 * This interface represents the list of {@link Persona.iid}s
 * corresponding to {@link Persona}s from backends with write
 * support so that they can be linked.
 *
 * This is necessary so that personas from the same backend
 * can be linked together even if they have no other linkeable
 * properties set.
 *
 * @since 0.5.0
 */
static GType
folks_local_id_details_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksLocalIdDetailsIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_local_id_details_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType folks_local_id_details_type_id;
	folks_local_id_details_type_id = g_type_register_static (G_TYPE_INTERFACE, "FolksLocalIdDetails", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (folks_local_id_details_type_id, G_TYPE_OBJECT);
	return folks_local_id_details_type_id;
}

GType
folks_local_id_details_get_type (void)
{
	static volatile gsize folks_local_id_details_type_id__once = 0;
	if (g_once_init_enter (&folks_local_id_details_type_id__once)) {
		GType folks_local_id_details_type_id;
		folks_local_id_details_type_id = folks_local_id_details_get_type_once ();
		g_once_init_leave (&folks_local_id_details_type_id__once, folks_local_id_details_type_id);
	}
	return folks_local_id_details_type_id__once;
}

