/* role-details.c generated by valac 0.56.18, the Vala compiler
 * generated from role-details.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 * Copyright (C) 2011 Philip Withnall
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Philip Withnall <philip@tecnocode.co.uk>
 */

#include "folks/folks.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	FOLKS_ROLE_0_PROPERTY,
	FOLKS_ROLE_ORGANISATION_NAME_PROPERTY,
	FOLKS_ROLE_TITLE_PROPERTY,
	FOLKS_ROLE_ROLE_PROPERTY,
	FOLKS_ROLE_UID_PROPERTY,
	FOLKS_ROLE_NUM_PROPERTIES
};
static GParamSpec* folks_role_properties[FOLKS_ROLE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	FOLKS_ROLE_FIELD_DETAILS_0_PROPERTY,
	FOLKS_ROLE_FIELD_DETAILS_ID_PROPERTY,
	FOLKS_ROLE_FIELD_DETAILS_NUM_PROPERTIES
};
static GParamSpec* folks_role_field_details_properties[FOLKS_ROLE_FIELD_DETAILS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _FolksRoleDetailsChangeRolesData FolksRoleDetailsChangeRolesData;

struct _FolksRolePrivate {
	gchar* _organisation_name;
	gchar* _title;
	gchar* _role;
	gchar* _uid;
};

struct _FolksRoleFieldDetailsPrivate {
	gchar* _id;
};

struct _FolksRoleDetailsChangeRolesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksRoleDetails* self;
	GeeSet* roles;
	GError* _tmp0_;
	GError* _inner_error0_;
};

static gint FolksRole_private_offset;
static gpointer folks_role_parent_class = NULL;
static gint FolksRoleFieldDetails_private_offset;
static gpointer folks_role_field_details_parent_class = NULL;

static void folks_role_finalize (GObject * obj);
static GType folks_role_get_type_once (void);
static void _vala_folks_role_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec);
static void _vala_folks_role_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec);
static gboolean folks_role_field_details_real_equal (FolksAbstractFieldDetails* base,
                                              FolksAbstractFieldDetails* that);
static guint folks_role_field_details_real_hash (FolksAbstractFieldDetails* base);
static GObject * folks_role_field_details_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties);
static void _folks_role_field_details___lambda5_ (FolksRoleFieldDetails* self,
                                           GObject* s,
                                           GParamSpec* p);
static void __folks_role_field_details___lambda5__g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self);
static void folks_role_field_details_finalize (GObject * obj);
static GType folks_role_field_details_get_type_once (void);
static void _vala_folks_role_field_details_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_folks_role_field_details_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static void folks_role_details_real_change_roles_data_free (gpointer _data);
static void folks_role_details_real_change_roles (FolksRoleDetails* self,
                                           GeeSet* roles,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static gboolean folks_role_details_real_change_roles_co (FolksRoleDetailsChangeRolesData* _data_);
static GType folks_role_details_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
folks_role_get_instance_private (FolksRole* self)
{
	return G_STRUCT_MEMBER_P (self, FolksRole_private_offset);
}

/**
   * Default constructor.
   *
   * @param title title of the position
   * @param organisation_name organisation where the role is hold
   * @param uid a Unique ID associated to this Role
   * @return a new Role
   *
   * @since 0.4.0
   */
FolksRole*
folks_role_construct (GType object_type,
                      const gchar* title,
                      const gchar* organisation_name,
                      const gchar* uid)
{
	FolksRole * self = NULL;
	self = (FolksRole*) g_object_new (object_type, "uid", uid, "title", title, "organisation-name", organisation_name, NULL);
	return self;
}

FolksRole*
folks_role_new (const gchar* title,
                const gchar* organisation_name,
                const gchar* uid)
{
	return folks_role_construct (FOLKS_TYPE_ROLE, title, organisation_name, uid);
}

/**
   * Whether none of the components is set.
   *
   * @return ``true`` if all the components are the empty string, ``false``
   * otherwise.
   *
   * @since 0.6.7
   */
gboolean
folks_role_is_empty (FolksRole* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp2_ = folks_role_get_organisation_name (self);
	_tmp3_ = _tmp2_;
	if (g_strcmp0 (_tmp3_, "") == 0) {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = folks_role_get_title (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = g_strcmp0 (_tmp5_, "") == 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = folks_role_get_role (self);
		_tmp7_ = _tmp6_;
		_tmp0_ = g_strcmp0 (_tmp7_, "") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

/**
   * Compare if two roles are equal. Roles are equal if their titles and
   * organisation names are equal.
   *
   * @param a a role to compare
   * @param b another role to compare
   * @return ``true`` if the roles are equal, ``false`` otherwise
   */
gboolean
folks_role_equal (FolksRole* a,
                  FolksRole* b)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gboolean result;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp2_ = folks_role_get_title (a);
	_tmp3_ = _tmp2_;
	_tmp4_ = folks_role_get_title (b);
	_tmp5_ = _tmp4_;
	if (g_strcmp0 (_tmp3_, _tmp5_) == 0) {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp6_ = folks_role_get_role (a);
		_tmp7_ = _tmp6_;
		_tmp8_ = folks_role_get_role (b);
		_tmp9_ = _tmp8_;
		_tmp1_ = g_strcmp0 (_tmp7_, _tmp9_) == 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		_tmp10_ = folks_role_get_organisation_name (a);
		_tmp11_ = _tmp10_;
		_tmp12_ = folks_role_get_organisation_name (b);
		_tmp13_ = _tmp12_;
		_tmp0_ = g_strcmp0 (_tmp11_, _tmp13_) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

/**
   * Hash function for the class. Suitable for use as a hash table key.
   *
   * @param r a role to hash
   * @return hash value for the role instance
   */
guint
folks_role_hash (FolksRole* r)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	guint result;
	g_return_val_if_fail (r != NULL, 0U);
	_tmp0_ = folks_role_get_organisation_name (r);
	_tmp1_ = _tmp0_;
	_tmp2_ = folks_role_get_title (r);
	_tmp3_ = _tmp2_;
	_tmp4_ = folks_role_get_role (r);
	_tmp5_ = _tmp4_;
	result = (g_str_hash (_tmp1_) ^ g_str_hash (_tmp3_)) ^ g_str_hash (_tmp5_);
	return result;
}

/**
   * Formatted version of this role.
   *
   * @since 0.4.0
   */
gchar*
folks_role_to_string (FolksRole* self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (_ ("Title: %s, Organisation: %s, Role: %s"));
	str = _tmp0_;
	_tmp1_ = folks_role_get_title (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = folks_role_get_organisation_name (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = folks_role_get_role (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf (str, _tmp2_, _tmp4_, _tmp6_);
	result = _tmp7_;
	_g_free0 (str);
	return result;
}

const gchar*
folks_role_get_organisation_name (FolksRole* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_organisation_name;
	result = _tmp0_;
	return result;
}

void
folks_role_set_organisation_name (FolksRole* self,
                                  const gchar* value)
{
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		_tmp0_ = value;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_organisation_name);
	self->priv->_organisation_name = _tmp1_;
	g_object_notify_by_pspec ((GObject *) self, folks_role_properties[FOLKS_ROLE_ORGANISATION_NAME_PROPERTY]);
}

const gchar*
folks_role_get_title (FolksRole* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_title;
	result = _tmp0_;
	return result;
}

void
folks_role_set_title (FolksRole* self,
                      const gchar* value)
{
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		_tmp0_ = value;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_title);
	self->priv->_title = _tmp1_;
	g_object_notify_by_pspec ((GObject *) self, folks_role_properties[FOLKS_ROLE_TITLE_PROPERTY]);
}

const gchar*
folks_role_get_role (FolksRole* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_role;
	result = _tmp0_;
	return result;
}

void
folks_role_set_role (FolksRole* self,
                     const gchar* value)
{
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		_tmp0_ = value;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_role);
	self->priv->_role = _tmp1_;
	g_object_notify_by_pspec ((GObject *) self, folks_role_properties[FOLKS_ROLE_ROLE_PROPERTY]);
}

const gchar*
folks_role_get_uid (FolksRole* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uid;
	result = _tmp0_;
	return result;
}

void
folks_role_set_uid (FolksRole* self,
                    const gchar* value)
{
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		_tmp0_ = value;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_uid);
	self->priv->_uid = _tmp1_;
	g_object_notify_by_pspec ((GObject *) self, folks_role_properties[FOLKS_ROLE_UID_PROPERTY]);
}

static void
folks_role_class_init (FolksRoleClass * klass,
                       gpointer klass_data)
{
	folks_role_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FolksRole_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_role_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_role_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_role_finalize;
	/**
	   * The name of the organisation in which the role is held.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_ROLE_ORGANISATION_NAME_PROPERTY, folks_role_properties[FOLKS_ROLE_ORGANISATION_NAME_PROPERTY] = g_param_spec_string ("organisation-name", "organisation-name", "organisation-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * The title of the position held.
	   *
	   * For example: “Director, Ministry of Silly Walks”
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_ROLE_TITLE_PROPERTY, folks_role_properties[FOLKS_ROLE_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * The role of the position.
	   *
	   * For example: “Programmer”
	   *
	   * @since 0.6.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_ROLE_ROLE_PROPERTY, folks_role_properties[FOLKS_ROLE_ROLE_PROPERTY] = g_param_spec_string ("role", "role", "role", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * The UID that distinguishes this role.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_ROLE_UID_PROPERTY, folks_role_properties[FOLKS_ROLE_UID_PROPERTY] = g_param_spec_string ("uid", "uid", "uid", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_DEPRECATED));
}

static void
folks_role_instance_init (FolksRole * self,
                          gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	self->priv = folks_role_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_organisation_name = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_title = _tmp1_;
	_tmp2_ = g_strdup ("");
	self->priv->_role = _tmp2_;
	_tmp3_ = g_strdup ("");
	self->priv->_uid = _tmp3_;
}

static void
folks_role_finalize (GObject * obj)
{
	FolksRole * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_ROLE, FolksRole);
	_g_free0 (self->priv->_organisation_name);
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_role);
	_g_free0 (self->priv->_uid);
	G_OBJECT_CLASS (folks_role_parent_class)->finalize (obj);
}

/**
 * Role a contact has in an organisation.
 *
 * This represents the role a {@link Persona} or {@link Individual} has in a
 * single given organisation, such as a company.
 *
 * @since 0.4.0
 */
static GType
folks_role_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksRoleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_role_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksRole), 0, (GInstanceInitFunc) folks_role_instance_init, NULL };
	GType folks_role_type_id;
	folks_role_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksRole", &g_define_type_info, 0);
	FolksRole_private_offset = g_type_add_instance_private (folks_role_type_id, sizeof (FolksRolePrivate));
	return folks_role_type_id;
}

GType
folks_role_get_type (void)
{
	static volatile gsize folks_role_type_id__once = 0;
	if (g_once_init_enter (&folks_role_type_id__once)) {
		GType folks_role_type_id;
		folks_role_type_id = folks_role_get_type_once ();
		g_once_init_leave (&folks_role_type_id__once, folks_role_type_id);
	}
	return folks_role_type_id__once;
}

static void
_vala_folks_role_get_property (GObject * object,
                               guint property_id,
                               GValue * value,
                               GParamSpec * pspec)
{
	FolksRole * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_ROLE, FolksRole);
	switch (property_id) {
		case FOLKS_ROLE_ORGANISATION_NAME_PROPERTY:
		g_value_set_string (value, folks_role_get_organisation_name (self));
		break;
		case FOLKS_ROLE_TITLE_PROPERTY:
		g_value_set_string (value, folks_role_get_title (self));
		break;
		case FOLKS_ROLE_ROLE_PROPERTY:
		g_value_set_string (value, folks_role_get_role (self));
		break;
		case FOLKS_ROLE_UID_PROPERTY:
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
		g_value_set_string (value, folks_role_get_uid (self));
G_GNUC_END_IGNORE_DEPRECATIONS
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_folks_role_set_property (GObject * object,
                               guint property_id,
                               const GValue * value,
                               GParamSpec * pspec)
{
	FolksRole * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_ROLE, FolksRole);
	switch (property_id) {
		case FOLKS_ROLE_ORGANISATION_NAME_PROPERTY:
		folks_role_set_organisation_name (self, g_value_get_string (value));
		break;
		case FOLKS_ROLE_TITLE_PROPERTY:
		folks_role_set_title (self, g_value_get_string (value));
		break;
		case FOLKS_ROLE_ROLE_PROPERTY:
		folks_role_set_role (self, g_value_get_string (value));
		break;
		case FOLKS_ROLE_UID_PROPERTY:
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
		folks_role_set_uid (self, g_value_get_string (value));
G_GNUC_END_IGNORE_DEPRECATIONS
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
folks_role_field_details_get_instance_private (FolksRoleFieldDetails* self)
{
	return G_STRUCT_MEMBER_P (self, FolksRoleFieldDetails_private_offset);
}

/**
   * Create a new RoleFieldDetails.
   *
   * @param value the non-empty {@link Role} of the field
   * @param parameters initial parameters. See
   * {@link AbstractFieldDetails.parameters}. A ``null`` value is equivalent to an
   * empty map of parameters.
   *
   * @return a new RoleFieldDetails
   *
   * @since 0.6.0
   */
FolksRoleFieldDetails*
folks_role_field_details_construct (GType object_type,
                                    FolksRole* value,
                                    GeeMultiMap* parameters)
{
	FolksRoleFieldDetails * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (value != NULL, NULL);
	if (folks_role_is_empty (value)) {
		g_warning ("role-details.vala:200: Empty role passed to RoleFieldDetails.");
	}
	_tmp0_ = folks_role_get_uid (value);
	_tmp1_ = _tmp0_;
	self = (FolksRoleFieldDetails*) g_object_new (object_type, "t-type", FOLKS_TYPE_ROLE, "t-dup-func", (GBoxedCopyFunc) g_object_ref, "t-destroy-func", (GDestroyNotify) g_object_unref, "value", value, "parameters", parameters, "id", _tmp1_, NULL);
	return self;
}

FolksRoleFieldDetails*
folks_role_field_details_new (FolksRole* value,
                              GeeMultiMap* parameters)
{
	return folks_role_field_details_construct (FOLKS_TYPE_ROLE_FIELD_DETAILS, value, parameters);
}

/**
   * {@inheritDoc}
   *
   * @since 0.6.0
   */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
folks_role_field_details_real_equal (FolksAbstractFieldDetails* base,
                                     FolksAbstractFieldDetails* that)
{
	FolksRoleFieldDetails * self;
	FolksRoleFieldDetails* _that_fd = NULL;
	FolksRoleFieldDetails* _tmp0_;
	FolksRoleFieldDetails* _tmp1_;
	FolksRoleFieldDetails* that_fd = NULL;
	FolksRoleFieldDetails* _tmp2_;
	FolksRoleFieldDetails* _tmp3_;
	gconstpointer _tmp4_;
	gconstpointer _tmp5_;
	FolksRoleFieldDetails* _tmp6_;
	gconstpointer _tmp7_;
	gconstpointer _tmp8_;
	gboolean result;
	self = (FolksRoleFieldDetails*) base;
	g_return_val_if_fail (that != NULL, FALSE);
	_tmp0_ = _g_object_ref0 (FOLKS_IS_ROLE_FIELD_DETAILS (that) ? ((FolksRoleFieldDetails*) that) : NULL);
	_that_fd = _tmp0_;
	_tmp1_ = _that_fd;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_g_object_unref0 (_that_fd);
		return result;
	}
	_tmp2_ = _that_fd;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, FOLKS_TYPE_ROLE_FIELD_DETAILS, FolksRoleFieldDetails));
	that_fd = _tmp3_;
	if (!FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (folks_role_field_details_parent_class)->parameters_equal (G_TYPE_CHECK_INSTANCE_CAST (self, FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails), that)) {
		result = FALSE;
		_g_object_unref0 (that_fd);
		_g_object_unref0 (_that_fd);
		return result;
	}
	_tmp4_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = that_fd;
	_tmp7_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp6_);
	_tmp8_ = _tmp7_;
	result = folks_role_equal ((FolksRole*) _tmp5_, (FolksRole*) _tmp8_);
	_g_object_unref0 (that_fd);
	_g_object_unref0 (_that_fd);
	return result;
}

/**
   * {@inheritDoc}
   *
   * @since 0.6.0
   */
static guint
folks_role_field_details_real_hash (FolksAbstractFieldDetails* base)
{
	FolksRoleFieldDetails * self;
	GHashFunc _tmp0_;
	gconstpointer _tmp1_;
	gconstpointer _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	guint _tmp5_;
	guint result;
	self = (FolksRoleFieldDetails*) base;
	_tmp0_ = g_str_hash;
	_tmp1_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = folks_role_to_string ((FolksRole*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp0_ (_tmp4_);
	_g_free0 (_tmp4_);
	result = _tmp5_;
	return result;
}

static const gchar*
folks_role_field_details_real_get_id (FolksAbstractFieldDetails* base)
{
	const gchar* result;
	FolksRoleFieldDetails* self;
	const gchar* _tmp0_;
	self = (FolksRoleFieldDetails*) base;
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}

static void
folks_role_field_details_real_set_id (FolksAbstractFieldDetails* base,
                                      const gchar* value)
{
	FolksRoleFieldDetails* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gconstpointer _tmp3_;
	gconstpointer _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	self = (FolksRoleFieldDetails*) base;
	if (value != NULL) {
		_tmp0_ = value;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_id);
	self->priv->_id = _tmp1_;
	_tmp2_ = self->priv->_id;
	_tmp3_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = folks_role_get_uid ((FolksRole*) _tmp4_);
	_tmp6_ = _tmp5_;
	if (g_strcmp0 (_tmp2_, _tmp6_) != 0) {
		gconstpointer _tmp7_;
		gconstpointer _tmp8_;
		const gchar* _tmp9_;
		_tmp7_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = self->priv->_id;
		folks_role_set_uid ((FolksRole*) _tmp8_, _tmp9_);
	}
	g_object_notify_by_pspec ((GObject *) self, folks_role_field_details_properties[FOLKS_ROLE_FIELD_DETAILS_ID_PROPERTY]);
}

static void
_folks_role_field_details___lambda5_ (FolksRoleFieldDetails* self,
                                      GObject* s,
                                      GParamSpec* p)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gconstpointer _tmp2_;
	gconstpointer _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = folks_abstract_field_details_get_id ((FolksAbstractFieldDetails*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = folks_role_get_uid ((FolksRole*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (g_strcmp0 (_tmp1_, _tmp5_) != 0) {
		gconstpointer _tmp6_;
		gconstpointer _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp6_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) self);
		_tmp7_ = _tmp6_;
		_tmp8_ = folks_role_get_uid ((FolksRole*) _tmp7_);
		_tmp9_ = _tmp8_;
		folks_abstract_field_details_set_id ((FolksAbstractFieldDetails*) self, _tmp9_);
	}
}

static void
__folks_role_field_details___lambda5__g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self)
{
	_folks_role_field_details___lambda5_ ((FolksRoleFieldDetails*) self, _sender, pspec);
}

static GObject *
folks_role_field_details_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FolksRoleFieldDetails * self;
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	parent_class = G_OBJECT_CLASS (folks_role_field_details_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_ROLE_FIELD_DETAILS, FolksRoleFieldDetails);
	_tmp0_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) self);
	_tmp1_ = _tmp0_;
	g_signal_connect_object ((GObject*) ((FolksRole*) _tmp1_), "notify::uid", (GCallback) __folks_role_field_details___lambda5__g_object_notify, self, 0);
	return obj;
}

static void
folks_role_field_details_class_init (FolksRoleFieldDetailsClass * klass,
                                     gpointer klass_data)
{
	folks_role_field_details_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FolksRoleFieldDetails_private_offset);
	((FolksAbstractFieldDetailsClass *) klass)->equal = (gboolean (*) (FolksAbstractFieldDetails*, FolksAbstractFieldDetails*)) folks_role_field_details_real_equal;
	((FolksAbstractFieldDetailsClass *) klass)->hash = (guint (*) (FolksAbstractFieldDetails*)) folks_role_field_details_real_hash;
	FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (klass)->get_id = (const gchar* (*) (FolksAbstractFieldDetails*)) folks_role_field_details_real_get_id;
	FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (klass)->set_id = (void (*) (FolksAbstractFieldDetails*, const gchar*)) folks_role_field_details_real_set_id;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_role_field_details_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_role_field_details_set_property;
	G_OBJECT_CLASS (klass)->constructor = folks_role_field_details_constructor;
	G_OBJECT_CLASS (klass)->finalize = folks_role_field_details_finalize;
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_ROLE_FIELD_DETAILS_ID_PROPERTY, folks_role_field_details_properties[FOLKS_ROLE_FIELD_DETAILS_ID_PROPERTY] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
folks_role_field_details_instance_init (FolksRoleFieldDetails * self,
                                        gpointer klass)
{
	gchar* _tmp0_;
	self->priv = folks_role_field_details_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_id = _tmp0_;
}

static void
folks_role_field_details_finalize (GObject * obj)
{
	FolksRoleFieldDetails * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_ROLE_FIELD_DETAILS, FolksRoleFieldDetails);
	_g_free0 (self->priv->_id);
	G_OBJECT_CLASS (folks_role_field_details_parent_class)->finalize (obj);
}

/**
 * Object representing details of a contact in an organisation which can have
 * some parameters associated with it.
 *
 * See {@link Folks.AbstractFieldDetails}.
 *
 * @since 0.6.0
 */
static GType
folks_role_field_details_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksRoleFieldDetailsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_role_field_details_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksRoleFieldDetails), 0, (GInstanceInitFunc) folks_role_field_details_instance_init, NULL };
	GType folks_role_field_details_type_id;
	folks_role_field_details_type_id = g_type_register_static (FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, "FolksRoleFieldDetails", &g_define_type_info, 0);
	FolksRoleFieldDetails_private_offset = g_type_add_instance_private (folks_role_field_details_type_id, sizeof (FolksRoleFieldDetailsPrivate));
	return folks_role_field_details_type_id;
}

GType
folks_role_field_details_get_type (void)
{
	static volatile gsize folks_role_field_details_type_id__once = 0;
	if (g_once_init_enter (&folks_role_field_details_type_id__once)) {
		GType folks_role_field_details_type_id;
		folks_role_field_details_type_id = folks_role_field_details_get_type_once ();
		g_once_init_leave (&folks_role_field_details_type_id__once, folks_role_field_details_type_id);
	}
	return folks_role_field_details_type_id__once;
}

static void
_vala_folks_role_field_details_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	FolksRoleFieldDetails * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_ROLE_FIELD_DETAILS, FolksRoleFieldDetails);
	switch (property_id) {
		case FOLKS_ROLE_FIELD_DETAILS_ID_PROPERTY:
		g_value_set_string (value, folks_abstract_field_details_get_id ((FolksAbstractFieldDetails*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_folks_role_field_details_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	FolksRoleFieldDetails * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_ROLE_FIELD_DETAILS, FolksRoleFieldDetails);
	switch (property_id) {
		case FOLKS_ROLE_FIELD_DETAILS_ID_PROPERTY:
		folks_abstract_field_details_set_id ((FolksAbstractFieldDetails*) self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
folks_role_details_real_change_roles_data_free (gpointer _data)
{
	FolksRoleDetailsChangeRolesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->roles);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksRoleDetailsChangeRolesData, _data_);
}

static void
folks_role_details_real_change_roles (FolksRoleDetails* self,
                                      GeeSet* roles,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	FolksRoleDetailsChangeRolesData* _data_;
	FolksRoleDetails* _tmp0_;
	GeeSet* _tmp1_;
	g_return_if_fail (roles != NULL);
	_data_ = g_slice_new0 (FolksRoleDetailsChangeRolesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_role_details_real_change_roles_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (roles);
	_g_object_unref0 (_data_->roles);
	_data_->roles = _tmp1_;
	folks_role_details_real_change_roles_co (_data_);
}

static void
folks_role_details_real_change_roles_finish (FolksRoleDetails* self,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	FolksRoleDetailsChangeRolesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * Change the contact's roles.
   *
   * It's preferred to call this rather than setting {@link RoleDetails.roles}
   * directly, as this method gives error notification and will only return once
   * the roles have been written to the relevant backing store (or the
   * operation's failed).
   *
   * @param roles the set of roles
   * @throws PropertyError if setting the roles failed
   * @since 0.6.2
   */
static gboolean
folks_role_details_real_change_roles_co (FolksRoleDetailsChangeRolesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_NOT_WRITEABLE, _ ("Roles are not writeable on this contact."));
	_data_->_inner_error0_ = _data_->_tmp0_;
	if (_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
folks_role_details_change_roles (FolksRoleDetails* self,
                                 GeeSet* roles,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	FolksRoleDetailsIface* _iface_;
	_iface_ = FOLKS_ROLE_DETAILS_GET_INTERFACE (self);
	if (_iface_->change_roles) {
		_iface_->change_roles (self, roles, _callback_, _user_data_);
	}
}

void
folks_role_details_change_roles_finish (FolksRoleDetails* self,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	FolksRoleDetailsIface* _iface_;
	_iface_ = FOLKS_ROLE_DETAILS_GET_INTERFACE (self);
	if (_iface_->change_roles_finish) {
		_iface_->change_roles_finish (self, _res_, error);
	}
}

GeeSet*
folks_role_details_get_roles (FolksRoleDetails* self)
{
	FolksRoleDetailsIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = FOLKS_ROLE_DETAILS_GET_INTERFACE (self);
	if (_iface_->get_roles) {
		return _iface_->get_roles (self);
	}
	return NULL;
}

void
folks_role_details_set_roles (FolksRoleDetails* self,
                              GeeSet* value)
{
	FolksRoleDetailsIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = FOLKS_ROLE_DETAILS_GET_INTERFACE (self);
	if (_iface_->set_roles) {
		_iface_->set_roles (self, value);
	}
}

static void
folks_role_details_default_init (FolksRoleDetailsIface * iface,
                                 gpointer iface_data)
{
	/**
	   * The roles of the contact.
	   *
	   * @since 0.6.0
	   */
	g_object_interface_install_property (iface, g_param_spec_object ("roles", "roles", "roles", GEE_TYPE_SET, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	iface->change_roles = folks_role_details_real_change_roles;
	iface->change_roles_finish = folks_role_details_real_change_roles_finish;
}

/**
 * This interfaces represents the list of roles a {@link Persona} and
 * {@link Individual} might have.
 *
 * @since 0.4.0
 */
static GType
folks_role_details_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksRoleDetailsIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_role_details_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType folks_role_details_type_id;
	folks_role_details_type_id = g_type_register_static (G_TYPE_INTERFACE, "FolksRoleDetails", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (folks_role_details_type_id, G_TYPE_OBJECT);
	return folks_role_details_type_id;
}

GType
folks_role_details_get_type (void)
{
	static volatile gsize folks_role_details_type_id__once = 0;
	if (g_once_init_enter (&folks_role_details_type_id__once)) {
		GType folks_role_details_type_id;
		folks_role_details_type_id = folks_role_details_get_type_once ();
		g_once_init_leave (&folks_role_details_type_id__once, folks_role_details_type_id);
	}
	return folks_role_details_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

