/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// CustomResourceColumnDefinitionApplyConfiguration represents a declarative configuration of the CustomResourceColumnDefinition type for use
// with apply.
//
// CustomResourceColumnDefinition specifies a column for server side printing.
type CustomResourceColumnDefinitionApplyConfiguration struct {
	// name is a human readable name for the column.
	Name *string `json:"name,omitempty"`
	// type is an OpenAPI type definition for this column.
	// See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for details.
	Type *string `json:"type,omitempty"`
	// format is an optional OpenAPI type definition for this column. The 'name' format is applied
	// to the primary identifier column to assist in clients identifying column is the resource name.
	// See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for details.
	Format *string `json:"format,omitempty"`
	// description is a human readable description of this column.
	Description *string `json:"description,omitempty"`
	// priority is an integer defining the relative importance of this column compared to others. Lower
	// numbers are considered higher priority. Columns that may be omitted in limited space scenarios
	// should be given a priority greater than 0.
	Priority *int32 `json:"priority,omitempty"`
	// jsonPath is a simple JSON path (i.e. with array notation) which is evaluated against
	// each custom resource to produce the value for this column.
	JSONPath *string `json:"jsonPath,omitempty"`
}

// CustomResourceColumnDefinitionApplyConfiguration constructs a declarative configuration of the CustomResourceColumnDefinition type for use with
// apply.
func CustomResourceColumnDefinition() *CustomResourceColumnDefinitionApplyConfiguration {
	return &CustomResourceColumnDefinitionApplyConfiguration{}
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *CustomResourceColumnDefinitionApplyConfiguration) WithName(value string) *CustomResourceColumnDefinitionApplyConfiguration {
	b.Name = &value
	return b
}

// WithType sets the Type field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Type field is set to the value of the last call.
func (b *CustomResourceColumnDefinitionApplyConfiguration) WithType(value string) *CustomResourceColumnDefinitionApplyConfiguration {
	b.Type = &value
	return b
}

// WithFormat sets the Format field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Format field is set to the value of the last call.
func (b *CustomResourceColumnDefinitionApplyConfiguration) WithFormat(value string) *CustomResourceColumnDefinitionApplyConfiguration {
	b.Format = &value
	return b
}

// WithDescription sets the Description field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Description field is set to the value of the last call.
func (b *CustomResourceColumnDefinitionApplyConfiguration) WithDescription(value string) *CustomResourceColumnDefinitionApplyConfiguration {
	b.Description = &value
	return b
}

// WithPriority sets the Priority field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Priority field is set to the value of the last call.
func (b *CustomResourceColumnDefinitionApplyConfiguration) WithPriority(value int32) *CustomResourceColumnDefinitionApplyConfiguration {
	b.Priority = &value
	return b
}

// WithJSONPath sets the JSONPath field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the JSONPath field is set to the value of the last call.
func (b *CustomResourceColumnDefinitionApplyConfiguration) WithJSONPath(value string) *CustomResourceColumnDefinitionApplyConfiguration {
	b.JSONPath = &value
	return b
}
