
/* GENERATED CODE... DO NOT EDIT */

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 *
 * Copyright (C) 2012 Lanedo GmbH
 * Copyright (C) 2012-2022 Aleksander Morgado <aleksander@aleksander.es>
 */


#include <string.h>

#include "qmi-dms.h"
#include "qmi-common.h"
#include "qmi-enum-types.h"
#include "qmi-flag-types.h"
#include "qmi-enum-types-private.h"
#include "qmi-flag-types-private.h"
#include "qmi-flags64-types.h"
#include "qmi-error-types.h"
#include "qmi-device.h"
#include "qmi-helpers.h"

#define QMI_STATUS_SUCCESS 0x0000
#define QMI_STATUS_FAILURE 0x0001


typedef enum {
    QMI_MESSAGE_DMS_RESET = 0x0000,
    QMI_MESSAGE_DMS_SET_EVENT_REPORT = 0x0001,
    QMI_MESSAGE_DMS_GET_CAPABILITIES = 0x0020,
    QMI_MESSAGE_DMS_GET_MANUFACTURER = 0x0021,
    QMI_MESSAGE_DMS_GET_MODEL = 0x0022,
    QMI_MESSAGE_DMS_GET_REVISION = 0x0023,
    QMI_MESSAGE_DMS_GET_MSISDN = 0x0024,
    QMI_MESSAGE_DMS_GET_IDS = 0x0025,
    QMI_MESSAGE_DMS_GET_POWER_STATE = 0x0026,
    QMI_MESSAGE_DMS_UIM_SET_PIN_PROTECTION = 0x0027,
    QMI_MESSAGE_DMS_UIM_VERIFY_PIN = 0x0028,
    QMI_MESSAGE_DMS_UIM_UNBLOCK_PIN = 0x0029,
    QMI_MESSAGE_DMS_UIM_CHANGE_PIN = 0x002A,
    QMI_MESSAGE_DMS_UIM_GET_PIN_STATUS = 0x002B,
    QMI_MESSAGE_DMS_GET_HARDWARE_REVISION = 0x002C,
    QMI_MESSAGE_DMS_GET_OPERATING_MODE = 0x002D,
    QMI_MESSAGE_DMS_SET_OPERATING_MODE = 0x002E,
    QMI_MESSAGE_DMS_GET_TIME = 0x002F,
    QMI_MESSAGE_DMS_GET_PRL_VERSION = 0x0030,
    QMI_MESSAGE_DMS_GET_ACTIVATION_STATE = 0x0031,
    QMI_MESSAGE_DMS_ACTIVATE_AUTOMATIC = 0x0032,
    QMI_MESSAGE_DMS_ACTIVATE_MANUAL = 0x0033,
    QMI_MESSAGE_DMS_GET_USER_LOCK_STATE = 0x0034,
    QMI_MESSAGE_DMS_SET_USER_LOCK_STATE = 0x0035,
    QMI_MESSAGE_DMS_SET_USER_LOCK_CODE = 0x0036,
    QMI_MESSAGE_DMS_READ_USER_DATA = 0x0037,
    QMI_MESSAGE_DMS_WRITE_USER_DATA = 0x0038,
    QMI_MESSAGE_DMS_READ_ERI_FILE = 0x0039,
    QMI_MESSAGE_DMS_RESTORE_FACTORY_DEFAULTS = 0x003A,
    QMI_MESSAGE_DMS_VALIDATE_SERVICE_PROGRAMMING_CODE = 0x003B,
    QMI_MESSAGE_DMS_UIM_GET_ICCID = 0x003C,
    QMI_MESSAGE_DMS_SET_FIRMWARE_ID = 0x003E,
    QMI_MESSAGE_DMS_UIM_GET_CK_STATUS = 0x0040,
    QMI_MESSAGE_DMS_UIM_SET_CK_PROTECTION = 0x0041,
    QMI_MESSAGE_DMS_UIM_UNBLOCK_CK = 0x0042,
    QMI_MESSAGE_DMS_UIM_GET_IMSI = 0x0043,
    QMI_MESSAGE_DMS_UIM_GET_STATE = 0x0044,
    QMI_MESSAGE_DMS_GET_BAND_CAPABILITIES = 0x0045,
    QMI_MESSAGE_DMS_GET_FACTORY_SKU = 0x0046,
    QMI_MESSAGE_DMS_GET_FIRMWARE_PREFERENCE = 0x0047,
    QMI_MESSAGE_DMS_SET_FIRMWARE_PREFERENCE = 0x0048,
    QMI_MESSAGE_DMS_LIST_STORED_IMAGES = 0x0049,
    QMI_MESSAGE_DMS_DELETE_STORED_IMAGE = 0x004A,
    QMI_MESSAGE_DMS_SET_TIME = 0x004B,
    QMI_MESSAGE_DMS_GET_STORED_IMAGE_INFO = 0x004C,
    QMI_MESSAGE_DMS_GET_ALT_NET_CONFIG = 0x004D,
    QMI_MESSAGE_DMS_SET_ALT_NET_CONFIG = 0x004E,
    QMI_MESSAGE_DMS_GET_BOOT_IMAGE_DOWNLOAD_MODE = 0x004F,
    QMI_MESSAGE_DMS_SET_BOOT_IMAGE_DOWNLOAD_MODE = 0x0050,
    QMI_MESSAGE_DMS_GET_SOFTWARE_VERSION = 0x0051,
    QMI_MESSAGE_DMS_SET_SERVICE_PROGRAMMING_CODE = 0x0052,
    QMI_MESSAGE_DMS_GET_MAC_ADDRESS = 0x005C,
    QMI_MESSAGE_DMS_GET_SUPPORTED_MESSAGES = 0x001E,
    QMI_MESSAGE_DMS_HP_CHANGE_DEVICE_MODE = 0x5556, /* vendor 0x03f0 */
    QMI_MESSAGE_DMS_SWI_GET_CURRENT_FIRMWARE = 0x5556, /* vendor 0x1199 */
    QMI_MESSAGE_DMS_SWI_GET_USB_COMPOSITION = 0x555B, /* vendor 0x1199 */
    QMI_MESSAGE_DMS_SWI_SET_USB_COMPOSITION = 0x555C, /* vendor 0x1199 */
    QMI_MESSAGE_DMS_FOXCONN_GET_FIRMWARE_VERSION = 0x555E, /* vendor 0x0489 */
    QMI_MESSAGE_DMS_SET_FCC_AUTHENTICATION = 0x555F,
    QMI_MESSAGE_DMS_FOXCONN_CHANGE_DEVICE_MODE = 0x5562, /* vendor 0x0489 */
    QMI_MESSAGE_DMS_FOXCONN_SET_FCC_AUTHENTICATION = 0x5571, /* vendor 0x0489 */
    QMI_MESSAGE_DMS_FOXCONN_SET_FCC_AUTHENTICATION_V2 = 0x5571, /* vendor 0x0490 */
} QmiMessageDms;


typedef enum {
    QMI_INDICATION_DMS_EVENT_REPORT = 0x0001,
} QmiIndicationDms;


/*****************************************************************************/
/* INDICATION: Qmi Indication DMS Event Report */


/* --- Output -- */

struct _QmiIndicationDmsEventReportOutput {
    volatile gint ref_count;

    /* PRL Init Notification */
    gboolean arg_prl_init_notification_set;
    guint8 arg_prl_init_notification;

    /* Wireless Disable State */
    gboolean arg_wireless_disable_state_set;
    guint8 arg_wireless_disable_state;

    /* UIM State */
    gboolean arg_uim_state_set;
    guint8 arg_uim_state;

    /* Operating Mode */
    gboolean arg_operating_mode_set;
    guint8 arg_operating_mode;

    /* Activation State */
    gboolean arg_activation_state_set;
    guint16 arg_activation_state;

    /* PIN2 Status */
    gboolean arg_pin2_status_set;
    guint8 arg_pin2_status_current_status;
    guint8 arg_pin2_status_verify_retries_left;
    guint8 arg_pin2_status_unblock_retries_left;

    /* PIN1 Status */
    gboolean arg_pin1_status_set;
    guint8 arg_pin1_status_current_status;
    guint8 arg_pin1_status_verify_retries_left;
    guint8 arg_pin1_status_unblock_retries_left;

    /* Power State */
    gboolean arg_power_state_set;
    guint8 arg_power_state_power_state_flags;
    guint8 arg_power_state_battery_level;
};

#define QMI_INDICATION_DMS_EVENT_REPORT_OUTPUT_TLV_PRL_INIT_NOTIFICATION 0x17
#define QMI_INDICATION_DMS_EVENT_REPORT_OUTPUT_TLV_WIRELESS_DISABLE_STATE 0x16
#define QMI_INDICATION_DMS_EVENT_REPORT_OUTPUT_TLV_UIM_STATE 0x15
#define QMI_INDICATION_DMS_EVENT_REPORT_OUTPUT_TLV_OPERATING_MODE 0x14
#define QMI_INDICATION_DMS_EVENT_REPORT_OUTPUT_TLV_ACTIVATION_STATE 0x13
#define QMI_INDICATION_DMS_EVENT_REPORT_OUTPUT_TLV_PIN2_STATUS 0x12
#define QMI_INDICATION_DMS_EVENT_REPORT_OUTPUT_TLV_PIN1_STATUS 0x11
#define QMI_INDICATION_DMS_EVENT_REPORT_OUTPUT_TLV_POWER_STATE 0x10

gboolean
qmi_indication_dms_event_report_output_get_prl_init_notification (
    QmiIndicationDmsEventReportOutput *self,
    gboolean *value_prl_init_notification,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_prl_init_notification_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'PRL Init Notification' was not found in the message");
        return FALSE;
    }

    if (value_prl_init_notification)
        *value_prl_init_notification = (gboolean)(self->arg_prl_init_notification);

    return TRUE;
}

gboolean
qmi_indication_dms_event_report_output_get_wireless_disable_state (
    QmiIndicationDmsEventReportOutput *self,
    gboolean *value_wireless_disable_state,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_wireless_disable_state_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Wireless Disable State' was not found in the message");
        return FALSE;
    }

    if (value_wireless_disable_state)
        *value_wireless_disable_state = (gboolean)(self->arg_wireless_disable_state);

    return TRUE;
}

gboolean
qmi_indication_dms_event_report_output_get_uim_state (
    QmiIndicationDmsEventReportOutput *self,
    QmiDmsUimState *value_uim_state,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_uim_state_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'UIM State' was not found in the message");
        return FALSE;
    }

    if (value_uim_state)
        *value_uim_state = (QmiDmsUimState)(self->arg_uim_state);

    return TRUE;
}

gboolean
qmi_indication_dms_event_report_output_get_operating_mode (
    QmiIndicationDmsEventReportOutput *self,
    QmiDmsOperatingMode *value_operating_mode,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_operating_mode_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Operating Mode' was not found in the message");
        return FALSE;
    }

    if (value_operating_mode)
        *value_operating_mode = (QmiDmsOperatingMode)(self->arg_operating_mode);

    return TRUE;
}

gboolean
qmi_indication_dms_event_report_output_get_activation_state (
    QmiIndicationDmsEventReportOutput *self,
    QmiDmsActivationState *value_activation_state,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_activation_state_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Activation State' was not found in the message");
        return FALSE;
    }

    if (value_activation_state)
        *value_activation_state = (QmiDmsActivationState)(self->arg_activation_state);

    return TRUE;
}

gboolean
qmi_indication_dms_event_report_output_get_pin2_status (
    QmiIndicationDmsEventReportOutput *self,
    QmiDmsUimPinStatus *value_pin2_status_current_status,
    guint8 *value_pin2_status_verify_retries_left,
    guint8 *value_pin2_status_unblock_retries_left,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_pin2_status_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'PIN2 Status' was not found in the message");
        return FALSE;
    }

    if (value_pin2_status_current_status)
        *value_pin2_status_current_status = (QmiDmsUimPinStatus)(self->arg_pin2_status_current_status);
    if (value_pin2_status_verify_retries_left)
        *value_pin2_status_verify_retries_left = self->arg_pin2_status_verify_retries_left;
    if (value_pin2_status_unblock_retries_left)
        *value_pin2_status_unblock_retries_left = self->arg_pin2_status_unblock_retries_left;

    return TRUE;
}

gboolean
qmi_indication_dms_event_report_output_get_pin1_status (
    QmiIndicationDmsEventReportOutput *self,
    QmiDmsUimPinStatus *value_pin1_status_current_status,
    guint8 *value_pin1_status_verify_retries_left,
    guint8 *value_pin1_status_unblock_retries_left,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_pin1_status_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'PIN1 Status' was not found in the message");
        return FALSE;
    }

    if (value_pin1_status_current_status)
        *value_pin1_status_current_status = (QmiDmsUimPinStatus)(self->arg_pin1_status_current_status);
    if (value_pin1_status_verify_retries_left)
        *value_pin1_status_verify_retries_left = self->arg_pin1_status_verify_retries_left;
    if (value_pin1_status_unblock_retries_left)
        *value_pin1_status_unblock_retries_left = self->arg_pin1_status_unblock_retries_left;

    return TRUE;
}

gboolean
qmi_indication_dms_event_report_output_get_power_state (
    QmiIndicationDmsEventReportOutput *self,
    guint8 *value_power_state_power_state_flags,
    guint8 *value_power_state_battery_level,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_power_state_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Power State' was not found in the message");
        return FALSE;
    }

    if (value_power_state_power_state_flags)
        *value_power_state_power_state_flags = self->arg_power_state_power_state_flags;
    if (value_power_state_battery_level)
        *value_power_state_battery_level = self->arg_power_state_battery_level;

    return TRUE;
}

GType
qmi_indication_dms_event_report_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiIndicationDmsEventReportOutput"),
                                          (GBoxedCopyFunc) qmi_indication_dms_event_report_output_ref,
                                          (GBoxedFreeFunc) qmi_indication_dms_event_report_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiIndicationDmsEventReportOutput *
qmi_indication_dms_event_report_output_ref (QmiIndicationDmsEventReportOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_indication_dms_event_report_output_unref (QmiIndicationDmsEventReportOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiIndicationDmsEventReportOutput, self);
    }
}

static gchar *
qmi_indication_dms_event_report_output_prl_init_notification_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_DMS_EVENT_REPORT_OUTPUT_TLV_PRL_INIT_NOTIFICATION, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_dms_event_report_output_wireless_disable_state_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_DMS_EVENT_REPORT_OUTPUT_TLV_WIRELESS_DISABLE_STATE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_dms_event_report_output_uim_state_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_DMS_EVENT_REPORT_OUTPUT_TLV_UIM_STATE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_DMS_UIM_STATE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_dms_uim_state_get_string ((QmiDmsUimState)tmp));
#elif defined  __QMI_DMS_UIM_STATE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_dms_uim_state_build_string_from_mask ((QmiDmsUimState)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiDmsUimState
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_dms_event_report_output_operating_mode_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_DMS_EVENT_REPORT_OUTPUT_TLV_OPERATING_MODE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_DMS_OPERATING_MODE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_dms_operating_mode_get_string ((QmiDmsOperatingMode)tmp));
#elif defined  __QMI_DMS_OPERATING_MODE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_dms_operating_mode_build_string_from_mask ((QmiDmsOperatingMode)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiDmsOperatingMode
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_dms_event_report_output_activation_state_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_DMS_EVENT_REPORT_OUTPUT_TLV_ACTIVATION_STATE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
#if defined  __QMI_DMS_ACTIVATION_STATE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_dms_activation_state_get_string ((QmiDmsActivationState)tmp));
#elif defined  __QMI_DMS_ACTIVATION_STATE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_dms_activation_state_build_string_from_mask ((QmiDmsActivationState)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiDmsActivationState
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_dms_event_report_output_pin2_status_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_DMS_EVENT_REPORT_OUTPUT_TLV_PIN2_STATUS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " current_status = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_DMS_UIM_PIN_STATUS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_dms_uim_pin_status_get_string ((QmiDmsUimPinStatus)tmp));
#elif defined  __QMI_DMS_UIM_PIN_STATUS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_dms_uim_pin_status_build_string_from_mask ((QmiDmsUimPinStatus)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiDmsUimPinStatus
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " verify_retries_left = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " unblock_retries_left = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_dms_event_report_output_pin1_status_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_DMS_EVENT_REPORT_OUTPUT_TLV_PIN1_STATUS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " current_status = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_DMS_UIM_PIN_STATUS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_dms_uim_pin_status_get_string ((QmiDmsUimPinStatus)tmp));
#elif defined  __QMI_DMS_UIM_PIN_STATUS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_dms_uim_pin_status_build_string_from_mask ((QmiDmsUimPinStatus)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiDmsUimPinStatus
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " verify_retries_left = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " unblock_retries_left = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_dms_event_report_output_power_state_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_DMS_EVENT_REPORT_OUTPUT_TLV_POWER_STATE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " power_state_flags = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " battery_level = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct indication_event_report_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
indication_event_report_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct indication_event_report_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    {
        switch (type) {
        case QMI_INDICATION_DMS_EVENT_REPORT_OUTPUT_TLV_PRL_INIT_NOTIFICATION:
            tlv_type_str = "PRL Init Notification";
            translated_value = qmi_indication_dms_event_report_output_prl_init_notification_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_DMS_EVENT_REPORT_OUTPUT_TLV_WIRELESS_DISABLE_STATE:
            tlv_type_str = "Wireless Disable State";
            translated_value = qmi_indication_dms_event_report_output_wireless_disable_state_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_DMS_EVENT_REPORT_OUTPUT_TLV_UIM_STATE:
            tlv_type_str = "UIM State";
            translated_value = qmi_indication_dms_event_report_output_uim_state_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_DMS_EVENT_REPORT_OUTPUT_TLV_OPERATING_MODE:
            tlv_type_str = "Operating Mode";
            translated_value = qmi_indication_dms_event_report_output_operating_mode_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_DMS_EVENT_REPORT_OUTPUT_TLV_ACTIVATION_STATE:
            tlv_type_str = "Activation State";
            translated_value = qmi_indication_dms_event_report_output_activation_state_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_DMS_EVENT_REPORT_OUTPUT_TLV_PIN2_STATUS:
            tlv_type_str = "PIN2 Status";
            translated_value = qmi_indication_dms_event_report_output_pin2_status_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_DMS_EVENT_REPORT_OUTPUT_TLV_PIN1_STATUS:
            tlv_type_str = "PIN1 Status";
            translated_value = qmi_indication_dms_event_report_output_pin1_status_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_DMS_EVENT_REPORT_OUTPUT_TLV_POWER_STATE:
            tlv_type_str = "Power State";
            translated_value = qmi_indication_dms_event_report_output_power_state_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
indication_event_report_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Event Report\" (0x0001)\n",
                            line_prefix);

    {
        struct indication_event_report_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)indication_event_report_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiIndicationDmsEventReportOutput *
qmi_indication_dms_event_report_indication_parse (
    QmiMessage *message,
    GError **error)
{
    QmiIndicationDmsEventReportOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_INDICATION_DMS_EVENT_REPORT);

    self = g_slice_new0 (QmiIndicationDmsEventReportOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_DMS_EVENT_REPORT_OUTPUT_TLV_PRL_INIT_NOTIFICATION, NULL, NULL)) == 0) {
                goto qmi_indication_dms_event_report_output_prl_init_notification_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_dms_event_report_output_prl_init_notification_out;
                self->arg_prl_init_notification = (gboolean)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'PRL Init Notification' TLV", offset);
            }

            self->arg_prl_init_notification_set = TRUE;

qmi_indication_dms_event_report_output_prl_init_notification_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_DMS_EVENT_REPORT_OUTPUT_TLV_WIRELESS_DISABLE_STATE, NULL, NULL)) == 0) {
                goto qmi_indication_dms_event_report_output_wireless_disable_state_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_dms_event_report_output_wireless_disable_state_out;
                self->arg_wireless_disable_state = (gboolean)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Wireless Disable State' TLV", offset);
            }

            self->arg_wireless_disable_state_set = TRUE;

qmi_indication_dms_event_report_output_wireless_disable_state_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_DMS_EVENT_REPORT_OUTPUT_TLV_UIM_STATE, NULL, NULL)) == 0) {
                goto qmi_indication_dms_event_report_output_uim_state_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_dms_event_report_output_uim_state_out;
                self->arg_uim_state = (QmiDmsUimState)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'UIM State' TLV", offset);
            }

            self->arg_uim_state_set = TRUE;

qmi_indication_dms_event_report_output_uim_state_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_DMS_EVENT_REPORT_OUTPUT_TLV_OPERATING_MODE, NULL, NULL)) == 0) {
                goto qmi_indication_dms_event_report_output_operating_mode_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_dms_event_report_output_operating_mode_out;
                self->arg_operating_mode = (QmiDmsOperatingMode)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Operating Mode' TLV", offset);
            }

            self->arg_operating_mode_set = TRUE;

qmi_indication_dms_event_report_output_operating_mode_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_DMS_EVENT_REPORT_OUTPUT_TLV_ACTIVATION_STATE, NULL, NULL)) == 0) {
                goto qmi_indication_dms_event_report_output_activation_state_out;
            }
            {
                guint16 tmp;

                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, NULL))
                    goto qmi_indication_dms_event_report_output_activation_state_out;
                self->arg_activation_state = (QmiDmsActivationState)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Activation State' TLV", offset);
            }

            self->arg_activation_state_set = TRUE;

qmi_indication_dms_event_report_output_activation_state_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_DMS_EVENT_REPORT_OUTPUT_TLV_PIN2_STATUS, NULL, NULL)) == 0) {
                goto qmi_indication_dms_event_report_output_pin2_status_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_dms_event_report_output_pin2_status_out;
                self->arg_pin2_status_current_status = (QmiDmsUimPinStatus)tmp;
            }
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_pin2_status_verify_retries_left), NULL))
                goto qmi_indication_dms_event_report_output_pin2_status_out;
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_pin2_status_unblock_retries_left), NULL))
                goto qmi_indication_dms_event_report_output_pin2_status_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'PIN2 Status' TLV", offset);
            }

            self->arg_pin2_status_set = TRUE;

qmi_indication_dms_event_report_output_pin2_status_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_DMS_EVENT_REPORT_OUTPUT_TLV_PIN1_STATUS, NULL, NULL)) == 0) {
                goto qmi_indication_dms_event_report_output_pin1_status_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_dms_event_report_output_pin1_status_out;
                self->arg_pin1_status_current_status = (QmiDmsUimPinStatus)tmp;
            }
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_pin1_status_verify_retries_left), NULL))
                goto qmi_indication_dms_event_report_output_pin1_status_out;
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_pin1_status_unblock_retries_left), NULL))
                goto qmi_indication_dms_event_report_output_pin1_status_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'PIN1 Status' TLV", offset);
            }

            self->arg_pin1_status_set = TRUE;

qmi_indication_dms_event_report_output_pin1_status_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_DMS_EVENT_REPORT_OUTPUT_TLV_POWER_STATE, NULL, NULL)) == 0) {
                goto qmi_indication_dms_event_report_output_power_state_out;
            }
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_power_state_power_state_flags), NULL))
                goto qmi_indication_dms_event_report_output_power_state_out;
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_power_state_battery_level), NULL))
                goto qmi_indication_dms_event_report_output_power_state_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Power State' TLV", offset);
            }

            self->arg_power_state_set = TRUE;

qmi_indication_dms_event_report_output_power_state_out:
            ;

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS Reset */


/* --- Input -- */

/* Note: no fields in the Input container */

static QmiMessage *
__qmi_message_dms_reset_request_create (
    guint16 transaction_id,
    guint8 cid,
    gpointer unused,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_RESET);

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsResetOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;
};

#define QMI_MESSAGE_DMS_RESET_OUTPUT_TLV_RESULT 0x02

gboolean
qmi_message_dms_reset_output_get_result (
    QmiMessageDmsResetOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

GType
qmi_message_dms_reset_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsResetOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_reset_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_reset_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsResetOutput *
qmi_message_dms_reset_output_ref (QmiMessageDmsResetOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_reset_output_unref (QmiMessageDmsResetOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsResetOutput, self);
    }
}

static gboolean
qmi_message_result_validate (
    const guint8 *buffer,
    guint16 buffer_len)
{
    static const guint expected_len = 4;

    if (buffer_len < expected_len) {
        g_warning ("Cannot read the 'Result' TLV: expected '%u' bytes, but only got '%u' bytes",
                   expected_len, buffer_len);
        return FALSE;
    }

    return TRUE;
}

static gchar *
qmi_message_result_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    guint16 error_status;
    guint16 error_code;

    if ((init_offset = qmi_message_tlv_read_init (self, QMI_MESSAGE_DMS_RESET_OUTPUT_TLV_RESULT, NULL, NULL)) == 0)
        return NULL;
    if (!qmi_message_tlv_read_guint16 (self, init_offset, &offset, QMI_ENDIAN_LITTLE, &error_status, NULL))
        return NULL;
    if (!qmi_message_tlv_read_guint16 (self, init_offset, &offset, QMI_ENDIAN_LITTLE, &error_code, NULL))
        return NULL;
    g_warn_if_fail (qmi_message_tlv_read_remaining_size (self, init_offset, offset) == 0);

    if (error_status == QMI_STATUS_SUCCESS)
        return g_strdup ("SUCCESS");

    return g_strdup_printf ("FAILURE: %s", qmi_protocol_error_get_string ((QmiProtocolError) error_code));
}

struct message_reset_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_reset_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_reset_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_RESET_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_reset_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Reset\" (0x0000)\n",
                            line_prefix);

    {
        struct message_reset_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_reset_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsResetOutput *
qmi_message_dms_reset_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsResetOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_RESET);

    self = g_slice_new0 (QmiMessageDmsResetOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_RESET_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_reset_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_reset_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS Set Event Report */


/* --- Input -- */

struct _QmiMessageDmsSetEventReportInput {
    volatile gint ref_count;

    /* PRL Init Reporting */
    gboolean arg_prl_init_reporting_set;
    guint8 arg_prl_init_reporting;

    /* Wireless Disable State Reporting */
    gboolean arg_wireless_disable_state_reporting_set;
    guint8 arg_wireless_disable_state_reporting;

    /* UIM State Reporting */
    gboolean arg_uim_state_reporting_set;
    guint8 arg_uim_state_reporting;

    /* Operating Mode Reporting */
    gboolean arg_operating_mode_reporting_set;
    guint8 arg_operating_mode_reporting;

    /* Activation State Reporting */
    gboolean arg_activation_state_reporting_set;
    guint8 arg_activation_state_reporting;

    /* PIN State Reporting */
    gboolean arg_pin_state_reporting_set;
    guint8 arg_pin_state_reporting;

    /* Battery Level Report Limits */
    gboolean arg_battery_level_report_limits_set;
    guint8 arg_battery_level_report_limits_lower_limit;
    guint8 arg_battery_level_report_limits_upper_limit;

    /* Power State Reporting */
    gboolean arg_power_state_reporting_set;
    guint8 arg_power_state_reporting;
};

#define QMI_MESSAGE_DMS_SET_EVENT_REPORT_INPUT_TLV_PRL_INIT_REPORTING 0x17
#define QMI_MESSAGE_DMS_SET_EVENT_REPORT_INPUT_TLV_WIRELESS_DISABLE_STATE_REPORTING 0x16
#define QMI_MESSAGE_DMS_SET_EVENT_REPORT_INPUT_TLV_UIM_STATE_REPORTING 0x15
#define QMI_MESSAGE_DMS_SET_EVENT_REPORT_INPUT_TLV_OPERATING_MODE_REPORTING 0x14
#define QMI_MESSAGE_DMS_SET_EVENT_REPORT_INPUT_TLV_ACTIVATION_STATE_REPORTING 0x13
#define QMI_MESSAGE_DMS_SET_EVENT_REPORT_INPUT_TLV_PIN_STATE_REPORTING 0x12
#define QMI_MESSAGE_DMS_SET_EVENT_REPORT_INPUT_TLV_BATTERY_LEVEL_REPORT_LIMITS 0x11
#define QMI_MESSAGE_DMS_SET_EVENT_REPORT_INPUT_TLV_POWER_STATE_REPORTING 0x10

gboolean
qmi_message_dms_set_event_report_input_get_prl_init_reporting (
    QmiMessageDmsSetEventReportInput *self,
    gboolean *value_prl_init_reporting,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_prl_init_reporting_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'PRL Init Reporting' was not found in the message");
        return FALSE;
    }

    if (value_prl_init_reporting)
        *value_prl_init_reporting = (gboolean)(self->arg_prl_init_reporting);

    return TRUE;
}

gboolean
qmi_message_dms_set_event_report_input_set_prl_init_reporting (
    QmiMessageDmsSetEventReportInput *self,
    gboolean value_prl_init_reporting,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_prl_init_reporting = (guint8)(value_prl_init_reporting);
    self->arg_prl_init_reporting_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_dms_set_event_report_input_get_wireless_disable_state_reporting (
    QmiMessageDmsSetEventReportInput *self,
    gboolean *value_wireless_disable_state_reporting,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_wireless_disable_state_reporting_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Wireless Disable State Reporting' was not found in the message");
        return FALSE;
    }

    if (value_wireless_disable_state_reporting)
        *value_wireless_disable_state_reporting = (gboolean)(self->arg_wireless_disable_state_reporting);

    return TRUE;
}

gboolean
qmi_message_dms_set_event_report_input_set_wireless_disable_state_reporting (
    QmiMessageDmsSetEventReportInput *self,
    gboolean value_wireless_disable_state_reporting,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_wireless_disable_state_reporting = (guint8)(value_wireless_disable_state_reporting);
    self->arg_wireless_disable_state_reporting_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_dms_set_event_report_input_get_uim_state_reporting (
    QmiMessageDmsSetEventReportInput *self,
    gboolean *value_uim_state_reporting,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_uim_state_reporting_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'UIM State Reporting' was not found in the message");
        return FALSE;
    }

    if (value_uim_state_reporting)
        *value_uim_state_reporting = (gboolean)(self->arg_uim_state_reporting);

    return TRUE;
}

gboolean
qmi_message_dms_set_event_report_input_set_uim_state_reporting (
    QmiMessageDmsSetEventReportInput *self,
    gboolean value_uim_state_reporting,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_uim_state_reporting = (guint8)(value_uim_state_reporting);
    self->arg_uim_state_reporting_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_dms_set_event_report_input_get_operating_mode_reporting (
    QmiMessageDmsSetEventReportInput *self,
    gboolean *value_operating_mode_reporting,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_operating_mode_reporting_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Operating Mode Reporting' was not found in the message");
        return FALSE;
    }

    if (value_operating_mode_reporting)
        *value_operating_mode_reporting = (gboolean)(self->arg_operating_mode_reporting);

    return TRUE;
}

gboolean
qmi_message_dms_set_event_report_input_set_operating_mode_reporting (
    QmiMessageDmsSetEventReportInput *self,
    gboolean value_operating_mode_reporting,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_operating_mode_reporting = (guint8)(value_operating_mode_reporting);
    self->arg_operating_mode_reporting_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_dms_set_event_report_input_get_activation_state_reporting (
    QmiMessageDmsSetEventReportInput *self,
    gboolean *value_activation_state_reporting,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_activation_state_reporting_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Activation State Reporting' was not found in the message");
        return FALSE;
    }

    if (value_activation_state_reporting)
        *value_activation_state_reporting = (gboolean)(self->arg_activation_state_reporting);

    return TRUE;
}

gboolean
qmi_message_dms_set_event_report_input_set_activation_state_reporting (
    QmiMessageDmsSetEventReportInput *self,
    gboolean value_activation_state_reporting,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_activation_state_reporting = (guint8)(value_activation_state_reporting);
    self->arg_activation_state_reporting_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_dms_set_event_report_input_get_pin_state_reporting (
    QmiMessageDmsSetEventReportInput *self,
    gboolean *value_pin_state_reporting,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_pin_state_reporting_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'PIN State Reporting' was not found in the message");
        return FALSE;
    }

    if (value_pin_state_reporting)
        *value_pin_state_reporting = (gboolean)(self->arg_pin_state_reporting);

    return TRUE;
}

gboolean
qmi_message_dms_set_event_report_input_set_pin_state_reporting (
    QmiMessageDmsSetEventReportInput *self,
    gboolean value_pin_state_reporting,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_pin_state_reporting = (guint8)(value_pin_state_reporting);
    self->arg_pin_state_reporting_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_dms_set_event_report_input_get_battery_level_report_limits (
    QmiMessageDmsSetEventReportInput *self,
    guint8 *value_battery_level_report_limits_lower_limit,
    guint8 *value_battery_level_report_limits_upper_limit,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_battery_level_report_limits_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Battery Level Report Limits' was not found in the message");
        return FALSE;
    }

    if (value_battery_level_report_limits_lower_limit)
        *value_battery_level_report_limits_lower_limit = self->arg_battery_level_report_limits_lower_limit;
    if (value_battery_level_report_limits_upper_limit)
        *value_battery_level_report_limits_upper_limit = self->arg_battery_level_report_limits_upper_limit;

    return TRUE;
}

gboolean
qmi_message_dms_set_event_report_input_set_battery_level_report_limits (
    QmiMessageDmsSetEventReportInput *self,
    guint8 value_battery_level_report_limits_lower_limit,
    guint8 value_battery_level_report_limits_upper_limit,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_battery_level_report_limits_lower_limit = value_battery_level_report_limits_lower_limit;
    self->arg_battery_level_report_limits_upper_limit = value_battery_level_report_limits_upper_limit;
    self->arg_battery_level_report_limits_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_dms_set_event_report_input_get_power_state_reporting (
    QmiMessageDmsSetEventReportInput *self,
    gboolean *value_power_state_reporting,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_power_state_reporting_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Power State Reporting' was not found in the message");
        return FALSE;
    }

    if (value_power_state_reporting)
        *value_power_state_reporting = (gboolean)(self->arg_power_state_reporting);

    return TRUE;
}

gboolean
qmi_message_dms_set_event_report_input_set_power_state_reporting (
    QmiMessageDmsSetEventReportInput *self,
    gboolean value_power_state_reporting,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_power_state_reporting = (guint8)(value_power_state_reporting);
    self->arg_power_state_reporting_set = TRUE;

    return TRUE;
}

GType
qmi_message_dms_set_event_report_input_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsSetEventReportInput"),
                                          (GBoxedCopyFunc) qmi_message_dms_set_event_report_input_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_set_event_report_input_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsSetEventReportInput *
qmi_message_dms_set_event_report_input_ref (QmiMessageDmsSetEventReportInput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_set_event_report_input_unref (QmiMessageDmsSetEventReportInput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsSetEventReportInput, self);
    }
}

QmiMessageDmsSetEventReportInput *
qmi_message_dms_set_event_report_input_new (void)
{
    QmiMessageDmsSetEventReportInput *self;

    self = g_slice_new0 (QmiMessageDmsSetEventReportInput);
    self->ref_count = 1;
    return self;
}

static QmiMessage *
__qmi_message_dms_set_event_report_request_create (
    guint16 transaction_id,
    guint8 cid,
    QmiMessageDmsSetEventReportInput *input,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_SET_EVENT_REPORT);

    /* All TLVs are optional, we allow NULL input */
    if (!input)
        return g_steal_pointer (&self);

    /* Try to add the 'PRL Init Reporting' TLV */
    if (input->arg_prl_init_reporting_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_DMS_SET_EVENT_REPORT_INPUT_TLV_PRL_INIT_REPORTING, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'PRL Init Reporting': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_prl_init_reporting;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'PRL Init Reporting': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'PRL Init Reporting': ");
            return NULL;
        }
    }

    /* Try to add the 'Wireless Disable State Reporting' TLV */
    if (input->arg_wireless_disable_state_reporting_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_DMS_SET_EVENT_REPORT_INPUT_TLV_WIRELESS_DISABLE_STATE_REPORTING, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Wireless Disable State Reporting': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_wireless_disable_state_reporting;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Wireless Disable State Reporting': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Wireless Disable State Reporting': ");
            return NULL;
        }
    }

    /* Try to add the 'UIM State Reporting' TLV */
    if (input->arg_uim_state_reporting_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_DMS_SET_EVENT_REPORT_INPUT_TLV_UIM_STATE_REPORTING, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'UIM State Reporting': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_uim_state_reporting;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'UIM State Reporting': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'UIM State Reporting': ");
            return NULL;
        }
    }

    /* Try to add the 'Operating Mode Reporting' TLV */
    if (input->arg_operating_mode_reporting_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_DMS_SET_EVENT_REPORT_INPUT_TLV_OPERATING_MODE_REPORTING, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Operating Mode Reporting': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_operating_mode_reporting;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Operating Mode Reporting': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Operating Mode Reporting': ");
            return NULL;
        }
    }

    /* Try to add the 'Activation State Reporting' TLV */
    if (input->arg_activation_state_reporting_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_DMS_SET_EVENT_REPORT_INPUT_TLV_ACTIVATION_STATE_REPORTING, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Activation State Reporting': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_activation_state_reporting;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Activation State Reporting': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Activation State Reporting': ");
            return NULL;
        }
    }

    /* Try to add the 'PIN State Reporting' TLV */
    if (input->arg_pin_state_reporting_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_DMS_SET_EVENT_REPORT_INPUT_TLV_PIN_STATE_REPORTING, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'PIN State Reporting': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_pin_state_reporting;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'PIN State Reporting': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'PIN State Reporting': ");
            return NULL;
        }
    }

    /* Try to add the 'Battery Level Report Limits' TLV */
    if (input->arg_battery_level_report_limits_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_DMS_SET_EVENT_REPORT_INPUT_TLV_BATTERY_LEVEL_REPORT_LIMITS, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Battery Level Report Limits': ");
            return NULL;
        }

        /* Write the guint8 variable to the buffer */
        if (!qmi_message_tlv_write_guint8 (self, input->arg_battery_level_report_limits_lower_limit, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'Battery Level Report Limits': ");
            return NULL;
        }
        /* Write the guint8 variable to the buffer */
        if (!qmi_message_tlv_write_guint8 (self, input->arg_battery_level_report_limits_upper_limit, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'Battery Level Report Limits': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Battery Level Report Limits': ");
            return NULL;
        }
    }

    /* Try to add the 'Power State Reporting' TLV */
    if (input->arg_power_state_reporting_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_DMS_SET_EVENT_REPORT_INPUT_TLV_POWER_STATE_REPORTING, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Power State Reporting': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_power_state_reporting;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Power State Reporting': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Power State Reporting': ");
            return NULL;
        }
    }

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsSetEventReportOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;
};

#define QMI_MESSAGE_DMS_SET_EVENT_REPORT_OUTPUT_TLV_RESULT 0x02

gboolean
qmi_message_dms_set_event_report_output_get_result (
    QmiMessageDmsSetEventReportOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

GType
qmi_message_dms_set_event_report_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsSetEventReportOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_set_event_report_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_set_event_report_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsSetEventReportOutput *
qmi_message_dms_set_event_report_output_ref (QmiMessageDmsSetEventReportOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_set_event_report_output_unref (QmiMessageDmsSetEventReportOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsSetEventReportOutput, self);
    }
}

static gchar *
qmi_message_dms_set_event_report_input_prl_init_reporting_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SET_EVENT_REPORT_INPUT_TLV_PRL_INIT_REPORTING, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_set_event_report_input_wireless_disable_state_reporting_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SET_EVENT_REPORT_INPUT_TLV_WIRELESS_DISABLE_STATE_REPORTING, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_set_event_report_input_uim_state_reporting_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SET_EVENT_REPORT_INPUT_TLV_UIM_STATE_REPORTING, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_set_event_report_input_operating_mode_reporting_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SET_EVENT_REPORT_INPUT_TLV_OPERATING_MODE_REPORTING, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_set_event_report_input_activation_state_reporting_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SET_EVENT_REPORT_INPUT_TLV_ACTIVATION_STATE_REPORTING, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_set_event_report_input_pin_state_reporting_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SET_EVENT_REPORT_INPUT_TLV_PIN_STATE_REPORTING, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_set_event_report_input_battery_level_report_limits_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SET_EVENT_REPORT_INPUT_TLV_BATTERY_LEVEL_REPORT_LIMITS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " lower_limit = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " upper_limit = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_set_event_report_input_power_state_reporting_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SET_EVENT_REPORT_INPUT_TLV_POWER_STATE_REPORTING, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_set_event_report_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_set_event_report_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_set_event_report_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        case QMI_MESSAGE_DMS_SET_EVENT_REPORT_INPUT_TLV_PRL_INIT_REPORTING:
            tlv_type_str = "PRL Init Reporting";
            translated_value = qmi_message_dms_set_event_report_input_prl_init_reporting_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_SET_EVENT_REPORT_INPUT_TLV_WIRELESS_DISABLE_STATE_REPORTING:
            tlv_type_str = "Wireless Disable State Reporting";
            translated_value = qmi_message_dms_set_event_report_input_wireless_disable_state_reporting_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_SET_EVENT_REPORT_INPUT_TLV_UIM_STATE_REPORTING:
            tlv_type_str = "UIM State Reporting";
            translated_value = qmi_message_dms_set_event_report_input_uim_state_reporting_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_SET_EVENT_REPORT_INPUT_TLV_OPERATING_MODE_REPORTING:
            tlv_type_str = "Operating Mode Reporting";
            translated_value = qmi_message_dms_set_event_report_input_operating_mode_reporting_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_SET_EVENT_REPORT_INPUT_TLV_ACTIVATION_STATE_REPORTING:
            tlv_type_str = "Activation State Reporting";
            translated_value = qmi_message_dms_set_event_report_input_activation_state_reporting_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_SET_EVENT_REPORT_INPUT_TLV_PIN_STATE_REPORTING:
            tlv_type_str = "PIN State Reporting";
            translated_value = qmi_message_dms_set_event_report_input_pin_state_reporting_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_SET_EVENT_REPORT_INPUT_TLV_BATTERY_LEVEL_REPORT_LIMITS:
            tlv_type_str = "Battery Level Report Limits";
            translated_value = qmi_message_dms_set_event_report_input_battery_level_report_limits_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_SET_EVENT_REPORT_INPUT_TLV_POWER_STATE_REPORTING:
            tlv_type_str = "Power State Reporting";
            translated_value = qmi_message_dms_set_event_report_input_power_state_reporting_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_SET_EVENT_REPORT_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_set_event_report_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Set Event Report\" (0x0001)\n",
                            line_prefix);

    {
        struct message_set_event_report_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_set_event_report_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsSetEventReportOutput *
qmi_message_dms_set_event_report_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsSetEventReportOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_SET_EVENT_REPORT);

    self = g_slice_new0 (QmiMessageDmsSetEventReportOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SET_EVENT_REPORT_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_set_event_report_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_set_event_report_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS Get Capabilities */


/* --- Input -- */

/* Note: no fields in the Input container */

static QmiMessage *
__qmi_message_dms_get_capabilities_request_create (
    guint16 transaction_id,
    guint8 cid,
    gpointer unused,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_GET_CAPABILITIES);

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsGetCapabilitiesOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* Info */
    gboolean arg_info_set;
    guint32 arg_info_max_tx_channel_rate;
    guint32 arg_info_max_rx_channel_rate;
    guint8 arg_info_data_service_capability;
    guint8 arg_info_sim_capability;
    GArray *arg_info_radio_interface_list;
};

#define QMI_MESSAGE_DMS_GET_CAPABILITIES_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_DMS_GET_CAPABILITIES_OUTPUT_TLV_INFO 0x01

gboolean
qmi_message_dms_get_capabilities_output_get_result (
    QmiMessageDmsGetCapabilitiesOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_dms_get_capabilities_output_get_info (
    QmiMessageDmsGetCapabilitiesOutput *self,
    guint32 *value_info_max_tx_channel_rate,
    guint32 *value_info_max_rx_channel_rate,
    QmiDmsDataServiceCapability *value_info_data_service_capability,
    QmiDmsSimCapability *value_info_sim_capability,
    GArray **value_info_radio_interface_list,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_info_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Info' was not found in the message");
        return FALSE;
    }

    if (value_info_max_tx_channel_rate)
        *value_info_max_tx_channel_rate = self->arg_info_max_tx_channel_rate;
    if (value_info_max_rx_channel_rate)
        *value_info_max_rx_channel_rate = self->arg_info_max_rx_channel_rate;
    if (value_info_data_service_capability)
        *value_info_data_service_capability = (QmiDmsDataServiceCapability)(self->arg_info_data_service_capability);
    if (value_info_sim_capability)
        *value_info_sim_capability = (QmiDmsSimCapability)(self->arg_info_sim_capability);
    if (value_info_radio_interface_list)
        *value_info_radio_interface_list = self->arg_info_radio_interface_list;

    return TRUE;
}

GType
qmi_message_dms_get_capabilities_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsGetCapabilitiesOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_get_capabilities_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_get_capabilities_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsGetCapabilitiesOutput *
qmi_message_dms_get_capabilities_output_ref (QmiMessageDmsGetCapabilitiesOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_get_capabilities_output_unref (QmiMessageDmsGetCapabilitiesOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_info_radio_interface_list, (GDestroyNotify)g_array_unref);
        g_slice_free (QmiMessageDmsGetCapabilitiesOutput, self);
    }
}

static gchar *
qmi_message_dms_get_capabilities_output_info_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_CAPABILITIES_OUTPUT_TLV_INFO, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " max_tx_channel_rate = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " max_rx_channel_rate = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " data_service_capability = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_DMS_DATA_SERVICE_CAPABILITY_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_dms_data_service_capability_get_string ((QmiDmsDataServiceCapability)tmp));
#elif defined  __QMI_DMS_DATA_SERVICE_CAPABILITY_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_dms_data_service_capability_build_string_from_mask ((QmiDmsDataServiceCapability)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiDmsDataServiceCapability
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " sim_capability = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_DMS_SIM_CAPABILITY_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_dms_sim_capability_get_string ((QmiDmsSimCapability)tmp));
#elif defined  __QMI_DMS_SIM_CAPABILITY_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_dms_sim_capability_build_string_from_mask ((QmiDmsSimCapability)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiDmsSimCapability
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " radio_interface_list = '");
    {
        guint radio_interface_list_i;
        guint8 radio_interface_list_n_items;

        /* Read number of items in the array */
        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(radio_interface_list_n_items), &error))
            goto out;

        g_string_append (printable, "{");

        for (radio_interface_list_i = 0; radio_interface_list_i < radio_interface_list_n_items; radio_interface_list_i++) {
            g_string_append_printf (printable, " [%u] = '", radio_interface_list_i);

            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
#if defined  __QMI_DMS_RADIO_INTERFACE_IS_ENUM__
                    g_string_append_printf (printable, "%s", qmi_dms_radio_interface_get_string ((QmiDmsRadioInterface)tmp));
#elif defined  __QMI_DMS_RADIO_INTERFACE_IS_FLAGS__
                    {
                        g_autofree gchar *flags_str = NULL;

                        flags_str = qmi_dms_radio_interface_build_string_from_mask ((QmiDmsRadioInterface)tmp);
                        g_string_append_printf (printable, "%s", flags_str);
                    }
#else
# error unexpected public format: QmiDmsRadioInterface
#endif
                }
            }
            g_string_append (printable, "'");
        }

        g_string_append (printable, "}");
    }    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_get_capabilities_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_get_capabilities_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_get_capabilities_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_GET_CAPABILITIES_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_GET_CAPABILITIES_OUTPUT_TLV_INFO:
            tlv_type_str = "Info";
            translated_value = qmi_message_dms_get_capabilities_output_info_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_get_capabilities_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Get Capabilities\" (0x0020)\n",
                            line_prefix);

    {
        struct message_get_capabilities_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_get_capabilities_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsGetCapabilitiesOutput *
qmi_message_dms_get_capabilities_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsGetCapabilitiesOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_GET_CAPABILITIES);

    self = g_slice_new0 (QmiMessageDmsGetCapabilitiesOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_CAPABILITIES_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_get_capabilities_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_get_capabilities_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_CAPABILITIES_OUTPUT_TLV_INFO, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Info TLV: ");
                qmi_message_dms_get_capabilities_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_info_max_tx_channel_rate), error))
                goto qmi_message_dms_get_capabilities_output_info_out;
            if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_info_max_rx_channel_rate), error))
                goto qmi_message_dms_get_capabilities_output_info_out;
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, error))
                    goto qmi_message_dms_get_capabilities_output_info_out;
                self->arg_info_data_service_capability = (QmiDmsDataServiceCapability)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, error))
                    goto qmi_message_dms_get_capabilities_output_info_out;
                self->arg_info_sim_capability = (QmiDmsSimCapability)tmp;
            }
            {
                guint radio_interface_list_i;
                guint8 radio_interface_list_n_items;

                /* Read number of items in the array */
                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(radio_interface_list_n_items), error))
                    goto qmi_message_dms_get_capabilities_output_info_out;

                self->arg_info_radio_interface_list = g_array_sized_new (
                    FALSE,
                    FALSE,
                    sizeof (QmiDmsRadioInterface),
                    (guint)radio_interface_list_n_items);

                for (radio_interface_list_i = 0; radio_interface_list_i < radio_interface_list_n_items; radio_interface_list_i++) {
                    QmiDmsRadioInterface radio_interface_list_aux;

                    {
                        guint8 tmp;

                        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, error))
                            goto qmi_message_dms_get_capabilities_output_info_out;
                        radio_interface_list_aux = (QmiDmsRadioInterface)tmp;
                    }
                    g_array_insert_val (self->arg_info_radio_interface_list, radio_interface_list_i, radio_interface_list_aux);
                }
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Info' TLV", offset);
            }

            self->arg_info_set = TRUE;

qmi_message_dms_get_capabilities_output_info_out:
            if (!self->arg_info_set) {
                qmi_message_dms_get_capabilities_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS Get Manufacturer */


/* --- Input -- */

/* Note: no fields in the Input container */

static QmiMessage *
__qmi_message_dms_get_manufacturer_request_create (
    guint16 transaction_id,
    guint8 cid,
    gpointer unused,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_GET_MANUFACTURER);

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsGetManufacturerOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* Manufacturer */
    gboolean arg_manufacturer_set;
    gchar *arg_manufacturer;
};

#define QMI_MESSAGE_DMS_GET_MANUFACTURER_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_DMS_GET_MANUFACTURER_OUTPUT_TLV_MANUFACTURER 0x01

gboolean
qmi_message_dms_get_manufacturer_output_get_result (
    QmiMessageDmsGetManufacturerOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_dms_get_manufacturer_output_get_manufacturer (
    QmiMessageDmsGetManufacturerOutput *self,
    const gchar **value_manufacturer,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_manufacturer_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Manufacturer' was not found in the message");
        return FALSE;
    }

    if (value_manufacturer)
        *value_manufacturer = self->arg_manufacturer;

    return TRUE;
}

GType
qmi_message_dms_get_manufacturer_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsGetManufacturerOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_get_manufacturer_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_get_manufacturer_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsGetManufacturerOutput *
qmi_message_dms_get_manufacturer_output_ref (QmiMessageDmsGetManufacturerOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_get_manufacturer_output_unref (QmiMessageDmsGetManufacturerOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_manufacturer, (GDestroyNotify)g_free);
        g_slice_free (QmiMessageDmsGetManufacturerOutput, self);
    }
}

static gchar *
qmi_message_dms_get_manufacturer_output_manufacturer_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_MANUFACTURER_OUTPUT_TLV_MANUFACTURER, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &tmp, &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_get_manufacturer_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_get_manufacturer_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_get_manufacturer_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_GET_MANUFACTURER_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_GET_MANUFACTURER_OUTPUT_TLV_MANUFACTURER:
            tlv_type_str = "Manufacturer";
            translated_value = qmi_message_dms_get_manufacturer_output_manufacturer_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_get_manufacturer_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Get Manufacturer\" (0x0021)\n",
                            line_prefix);

    {
        struct message_get_manufacturer_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_get_manufacturer_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsGetManufacturerOutput *
qmi_message_dms_get_manufacturer_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsGetManufacturerOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_GET_MANUFACTURER);

    self = g_slice_new0 (QmiMessageDmsGetManufacturerOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_MANUFACTURER_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_get_manufacturer_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_get_manufacturer_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_MANUFACTURER_OUTPUT_TLV_MANUFACTURER, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Manufacturer TLV: ");
                qmi_message_dms_get_manufacturer_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &(self->arg_manufacturer), error))
                goto qmi_message_dms_get_manufacturer_output_manufacturer_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Manufacturer' TLV", offset);
            }

            self->arg_manufacturer_set = TRUE;

qmi_message_dms_get_manufacturer_output_manufacturer_out:
            if (!self->arg_manufacturer_set) {
                qmi_message_dms_get_manufacturer_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS Get Model */


/* --- Input -- */

/* Note: no fields in the Input container */

static QmiMessage *
__qmi_message_dms_get_model_request_create (
    guint16 transaction_id,
    guint8 cid,
    gpointer unused,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_GET_MODEL);

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsGetModelOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* Model */
    gboolean arg_model_set;
    gchar *arg_model;
};

#define QMI_MESSAGE_DMS_GET_MODEL_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_DMS_GET_MODEL_OUTPUT_TLV_MODEL 0x01

gboolean
qmi_message_dms_get_model_output_get_result (
    QmiMessageDmsGetModelOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_dms_get_model_output_get_model (
    QmiMessageDmsGetModelOutput *self,
    const gchar **value_model,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_model_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Model' was not found in the message");
        return FALSE;
    }

    if (value_model)
        *value_model = self->arg_model;

    return TRUE;
}

GType
qmi_message_dms_get_model_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsGetModelOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_get_model_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_get_model_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsGetModelOutput *
qmi_message_dms_get_model_output_ref (QmiMessageDmsGetModelOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_get_model_output_unref (QmiMessageDmsGetModelOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_model, (GDestroyNotify)g_free);
        g_slice_free (QmiMessageDmsGetModelOutput, self);
    }
}

static gchar *
qmi_message_dms_get_model_output_model_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_MODEL_OUTPUT_TLV_MODEL, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &tmp, &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_get_model_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_get_model_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_get_model_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_GET_MODEL_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_GET_MODEL_OUTPUT_TLV_MODEL:
            tlv_type_str = "Model";
            translated_value = qmi_message_dms_get_model_output_model_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_get_model_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Get Model\" (0x0022)\n",
                            line_prefix);

    {
        struct message_get_model_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_get_model_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsGetModelOutput *
qmi_message_dms_get_model_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsGetModelOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_GET_MODEL);

    self = g_slice_new0 (QmiMessageDmsGetModelOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_MODEL_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_get_model_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_get_model_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_MODEL_OUTPUT_TLV_MODEL, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Model TLV: ");
                qmi_message_dms_get_model_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &(self->arg_model), error))
                goto qmi_message_dms_get_model_output_model_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Model' TLV", offset);
            }

            self->arg_model_set = TRUE;

qmi_message_dms_get_model_output_model_out:
            if (!self->arg_model_set) {
                qmi_message_dms_get_model_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS Get Revision */


/* --- Input -- */

/* Note: no fields in the Input container */

static QmiMessage *
__qmi_message_dms_get_revision_request_create (
    guint16 transaction_id,
    guint8 cid,
    gpointer unused,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_GET_REVISION);

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsGetRevisionOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* Revision */
    gboolean arg_revision_set;
    gchar *arg_revision;
};

#define QMI_MESSAGE_DMS_GET_REVISION_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_DMS_GET_REVISION_OUTPUT_TLV_REVISION 0x01

gboolean
qmi_message_dms_get_revision_output_get_result (
    QmiMessageDmsGetRevisionOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_dms_get_revision_output_get_revision (
    QmiMessageDmsGetRevisionOutput *self,
    const gchar **value_revision,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_revision_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Revision' was not found in the message");
        return FALSE;
    }

    if (value_revision)
        *value_revision = self->arg_revision;

    return TRUE;
}

GType
qmi_message_dms_get_revision_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsGetRevisionOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_get_revision_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_get_revision_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsGetRevisionOutput *
qmi_message_dms_get_revision_output_ref (QmiMessageDmsGetRevisionOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_get_revision_output_unref (QmiMessageDmsGetRevisionOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_revision, (GDestroyNotify)g_free);
        g_slice_free (QmiMessageDmsGetRevisionOutput, self);
    }
}

static gchar *
qmi_message_dms_get_revision_output_revision_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_REVISION_OUTPUT_TLV_REVISION, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &tmp, &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_get_revision_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_get_revision_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_get_revision_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_GET_REVISION_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_GET_REVISION_OUTPUT_TLV_REVISION:
            tlv_type_str = "Revision";
            translated_value = qmi_message_dms_get_revision_output_revision_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_get_revision_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Get Revision\" (0x0023)\n",
                            line_prefix);

    {
        struct message_get_revision_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_get_revision_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsGetRevisionOutput *
qmi_message_dms_get_revision_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsGetRevisionOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_GET_REVISION);

    self = g_slice_new0 (QmiMessageDmsGetRevisionOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_REVISION_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_get_revision_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_get_revision_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_REVISION_OUTPUT_TLV_REVISION, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Revision TLV: ");
                qmi_message_dms_get_revision_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &(self->arg_revision), error))
                goto qmi_message_dms_get_revision_output_revision_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Revision' TLV", offset);
            }

            self->arg_revision_set = TRUE;

qmi_message_dms_get_revision_output_revision_out:
            if (!self->arg_revision_set) {
                qmi_message_dms_get_revision_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS Get MSISDN */


/* --- Input -- */

/* Note: no fields in the Input container */

static QmiMessage *
__qmi_message_dms_get_msisdn_request_create (
    guint16 transaction_id,
    guint8 cid,
    gpointer unused,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_GET_MSISDN);

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsGetMsisdnOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* MSISDN */
    gboolean arg_msisdn_set;
    gchar *arg_msisdn;
};

#define QMI_MESSAGE_DMS_GET_MSISDN_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_DMS_GET_MSISDN_OUTPUT_TLV_MSISDN 0x01

gboolean
qmi_message_dms_get_msisdn_output_get_result (
    QmiMessageDmsGetMsisdnOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_dms_get_msisdn_output_get_msisdn (
    QmiMessageDmsGetMsisdnOutput *self,
    const gchar **value_msisdn,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_msisdn_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'MSISDN' was not found in the message");
        return FALSE;
    }

    if (value_msisdn)
        *value_msisdn = self->arg_msisdn;

    return TRUE;
}

GType
qmi_message_dms_get_msisdn_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsGetMsisdnOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_get_msisdn_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_get_msisdn_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsGetMsisdnOutput *
qmi_message_dms_get_msisdn_output_ref (QmiMessageDmsGetMsisdnOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_get_msisdn_output_unref (QmiMessageDmsGetMsisdnOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_msisdn, (GDestroyNotify)g_free);
        g_slice_free (QmiMessageDmsGetMsisdnOutput, self);
    }
}

static gchar *
qmi_message_dms_get_msisdn_output_msisdn_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_MSISDN_OUTPUT_TLV_MSISDN, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &tmp, &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_get_msisdn_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_get_msisdn_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_get_msisdn_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_GET_MSISDN_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_GET_MSISDN_OUTPUT_TLV_MSISDN:
            tlv_type_str = "MSISDN";
            translated_value = qmi_message_dms_get_msisdn_output_msisdn_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_get_msisdn_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Get MSISDN\" (0x0024)\n",
                            line_prefix);

    {
        struct message_get_msisdn_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_get_msisdn_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsGetMsisdnOutput *
qmi_message_dms_get_msisdn_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsGetMsisdnOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_GET_MSISDN);

    self = g_slice_new0 (QmiMessageDmsGetMsisdnOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_MSISDN_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_get_msisdn_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_get_msisdn_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_MSISDN_OUTPUT_TLV_MSISDN, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory MSISDN TLV: ");
                qmi_message_dms_get_msisdn_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &(self->arg_msisdn), error))
                goto qmi_message_dms_get_msisdn_output_msisdn_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'MSISDN' TLV", offset);
            }

            self->arg_msisdn_set = TRUE;

qmi_message_dms_get_msisdn_output_msisdn_out:
            if (!self->arg_msisdn_set) {
                qmi_message_dms_get_msisdn_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS Get IDs */


/* --- Input -- */

/* Note: no fields in the Input container */

static QmiMessage *
__qmi_message_dms_get_ids_request_create (
    guint16 transaction_id,
    guint8 cid,
    gpointer unused,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_GET_IDS);

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsGetIdsOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* Esn */
    gboolean arg_esn_set;
    gchar *arg_esn;

    /* Imei */
    gboolean arg_imei_set;
    gchar *arg_imei;

    /* Meid */
    gboolean arg_meid_set;
    gchar *arg_meid;

    /* Imei Software Version */
    gboolean arg_imei_software_version_set;
    gchar *arg_imei_software_version;
};

#define QMI_MESSAGE_DMS_GET_IDS_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_DMS_GET_IDS_OUTPUT_TLV_ESN 0x10
#define QMI_MESSAGE_DMS_GET_IDS_OUTPUT_TLV_IMEI 0x11
#define QMI_MESSAGE_DMS_GET_IDS_OUTPUT_TLV_MEID 0x12
#define QMI_MESSAGE_DMS_GET_IDS_OUTPUT_TLV_IMEI_SOFTWARE_VERSION 0x13

gboolean
qmi_message_dms_get_ids_output_get_result (
    QmiMessageDmsGetIdsOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_dms_get_ids_output_get_esn (
    QmiMessageDmsGetIdsOutput *self,
    const gchar **value_esn,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_esn_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Esn' was not found in the message");
        return FALSE;
    }

    if (value_esn)
        *value_esn = self->arg_esn;

    return TRUE;
}

gboolean
qmi_message_dms_get_ids_output_get_imei (
    QmiMessageDmsGetIdsOutput *self,
    const gchar **value_imei,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_imei_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Imei' was not found in the message");
        return FALSE;
    }

    if (value_imei)
        *value_imei = self->arg_imei;

    return TRUE;
}

gboolean
qmi_message_dms_get_ids_output_get_meid (
    QmiMessageDmsGetIdsOutput *self,
    const gchar **value_meid,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_meid_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Meid' was not found in the message");
        return FALSE;
    }

    if (value_meid)
        *value_meid = self->arg_meid;

    return TRUE;
}

gboolean
qmi_message_dms_get_ids_output_get_imei_software_version (
    QmiMessageDmsGetIdsOutput *self,
    const gchar **value_imei_software_version,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_imei_software_version_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Imei Software Version' was not found in the message");
        return FALSE;
    }

    if (value_imei_software_version)
        *value_imei_software_version = self->arg_imei_software_version;

    return TRUE;
}

GType
qmi_message_dms_get_ids_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsGetIdsOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_get_ids_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_get_ids_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsGetIdsOutput *
qmi_message_dms_get_ids_output_ref (QmiMessageDmsGetIdsOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_get_ids_output_unref (QmiMessageDmsGetIdsOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_esn, (GDestroyNotify)g_free);
        g_clear_pointer (&self->arg_imei, (GDestroyNotify)g_free);
        g_clear_pointer (&self->arg_meid, (GDestroyNotify)g_free);
        g_clear_pointer (&self->arg_imei_software_version, (GDestroyNotify)g_free);
        g_slice_free (QmiMessageDmsGetIdsOutput, self);
    }
}

static gchar *
qmi_message_dms_get_ids_output_esn_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_IDS_OUTPUT_TLV_ESN, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &tmp, &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_get_ids_output_imei_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_IDS_OUTPUT_TLV_IMEI, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 15, &tmp, &error))
            goto out;
        if (qmi_utils_get_show_personal_info ()) {
            g_string_append (printable, tmp);
        } else {
            g_string_append_printf (printable, "'###'");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_get_ids_output_meid_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_IDS_OUTPUT_TLV_MEID, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &tmp, &error))
            goto out;
        if (qmi_utils_get_show_personal_info ()) {
            g_string_append (printable, tmp);
        } else {
            g_string_append_printf (printable, "'###'");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_get_ids_output_imei_software_version_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_IDS_OUTPUT_TLV_IMEI_SOFTWARE_VERSION, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &tmp, &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_get_ids_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_get_ids_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_get_ids_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_GET_IDS_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_GET_IDS_OUTPUT_TLV_ESN:
            tlv_type_str = "Esn";
            translated_value = qmi_message_dms_get_ids_output_esn_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_GET_IDS_OUTPUT_TLV_IMEI:
            tlv_type_str = "Imei";
            translated_value = qmi_message_dms_get_ids_output_imei_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            value_has_personal_info = TRUE;
            break;
        case QMI_MESSAGE_DMS_GET_IDS_OUTPUT_TLV_MEID:
            tlv_type_str = "Meid";
            translated_value = qmi_message_dms_get_ids_output_meid_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            value_has_personal_info = TRUE;
            break;
        case QMI_MESSAGE_DMS_GET_IDS_OUTPUT_TLV_IMEI_SOFTWARE_VERSION:
            tlv_type_str = "Imei Software Version";
            translated_value = qmi_message_dms_get_ids_output_imei_software_version_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_get_ids_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Get IDs\" (0x0025)\n",
                            line_prefix);

    {
        struct message_get_ids_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_get_ids_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsGetIdsOutput *
qmi_message_dms_get_ids_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsGetIdsOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_GET_IDS);

    self = g_slice_new0 (QmiMessageDmsGetIdsOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_IDS_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_get_ids_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_get_ids_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_IDS_OUTPUT_TLV_ESN, NULL, NULL)) == 0) {
                goto qmi_message_dms_get_ids_output_esn_out;
            }
            if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &(self->arg_esn), NULL))
                goto qmi_message_dms_get_ids_output_esn_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Esn' TLV", offset);
            }

            self->arg_esn_set = TRUE;

qmi_message_dms_get_ids_output_esn_out:
            ;

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_IDS_OUTPUT_TLV_IMEI, NULL, NULL)) == 0) {
                goto qmi_message_dms_get_ids_output_imei_out;
            }
            if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 15, &(self->arg_imei), NULL))
                goto qmi_message_dms_get_ids_output_imei_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Imei' TLV", offset);
            }

            self->arg_imei_set = TRUE;

qmi_message_dms_get_ids_output_imei_out:
            ;

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_IDS_OUTPUT_TLV_MEID, NULL, NULL)) == 0) {
                goto qmi_message_dms_get_ids_output_meid_out;
            }
            if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &(self->arg_meid), NULL))
                goto qmi_message_dms_get_ids_output_meid_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Meid' TLV", offset);
            }

            self->arg_meid_set = TRUE;

qmi_message_dms_get_ids_output_meid_out:
            ;

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_IDS_OUTPUT_TLV_IMEI_SOFTWARE_VERSION, NULL, NULL)) == 0) {
                goto qmi_message_dms_get_ids_output_imei_software_version_out;
            }
            if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &(self->arg_imei_software_version), NULL))
                goto qmi_message_dms_get_ids_output_imei_software_version_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Imei Software Version' TLV", offset);
            }

            self->arg_imei_software_version_set = TRUE;

qmi_message_dms_get_ids_output_imei_software_version_out:
            ;

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS Get Power State */


/* --- Input -- */

/* Note: no fields in the Input container */

static QmiMessage *
__qmi_message_dms_get_power_state_request_create (
    guint16 transaction_id,
    guint8 cid,
    gpointer unused,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_GET_POWER_STATE);

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsGetPowerStateOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* Info */
    gboolean arg_info_set;
    guint8 arg_info_power_state_flags;
    guint8 arg_info_battery_level;
};

#define QMI_MESSAGE_DMS_GET_POWER_STATE_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_DMS_GET_POWER_STATE_OUTPUT_TLV_INFO 0x01

gboolean
qmi_message_dms_get_power_state_output_get_result (
    QmiMessageDmsGetPowerStateOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_dms_get_power_state_output_get_info (
    QmiMessageDmsGetPowerStateOutput *self,
    guint8 *value_info_power_state_flags,
    guint8 *value_info_battery_level,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_info_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Info' was not found in the message");
        return FALSE;
    }

    if (value_info_power_state_flags)
        *value_info_power_state_flags = self->arg_info_power_state_flags;
    if (value_info_battery_level)
        *value_info_battery_level = self->arg_info_battery_level;

    return TRUE;
}

GType
qmi_message_dms_get_power_state_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsGetPowerStateOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_get_power_state_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_get_power_state_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsGetPowerStateOutput *
qmi_message_dms_get_power_state_output_ref (QmiMessageDmsGetPowerStateOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_get_power_state_output_unref (QmiMessageDmsGetPowerStateOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsGetPowerStateOutput, self);
    }
}

static gchar *
qmi_message_dms_get_power_state_output_info_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_POWER_STATE_OUTPUT_TLV_INFO, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " power_state_flags = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " battery_level = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_get_power_state_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_get_power_state_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_get_power_state_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_GET_POWER_STATE_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_GET_POWER_STATE_OUTPUT_TLV_INFO:
            tlv_type_str = "Info";
            translated_value = qmi_message_dms_get_power_state_output_info_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_get_power_state_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Get Power State\" (0x0026)\n",
                            line_prefix);

    {
        struct message_get_power_state_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_get_power_state_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsGetPowerStateOutput *
qmi_message_dms_get_power_state_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsGetPowerStateOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_GET_POWER_STATE);

    self = g_slice_new0 (QmiMessageDmsGetPowerStateOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_POWER_STATE_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_get_power_state_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_get_power_state_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_POWER_STATE_OUTPUT_TLV_INFO, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Info TLV: ");
                qmi_message_dms_get_power_state_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_info_power_state_flags), error))
                goto qmi_message_dms_get_power_state_output_info_out;
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_info_battery_level), error))
                goto qmi_message_dms_get_power_state_output_info_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Info' TLV", offset);
            }

            self->arg_info_set = TRUE;

qmi_message_dms_get_power_state_output_info_out:
            if (!self->arg_info_set) {
                qmi_message_dms_get_power_state_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS UIM Set PIN Protection */


/* --- Input -- */

struct _QmiMessageDmsUimSetPinProtectionInput {
    volatile gint ref_count;

    /* Info */
    gboolean arg_info_set;
    guint8 arg_info_pin_id;
    guint8 arg_info_protection_enabled;
    gchar *arg_info_pin;
};

#define QMI_MESSAGE_DMS_UIM_SET_PIN_PROTECTION_INPUT_TLV_INFO 0x01

gboolean
qmi_message_dms_uim_set_pin_protection_input_get_info (
    QmiMessageDmsUimSetPinProtectionInput *self,
    QmiDmsUimPinId *value_info_pin_id,
    gboolean *value_info_protection_enabled,
    const gchar **value_info_pin,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_info_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Info' was not found in the message");
        return FALSE;
    }

    if (value_info_pin_id)
        *value_info_pin_id = (QmiDmsUimPinId)(self->arg_info_pin_id);
    if (value_info_protection_enabled)
        *value_info_protection_enabled = (gboolean)(self->arg_info_protection_enabled);
    if (value_info_pin)
        *value_info_pin = self->arg_info_pin;

    return TRUE;
}

gboolean
qmi_message_dms_uim_set_pin_protection_input_set_info (
    QmiMessageDmsUimSetPinProtectionInput *self,
    QmiDmsUimPinId value_info_pin_id,
    gboolean value_info_protection_enabled,
    const gchar *value_info_pin,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_info_pin_id = (guint8)(value_info_pin_id);
    self->arg_info_protection_enabled = (guint8)(value_info_protection_enabled);
    g_free (self->arg_info_pin);
    self->arg_info_pin = g_strdup (value_info_pin ? value_info_pin : "");
    self->arg_info_set = TRUE;

    return TRUE;
}

GType
qmi_message_dms_uim_set_pin_protection_input_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsUimSetPinProtectionInput"),
                                          (GBoxedCopyFunc) qmi_message_dms_uim_set_pin_protection_input_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_uim_set_pin_protection_input_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsUimSetPinProtectionInput *
qmi_message_dms_uim_set_pin_protection_input_ref (QmiMessageDmsUimSetPinProtectionInput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_uim_set_pin_protection_input_unref (QmiMessageDmsUimSetPinProtectionInput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_info_pin, (GDestroyNotify)g_free);
        g_slice_free (QmiMessageDmsUimSetPinProtectionInput, self);
    }
}

QmiMessageDmsUimSetPinProtectionInput *
qmi_message_dms_uim_set_pin_protection_input_new (void)
{
    QmiMessageDmsUimSetPinProtectionInput *self;

    self = g_slice_new0 (QmiMessageDmsUimSetPinProtectionInput);
    self->ref_count = 1;
    return self;
}

static QmiMessage *
__qmi_message_dms_uim_set_pin_protection_request_create (
    guint16 transaction_id,
    guint8 cid,
    QmiMessageDmsUimSetPinProtectionInput *input,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_UIM_SET_PIN_PROTECTION);

    /* There is at least one mandatory TLV, don't allow NULL input */
    if (!input) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Message 'UIM Set PIN Protection' has mandatory TLVs");
        return NULL;
    }

    /* Try to add the 'Info' TLV */
    if (input->arg_info_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_DMS_UIM_SET_PIN_PROTECTION_INPUT_TLV_INFO, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Info': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_info_pin_id;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Info': ");
                return NULL;
            }
        }
        {
            guint8 tmp;

            tmp = (guint8) input->arg_info_protection_enabled;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Info': ");
                return NULL;
            }
        }
        if (!qmi_message_tlv_write_string (self, 1, input->arg_info_pin, -1, error)) {
            g_prefix_error (error, "Cannot write string in TLV 'Info': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Info': ");
            return NULL;
        }
    } else {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Missing mandatory TLV 'Info' in message 'UIM Set PIN Protection'");
        return NULL;
    }

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsUimSetPinProtectionOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* Pin Retries Status */
    gboolean arg_pin_retries_status_set;
    guint8 arg_pin_retries_status_verify_retries_left;
    guint8 arg_pin_retries_status_unblock_retries_left;
};

#define QMI_MESSAGE_DMS_UIM_SET_PIN_PROTECTION_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_DMS_UIM_SET_PIN_PROTECTION_OUTPUT_TLV_PIN_RETRIES_STATUS 0x10

gboolean
qmi_message_dms_uim_set_pin_protection_output_get_result (
    QmiMessageDmsUimSetPinProtectionOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_dms_uim_set_pin_protection_output_get_pin_retries_status (
    QmiMessageDmsUimSetPinProtectionOutput *self,
    guint8 *value_pin_retries_status_verify_retries_left,
    guint8 *value_pin_retries_status_unblock_retries_left,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_pin_retries_status_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Pin Retries Status' was not found in the message");
        return FALSE;
    }

    if (value_pin_retries_status_verify_retries_left)
        *value_pin_retries_status_verify_retries_left = self->arg_pin_retries_status_verify_retries_left;
    if (value_pin_retries_status_unblock_retries_left)
        *value_pin_retries_status_unblock_retries_left = self->arg_pin_retries_status_unblock_retries_left;

    return TRUE;
}

GType
qmi_message_dms_uim_set_pin_protection_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsUimSetPinProtectionOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_uim_set_pin_protection_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_uim_set_pin_protection_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsUimSetPinProtectionOutput *
qmi_message_dms_uim_set_pin_protection_output_ref (QmiMessageDmsUimSetPinProtectionOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_uim_set_pin_protection_output_unref (QmiMessageDmsUimSetPinProtectionOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsUimSetPinProtectionOutput, self);
    }
}

static gchar *
qmi_message_dms_uim_set_pin_protection_input_info_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_UIM_SET_PIN_PROTECTION_INPUT_TLV_INFO, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " pin_id = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_DMS_UIM_PIN_ID_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_dms_uim_pin_id_get_string ((QmiDmsUimPinId)tmp));
#elif defined  __QMI_DMS_UIM_PIN_ID_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_dms_uim_pin_id_build_string_from_mask ((QmiDmsUimPinId)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiDmsUimPinId
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " protection_enabled = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " pin = '");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 1, 0, &tmp, &error))
            goto out;
        if (qmi_utils_get_show_personal_info ()) {
            g_string_append (printable, tmp);
        } else {
            g_string_append_printf (printable, "'###'");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_uim_set_pin_protection_output_pin_retries_status_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_UIM_SET_PIN_PROTECTION_OUTPUT_TLV_PIN_RETRIES_STATUS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " verify_retries_left = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " unblock_retries_left = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_uim_set_pin_protection_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_uim_set_pin_protection_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_uim_set_pin_protection_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        case QMI_MESSAGE_DMS_UIM_SET_PIN_PROTECTION_INPUT_TLV_INFO:
            tlv_type_str = "Info";
            translated_value = qmi_message_dms_uim_set_pin_protection_input_info_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            value_has_personal_info = TRUE;
            break;
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_UIM_SET_PIN_PROTECTION_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_UIM_SET_PIN_PROTECTION_OUTPUT_TLV_PIN_RETRIES_STATUS:
            tlv_type_str = "Pin Retries Status";
            translated_value = qmi_message_dms_uim_set_pin_protection_output_pin_retries_status_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_uim_set_pin_protection_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"UIM Set PIN Protection\" (0x0027)\n",
                            line_prefix);

    {
        struct message_uim_set_pin_protection_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_uim_set_pin_protection_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsUimSetPinProtectionOutput *
qmi_message_dms_uim_set_pin_protection_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsUimSetPinProtectionOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_UIM_SET_PIN_PROTECTION);

    self = g_slice_new0 (QmiMessageDmsUimSetPinProtectionOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_UIM_SET_PIN_PROTECTION_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_uim_set_pin_protection_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_uim_set_pin_protection_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status != QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_UIM_SET_PIN_PROTECTION_OUTPUT_TLV_PIN_RETRIES_STATUS, NULL, NULL)) == 0) {
                goto qmi_message_dms_uim_set_pin_protection_output_pin_retries_status_out;
            }
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_pin_retries_status_verify_retries_left), NULL))
                goto qmi_message_dms_uim_set_pin_protection_output_pin_retries_status_out;
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_pin_retries_status_unblock_retries_left), NULL))
                goto qmi_message_dms_uim_set_pin_protection_output_pin_retries_status_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Pin Retries Status' TLV", offset);
            }

            self->arg_pin_retries_status_set = TRUE;

qmi_message_dms_uim_set_pin_protection_output_pin_retries_status_out:
            ;

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS UIM Verify PIN */


/* --- Input -- */

struct _QmiMessageDmsUimVerifyPinInput {
    volatile gint ref_count;

    /* Info */
    gboolean arg_info_set;
    guint8 arg_info_pin_id;
    gchar *arg_info_pin;
};

#define QMI_MESSAGE_DMS_UIM_VERIFY_PIN_INPUT_TLV_INFO 0x01

gboolean
qmi_message_dms_uim_verify_pin_input_get_info (
    QmiMessageDmsUimVerifyPinInput *self,
    QmiDmsUimPinId *value_info_pin_id,
    const gchar **value_info_pin,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_info_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Info' was not found in the message");
        return FALSE;
    }

    if (value_info_pin_id)
        *value_info_pin_id = (QmiDmsUimPinId)(self->arg_info_pin_id);
    if (value_info_pin)
        *value_info_pin = self->arg_info_pin;

    return TRUE;
}

gboolean
qmi_message_dms_uim_verify_pin_input_set_info (
    QmiMessageDmsUimVerifyPinInput *self,
    QmiDmsUimPinId value_info_pin_id,
    const gchar *value_info_pin,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_info_pin_id = (guint8)(value_info_pin_id);
    g_free (self->arg_info_pin);
    self->arg_info_pin = g_strdup (value_info_pin ? value_info_pin : "");
    self->arg_info_set = TRUE;

    return TRUE;
}

GType
qmi_message_dms_uim_verify_pin_input_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsUimVerifyPinInput"),
                                          (GBoxedCopyFunc) qmi_message_dms_uim_verify_pin_input_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_uim_verify_pin_input_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsUimVerifyPinInput *
qmi_message_dms_uim_verify_pin_input_ref (QmiMessageDmsUimVerifyPinInput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_uim_verify_pin_input_unref (QmiMessageDmsUimVerifyPinInput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_info_pin, (GDestroyNotify)g_free);
        g_slice_free (QmiMessageDmsUimVerifyPinInput, self);
    }
}

QmiMessageDmsUimVerifyPinInput *
qmi_message_dms_uim_verify_pin_input_new (void)
{
    QmiMessageDmsUimVerifyPinInput *self;

    self = g_slice_new0 (QmiMessageDmsUimVerifyPinInput);
    self->ref_count = 1;
    return self;
}

static QmiMessage *
__qmi_message_dms_uim_verify_pin_request_create (
    guint16 transaction_id,
    guint8 cid,
    QmiMessageDmsUimVerifyPinInput *input,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_UIM_VERIFY_PIN);

    /* There is at least one mandatory TLV, don't allow NULL input */
    if (!input) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Message 'UIM Verify PIN' has mandatory TLVs");
        return NULL;
    }

    /* Try to add the 'Info' TLV */
    if (input->arg_info_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_DMS_UIM_VERIFY_PIN_INPUT_TLV_INFO, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Info': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_info_pin_id;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Info': ");
                return NULL;
            }
        }
        if (!qmi_message_tlv_write_string (self, 1, input->arg_info_pin, -1, error)) {
            g_prefix_error (error, "Cannot write string in TLV 'Info': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Info': ");
            return NULL;
        }
    } else {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Missing mandatory TLV 'Info' in message 'UIM Verify PIN'");
        return NULL;
    }

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsUimVerifyPinOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* Pin Retries Status */
    gboolean arg_pin_retries_status_set;
    guint8 arg_pin_retries_status_verify_retries_left;
    guint8 arg_pin_retries_status_unblock_retries_left;
};

#define QMI_MESSAGE_DMS_UIM_VERIFY_PIN_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_DMS_UIM_VERIFY_PIN_OUTPUT_TLV_PIN_RETRIES_STATUS 0x10

gboolean
qmi_message_dms_uim_verify_pin_output_get_result (
    QmiMessageDmsUimVerifyPinOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_dms_uim_verify_pin_output_get_pin_retries_status (
    QmiMessageDmsUimVerifyPinOutput *self,
    guint8 *value_pin_retries_status_verify_retries_left,
    guint8 *value_pin_retries_status_unblock_retries_left,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_pin_retries_status_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Pin Retries Status' was not found in the message");
        return FALSE;
    }

    if (value_pin_retries_status_verify_retries_left)
        *value_pin_retries_status_verify_retries_left = self->arg_pin_retries_status_verify_retries_left;
    if (value_pin_retries_status_unblock_retries_left)
        *value_pin_retries_status_unblock_retries_left = self->arg_pin_retries_status_unblock_retries_left;

    return TRUE;
}

GType
qmi_message_dms_uim_verify_pin_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsUimVerifyPinOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_uim_verify_pin_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_uim_verify_pin_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsUimVerifyPinOutput *
qmi_message_dms_uim_verify_pin_output_ref (QmiMessageDmsUimVerifyPinOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_uim_verify_pin_output_unref (QmiMessageDmsUimVerifyPinOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsUimVerifyPinOutput, self);
    }
}

static gchar *
qmi_message_dms_uim_verify_pin_input_info_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_UIM_VERIFY_PIN_INPUT_TLV_INFO, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " pin_id = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_DMS_UIM_PIN_ID_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_dms_uim_pin_id_get_string ((QmiDmsUimPinId)tmp));
#elif defined  __QMI_DMS_UIM_PIN_ID_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_dms_uim_pin_id_build_string_from_mask ((QmiDmsUimPinId)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiDmsUimPinId
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " pin = '");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 1, 0, &tmp, &error))
            goto out;
        if (qmi_utils_get_show_personal_info ()) {
            g_string_append (printable, tmp);
        } else {
            g_string_append_printf (printable, "'###'");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_uim_verify_pin_output_pin_retries_status_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_UIM_VERIFY_PIN_OUTPUT_TLV_PIN_RETRIES_STATUS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " verify_retries_left = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " unblock_retries_left = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_uim_verify_pin_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_uim_verify_pin_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_uim_verify_pin_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        case QMI_MESSAGE_DMS_UIM_VERIFY_PIN_INPUT_TLV_INFO:
            tlv_type_str = "Info";
            translated_value = qmi_message_dms_uim_verify_pin_input_info_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            value_has_personal_info = TRUE;
            break;
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_UIM_VERIFY_PIN_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_UIM_VERIFY_PIN_OUTPUT_TLV_PIN_RETRIES_STATUS:
            tlv_type_str = "Pin Retries Status";
            translated_value = qmi_message_dms_uim_verify_pin_output_pin_retries_status_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_uim_verify_pin_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"UIM Verify PIN\" (0x0028)\n",
                            line_prefix);

    {
        struct message_uim_verify_pin_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_uim_verify_pin_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsUimVerifyPinOutput *
qmi_message_dms_uim_verify_pin_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsUimVerifyPinOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_UIM_VERIFY_PIN);

    self = g_slice_new0 (QmiMessageDmsUimVerifyPinOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_UIM_VERIFY_PIN_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_uim_verify_pin_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_uim_verify_pin_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status != QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_UIM_VERIFY_PIN_OUTPUT_TLV_PIN_RETRIES_STATUS, NULL, NULL)) == 0) {
                goto qmi_message_dms_uim_verify_pin_output_pin_retries_status_out;
            }
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_pin_retries_status_verify_retries_left), NULL))
                goto qmi_message_dms_uim_verify_pin_output_pin_retries_status_out;
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_pin_retries_status_unblock_retries_left), NULL))
                goto qmi_message_dms_uim_verify_pin_output_pin_retries_status_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Pin Retries Status' TLV", offset);
            }

            self->arg_pin_retries_status_set = TRUE;

qmi_message_dms_uim_verify_pin_output_pin_retries_status_out:
            ;

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS UIM Unblock PIN */


/* --- Input -- */

struct _QmiMessageDmsUimUnblockPinInput {
    volatile gint ref_count;

    /* Info */
    gboolean arg_info_set;
    guint8 arg_info_pin_id;
    gchar *arg_info_puk;
    gchar *arg_info_new_pin;
};

#define QMI_MESSAGE_DMS_UIM_UNBLOCK_PIN_INPUT_TLV_INFO 0x01

gboolean
qmi_message_dms_uim_unblock_pin_input_get_info (
    QmiMessageDmsUimUnblockPinInput *self,
    QmiDmsUimPinId *value_info_pin_id,
    const gchar **value_info_puk,
    const gchar **value_info_new_pin,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_info_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Info' was not found in the message");
        return FALSE;
    }

    if (value_info_pin_id)
        *value_info_pin_id = (QmiDmsUimPinId)(self->arg_info_pin_id);
    if (value_info_puk)
        *value_info_puk = self->arg_info_puk;
    if (value_info_new_pin)
        *value_info_new_pin = self->arg_info_new_pin;

    return TRUE;
}

gboolean
qmi_message_dms_uim_unblock_pin_input_set_info (
    QmiMessageDmsUimUnblockPinInput *self,
    QmiDmsUimPinId value_info_pin_id,
    const gchar *value_info_puk,
    const gchar *value_info_new_pin,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_info_pin_id = (guint8)(value_info_pin_id);
    g_free (self->arg_info_puk);
    self->arg_info_puk = g_strdup (value_info_puk ? value_info_puk : "");
    g_free (self->arg_info_new_pin);
    self->arg_info_new_pin = g_strdup (value_info_new_pin ? value_info_new_pin : "");
    self->arg_info_set = TRUE;

    return TRUE;
}

GType
qmi_message_dms_uim_unblock_pin_input_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsUimUnblockPinInput"),
                                          (GBoxedCopyFunc) qmi_message_dms_uim_unblock_pin_input_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_uim_unblock_pin_input_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsUimUnblockPinInput *
qmi_message_dms_uim_unblock_pin_input_ref (QmiMessageDmsUimUnblockPinInput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_uim_unblock_pin_input_unref (QmiMessageDmsUimUnblockPinInput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_info_puk, (GDestroyNotify)g_free);
        g_clear_pointer (&self->arg_info_new_pin, (GDestroyNotify)g_free);
        g_slice_free (QmiMessageDmsUimUnblockPinInput, self);
    }
}

QmiMessageDmsUimUnblockPinInput *
qmi_message_dms_uim_unblock_pin_input_new (void)
{
    QmiMessageDmsUimUnblockPinInput *self;

    self = g_slice_new0 (QmiMessageDmsUimUnblockPinInput);
    self->ref_count = 1;
    return self;
}

static QmiMessage *
__qmi_message_dms_uim_unblock_pin_request_create (
    guint16 transaction_id,
    guint8 cid,
    QmiMessageDmsUimUnblockPinInput *input,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_UIM_UNBLOCK_PIN);

    /* There is at least one mandatory TLV, don't allow NULL input */
    if (!input) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Message 'UIM Unblock PIN' has mandatory TLVs");
        return NULL;
    }

    /* Try to add the 'Info' TLV */
    if (input->arg_info_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_DMS_UIM_UNBLOCK_PIN_INPUT_TLV_INFO, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Info': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_info_pin_id;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Info': ");
                return NULL;
            }
        }
        if (!qmi_message_tlv_write_string (self, 1, input->arg_info_puk, -1, error)) {
            g_prefix_error (error, "Cannot write string in TLV 'Info': ");
            return NULL;
        }
        if (!qmi_message_tlv_write_string (self, 1, input->arg_info_new_pin, -1, error)) {
            g_prefix_error (error, "Cannot write string in TLV 'Info': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Info': ");
            return NULL;
        }
    } else {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Missing mandatory TLV 'Info' in message 'UIM Unblock PIN'");
        return NULL;
    }

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsUimUnblockPinOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* Pin Retries Status */
    gboolean arg_pin_retries_status_set;
    guint8 arg_pin_retries_status_verify_retries_left;
    guint8 arg_pin_retries_status_unblock_retries_left;
};

#define QMI_MESSAGE_DMS_UIM_UNBLOCK_PIN_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_DMS_UIM_UNBLOCK_PIN_OUTPUT_TLV_PIN_RETRIES_STATUS 0x10

gboolean
qmi_message_dms_uim_unblock_pin_output_get_result (
    QmiMessageDmsUimUnblockPinOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_dms_uim_unblock_pin_output_get_pin_retries_status (
    QmiMessageDmsUimUnblockPinOutput *self,
    guint8 *value_pin_retries_status_verify_retries_left,
    guint8 *value_pin_retries_status_unblock_retries_left,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_pin_retries_status_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Pin Retries Status' was not found in the message");
        return FALSE;
    }

    if (value_pin_retries_status_verify_retries_left)
        *value_pin_retries_status_verify_retries_left = self->arg_pin_retries_status_verify_retries_left;
    if (value_pin_retries_status_unblock_retries_left)
        *value_pin_retries_status_unblock_retries_left = self->arg_pin_retries_status_unblock_retries_left;

    return TRUE;
}

GType
qmi_message_dms_uim_unblock_pin_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsUimUnblockPinOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_uim_unblock_pin_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_uim_unblock_pin_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsUimUnblockPinOutput *
qmi_message_dms_uim_unblock_pin_output_ref (QmiMessageDmsUimUnblockPinOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_uim_unblock_pin_output_unref (QmiMessageDmsUimUnblockPinOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsUimUnblockPinOutput, self);
    }
}

static gchar *
qmi_message_dms_uim_unblock_pin_input_info_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_UIM_UNBLOCK_PIN_INPUT_TLV_INFO, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " pin_id = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_DMS_UIM_PIN_ID_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_dms_uim_pin_id_get_string ((QmiDmsUimPinId)tmp));
#elif defined  __QMI_DMS_UIM_PIN_ID_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_dms_uim_pin_id_build_string_from_mask ((QmiDmsUimPinId)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiDmsUimPinId
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " puk = '");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 1, 0, &tmp, &error))
            goto out;
        if (qmi_utils_get_show_personal_info ()) {
            g_string_append (printable, tmp);
        } else {
            g_string_append_printf (printable, "'###'");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " new_pin = '");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 1, 0, &tmp, &error))
            goto out;
        if (qmi_utils_get_show_personal_info ()) {
            g_string_append (printable, tmp);
        } else {
            g_string_append_printf (printable, "'###'");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_uim_unblock_pin_output_pin_retries_status_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_UIM_UNBLOCK_PIN_OUTPUT_TLV_PIN_RETRIES_STATUS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " verify_retries_left = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " unblock_retries_left = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_uim_unblock_pin_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_uim_unblock_pin_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_uim_unblock_pin_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        case QMI_MESSAGE_DMS_UIM_UNBLOCK_PIN_INPUT_TLV_INFO:
            tlv_type_str = "Info";
            translated_value = qmi_message_dms_uim_unblock_pin_input_info_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            value_has_personal_info = TRUE;
            break;
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_UIM_UNBLOCK_PIN_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_UIM_UNBLOCK_PIN_OUTPUT_TLV_PIN_RETRIES_STATUS:
            tlv_type_str = "Pin Retries Status";
            translated_value = qmi_message_dms_uim_unblock_pin_output_pin_retries_status_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_uim_unblock_pin_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"UIM Unblock PIN\" (0x0029)\n",
                            line_prefix);

    {
        struct message_uim_unblock_pin_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_uim_unblock_pin_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsUimUnblockPinOutput *
qmi_message_dms_uim_unblock_pin_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsUimUnblockPinOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_UIM_UNBLOCK_PIN);

    self = g_slice_new0 (QmiMessageDmsUimUnblockPinOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_UIM_UNBLOCK_PIN_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_uim_unblock_pin_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_uim_unblock_pin_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status != QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_UIM_UNBLOCK_PIN_OUTPUT_TLV_PIN_RETRIES_STATUS, NULL, NULL)) == 0) {
                goto qmi_message_dms_uim_unblock_pin_output_pin_retries_status_out;
            }
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_pin_retries_status_verify_retries_left), NULL))
                goto qmi_message_dms_uim_unblock_pin_output_pin_retries_status_out;
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_pin_retries_status_unblock_retries_left), NULL))
                goto qmi_message_dms_uim_unblock_pin_output_pin_retries_status_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Pin Retries Status' TLV", offset);
            }

            self->arg_pin_retries_status_set = TRUE;

qmi_message_dms_uim_unblock_pin_output_pin_retries_status_out:
            ;

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS UIM Change PIN */


/* --- Input -- */

struct _QmiMessageDmsUimChangePinInput {
    volatile gint ref_count;

    /* Info */
    gboolean arg_info_set;
    guint8 arg_info_pin_id;
    gchar *arg_info_old_pin;
    gchar *arg_info_new_pin;
};

#define QMI_MESSAGE_DMS_UIM_CHANGE_PIN_INPUT_TLV_INFO 0x01

gboolean
qmi_message_dms_uim_change_pin_input_get_info (
    QmiMessageDmsUimChangePinInput *self,
    QmiDmsUimPinId *value_info_pin_id,
    const gchar **value_info_old_pin,
    const gchar **value_info_new_pin,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_info_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Info' was not found in the message");
        return FALSE;
    }

    if (value_info_pin_id)
        *value_info_pin_id = (QmiDmsUimPinId)(self->arg_info_pin_id);
    if (value_info_old_pin)
        *value_info_old_pin = self->arg_info_old_pin;
    if (value_info_new_pin)
        *value_info_new_pin = self->arg_info_new_pin;

    return TRUE;
}

gboolean
qmi_message_dms_uim_change_pin_input_set_info (
    QmiMessageDmsUimChangePinInput *self,
    QmiDmsUimPinId value_info_pin_id,
    const gchar *value_info_old_pin,
    const gchar *value_info_new_pin,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_info_pin_id = (guint8)(value_info_pin_id);
    g_free (self->arg_info_old_pin);
    self->arg_info_old_pin = g_strdup (value_info_old_pin ? value_info_old_pin : "");
    g_free (self->arg_info_new_pin);
    self->arg_info_new_pin = g_strdup (value_info_new_pin ? value_info_new_pin : "");
    self->arg_info_set = TRUE;

    return TRUE;
}

GType
qmi_message_dms_uim_change_pin_input_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsUimChangePinInput"),
                                          (GBoxedCopyFunc) qmi_message_dms_uim_change_pin_input_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_uim_change_pin_input_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsUimChangePinInput *
qmi_message_dms_uim_change_pin_input_ref (QmiMessageDmsUimChangePinInput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_uim_change_pin_input_unref (QmiMessageDmsUimChangePinInput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_info_old_pin, (GDestroyNotify)g_free);
        g_clear_pointer (&self->arg_info_new_pin, (GDestroyNotify)g_free);
        g_slice_free (QmiMessageDmsUimChangePinInput, self);
    }
}

QmiMessageDmsUimChangePinInput *
qmi_message_dms_uim_change_pin_input_new (void)
{
    QmiMessageDmsUimChangePinInput *self;

    self = g_slice_new0 (QmiMessageDmsUimChangePinInput);
    self->ref_count = 1;
    return self;
}

static QmiMessage *
__qmi_message_dms_uim_change_pin_request_create (
    guint16 transaction_id,
    guint8 cid,
    QmiMessageDmsUimChangePinInput *input,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_UIM_CHANGE_PIN);

    /* There is at least one mandatory TLV, don't allow NULL input */
    if (!input) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Message 'UIM Change PIN' has mandatory TLVs");
        return NULL;
    }

    /* Try to add the 'Info' TLV */
    if (input->arg_info_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_DMS_UIM_CHANGE_PIN_INPUT_TLV_INFO, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Info': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_info_pin_id;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Info': ");
                return NULL;
            }
        }
        if (!qmi_message_tlv_write_string (self, 1, input->arg_info_old_pin, -1, error)) {
            g_prefix_error (error, "Cannot write string in TLV 'Info': ");
            return NULL;
        }
        if (!qmi_message_tlv_write_string (self, 1, input->arg_info_new_pin, -1, error)) {
            g_prefix_error (error, "Cannot write string in TLV 'Info': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Info': ");
            return NULL;
        }
    } else {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Missing mandatory TLV 'Info' in message 'UIM Change PIN'");
        return NULL;
    }

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsUimChangePinOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* Pin Retries Status */
    gboolean arg_pin_retries_status_set;
    guint8 arg_pin_retries_status_verify_retries_left;
    guint8 arg_pin_retries_status_unblock_retries_left;
};

#define QMI_MESSAGE_DMS_UIM_CHANGE_PIN_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_DMS_UIM_CHANGE_PIN_OUTPUT_TLV_PIN_RETRIES_STATUS 0x10

gboolean
qmi_message_dms_uim_change_pin_output_get_result (
    QmiMessageDmsUimChangePinOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_dms_uim_change_pin_output_get_pin_retries_status (
    QmiMessageDmsUimChangePinOutput *self,
    guint8 *value_pin_retries_status_verify_retries_left,
    guint8 *value_pin_retries_status_unblock_retries_left,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_pin_retries_status_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Pin Retries Status' was not found in the message");
        return FALSE;
    }

    if (value_pin_retries_status_verify_retries_left)
        *value_pin_retries_status_verify_retries_left = self->arg_pin_retries_status_verify_retries_left;
    if (value_pin_retries_status_unblock_retries_left)
        *value_pin_retries_status_unblock_retries_left = self->arg_pin_retries_status_unblock_retries_left;

    return TRUE;
}

GType
qmi_message_dms_uim_change_pin_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsUimChangePinOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_uim_change_pin_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_uim_change_pin_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsUimChangePinOutput *
qmi_message_dms_uim_change_pin_output_ref (QmiMessageDmsUimChangePinOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_uim_change_pin_output_unref (QmiMessageDmsUimChangePinOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsUimChangePinOutput, self);
    }
}

static gchar *
qmi_message_dms_uim_change_pin_input_info_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_UIM_CHANGE_PIN_INPUT_TLV_INFO, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " pin_id = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_DMS_UIM_PIN_ID_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_dms_uim_pin_id_get_string ((QmiDmsUimPinId)tmp));
#elif defined  __QMI_DMS_UIM_PIN_ID_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_dms_uim_pin_id_build_string_from_mask ((QmiDmsUimPinId)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiDmsUimPinId
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " old_pin = '");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 1, 0, &tmp, &error))
            goto out;
        if (qmi_utils_get_show_personal_info ()) {
            g_string_append (printable, tmp);
        } else {
            g_string_append_printf (printable, "'###'");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " new_pin = '");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 1, 0, &tmp, &error))
            goto out;
        if (qmi_utils_get_show_personal_info ()) {
            g_string_append (printable, tmp);
        } else {
            g_string_append_printf (printable, "'###'");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_uim_change_pin_output_pin_retries_status_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_UIM_CHANGE_PIN_OUTPUT_TLV_PIN_RETRIES_STATUS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " verify_retries_left = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " unblock_retries_left = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_uim_change_pin_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_uim_change_pin_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_uim_change_pin_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        case QMI_MESSAGE_DMS_UIM_CHANGE_PIN_INPUT_TLV_INFO:
            tlv_type_str = "Info";
            translated_value = qmi_message_dms_uim_change_pin_input_info_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            value_has_personal_info = TRUE;
            break;
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_UIM_CHANGE_PIN_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_UIM_CHANGE_PIN_OUTPUT_TLV_PIN_RETRIES_STATUS:
            tlv_type_str = "Pin Retries Status";
            translated_value = qmi_message_dms_uim_change_pin_output_pin_retries_status_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_uim_change_pin_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"UIM Change PIN\" (0x002A)\n",
                            line_prefix);

    {
        struct message_uim_change_pin_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_uim_change_pin_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsUimChangePinOutput *
qmi_message_dms_uim_change_pin_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsUimChangePinOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_UIM_CHANGE_PIN);

    self = g_slice_new0 (QmiMessageDmsUimChangePinOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_UIM_CHANGE_PIN_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_uim_change_pin_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_uim_change_pin_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status != QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_UIM_CHANGE_PIN_OUTPUT_TLV_PIN_RETRIES_STATUS, NULL, NULL)) == 0) {
                goto qmi_message_dms_uim_change_pin_output_pin_retries_status_out;
            }
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_pin_retries_status_verify_retries_left), NULL))
                goto qmi_message_dms_uim_change_pin_output_pin_retries_status_out;
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_pin_retries_status_unblock_retries_left), NULL))
                goto qmi_message_dms_uim_change_pin_output_pin_retries_status_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Pin Retries Status' TLV", offset);
            }

            self->arg_pin_retries_status_set = TRUE;

qmi_message_dms_uim_change_pin_output_pin_retries_status_out:
            ;

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS UIM Get PIN Status */


/* --- Input -- */

/* Note: no fields in the Input container */

static QmiMessage *
__qmi_message_dms_uim_get_pin_status_request_create (
    guint16 transaction_id,
    guint8 cid,
    gpointer unused,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_UIM_GET_PIN_STATUS);

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsUimGetPinStatusOutput {
    volatile gint ref_count;

    /* PIN2 Status */
    gboolean arg_pin2_status_set;
    guint8 arg_pin2_status_current_status;
    guint8 arg_pin2_status_verify_retries_left;
    guint8 arg_pin2_status_unblock_retries_left;

    /* PIN1 Status */
    gboolean arg_pin1_status_set;
    guint8 arg_pin1_status_current_status;
    guint8 arg_pin1_status_verify_retries_left;
    guint8 arg_pin1_status_unblock_retries_left;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;
};

#define QMI_MESSAGE_DMS_UIM_GET_PIN_STATUS_OUTPUT_TLV_PIN2_STATUS 0x12
#define QMI_MESSAGE_DMS_UIM_GET_PIN_STATUS_OUTPUT_TLV_PIN1_STATUS 0x11
#define QMI_MESSAGE_DMS_UIM_GET_PIN_STATUS_OUTPUT_TLV_RESULT 0x02

gboolean
qmi_message_dms_uim_get_pin_status_output_get_pin2_status (
    QmiMessageDmsUimGetPinStatusOutput *self,
    QmiDmsUimPinStatus *value_pin2_status_current_status,
    guint8 *value_pin2_status_verify_retries_left,
    guint8 *value_pin2_status_unblock_retries_left,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_pin2_status_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'PIN2 Status' was not found in the message");
        return FALSE;
    }

    if (value_pin2_status_current_status)
        *value_pin2_status_current_status = (QmiDmsUimPinStatus)(self->arg_pin2_status_current_status);
    if (value_pin2_status_verify_retries_left)
        *value_pin2_status_verify_retries_left = self->arg_pin2_status_verify_retries_left;
    if (value_pin2_status_unblock_retries_left)
        *value_pin2_status_unblock_retries_left = self->arg_pin2_status_unblock_retries_left;

    return TRUE;
}

gboolean
qmi_message_dms_uim_get_pin_status_output_get_pin1_status (
    QmiMessageDmsUimGetPinStatusOutput *self,
    QmiDmsUimPinStatus *value_pin1_status_current_status,
    guint8 *value_pin1_status_verify_retries_left,
    guint8 *value_pin1_status_unblock_retries_left,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_pin1_status_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'PIN1 Status' was not found in the message");
        return FALSE;
    }

    if (value_pin1_status_current_status)
        *value_pin1_status_current_status = (QmiDmsUimPinStatus)(self->arg_pin1_status_current_status);
    if (value_pin1_status_verify_retries_left)
        *value_pin1_status_verify_retries_left = self->arg_pin1_status_verify_retries_left;
    if (value_pin1_status_unblock_retries_left)
        *value_pin1_status_unblock_retries_left = self->arg_pin1_status_unblock_retries_left;

    return TRUE;
}

gboolean
qmi_message_dms_uim_get_pin_status_output_get_result (
    QmiMessageDmsUimGetPinStatusOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

GType
qmi_message_dms_uim_get_pin_status_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsUimGetPinStatusOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_uim_get_pin_status_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_uim_get_pin_status_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsUimGetPinStatusOutput *
qmi_message_dms_uim_get_pin_status_output_ref (QmiMessageDmsUimGetPinStatusOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_uim_get_pin_status_output_unref (QmiMessageDmsUimGetPinStatusOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsUimGetPinStatusOutput, self);
    }
}

static gchar *
qmi_message_dms_uim_get_pin_status_output_pin2_status_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_UIM_GET_PIN_STATUS_OUTPUT_TLV_PIN2_STATUS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " current_status = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_DMS_UIM_PIN_STATUS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_dms_uim_pin_status_get_string ((QmiDmsUimPinStatus)tmp));
#elif defined  __QMI_DMS_UIM_PIN_STATUS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_dms_uim_pin_status_build_string_from_mask ((QmiDmsUimPinStatus)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiDmsUimPinStatus
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " verify_retries_left = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " unblock_retries_left = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_uim_get_pin_status_output_pin1_status_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_UIM_GET_PIN_STATUS_OUTPUT_TLV_PIN1_STATUS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " current_status = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_DMS_UIM_PIN_STATUS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_dms_uim_pin_status_get_string ((QmiDmsUimPinStatus)tmp));
#elif defined  __QMI_DMS_UIM_PIN_STATUS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_dms_uim_pin_status_build_string_from_mask ((QmiDmsUimPinStatus)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiDmsUimPinStatus
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " verify_retries_left = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " unblock_retries_left = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_uim_get_pin_status_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_uim_get_pin_status_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_uim_get_pin_status_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_UIM_GET_PIN_STATUS_OUTPUT_TLV_PIN2_STATUS:
            tlv_type_str = "PIN2 Status";
            translated_value = qmi_message_dms_uim_get_pin_status_output_pin2_status_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_UIM_GET_PIN_STATUS_OUTPUT_TLV_PIN1_STATUS:
            tlv_type_str = "PIN1 Status";
            translated_value = qmi_message_dms_uim_get_pin_status_output_pin1_status_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_UIM_GET_PIN_STATUS_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_uim_get_pin_status_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"UIM Get PIN Status\" (0x002B)\n",
                            line_prefix);

    {
        struct message_uim_get_pin_status_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_uim_get_pin_status_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsUimGetPinStatusOutput *
qmi_message_dms_uim_get_pin_status_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsUimGetPinStatusOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_UIM_GET_PIN_STATUS);

    self = g_slice_new0 (QmiMessageDmsUimGetPinStatusOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_UIM_GET_PIN_STATUS_OUTPUT_TLV_PIN2_STATUS, NULL, NULL)) == 0) {
                goto qmi_message_dms_uim_get_pin_status_output_pin2_status_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_message_dms_uim_get_pin_status_output_pin2_status_out;
                self->arg_pin2_status_current_status = (QmiDmsUimPinStatus)tmp;
            }
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_pin2_status_verify_retries_left), NULL))
                goto qmi_message_dms_uim_get_pin_status_output_pin2_status_out;
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_pin2_status_unblock_retries_left), NULL))
                goto qmi_message_dms_uim_get_pin_status_output_pin2_status_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'PIN2 Status' TLV", offset);
            }

            self->arg_pin2_status_set = TRUE;

qmi_message_dms_uim_get_pin_status_output_pin2_status_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_UIM_GET_PIN_STATUS_OUTPUT_TLV_PIN1_STATUS, NULL, NULL)) == 0) {
                goto qmi_message_dms_uim_get_pin_status_output_pin1_status_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_message_dms_uim_get_pin_status_output_pin1_status_out;
                self->arg_pin1_status_current_status = (QmiDmsUimPinStatus)tmp;
            }
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_pin1_status_verify_retries_left), NULL))
                goto qmi_message_dms_uim_get_pin_status_output_pin1_status_out;
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_pin1_status_unblock_retries_left), NULL))
                goto qmi_message_dms_uim_get_pin_status_output_pin1_status_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'PIN1 Status' TLV", offset);
            }

            self->arg_pin1_status_set = TRUE;

qmi_message_dms_uim_get_pin_status_output_pin1_status_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_UIM_GET_PIN_STATUS_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_uim_get_pin_status_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_uim_get_pin_status_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS Get Hardware Revision */


/* --- Input -- */

/* Note: no fields in the Input container */

static QmiMessage *
__qmi_message_dms_get_hardware_revision_request_create (
    guint16 transaction_id,
    guint8 cid,
    gpointer unused,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_GET_HARDWARE_REVISION);

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsGetHardwareRevisionOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* Revision */
    gboolean arg_revision_set;
    gchar *arg_revision;
};

#define QMI_MESSAGE_DMS_GET_HARDWARE_REVISION_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_DMS_GET_HARDWARE_REVISION_OUTPUT_TLV_REVISION 0x01

gboolean
qmi_message_dms_get_hardware_revision_output_get_result (
    QmiMessageDmsGetHardwareRevisionOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_dms_get_hardware_revision_output_get_revision (
    QmiMessageDmsGetHardwareRevisionOutput *self,
    const gchar **value_revision,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_revision_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Revision' was not found in the message");
        return FALSE;
    }

    if (value_revision)
        *value_revision = self->arg_revision;

    return TRUE;
}

GType
qmi_message_dms_get_hardware_revision_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsGetHardwareRevisionOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_get_hardware_revision_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_get_hardware_revision_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsGetHardwareRevisionOutput *
qmi_message_dms_get_hardware_revision_output_ref (QmiMessageDmsGetHardwareRevisionOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_get_hardware_revision_output_unref (QmiMessageDmsGetHardwareRevisionOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_revision, (GDestroyNotify)g_free);
        g_slice_free (QmiMessageDmsGetHardwareRevisionOutput, self);
    }
}

static gchar *
qmi_message_dms_get_hardware_revision_output_revision_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_HARDWARE_REVISION_OUTPUT_TLV_REVISION, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &tmp, &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_get_hardware_revision_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_get_hardware_revision_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_get_hardware_revision_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_GET_HARDWARE_REVISION_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_GET_HARDWARE_REVISION_OUTPUT_TLV_REVISION:
            tlv_type_str = "Revision";
            translated_value = qmi_message_dms_get_hardware_revision_output_revision_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_get_hardware_revision_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Get Hardware Revision\" (0x002C)\n",
                            line_prefix);

    {
        struct message_get_hardware_revision_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_get_hardware_revision_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsGetHardwareRevisionOutput *
qmi_message_dms_get_hardware_revision_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsGetHardwareRevisionOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_GET_HARDWARE_REVISION);

    self = g_slice_new0 (QmiMessageDmsGetHardwareRevisionOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_HARDWARE_REVISION_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_get_hardware_revision_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_get_hardware_revision_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_HARDWARE_REVISION_OUTPUT_TLV_REVISION, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Revision TLV: ");
                qmi_message_dms_get_hardware_revision_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &(self->arg_revision), error))
                goto qmi_message_dms_get_hardware_revision_output_revision_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Revision' TLV", offset);
            }

            self->arg_revision_set = TRUE;

qmi_message_dms_get_hardware_revision_output_revision_out:
            if (!self->arg_revision_set) {
                qmi_message_dms_get_hardware_revision_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS Get Operating Mode */


/* --- Input -- */

/* Note: no fields in the Input container */

static QmiMessage *
__qmi_message_dms_get_operating_mode_request_create (
    guint16 transaction_id,
    guint8 cid,
    gpointer unused,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_GET_OPERATING_MODE);

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsGetOperatingModeOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* Mode */
    gboolean arg_mode_set;
    guint8 arg_mode;

    /* Offline Reason */
    gboolean arg_offline_reason_set;
    guint16 arg_offline_reason;

    /* Hardware Restricted Mode */
    gboolean arg_hardware_restricted_mode_set;
    guint8 arg_hardware_restricted_mode;
};

#define QMI_MESSAGE_DMS_GET_OPERATING_MODE_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_DMS_GET_OPERATING_MODE_OUTPUT_TLV_MODE 0x01
#define QMI_MESSAGE_DMS_GET_OPERATING_MODE_OUTPUT_TLV_OFFLINE_REASON 0x10
#define QMI_MESSAGE_DMS_GET_OPERATING_MODE_OUTPUT_TLV_HARDWARE_RESTRICTED_MODE 0x11

gboolean
qmi_message_dms_get_operating_mode_output_get_result (
    QmiMessageDmsGetOperatingModeOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_dms_get_operating_mode_output_get_mode (
    QmiMessageDmsGetOperatingModeOutput *self,
    QmiDmsOperatingMode *value_mode,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_mode_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Mode' was not found in the message");
        return FALSE;
    }

    if (value_mode)
        *value_mode = (QmiDmsOperatingMode)(self->arg_mode);

    return TRUE;
}

gboolean
qmi_message_dms_get_operating_mode_output_get_offline_reason (
    QmiMessageDmsGetOperatingModeOutput *self,
    QmiDmsOfflineReason *value_offline_reason,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_offline_reason_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Offline Reason' was not found in the message");
        return FALSE;
    }

    if (value_offline_reason)
        *value_offline_reason = (QmiDmsOfflineReason)(self->arg_offline_reason);

    return TRUE;
}

gboolean
qmi_message_dms_get_operating_mode_output_get_hardware_restricted_mode (
    QmiMessageDmsGetOperatingModeOutput *self,
    gboolean *value_hardware_restricted_mode,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_hardware_restricted_mode_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Hardware Restricted Mode' was not found in the message");
        return FALSE;
    }

    if (value_hardware_restricted_mode)
        *value_hardware_restricted_mode = (gboolean)(self->arg_hardware_restricted_mode);

    return TRUE;
}

GType
qmi_message_dms_get_operating_mode_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsGetOperatingModeOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_get_operating_mode_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_get_operating_mode_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsGetOperatingModeOutput *
qmi_message_dms_get_operating_mode_output_ref (QmiMessageDmsGetOperatingModeOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_get_operating_mode_output_unref (QmiMessageDmsGetOperatingModeOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsGetOperatingModeOutput, self);
    }
}

static gchar *
qmi_message_dms_get_operating_mode_output_mode_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_OPERATING_MODE_OUTPUT_TLV_MODE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_DMS_OPERATING_MODE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_dms_operating_mode_get_string ((QmiDmsOperatingMode)tmp));
#elif defined  __QMI_DMS_OPERATING_MODE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_dms_operating_mode_build_string_from_mask ((QmiDmsOperatingMode)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiDmsOperatingMode
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_get_operating_mode_output_offline_reason_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_OPERATING_MODE_OUTPUT_TLV_OFFLINE_REASON, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
#if defined  __QMI_DMS_OFFLINE_REASON_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_dms_offline_reason_get_string ((QmiDmsOfflineReason)tmp));
#elif defined  __QMI_DMS_OFFLINE_REASON_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_dms_offline_reason_build_string_from_mask ((QmiDmsOfflineReason)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiDmsOfflineReason
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_get_operating_mode_output_hardware_restricted_mode_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_OPERATING_MODE_OUTPUT_TLV_HARDWARE_RESTRICTED_MODE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_get_operating_mode_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_get_operating_mode_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_get_operating_mode_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_GET_OPERATING_MODE_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_GET_OPERATING_MODE_OUTPUT_TLV_MODE:
            tlv_type_str = "Mode";
            translated_value = qmi_message_dms_get_operating_mode_output_mode_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_GET_OPERATING_MODE_OUTPUT_TLV_OFFLINE_REASON:
            tlv_type_str = "Offline Reason";
            translated_value = qmi_message_dms_get_operating_mode_output_offline_reason_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_GET_OPERATING_MODE_OUTPUT_TLV_HARDWARE_RESTRICTED_MODE:
            tlv_type_str = "Hardware Restricted Mode";
            translated_value = qmi_message_dms_get_operating_mode_output_hardware_restricted_mode_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_get_operating_mode_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Get Operating Mode\" (0x002D)\n",
                            line_prefix);

    {
        struct message_get_operating_mode_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_get_operating_mode_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsGetOperatingModeOutput *
qmi_message_dms_get_operating_mode_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsGetOperatingModeOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_GET_OPERATING_MODE);

    self = g_slice_new0 (QmiMessageDmsGetOperatingModeOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_OPERATING_MODE_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_get_operating_mode_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_get_operating_mode_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_OPERATING_MODE_OUTPUT_TLV_MODE, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Mode TLV: ");
                qmi_message_dms_get_operating_mode_output_unref (self);
                return NULL;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, error))
                    goto qmi_message_dms_get_operating_mode_output_mode_out;
                self->arg_mode = (QmiDmsOperatingMode)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Mode' TLV", offset);
            }

            self->arg_mode_set = TRUE;

qmi_message_dms_get_operating_mode_output_mode_out:
            if (!self->arg_mode_set) {
                qmi_message_dms_get_operating_mode_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_mode == QMI_DMS_OPERATING_MODE_OFFLINE))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_OPERATING_MODE_OUTPUT_TLV_OFFLINE_REASON, NULL, NULL)) == 0) {
                goto qmi_message_dms_get_operating_mode_output_offline_reason_out;
            }
            {
                guint16 tmp;

                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, NULL))
                    goto qmi_message_dms_get_operating_mode_output_offline_reason_out;
                self->arg_offline_reason = (QmiDmsOfflineReason)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Offline Reason' TLV", offset);
            }

            self->arg_offline_reason_set = TRUE;

qmi_message_dms_get_operating_mode_output_offline_reason_out:
            ;

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_OPERATING_MODE_OUTPUT_TLV_HARDWARE_RESTRICTED_MODE, NULL, NULL)) == 0) {
                goto qmi_message_dms_get_operating_mode_output_hardware_restricted_mode_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_message_dms_get_operating_mode_output_hardware_restricted_mode_out;
                self->arg_hardware_restricted_mode = (gboolean)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Hardware Restricted Mode' TLV", offset);
            }

            self->arg_hardware_restricted_mode_set = TRUE;

qmi_message_dms_get_operating_mode_output_hardware_restricted_mode_out:
            ;

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS Set Operating Mode */


/* --- Input -- */

struct _QmiMessageDmsSetOperatingModeInput {
    volatile gint ref_count;

    /* Mode */
    gboolean arg_mode_set;
    guint8 arg_mode;
};

#define QMI_MESSAGE_DMS_SET_OPERATING_MODE_INPUT_TLV_MODE 0x01

gboolean
qmi_message_dms_set_operating_mode_input_get_mode (
    QmiMessageDmsSetOperatingModeInput *self,
    QmiDmsOperatingMode *value_mode,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_mode_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Mode' was not found in the message");
        return FALSE;
    }

    if (value_mode)
        *value_mode = (QmiDmsOperatingMode)(self->arg_mode);

    return TRUE;
}

gboolean
qmi_message_dms_set_operating_mode_input_set_mode (
    QmiMessageDmsSetOperatingModeInput *self,
    QmiDmsOperatingMode value_mode,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_mode = (guint8)(value_mode);
    self->arg_mode_set = TRUE;

    return TRUE;
}

GType
qmi_message_dms_set_operating_mode_input_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsSetOperatingModeInput"),
                                          (GBoxedCopyFunc) qmi_message_dms_set_operating_mode_input_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_set_operating_mode_input_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsSetOperatingModeInput *
qmi_message_dms_set_operating_mode_input_ref (QmiMessageDmsSetOperatingModeInput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_set_operating_mode_input_unref (QmiMessageDmsSetOperatingModeInput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsSetOperatingModeInput, self);
    }
}

QmiMessageDmsSetOperatingModeInput *
qmi_message_dms_set_operating_mode_input_new (void)
{
    QmiMessageDmsSetOperatingModeInput *self;

    self = g_slice_new0 (QmiMessageDmsSetOperatingModeInput);
    self->ref_count = 1;
    return self;
}

static QmiMessage *
__qmi_message_dms_set_operating_mode_request_create (
    guint16 transaction_id,
    guint8 cid,
    QmiMessageDmsSetOperatingModeInput *input,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_SET_OPERATING_MODE);

    /* There is at least one mandatory TLV, don't allow NULL input */
    if (!input) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Message 'Set Operating Mode' has mandatory TLVs");
        return NULL;
    }

    /* Try to add the 'Mode' TLV */
    if (input->arg_mode_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_DMS_SET_OPERATING_MODE_INPUT_TLV_MODE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Mode': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_mode;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Mode': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Mode': ");
            return NULL;
        }
    } else {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Missing mandatory TLV 'Mode' in message 'Set Operating Mode'");
        return NULL;
    }

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsSetOperatingModeOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;
};

#define QMI_MESSAGE_DMS_SET_OPERATING_MODE_OUTPUT_TLV_RESULT 0x02

gboolean
qmi_message_dms_set_operating_mode_output_get_result (
    QmiMessageDmsSetOperatingModeOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

GType
qmi_message_dms_set_operating_mode_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsSetOperatingModeOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_set_operating_mode_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_set_operating_mode_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsSetOperatingModeOutput *
qmi_message_dms_set_operating_mode_output_ref (QmiMessageDmsSetOperatingModeOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_set_operating_mode_output_unref (QmiMessageDmsSetOperatingModeOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsSetOperatingModeOutput, self);
    }
}

static gchar *
qmi_message_dms_set_operating_mode_input_mode_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SET_OPERATING_MODE_INPUT_TLV_MODE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_DMS_OPERATING_MODE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_dms_operating_mode_get_string ((QmiDmsOperatingMode)tmp));
#elif defined  __QMI_DMS_OPERATING_MODE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_dms_operating_mode_build_string_from_mask ((QmiDmsOperatingMode)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiDmsOperatingMode
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_set_operating_mode_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_set_operating_mode_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_set_operating_mode_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        case QMI_MESSAGE_DMS_SET_OPERATING_MODE_INPUT_TLV_MODE:
            tlv_type_str = "Mode";
            translated_value = qmi_message_dms_set_operating_mode_input_mode_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_SET_OPERATING_MODE_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_set_operating_mode_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Set Operating Mode\" (0x002E)\n",
                            line_prefix);

    {
        struct message_set_operating_mode_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_set_operating_mode_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsSetOperatingModeOutput *
qmi_message_dms_set_operating_mode_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsSetOperatingModeOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_SET_OPERATING_MODE);

    self = g_slice_new0 (QmiMessageDmsSetOperatingModeOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SET_OPERATING_MODE_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_set_operating_mode_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_set_operating_mode_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS Get Time */


/* --- Input -- */

/* Note: no fields in the Input container */

static QmiMessage *
__qmi_message_dms_get_time_request_create (
    guint16 transaction_id,
    guint8 cid,
    gpointer unused,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_GET_TIME);

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsGetTimeOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* Device Time */
    gboolean arg_device_time_set;
    guint64 arg_device_time_time_count;
    guint16 arg_device_time_time_source;

    /* System Time */
    gboolean arg_system_time_set;
    guint64 arg_system_time;

    /* User Time */
    gboolean arg_user_time_set;
    guint64 arg_user_time;
};

#define QMI_MESSAGE_DMS_GET_TIME_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_DMS_GET_TIME_OUTPUT_TLV_DEVICE_TIME 0x01
#define QMI_MESSAGE_DMS_GET_TIME_OUTPUT_TLV_SYSTEM_TIME 0x10
#define QMI_MESSAGE_DMS_GET_TIME_OUTPUT_TLV_USER_TIME 0x11

gboolean
qmi_message_dms_get_time_output_get_result (
    QmiMessageDmsGetTimeOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_dms_get_time_output_get_device_time (
    QmiMessageDmsGetTimeOutput *self,
    guint64 *value_device_time_time_count,
    QmiDmsTimeSource *value_device_time_time_source,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_device_time_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Device Time' was not found in the message");
        return FALSE;
    }

    if (value_device_time_time_count)
        *value_device_time_time_count = self->arg_device_time_time_count;
    if (value_device_time_time_source)
        *value_device_time_time_source = (QmiDmsTimeSource)(self->arg_device_time_time_source);

    return TRUE;
}

gboolean
qmi_message_dms_get_time_output_get_system_time (
    QmiMessageDmsGetTimeOutput *self,
    guint64 *value_system_time,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_system_time_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'System Time' was not found in the message");
        return FALSE;
    }

    if (value_system_time)
        *value_system_time = self->arg_system_time;

    return TRUE;
}

gboolean
qmi_message_dms_get_time_output_get_user_time (
    QmiMessageDmsGetTimeOutput *self,
    guint64 *value_user_time,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_user_time_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'User Time' was not found in the message");
        return FALSE;
    }

    if (value_user_time)
        *value_user_time = self->arg_user_time;

    return TRUE;
}

GType
qmi_message_dms_get_time_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsGetTimeOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_get_time_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_get_time_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsGetTimeOutput *
qmi_message_dms_get_time_output_ref (QmiMessageDmsGetTimeOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_get_time_output_unref (QmiMessageDmsGetTimeOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsGetTimeOutput, self);
    }
}

static gchar *
qmi_message_dms_get_time_output_device_time_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_TIME_OUTPUT_TLV_DEVICE_TIME, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " time_count = '");

    {
        guint64 tmp;

        if (!qmi_message_tlv_read_sized_guint (message, init_offset, &offset, 6, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT64_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " time_source = '");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
#if defined  __QMI_DMS_TIME_SOURCE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_dms_time_source_get_string ((QmiDmsTimeSource)tmp));
#elif defined  __QMI_DMS_TIME_SOURCE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_dms_time_source_build_string_from_mask ((QmiDmsTimeSource)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiDmsTimeSource
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_get_time_output_system_time_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_TIME_OUTPUT_TLV_SYSTEM_TIME, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint64 tmp;

        if (!qmi_message_tlv_read_guint64 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT64_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_get_time_output_user_time_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_TIME_OUTPUT_TLV_USER_TIME, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint64 tmp;

        if (!qmi_message_tlv_read_guint64 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT64_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_get_time_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_get_time_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_get_time_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_GET_TIME_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_GET_TIME_OUTPUT_TLV_DEVICE_TIME:
            tlv_type_str = "Device Time";
            translated_value = qmi_message_dms_get_time_output_device_time_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_GET_TIME_OUTPUT_TLV_SYSTEM_TIME:
            tlv_type_str = "System Time";
            translated_value = qmi_message_dms_get_time_output_system_time_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_GET_TIME_OUTPUT_TLV_USER_TIME:
            tlv_type_str = "User Time";
            translated_value = qmi_message_dms_get_time_output_user_time_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_get_time_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Get Time\" (0x002F)\n",
                            line_prefix);

    {
        struct message_get_time_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_get_time_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsGetTimeOutput *
qmi_message_dms_get_time_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsGetTimeOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_GET_TIME);

    self = g_slice_new0 (QmiMessageDmsGetTimeOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_TIME_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_get_time_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_get_time_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_TIME_OUTPUT_TLV_DEVICE_TIME, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Device Time TLV: ");
                qmi_message_dms_get_time_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_sized_guint (message, init_offset, &offset, 6, QMI_ENDIAN_LITTLE, &(self->arg_device_time_time_count), error))
                goto qmi_message_dms_get_time_output_device_time_out;
            {
                guint16 tmp;

                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, error))
                    goto qmi_message_dms_get_time_output_device_time_out;
                self->arg_device_time_time_source = (QmiDmsTimeSource)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Device Time' TLV", offset);
            }

            self->arg_device_time_set = TRUE;

qmi_message_dms_get_time_output_device_time_out:
            if (!self->arg_device_time_set) {
                qmi_message_dms_get_time_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_TIME_OUTPUT_TLV_SYSTEM_TIME, NULL, NULL)) == 0) {
                goto qmi_message_dms_get_time_output_system_time_out;
            }
            if (!qmi_message_tlv_read_guint64 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_system_time), NULL))
                goto qmi_message_dms_get_time_output_system_time_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'System Time' TLV", offset);
            }

            self->arg_system_time_set = TRUE;

qmi_message_dms_get_time_output_system_time_out:
            ;

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_TIME_OUTPUT_TLV_USER_TIME, NULL, NULL)) == 0) {
                goto qmi_message_dms_get_time_output_user_time_out;
            }
            if (!qmi_message_tlv_read_guint64 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_user_time), NULL))
                goto qmi_message_dms_get_time_output_user_time_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'User Time' TLV", offset);
            }

            self->arg_user_time_set = TRUE;

qmi_message_dms_get_time_output_user_time_out:
            ;

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS Get PRL Version */


/* --- Input -- */

/* Note: no fields in the Input container */

static QmiMessage *
__qmi_message_dms_get_prl_version_request_create (
    guint16 transaction_id,
    guint8 cid,
    gpointer unused,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_GET_PRL_VERSION);

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsGetPrlVersionOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* Version */
    gboolean arg_version_set;
    guint16 arg_version;

    /* PRL Only Preference */
    gboolean arg_prl_only_preference_set;
    guint8 arg_prl_only_preference;
};

#define QMI_MESSAGE_DMS_GET_PRL_VERSION_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_DMS_GET_PRL_VERSION_OUTPUT_TLV_VERSION 0x01
#define QMI_MESSAGE_DMS_GET_PRL_VERSION_OUTPUT_TLV_PRL_ONLY_PREFERENCE 0x10

gboolean
qmi_message_dms_get_prl_version_output_get_result (
    QmiMessageDmsGetPrlVersionOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_dms_get_prl_version_output_get_version (
    QmiMessageDmsGetPrlVersionOutput *self,
    guint16 *value_version,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_version_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Version' was not found in the message");
        return FALSE;
    }

    if (value_version)
        *value_version = self->arg_version;

    return TRUE;
}

gboolean
qmi_message_dms_get_prl_version_output_get_prl_only_preference (
    QmiMessageDmsGetPrlVersionOutput *self,
    gboolean *value_prl_only_preference,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_prl_only_preference_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'PRL Only Preference' was not found in the message");
        return FALSE;
    }

    if (value_prl_only_preference)
        *value_prl_only_preference = (gboolean)(self->arg_prl_only_preference);

    return TRUE;
}

GType
qmi_message_dms_get_prl_version_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsGetPrlVersionOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_get_prl_version_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_get_prl_version_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsGetPrlVersionOutput *
qmi_message_dms_get_prl_version_output_ref (QmiMessageDmsGetPrlVersionOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_get_prl_version_output_unref (QmiMessageDmsGetPrlVersionOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsGetPrlVersionOutput, self);
    }
}

static gchar *
qmi_message_dms_get_prl_version_output_version_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_PRL_VERSION_OUTPUT_TLV_VERSION, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_get_prl_version_output_prl_only_preference_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_PRL_VERSION_OUTPUT_TLV_PRL_ONLY_PREFERENCE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_get_prl_version_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_get_prl_version_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_get_prl_version_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_GET_PRL_VERSION_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_GET_PRL_VERSION_OUTPUT_TLV_VERSION:
            tlv_type_str = "Version";
            translated_value = qmi_message_dms_get_prl_version_output_version_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_GET_PRL_VERSION_OUTPUT_TLV_PRL_ONLY_PREFERENCE:
            tlv_type_str = "PRL Only Preference";
            translated_value = qmi_message_dms_get_prl_version_output_prl_only_preference_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_get_prl_version_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Get PRL Version\" (0x0030)\n",
                            line_prefix);

    {
        struct message_get_prl_version_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_get_prl_version_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsGetPrlVersionOutput *
qmi_message_dms_get_prl_version_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsGetPrlVersionOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_GET_PRL_VERSION);

    self = g_slice_new0 (QmiMessageDmsGetPrlVersionOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_PRL_VERSION_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_get_prl_version_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_get_prl_version_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_PRL_VERSION_OUTPUT_TLV_VERSION, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Version TLV: ");
                qmi_message_dms_get_prl_version_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_version), error))
                goto qmi_message_dms_get_prl_version_output_version_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Version' TLV", offset);
            }

            self->arg_version_set = TRUE;

qmi_message_dms_get_prl_version_output_version_out:
            if (!self->arg_version_set) {
                qmi_message_dms_get_prl_version_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_PRL_VERSION_OUTPUT_TLV_PRL_ONLY_PREFERENCE, NULL, NULL)) == 0) {
                goto qmi_message_dms_get_prl_version_output_prl_only_preference_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_message_dms_get_prl_version_output_prl_only_preference_out;
                self->arg_prl_only_preference = (gboolean)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'PRL Only Preference' TLV", offset);
            }

            self->arg_prl_only_preference_set = TRUE;

qmi_message_dms_get_prl_version_output_prl_only_preference_out:
            ;

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS Get Activation State */


/* --- Input -- */

/* Note: no fields in the Input container */

static QmiMessage *
__qmi_message_dms_get_activation_state_request_create (
    guint16 transaction_id,
    guint8 cid,
    gpointer unused,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_GET_ACTIVATION_STATE);

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsGetActivationStateOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* Info */
    gboolean arg_info_set;
    guint16 arg_info;
};

#define QMI_MESSAGE_DMS_GET_ACTIVATION_STATE_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_DMS_GET_ACTIVATION_STATE_OUTPUT_TLV_INFO 0x01

gboolean
qmi_message_dms_get_activation_state_output_get_result (
    QmiMessageDmsGetActivationStateOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_dms_get_activation_state_output_get_info (
    QmiMessageDmsGetActivationStateOutput *self,
    QmiDmsActivationState *value_info,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_info_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Info' was not found in the message");
        return FALSE;
    }

    if (value_info)
        *value_info = (QmiDmsActivationState)(self->arg_info);

    return TRUE;
}

GType
qmi_message_dms_get_activation_state_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsGetActivationStateOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_get_activation_state_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_get_activation_state_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsGetActivationStateOutput *
qmi_message_dms_get_activation_state_output_ref (QmiMessageDmsGetActivationStateOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_get_activation_state_output_unref (QmiMessageDmsGetActivationStateOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsGetActivationStateOutput, self);
    }
}

static gchar *
qmi_message_dms_get_activation_state_output_info_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_ACTIVATION_STATE_OUTPUT_TLV_INFO, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
#if defined  __QMI_DMS_ACTIVATION_STATE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_dms_activation_state_get_string ((QmiDmsActivationState)tmp));
#elif defined  __QMI_DMS_ACTIVATION_STATE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_dms_activation_state_build_string_from_mask ((QmiDmsActivationState)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiDmsActivationState
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_get_activation_state_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_get_activation_state_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_get_activation_state_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_GET_ACTIVATION_STATE_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_GET_ACTIVATION_STATE_OUTPUT_TLV_INFO:
            tlv_type_str = "Info";
            translated_value = qmi_message_dms_get_activation_state_output_info_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_get_activation_state_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Get Activation State\" (0x0031)\n",
                            line_prefix);

    {
        struct message_get_activation_state_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_get_activation_state_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsGetActivationStateOutput *
qmi_message_dms_get_activation_state_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsGetActivationStateOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_GET_ACTIVATION_STATE);

    self = g_slice_new0 (QmiMessageDmsGetActivationStateOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_ACTIVATION_STATE_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_get_activation_state_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_get_activation_state_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_ACTIVATION_STATE_OUTPUT_TLV_INFO, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Info TLV: ");
                qmi_message_dms_get_activation_state_output_unref (self);
                return NULL;
            }
            {
                guint16 tmp;

                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, error))
                    goto qmi_message_dms_get_activation_state_output_info_out;
                self->arg_info = (QmiDmsActivationState)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Info' TLV", offset);
            }

            self->arg_info_set = TRUE;

qmi_message_dms_get_activation_state_output_info_out:
            if (!self->arg_info_set) {
                qmi_message_dms_get_activation_state_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS Activate Automatic */


/* --- Input -- */

struct _QmiMessageDmsActivateAutomaticInput {
    volatile gint ref_count;

    /* Activation Code */
    gboolean arg_activation_code_set;
    gchar *arg_activation_code;
};

#define QMI_MESSAGE_DMS_ACTIVATE_AUTOMATIC_INPUT_TLV_ACTIVATION_CODE 0x01

gboolean
qmi_message_dms_activate_automatic_input_get_activation_code (
    QmiMessageDmsActivateAutomaticInput *self,
    const gchar **value_activation_code,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_activation_code_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Activation Code' was not found in the message");
        return FALSE;
    }

    if (value_activation_code)
        *value_activation_code = self->arg_activation_code;

    return TRUE;
}

gboolean
qmi_message_dms_activate_automatic_input_set_activation_code (
    QmiMessageDmsActivateAutomaticInput *self,
    const gchar *value_activation_code,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    g_free (self->arg_activation_code);
    self->arg_activation_code = g_strdup (value_activation_code ? value_activation_code : "");
    self->arg_activation_code_set = TRUE;

    return TRUE;
}

GType
qmi_message_dms_activate_automatic_input_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsActivateAutomaticInput"),
                                          (GBoxedCopyFunc) qmi_message_dms_activate_automatic_input_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_activate_automatic_input_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsActivateAutomaticInput *
qmi_message_dms_activate_automatic_input_ref (QmiMessageDmsActivateAutomaticInput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_activate_automatic_input_unref (QmiMessageDmsActivateAutomaticInput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_activation_code, (GDestroyNotify)g_free);
        g_slice_free (QmiMessageDmsActivateAutomaticInput, self);
    }
}

QmiMessageDmsActivateAutomaticInput *
qmi_message_dms_activate_automatic_input_new (void)
{
    QmiMessageDmsActivateAutomaticInput *self;

    self = g_slice_new0 (QmiMessageDmsActivateAutomaticInput);
    self->ref_count = 1;
    return self;
}

static QmiMessage *
__qmi_message_dms_activate_automatic_request_create (
    guint16 transaction_id,
    guint8 cid,
    QmiMessageDmsActivateAutomaticInput *input,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_ACTIVATE_AUTOMATIC);

    /* There is at least one mandatory TLV, don't allow NULL input */
    if (!input) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Message 'Activate Automatic' has mandatory TLVs");
        return NULL;
    }

    /* Try to add the 'Activation Code' TLV */
    if (input->arg_activation_code_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_DMS_ACTIVATE_AUTOMATIC_INPUT_TLV_ACTIVATION_CODE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Activation Code': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_string (self, 1, input->arg_activation_code, -1, error)) {
            g_prefix_error (error, "Cannot write string in TLV 'Activation Code': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Activation Code': ");
            return NULL;
        }
    } else {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Missing mandatory TLV 'Activation Code' in message 'Activate Automatic'");
        return NULL;
    }

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsActivateAutomaticOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;
};

#define QMI_MESSAGE_DMS_ACTIVATE_AUTOMATIC_OUTPUT_TLV_RESULT 0x02

gboolean
qmi_message_dms_activate_automatic_output_get_result (
    QmiMessageDmsActivateAutomaticOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

GType
qmi_message_dms_activate_automatic_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsActivateAutomaticOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_activate_automatic_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_activate_automatic_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsActivateAutomaticOutput *
qmi_message_dms_activate_automatic_output_ref (QmiMessageDmsActivateAutomaticOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_activate_automatic_output_unref (QmiMessageDmsActivateAutomaticOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsActivateAutomaticOutput, self);
    }
}

static gchar *
qmi_message_dms_activate_automatic_input_activation_code_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_ACTIVATE_AUTOMATIC_INPUT_TLV_ACTIVATION_CODE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 1, 0, &tmp, &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_activate_automatic_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_activate_automatic_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_activate_automatic_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        case QMI_MESSAGE_DMS_ACTIVATE_AUTOMATIC_INPUT_TLV_ACTIVATION_CODE:
            tlv_type_str = "Activation Code";
            translated_value = qmi_message_dms_activate_automatic_input_activation_code_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_ACTIVATE_AUTOMATIC_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_activate_automatic_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Activate Automatic\" (0x0032)\n",
                            line_prefix);

    {
        struct message_activate_automatic_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_activate_automatic_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsActivateAutomaticOutput *
qmi_message_dms_activate_automatic_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsActivateAutomaticOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_ACTIVATE_AUTOMATIC);

    self = g_slice_new0 (QmiMessageDmsActivateAutomaticOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_ACTIVATE_AUTOMATIC_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_activate_automatic_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_activate_automatic_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS Activate Manual */


/* --- Input -- */

struct _QmiMessageDmsActivateManualInput {
    volatile gint ref_count;

    /* PRL */
    gboolean arg_prl_set;
    guint16 arg_prl_prl_total_length;
    guint8 arg_prl_prl_segment_sequence;
    GArray *arg_prl_prl_segment;

    /* MN AAA key */
    gboolean arg_mn_aaa_key_set;
    gchar *arg_mn_aaa_key;

    /* MN HA key */
    gboolean arg_mn_ha_key_set;
    gchar *arg_mn_ha_key;

    /* Info */
    gboolean arg_info_set;
    gchar arg_info_service_programming_code[7];
    guint16 arg_info_system_identification_number;
    gchar *arg_info_mobile_directory_number;
    gchar *arg_info_mobile_identification_number;
};

#define QMI_MESSAGE_DMS_ACTIVATE_MANUAL_INPUT_TLV_PRL 0x13
#define QMI_MESSAGE_DMS_ACTIVATE_MANUAL_INPUT_TLV_MN_AAA_KEY 0x12
#define QMI_MESSAGE_DMS_ACTIVATE_MANUAL_INPUT_TLV_MN_HA_KEY 0x11
#define QMI_MESSAGE_DMS_ACTIVATE_MANUAL_INPUT_TLV_INFO 0x01

gboolean
qmi_message_dms_activate_manual_input_get_prl (
    QmiMessageDmsActivateManualInput *self,
    guint16 *value_prl_prl_total_length,
    guint8 *value_prl_prl_segment_sequence,
    GArray **value_prl_prl_segment,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_prl_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'PRL' was not found in the message");
        return FALSE;
    }

    if (value_prl_prl_total_length)
        *value_prl_prl_total_length = self->arg_prl_prl_total_length;
    if (value_prl_prl_segment_sequence)
        *value_prl_prl_segment_sequence = self->arg_prl_prl_segment_sequence;
    if (value_prl_prl_segment)
        *value_prl_prl_segment = self->arg_prl_prl_segment;

    return TRUE;
}

gboolean
qmi_message_dms_activate_manual_input_set_prl (
    QmiMessageDmsActivateManualInput *self,
    guint16 value_prl_prl_total_length,
    guint8 value_prl_prl_segment_sequence,
    GArray *value_prl_prl_segment,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_prl_prl_total_length = value_prl_prl_total_length;
    self->arg_prl_prl_segment_sequence = value_prl_prl_segment_sequence;
    g_clear_pointer (&self->arg_prl_prl_segment, (GDestroyNotify)g_array_unref);
    g_clear_pointer (&self->arg_prl_prl_segment, (GDestroyNotify)g_ptr_array_unref);
    self->arg_prl_prl_segment = g_array_ref (value_prl_prl_segment);
    self->arg_prl_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_dms_activate_manual_input_get_mn_aaa_key (
    QmiMessageDmsActivateManualInput *self,
    const gchar **value_mn_aaa_key,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_mn_aaa_key_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'MN AAA key' was not found in the message");
        return FALSE;
    }

    if (value_mn_aaa_key)
        *value_mn_aaa_key = self->arg_mn_aaa_key;

    return TRUE;
}

gboolean
qmi_message_dms_activate_manual_input_set_mn_aaa_key (
    QmiMessageDmsActivateManualInput *self,
    const gchar *value_mn_aaa_key,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (value_mn_aaa_key && strlen (value_mn_aaa_key) > 16) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Input variable 'value_mn_aaa_key' must be less than 16 characters long");
        return FALSE;
    }
    g_free (self->arg_mn_aaa_key);
    self->arg_mn_aaa_key = g_strdup (value_mn_aaa_key ? value_mn_aaa_key : "");
    self->arg_mn_aaa_key_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_dms_activate_manual_input_get_mn_ha_key (
    QmiMessageDmsActivateManualInput *self,
    const gchar **value_mn_ha_key,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_mn_ha_key_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'MN HA key' was not found in the message");
        return FALSE;
    }

    if (value_mn_ha_key)
        *value_mn_ha_key = self->arg_mn_ha_key;

    return TRUE;
}

gboolean
qmi_message_dms_activate_manual_input_set_mn_ha_key (
    QmiMessageDmsActivateManualInput *self,
    const gchar *value_mn_ha_key,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (value_mn_ha_key && strlen (value_mn_ha_key) > 16) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Input variable 'value_mn_ha_key' must be less than 16 characters long");
        return FALSE;
    }
    g_free (self->arg_mn_ha_key);
    self->arg_mn_ha_key = g_strdup (value_mn_ha_key ? value_mn_ha_key : "");
    self->arg_mn_ha_key_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_dms_activate_manual_input_get_info (
    QmiMessageDmsActivateManualInput *self,
    const gchar **value_info_service_programming_code,
    guint16 *value_info_system_identification_number,
    const gchar **value_info_mobile_directory_number,
    const gchar **value_info_mobile_identification_number,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_info_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Info' was not found in the message");
        return FALSE;
    }

    if (value_info_service_programming_code)
        *value_info_service_programming_code = self->arg_info_service_programming_code;
    if (value_info_system_identification_number)
        *value_info_system_identification_number = self->arg_info_system_identification_number;
    if (value_info_mobile_directory_number)
        *value_info_mobile_directory_number = self->arg_info_mobile_directory_number;
    if (value_info_mobile_identification_number)
        *value_info_mobile_identification_number = self->arg_info_mobile_identification_number;

    return TRUE;
}

gboolean
qmi_message_dms_activate_manual_input_set_info (
    QmiMessageDmsActivateManualInput *self,
    const gchar *value_info_service_programming_code,
    guint16 value_info_system_identification_number,
    const gchar *value_info_mobile_directory_number,
    const gchar *value_info_mobile_identification_number,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!value_info_service_programming_code || strlen (value_info_service_programming_code) != 6) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Input variable 'value_info_service_programming_code' must be 6 characters long");
        return FALSE;
    }
    memcpy (self->arg_info_service_programming_code, value_info_service_programming_code, 6);
    self->arg_info_service_programming_code[6] = '\0';
    self->arg_info_system_identification_number = value_info_system_identification_number;
    if (value_info_mobile_directory_number && strlen (value_info_mobile_directory_number) > 15) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Input variable 'value_info_mobile_directory_number' must be less than 15 characters long");
        return FALSE;
    }
    g_free (self->arg_info_mobile_directory_number);
    self->arg_info_mobile_directory_number = g_strdup (value_info_mobile_directory_number ? value_info_mobile_directory_number : "");
    if (value_info_mobile_identification_number && strlen (value_info_mobile_identification_number) > 15) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Input variable 'value_info_mobile_identification_number' must be less than 15 characters long");
        return FALSE;
    }
    g_free (self->arg_info_mobile_identification_number);
    self->arg_info_mobile_identification_number = g_strdup (value_info_mobile_identification_number ? value_info_mobile_identification_number : "");
    self->arg_info_set = TRUE;

    return TRUE;
}

GType
qmi_message_dms_activate_manual_input_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsActivateManualInput"),
                                          (GBoxedCopyFunc) qmi_message_dms_activate_manual_input_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_activate_manual_input_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsActivateManualInput *
qmi_message_dms_activate_manual_input_ref (QmiMessageDmsActivateManualInput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_activate_manual_input_unref (QmiMessageDmsActivateManualInput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_prl_prl_segment, (GDestroyNotify)g_array_unref);
        g_clear_pointer (&self->arg_mn_aaa_key, (GDestroyNotify)g_free);
        g_clear_pointer (&self->arg_mn_ha_key, (GDestroyNotify)g_free);
        g_clear_pointer (&self->arg_info_mobile_directory_number, (GDestroyNotify)g_free);
        g_clear_pointer (&self->arg_info_mobile_identification_number, (GDestroyNotify)g_free);
        g_slice_free (QmiMessageDmsActivateManualInput, self);
    }
}

QmiMessageDmsActivateManualInput *
qmi_message_dms_activate_manual_input_new (void)
{
    QmiMessageDmsActivateManualInput *self;

    self = g_slice_new0 (QmiMessageDmsActivateManualInput);
    self->ref_count = 1;
    return self;
}

static QmiMessage *
__qmi_message_dms_activate_manual_request_create (
    guint16 transaction_id,
    guint8 cid,
    QmiMessageDmsActivateManualInput *input,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_ACTIVATE_MANUAL);

    /* There is at least one mandatory TLV, don't allow NULL input */
    if (!input) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Message 'Activate Manual' has mandatory TLVs");
        return NULL;
    }

    /* Try to add the 'PRL' TLV */
    if (input->arg_prl_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_DMS_ACTIVATE_MANUAL_INPUT_TLV_PRL, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'PRL': ");
            return NULL;
        }

        /* Write the guint16 variable to the buffer */
        if (!qmi_message_tlv_write_guint16 (self, QMI_ENDIAN_LITTLE, input->arg_prl_prl_total_length, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'PRL': ");
            return NULL;
        }
        {
            guint prl_segment_i;
            guint16 prl_segment_n_items;

            /* Write the number of items in the array first */
            prl_segment_n_items = (guint16) input->arg_prl_prl_segment->len;
            /* Write the guint16 variable to the buffer */
            if (!qmi_message_tlv_write_guint16 (self, QMI_ENDIAN_LITTLE, prl_segment_n_items, error)) {
                g_prefix_error (error, "Cannot write integer in TLV 'PRL': ");
                return NULL;
            }
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, input->arg_prl_prl_segment_sequence, error)) {
                g_prefix_error (error, "Cannot write integer in TLV 'PRL': ");
                return NULL;
            }

            for (prl_segment_i = 0; prl_segment_i < input->arg_prl_prl_segment->len; prl_segment_i++) {
                /* Write the guint8 variable to the buffer */
                if (!qmi_message_tlv_write_guint8 (self, g_array_index (input->arg_prl_prl_segment, guint8,prl_segment_i), error)) {
                    g_prefix_error (error, "Cannot write integer in TLV 'PRL': ");
                    return NULL;
                }
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'PRL': ");
            return NULL;
        }
    }

    /* Try to add the 'MN AAA key' TLV */
    if (input->arg_mn_aaa_key_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_DMS_ACTIVATE_MANUAL_INPUT_TLV_MN_AAA_KEY, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'MN AAA key': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_string (self, 1, input->arg_mn_aaa_key, -1, error)) {
            g_prefix_error (error, "Cannot write string in TLV 'MN AAA key': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'MN AAA key': ");
            return NULL;
        }
    }

    /* Try to add the 'MN HA key' TLV */
    if (input->arg_mn_ha_key_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_DMS_ACTIVATE_MANUAL_INPUT_TLV_MN_HA_KEY, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'MN HA key': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_string (self, 1, input->arg_mn_ha_key, -1, error)) {
            g_prefix_error (error, "Cannot write string in TLV 'MN HA key': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'MN HA key': ");
            return NULL;
        }
    }

    /* Try to add the 'Info' TLV */
    if (input->arg_info_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_DMS_ACTIVATE_MANUAL_INPUT_TLV_INFO, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Info': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_string (self, 0, input->arg_info_service_programming_code, 6, error)) {
            g_prefix_error (error, "Cannot write string in TLV 'Info': ");
            return NULL;
        }
        /* Write the guint16 variable to the buffer */
        if (!qmi_message_tlv_write_guint16 (self, QMI_ENDIAN_LITTLE, input->arg_info_system_identification_number, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'Info': ");
            return NULL;
        }
        if (!qmi_message_tlv_write_string (self, 1, input->arg_info_mobile_directory_number, -1, error)) {
            g_prefix_error (error, "Cannot write string in TLV 'Info': ");
            return NULL;
        }
        if (!qmi_message_tlv_write_string (self, 1, input->arg_info_mobile_identification_number, -1, error)) {
            g_prefix_error (error, "Cannot write string in TLV 'Info': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Info': ");
            return NULL;
        }
    } else {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Missing mandatory TLV 'Info' in message 'Activate Manual'");
        return NULL;
    }

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsActivateManualOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;
};

#define QMI_MESSAGE_DMS_ACTIVATE_MANUAL_OUTPUT_TLV_RESULT 0x02

gboolean
qmi_message_dms_activate_manual_output_get_result (
    QmiMessageDmsActivateManualOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

GType
qmi_message_dms_activate_manual_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsActivateManualOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_activate_manual_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_activate_manual_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsActivateManualOutput *
qmi_message_dms_activate_manual_output_ref (QmiMessageDmsActivateManualOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_activate_manual_output_unref (QmiMessageDmsActivateManualOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsActivateManualOutput, self);
    }
}

static gchar *
qmi_message_dms_activate_manual_input_prl_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_ACTIVATE_MANUAL_INPUT_TLV_PRL, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " prl_total_length = '");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " prl_segment = '");
    {
        guint prl_segment_i;
        guint16 prl_segment_n_items;
        guint8 prl_segment_sequence;

        /* Read number of items in the array */
        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(prl_segment_n_items), &error))
            goto out;

        /* Read sequence */
        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(prl_segment_sequence), &error))
            goto out;

        g_string_append_printf (printable, "[[Seq:%u]] ", prl_segment_sequence);

        g_string_append (printable, "{");

        for (prl_segment_i = 0; prl_segment_i < prl_segment_n_items; prl_segment_i++) {
            g_string_append_printf (printable, " [%u] = '", prl_segment_i);

            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
                    g_string_append_printf (printable, "%u", (guint)tmp);
                }
            }
            g_string_append (printable, "'");
        }

        g_string_append (printable, "}");
    }    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_activate_manual_input_mn_aaa_key_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_ACTIVATE_MANUAL_INPUT_TLV_MN_AAA_KEY, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 1, 16, &tmp, &error))
            goto out;
        if (qmi_utils_get_show_personal_info ()) {
            g_string_append (printable, tmp);
        } else {
            g_string_append_printf (printable, "'###'");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_activate_manual_input_mn_ha_key_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_ACTIVATE_MANUAL_INPUT_TLV_MN_HA_KEY, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 1, 16, &tmp, &error))
            goto out;
        if (qmi_utils_get_show_personal_info ()) {
            g_string_append (printable, tmp);
        } else {
            g_string_append_printf (printable, "'###'");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_activate_manual_input_info_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_ACTIVATE_MANUAL_INPUT_TLV_INFO, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " service_programming_code = '");

    {
        gchar tmp[7] = { '\0' };

        if (!qmi_message_tlv_read_fixed_size_string (message, init_offset, &offset, 6, &tmp[0], &error))
            goto out;
        if (qmi_utils_get_show_personal_info ()) {
            g_string_append (printable, tmp);
        } else {
            g_string_append_printf (printable, "'###'");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " system_identification_number = '");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        if (qmi_utils_get_show_personal_info ()) {
            g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
        } else {
            g_string_append_printf (printable, "'###'");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " mobile_directory_number = '");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 1, 15, &tmp, &error))
            goto out;
        if (qmi_utils_get_show_personal_info ()) {
            g_string_append (printable, tmp);
        } else {
            g_string_append_printf (printable, "'###'");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " mobile_identification_number = '");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 1, 15, &tmp, &error))
            goto out;
        if (qmi_utils_get_show_personal_info ()) {
            g_string_append (printable, tmp);
        } else {
            g_string_append_printf (printable, "'###'");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_activate_manual_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_activate_manual_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_activate_manual_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        case QMI_MESSAGE_DMS_ACTIVATE_MANUAL_INPUT_TLV_PRL:
            tlv_type_str = "PRL";
            translated_value = qmi_message_dms_activate_manual_input_prl_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_ACTIVATE_MANUAL_INPUT_TLV_MN_AAA_KEY:
            tlv_type_str = "MN AAA key";
            translated_value = qmi_message_dms_activate_manual_input_mn_aaa_key_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            value_has_personal_info = TRUE;
            break;
        case QMI_MESSAGE_DMS_ACTIVATE_MANUAL_INPUT_TLV_MN_HA_KEY:
            tlv_type_str = "MN HA key";
            translated_value = qmi_message_dms_activate_manual_input_mn_ha_key_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            value_has_personal_info = TRUE;
            break;
        case QMI_MESSAGE_DMS_ACTIVATE_MANUAL_INPUT_TLV_INFO:
            tlv_type_str = "Info";
            translated_value = qmi_message_dms_activate_manual_input_info_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            value_has_personal_info = TRUE;
            break;
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_ACTIVATE_MANUAL_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_activate_manual_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Activate Manual\" (0x0033)\n",
                            line_prefix);

    {
        struct message_activate_manual_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_activate_manual_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsActivateManualOutput *
qmi_message_dms_activate_manual_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsActivateManualOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_ACTIVATE_MANUAL);

    self = g_slice_new0 (QmiMessageDmsActivateManualOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_ACTIVATE_MANUAL_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_activate_manual_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_activate_manual_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS Get User Lock State */


/* --- Input -- */

/* Note: no fields in the Input container */

static QmiMessage *
__qmi_message_dms_get_user_lock_state_request_create (
    guint16 transaction_id,
    guint8 cid,
    gpointer unused,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_GET_USER_LOCK_STATE);

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsGetUserLockStateOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* Enabled */
    gboolean arg_enabled_set;
    guint8 arg_enabled;
};

#define QMI_MESSAGE_DMS_GET_USER_LOCK_STATE_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_DMS_GET_USER_LOCK_STATE_OUTPUT_TLV_ENABLED 0x01

gboolean
qmi_message_dms_get_user_lock_state_output_get_result (
    QmiMessageDmsGetUserLockStateOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_dms_get_user_lock_state_output_get_enabled (
    QmiMessageDmsGetUserLockStateOutput *self,
    gboolean *value_enabled,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_enabled_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Enabled' was not found in the message");
        return FALSE;
    }

    if (value_enabled)
        *value_enabled = (gboolean)(self->arg_enabled);

    return TRUE;
}

GType
qmi_message_dms_get_user_lock_state_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsGetUserLockStateOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_get_user_lock_state_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_get_user_lock_state_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsGetUserLockStateOutput *
qmi_message_dms_get_user_lock_state_output_ref (QmiMessageDmsGetUserLockStateOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_get_user_lock_state_output_unref (QmiMessageDmsGetUserLockStateOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsGetUserLockStateOutput, self);
    }
}

static gchar *
qmi_message_dms_get_user_lock_state_output_enabled_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_USER_LOCK_STATE_OUTPUT_TLV_ENABLED, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_get_user_lock_state_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_get_user_lock_state_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_get_user_lock_state_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_GET_USER_LOCK_STATE_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_GET_USER_LOCK_STATE_OUTPUT_TLV_ENABLED:
            tlv_type_str = "Enabled";
            translated_value = qmi_message_dms_get_user_lock_state_output_enabled_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_get_user_lock_state_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Get User Lock State\" (0x0034)\n",
                            line_prefix);

    {
        struct message_get_user_lock_state_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_get_user_lock_state_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsGetUserLockStateOutput *
qmi_message_dms_get_user_lock_state_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsGetUserLockStateOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_GET_USER_LOCK_STATE);

    self = g_slice_new0 (QmiMessageDmsGetUserLockStateOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_USER_LOCK_STATE_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_get_user_lock_state_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_get_user_lock_state_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_USER_LOCK_STATE_OUTPUT_TLV_ENABLED, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Enabled TLV: ");
                qmi_message_dms_get_user_lock_state_output_unref (self);
                return NULL;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, error))
                    goto qmi_message_dms_get_user_lock_state_output_enabled_out;
                self->arg_enabled = (gboolean)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Enabled' TLV", offset);
            }

            self->arg_enabled_set = TRUE;

qmi_message_dms_get_user_lock_state_output_enabled_out:
            if (!self->arg_enabled_set) {
                qmi_message_dms_get_user_lock_state_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS Set User Lock State */


/* --- Input -- */

struct _QmiMessageDmsSetUserLockStateInput {
    volatile gint ref_count;

    /* Info */
    gboolean arg_info_set;
    guint8 arg_info_enabled;
    gchar arg_info_lock_code[5];
};

#define QMI_MESSAGE_DMS_SET_USER_LOCK_STATE_INPUT_TLV_INFO 0x01

gboolean
qmi_message_dms_set_user_lock_state_input_get_info (
    QmiMessageDmsSetUserLockStateInput *self,
    gboolean *value_info_enabled,
    const gchar **value_info_lock_code,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_info_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Info' was not found in the message");
        return FALSE;
    }

    if (value_info_enabled)
        *value_info_enabled = (gboolean)(self->arg_info_enabled);
    if (value_info_lock_code)
        *value_info_lock_code = self->arg_info_lock_code;

    return TRUE;
}

gboolean
qmi_message_dms_set_user_lock_state_input_set_info (
    QmiMessageDmsSetUserLockStateInput *self,
    gboolean value_info_enabled,
    const gchar *value_info_lock_code,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_info_enabled = (guint8)(value_info_enabled);
    if (!value_info_lock_code || strlen (value_info_lock_code) != 4) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Input variable 'value_info_lock_code' must be 4 characters long");
        return FALSE;
    }
    memcpy (self->arg_info_lock_code, value_info_lock_code, 4);
    self->arg_info_lock_code[4] = '\0';
    self->arg_info_set = TRUE;

    return TRUE;
}

GType
qmi_message_dms_set_user_lock_state_input_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsSetUserLockStateInput"),
                                          (GBoxedCopyFunc) qmi_message_dms_set_user_lock_state_input_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_set_user_lock_state_input_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsSetUserLockStateInput *
qmi_message_dms_set_user_lock_state_input_ref (QmiMessageDmsSetUserLockStateInput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_set_user_lock_state_input_unref (QmiMessageDmsSetUserLockStateInput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsSetUserLockStateInput, self);
    }
}

QmiMessageDmsSetUserLockStateInput *
qmi_message_dms_set_user_lock_state_input_new (void)
{
    QmiMessageDmsSetUserLockStateInput *self;

    self = g_slice_new0 (QmiMessageDmsSetUserLockStateInput);
    self->ref_count = 1;
    return self;
}

static QmiMessage *
__qmi_message_dms_set_user_lock_state_request_create (
    guint16 transaction_id,
    guint8 cid,
    QmiMessageDmsSetUserLockStateInput *input,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_SET_USER_LOCK_STATE);

    /* There is at least one mandatory TLV, don't allow NULL input */
    if (!input) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Message 'Set User Lock State' has mandatory TLVs");
        return NULL;
    }

    /* Try to add the 'Info' TLV */
    if (input->arg_info_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_DMS_SET_USER_LOCK_STATE_INPUT_TLV_INFO, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Info': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_info_enabled;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Info': ");
                return NULL;
            }
        }
        if (!qmi_message_tlv_write_string (self, 0, input->arg_info_lock_code, 4, error)) {
            g_prefix_error (error, "Cannot write string in TLV 'Info': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Info': ");
            return NULL;
        }
    } else {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Missing mandatory TLV 'Info' in message 'Set User Lock State'");
        return NULL;
    }

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsSetUserLockStateOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;
};

#define QMI_MESSAGE_DMS_SET_USER_LOCK_STATE_OUTPUT_TLV_RESULT 0x02

gboolean
qmi_message_dms_set_user_lock_state_output_get_result (
    QmiMessageDmsSetUserLockStateOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

GType
qmi_message_dms_set_user_lock_state_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsSetUserLockStateOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_set_user_lock_state_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_set_user_lock_state_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsSetUserLockStateOutput *
qmi_message_dms_set_user_lock_state_output_ref (QmiMessageDmsSetUserLockStateOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_set_user_lock_state_output_unref (QmiMessageDmsSetUserLockStateOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsSetUserLockStateOutput, self);
    }
}

static gchar *
qmi_message_dms_set_user_lock_state_input_info_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SET_USER_LOCK_STATE_INPUT_TLV_INFO, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " enabled = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " lock_code = '");

    {
        gchar tmp[5] = { '\0' };

        if (!qmi_message_tlv_read_fixed_size_string (message, init_offset, &offset, 4, &tmp[0], &error))
            goto out;
        if (qmi_utils_get_show_personal_info ()) {
            g_string_append (printable, tmp);
        } else {
            g_string_append_printf (printable, "'###'");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_set_user_lock_state_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_set_user_lock_state_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_set_user_lock_state_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        case QMI_MESSAGE_DMS_SET_USER_LOCK_STATE_INPUT_TLV_INFO:
            tlv_type_str = "Info";
            translated_value = qmi_message_dms_set_user_lock_state_input_info_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            value_has_personal_info = TRUE;
            break;
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_SET_USER_LOCK_STATE_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_set_user_lock_state_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Set User Lock State\" (0x0035)\n",
                            line_prefix);

    {
        struct message_set_user_lock_state_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_set_user_lock_state_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsSetUserLockStateOutput *
qmi_message_dms_set_user_lock_state_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsSetUserLockStateOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_SET_USER_LOCK_STATE);

    self = g_slice_new0 (QmiMessageDmsSetUserLockStateOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SET_USER_LOCK_STATE_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_set_user_lock_state_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_set_user_lock_state_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS Set User Lock Code */


/* --- Input -- */

struct _QmiMessageDmsSetUserLockCodeInput {
    volatile gint ref_count;

    /* Info */
    gboolean arg_info_set;
    gchar arg_info_old_code[5];
    gchar arg_info_new_code[5];
};

#define QMI_MESSAGE_DMS_SET_USER_LOCK_CODE_INPUT_TLV_INFO 0x01

gboolean
qmi_message_dms_set_user_lock_code_input_get_info (
    QmiMessageDmsSetUserLockCodeInput *self,
    const gchar **value_info_old_code,
    const gchar **value_info_new_code,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_info_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Info' was not found in the message");
        return FALSE;
    }

    if (value_info_old_code)
        *value_info_old_code = self->arg_info_old_code;
    if (value_info_new_code)
        *value_info_new_code = self->arg_info_new_code;

    return TRUE;
}

gboolean
qmi_message_dms_set_user_lock_code_input_set_info (
    QmiMessageDmsSetUserLockCodeInput *self,
    const gchar *value_info_old_code,
    const gchar *value_info_new_code,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!value_info_old_code || strlen (value_info_old_code) != 4) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Input variable 'value_info_old_code' must be 4 characters long");
        return FALSE;
    }
    memcpy (self->arg_info_old_code, value_info_old_code, 4);
    self->arg_info_old_code[4] = '\0';
    if (!value_info_new_code || strlen (value_info_new_code) != 4) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Input variable 'value_info_new_code' must be 4 characters long");
        return FALSE;
    }
    memcpy (self->arg_info_new_code, value_info_new_code, 4);
    self->arg_info_new_code[4] = '\0';
    self->arg_info_set = TRUE;

    return TRUE;
}

GType
qmi_message_dms_set_user_lock_code_input_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsSetUserLockCodeInput"),
                                          (GBoxedCopyFunc) qmi_message_dms_set_user_lock_code_input_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_set_user_lock_code_input_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsSetUserLockCodeInput *
qmi_message_dms_set_user_lock_code_input_ref (QmiMessageDmsSetUserLockCodeInput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_set_user_lock_code_input_unref (QmiMessageDmsSetUserLockCodeInput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsSetUserLockCodeInput, self);
    }
}

QmiMessageDmsSetUserLockCodeInput *
qmi_message_dms_set_user_lock_code_input_new (void)
{
    QmiMessageDmsSetUserLockCodeInput *self;

    self = g_slice_new0 (QmiMessageDmsSetUserLockCodeInput);
    self->ref_count = 1;
    return self;
}

static QmiMessage *
__qmi_message_dms_set_user_lock_code_request_create (
    guint16 transaction_id,
    guint8 cid,
    QmiMessageDmsSetUserLockCodeInput *input,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_SET_USER_LOCK_CODE);

    /* There is at least one mandatory TLV, don't allow NULL input */
    if (!input) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Message 'Set User Lock Code' has mandatory TLVs");
        return NULL;
    }

    /* Try to add the 'Info' TLV */
    if (input->arg_info_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_DMS_SET_USER_LOCK_CODE_INPUT_TLV_INFO, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Info': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_string (self, 0, input->arg_info_old_code, 4, error)) {
            g_prefix_error (error, "Cannot write string in TLV 'Info': ");
            return NULL;
        }
        if (!qmi_message_tlv_write_string (self, 0, input->arg_info_new_code, 4, error)) {
            g_prefix_error (error, "Cannot write string in TLV 'Info': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Info': ");
            return NULL;
        }
    } else {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Missing mandatory TLV 'Info' in message 'Set User Lock Code'");
        return NULL;
    }

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsSetUserLockCodeOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;
};

#define QMI_MESSAGE_DMS_SET_USER_LOCK_CODE_OUTPUT_TLV_RESULT 0x02

gboolean
qmi_message_dms_set_user_lock_code_output_get_result (
    QmiMessageDmsSetUserLockCodeOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

GType
qmi_message_dms_set_user_lock_code_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsSetUserLockCodeOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_set_user_lock_code_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_set_user_lock_code_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsSetUserLockCodeOutput *
qmi_message_dms_set_user_lock_code_output_ref (QmiMessageDmsSetUserLockCodeOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_set_user_lock_code_output_unref (QmiMessageDmsSetUserLockCodeOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsSetUserLockCodeOutput, self);
    }
}

static gchar *
qmi_message_dms_set_user_lock_code_input_info_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SET_USER_LOCK_CODE_INPUT_TLV_INFO, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " old_code = '");

    {
        gchar tmp[5] = { '\0' };

        if (!qmi_message_tlv_read_fixed_size_string (message, init_offset, &offset, 4, &tmp[0], &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " new_code = '");

    {
        gchar tmp[5] = { '\0' };

        if (!qmi_message_tlv_read_fixed_size_string (message, init_offset, &offset, 4, &tmp[0], &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_set_user_lock_code_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_set_user_lock_code_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_set_user_lock_code_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        case QMI_MESSAGE_DMS_SET_USER_LOCK_CODE_INPUT_TLV_INFO:
            tlv_type_str = "Info";
            translated_value = qmi_message_dms_set_user_lock_code_input_info_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_SET_USER_LOCK_CODE_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_set_user_lock_code_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Set User Lock Code\" (0x0036)\n",
                            line_prefix);

    {
        struct message_set_user_lock_code_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_set_user_lock_code_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsSetUserLockCodeOutput *
qmi_message_dms_set_user_lock_code_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsSetUserLockCodeOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_SET_USER_LOCK_CODE);

    self = g_slice_new0 (QmiMessageDmsSetUserLockCodeOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SET_USER_LOCK_CODE_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_set_user_lock_code_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_set_user_lock_code_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS Read User Data */


/* --- Input -- */

/* Note: no fields in the Input container */

static QmiMessage *
__qmi_message_dms_read_user_data_request_create (
    guint16 transaction_id,
    guint8 cid,
    gpointer unused,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_READ_USER_DATA);

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsReadUserDataOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* User Data */
    gboolean arg_user_data_set;
    GArray *arg_user_data;
};

#define QMI_MESSAGE_DMS_READ_USER_DATA_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_DMS_READ_USER_DATA_OUTPUT_TLV_USER_DATA 0x01

gboolean
qmi_message_dms_read_user_data_output_get_result (
    QmiMessageDmsReadUserDataOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_dms_read_user_data_output_get_user_data (
    QmiMessageDmsReadUserDataOutput *self,
    GArray **value_user_data,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_user_data_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'User Data' was not found in the message");
        return FALSE;
    }

    if (value_user_data)
        *value_user_data = self->arg_user_data;

    return TRUE;
}

GType
qmi_message_dms_read_user_data_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsReadUserDataOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_read_user_data_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_read_user_data_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsReadUserDataOutput *
qmi_message_dms_read_user_data_output_ref (QmiMessageDmsReadUserDataOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_read_user_data_output_unref (QmiMessageDmsReadUserDataOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_user_data, (GDestroyNotify)g_array_unref);
        g_slice_free (QmiMessageDmsReadUserDataOutput, self);
    }
}

static gchar *
qmi_message_dms_read_user_data_output_user_data_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_READ_USER_DATA_OUTPUT_TLV_USER_DATA, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    {
        guint user_data_i;
        guint16 user_data_n_items;

        /* Read number of items in the array */
        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(user_data_n_items), &error))
            goto out;

        g_string_append (printable, "{");

        for (user_data_i = 0; user_data_i < user_data_n_items; user_data_i++) {
            g_string_append_printf (printable, " [%u] = '", user_data_i);

            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
                    g_string_append_printf (printable, "%u", (guint)tmp);
                }
            }
            g_string_append (printable, "'");
        }

        g_string_append (printable, "}");
    }
    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_read_user_data_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_read_user_data_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_read_user_data_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_READ_USER_DATA_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_READ_USER_DATA_OUTPUT_TLV_USER_DATA:
            tlv_type_str = "User Data";
            translated_value = qmi_message_dms_read_user_data_output_user_data_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_read_user_data_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Read User Data\" (0x0037)\n",
                            line_prefix);

    {
        struct message_read_user_data_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_read_user_data_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsReadUserDataOutput *
qmi_message_dms_read_user_data_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsReadUserDataOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_READ_USER_DATA);

    self = g_slice_new0 (QmiMessageDmsReadUserDataOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_READ_USER_DATA_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_read_user_data_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_read_user_data_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_READ_USER_DATA_OUTPUT_TLV_USER_DATA, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory User Data TLV: ");
                qmi_message_dms_read_user_data_output_unref (self);
                return NULL;
            }
            {
                guint user_data_i;
                guint16 user_data_n_items;

                /* Read number of items in the array */
                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(user_data_n_items), error))
                    goto qmi_message_dms_read_user_data_output_user_data_out;

                self->arg_user_data = g_array_sized_new (
                    FALSE,
                    FALSE,
                    sizeof (guint8),
                    (guint)user_data_n_items);

                for (user_data_i = 0; user_data_i < user_data_n_items; user_data_i++) {
                    guint8 user_data_aux;

                    if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(user_data_aux), error))
                        goto qmi_message_dms_read_user_data_output_user_data_out;
                    g_array_insert_val (self->arg_user_data, user_data_i, user_data_aux);
                }
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'User Data' TLV", offset);
            }

            self->arg_user_data_set = TRUE;

qmi_message_dms_read_user_data_output_user_data_out:
            if (!self->arg_user_data_set) {
                qmi_message_dms_read_user_data_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS Write User Data */


/* --- Input -- */

struct _QmiMessageDmsWriteUserDataInput {
    volatile gint ref_count;

    /* User Data */
    gboolean arg_user_data_set;
    GArray *arg_user_data;
};

#define QMI_MESSAGE_DMS_WRITE_USER_DATA_INPUT_TLV_USER_DATA 0x01

gboolean
qmi_message_dms_write_user_data_input_get_user_data (
    QmiMessageDmsWriteUserDataInput *self,
    GArray **value_user_data,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_user_data_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'User Data' was not found in the message");
        return FALSE;
    }

    if (value_user_data)
        *value_user_data = self->arg_user_data;

    return TRUE;
}

gboolean
qmi_message_dms_write_user_data_input_set_user_data (
    QmiMessageDmsWriteUserDataInput *self,
    GArray *value_user_data,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    g_clear_pointer (&self->arg_user_data, (GDestroyNotify)g_array_unref);
    g_clear_pointer (&self->arg_user_data, (GDestroyNotify)g_ptr_array_unref);
    self->arg_user_data = g_array_ref (value_user_data);
    self->arg_user_data_set = TRUE;

    return TRUE;
}

GType
qmi_message_dms_write_user_data_input_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsWriteUserDataInput"),
                                          (GBoxedCopyFunc) qmi_message_dms_write_user_data_input_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_write_user_data_input_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsWriteUserDataInput *
qmi_message_dms_write_user_data_input_ref (QmiMessageDmsWriteUserDataInput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_write_user_data_input_unref (QmiMessageDmsWriteUserDataInput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_user_data, (GDestroyNotify)g_array_unref);
        g_slice_free (QmiMessageDmsWriteUserDataInput, self);
    }
}

QmiMessageDmsWriteUserDataInput *
qmi_message_dms_write_user_data_input_new (void)
{
    QmiMessageDmsWriteUserDataInput *self;

    self = g_slice_new0 (QmiMessageDmsWriteUserDataInput);
    self->ref_count = 1;
    return self;
}

static QmiMessage *
__qmi_message_dms_write_user_data_request_create (
    guint16 transaction_id,
    guint8 cid,
    QmiMessageDmsWriteUserDataInput *input,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_WRITE_USER_DATA);

    /* There is at least one mandatory TLV, don't allow NULL input */
    if (!input) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Message 'Write User Data' has mandatory TLVs");
        return NULL;
    }

    /* Try to add the 'User Data' TLV */
    if (input->arg_user_data_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_DMS_WRITE_USER_DATA_INPUT_TLV_USER_DATA, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'User Data': ");
            return NULL;
        }

        {
            guint user_data_i;
            guint16 user_data_n_items;

            /* Write the number of items in the array first */
            user_data_n_items = (guint16) input->arg_user_data->len;
            /* Write the guint16 variable to the buffer */
            if (!qmi_message_tlv_write_guint16 (self, QMI_ENDIAN_LITTLE, user_data_n_items, error)) {
                g_prefix_error (error, "Cannot write integer in TLV 'User Data': ");
                return NULL;
            }

            for (user_data_i = 0; user_data_i < input->arg_user_data->len; user_data_i++) {
                /* Write the guint8 variable to the buffer */
                if (!qmi_message_tlv_write_guint8 (self, g_array_index (input->arg_user_data, guint8,user_data_i), error)) {
                    g_prefix_error (error, "Cannot write integer in TLV 'User Data': ");
                    return NULL;
                }
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'User Data': ");
            return NULL;
        }
    } else {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Missing mandatory TLV 'User Data' in message 'Write User Data'");
        return NULL;
    }

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsWriteUserDataOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;
};

#define QMI_MESSAGE_DMS_WRITE_USER_DATA_OUTPUT_TLV_RESULT 0x02

gboolean
qmi_message_dms_write_user_data_output_get_result (
    QmiMessageDmsWriteUserDataOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

GType
qmi_message_dms_write_user_data_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsWriteUserDataOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_write_user_data_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_write_user_data_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsWriteUserDataOutput *
qmi_message_dms_write_user_data_output_ref (QmiMessageDmsWriteUserDataOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_write_user_data_output_unref (QmiMessageDmsWriteUserDataOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsWriteUserDataOutput, self);
    }
}

static gchar *
qmi_message_dms_write_user_data_input_user_data_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_WRITE_USER_DATA_INPUT_TLV_USER_DATA, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    {
        guint user_data_i;
        guint16 user_data_n_items;

        /* Read number of items in the array */
        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(user_data_n_items), &error))
            goto out;

        g_string_append (printable, "{");

        for (user_data_i = 0; user_data_i < user_data_n_items; user_data_i++) {
            g_string_append_printf (printable, " [%u] = '", user_data_i);

            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
                    g_string_append_printf (printable, "%u", (guint)tmp);
                }
            }
            g_string_append (printable, "'");
        }

        g_string_append (printable, "}");
    }
    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_write_user_data_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_write_user_data_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_write_user_data_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        case QMI_MESSAGE_DMS_WRITE_USER_DATA_INPUT_TLV_USER_DATA:
            tlv_type_str = "User Data";
            translated_value = qmi_message_dms_write_user_data_input_user_data_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_WRITE_USER_DATA_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_write_user_data_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Write User Data\" (0x0038)\n",
                            line_prefix);

    {
        struct message_write_user_data_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_write_user_data_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsWriteUserDataOutput *
qmi_message_dms_write_user_data_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsWriteUserDataOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_WRITE_USER_DATA);

    self = g_slice_new0 (QmiMessageDmsWriteUserDataOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_WRITE_USER_DATA_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_write_user_data_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_write_user_data_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS Read ERI File */


/* --- Input -- */

/* Note: no fields in the Input container */

static QmiMessage *
__qmi_message_dms_read_eri_file_request_create (
    guint16 transaction_id,
    guint8 cid,
    gpointer unused,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_READ_ERI_FILE);

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsReadEriFileOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* ERI File */
    gboolean arg_eri_file_set;
    GArray *arg_eri_file;
};

#define QMI_MESSAGE_DMS_READ_ERI_FILE_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_DMS_READ_ERI_FILE_OUTPUT_TLV_ERI_FILE 0x01

gboolean
qmi_message_dms_read_eri_file_output_get_result (
    QmiMessageDmsReadEriFileOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_dms_read_eri_file_output_get_eri_file (
    QmiMessageDmsReadEriFileOutput *self,
    GArray **value_eri_file,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_eri_file_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'ERI File' was not found in the message");
        return FALSE;
    }

    if (value_eri_file)
        *value_eri_file = self->arg_eri_file;

    return TRUE;
}

GType
qmi_message_dms_read_eri_file_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsReadEriFileOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_read_eri_file_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_read_eri_file_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsReadEriFileOutput *
qmi_message_dms_read_eri_file_output_ref (QmiMessageDmsReadEriFileOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_read_eri_file_output_unref (QmiMessageDmsReadEriFileOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_eri_file, (GDestroyNotify)g_array_unref);
        g_slice_free (QmiMessageDmsReadEriFileOutput, self);
    }
}

static gchar *
qmi_message_dms_read_eri_file_output_eri_file_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_READ_ERI_FILE_OUTPUT_TLV_ERI_FILE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    {
        guint eri_file_i;
        guint16 eri_file_n_items;

        /* Read number of items in the array */
        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(eri_file_n_items), &error))
            goto out;

        g_string_append (printable, "{");

        for (eri_file_i = 0; eri_file_i < eri_file_n_items; eri_file_i++) {
            g_string_append_printf (printable, " [%u] = '", eri_file_i);

            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
                    g_string_append_printf (printable, "%u", (guint)tmp);
                }
            }
            g_string_append (printable, "'");
        }

        g_string_append (printable, "}");
    }
    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_read_eri_file_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_read_eri_file_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_read_eri_file_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_READ_ERI_FILE_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_READ_ERI_FILE_OUTPUT_TLV_ERI_FILE:
            tlv_type_str = "ERI File";
            translated_value = qmi_message_dms_read_eri_file_output_eri_file_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_read_eri_file_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Read ERI File\" (0x0039)\n",
                            line_prefix);

    {
        struct message_read_eri_file_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_read_eri_file_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsReadEriFileOutput *
qmi_message_dms_read_eri_file_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsReadEriFileOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_READ_ERI_FILE);

    self = g_slice_new0 (QmiMessageDmsReadEriFileOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_READ_ERI_FILE_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_read_eri_file_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_read_eri_file_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_READ_ERI_FILE_OUTPUT_TLV_ERI_FILE, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory ERI File TLV: ");
                qmi_message_dms_read_eri_file_output_unref (self);
                return NULL;
            }
            {
                guint eri_file_i;
                guint16 eri_file_n_items;

                /* Read number of items in the array */
                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(eri_file_n_items), error))
                    goto qmi_message_dms_read_eri_file_output_eri_file_out;

                self->arg_eri_file = g_array_sized_new (
                    FALSE,
                    FALSE,
                    sizeof (guint8),
                    (guint)eri_file_n_items);

                for (eri_file_i = 0; eri_file_i < eri_file_n_items; eri_file_i++) {
                    guint8 eri_file_aux;

                    if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(eri_file_aux), error))
                        goto qmi_message_dms_read_eri_file_output_eri_file_out;
                    g_array_insert_val (self->arg_eri_file, eri_file_i, eri_file_aux);
                }
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'ERI File' TLV", offset);
            }

            self->arg_eri_file_set = TRUE;

qmi_message_dms_read_eri_file_output_eri_file_out:
            if (!self->arg_eri_file_set) {
                qmi_message_dms_read_eri_file_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS Restore Factory Defaults */


/* --- Input -- */

struct _QmiMessageDmsRestoreFactoryDefaultsInput {
    volatile gint ref_count;

    /* Service Programming Code */
    gboolean arg_service_programming_code_set;
    gchar arg_service_programming_code[7];
};

#define QMI_MESSAGE_DMS_RESTORE_FACTORY_DEFAULTS_INPUT_TLV_SERVICE_PROGRAMMING_CODE 0x01

gboolean
qmi_message_dms_restore_factory_defaults_input_get_service_programming_code (
    QmiMessageDmsRestoreFactoryDefaultsInput *self,
    const gchar **value_service_programming_code,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_service_programming_code_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Service Programming Code' was not found in the message");
        return FALSE;
    }

    if (value_service_programming_code)
        *value_service_programming_code = self->arg_service_programming_code;

    return TRUE;
}

gboolean
qmi_message_dms_restore_factory_defaults_input_set_service_programming_code (
    QmiMessageDmsRestoreFactoryDefaultsInput *self,
    const gchar *value_service_programming_code,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!value_service_programming_code || strlen (value_service_programming_code) != 6) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Input variable 'value_service_programming_code' must be 6 characters long");
        return FALSE;
    }
    memcpy (self->arg_service_programming_code, value_service_programming_code, 6);
    self->arg_service_programming_code[6] = '\0';
    self->arg_service_programming_code_set = TRUE;

    return TRUE;
}

GType
qmi_message_dms_restore_factory_defaults_input_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsRestoreFactoryDefaultsInput"),
                                          (GBoxedCopyFunc) qmi_message_dms_restore_factory_defaults_input_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_restore_factory_defaults_input_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsRestoreFactoryDefaultsInput *
qmi_message_dms_restore_factory_defaults_input_ref (QmiMessageDmsRestoreFactoryDefaultsInput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_restore_factory_defaults_input_unref (QmiMessageDmsRestoreFactoryDefaultsInput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsRestoreFactoryDefaultsInput, self);
    }
}

QmiMessageDmsRestoreFactoryDefaultsInput *
qmi_message_dms_restore_factory_defaults_input_new (void)
{
    QmiMessageDmsRestoreFactoryDefaultsInput *self;

    self = g_slice_new0 (QmiMessageDmsRestoreFactoryDefaultsInput);
    self->ref_count = 1;
    return self;
}

static QmiMessage *
__qmi_message_dms_restore_factory_defaults_request_create (
    guint16 transaction_id,
    guint8 cid,
    QmiMessageDmsRestoreFactoryDefaultsInput *input,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_RESTORE_FACTORY_DEFAULTS);

    /* There is at least one mandatory TLV, don't allow NULL input */
    if (!input) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Message 'Restore Factory Defaults' has mandatory TLVs");
        return NULL;
    }

    /* Try to add the 'Service Programming Code' TLV */
    if (input->arg_service_programming_code_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_DMS_RESTORE_FACTORY_DEFAULTS_INPUT_TLV_SERVICE_PROGRAMMING_CODE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Service Programming Code': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_string (self, 0, input->arg_service_programming_code, 6, error)) {
            g_prefix_error (error, "Cannot write string in TLV 'Service Programming Code': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Service Programming Code': ");
            return NULL;
        }
    } else {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Missing mandatory TLV 'Service Programming Code' in message 'Restore Factory Defaults'");
        return NULL;
    }

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsRestoreFactoryDefaultsOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;
};

#define QMI_MESSAGE_DMS_RESTORE_FACTORY_DEFAULTS_OUTPUT_TLV_RESULT 0x02

gboolean
qmi_message_dms_restore_factory_defaults_output_get_result (
    QmiMessageDmsRestoreFactoryDefaultsOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

GType
qmi_message_dms_restore_factory_defaults_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsRestoreFactoryDefaultsOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_restore_factory_defaults_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_restore_factory_defaults_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsRestoreFactoryDefaultsOutput *
qmi_message_dms_restore_factory_defaults_output_ref (QmiMessageDmsRestoreFactoryDefaultsOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_restore_factory_defaults_output_unref (QmiMessageDmsRestoreFactoryDefaultsOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsRestoreFactoryDefaultsOutput, self);
    }
}

static gchar *
qmi_message_dms_restore_factory_defaults_input_service_programming_code_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_RESTORE_FACTORY_DEFAULTS_INPUT_TLV_SERVICE_PROGRAMMING_CODE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        gchar tmp[7] = { '\0' };

        if (!qmi_message_tlv_read_fixed_size_string (message, init_offset, &offset, 6, &tmp[0], &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_restore_factory_defaults_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_restore_factory_defaults_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_restore_factory_defaults_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        case QMI_MESSAGE_DMS_RESTORE_FACTORY_DEFAULTS_INPUT_TLV_SERVICE_PROGRAMMING_CODE:
            tlv_type_str = "Service Programming Code";
            translated_value = qmi_message_dms_restore_factory_defaults_input_service_programming_code_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_RESTORE_FACTORY_DEFAULTS_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_restore_factory_defaults_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Restore Factory Defaults\" (0x003A)\n",
                            line_prefix);

    {
        struct message_restore_factory_defaults_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_restore_factory_defaults_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsRestoreFactoryDefaultsOutput *
qmi_message_dms_restore_factory_defaults_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsRestoreFactoryDefaultsOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_RESTORE_FACTORY_DEFAULTS);

    self = g_slice_new0 (QmiMessageDmsRestoreFactoryDefaultsOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_RESTORE_FACTORY_DEFAULTS_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_restore_factory_defaults_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_restore_factory_defaults_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS Validate Service Programming Code */


/* --- Input -- */

struct _QmiMessageDmsValidateServiceProgrammingCodeInput {
    volatile gint ref_count;

    /* Service Programming Code */
    gboolean arg_service_programming_code_set;
    gchar arg_service_programming_code[7];
};

#define QMI_MESSAGE_DMS_VALIDATE_SERVICE_PROGRAMMING_CODE_INPUT_TLV_SERVICE_PROGRAMMING_CODE 0x01

gboolean
qmi_message_dms_validate_service_programming_code_input_get_service_programming_code (
    QmiMessageDmsValidateServiceProgrammingCodeInput *self,
    const gchar **value_service_programming_code,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_service_programming_code_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Service Programming Code' was not found in the message");
        return FALSE;
    }

    if (value_service_programming_code)
        *value_service_programming_code = self->arg_service_programming_code;

    return TRUE;
}

gboolean
qmi_message_dms_validate_service_programming_code_input_set_service_programming_code (
    QmiMessageDmsValidateServiceProgrammingCodeInput *self,
    const gchar *value_service_programming_code,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!value_service_programming_code || strlen (value_service_programming_code) != 6) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Input variable 'value_service_programming_code' must be 6 characters long");
        return FALSE;
    }
    memcpy (self->arg_service_programming_code, value_service_programming_code, 6);
    self->arg_service_programming_code[6] = '\0';
    self->arg_service_programming_code_set = TRUE;

    return TRUE;
}

GType
qmi_message_dms_validate_service_programming_code_input_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsValidateServiceProgrammingCodeInput"),
                                          (GBoxedCopyFunc) qmi_message_dms_validate_service_programming_code_input_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_validate_service_programming_code_input_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsValidateServiceProgrammingCodeInput *
qmi_message_dms_validate_service_programming_code_input_ref (QmiMessageDmsValidateServiceProgrammingCodeInput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_validate_service_programming_code_input_unref (QmiMessageDmsValidateServiceProgrammingCodeInput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsValidateServiceProgrammingCodeInput, self);
    }
}

QmiMessageDmsValidateServiceProgrammingCodeInput *
qmi_message_dms_validate_service_programming_code_input_new (void)
{
    QmiMessageDmsValidateServiceProgrammingCodeInput *self;

    self = g_slice_new0 (QmiMessageDmsValidateServiceProgrammingCodeInput);
    self->ref_count = 1;
    return self;
}

static QmiMessage *
__qmi_message_dms_validate_service_programming_code_request_create (
    guint16 transaction_id,
    guint8 cid,
    QmiMessageDmsValidateServiceProgrammingCodeInput *input,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_VALIDATE_SERVICE_PROGRAMMING_CODE);

    /* There is at least one mandatory TLV, don't allow NULL input */
    if (!input) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Message 'Validate Service Programming Code' has mandatory TLVs");
        return NULL;
    }

    /* Try to add the 'Service Programming Code' TLV */
    if (input->arg_service_programming_code_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_DMS_VALIDATE_SERVICE_PROGRAMMING_CODE_INPUT_TLV_SERVICE_PROGRAMMING_CODE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Service Programming Code': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_string (self, 0, input->arg_service_programming_code, 6, error)) {
            g_prefix_error (error, "Cannot write string in TLV 'Service Programming Code': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Service Programming Code': ");
            return NULL;
        }
    } else {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Missing mandatory TLV 'Service Programming Code' in message 'Validate Service Programming Code'");
        return NULL;
    }

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsValidateServiceProgrammingCodeOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;
};

#define QMI_MESSAGE_DMS_VALIDATE_SERVICE_PROGRAMMING_CODE_OUTPUT_TLV_RESULT 0x02

gboolean
qmi_message_dms_validate_service_programming_code_output_get_result (
    QmiMessageDmsValidateServiceProgrammingCodeOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

GType
qmi_message_dms_validate_service_programming_code_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsValidateServiceProgrammingCodeOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_validate_service_programming_code_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_validate_service_programming_code_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsValidateServiceProgrammingCodeOutput *
qmi_message_dms_validate_service_programming_code_output_ref (QmiMessageDmsValidateServiceProgrammingCodeOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_validate_service_programming_code_output_unref (QmiMessageDmsValidateServiceProgrammingCodeOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsValidateServiceProgrammingCodeOutput, self);
    }
}

static gchar *
qmi_message_dms_validate_service_programming_code_input_service_programming_code_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_VALIDATE_SERVICE_PROGRAMMING_CODE_INPUT_TLV_SERVICE_PROGRAMMING_CODE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        gchar tmp[7] = { '\0' };

        if (!qmi_message_tlv_read_fixed_size_string (message, init_offset, &offset, 6, &tmp[0], &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_validate_service_programming_code_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_validate_service_programming_code_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_validate_service_programming_code_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        case QMI_MESSAGE_DMS_VALIDATE_SERVICE_PROGRAMMING_CODE_INPUT_TLV_SERVICE_PROGRAMMING_CODE:
            tlv_type_str = "Service Programming Code";
            translated_value = qmi_message_dms_validate_service_programming_code_input_service_programming_code_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_VALIDATE_SERVICE_PROGRAMMING_CODE_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_validate_service_programming_code_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Validate Service Programming Code\" (0x003B)\n",
                            line_prefix);

    {
        struct message_validate_service_programming_code_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_validate_service_programming_code_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsValidateServiceProgrammingCodeOutput *
qmi_message_dms_validate_service_programming_code_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsValidateServiceProgrammingCodeOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_VALIDATE_SERVICE_PROGRAMMING_CODE);

    self = g_slice_new0 (QmiMessageDmsValidateServiceProgrammingCodeOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_VALIDATE_SERVICE_PROGRAMMING_CODE_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_validate_service_programming_code_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_validate_service_programming_code_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS UIM Get ICCID */


/* --- Input -- */

/* Note: no fields in the Input container */

static QmiMessage *
__qmi_message_dms_uim_get_iccid_request_create (
    guint16 transaction_id,
    guint8 cid,
    gpointer unused,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_UIM_GET_ICCID);

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsUimGetIccidOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* ICCID */
    gboolean arg_iccid_set;
    gchar *arg_iccid;
};

#define QMI_MESSAGE_DMS_UIM_GET_ICCID_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_DMS_UIM_GET_ICCID_OUTPUT_TLV_ICCID 0x01

gboolean
qmi_message_dms_uim_get_iccid_output_get_result (
    QmiMessageDmsUimGetIccidOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_dms_uim_get_iccid_output_get_iccid (
    QmiMessageDmsUimGetIccidOutput *self,
    const gchar **value_iccid,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_iccid_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'ICCID' was not found in the message");
        return FALSE;
    }

    if (value_iccid)
        *value_iccid = self->arg_iccid;

    return TRUE;
}

GType
qmi_message_dms_uim_get_iccid_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsUimGetIccidOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_uim_get_iccid_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_uim_get_iccid_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsUimGetIccidOutput *
qmi_message_dms_uim_get_iccid_output_ref (QmiMessageDmsUimGetIccidOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_uim_get_iccid_output_unref (QmiMessageDmsUimGetIccidOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_iccid, (GDestroyNotify)g_free);
        g_slice_free (QmiMessageDmsUimGetIccidOutput, self);
    }
}

static gchar *
qmi_message_dms_uim_get_iccid_output_iccid_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_UIM_GET_ICCID_OUTPUT_TLV_ICCID, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &tmp, &error))
            goto out;
        if (qmi_utils_get_show_personal_info ()) {
            g_string_append (printable, tmp);
        } else {
            g_string_append_printf (printable, "'###'");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_uim_get_iccid_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_uim_get_iccid_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_uim_get_iccid_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_UIM_GET_ICCID_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_UIM_GET_ICCID_OUTPUT_TLV_ICCID:
            tlv_type_str = "ICCID";
            translated_value = qmi_message_dms_uim_get_iccid_output_iccid_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            value_has_personal_info = TRUE;
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_uim_get_iccid_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"UIM Get ICCID\" (0x003C)\n",
                            line_prefix);

    {
        struct message_uim_get_iccid_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_uim_get_iccid_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsUimGetIccidOutput *
qmi_message_dms_uim_get_iccid_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsUimGetIccidOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_UIM_GET_ICCID);

    self = g_slice_new0 (QmiMessageDmsUimGetIccidOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_UIM_GET_ICCID_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_uim_get_iccid_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_uim_get_iccid_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_UIM_GET_ICCID_OUTPUT_TLV_ICCID, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory ICCID TLV: ");
                qmi_message_dms_uim_get_iccid_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &(self->arg_iccid), error))
                goto qmi_message_dms_uim_get_iccid_output_iccid_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'ICCID' TLV", offset);
            }

            self->arg_iccid_set = TRUE;

qmi_message_dms_uim_get_iccid_output_iccid_out:
            if (!self->arg_iccid_set) {
                qmi_message_dms_uim_get_iccid_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS Set Firmware ID */


/* --- Input -- */

/* Note: no fields in the Input container */

static QmiMessage *
__qmi_message_dms_set_firmware_id_request_create (
    guint16 transaction_id,
    guint8 cid,
    gpointer unused,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_SET_FIRMWARE_ID);

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsSetFirmwareIdOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;
};

#define QMI_MESSAGE_DMS_SET_FIRMWARE_ID_OUTPUT_TLV_RESULT 0x02

gboolean
qmi_message_dms_set_firmware_id_output_get_result (
    QmiMessageDmsSetFirmwareIdOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

GType
qmi_message_dms_set_firmware_id_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsSetFirmwareIdOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_set_firmware_id_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_set_firmware_id_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsSetFirmwareIdOutput *
qmi_message_dms_set_firmware_id_output_ref (QmiMessageDmsSetFirmwareIdOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_set_firmware_id_output_unref (QmiMessageDmsSetFirmwareIdOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsSetFirmwareIdOutput, self);
    }
}

struct message_set_firmware_id_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_set_firmware_id_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_set_firmware_id_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_SET_FIRMWARE_ID_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_set_firmware_id_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Set Firmware ID\" (0x003E)\n",
                            line_prefix);

    {
        struct message_set_firmware_id_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_set_firmware_id_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsSetFirmwareIdOutput *
qmi_message_dms_set_firmware_id_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsSetFirmwareIdOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_SET_FIRMWARE_ID);

    self = g_slice_new0 (QmiMessageDmsSetFirmwareIdOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SET_FIRMWARE_ID_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_set_firmware_id_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_set_firmware_id_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS UIM Get CK Status */


/* --- Input -- */

struct _QmiMessageDmsUimGetCkStatusInput {
    volatile gint ref_count;

    /* Facility */
    gboolean arg_facility_set;
    guint8 arg_facility;
};

#define QMI_MESSAGE_DMS_UIM_GET_CK_STATUS_INPUT_TLV_FACILITY 0x01

gboolean
qmi_message_dms_uim_get_ck_status_input_get_facility (
    QmiMessageDmsUimGetCkStatusInput *self,
    QmiDmsUimFacility *value_facility,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_facility_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Facility' was not found in the message");
        return FALSE;
    }

    if (value_facility)
        *value_facility = (QmiDmsUimFacility)(self->arg_facility);

    return TRUE;
}

gboolean
qmi_message_dms_uim_get_ck_status_input_set_facility (
    QmiMessageDmsUimGetCkStatusInput *self,
    QmiDmsUimFacility value_facility,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_facility = (guint8)(value_facility);
    self->arg_facility_set = TRUE;

    return TRUE;
}

GType
qmi_message_dms_uim_get_ck_status_input_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsUimGetCkStatusInput"),
                                          (GBoxedCopyFunc) qmi_message_dms_uim_get_ck_status_input_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_uim_get_ck_status_input_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsUimGetCkStatusInput *
qmi_message_dms_uim_get_ck_status_input_ref (QmiMessageDmsUimGetCkStatusInput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_uim_get_ck_status_input_unref (QmiMessageDmsUimGetCkStatusInput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsUimGetCkStatusInput, self);
    }
}

QmiMessageDmsUimGetCkStatusInput *
qmi_message_dms_uim_get_ck_status_input_new (void)
{
    QmiMessageDmsUimGetCkStatusInput *self;

    self = g_slice_new0 (QmiMessageDmsUimGetCkStatusInput);
    self->ref_count = 1;
    return self;
}

static QmiMessage *
__qmi_message_dms_uim_get_ck_status_request_create (
    guint16 transaction_id,
    guint8 cid,
    QmiMessageDmsUimGetCkStatusInput *input,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_UIM_GET_CK_STATUS);

    /* There is at least one mandatory TLV, don't allow NULL input */
    if (!input) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Message 'UIM Get CK Status' has mandatory TLVs");
        return NULL;
    }

    /* Try to add the 'Facility' TLV */
    if (input->arg_facility_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_DMS_UIM_GET_CK_STATUS_INPUT_TLV_FACILITY, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Facility': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_facility;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Facility': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Facility': ");
            return NULL;
        }
    } else {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Missing mandatory TLV 'Facility' in message 'UIM Get CK Status'");
        return NULL;
    }

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsUimGetCkStatusOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* CK Status */
    gboolean arg_ck_status_set;
    guint8 arg_ck_status_facility_state;
    guint8 arg_ck_status_verify_retries_left;
    guint8 arg_ck_status_unblock_retries_left;

    /* Operation Blocking Facility */
    gboolean arg_operation_blocking_facility_set;
    guint8 arg_operation_blocking_facility;
};

#define QMI_MESSAGE_DMS_UIM_GET_CK_STATUS_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_DMS_UIM_GET_CK_STATUS_OUTPUT_TLV_CK_STATUS 0x01
#define QMI_MESSAGE_DMS_UIM_GET_CK_STATUS_OUTPUT_TLV_OPERATION_BLOCKING_FACILITY 0x10

gboolean
qmi_message_dms_uim_get_ck_status_output_get_result (
    QmiMessageDmsUimGetCkStatusOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_dms_uim_get_ck_status_output_get_ck_status (
    QmiMessageDmsUimGetCkStatusOutput *self,
    QmiDmsUimFacilityState *value_ck_status_facility_state,
    guint8 *value_ck_status_verify_retries_left,
    guint8 *value_ck_status_unblock_retries_left,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_ck_status_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'CK Status' was not found in the message");
        return FALSE;
    }

    if (value_ck_status_facility_state)
        *value_ck_status_facility_state = (QmiDmsUimFacilityState)(self->arg_ck_status_facility_state);
    if (value_ck_status_verify_retries_left)
        *value_ck_status_verify_retries_left = self->arg_ck_status_verify_retries_left;
    if (value_ck_status_unblock_retries_left)
        *value_ck_status_unblock_retries_left = self->arg_ck_status_unblock_retries_left;

    return TRUE;
}

gboolean
qmi_message_dms_uim_get_ck_status_output_get_operation_blocking_facility (
    QmiMessageDmsUimGetCkStatusOutput *self,
    gboolean *value_operation_blocking_facility,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_operation_blocking_facility_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Operation Blocking Facility' was not found in the message");
        return FALSE;
    }

    if (value_operation_blocking_facility)
        *value_operation_blocking_facility = (gboolean)(self->arg_operation_blocking_facility);

    return TRUE;
}

GType
qmi_message_dms_uim_get_ck_status_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsUimGetCkStatusOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_uim_get_ck_status_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_uim_get_ck_status_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsUimGetCkStatusOutput *
qmi_message_dms_uim_get_ck_status_output_ref (QmiMessageDmsUimGetCkStatusOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_uim_get_ck_status_output_unref (QmiMessageDmsUimGetCkStatusOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsUimGetCkStatusOutput, self);
    }
}

static gchar *
qmi_message_dms_uim_get_ck_status_input_facility_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_UIM_GET_CK_STATUS_INPUT_TLV_FACILITY, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_DMS_UIM_FACILITY_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_dms_uim_facility_get_string ((QmiDmsUimFacility)tmp));
#elif defined  __QMI_DMS_UIM_FACILITY_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_dms_uim_facility_build_string_from_mask ((QmiDmsUimFacility)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiDmsUimFacility
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_uim_get_ck_status_output_ck_status_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_UIM_GET_CK_STATUS_OUTPUT_TLV_CK_STATUS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " facility_state = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_DMS_UIM_FACILITY_STATE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_dms_uim_facility_state_get_string ((QmiDmsUimFacilityState)tmp));
#elif defined  __QMI_DMS_UIM_FACILITY_STATE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_dms_uim_facility_state_build_string_from_mask ((QmiDmsUimFacilityState)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiDmsUimFacilityState
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " verify_retries_left = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " unblock_retries_left = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_uim_get_ck_status_output_operation_blocking_facility_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_UIM_GET_CK_STATUS_OUTPUT_TLV_OPERATION_BLOCKING_FACILITY, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_uim_get_ck_status_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_uim_get_ck_status_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_uim_get_ck_status_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        case QMI_MESSAGE_DMS_UIM_GET_CK_STATUS_INPUT_TLV_FACILITY:
            tlv_type_str = "Facility";
            translated_value = qmi_message_dms_uim_get_ck_status_input_facility_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_UIM_GET_CK_STATUS_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_UIM_GET_CK_STATUS_OUTPUT_TLV_CK_STATUS:
            tlv_type_str = "CK Status";
            translated_value = qmi_message_dms_uim_get_ck_status_output_ck_status_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_UIM_GET_CK_STATUS_OUTPUT_TLV_OPERATION_BLOCKING_FACILITY:
            tlv_type_str = "Operation Blocking Facility";
            translated_value = qmi_message_dms_uim_get_ck_status_output_operation_blocking_facility_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_uim_get_ck_status_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"UIM Get CK Status\" (0x0040)\n",
                            line_prefix);

    {
        struct message_uim_get_ck_status_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_uim_get_ck_status_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsUimGetCkStatusOutput *
qmi_message_dms_uim_get_ck_status_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsUimGetCkStatusOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_UIM_GET_CK_STATUS);

    self = g_slice_new0 (QmiMessageDmsUimGetCkStatusOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_UIM_GET_CK_STATUS_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_uim_get_ck_status_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_uim_get_ck_status_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_UIM_GET_CK_STATUS_OUTPUT_TLV_CK_STATUS, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory CK Status TLV: ");
                qmi_message_dms_uim_get_ck_status_output_unref (self);
                return NULL;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, error))
                    goto qmi_message_dms_uim_get_ck_status_output_ck_status_out;
                self->arg_ck_status_facility_state = (QmiDmsUimFacilityState)tmp;
            }
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_ck_status_verify_retries_left), error))
                goto qmi_message_dms_uim_get_ck_status_output_ck_status_out;
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_ck_status_unblock_retries_left), error))
                goto qmi_message_dms_uim_get_ck_status_output_ck_status_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'CK Status' TLV", offset);
            }

            self->arg_ck_status_set = TRUE;

qmi_message_dms_uim_get_ck_status_output_ck_status_out:
            if (!self->arg_ck_status_set) {
                qmi_message_dms_uim_get_ck_status_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_UIM_GET_CK_STATUS_OUTPUT_TLV_OPERATION_BLOCKING_FACILITY, NULL, NULL)) == 0) {
                goto qmi_message_dms_uim_get_ck_status_output_operation_blocking_facility_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_message_dms_uim_get_ck_status_output_operation_blocking_facility_out;
                self->arg_operation_blocking_facility = (gboolean)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Operation Blocking Facility' TLV", offset);
            }

            self->arg_operation_blocking_facility_set = TRUE;

qmi_message_dms_uim_get_ck_status_output_operation_blocking_facility_out:
            ;

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS UIM Set CK Protection */


/* --- Input -- */

struct _QmiMessageDmsUimSetCkProtectionInput {
    volatile gint ref_count;

    /* Facility */
    gboolean arg_facility_set;
    guint8 arg_facility_facility;
    guint8 arg_facility_facility_state;
    gchar *arg_facility_facility_depersonalization_control_key;
};

#define QMI_MESSAGE_DMS_UIM_SET_CK_PROTECTION_INPUT_TLV_FACILITY 0x01

gboolean
qmi_message_dms_uim_set_ck_protection_input_get_facility (
    QmiMessageDmsUimSetCkProtectionInput *self,
    QmiDmsUimFacility *value_facility_facility,
    QmiDmsUimFacilityState *value_facility_facility_state,
    const gchar **value_facility_facility_depersonalization_control_key,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_facility_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Facility' was not found in the message");
        return FALSE;
    }

    if (value_facility_facility)
        *value_facility_facility = (QmiDmsUimFacility)(self->arg_facility_facility);
    if (value_facility_facility_state)
        *value_facility_facility_state = (QmiDmsUimFacilityState)(self->arg_facility_facility_state);
    if (value_facility_facility_depersonalization_control_key)
        *value_facility_facility_depersonalization_control_key = self->arg_facility_facility_depersonalization_control_key;

    return TRUE;
}

gboolean
qmi_message_dms_uim_set_ck_protection_input_set_facility (
    QmiMessageDmsUimSetCkProtectionInput *self,
    QmiDmsUimFacility value_facility_facility,
    QmiDmsUimFacilityState value_facility_facility_state,
    const gchar *value_facility_facility_depersonalization_control_key,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_facility_facility = (guint8)(value_facility_facility);
    self->arg_facility_facility_state = (guint8)(value_facility_facility_state);
    g_free (self->arg_facility_facility_depersonalization_control_key);
    self->arg_facility_facility_depersonalization_control_key = g_strdup (value_facility_facility_depersonalization_control_key ? value_facility_facility_depersonalization_control_key : "");
    self->arg_facility_set = TRUE;

    return TRUE;
}

GType
qmi_message_dms_uim_set_ck_protection_input_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsUimSetCkProtectionInput"),
                                          (GBoxedCopyFunc) qmi_message_dms_uim_set_ck_protection_input_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_uim_set_ck_protection_input_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsUimSetCkProtectionInput *
qmi_message_dms_uim_set_ck_protection_input_ref (QmiMessageDmsUimSetCkProtectionInput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_uim_set_ck_protection_input_unref (QmiMessageDmsUimSetCkProtectionInput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_facility_facility_depersonalization_control_key, (GDestroyNotify)g_free);
        g_slice_free (QmiMessageDmsUimSetCkProtectionInput, self);
    }
}

QmiMessageDmsUimSetCkProtectionInput *
qmi_message_dms_uim_set_ck_protection_input_new (void)
{
    QmiMessageDmsUimSetCkProtectionInput *self;

    self = g_slice_new0 (QmiMessageDmsUimSetCkProtectionInput);
    self->ref_count = 1;
    return self;
}

static QmiMessage *
__qmi_message_dms_uim_set_ck_protection_request_create (
    guint16 transaction_id,
    guint8 cid,
    QmiMessageDmsUimSetCkProtectionInput *input,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_UIM_SET_CK_PROTECTION);

    /* There is at least one mandatory TLV, don't allow NULL input */
    if (!input) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Message 'UIM Set CK Protection' has mandatory TLVs");
        return NULL;
    }

    /* Try to add the 'Facility' TLV */
    if (input->arg_facility_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_DMS_UIM_SET_CK_PROTECTION_INPUT_TLV_FACILITY, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Facility': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_facility_facility;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Facility': ");
                return NULL;
            }
        }
        {
            guint8 tmp;

            tmp = (guint8) input->arg_facility_facility_state;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Facility': ");
                return NULL;
            }
        }
        if (!qmi_message_tlv_write_string (self, 1, input->arg_facility_facility_depersonalization_control_key, -1, error)) {
            g_prefix_error (error, "Cannot write string in TLV 'Facility': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Facility': ");
            return NULL;
        }
    } else {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Missing mandatory TLV 'Facility' in message 'UIM Set CK Protection'");
        return NULL;
    }

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsUimSetCkProtectionOutput {
    volatile gint ref_count;

    /* Verify Retries Left */
    gboolean arg_verify_retries_left_set;
    guint8 arg_verify_retries_left;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;
};

#define QMI_MESSAGE_DMS_UIM_SET_CK_PROTECTION_OUTPUT_TLV_VERIFY_RETRIES_LEFT 0x10
#define QMI_MESSAGE_DMS_UIM_SET_CK_PROTECTION_OUTPUT_TLV_RESULT 0x02

gboolean
qmi_message_dms_uim_set_ck_protection_output_get_verify_retries_left (
    QmiMessageDmsUimSetCkProtectionOutput *self,
    guint8 *value_verify_retries_left,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_verify_retries_left_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Verify Retries Left' was not found in the message");
        return FALSE;
    }

    if (value_verify_retries_left)
        *value_verify_retries_left = self->arg_verify_retries_left;

    return TRUE;
}

gboolean
qmi_message_dms_uim_set_ck_protection_output_get_result (
    QmiMessageDmsUimSetCkProtectionOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

GType
qmi_message_dms_uim_set_ck_protection_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsUimSetCkProtectionOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_uim_set_ck_protection_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_uim_set_ck_protection_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsUimSetCkProtectionOutput *
qmi_message_dms_uim_set_ck_protection_output_ref (QmiMessageDmsUimSetCkProtectionOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_uim_set_ck_protection_output_unref (QmiMessageDmsUimSetCkProtectionOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsUimSetCkProtectionOutput, self);
    }
}

static gchar *
qmi_message_dms_uim_set_ck_protection_input_facility_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_UIM_SET_CK_PROTECTION_INPUT_TLV_FACILITY, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " facility = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_DMS_UIM_FACILITY_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_dms_uim_facility_get_string ((QmiDmsUimFacility)tmp));
#elif defined  __QMI_DMS_UIM_FACILITY_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_dms_uim_facility_build_string_from_mask ((QmiDmsUimFacility)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiDmsUimFacility
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " facility_state = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_DMS_UIM_FACILITY_STATE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_dms_uim_facility_state_get_string ((QmiDmsUimFacilityState)tmp));
#elif defined  __QMI_DMS_UIM_FACILITY_STATE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_dms_uim_facility_state_build_string_from_mask ((QmiDmsUimFacilityState)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiDmsUimFacilityState
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " facility_depersonalization_control_key = '");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 1, 0, &tmp, &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_uim_set_ck_protection_output_verify_retries_left_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_UIM_SET_CK_PROTECTION_OUTPUT_TLV_VERIFY_RETRIES_LEFT, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_uim_set_ck_protection_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_uim_set_ck_protection_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_uim_set_ck_protection_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        case QMI_MESSAGE_DMS_UIM_SET_CK_PROTECTION_INPUT_TLV_FACILITY:
            tlv_type_str = "Facility";
            translated_value = qmi_message_dms_uim_set_ck_protection_input_facility_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_UIM_SET_CK_PROTECTION_OUTPUT_TLV_VERIFY_RETRIES_LEFT:
            tlv_type_str = "Verify Retries Left";
            translated_value = qmi_message_dms_uim_set_ck_protection_output_verify_retries_left_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_UIM_SET_CK_PROTECTION_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_uim_set_ck_protection_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"UIM Set CK Protection\" (0x0041)\n",
                            line_prefix);

    {
        struct message_uim_set_ck_protection_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_uim_set_ck_protection_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsUimSetCkProtectionOutput *
qmi_message_dms_uim_set_ck_protection_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsUimSetCkProtectionOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_UIM_SET_CK_PROTECTION);

    self = g_slice_new0 (QmiMessageDmsUimSetCkProtectionOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_UIM_SET_CK_PROTECTION_OUTPUT_TLV_VERIFY_RETRIES_LEFT, NULL, NULL)) == 0) {
                goto qmi_message_dms_uim_set_ck_protection_output_verify_retries_left_out;
            }
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_verify_retries_left), NULL))
                goto qmi_message_dms_uim_set_ck_protection_output_verify_retries_left_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Verify Retries Left' TLV", offset);
            }

            self->arg_verify_retries_left_set = TRUE;

qmi_message_dms_uim_set_ck_protection_output_verify_retries_left_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_UIM_SET_CK_PROTECTION_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_uim_set_ck_protection_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_uim_set_ck_protection_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS UIM Unblock CK */


/* --- Input -- */

struct _QmiMessageDmsUimUnblockCkInput {
    volatile gint ref_count;

    /* Facility */
    gboolean arg_facility_set;
    guint8 arg_facility_facility;
    gchar *arg_facility_facility_control_key;
};

#define QMI_MESSAGE_DMS_UIM_UNBLOCK_CK_INPUT_TLV_FACILITY 0x01

gboolean
qmi_message_dms_uim_unblock_ck_input_get_facility (
    QmiMessageDmsUimUnblockCkInput *self,
    QmiDmsUimFacility *value_facility_facility,
    const gchar **value_facility_facility_control_key,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_facility_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Facility' was not found in the message");
        return FALSE;
    }

    if (value_facility_facility)
        *value_facility_facility = (QmiDmsUimFacility)(self->arg_facility_facility);
    if (value_facility_facility_control_key)
        *value_facility_facility_control_key = self->arg_facility_facility_control_key;

    return TRUE;
}

gboolean
qmi_message_dms_uim_unblock_ck_input_set_facility (
    QmiMessageDmsUimUnblockCkInput *self,
    QmiDmsUimFacility value_facility_facility,
    const gchar *value_facility_facility_control_key,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_facility_facility = (guint8)(value_facility_facility);
    g_free (self->arg_facility_facility_control_key);
    self->arg_facility_facility_control_key = g_strdup (value_facility_facility_control_key ? value_facility_facility_control_key : "");
    self->arg_facility_set = TRUE;

    return TRUE;
}

GType
qmi_message_dms_uim_unblock_ck_input_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsUimUnblockCkInput"),
                                          (GBoxedCopyFunc) qmi_message_dms_uim_unblock_ck_input_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_uim_unblock_ck_input_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsUimUnblockCkInput *
qmi_message_dms_uim_unblock_ck_input_ref (QmiMessageDmsUimUnblockCkInput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_uim_unblock_ck_input_unref (QmiMessageDmsUimUnblockCkInput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_facility_facility_control_key, (GDestroyNotify)g_free);
        g_slice_free (QmiMessageDmsUimUnblockCkInput, self);
    }
}

QmiMessageDmsUimUnblockCkInput *
qmi_message_dms_uim_unblock_ck_input_new (void)
{
    QmiMessageDmsUimUnblockCkInput *self;

    self = g_slice_new0 (QmiMessageDmsUimUnblockCkInput);
    self->ref_count = 1;
    return self;
}

static QmiMessage *
__qmi_message_dms_uim_unblock_ck_request_create (
    guint16 transaction_id,
    guint8 cid,
    QmiMessageDmsUimUnblockCkInput *input,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_UIM_UNBLOCK_CK);

    /* There is at least one mandatory TLV, don't allow NULL input */
    if (!input) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Message 'UIM Unblock CK' has mandatory TLVs");
        return NULL;
    }

    /* Try to add the 'Facility' TLV */
    if (input->arg_facility_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_DMS_UIM_UNBLOCK_CK_INPUT_TLV_FACILITY, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Facility': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_facility_facility;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Facility': ");
                return NULL;
            }
        }
        if (!qmi_message_tlv_write_string (self, 1, input->arg_facility_facility_control_key, -1, error)) {
            g_prefix_error (error, "Cannot write string in TLV 'Facility': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Facility': ");
            return NULL;
        }
    } else {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Missing mandatory TLV 'Facility' in message 'UIM Unblock CK'");
        return NULL;
    }

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsUimUnblockCkOutput {
    volatile gint ref_count;

    /* Unblock Retries Left */
    gboolean arg_unblock_retries_left_set;
    guint8 arg_unblock_retries_left;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;
};

#define QMI_MESSAGE_DMS_UIM_UNBLOCK_CK_OUTPUT_TLV_UNBLOCK_RETRIES_LEFT 0x10
#define QMI_MESSAGE_DMS_UIM_UNBLOCK_CK_OUTPUT_TLV_RESULT 0x02

gboolean
qmi_message_dms_uim_unblock_ck_output_get_unblock_retries_left (
    QmiMessageDmsUimUnblockCkOutput *self,
    guint8 *value_unblock_retries_left,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_unblock_retries_left_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Unblock Retries Left' was not found in the message");
        return FALSE;
    }

    if (value_unblock_retries_left)
        *value_unblock_retries_left = self->arg_unblock_retries_left;

    return TRUE;
}

gboolean
qmi_message_dms_uim_unblock_ck_output_get_result (
    QmiMessageDmsUimUnblockCkOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

GType
qmi_message_dms_uim_unblock_ck_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsUimUnblockCkOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_uim_unblock_ck_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_uim_unblock_ck_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsUimUnblockCkOutput *
qmi_message_dms_uim_unblock_ck_output_ref (QmiMessageDmsUimUnblockCkOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_uim_unblock_ck_output_unref (QmiMessageDmsUimUnblockCkOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsUimUnblockCkOutput, self);
    }
}

static gchar *
qmi_message_dms_uim_unblock_ck_input_facility_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_UIM_UNBLOCK_CK_INPUT_TLV_FACILITY, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " facility = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_DMS_UIM_FACILITY_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_dms_uim_facility_get_string ((QmiDmsUimFacility)tmp));
#elif defined  __QMI_DMS_UIM_FACILITY_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_dms_uim_facility_build_string_from_mask ((QmiDmsUimFacility)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiDmsUimFacility
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " facility_control_key = '");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 1, 0, &tmp, &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_uim_unblock_ck_output_unblock_retries_left_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_UIM_UNBLOCK_CK_OUTPUT_TLV_UNBLOCK_RETRIES_LEFT, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_uim_unblock_ck_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_uim_unblock_ck_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_uim_unblock_ck_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        case QMI_MESSAGE_DMS_UIM_UNBLOCK_CK_INPUT_TLV_FACILITY:
            tlv_type_str = "Facility";
            translated_value = qmi_message_dms_uim_unblock_ck_input_facility_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_UIM_UNBLOCK_CK_OUTPUT_TLV_UNBLOCK_RETRIES_LEFT:
            tlv_type_str = "Unblock Retries Left";
            translated_value = qmi_message_dms_uim_unblock_ck_output_unblock_retries_left_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_UIM_UNBLOCK_CK_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_uim_unblock_ck_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"UIM Unblock CK\" (0x0042)\n",
                            line_prefix);

    {
        struct message_uim_unblock_ck_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_uim_unblock_ck_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsUimUnblockCkOutput *
qmi_message_dms_uim_unblock_ck_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsUimUnblockCkOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_UIM_UNBLOCK_CK);

    self = g_slice_new0 (QmiMessageDmsUimUnblockCkOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_UIM_UNBLOCK_CK_OUTPUT_TLV_UNBLOCK_RETRIES_LEFT, NULL, NULL)) == 0) {
                goto qmi_message_dms_uim_unblock_ck_output_unblock_retries_left_out;
            }
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_unblock_retries_left), NULL))
                goto qmi_message_dms_uim_unblock_ck_output_unblock_retries_left_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Unblock Retries Left' TLV", offset);
            }

            self->arg_unblock_retries_left_set = TRUE;

qmi_message_dms_uim_unblock_ck_output_unblock_retries_left_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_UIM_UNBLOCK_CK_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_uim_unblock_ck_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_uim_unblock_ck_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS UIM Get IMSI */


/* --- Input -- */

/* Note: no fields in the Input container */

static QmiMessage *
__qmi_message_dms_uim_get_imsi_request_create (
    guint16 transaction_id,
    guint8 cid,
    gpointer unused,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_UIM_GET_IMSI);

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsUimGetImsiOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* IMSI */
    gboolean arg_imsi_set;
    gchar *arg_imsi;
};

#define QMI_MESSAGE_DMS_UIM_GET_IMSI_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_DMS_UIM_GET_IMSI_OUTPUT_TLV_IMSI 0x01

gboolean
qmi_message_dms_uim_get_imsi_output_get_result (
    QmiMessageDmsUimGetImsiOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_dms_uim_get_imsi_output_get_imsi (
    QmiMessageDmsUimGetImsiOutput *self,
    const gchar **value_imsi,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_imsi_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'IMSI' was not found in the message");
        return FALSE;
    }

    if (value_imsi)
        *value_imsi = self->arg_imsi;

    return TRUE;
}

GType
qmi_message_dms_uim_get_imsi_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsUimGetImsiOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_uim_get_imsi_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_uim_get_imsi_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsUimGetImsiOutput *
qmi_message_dms_uim_get_imsi_output_ref (QmiMessageDmsUimGetImsiOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_uim_get_imsi_output_unref (QmiMessageDmsUimGetImsiOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_imsi, (GDestroyNotify)g_free);
        g_slice_free (QmiMessageDmsUimGetImsiOutput, self);
    }
}

static gchar *
qmi_message_dms_uim_get_imsi_output_imsi_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_UIM_GET_IMSI_OUTPUT_TLV_IMSI, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &tmp, &error))
            goto out;
        if (qmi_utils_get_show_personal_info ()) {
            g_string_append (printable, tmp);
        } else {
            g_string_append_printf (printable, "'###'");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_uim_get_imsi_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_uim_get_imsi_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_uim_get_imsi_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_UIM_GET_IMSI_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_UIM_GET_IMSI_OUTPUT_TLV_IMSI:
            tlv_type_str = "IMSI";
            translated_value = qmi_message_dms_uim_get_imsi_output_imsi_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            value_has_personal_info = TRUE;
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_uim_get_imsi_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"UIM Get IMSI\" (0x0043)\n",
                            line_prefix);

    {
        struct message_uim_get_imsi_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_uim_get_imsi_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsUimGetImsiOutput *
qmi_message_dms_uim_get_imsi_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsUimGetImsiOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_UIM_GET_IMSI);

    self = g_slice_new0 (QmiMessageDmsUimGetImsiOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_UIM_GET_IMSI_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_uim_get_imsi_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_uim_get_imsi_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_UIM_GET_IMSI_OUTPUT_TLV_IMSI, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory IMSI TLV: ");
                qmi_message_dms_uim_get_imsi_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &(self->arg_imsi), error))
                goto qmi_message_dms_uim_get_imsi_output_imsi_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'IMSI' TLV", offset);
            }

            self->arg_imsi_set = TRUE;

qmi_message_dms_uim_get_imsi_output_imsi_out:
            if (!self->arg_imsi_set) {
                qmi_message_dms_uim_get_imsi_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS UIM Get State */


/* --- Input -- */

/* Note: no fields in the Input container */

static QmiMessage *
__qmi_message_dms_uim_get_state_request_create (
    guint16 transaction_id,
    guint8 cid,
    gpointer unused,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_UIM_GET_STATE);

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsUimGetStateOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* State */
    gboolean arg_state_set;
    guint8 arg_state;
};

#define QMI_MESSAGE_DMS_UIM_GET_STATE_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_DMS_UIM_GET_STATE_OUTPUT_TLV_STATE 0x01

gboolean
qmi_message_dms_uim_get_state_output_get_result (
    QmiMessageDmsUimGetStateOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_dms_uim_get_state_output_get_state (
    QmiMessageDmsUimGetStateOutput *self,
    QmiDmsUimState *value_state,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_state_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'State' was not found in the message");
        return FALSE;
    }

    if (value_state)
        *value_state = (QmiDmsUimState)(self->arg_state);

    return TRUE;
}

GType
qmi_message_dms_uim_get_state_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsUimGetStateOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_uim_get_state_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_uim_get_state_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsUimGetStateOutput *
qmi_message_dms_uim_get_state_output_ref (QmiMessageDmsUimGetStateOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_uim_get_state_output_unref (QmiMessageDmsUimGetStateOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsUimGetStateOutput, self);
    }
}

static gchar *
qmi_message_dms_uim_get_state_output_state_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_UIM_GET_STATE_OUTPUT_TLV_STATE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_DMS_UIM_STATE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_dms_uim_state_get_string ((QmiDmsUimState)tmp));
#elif defined  __QMI_DMS_UIM_STATE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_dms_uim_state_build_string_from_mask ((QmiDmsUimState)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiDmsUimState
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_uim_get_state_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_uim_get_state_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_uim_get_state_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_UIM_GET_STATE_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_UIM_GET_STATE_OUTPUT_TLV_STATE:
            tlv_type_str = "State";
            translated_value = qmi_message_dms_uim_get_state_output_state_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_uim_get_state_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"UIM Get State\" (0x0044)\n",
                            line_prefix);

    {
        struct message_uim_get_state_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_uim_get_state_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsUimGetStateOutput *
qmi_message_dms_uim_get_state_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsUimGetStateOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_UIM_GET_STATE);

    self = g_slice_new0 (QmiMessageDmsUimGetStateOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_UIM_GET_STATE_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_uim_get_state_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_uim_get_state_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_UIM_GET_STATE_OUTPUT_TLV_STATE, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory State TLV: ");
                qmi_message_dms_uim_get_state_output_unref (self);
                return NULL;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, error))
                    goto qmi_message_dms_uim_get_state_output_state_out;
                self->arg_state = (QmiDmsUimState)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'State' TLV", offset);
            }

            self->arg_state_set = TRUE;

qmi_message_dms_uim_get_state_output_state_out:
            if (!self->arg_state_set) {
                qmi_message_dms_uim_get_state_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS Get Band Capabilities */


/* --- Input -- */

/* Note: no fields in the Input container */

static QmiMessage *
__qmi_message_dms_get_band_capabilities_request_create (
    guint16 transaction_id,
    guint8 cid,
    gpointer unused,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_GET_BAND_CAPABILITIES);

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsGetBandCapabilitiesOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* Band Capability */
    gboolean arg_band_capability_set;
    guint64 arg_band_capability;

    /* LTE Band Capability */
    gboolean arg_lte_band_capability_set;
    guint64 arg_lte_band_capability;

    /* Extended LTE Band Capability */
    gboolean arg_extended_lte_band_capability_set;
    GArray *arg_extended_lte_band_capability;

    /* NR5G Band Capability */
    gboolean arg_nr5g_band_capability_set;
    GArray *arg_nr5g_band_capability;
};

#define QMI_MESSAGE_DMS_GET_BAND_CAPABILITIES_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_DMS_GET_BAND_CAPABILITIES_OUTPUT_TLV_BAND_CAPABILITY 0x01
#define QMI_MESSAGE_DMS_GET_BAND_CAPABILITIES_OUTPUT_TLV_LTE_BAND_CAPABILITY 0x10
#define QMI_MESSAGE_DMS_GET_BAND_CAPABILITIES_OUTPUT_TLV_EXTENDED_LTE_BAND_CAPABILITY 0x12
#define QMI_MESSAGE_DMS_GET_BAND_CAPABILITIES_OUTPUT_TLV_NR5G_BAND_CAPABILITY 0x13

gboolean
qmi_message_dms_get_band_capabilities_output_get_result (
    QmiMessageDmsGetBandCapabilitiesOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_dms_get_band_capabilities_output_get_band_capability (
    QmiMessageDmsGetBandCapabilitiesOutput *self,
    QmiDmsBandCapability *value_band_capability,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_band_capability_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Band Capability' was not found in the message");
        return FALSE;
    }

    if (value_band_capability)
        *value_band_capability = (QmiDmsBandCapability)(self->arg_band_capability);

    return TRUE;
}

gboolean
qmi_message_dms_get_band_capabilities_output_get_lte_band_capability (
    QmiMessageDmsGetBandCapabilitiesOutput *self,
    QmiDmsLteBandCapability *value_lte_band_capability,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_lte_band_capability_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'LTE Band Capability' was not found in the message");
        return FALSE;
    }

    if (value_lte_band_capability)
        *value_lte_band_capability = (QmiDmsLteBandCapability)(self->arg_lte_band_capability);

    return TRUE;
}

gboolean
qmi_message_dms_get_band_capabilities_output_get_extended_lte_band_capability (
    QmiMessageDmsGetBandCapabilitiesOutput *self,
    GArray **value_extended_lte_band_capability,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_extended_lte_band_capability_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Extended LTE Band Capability' was not found in the message");
        return FALSE;
    }

    if (value_extended_lte_band_capability)
        *value_extended_lte_band_capability = self->arg_extended_lte_band_capability;

    return TRUE;
}

gboolean
qmi_message_dms_get_band_capabilities_output_get_nr5g_band_capability (
    QmiMessageDmsGetBandCapabilitiesOutput *self,
    GArray **value_nr5g_band_capability,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_nr5g_band_capability_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'NR5G Band Capability' was not found in the message");
        return FALSE;
    }

    if (value_nr5g_band_capability)
        *value_nr5g_band_capability = self->arg_nr5g_band_capability;

    return TRUE;
}

GType
qmi_message_dms_get_band_capabilities_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsGetBandCapabilitiesOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_get_band_capabilities_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_get_band_capabilities_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsGetBandCapabilitiesOutput *
qmi_message_dms_get_band_capabilities_output_ref (QmiMessageDmsGetBandCapabilitiesOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_get_band_capabilities_output_unref (QmiMessageDmsGetBandCapabilitiesOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_extended_lte_band_capability, (GDestroyNotify)g_array_unref);
        g_clear_pointer (&self->arg_nr5g_band_capability, (GDestroyNotify)g_array_unref);
        g_slice_free (QmiMessageDmsGetBandCapabilitiesOutput, self);
    }
}

static gchar *
qmi_message_dms_get_band_capabilities_output_band_capability_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_BAND_CAPABILITIES_OUTPUT_TLV_BAND_CAPABILITY, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint64 tmp;

        if (!qmi_message_tlv_read_guint64 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
#if defined  __QMI_DMS_BAND_CAPABILITY_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_dms_band_capability_get_string ((QmiDmsBandCapability)tmp));
#elif defined  __QMI_DMS_BAND_CAPABILITY_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_dms_band_capability_build_string_from_mask ((QmiDmsBandCapability)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiDmsBandCapability
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_get_band_capabilities_output_lte_band_capability_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_BAND_CAPABILITIES_OUTPUT_TLV_LTE_BAND_CAPABILITY, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint64 tmp;

        if (!qmi_message_tlv_read_guint64 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
#if defined  __QMI_DMS_LTE_BAND_CAPABILITY_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_dms_lte_band_capability_get_string ((QmiDmsLteBandCapability)tmp));
#elif defined  __QMI_DMS_LTE_BAND_CAPABILITY_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_dms_lte_band_capability_build_string_from_mask ((QmiDmsLteBandCapability)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiDmsLteBandCapability
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_get_band_capabilities_output_extended_lte_band_capability_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_BAND_CAPABILITIES_OUTPUT_TLV_EXTENDED_LTE_BAND_CAPABILITY, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    {
        guint extended_lte_band_capability_i;
        guint16 extended_lte_band_capability_n_items;

        /* Read number of items in the array */
        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(extended_lte_band_capability_n_items), &error))
            goto out;

        g_string_append (printable, "{");

        for (extended_lte_band_capability_i = 0; extended_lte_band_capability_i < extended_lte_band_capability_n_items; extended_lte_band_capability_i++) {
            g_string_append_printf (printable, " [%u] = '", extended_lte_band_capability_i);

            {
                guint16 tmp;

                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
                    goto out;
                {
                    g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
                }
            }
            g_string_append (printable, "'");
        }

        g_string_append (printable, "}");
    }
    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_get_band_capabilities_output_nr5g_band_capability_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_BAND_CAPABILITIES_OUTPUT_TLV_NR5G_BAND_CAPABILITY, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    {
        guint nr5g_band_capability_i;
        guint16 nr5g_band_capability_n_items;

        /* Read number of items in the array */
        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(nr5g_band_capability_n_items), &error))
            goto out;

        g_string_append (printable, "{");

        for (nr5g_band_capability_i = 0; nr5g_band_capability_i < nr5g_band_capability_n_items; nr5g_band_capability_i++) {
            g_string_append_printf (printable, " [%u] = '", nr5g_band_capability_i);

            {
                guint16 tmp;

                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
                    goto out;
                {
                    g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
                }
            }
            g_string_append (printable, "'");
        }

        g_string_append (printable, "}");
    }
    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_get_band_capabilities_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_get_band_capabilities_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_get_band_capabilities_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_GET_BAND_CAPABILITIES_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_GET_BAND_CAPABILITIES_OUTPUT_TLV_BAND_CAPABILITY:
            tlv_type_str = "Band Capability";
            translated_value = qmi_message_dms_get_band_capabilities_output_band_capability_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_GET_BAND_CAPABILITIES_OUTPUT_TLV_LTE_BAND_CAPABILITY:
            tlv_type_str = "LTE Band Capability";
            translated_value = qmi_message_dms_get_band_capabilities_output_lte_band_capability_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_GET_BAND_CAPABILITIES_OUTPUT_TLV_EXTENDED_LTE_BAND_CAPABILITY:
            tlv_type_str = "Extended LTE Band Capability";
            translated_value = qmi_message_dms_get_band_capabilities_output_extended_lte_band_capability_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_GET_BAND_CAPABILITIES_OUTPUT_TLV_NR5G_BAND_CAPABILITY:
            tlv_type_str = "NR5G Band Capability";
            translated_value = qmi_message_dms_get_band_capabilities_output_nr5g_band_capability_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_get_band_capabilities_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Get Band Capabilities\" (0x0045)\n",
                            line_prefix);

    {
        struct message_get_band_capabilities_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_get_band_capabilities_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsGetBandCapabilitiesOutput *
qmi_message_dms_get_band_capabilities_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsGetBandCapabilitiesOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_GET_BAND_CAPABILITIES);

    self = g_slice_new0 (QmiMessageDmsGetBandCapabilitiesOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_BAND_CAPABILITIES_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_get_band_capabilities_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_get_band_capabilities_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_BAND_CAPABILITIES_OUTPUT_TLV_BAND_CAPABILITY, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Band Capability TLV: ");
                qmi_message_dms_get_band_capabilities_output_unref (self);
                return NULL;
            }
            {
                guint64 tmp;

                if (!qmi_message_tlv_read_guint64 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, error))
                    goto qmi_message_dms_get_band_capabilities_output_band_capability_out;
                self->arg_band_capability = (QmiDmsBandCapability)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Band Capability' TLV", offset);
            }

            self->arg_band_capability_set = TRUE;

qmi_message_dms_get_band_capabilities_output_band_capability_out:
            if (!self->arg_band_capability_set) {
                qmi_message_dms_get_band_capabilities_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_BAND_CAPABILITIES_OUTPUT_TLV_LTE_BAND_CAPABILITY, NULL, NULL)) == 0) {
                goto qmi_message_dms_get_band_capabilities_output_lte_band_capability_out;
            }
            {
                guint64 tmp;

                if (!qmi_message_tlv_read_guint64 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, NULL))
                    goto qmi_message_dms_get_band_capabilities_output_lte_band_capability_out;
                self->arg_lte_band_capability = (QmiDmsLteBandCapability)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'LTE Band Capability' TLV", offset);
            }

            self->arg_lte_band_capability_set = TRUE;

qmi_message_dms_get_band_capabilities_output_lte_band_capability_out:
            ;

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_BAND_CAPABILITIES_OUTPUT_TLV_EXTENDED_LTE_BAND_CAPABILITY, NULL, NULL)) == 0) {
                goto qmi_message_dms_get_band_capabilities_output_extended_lte_band_capability_out;
            }
            {
                guint extended_lte_band_capability_i;
                guint16 extended_lte_band_capability_n_items;

                /* Read number of items in the array */
                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(extended_lte_band_capability_n_items), NULL))
                    goto qmi_message_dms_get_band_capabilities_output_extended_lte_band_capability_out;

                self->arg_extended_lte_band_capability = g_array_sized_new (
                    FALSE,
                    FALSE,
                    sizeof (guint16),
                    (guint)extended_lte_band_capability_n_items);

                for (extended_lte_band_capability_i = 0; extended_lte_band_capability_i < extended_lte_band_capability_n_items; extended_lte_band_capability_i++) {
                    guint16 extended_lte_band_capability_aux;

                    if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(extended_lte_band_capability_aux), NULL))
                        goto qmi_message_dms_get_band_capabilities_output_extended_lte_band_capability_out;
                    g_array_insert_val (self->arg_extended_lte_band_capability, extended_lte_band_capability_i, extended_lte_band_capability_aux);
                }
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Extended LTE Band Capability' TLV", offset);
            }

            self->arg_extended_lte_band_capability_set = TRUE;

qmi_message_dms_get_band_capabilities_output_extended_lte_band_capability_out:
            ;

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_BAND_CAPABILITIES_OUTPUT_TLV_NR5G_BAND_CAPABILITY, NULL, NULL)) == 0) {
                goto qmi_message_dms_get_band_capabilities_output_nr5g_band_capability_out;
            }
            {
                guint nr5g_band_capability_i;
                guint16 nr5g_band_capability_n_items;

                /* Read number of items in the array */
                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(nr5g_band_capability_n_items), NULL))
                    goto qmi_message_dms_get_band_capabilities_output_nr5g_band_capability_out;

                self->arg_nr5g_band_capability = g_array_sized_new (
                    FALSE,
                    FALSE,
                    sizeof (guint16),
                    (guint)nr5g_band_capability_n_items);

                for (nr5g_band_capability_i = 0; nr5g_band_capability_i < nr5g_band_capability_n_items; nr5g_band_capability_i++) {
                    guint16 nr5g_band_capability_aux;

                    if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(nr5g_band_capability_aux), NULL))
                        goto qmi_message_dms_get_band_capabilities_output_nr5g_band_capability_out;
                    g_array_insert_val (self->arg_nr5g_band_capability, nr5g_band_capability_i, nr5g_band_capability_aux);
                }
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'NR5G Band Capability' TLV", offset);
            }

            self->arg_nr5g_band_capability_set = TRUE;

qmi_message_dms_get_band_capabilities_output_nr5g_band_capability_out:
            ;

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS Get Factory SKU */


/* --- Input -- */

/* Note: no fields in the Input container */

static QmiMessage *
__qmi_message_dms_get_factory_sku_request_create (
    guint16 transaction_id,
    guint8 cid,
    gpointer unused,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_GET_FACTORY_SKU);

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsGetFactorySkuOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* SKU */
    gboolean arg_sku_set;
    gchar *arg_sku;
};

#define QMI_MESSAGE_DMS_GET_FACTORY_SKU_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_DMS_GET_FACTORY_SKU_OUTPUT_TLV_SKU 0x01

gboolean
qmi_message_dms_get_factory_sku_output_get_result (
    QmiMessageDmsGetFactorySkuOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_dms_get_factory_sku_output_get_sku (
    QmiMessageDmsGetFactorySkuOutput *self,
    const gchar **value_sku,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_sku_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'SKU' was not found in the message");
        return FALSE;
    }

    if (value_sku)
        *value_sku = self->arg_sku;

    return TRUE;
}

GType
qmi_message_dms_get_factory_sku_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsGetFactorySkuOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_get_factory_sku_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_get_factory_sku_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsGetFactorySkuOutput *
qmi_message_dms_get_factory_sku_output_ref (QmiMessageDmsGetFactorySkuOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_get_factory_sku_output_unref (QmiMessageDmsGetFactorySkuOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_sku, (GDestroyNotify)g_free);
        g_slice_free (QmiMessageDmsGetFactorySkuOutput, self);
    }
}

static gchar *
qmi_message_dms_get_factory_sku_output_sku_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_FACTORY_SKU_OUTPUT_TLV_SKU, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &tmp, &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_get_factory_sku_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_get_factory_sku_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_get_factory_sku_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_GET_FACTORY_SKU_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_GET_FACTORY_SKU_OUTPUT_TLV_SKU:
            tlv_type_str = "SKU";
            translated_value = qmi_message_dms_get_factory_sku_output_sku_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_get_factory_sku_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Get Factory SKU\" (0x0046)\n",
                            line_prefix);

    {
        struct message_get_factory_sku_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_get_factory_sku_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsGetFactorySkuOutput *
qmi_message_dms_get_factory_sku_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsGetFactorySkuOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_GET_FACTORY_SKU);

    self = g_slice_new0 (QmiMessageDmsGetFactorySkuOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_FACTORY_SKU_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_get_factory_sku_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_get_factory_sku_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_FACTORY_SKU_OUTPUT_TLV_SKU, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory SKU TLV: ");
                qmi_message_dms_get_factory_sku_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &(self->arg_sku), error))
                goto qmi_message_dms_get_factory_sku_output_sku_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'SKU' TLV", offset);
            }

            self->arg_sku_set = TRUE;

qmi_message_dms_get_factory_sku_output_sku_out:
            if (!self->arg_sku_set) {
                qmi_message_dms_get_factory_sku_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS Get Firmware Preference */


/* --- Input -- */

/* Note: no fields in the Input container */

static QmiMessage *
__qmi_message_dms_get_firmware_preference_request_create (
    guint16 transaction_id,
    guint8 cid,
    gpointer unused,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_GET_FIRMWARE_PREFERENCE);

    return g_steal_pointer (&self);
}

/* --- Output -- */

static void
__qmi_message_dms_get_firmware_preference_output_list_image_clear (QmiMessageDmsGetFirmwarePreferenceOutputListImage *value)
{
    g_clear_pointer (&value->unique_id, (GDestroyNotify)g_array_unref);
    g_clear_pointer (&value->build_id, (GDestroyNotify)g_free);
}

static void
__qmi_message_dms_get_firmware_preference_output_list_image_free (QmiMessageDmsGetFirmwarePreferenceOutputListImage *value)
{
    __qmi_message_dms_get_firmware_preference_output_list_image_clear (value);
    g_slice_free (QmiMessageDmsGetFirmwarePreferenceOutputListImage, value);
}

static QmiMessageDmsGetFirmwarePreferenceOutputListImage *
__qmi_message_dms_get_firmware_preference_output_list_image_new (void)
{
    return g_slice_new0 (QmiMessageDmsGetFirmwarePreferenceOutputListImage);
}

static QmiMessageDmsGetFirmwarePreferenceOutputListImage *
__qmi_message_dms_get_firmware_preference_output_list_image_copy (const QmiMessageDmsGetFirmwarePreferenceOutputListImage *value)
{
    QmiMessageDmsGetFirmwarePreferenceOutputListImage *copy;

    copy = __qmi_message_dms_get_firmware_preference_output_list_image_new ();
    copy->type = value->type;
    copy->unique_id = g_array_ref (value->unique_id);
    copy->build_id = g_strdup (value->build_id);
    return copy;
}

G_DEFINE_BOXED_TYPE (QmiMessageDmsGetFirmwarePreferenceOutputListImage, qmi_message_dms_get_firmware_preference_output_list_image, (GBoxedCopyFunc)__qmi_message_dms_get_firmware_preference_output_list_image_copy, (GBoxedFreeFunc)__qmi_message_dms_get_firmware_preference_output_list_image_free)

struct _QmiMessageDmsGetFirmwarePreferenceOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* List */
    gboolean arg_list_set;
    GArray *arg_list;
    GPtrArray *arg_list_ptr;
};

#define QMI_MESSAGE_DMS_GET_FIRMWARE_PREFERENCE_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_DMS_GET_FIRMWARE_PREFERENCE_OUTPUT_TLV_LIST 0x01

gboolean
qmi_message_dms_get_firmware_preference_output_get_result (
    QmiMessageDmsGetFirmwarePreferenceOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_dms_get_firmware_preference_output_get_list (
    QmiMessageDmsGetFirmwarePreferenceOutput *self,
    GArray **value_list,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_list_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'List' was not found in the message");
        return FALSE;
    }

    if (value_list)
        *value_list = self->arg_list;

    return TRUE;
}

gboolean
qmi_message_dms_get_firmware_preference_output_get_list_gir (
    QmiMessageDmsGetFirmwarePreferenceOutput *self,
    GPtrArray **value_list_ptr,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_list_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'List' was not found in the message");
        return FALSE;
    }

    if (value_list_ptr) {
        if (!self->arg_list_ptr) {
            {
                guint list_i;

                self->arg_list_ptr = g_ptr_array_new_full (self->arg_list->len, (GDestroyNotify)__qmi_message_dms_get_firmware_preference_output_list_image_free);
                for (list_i = 0; list_i < self->arg_list->len; list_i++) {
                    QmiMessageDmsGetFirmwarePreferenceOutputListImage *list_aux_from;
                    QmiMessageDmsGetFirmwarePreferenceOutputListImage *list_aux_to;

                    list_aux_from = &g_array_index (self->arg_list, QmiMessageDmsGetFirmwarePreferenceOutputListImage, list_i);

                    list_aux_to = __qmi_message_dms_get_firmware_preference_output_list_image_new ();
                    list_aux_to->type = (*list_aux_from).type;
                    list_aux_to->unique_id = g_array_ref ((*list_aux_from).unique_id);
                    list_aux_to->build_id = g_strdup ((*list_aux_from).build_id);

                    g_ptr_array_add (self->arg_list_ptr, list_aux_to);
                }
            }
        }
        *value_list_ptr = self->arg_list_ptr;
    }
    return TRUE;
}

GType
qmi_message_dms_get_firmware_preference_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsGetFirmwarePreferenceOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_get_firmware_preference_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_get_firmware_preference_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsGetFirmwarePreferenceOutput *
qmi_message_dms_get_firmware_preference_output_ref (QmiMessageDmsGetFirmwarePreferenceOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_get_firmware_preference_output_unref (QmiMessageDmsGetFirmwarePreferenceOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_list, (GDestroyNotify)g_array_unref);
        g_clear_pointer (&self->arg_list, (GDestroyNotify)g_ptr_array_unref);
        g_slice_free (QmiMessageDmsGetFirmwarePreferenceOutput, self);
    }
}

static gchar *
qmi_message_dms_get_firmware_preference_output_list_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_FIRMWARE_PREFERENCE_OUTPUT_TLV_LIST, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    {
        guint list_i;
        guint8 list_n_items;

        /* Read number of items in the array */
        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(list_n_items), &error))
            goto out;

        g_string_append (printable, "{");

        for (list_i = 0; list_i < list_n_items; list_i++) {
            g_string_append_printf (printable, " [%u] = '", list_i);
            g_string_append (printable, "[");
            g_string_append (printable, " type = '");

            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
#if defined  __QMI_DMS_FIRMWARE_IMAGE_TYPE_IS_ENUM__
                    g_string_append_printf (printable, "%s", qmi_dms_firmware_image_type_get_string ((QmiDmsFirmwareImageType)tmp));
#elif defined  __QMI_DMS_FIRMWARE_IMAGE_TYPE_IS_FLAGS__
                    {
                        g_autofree gchar *flags_str = NULL;

                        flags_str = qmi_dms_firmware_image_type_build_string_from_mask ((QmiDmsFirmwareImageType)tmp);
                        g_string_append_printf (printable, "%s", flags_str);
                    }
#else
# error unexpected public format: QmiDmsFirmwareImageType
#endif
                }
            }
            g_string_append (printable, "'");
            g_string_append (printable, " unique_id = '");
            {
                guint unique_id_i;
                guint16 unique_id_n_items = 16;


                g_string_append (printable, "{");

                for (unique_id_i = 0; unique_id_i < unique_id_n_items; unique_id_i++) {
                    g_string_append_printf (printable, " [%u] = '", unique_id_i);

                    {
                        guint8 tmp;

                        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
                            goto out;
                        {
                            g_string_append_printf (printable, "%u", (guint)tmp);
                        }
                    }
                    g_string_append (printable, "'");
                }

                g_string_append (printable, "}");
            }            g_string_append (printable, "'");
            g_string_append (printable, " build_id = '");

            {
                g_autofree gchar *tmp = NULL;

                if (!qmi_message_tlv_read_string (message, init_offset, &offset, 1, 0, &tmp, &error))
                    goto out;
                {
                    g_string_append (printable, tmp);
                }
            }
            g_string_append (printable, "'");
            g_string_append (printable, " ]");
            g_string_append (printable, "'");
        }

        g_string_append (printable, "}");
    }
    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_get_firmware_preference_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_get_firmware_preference_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_get_firmware_preference_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_GET_FIRMWARE_PREFERENCE_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_GET_FIRMWARE_PREFERENCE_OUTPUT_TLV_LIST:
            tlv_type_str = "List";
            translated_value = qmi_message_dms_get_firmware_preference_output_list_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_get_firmware_preference_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Get Firmware Preference\" (0x0047)\n",
                            line_prefix);

    {
        struct message_get_firmware_preference_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_get_firmware_preference_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsGetFirmwarePreferenceOutput *
qmi_message_dms_get_firmware_preference_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsGetFirmwarePreferenceOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_GET_FIRMWARE_PREFERENCE);

    self = g_slice_new0 (QmiMessageDmsGetFirmwarePreferenceOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_FIRMWARE_PREFERENCE_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_get_firmware_preference_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_get_firmware_preference_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_FIRMWARE_PREFERENCE_OUTPUT_TLV_LIST, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory List TLV: ");
                qmi_message_dms_get_firmware_preference_output_unref (self);
                return NULL;
            }
            {
                guint list_i;
                guint8 list_n_items;

                /* Read number of items in the array */
                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(list_n_items), error))
                    goto qmi_message_dms_get_firmware_preference_output_list_out;

                self->arg_list = g_array_sized_new (
                    FALSE,
                    FALSE,
                    sizeof (QmiMessageDmsGetFirmwarePreferenceOutputListImage),
                    (guint)list_n_items);

                g_array_set_clear_func (self->arg_list, (GDestroyNotify)__qmi_message_dms_get_firmware_preference_output_list_image_clear);

                for (list_i = 0; list_i < list_n_items; list_i++) {
                    QmiMessageDmsGetFirmwarePreferenceOutputListImage list_aux;

                    {
                        guint8 tmp;

                        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, error))
                            goto qmi_message_dms_get_firmware_preference_output_list_out;
                        list_aux.type = (QmiDmsFirmwareImageType)tmp;
                    }
                    {
                        guint unique_id_i;
                        guint16 unique_id_n_items = 16;


                        list_aux.unique_id = g_array_sized_new (
                            FALSE,
                            FALSE,
                            sizeof (guint8),
                            (guint)unique_id_n_items);

                        for (unique_id_i = 0; unique_id_i < unique_id_n_items; unique_id_i++) {
                            guint8 unique_id_aux;

                            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(unique_id_aux), error))
                                goto qmi_message_dms_get_firmware_preference_output_list_out;
                            g_array_insert_val (list_aux.unique_id, unique_id_i, unique_id_aux);
                        }
                    }
                    if (!qmi_message_tlv_read_string (message, init_offset, &offset, 1, 0, &(list_aux.build_id), error))
                        goto qmi_message_dms_get_firmware_preference_output_list_out;
                    g_array_insert_val (self->arg_list, list_i, list_aux);
                }
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'List' TLV", offset);
            }

            self->arg_list_set = TRUE;

qmi_message_dms_get_firmware_preference_output_list_out:
            if (!self->arg_list_set) {
                qmi_message_dms_get_firmware_preference_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS Set Firmware Preference */


/* --- Input -- */

static void
__qmi_message_dms_set_firmware_preference_input_list_image_clear (QmiMessageDmsSetFirmwarePreferenceInputListImage *value)
{
    g_clear_pointer (&value->unique_id, (GDestroyNotify)g_array_unref);
    g_clear_pointer (&value->build_id, (GDestroyNotify)g_free);
}

static void
__qmi_message_dms_set_firmware_preference_input_list_image_free (QmiMessageDmsSetFirmwarePreferenceInputListImage *value)
{
    __qmi_message_dms_set_firmware_preference_input_list_image_clear (value);
    g_slice_free (QmiMessageDmsSetFirmwarePreferenceInputListImage, value);
}

static QmiMessageDmsSetFirmwarePreferenceInputListImage *
__qmi_message_dms_set_firmware_preference_input_list_image_new (void)
{
    return g_slice_new0 (QmiMessageDmsSetFirmwarePreferenceInputListImage);
}

static QmiMessageDmsSetFirmwarePreferenceInputListImage *
__qmi_message_dms_set_firmware_preference_input_list_image_copy (const QmiMessageDmsSetFirmwarePreferenceInputListImage *value)
{
    QmiMessageDmsSetFirmwarePreferenceInputListImage *copy;

    copy = __qmi_message_dms_set_firmware_preference_input_list_image_new ();
    copy->type = value->type;
    copy->unique_id = g_array_ref (value->unique_id);
    copy->build_id = g_strdup (value->build_id);
    return copy;
}

G_DEFINE_BOXED_TYPE (QmiMessageDmsSetFirmwarePreferenceInputListImage, qmi_message_dms_set_firmware_preference_input_list_image, (GBoxedCopyFunc)__qmi_message_dms_set_firmware_preference_input_list_image_copy, (GBoxedFreeFunc)__qmi_message_dms_set_firmware_preference_input_list_image_free)

struct _QmiMessageDmsSetFirmwarePreferenceInput {
    volatile gint ref_count;

    /* Modem Storage Index */
    gboolean arg_modem_storage_index_set;
    guint8 arg_modem_storage_index;

    /* Download Override */
    gboolean arg_download_override_set;
    guint8 arg_download_override;

    /* List */
    gboolean arg_list_set;
    GArray *arg_list;
    GPtrArray *arg_list_ptr;
};

#define QMI_MESSAGE_DMS_SET_FIRMWARE_PREFERENCE_INPUT_TLV_MODEM_STORAGE_INDEX 0x11
#define QMI_MESSAGE_DMS_SET_FIRMWARE_PREFERENCE_INPUT_TLV_DOWNLOAD_OVERRIDE 0x10
#define QMI_MESSAGE_DMS_SET_FIRMWARE_PREFERENCE_INPUT_TLV_LIST 0x01

gboolean
qmi_message_dms_set_firmware_preference_input_get_modem_storage_index (
    QmiMessageDmsSetFirmwarePreferenceInput *self,
    guint8 *value_modem_storage_index,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_modem_storage_index_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Modem Storage Index' was not found in the message");
        return FALSE;
    }

    if (value_modem_storage_index)
        *value_modem_storage_index = self->arg_modem_storage_index;

    return TRUE;
}

gboolean
qmi_message_dms_set_firmware_preference_input_set_modem_storage_index (
    QmiMessageDmsSetFirmwarePreferenceInput *self,
    guint8 value_modem_storage_index,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_modem_storage_index = value_modem_storage_index;
    self->arg_modem_storage_index_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_dms_set_firmware_preference_input_get_download_override (
    QmiMessageDmsSetFirmwarePreferenceInput *self,
    gboolean *value_download_override,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_download_override_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Download Override' was not found in the message");
        return FALSE;
    }

    if (value_download_override)
        *value_download_override = (gboolean)(self->arg_download_override);

    return TRUE;
}

gboolean
qmi_message_dms_set_firmware_preference_input_set_download_override (
    QmiMessageDmsSetFirmwarePreferenceInput *self,
    gboolean value_download_override,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_download_override = (guint8)(value_download_override);
    self->arg_download_override_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_dms_set_firmware_preference_input_get_list (
    QmiMessageDmsSetFirmwarePreferenceInput *self,
    GArray **value_list,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_list_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'List' was not found in the message");
        return FALSE;
    }

    if (value_list)
        *value_list = self->arg_list;

    return TRUE;
}

gboolean
qmi_message_dms_set_firmware_preference_input_get_list_gir (
    QmiMessageDmsSetFirmwarePreferenceInput *self,
    GPtrArray **value_list_ptr,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_list_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'List' was not found in the message");
        return FALSE;
    }

    if (value_list_ptr) {
        if (!self->arg_list_ptr) {
            {
                guint list_i;

                self->arg_list_ptr = g_ptr_array_new_full (self->arg_list->len, (GDestroyNotify)__qmi_message_dms_set_firmware_preference_input_list_image_free);
                for (list_i = 0; list_i < self->arg_list->len; list_i++) {
                    QmiMessageDmsSetFirmwarePreferenceInputListImage *list_aux_from;
                    QmiMessageDmsSetFirmwarePreferenceInputListImage *list_aux_to;

                    list_aux_from = &g_array_index (self->arg_list, QmiMessageDmsSetFirmwarePreferenceInputListImage, list_i);

                    list_aux_to = __qmi_message_dms_set_firmware_preference_input_list_image_new ();
                    list_aux_to->type = (*list_aux_from).type;
                    list_aux_to->unique_id = g_array_ref ((*list_aux_from).unique_id);
                    list_aux_to->build_id = g_strdup ((*list_aux_from).build_id);

                    g_ptr_array_add (self->arg_list_ptr, list_aux_to);
                }
            }
        }
        *value_list_ptr = self->arg_list_ptr;
    }
    return TRUE;
}

gboolean
qmi_message_dms_set_firmware_preference_input_set_list (
    QmiMessageDmsSetFirmwarePreferenceInput *self,
    GArray *value_list,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    g_clear_pointer (&self->arg_list, (GDestroyNotify)g_array_unref);
    g_clear_pointer (&self->arg_list, (GDestroyNotify)g_ptr_array_unref);
    self->arg_list = g_array_ref (value_list);
    self->arg_list_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_dms_set_firmware_preference_input_set_list_gir (
    QmiMessageDmsSetFirmwarePreferenceInput *self,
    GPtrArray *value_list_ptr,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    g_clear_pointer (&self->arg_list, (GDestroyNotify)g_array_unref);
    g_clear_pointer (&self->arg_list_ptr, (GDestroyNotify)g_ptr_array_unref);
    {
        guint list_i;

        self->arg_list = g_array_sized_new (FALSE, FALSE, sizeof (QmiMessageDmsSetFirmwarePreferenceInputListImage), value_list_ptr->len);
        for (list_i = 0; list_i < value_list_ptr->len; list_i++) {
            QmiMessageDmsSetFirmwarePreferenceInputListImage list_aux_to;
            QmiMessageDmsSetFirmwarePreferenceInputListImage *list_aux_from;

            list_aux_from = g_ptr_array_index (value_list_ptr, list_i);

            list_aux_to.type = list_aux_from->type;
            list_aux_to.unique_id = g_array_ref (list_aux_from->unique_id);
            list_aux_to.build_id = g_strdup (list_aux_from->build_id);

            g_array_append_val (self->arg_list, list_aux_to);
        }
    }
    self->arg_list_set = TRUE;

    return TRUE;
}

GType
qmi_message_dms_set_firmware_preference_input_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsSetFirmwarePreferenceInput"),
                                          (GBoxedCopyFunc) qmi_message_dms_set_firmware_preference_input_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_set_firmware_preference_input_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsSetFirmwarePreferenceInput *
qmi_message_dms_set_firmware_preference_input_ref (QmiMessageDmsSetFirmwarePreferenceInput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_set_firmware_preference_input_unref (QmiMessageDmsSetFirmwarePreferenceInput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_list, (GDestroyNotify)g_array_unref);
        g_clear_pointer (&self->arg_list, (GDestroyNotify)g_ptr_array_unref);
        g_slice_free (QmiMessageDmsSetFirmwarePreferenceInput, self);
    }
}

QmiMessageDmsSetFirmwarePreferenceInput *
qmi_message_dms_set_firmware_preference_input_new (void)
{
    QmiMessageDmsSetFirmwarePreferenceInput *self;

    self = g_slice_new0 (QmiMessageDmsSetFirmwarePreferenceInput);
    self->ref_count = 1;
    return self;
}

static QmiMessage *
__qmi_message_dms_set_firmware_preference_request_create (
    guint16 transaction_id,
    guint8 cid,
    QmiMessageDmsSetFirmwarePreferenceInput *input,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_SET_FIRMWARE_PREFERENCE);

    /* There is at least one mandatory TLV, don't allow NULL input */
    if (!input) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Message 'Set Firmware Preference' has mandatory TLVs");
        return NULL;
    }

    /* Try to add the 'Modem Storage Index' TLV */
    if (input->arg_modem_storage_index_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_DMS_SET_FIRMWARE_PREFERENCE_INPUT_TLV_MODEM_STORAGE_INDEX, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Modem Storage Index': ");
            return NULL;
        }

        /* Write the guint8 variable to the buffer */
        if (!qmi_message_tlv_write_guint8 (self, input->arg_modem_storage_index, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'Modem Storage Index': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Modem Storage Index': ");
            return NULL;
        }
    }

    /* Try to add the 'Download Override' TLV */
    if (input->arg_download_override_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_DMS_SET_FIRMWARE_PREFERENCE_INPUT_TLV_DOWNLOAD_OVERRIDE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Download Override': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_download_override;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Download Override': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Download Override': ");
            return NULL;
        }
    }

    /* Try to add the 'List' TLV */
    if (input->arg_list_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_DMS_SET_FIRMWARE_PREFERENCE_INPUT_TLV_LIST, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'List': ");
            return NULL;
        }

        {
            guint list_i;
            guint8 list_n_items;

            /* Write the number of items in the array first */
            list_n_items = (guint8) input->arg_list->len;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, list_n_items, error)) {
                g_prefix_error (error, "Cannot write integer in TLV 'List': ");
                return NULL;
            }

            for (list_i = 0; list_i < input->arg_list->len; list_i++) {
                {
                    guint8 tmp;

                    tmp = (guint8) g_array_index (input->arg_list, QmiMessageDmsSetFirmwarePreferenceInputListImage,list_i).type;
                    /* Write the guint8 variable to the buffer */
                    if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                        g_prefix_error (error, "Cannot write enum in TLV 'List': ");
                        return NULL;
                    }
                }
                {
                    guint unique_id_i;

                    for (unique_id_i = 0; unique_id_i < g_array_index (input->arg_list, QmiMessageDmsSetFirmwarePreferenceInputListImage,list_i).unique_id->len; unique_id_i++) {
                        /* Write the guint8 variable to the buffer */
                        if (!qmi_message_tlv_write_guint8 (self, g_array_index (g_array_index (input->arg_list, QmiMessageDmsSetFirmwarePreferenceInputListImage,list_i).unique_id, guint8,unique_id_i), error)) {
                            g_prefix_error (error, "Cannot write integer in TLV 'List': ");
                            return NULL;
                        }
                    }
                }
                if (!qmi_message_tlv_write_string (self, 1, g_array_index (input->arg_list, QmiMessageDmsSetFirmwarePreferenceInputListImage,list_i).build_id, -1, error)) {
                    g_prefix_error (error, "Cannot write string in TLV 'List': ");
                    return NULL;
                }
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'List': ");
            return NULL;
        }
    } else {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Missing mandatory TLV 'List' in message 'Set Firmware Preference'");
        return NULL;
    }

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsSetFirmwarePreferenceOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* Image Download List */
    gboolean arg_image_download_list_set;
    GArray *arg_image_download_list;
};

#define QMI_MESSAGE_DMS_SET_FIRMWARE_PREFERENCE_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_DMS_SET_FIRMWARE_PREFERENCE_OUTPUT_TLV_IMAGE_DOWNLOAD_LIST 0x01

gboolean
qmi_message_dms_set_firmware_preference_output_get_result (
    QmiMessageDmsSetFirmwarePreferenceOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_dms_set_firmware_preference_output_get_image_download_list (
    QmiMessageDmsSetFirmwarePreferenceOutput *self,
    GArray **value_image_download_list,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_image_download_list_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Image Download List' was not found in the message");
        return FALSE;
    }

    if (value_image_download_list)
        *value_image_download_list = self->arg_image_download_list;

    return TRUE;
}

GType
qmi_message_dms_set_firmware_preference_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsSetFirmwarePreferenceOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_set_firmware_preference_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_set_firmware_preference_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsSetFirmwarePreferenceOutput *
qmi_message_dms_set_firmware_preference_output_ref (QmiMessageDmsSetFirmwarePreferenceOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_set_firmware_preference_output_unref (QmiMessageDmsSetFirmwarePreferenceOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_image_download_list, (GDestroyNotify)g_array_unref);
        g_slice_free (QmiMessageDmsSetFirmwarePreferenceOutput, self);
    }
}

static gchar *
qmi_message_dms_set_firmware_preference_input_modem_storage_index_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SET_FIRMWARE_PREFERENCE_INPUT_TLV_MODEM_STORAGE_INDEX, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_set_firmware_preference_input_download_override_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SET_FIRMWARE_PREFERENCE_INPUT_TLV_DOWNLOAD_OVERRIDE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_set_firmware_preference_input_list_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SET_FIRMWARE_PREFERENCE_INPUT_TLV_LIST, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    {
        guint list_i;
        guint8 list_n_items;

        /* Read number of items in the array */
        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(list_n_items), &error))
            goto out;

        g_string_append (printable, "{");

        for (list_i = 0; list_i < list_n_items; list_i++) {
            g_string_append_printf (printable, " [%u] = '", list_i);
            g_string_append (printable, "[");
            g_string_append (printable, " type = '");

            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
#if defined  __QMI_DMS_FIRMWARE_IMAGE_TYPE_IS_ENUM__
                    g_string_append_printf (printable, "%s", qmi_dms_firmware_image_type_get_string ((QmiDmsFirmwareImageType)tmp));
#elif defined  __QMI_DMS_FIRMWARE_IMAGE_TYPE_IS_FLAGS__
                    {
                        g_autofree gchar *flags_str = NULL;

                        flags_str = qmi_dms_firmware_image_type_build_string_from_mask ((QmiDmsFirmwareImageType)tmp);
                        g_string_append_printf (printable, "%s", flags_str);
                    }
#else
# error unexpected public format: QmiDmsFirmwareImageType
#endif
                }
            }
            g_string_append (printable, "'");
            g_string_append (printable, " unique_id = '");
            {
                guint unique_id_i;
                guint16 unique_id_n_items = 16;


                g_string_append (printable, "{");

                for (unique_id_i = 0; unique_id_i < unique_id_n_items; unique_id_i++) {
                    g_string_append_printf (printable, " [%u] = '", unique_id_i);

                    {
                        guint8 tmp;

                        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
                            goto out;
                        {
                            g_string_append_printf (printable, "%u", (guint)tmp);
                        }
                    }
                    g_string_append (printable, "'");
                }

                g_string_append (printable, "}");
            }            g_string_append (printable, "'");
            g_string_append (printable, " build_id = '");

            {
                g_autofree gchar *tmp = NULL;

                if (!qmi_message_tlv_read_string (message, init_offset, &offset, 1, 0, &tmp, &error))
                    goto out;
                {
                    g_string_append (printable, tmp);
                }
            }
            g_string_append (printable, "'");
            g_string_append (printable, " ]");
            g_string_append (printable, "'");
        }

        g_string_append (printable, "}");
    }
    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_set_firmware_preference_output_image_download_list_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SET_FIRMWARE_PREFERENCE_OUTPUT_TLV_IMAGE_DOWNLOAD_LIST, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    {
        guint image_download_list_i;
        guint8 image_download_list_n_items;

        /* Read number of items in the array */
        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(image_download_list_n_items), &error))
            goto out;

        g_string_append (printable, "{");

        for (image_download_list_i = 0; image_download_list_i < image_download_list_n_items; image_download_list_i++) {
            g_string_append_printf (printable, " [%u] = '", image_download_list_i);

            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
#if defined  __QMI_DMS_FIRMWARE_IMAGE_TYPE_IS_ENUM__
                    g_string_append_printf (printable, "%s", qmi_dms_firmware_image_type_get_string ((QmiDmsFirmwareImageType)tmp));
#elif defined  __QMI_DMS_FIRMWARE_IMAGE_TYPE_IS_FLAGS__
                    {
                        g_autofree gchar *flags_str = NULL;

                        flags_str = qmi_dms_firmware_image_type_build_string_from_mask ((QmiDmsFirmwareImageType)tmp);
                        g_string_append_printf (printable, "%s", flags_str);
                    }
#else
# error unexpected public format: QmiDmsFirmwareImageType
#endif
                }
            }
            g_string_append (printable, "'");
        }

        g_string_append (printable, "}");
    }
    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_set_firmware_preference_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_set_firmware_preference_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_set_firmware_preference_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        case QMI_MESSAGE_DMS_SET_FIRMWARE_PREFERENCE_INPUT_TLV_MODEM_STORAGE_INDEX:
            tlv_type_str = "Modem Storage Index";
            translated_value = qmi_message_dms_set_firmware_preference_input_modem_storage_index_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_SET_FIRMWARE_PREFERENCE_INPUT_TLV_DOWNLOAD_OVERRIDE:
            tlv_type_str = "Download Override";
            translated_value = qmi_message_dms_set_firmware_preference_input_download_override_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_SET_FIRMWARE_PREFERENCE_INPUT_TLV_LIST:
            tlv_type_str = "List";
            translated_value = qmi_message_dms_set_firmware_preference_input_list_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_SET_FIRMWARE_PREFERENCE_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_SET_FIRMWARE_PREFERENCE_OUTPUT_TLV_IMAGE_DOWNLOAD_LIST:
            tlv_type_str = "Image Download List";
            translated_value = qmi_message_dms_set_firmware_preference_output_image_download_list_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_set_firmware_preference_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Set Firmware Preference\" (0x0048)\n",
                            line_prefix);

    {
        struct message_set_firmware_preference_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_set_firmware_preference_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsSetFirmwarePreferenceOutput *
qmi_message_dms_set_firmware_preference_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsSetFirmwarePreferenceOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_SET_FIRMWARE_PREFERENCE);

    self = g_slice_new0 (QmiMessageDmsSetFirmwarePreferenceOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SET_FIRMWARE_PREFERENCE_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_set_firmware_preference_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_set_firmware_preference_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SET_FIRMWARE_PREFERENCE_OUTPUT_TLV_IMAGE_DOWNLOAD_LIST, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Image Download List TLV: ");
                qmi_message_dms_set_firmware_preference_output_unref (self);
                return NULL;
            }
            {
                guint image_download_list_i;
                guint8 image_download_list_n_items;

                /* Read number of items in the array */
                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(image_download_list_n_items), error))
                    goto qmi_message_dms_set_firmware_preference_output_image_download_list_out;

                self->arg_image_download_list = g_array_sized_new (
                    FALSE,
                    FALSE,
                    sizeof (QmiDmsFirmwareImageType),
                    (guint)image_download_list_n_items);

                for (image_download_list_i = 0; image_download_list_i < image_download_list_n_items; image_download_list_i++) {
                    QmiDmsFirmwareImageType image_download_list_aux;

                    {
                        guint8 tmp;

                        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, error))
                            goto qmi_message_dms_set_firmware_preference_output_image_download_list_out;
                        image_download_list_aux = (QmiDmsFirmwareImageType)tmp;
                    }
                    g_array_insert_val (self->arg_image_download_list, image_download_list_i, image_download_list_aux);
                }
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Image Download List' TLV", offset);
            }

            self->arg_image_download_list_set = TRUE;

qmi_message_dms_set_firmware_preference_output_image_download_list_out:
            if (!self->arg_image_download_list_set) {
                qmi_message_dms_set_firmware_preference_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS List Stored Images */


/* --- Input -- */

/* Note: no fields in the Input container */

static QmiMessage *
__qmi_message_dms_list_stored_images_request_create (
    guint16 transaction_id,
    guint8 cid,
    gpointer unused,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_LIST_STORED_IMAGES);

    return g_steal_pointer (&self);
}

/* --- Output -- */

static void
__qmi_message_dms_list_stored_images_output_list_image_sublist_sublist_element_clear (QmiMessageDmsListStoredImagesOutputListImageSublistSublistElement *value)
{
    g_clear_pointer (&value->unique_id, (GDestroyNotify)g_array_unref);
    g_clear_pointer (&value->build_id, (GDestroyNotify)g_free);
}

static void
__qmi_message_dms_list_stored_images_output_list_image_clear (QmiMessageDmsListStoredImagesOutputListImage *value)
{
    g_clear_pointer (&value->sublist, (GDestroyNotify)g_array_unref);
}

static void
__qmi_message_dms_list_stored_images_output_list_image_sublist_sublist_element_free (QmiMessageDmsListStoredImagesOutputListImageSublistSublistElement *value)
{
    __qmi_message_dms_list_stored_images_output_list_image_sublist_sublist_element_clear (value);
    g_slice_free (QmiMessageDmsListStoredImagesOutputListImageSublistSublistElement, value);
}

static QmiMessageDmsListStoredImagesOutputListImageSublistSublistElement *
__qmi_message_dms_list_stored_images_output_list_image_sublist_sublist_element_new (void)
{
    return g_slice_new0 (QmiMessageDmsListStoredImagesOutputListImageSublistSublistElement);
}

static QmiMessageDmsListStoredImagesOutputListImageSublistSublistElement *
__qmi_message_dms_list_stored_images_output_list_image_sublist_sublist_element_copy (const QmiMessageDmsListStoredImagesOutputListImageSublistSublistElement *value)
{
    QmiMessageDmsListStoredImagesOutputListImageSublistSublistElement *copy;

    copy = __qmi_message_dms_list_stored_images_output_list_image_sublist_sublist_element_new ();
    copy->storage_index = value->storage_index;
    copy->failure_count = value->failure_count;
    copy->unique_id = g_array_ref (value->unique_id);
    copy->build_id = g_strdup (value->build_id);
    return copy;
}

G_DEFINE_BOXED_TYPE (QmiMessageDmsListStoredImagesOutputListImageSublistSublistElement, qmi_message_dms_list_stored_images_output_list_image_sublist_sublist_element, (GBoxedCopyFunc)__qmi_message_dms_list_stored_images_output_list_image_sublist_sublist_element_copy, (GBoxedFreeFunc)__qmi_message_dms_list_stored_images_output_list_image_sublist_sublist_element_free)

static void
__qmi_message_dms_list_stored_images_output_list_image_gir_free (QmiMessageDmsListStoredImagesOutputListImageGir *value)
{
    g_clear_pointer (&value->sublist, (GDestroyNotify)g_ptr_array_unref);
    g_slice_free (QmiMessageDmsListStoredImagesOutputListImageGir, value);
}

static QmiMessageDmsListStoredImagesOutputListImageGir *
__qmi_message_dms_list_stored_images_output_list_image_gir_new (void)
{
    return g_slice_new0 (QmiMessageDmsListStoredImagesOutputListImageGir);
}

static QmiMessageDmsListStoredImagesOutputListImageGir *
__qmi_message_dms_list_stored_images_output_list_image_gir_copy (const QmiMessageDmsListStoredImagesOutputListImageGir *value)
{
    QmiMessageDmsListStoredImagesOutputListImageGir *copy;

    copy = __qmi_message_dms_list_stored_images_output_list_image_gir_new ();
    copy->type = value->type;
    copy->maximum_images = value->maximum_images;
    copy->index_of_running_image = value->index_of_running_image;
    copy->sublist = g_ptr_array_ref (value->sublist);
    return copy;
}

G_DEFINE_BOXED_TYPE (QmiMessageDmsListStoredImagesOutputListImageGir, qmi_message_dms_list_stored_images_output_list_image_gir, (GBoxedCopyFunc)__qmi_message_dms_list_stored_images_output_list_image_gir_copy, (GBoxedFreeFunc)__qmi_message_dms_list_stored_images_output_list_image_gir_free)

struct _QmiMessageDmsListStoredImagesOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* List */
    gboolean arg_list_set;
    GArray *arg_list;
    GPtrArray *arg_list_ptr;
};

#define QMI_MESSAGE_DMS_LIST_STORED_IMAGES_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_DMS_LIST_STORED_IMAGES_OUTPUT_TLV_LIST 0x01

gboolean
qmi_message_dms_list_stored_images_output_get_result (
    QmiMessageDmsListStoredImagesOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_dms_list_stored_images_output_get_list (
    QmiMessageDmsListStoredImagesOutput *self,
    GArray **value_list,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_list_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'List' was not found in the message");
        return FALSE;
    }

    if (value_list)
        *value_list = self->arg_list;

    return TRUE;
}

gboolean
qmi_message_dms_list_stored_images_output_get_list_gir (
    QmiMessageDmsListStoredImagesOutput *self,
    GPtrArray **value_list_ptr,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_list_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'List' was not found in the message");
        return FALSE;
    }

    if (value_list_ptr) {
        if (!self->arg_list_ptr) {
            {
                guint list_i;

                self->arg_list_ptr = g_ptr_array_new_full (self->arg_list->len, (GDestroyNotify)__qmi_message_dms_list_stored_images_output_list_image_gir_free);
                for (list_i = 0; list_i < self->arg_list->len; list_i++) {
                    QmiMessageDmsListStoredImagesOutputListImage *list_aux_from;
                    QmiMessageDmsListStoredImagesOutputListImageGir *list_aux_to;

                    list_aux_from = &g_array_index (self->arg_list, QmiMessageDmsListStoredImagesOutputListImage, list_i);

                    list_aux_to = __qmi_message_dms_list_stored_images_output_list_image_gir_new ();
                    list_aux_to->type = (*list_aux_from).type;
                    list_aux_to->maximum_images = (*list_aux_from).maximum_images;
                    list_aux_to->index_of_running_image = (*list_aux_from).index_of_running_image;
                    {
                        guint sublist_i;

                        list_aux_to->sublist = g_ptr_array_new_full ((*list_aux_from).sublist->len, (GDestroyNotify)__qmi_message_dms_list_stored_images_output_list_image_sublist_sublist_element_free);
                        for (sublist_i = 0; sublist_i < (*list_aux_from).sublist->len; sublist_i++) {
                            QmiMessageDmsListStoredImagesOutputListImageSublistSublistElement *sublist_aux_from;
                            QmiMessageDmsListStoredImagesOutputListImageSublistSublistElement *sublist_aux_to;

                            sublist_aux_from = &g_array_index ((*list_aux_from).sublist, QmiMessageDmsListStoredImagesOutputListImageSublistSublistElement, sublist_i);

                            sublist_aux_to = __qmi_message_dms_list_stored_images_output_list_image_sublist_sublist_element_new ();
                            sublist_aux_to->storage_index = (*sublist_aux_from).storage_index;
                            sublist_aux_to->failure_count = (*sublist_aux_from).failure_count;
                            sublist_aux_to->unique_id = g_array_ref ((*sublist_aux_from).unique_id);
                            sublist_aux_to->build_id = g_strdup ((*sublist_aux_from).build_id);

                            g_ptr_array_add (list_aux_to->sublist, sublist_aux_to);
                        }
                    }

                    g_ptr_array_add (self->arg_list_ptr, list_aux_to);
                }
            }
        }
        *value_list_ptr = self->arg_list_ptr;
    }
    return TRUE;
}

GType
qmi_message_dms_list_stored_images_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsListStoredImagesOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_list_stored_images_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_list_stored_images_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsListStoredImagesOutput *
qmi_message_dms_list_stored_images_output_ref (QmiMessageDmsListStoredImagesOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_list_stored_images_output_unref (QmiMessageDmsListStoredImagesOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_list, (GDestroyNotify)g_array_unref);
        g_clear_pointer (&self->arg_list, (GDestroyNotify)g_ptr_array_unref);
        g_slice_free (QmiMessageDmsListStoredImagesOutput, self);
    }
}

static gchar *
qmi_message_dms_list_stored_images_output_list_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_LIST_STORED_IMAGES_OUTPUT_TLV_LIST, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    {
        guint list_i;
        guint8 list_n_items;

        /* Read number of items in the array */
        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(list_n_items), &error))
            goto out;

        g_string_append (printable, "{");

        for (list_i = 0; list_i < list_n_items; list_i++) {
            g_string_append_printf (printable, " [%u] = '", list_i);
            g_string_append (printable, "[");
            g_string_append (printable, " type = '");

            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
#if defined  __QMI_DMS_FIRMWARE_IMAGE_TYPE_IS_ENUM__
                    g_string_append_printf (printable, "%s", qmi_dms_firmware_image_type_get_string ((QmiDmsFirmwareImageType)tmp));
#elif defined  __QMI_DMS_FIRMWARE_IMAGE_TYPE_IS_FLAGS__
                    {
                        g_autofree gchar *flags_str = NULL;

                        flags_str = qmi_dms_firmware_image_type_build_string_from_mask ((QmiDmsFirmwareImageType)tmp);
                        g_string_append_printf (printable, "%s", flags_str);
                    }
#else
# error unexpected public format: QmiDmsFirmwareImageType
#endif
                }
            }
            g_string_append (printable, "'");
            g_string_append (printable, " maximum_images = '");

            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
                    g_string_append_printf (printable, "%u", (guint)tmp);
                }
            }
            g_string_append (printable, "'");
            g_string_append (printable, " index_of_running_image = '");

            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
                    g_string_append_printf (printable, "%u", (guint)tmp);
                }
            }
            g_string_append (printable, "'");
            g_string_append (printable, " sublist = '");
            {
                guint sublist_i;
                guint8 sublist_n_items;

                /* Read number of items in the array */
                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(sublist_n_items), &error))
                    goto out;

                g_string_append (printable, "{");

                for (sublist_i = 0; sublist_i < sublist_n_items; sublist_i++) {
                    g_string_append_printf (printable, " [%u] = '", sublist_i);
                    g_string_append (printable, "[");
                    g_string_append (printable, " storage_index = '");

                    {
                        guint8 tmp;

                        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
                            goto out;
                        {
                            g_string_append_printf (printable, "%u", (guint)tmp);
                        }
                    }
                    g_string_append (printable, "'");
                    g_string_append (printable, " failure_count = '");

                    {
                        guint8 tmp;

                        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
                            goto out;
                        {
                            g_string_append_printf (printable, "%u", (guint)tmp);
                        }
                    }
                    g_string_append (printable, "'");
                    g_string_append (printable, " unique_id = '");
                    {
                        guint unique_id_i;
                        guint16 unique_id_n_items = 16;


                        g_string_append (printable, "{");

                        for (unique_id_i = 0; unique_id_i < unique_id_n_items; unique_id_i++) {
                            g_string_append_printf (printable, " [%u] = '", unique_id_i);

                            {
                                guint8 tmp;

                                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
                                    goto out;
                                {
                                    g_string_append_printf (printable, "%u", (guint)tmp);
                                }
                            }
                            g_string_append (printable, "'");
                        }

                        g_string_append (printable, "}");
                    }                    g_string_append (printable, "'");
                    g_string_append (printable, " build_id = '");

                    {
                        g_autofree gchar *tmp = NULL;

                        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 1, 0, &tmp, &error))
                            goto out;
                        {
                            g_string_append (printable, tmp);
                        }
                    }
                    g_string_append (printable, "'");
                    g_string_append (printable, " ]");
                    g_string_append (printable, "'");
                }

                g_string_append (printable, "}");
            }            g_string_append (printable, "'");
            g_string_append (printable, " ]");
            g_string_append (printable, "'");
        }

        g_string_append (printable, "}");
    }
    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_list_stored_images_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_list_stored_images_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_list_stored_images_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_LIST_STORED_IMAGES_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_LIST_STORED_IMAGES_OUTPUT_TLV_LIST:
            tlv_type_str = "List";
            translated_value = qmi_message_dms_list_stored_images_output_list_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_list_stored_images_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"List Stored Images\" (0x0049)\n",
                            line_prefix);

    {
        struct message_list_stored_images_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_list_stored_images_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsListStoredImagesOutput *
qmi_message_dms_list_stored_images_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsListStoredImagesOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_LIST_STORED_IMAGES);

    self = g_slice_new0 (QmiMessageDmsListStoredImagesOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_LIST_STORED_IMAGES_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_list_stored_images_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_list_stored_images_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_LIST_STORED_IMAGES_OUTPUT_TLV_LIST, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory List TLV: ");
                qmi_message_dms_list_stored_images_output_unref (self);
                return NULL;
            }
            {
                guint list_i;
                guint8 list_n_items;

                /* Read number of items in the array */
                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(list_n_items), error))
                    goto qmi_message_dms_list_stored_images_output_list_out;

                self->arg_list = g_array_sized_new (
                    FALSE,
                    FALSE,
                    sizeof (QmiMessageDmsListStoredImagesOutputListImage),
                    (guint)list_n_items);

                g_array_set_clear_func (self->arg_list, (GDestroyNotify)__qmi_message_dms_list_stored_images_output_list_image_clear);

                for (list_i = 0; list_i < list_n_items; list_i++) {
                    QmiMessageDmsListStoredImagesOutputListImage list_aux;

                    {
                        guint8 tmp;

                        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, error))
                            goto qmi_message_dms_list_stored_images_output_list_out;
                        list_aux.type = (QmiDmsFirmwareImageType)tmp;
                    }
                    if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(list_aux.maximum_images), error))
                        goto qmi_message_dms_list_stored_images_output_list_out;
                    if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(list_aux.index_of_running_image), error))
                        goto qmi_message_dms_list_stored_images_output_list_out;
                    {
                        guint sublist_i;
                        guint8 sublist_n_items;

                        /* Read number of items in the array */
                        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(sublist_n_items), error))
                            goto qmi_message_dms_list_stored_images_output_list_out;

                        list_aux.sublist = g_array_sized_new (
                            FALSE,
                            FALSE,
                            sizeof (QmiMessageDmsListStoredImagesOutputListImageSublistSublistElement),
                            (guint)sublist_n_items);

                        g_array_set_clear_func (list_aux.sublist, (GDestroyNotify)__qmi_message_dms_list_stored_images_output_list_image_sublist_sublist_element_clear);

                        for (sublist_i = 0; sublist_i < sublist_n_items; sublist_i++) {
                            QmiMessageDmsListStoredImagesOutputListImageSublistSublistElement sublist_aux;

                            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(sublist_aux.storage_index), error))
                                goto qmi_message_dms_list_stored_images_output_list_out;
                            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(sublist_aux.failure_count), error))
                                goto qmi_message_dms_list_stored_images_output_list_out;
                            {
                                guint unique_id_i;
                                guint16 unique_id_n_items = 16;


                                sublist_aux.unique_id = g_array_sized_new (
                                    FALSE,
                                    FALSE,
                                    sizeof (guint8),
                                    (guint)unique_id_n_items);

                                for (unique_id_i = 0; unique_id_i < unique_id_n_items; unique_id_i++) {
                                    guint8 unique_id_aux;

                                    if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(unique_id_aux), error))
                                        goto qmi_message_dms_list_stored_images_output_list_out;
                                    g_array_insert_val (sublist_aux.unique_id, unique_id_i, unique_id_aux);
                                }
                            }
                            if (!qmi_message_tlv_read_string (message, init_offset, &offset, 1, 0, &(sublist_aux.build_id), error))
                                goto qmi_message_dms_list_stored_images_output_list_out;
                            g_array_insert_val (list_aux.sublist, sublist_i, sublist_aux);
                        }
                    }
                    g_array_insert_val (self->arg_list, list_i, list_aux);
                }
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'List' TLV", offset);
            }

            self->arg_list_set = TRUE;

qmi_message_dms_list_stored_images_output_list_out:
            if (!self->arg_list_set) {
                qmi_message_dms_list_stored_images_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS Delete Stored Image */


/* --- Input -- */

struct _QmiMessageDmsDeleteStoredImageInput {
    volatile gint ref_count;

    /* Image Details */
    gboolean arg_image_details_set;
    guint8 arg_image_details_type;
    GArray *arg_image_details_unique_id;
    gchar *arg_image_details_build_id;
};

#define QMI_MESSAGE_DMS_DELETE_STORED_IMAGE_INPUT_TLV_IMAGE_DETAILS 0x01

gboolean
qmi_message_dms_delete_stored_image_input_get_image_details (
    QmiMessageDmsDeleteStoredImageInput *self,
    QmiDmsFirmwareImageType *value_image_details_type,
    GArray **value_image_details_unique_id,
    const gchar **value_image_details_build_id,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_image_details_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Image Details' was not found in the message");
        return FALSE;
    }

    if (value_image_details_type)
        *value_image_details_type = (QmiDmsFirmwareImageType)(self->arg_image_details_type);
    if (value_image_details_unique_id)
        *value_image_details_unique_id = self->arg_image_details_unique_id;
    if (value_image_details_build_id)
        *value_image_details_build_id = self->arg_image_details_build_id;

    return TRUE;
}

gboolean
qmi_message_dms_delete_stored_image_input_set_image_details (
    QmiMessageDmsDeleteStoredImageInput *self,
    QmiDmsFirmwareImageType value_image_details_type,
    GArray *value_image_details_unique_id,
    const gchar *value_image_details_build_id,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_image_details_type = (guint8)(value_image_details_type);
    g_clear_pointer (&self->arg_image_details_unique_id, (GDestroyNotify)g_array_unref);
    g_clear_pointer (&self->arg_image_details_unique_id, (GDestroyNotify)g_ptr_array_unref);
    self->arg_image_details_unique_id = g_array_ref (value_image_details_unique_id);
    g_free (self->arg_image_details_build_id);
    self->arg_image_details_build_id = g_strdup (value_image_details_build_id ? value_image_details_build_id : "");
    self->arg_image_details_set = TRUE;

    return TRUE;
}

GType
qmi_message_dms_delete_stored_image_input_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsDeleteStoredImageInput"),
                                          (GBoxedCopyFunc) qmi_message_dms_delete_stored_image_input_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_delete_stored_image_input_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsDeleteStoredImageInput *
qmi_message_dms_delete_stored_image_input_ref (QmiMessageDmsDeleteStoredImageInput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_delete_stored_image_input_unref (QmiMessageDmsDeleteStoredImageInput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_image_details_unique_id, (GDestroyNotify)g_array_unref);
        g_clear_pointer (&self->arg_image_details_build_id, (GDestroyNotify)g_free);
        g_slice_free (QmiMessageDmsDeleteStoredImageInput, self);
    }
}

QmiMessageDmsDeleteStoredImageInput *
qmi_message_dms_delete_stored_image_input_new (void)
{
    QmiMessageDmsDeleteStoredImageInput *self;

    self = g_slice_new0 (QmiMessageDmsDeleteStoredImageInput);
    self->ref_count = 1;
    return self;
}

static QmiMessage *
__qmi_message_dms_delete_stored_image_request_create (
    guint16 transaction_id,
    guint8 cid,
    QmiMessageDmsDeleteStoredImageInput *input,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_DELETE_STORED_IMAGE);

    /* There is at least one mandatory TLV, don't allow NULL input */
    if (!input) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Message 'Delete Stored Image' has mandatory TLVs");
        return NULL;
    }

    /* Try to add the 'Image Details' TLV */
    if (input->arg_image_details_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_DMS_DELETE_STORED_IMAGE_INPUT_TLV_IMAGE_DETAILS, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Image Details': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_image_details_type;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Image Details': ");
                return NULL;
            }
        }
        {
            guint unique_id_i;

            for (unique_id_i = 0; unique_id_i < input->arg_image_details_unique_id->len; unique_id_i++) {
                /* Write the guint8 variable to the buffer */
                if (!qmi_message_tlv_write_guint8 (self, g_array_index (input->arg_image_details_unique_id, guint8,unique_id_i), error)) {
                    g_prefix_error (error, "Cannot write integer in TLV 'Image Details': ");
                    return NULL;
                }
            }
        }
        if (!qmi_message_tlv_write_string (self, 1, input->arg_image_details_build_id, -1, error)) {
            g_prefix_error (error, "Cannot write string in TLV 'Image Details': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Image Details': ");
            return NULL;
        }
    } else {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Missing mandatory TLV 'Image Details' in message 'Delete Stored Image'");
        return NULL;
    }

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsDeleteStoredImageOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;
};

#define QMI_MESSAGE_DMS_DELETE_STORED_IMAGE_OUTPUT_TLV_RESULT 0x02

gboolean
qmi_message_dms_delete_stored_image_output_get_result (
    QmiMessageDmsDeleteStoredImageOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

GType
qmi_message_dms_delete_stored_image_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsDeleteStoredImageOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_delete_stored_image_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_delete_stored_image_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsDeleteStoredImageOutput *
qmi_message_dms_delete_stored_image_output_ref (QmiMessageDmsDeleteStoredImageOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_delete_stored_image_output_unref (QmiMessageDmsDeleteStoredImageOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsDeleteStoredImageOutput, self);
    }
}

static gchar *
qmi_message_dms_delete_stored_image_input_image_details_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_DELETE_STORED_IMAGE_INPUT_TLV_IMAGE_DETAILS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " type = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_DMS_FIRMWARE_IMAGE_TYPE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_dms_firmware_image_type_get_string ((QmiDmsFirmwareImageType)tmp));
#elif defined  __QMI_DMS_FIRMWARE_IMAGE_TYPE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_dms_firmware_image_type_build_string_from_mask ((QmiDmsFirmwareImageType)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiDmsFirmwareImageType
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " unique_id = '");
    {
        guint unique_id_i;
        guint16 unique_id_n_items = 16;


        g_string_append (printable, "{");

        for (unique_id_i = 0; unique_id_i < unique_id_n_items; unique_id_i++) {
            g_string_append_printf (printable, " [%u] = '", unique_id_i);

            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
                    g_string_append_printf (printable, "%u", (guint)tmp);
                }
            }
            g_string_append (printable, "'");
        }

        g_string_append (printable, "}");
    }    g_string_append (printable, "'");
    g_string_append (printable, " build_id = '");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 1, 0, &tmp, &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_delete_stored_image_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_delete_stored_image_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_delete_stored_image_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        case QMI_MESSAGE_DMS_DELETE_STORED_IMAGE_INPUT_TLV_IMAGE_DETAILS:
            tlv_type_str = "Image Details";
            translated_value = qmi_message_dms_delete_stored_image_input_image_details_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_DELETE_STORED_IMAGE_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_delete_stored_image_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Delete Stored Image\" (0x004A)\n",
                            line_prefix);

    {
        struct message_delete_stored_image_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_delete_stored_image_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsDeleteStoredImageOutput *
qmi_message_dms_delete_stored_image_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsDeleteStoredImageOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_DELETE_STORED_IMAGE);

    self = g_slice_new0 (QmiMessageDmsDeleteStoredImageOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_DELETE_STORED_IMAGE_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_delete_stored_image_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_delete_stored_image_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS Set Time */


/* --- Input -- */

struct _QmiMessageDmsSetTimeInput {
    volatile gint ref_count;

    /* Time Reference Type */
    gboolean arg_time_reference_type_set;
    guint32 arg_time_reference_type;

    /* Time Value */
    gboolean arg_time_value_set;
    guint64 arg_time_value;
};

#define QMI_MESSAGE_DMS_SET_TIME_INPUT_TLV_TIME_REFERENCE_TYPE 0x10
#define QMI_MESSAGE_DMS_SET_TIME_INPUT_TLV_TIME_VALUE 0x01

gboolean
qmi_message_dms_set_time_input_get_time_reference_type (
    QmiMessageDmsSetTimeInput *self,
    QmiDmsTimeReferenceType *value_time_reference_type,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_time_reference_type_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Time Reference Type' was not found in the message");
        return FALSE;
    }

    if (value_time_reference_type)
        *value_time_reference_type = (QmiDmsTimeReferenceType)(self->arg_time_reference_type);

    return TRUE;
}

gboolean
qmi_message_dms_set_time_input_set_time_reference_type (
    QmiMessageDmsSetTimeInput *self,
    QmiDmsTimeReferenceType value_time_reference_type,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_time_reference_type = (guint32)(value_time_reference_type);
    self->arg_time_reference_type_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_dms_set_time_input_get_time_value (
    QmiMessageDmsSetTimeInput *self,
    guint64 *value_time_value,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_time_value_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Time Value' was not found in the message");
        return FALSE;
    }

    if (value_time_value)
        *value_time_value = self->arg_time_value;

    return TRUE;
}

gboolean
qmi_message_dms_set_time_input_set_time_value (
    QmiMessageDmsSetTimeInput *self,
    guint64 value_time_value,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_time_value = value_time_value;
    self->arg_time_value_set = TRUE;

    return TRUE;
}

GType
qmi_message_dms_set_time_input_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsSetTimeInput"),
                                          (GBoxedCopyFunc) qmi_message_dms_set_time_input_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_set_time_input_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsSetTimeInput *
qmi_message_dms_set_time_input_ref (QmiMessageDmsSetTimeInput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_set_time_input_unref (QmiMessageDmsSetTimeInput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsSetTimeInput, self);
    }
}

QmiMessageDmsSetTimeInput *
qmi_message_dms_set_time_input_new (void)
{
    QmiMessageDmsSetTimeInput *self;

    self = g_slice_new0 (QmiMessageDmsSetTimeInput);
    self->ref_count = 1;
    return self;
}

static QmiMessage *
__qmi_message_dms_set_time_request_create (
    guint16 transaction_id,
    guint8 cid,
    QmiMessageDmsSetTimeInput *input,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_SET_TIME);

    /* There is at least one mandatory TLV, don't allow NULL input */
    if (!input) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Message 'Set Time' has mandatory TLVs");
        return NULL;
    }

    /* Try to add the 'Time Reference Type' TLV */
    if (input->arg_time_reference_type_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_DMS_SET_TIME_INPUT_TLV_TIME_REFERENCE_TYPE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Time Reference Type': ");
            return NULL;
        }

        {
            guint32 tmp;

            tmp = (guint32) input->arg_time_reference_type;
            /* Write the guint32 variable to the buffer */
            if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Time Reference Type': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Time Reference Type': ");
            return NULL;
        }
    } else {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Missing mandatory TLV 'Time Reference Type' in message 'Set Time'");
        return NULL;
    }

    /* Try to add the 'Time Value' TLV */
    if (input->arg_time_value_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_DMS_SET_TIME_INPUT_TLV_TIME_VALUE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Time Value': ");
            return NULL;
        }

        /* Write the guint64 variable to the buffer */
        if (!qmi_message_tlv_write_guint64 (self, QMI_ENDIAN_LITTLE, input->arg_time_value, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'Time Value': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Time Value': ");
            return NULL;
        }
    } else {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Missing mandatory TLV 'Time Value' in message 'Set Time'");
        return NULL;
    }

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsSetTimeOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;
};

#define QMI_MESSAGE_DMS_SET_TIME_OUTPUT_TLV_RESULT 0x02

gboolean
qmi_message_dms_set_time_output_get_result (
    QmiMessageDmsSetTimeOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

GType
qmi_message_dms_set_time_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsSetTimeOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_set_time_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_set_time_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsSetTimeOutput *
qmi_message_dms_set_time_output_ref (QmiMessageDmsSetTimeOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_set_time_output_unref (QmiMessageDmsSetTimeOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsSetTimeOutput, self);
    }
}

static gchar *
qmi_message_dms_set_time_input_time_reference_type_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SET_TIME_INPUT_TLV_TIME_REFERENCE_TYPE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
#if defined  __QMI_DMS_TIME_REFERENCE_TYPE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_dms_time_reference_type_get_string ((QmiDmsTimeReferenceType)tmp));
#elif defined  __QMI_DMS_TIME_REFERENCE_TYPE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_dms_time_reference_type_build_string_from_mask ((QmiDmsTimeReferenceType)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiDmsTimeReferenceType
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_set_time_input_time_value_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SET_TIME_INPUT_TLV_TIME_VALUE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint64 tmp;

        if (!qmi_message_tlv_read_guint64 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT64_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_set_time_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_set_time_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_set_time_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        case QMI_MESSAGE_DMS_SET_TIME_INPUT_TLV_TIME_REFERENCE_TYPE:
            tlv_type_str = "Time Reference Type";
            translated_value = qmi_message_dms_set_time_input_time_reference_type_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_SET_TIME_INPUT_TLV_TIME_VALUE:
            tlv_type_str = "Time Value";
            translated_value = qmi_message_dms_set_time_input_time_value_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_SET_TIME_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_set_time_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Set Time\" (0x004B)\n",
                            line_prefix);

    {
        struct message_set_time_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_set_time_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsSetTimeOutput *
qmi_message_dms_set_time_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsSetTimeOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_SET_TIME);

    self = g_slice_new0 (QmiMessageDmsSetTimeOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SET_TIME_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_set_time_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_set_time_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS Get Stored Image Info */


/* --- Input -- */

struct _QmiMessageDmsGetStoredImageInfoInput {
    volatile gint ref_count;

    /* Image Details */
    gboolean arg_image_details_set;
    guint8 arg_image_details_type;
    GArray *arg_image_details_unique_id;
    gchar *arg_image_details_build_id;
};

#define QMI_MESSAGE_DMS_GET_STORED_IMAGE_INFO_INPUT_TLV_IMAGE_DETAILS 0x01

gboolean
qmi_message_dms_get_stored_image_info_input_get_image_details (
    QmiMessageDmsGetStoredImageInfoInput *self,
    QmiDmsFirmwareImageType *value_image_details_type,
    GArray **value_image_details_unique_id,
    const gchar **value_image_details_build_id,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_image_details_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Image Details' was not found in the message");
        return FALSE;
    }

    if (value_image_details_type)
        *value_image_details_type = (QmiDmsFirmwareImageType)(self->arg_image_details_type);
    if (value_image_details_unique_id)
        *value_image_details_unique_id = self->arg_image_details_unique_id;
    if (value_image_details_build_id)
        *value_image_details_build_id = self->arg_image_details_build_id;

    return TRUE;
}

gboolean
qmi_message_dms_get_stored_image_info_input_set_image_details (
    QmiMessageDmsGetStoredImageInfoInput *self,
    QmiDmsFirmwareImageType value_image_details_type,
    GArray *value_image_details_unique_id,
    const gchar *value_image_details_build_id,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_image_details_type = (guint8)(value_image_details_type);
    g_clear_pointer (&self->arg_image_details_unique_id, (GDestroyNotify)g_array_unref);
    g_clear_pointer (&self->arg_image_details_unique_id, (GDestroyNotify)g_ptr_array_unref);
    self->arg_image_details_unique_id = g_array_ref (value_image_details_unique_id);
    g_free (self->arg_image_details_build_id);
    self->arg_image_details_build_id = g_strdup (value_image_details_build_id ? value_image_details_build_id : "");
    self->arg_image_details_set = TRUE;

    return TRUE;
}

GType
qmi_message_dms_get_stored_image_info_input_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsGetStoredImageInfoInput"),
                                          (GBoxedCopyFunc) qmi_message_dms_get_stored_image_info_input_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_get_stored_image_info_input_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsGetStoredImageInfoInput *
qmi_message_dms_get_stored_image_info_input_ref (QmiMessageDmsGetStoredImageInfoInput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_get_stored_image_info_input_unref (QmiMessageDmsGetStoredImageInfoInput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_image_details_unique_id, (GDestroyNotify)g_array_unref);
        g_clear_pointer (&self->arg_image_details_build_id, (GDestroyNotify)g_free);
        g_slice_free (QmiMessageDmsGetStoredImageInfoInput, self);
    }
}

QmiMessageDmsGetStoredImageInfoInput *
qmi_message_dms_get_stored_image_info_input_new (void)
{
    QmiMessageDmsGetStoredImageInfoInput *self;

    self = g_slice_new0 (QmiMessageDmsGetStoredImageInfoInput);
    self->ref_count = 1;
    return self;
}

static QmiMessage *
__qmi_message_dms_get_stored_image_info_request_create (
    guint16 transaction_id,
    guint8 cid,
    QmiMessageDmsGetStoredImageInfoInput *input,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_GET_STORED_IMAGE_INFO);

    /* There is at least one mandatory TLV, don't allow NULL input */
    if (!input) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Message 'Get Stored Image Info' has mandatory TLVs");
        return NULL;
    }

    /* Try to add the 'Image Details' TLV */
    if (input->arg_image_details_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_DMS_GET_STORED_IMAGE_INFO_INPUT_TLV_IMAGE_DETAILS, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Image Details': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_image_details_type;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Image Details': ");
                return NULL;
            }
        }
        {
            guint unique_id_i;

            for (unique_id_i = 0; unique_id_i < input->arg_image_details_unique_id->len; unique_id_i++) {
                /* Write the guint8 variable to the buffer */
                if (!qmi_message_tlv_write_guint8 (self, g_array_index (input->arg_image_details_unique_id, guint8,unique_id_i), error)) {
                    g_prefix_error (error, "Cannot write integer in TLV 'Image Details': ");
                    return NULL;
                }
            }
        }
        if (!qmi_message_tlv_write_string (self, 1, input->arg_image_details_build_id, -1, error)) {
            g_prefix_error (error, "Cannot write string in TLV 'Image Details': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Image Details': ");
            return NULL;
        }
    } else {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Missing mandatory TLV 'Image Details' in message 'Get Stored Image Info'");
        return NULL;
    }

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsGetStoredImageInfoOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* Boot Version */
    gboolean arg_boot_version_set;
    guint16 arg_boot_version_major_version;
    guint16 arg_boot_version_minor_version;

    /* PRI Version */
    gboolean arg_pri_version_set;
    guint32 arg_pri_version_pri_version;
    gchar arg_pri_version_pri_info[33];

    /* OEM Lock ID */
    gboolean arg_oem_lock_id_set;
    guint32 arg_oem_lock_id;
};

#define QMI_MESSAGE_DMS_GET_STORED_IMAGE_INFO_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_DMS_GET_STORED_IMAGE_INFO_OUTPUT_TLV_BOOT_VERSION 0x10
#define QMI_MESSAGE_DMS_GET_STORED_IMAGE_INFO_OUTPUT_TLV_PRI_VERSION 0x11
#define QMI_MESSAGE_DMS_GET_STORED_IMAGE_INFO_OUTPUT_TLV_OEM_LOCK_ID 0x12

gboolean
qmi_message_dms_get_stored_image_info_output_get_result (
    QmiMessageDmsGetStoredImageInfoOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_dms_get_stored_image_info_output_get_boot_version (
    QmiMessageDmsGetStoredImageInfoOutput *self,
    guint16 *value_boot_version_major_version,
    guint16 *value_boot_version_minor_version,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_boot_version_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Boot Version' was not found in the message");
        return FALSE;
    }

    if (value_boot_version_major_version)
        *value_boot_version_major_version = self->arg_boot_version_major_version;
    if (value_boot_version_minor_version)
        *value_boot_version_minor_version = self->arg_boot_version_minor_version;

    return TRUE;
}

gboolean
qmi_message_dms_get_stored_image_info_output_get_pri_version (
    QmiMessageDmsGetStoredImageInfoOutput *self,
    guint32 *value_pri_version_pri_version,
    const gchar **value_pri_version_pri_info,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_pri_version_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'PRI Version' was not found in the message");
        return FALSE;
    }

    if (value_pri_version_pri_version)
        *value_pri_version_pri_version = self->arg_pri_version_pri_version;
    if (value_pri_version_pri_info)
        *value_pri_version_pri_info = self->arg_pri_version_pri_info;

    return TRUE;
}

gboolean
qmi_message_dms_get_stored_image_info_output_get_oem_lock_id (
    QmiMessageDmsGetStoredImageInfoOutput *self,
    guint32 *value_oem_lock_id,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_oem_lock_id_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'OEM Lock ID' was not found in the message");
        return FALSE;
    }

    if (value_oem_lock_id)
        *value_oem_lock_id = self->arg_oem_lock_id;

    return TRUE;
}

GType
qmi_message_dms_get_stored_image_info_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsGetStoredImageInfoOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_get_stored_image_info_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_get_stored_image_info_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsGetStoredImageInfoOutput *
qmi_message_dms_get_stored_image_info_output_ref (QmiMessageDmsGetStoredImageInfoOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_get_stored_image_info_output_unref (QmiMessageDmsGetStoredImageInfoOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsGetStoredImageInfoOutput, self);
    }
}

static gchar *
qmi_message_dms_get_stored_image_info_input_image_details_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_STORED_IMAGE_INFO_INPUT_TLV_IMAGE_DETAILS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " type = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_DMS_FIRMWARE_IMAGE_TYPE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_dms_firmware_image_type_get_string ((QmiDmsFirmwareImageType)tmp));
#elif defined  __QMI_DMS_FIRMWARE_IMAGE_TYPE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_dms_firmware_image_type_build_string_from_mask ((QmiDmsFirmwareImageType)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiDmsFirmwareImageType
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " unique_id = '");
    {
        guint unique_id_i;
        guint16 unique_id_n_items = 16;


        g_string_append (printable, "{");

        for (unique_id_i = 0; unique_id_i < unique_id_n_items; unique_id_i++) {
            g_string_append_printf (printable, " [%u] = '", unique_id_i);

            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
                    g_string_append_printf (printable, "%u", (guint)tmp);
                }
            }
            g_string_append (printable, "'");
        }

        g_string_append (printable, "}");
    }    g_string_append (printable, "'");
    g_string_append (printable, " build_id = '");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 1, 0, &tmp, &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_get_stored_image_info_output_boot_version_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_STORED_IMAGE_INFO_OUTPUT_TLV_BOOT_VERSION, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " major_version = '");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " minor_version = '");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_get_stored_image_info_output_pri_version_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_STORED_IMAGE_INFO_OUTPUT_TLV_PRI_VERSION, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " pri_version = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " pri_info = '");

    {
        gchar tmp[33] = { '\0' };

        if (!qmi_message_tlv_read_fixed_size_string (message, init_offset, &offset, 32, &tmp[0], &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_get_stored_image_info_output_oem_lock_id_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_STORED_IMAGE_INFO_OUTPUT_TLV_OEM_LOCK_ID, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_get_stored_image_info_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_get_stored_image_info_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_get_stored_image_info_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        case QMI_MESSAGE_DMS_GET_STORED_IMAGE_INFO_INPUT_TLV_IMAGE_DETAILS:
            tlv_type_str = "Image Details";
            translated_value = qmi_message_dms_get_stored_image_info_input_image_details_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_GET_STORED_IMAGE_INFO_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_GET_STORED_IMAGE_INFO_OUTPUT_TLV_BOOT_VERSION:
            tlv_type_str = "Boot Version";
            translated_value = qmi_message_dms_get_stored_image_info_output_boot_version_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_GET_STORED_IMAGE_INFO_OUTPUT_TLV_PRI_VERSION:
            tlv_type_str = "PRI Version";
            translated_value = qmi_message_dms_get_stored_image_info_output_pri_version_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_GET_STORED_IMAGE_INFO_OUTPUT_TLV_OEM_LOCK_ID:
            tlv_type_str = "OEM Lock ID";
            translated_value = qmi_message_dms_get_stored_image_info_output_oem_lock_id_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_get_stored_image_info_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Get Stored Image Info\" (0x004C)\n",
                            line_prefix);

    {
        struct message_get_stored_image_info_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_get_stored_image_info_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsGetStoredImageInfoOutput *
qmi_message_dms_get_stored_image_info_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsGetStoredImageInfoOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_GET_STORED_IMAGE_INFO);

    self = g_slice_new0 (QmiMessageDmsGetStoredImageInfoOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_STORED_IMAGE_INFO_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_get_stored_image_info_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_get_stored_image_info_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_STORED_IMAGE_INFO_OUTPUT_TLV_BOOT_VERSION, NULL, NULL)) == 0) {
                goto qmi_message_dms_get_stored_image_info_output_boot_version_out;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_boot_version_major_version), NULL))
                goto qmi_message_dms_get_stored_image_info_output_boot_version_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_boot_version_minor_version), NULL))
                goto qmi_message_dms_get_stored_image_info_output_boot_version_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Boot Version' TLV", offset);
            }

            self->arg_boot_version_set = TRUE;

qmi_message_dms_get_stored_image_info_output_boot_version_out:
            ;

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_STORED_IMAGE_INFO_OUTPUT_TLV_PRI_VERSION, NULL, NULL)) == 0) {
                goto qmi_message_dms_get_stored_image_info_output_pri_version_out;
            }
            if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_pri_version_pri_version), NULL))
                goto qmi_message_dms_get_stored_image_info_output_pri_version_out;
            if (!qmi_message_tlv_read_fixed_size_string (message, init_offset, &offset, 32, &self->arg_pri_version_pri_info[0], NULL))
                goto qmi_message_dms_get_stored_image_info_output_pri_version_out;
            self->arg_pri_version_pri_info[32] = '\0';

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'PRI Version' TLV", offset);
            }

            self->arg_pri_version_set = TRUE;

qmi_message_dms_get_stored_image_info_output_pri_version_out:
            ;

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_STORED_IMAGE_INFO_OUTPUT_TLV_OEM_LOCK_ID, NULL, NULL)) == 0) {
                goto qmi_message_dms_get_stored_image_info_output_oem_lock_id_out;
            }
            if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_oem_lock_id), NULL))
                goto qmi_message_dms_get_stored_image_info_output_oem_lock_id_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'OEM Lock ID' TLV", offset);
            }

            self->arg_oem_lock_id_set = TRUE;

qmi_message_dms_get_stored_image_info_output_oem_lock_id_out:
            ;

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS Get Alt Net Config */


/* --- Input -- */

/* Note: no fields in the Input container */

static QmiMessage *
__qmi_message_dms_get_alt_net_config_request_create (
    guint16 transaction_id,
    guint8 cid,
    gpointer unused,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_GET_ALT_NET_CONFIG);

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsGetAltNetConfigOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* Config */
    gboolean arg_config_set;
    guint8 arg_config;
};

#define QMI_MESSAGE_DMS_GET_ALT_NET_CONFIG_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_DMS_GET_ALT_NET_CONFIG_OUTPUT_TLV_CONFIG 0x01

gboolean
qmi_message_dms_get_alt_net_config_output_get_result (
    QmiMessageDmsGetAltNetConfigOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_dms_get_alt_net_config_output_get_config (
    QmiMessageDmsGetAltNetConfigOutput *self,
    gboolean *value_config,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_config_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Config' was not found in the message");
        return FALSE;
    }

    if (value_config)
        *value_config = (gboolean)(self->arg_config);

    return TRUE;
}

GType
qmi_message_dms_get_alt_net_config_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsGetAltNetConfigOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_get_alt_net_config_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_get_alt_net_config_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsGetAltNetConfigOutput *
qmi_message_dms_get_alt_net_config_output_ref (QmiMessageDmsGetAltNetConfigOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_get_alt_net_config_output_unref (QmiMessageDmsGetAltNetConfigOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsGetAltNetConfigOutput, self);
    }
}

static gchar *
qmi_message_dms_get_alt_net_config_output_config_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_ALT_NET_CONFIG_OUTPUT_TLV_CONFIG, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_get_alt_net_config_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_get_alt_net_config_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_get_alt_net_config_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_GET_ALT_NET_CONFIG_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_GET_ALT_NET_CONFIG_OUTPUT_TLV_CONFIG:
            tlv_type_str = "Config";
            translated_value = qmi_message_dms_get_alt_net_config_output_config_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_get_alt_net_config_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Get Alt Net Config\" (0x004D)\n",
                            line_prefix);

    {
        struct message_get_alt_net_config_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_get_alt_net_config_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsGetAltNetConfigOutput *
qmi_message_dms_get_alt_net_config_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsGetAltNetConfigOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_GET_ALT_NET_CONFIG);

    self = g_slice_new0 (QmiMessageDmsGetAltNetConfigOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_ALT_NET_CONFIG_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_get_alt_net_config_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_get_alt_net_config_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_ALT_NET_CONFIG_OUTPUT_TLV_CONFIG, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Config TLV: ");
                qmi_message_dms_get_alt_net_config_output_unref (self);
                return NULL;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, error))
                    goto qmi_message_dms_get_alt_net_config_output_config_out;
                self->arg_config = (gboolean)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Config' TLV", offset);
            }

            self->arg_config_set = TRUE;

qmi_message_dms_get_alt_net_config_output_config_out:
            if (!self->arg_config_set) {
                qmi_message_dms_get_alt_net_config_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS Set Alt Net Config */


/* --- Input -- */

struct _QmiMessageDmsSetAltNetConfigInput {
    volatile gint ref_count;

    /* Config */
    gboolean arg_config_set;
    guint8 arg_config;
};

#define QMI_MESSAGE_DMS_SET_ALT_NET_CONFIG_INPUT_TLV_CONFIG 0x01

gboolean
qmi_message_dms_set_alt_net_config_input_get_config (
    QmiMessageDmsSetAltNetConfigInput *self,
    gboolean *value_config,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_config_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Config' was not found in the message");
        return FALSE;
    }

    if (value_config)
        *value_config = (gboolean)(self->arg_config);

    return TRUE;
}

gboolean
qmi_message_dms_set_alt_net_config_input_set_config (
    QmiMessageDmsSetAltNetConfigInput *self,
    gboolean value_config,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_config = (guint8)(value_config);
    self->arg_config_set = TRUE;

    return TRUE;
}

GType
qmi_message_dms_set_alt_net_config_input_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsSetAltNetConfigInput"),
                                          (GBoxedCopyFunc) qmi_message_dms_set_alt_net_config_input_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_set_alt_net_config_input_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsSetAltNetConfigInput *
qmi_message_dms_set_alt_net_config_input_ref (QmiMessageDmsSetAltNetConfigInput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_set_alt_net_config_input_unref (QmiMessageDmsSetAltNetConfigInput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsSetAltNetConfigInput, self);
    }
}

QmiMessageDmsSetAltNetConfigInput *
qmi_message_dms_set_alt_net_config_input_new (void)
{
    QmiMessageDmsSetAltNetConfigInput *self;

    self = g_slice_new0 (QmiMessageDmsSetAltNetConfigInput);
    self->ref_count = 1;
    return self;
}

static QmiMessage *
__qmi_message_dms_set_alt_net_config_request_create (
    guint16 transaction_id,
    guint8 cid,
    QmiMessageDmsSetAltNetConfigInput *input,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_SET_ALT_NET_CONFIG);

    /* There is at least one mandatory TLV, don't allow NULL input */
    if (!input) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Message 'Set Alt Net Config' has mandatory TLVs");
        return NULL;
    }

    /* Try to add the 'Config' TLV */
    if (input->arg_config_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_DMS_SET_ALT_NET_CONFIG_INPUT_TLV_CONFIG, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Config': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_config;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Config': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Config': ");
            return NULL;
        }
    } else {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Missing mandatory TLV 'Config' in message 'Set Alt Net Config'");
        return NULL;
    }

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsSetAltNetConfigOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;
};

#define QMI_MESSAGE_DMS_SET_ALT_NET_CONFIG_OUTPUT_TLV_RESULT 0x02

gboolean
qmi_message_dms_set_alt_net_config_output_get_result (
    QmiMessageDmsSetAltNetConfigOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

GType
qmi_message_dms_set_alt_net_config_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsSetAltNetConfigOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_set_alt_net_config_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_set_alt_net_config_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsSetAltNetConfigOutput *
qmi_message_dms_set_alt_net_config_output_ref (QmiMessageDmsSetAltNetConfigOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_set_alt_net_config_output_unref (QmiMessageDmsSetAltNetConfigOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsSetAltNetConfigOutput, self);
    }
}

static gchar *
qmi_message_dms_set_alt_net_config_input_config_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SET_ALT_NET_CONFIG_INPUT_TLV_CONFIG, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_set_alt_net_config_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_set_alt_net_config_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_set_alt_net_config_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        case QMI_MESSAGE_DMS_SET_ALT_NET_CONFIG_INPUT_TLV_CONFIG:
            tlv_type_str = "Config";
            translated_value = qmi_message_dms_set_alt_net_config_input_config_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_SET_ALT_NET_CONFIG_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_set_alt_net_config_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Set Alt Net Config\" (0x004E)\n",
                            line_prefix);

    {
        struct message_set_alt_net_config_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_set_alt_net_config_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsSetAltNetConfigOutput *
qmi_message_dms_set_alt_net_config_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsSetAltNetConfigOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_SET_ALT_NET_CONFIG);

    self = g_slice_new0 (QmiMessageDmsSetAltNetConfigOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SET_ALT_NET_CONFIG_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_set_alt_net_config_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_set_alt_net_config_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS Get Boot Image Download Mode */


/* --- Input -- */

/* Note: no fields in the Input container */

static QmiMessage *
__qmi_message_dms_get_boot_image_download_mode_request_create (
    guint16 transaction_id,
    guint8 cid,
    gpointer unused,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_GET_BOOT_IMAGE_DOWNLOAD_MODE);

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsGetBootImageDownloadModeOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* Mode */
    gboolean arg_mode_set;
    guint8 arg_mode;
};

#define QMI_MESSAGE_DMS_GET_BOOT_IMAGE_DOWNLOAD_MODE_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_DMS_GET_BOOT_IMAGE_DOWNLOAD_MODE_OUTPUT_TLV_MODE 0x10

gboolean
qmi_message_dms_get_boot_image_download_mode_output_get_result (
    QmiMessageDmsGetBootImageDownloadModeOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_dms_get_boot_image_download_mode_output_get_mode (
    QmiMessageDmsGetBootImageDownloadModeOutput *self,
    QmiDmsBootImageDownloadMode *value_mode,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_mode_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Mode' was not found in the message");
        return FALSE;
    }

    if (value_mode)
        *value_mode = (QmiDmsBootImageDownloadMode)(self->arg_mode);

    return TRUE;
}

GType
qmi_message_dms_get_boot_image_download_mode_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsGetBootImageDownloadModeOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_get_boot_image_download_mode_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_get_boot_image_download_mode_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsGetBootImageDownloadModeOutput *
qmi_message_dms_get_boot_image_download_mode_output_ref (QmiMessageDmsGetBootImageDownloadModeOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_get_boot_image_download_mode_output_unref (QmiMessageDmsGetBootImageDownloadModeOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsGetBootImageDownloadModeOutput, self);
    }
}

static gchar *
qmi_message_dms_get_boot_image_download_mode_output_mode_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_BOOT_IMAGE_DOWNLOAD_MODE_OUTPUT_TLV_MODE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_DMS_BOOT_IMAGE_DOWNLOAD_MODE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_dms_boot_image_download_mode_get_string ((QmiDmsBootImageDownloadMode)tmp));
#elif defined  __QMI_DMS_BOOT_IMAGE_DOWNLOAD_MODE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_dms_boot_image_download_mode_build_string_from_mask ((QmiDmsBootImageDownloadMode)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiDmsBootImageDownloadMode
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_get_boot_image_download_mode_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_get_boot_image_download_mode_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_get_boot_image_download_mode_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_GET_BOOT_IMAGE_DOWNLOAD_MODE_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_GET_BOOT_IMAGE_DOWNLOAD_MODE_OUTPUT_TLV_MODE:
            tlv_type_str = "Mode";
            translated_value = qmi_message_dms_get_boot_image_download_mode_output_mode_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_get_boot_image_download_mode_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Get Boot Image Download Mode\" (0x004F)\n",
                            line_prefix);

    {
        struct message_get_boot_image_download_mode_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_get_boot_image_download_mode_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsGetBootImageDownloadModeOutput *
qmi_message_dms_get_boot_image_download_mode_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsGetBootImageDownloadModeOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_GET_BOOT_IMAGE_DOWNLOAD_MODE);

    self = g_slice_new0 (QmiMessageDmsGetBootImageDownloadModeOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_BOOT_IMAGE_DOWNLOAD_MODE_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_get_boot_image_download_mode_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_get_boot_image_download_mode_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_BOOT_IMAGE_DOWNLOAD_MODE_OUTPUT_TLV_MODE, NULL, NULL)) == 0) {
                goto qmi_message_dms_get_boot_image_download_mode_output_mode_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_message_dms_get_boot_image_download_mode_output_mode_out;
                self->arg_mode = (QmiDmsBootImageDownloadMode)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Mode' TLV", offset);
            }

            self->arg_mode_set = TRUE;

qmi_message_dms_get_boot_image_download_mode_output_mode_out:
            ;

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS Set Boot Image Download Mode */


/* --- Input -- */

struct _QmiMessageDmsSetBootImageDownloadModeInput {
    volatile gint ref_count;

    /* Mode */
    gboolean arg_mode_set;
    guint8 arg_mode;
};

#define QMI_MESSAGE_DMS_SET_BOOT_IMAGE_DOWNLOAD_MODE_INPUT_TLV_MODE 0x01

gboolean
qmi_message_dms_set_boot_image_download_mode_input_get_mode (
    QmiMessageDmsSetBootImageDownloadModeInput *self,
    QmiDmsBootImageDownloadMode *value_mode,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_mode_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Mode' was not found in the message");
        return FALSE;
    }

    if (value_mode)
        *value_mode = (QmiDmsBootImageDownloadMode)(self->arg_mode);

    return TRUE;
}

gboolean
qmi_message_dms_set_boot_image_download_mode_input_set_mode (
    QmiMessageDmsSetBootImageDownloadModeInput *self,
    QmiDmsBootImageDownloadMode value_mode,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_mode = (guint8)(value_mode);
    self->arg_mode_set = TRUE;

    return TRUE;
}

GType
qmi_message_dms_set_boot_image_download_mode_input_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsSetBootImageDownloadModeInput"),
                                          (GBoxedCopyFunc) qmi_message_dms_set_boot_image_download_mode_input_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_set_boot_image_download_mode_input_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsSetBootImageDownloadModeInput *
qmi_message_dms_set_boot_image_download_mode_input_ref (QmiMessageDmsSetBootImageDownloadModeInput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_set_boot_image_download_mode_input_unref (QmiMessageDmsSetBootImageDownloadModeInput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsSetBootImageDownloadModeInput, self);
    }
}

QmiMessageDmsSetBootImageDownloadModeInput *
qmi_message_dms_set_boot_image_download_mode_input_new (void)
{
    QmiMessageDmsSetBootImageDownloadModeInput *self;

    self = g_slice_new0 (QmiMessageDmsSetBootImageDownloadModeInput);
    self->ref_count = 1;
    return self;
}

static QmiMessage *
__qmi_message_dms_set_boot_image_download_mode_request_create (
    guint16 transaction_id,
    guint8 cid,
    QmiMessageDmsSetBootImageDownloadModeInput *input,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_SET_BOOT_IMAGE_DOWNLOAD_MODE);

    /* There is at least one mandatory TLV, don't allow NULL input */
    if (!input) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Message 'Set Boot Image Download Mode' has mandatory TLVs");
        return NULL;
    }

    /* Try to add the 'Mode' TLV */
    if (input->arg_mode_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_DMS_SET_BOOT_IMAGE_DOWNLOAD_MODE_INPUT_TLV_MODE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Mode': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_mode;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Mode': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Mode': ");
            return NULL;
        }
    } else {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Missing mandatory TLV 'Mode' in message 'Set Boot Image Download Mode'");
        return NULL;
    }

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsSetBootImageDownloadModeOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;
};

#define QMI_MESSAGE_DMS_SET_BOOT_IMAGE_DOWNLOAD_MODE_OUTPUT_TLV_RESULT 0x02

gboolean
qmi_message_dms_set_boot_image_download_mode_output_get_result (
    QmiMessageDmsSetBootImageDownloadModeOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

GType
qmi_message_dms_set_boot_image_download_mode_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsSetBootImageDownloadModeOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_set_boot_image_download_mode_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_set_boot_image_download_mode_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsSetBootImageDownloadModeOutput *
qmi_message_dms_set_boot_image_download_mode_output_ref (QmiMessageDmsSetBootImageDownloadModeOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_set_boot_image_download_mode_output_unref (QmiMessageDmsSetBootImageDownloadModeOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsSetBootImageDownloadModeOutput, self);
    }
}

static gchar *
qmi_message_dms_set_boot_image_download_mode_input_mode_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SET_BOOT_IMAGE_DOWNLOAD_MODE_INPUT_TLV_MODE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_DMS_BOOT_IMAGE_DOWNLOAD_MODE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_dms_boot_image_download_mode_get_string ((QmiDmsBootImageDownloadMode)tmp));
#elif defined  __QMI_DMS_BOOT_IMAGE_DOWNLOAD_MODE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_dms_boot_image_download_mode_build_string_from_mask ((QmiDmsBootImageDownloadMode)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiDmsBootImageDownloadMode
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_set_boot_image_download_mode_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_set_boot_image_download_mode_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_set_boot_image_download_mode_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        case QMI_MESSAGE_DMS_SET_BOOT_IMAGE_DOWNLOAD_MODE_INPUT_TLV_MODE:
            tlv_type_str = "Mode";
            translated_value = qmi_message_dms_set_boot_image_download_mode_input_mode_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_SET_BOOT_IMAGE_DOWNLOAD_MODE_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_set_boot_image_download_mode_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Set Boot Image Download Mode\" (0x0050)\n",
                            line_prefix);

    {
        struct message_set_boot_image_download_mode_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_set_boot_image_download_mode_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsSetBootImageDownloadModeOutput *
qmi_message_dms_set_boot_image_download_mode_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsSetBootImageDownloadModeOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_SET_BOOT_IMAGE_DOWNLOAD_MODE);

    self = g_slice_new0 (QmiMessageDmsSetBootImageDownloadModeOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SET_BOOT_IMAGE_DOWNLOAD_MODE_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_set_boot_image_download_mode_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_set_boot_image_download_mode_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS Get Software Version */


/* --- Input -- */

/* Note: no fields in the Input container */

static QmiMessage *
__qmi_message_dms_get_software_version_request_create (
    guint16 transaction_id,
    guint8 cid,
    gpointer unused,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_GET_SOFTWARE_VERSION);

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsGetSoftwareVersionOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* Version */
    gboolean arg_version_set;
    gchar *arg_version;
};

#define QMI_MESSAGE_DMS_GET_SOFTWARE_VERSION_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_DMS_GET_SOFTWARE_VERSION_OUTPUT_TLV_VERSION 0x01

gboolean
qmi_message_dms_get_software_version_output_get_result (
    QmiMessageDmsGetSoftwareVersionOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_dms_get_software_version_output_get_version (
    QmiMessageDmsGetSoftwareVersionOutput *self,
    const gchar **value_version,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_version_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Version' was not found in the message");
        return FALSE;
    }

    if (value_version)
        *value_version = self->arg_version;

    return TRUE;
}

GType
qmi_message_dms_get_software_version_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsGetSoftwareVersionOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_get_software_version_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_get_software_version_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsGetSoftwareVersionOutput *
qmi_message_dms_get_software_version_output_ref (QmiMessageDmsGetSoftwareVersionOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_get_software_version_output_unref (QmiMessageDmsGetSoftwareVersionOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_version, (GDestroyNotify)g_free);
        g_slice_free (QmiMessageDmsGetSoftwareVersionOutput, self);
    }
}

static gchar *
qmi_message_dms_get_software_version_output_version_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_SOFTWARE_VERSION_OUTPUT_TLV_VERSION, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &tmp, &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_get_software_version_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_get_software_version_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_get_software_version_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_GET_SOFTWARE_VERSION_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_GET_SOFTWARE_VERSION_OUTPUT_TLV_VERSION:
            tlv_type_str = "Version";
            translated_value = qmi_message_dms_get_software_version_output_version_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_get_software_version_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Get Software Version\" (0x0051)\n",
                            line_prefix);

    {
        struct message_get_software_version_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_get_software_version_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsGetSoftwareVersionOutput *
qmi_message_dms_get_software_version_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsGetSoftwareVersionOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_GET_SOFTWARE_VERSION);

    self = g_slice_new0 (QmiMessageDmsGetSoftwareVersionOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_SOFTWARE_VERSION_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_get_software_version_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_get_software_version_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_SOFTWARE_VERSION_OUTPUT_TLV_VERSION, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Version TLV: ");
                qmi_message_dms_get_software_version_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &(self->arg_version), error))
                goto qmi_message_dms_get_software_version_output_version_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Version' TLV", offset);
            }

            self->arg_version_set = TRUE;

qmi_message_dms_get_software_version_output_version_out:
            if (!self->arg_version_set) {
                qmi_message_dms_get_software_version_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS Set Service Programming Code */


/* --- Input -- */

struct _QmiMessageDmsSetServiceProgrammingCodeInput {
    volatile gint ref_count;

    /* New Code */
    gboolean arg_new_code_set;
    gchar arg_new_code[7];

    /* Current Code */
    gboolean arg_current_code_set;
    gchar arg_current_code[7];
};

#define QMI_MESSAGE_DMS_SET_SERVICE_PROGRAMMING_CODE_INPUT_TLV_NEW_CODE 0x02
#define QMI_MESSAGE_DMS_SET_SERVICE_PROGRAMMING_CODE_INPUT_TLV_CURRENT_CODE 0x01

gboolean
qmi_message_dms_set_service_programming_code_input_get_new_code (
    QmiMessageDmsSetServiceProgrammingCodeInput *self,
    const gchar **value_new_code,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_new_code_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'New Code' was not found in the message");
        return FALSE;
    }

    if (value_new_code)
        *value_new_code = self->arg_new_code;

    return TRUE;
}

gboolean
qmi_message_dms_set_service_programming_code_input_set_new_code (
    QmiMessageDmsSetServiceProgrammingCodeInput *self,
    const gchar *value_new_code,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!value_new_code || strlen (value_new_code) != 6) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Input variable 'value_new_code' must be 6 characters long");
        return FALSE;
    }
    memcpy (self->arg_new_code, value_new_code, 6);
    self->arg_new_code[6] = '\0';
    self->arg_new_code_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_dms_set_service_programming_code_input_get_current_code (
    QmiMessageDmsSetServiceProgrammingCodeInput *self,
    const gchar **value_current_code,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_current_code_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Current Code' was not found in the message");
        return FALSE;
    }

    if (value_current_code)
        *value_current_code = self->arg_current_code;

    return TRUE;
}

gboolean
qmi_message_dms_set_service_programming_code_input_set_current_code (
    QmiMessageDmsSetServiceProgrammingCodeInput *self,
    const gchar *value_current_code,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!value_current_code || strlen (value_current_code) != 6) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Input variable 'value_current_code' must be 6 characters long");
        return FALSE;
    }
    memcpy (self->arg_current_code, value_current_code, 6);
    self->arg_current_code[6] = '\0';
    self->arg_current_code_set = TRUE;

    return TRUE;
}

GType
qmi_message_dms_set_service_programming_code_input_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsSetServiceProgrammingCodeInput"),
                                          (GBoxedCopyFunc) qmi_message_dms_set_service_programming_code_input_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_set_service_programming_code_input_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsSetServiceProgrammingCodeInput *
qmi_message_dms_set_service_programming_code_input_ref (QmiMessageDmsSetServiceProgrammingCodeInput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_set_service_programming_code_input_unref (QmiMessageDmsSetServiceProgrammingCodeInput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsSetServiceProgrammingCodeInput, self);
    }
}

QmiMessageDmsSetServiceProgrammingCodeInput *
qmi_message_dms_set_service_programming_code_input_new (void)
{
    QmiMessageDmsSetServiceProgrammingCodeInput *self;

    self = g_slice_new0 (QmiMessageDmsSetServiceProgrammingCodeInput);
    self->ref_count = 1;
    return self;
}

static QmiMessage *
__qmi_message_dms_set_service_programming_code_request_create (
    guint16 transaction_id,
    guint8 cid,
    QmiMessageDmsSetServiceProgrammingCodeInput *input,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_SET_SERVICE_PROGRAMMING_CODE);

    /* There is at least one mandatory TLV, don't allow NULL input */
    if (!input) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Message 'Set Service Programming Code' has mandatory TLVs");
        return NULL;
    }

    /* Try to add the 'New Code' TLV */
    if (input->arg_new_code_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_DMS_SET_SERVICE_PROGRAMMING_CODE_INPUT_TLV_NEW_CODE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'New Code': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_string (self, 0, input->arg_new_code, 6, error)) {
            g_prefix_error (error, "Cannot write string in TLV 'New Code': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'New Code': ");
            return NULL;
        }
    } else {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Missing mandatory TLV 'New Code' in message 'Set Service Programming Code'");
        return NULL;
    }

    /* Try to add the 'Current Code' TLV */
    if (input->arg_current_code_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_DMS_SET_SERVICE_PROGRAMMING_CODE_INPUT_TLV_CURRENT_CODE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Current Code': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_string (self, 0, input->arg_current_code, 6, error)) {
            g_prefix_error (error, "Cannot write string in TLV 'Current Code': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Current Code': ");
            return NULL;
        }
    } else {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Missing mandatory TLV 'Current Code' in message 'Set Service Programming Code'");
        return NULL;
    }

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsSetServiceProgrammingCodeOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;
};

#define QMI_MESSAGE_DMS_SET_SERVICE_PROGRAMMING_CODE_OUTPUT_TLV_RESULT 0x02

gboolean
qmi_message_dms_set_service_programming_code_output_get_result (
    QmiMessageDmsSetServiceProgrammingCodeOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

GType
qmi_message_dms_set_service_programming_code_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsSetServiceProgrammingCodeOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_set_service_programming_code_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_set_service_programming_code_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsSetServiceProgrammingCodeOutput *
qmi_message_dms_set_service_programming_code_output_ref (QmiMessageDmsSetServiceProgrammingCodeOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_set_service_programming_code_output_unref (QmiMessageDmsSetServiceProgrammingCodeOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsSetServiceProgrammingCodeOutput, self);
    }
}

static gchar *
qmi_message_dms_set_service_programming_code_input_new_code_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SET_SERVICE_PROGRAMMING_CODE_INPUT_TLV_NEW_CODE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        gchar tmp[7] = { '\0' };

        if (!qmi_message_tlv_read_fixed_size_string (message, init_offset, &offset, 6, &tmp[0], &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_set_service_programming_code_input_current_code_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SET_SERVICE_PROGRAMMING_CODE_INPUT_TLV_CURRENT_CODE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        gchar tmp[7] = { '\0' };

        if (!qmi_message_tlv_read_fixed_size_string (message, init_offset, &offset, 6, &tmp[0], &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_set_service_programming_code_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_set_service_programming_code_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_set_service_programming_code_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        case QMI_MESSAGE_DMS_SET_SERVICE_PROGRAMMING_CODE_INPUT_TLV_NEW_CODE:
            tlv_type_str = "New Code";
            translated_value = qmi_message_dms_set_service_programming_code_input_new_code_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_SET_SERVICE_PROGRAMMING_CODE_INPUT_TLV_CURRENT_CODE:
            tlv_type_str = "Current Code";
            translated_value = qmi_message_dms_set_service_programming_code_input_current_code_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_SET_SERVICE_PROGRAMMING_CODE_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_set_service_programming_code_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Set Service Programming Code\" (0x0052)\n",
                            line_prefix);

    {
        struct message_set_service_programming_code_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_set_service_programming_code_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsSetServiceProgrammingCodeOutput *
qmi_message_dms_set_service_programming_code_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsSetServiceProgrammingCodeOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_SET_SERVICE_PROGRAMMING_CODE);

    self = g_slice_new0 (QmiMessageDmsSetServiceProgrammingCodeOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SET_SERVICE_PROGRAMMING_CODE_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_set_service_programming_code_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_set_service_programming_code_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS Get MAC Address */


/* --- Input -- */

struct _QmiMessageDmsGetMacAddressInput {
    volatile gint ref_count;

    /* Device */
    gboolean arg_device_set;
    guint32 arg_device;
};

#define QMI_MESSAGE_DMS_GET_MAC_ADDRESS_INPUT_TLV_DEVICE 0x01

gboolean
qmi_message_dms_get_mac_address_input_get_device (
    QmiMessageDmsGetMacAddressInput *self,
    QmiDmsMacType *value_device,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_device_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Device' was not found in the message");
        return FALSE;
    }

    if (value_device)
        *value_device = (QmiDmsMacType)(self->arg_device);

    return TRUE;
}

gboolean
qmi_message_dms_get_mac_address_input_set_device (
    QmiMessageDmsGetMacAddressInput *self,
    QmiDmsMacType value_device,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_device = (guint32)(value_device);
    self->arg_device_set = TRUE;

    return TRUE;
}

GType
qmi_message_dms_get_mac_address_input_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsGetMacAddressInput"),
                                          (GBoxedCopyFunc) qmi_message_dms_get_mac_address_input_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_get_mac_address_input_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsGetMacAddressInput *
qmi_message_dms_get_mac_address_input_ref (QmiMessageDmsGetMacAddressInput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_get_mac_address_input_unref (QmiMessageDmsGetMacAddressInput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsGetMacAddressInput, self);
    }
}

QmiMessageDmsGetMacAddressInput *
qmi_message_dms_get_mac_address_input_new (void)
{
    QmiMessageDmsGetMacAddressInput *self;

    self = g_slice_new0 (QmiMessageDmsGetMacAddressInput);
    self->ref_count = 1;
    return self;
}

static QmiMessage *
__qmi_message_dms_get_mac_address_request_create (
    guint16 transaction_id,
    guint8 cid,
    QmiMessageDmsGetMacAddressInput *input,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_GET_MAC_ADDRESS);

    /* There is at least one mandatory TLV, don't allow NULL input */
    if (!input) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Message 'Get MAC Address' has mandatory TLVs");
        return NULL;
    }

    /* Try to add the 'Device' TLV */
    if (input->arg_device_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_DMS_GET_MAC_ADDRESS_INPUT_TLV_DEVICE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Device': ");
            return NULL;
        }

        {
            guint32 tmp;

            tmp = (guint32) input->arg_device;
            /* Write the guint32 variable to the buffer */
            if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Device': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Device': ");
            return NULL;
        }
    } else {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Missing mandatory TLV 'Device' in message 'Get MAC Address'");
        return NULL;
    }

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsGetMacAddressOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* MAC Address */
    gboolean arg_mac_address_set;
    GArray *arg_mac_address;
};

#define QMI_MESSAGE_DMS_GET_MAC_ADDRESS_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_DMS_GET_MAC_ADDRESS_OUTPUT_TLV_MAC_ADDRESS 0x10

gboolean
qmi_message_dms_get_mac_address_output_get_result (
    QmiMessageDmsGetMacAddressOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_dms_get_mac_address_output_get_mac_address (
    QmiMessageDmsGetMacAddressOutput *self,
    GArray **value_mac_address,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_mac_address_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'MAC Address' was not found in the message");
        return FALSE;
    }

    if (value_mac_address)
        *value_mac_address = self->arg_mac_address;

    return TRUE;
}

GType
qmi_message_dms_get_mac_address_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsGetMacAddressOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_get_mac_address_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_get_mac_address_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsGetMacAddressOutput *
qmi_message_dms_get_mac_address_output_ref (QmiMessageDmsGetMacAddressOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_get_mac_address_output_unref (QmiMessageDmsGetMacAddressOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_mac_address, (GDestroyNotify)g_array_unref);
        g_slice_free (QmiMessageDmsGetMacAddressOutput, self);
    }
}

static gchar *
qmi_message_dms_get_mac_address_input_device_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_MAC_ADDRESS_INPUT_TLV_DEVICE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
#if defined  __QMI_DMS_MAC_TYPE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_dms_mac_type_get_string ((QmiDmsMacType)tmp));
#elif defined  __QMI_DMS_MAC_TYPE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_dms_mac_type_build_string_from_mask ((QmiDmsMacType)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiDmsMacType
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_get_mac_address_output_mac_address_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_MAC_ADDRESS_OUTPUT_TLV_MAC_ADDRESS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    {
        guint mac_address_i;
        guint8 mac_address_n_items;

        /* Read number of items in the array */
        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(mac_address_n_items), &error))
            goto out;

        g_string_append (printable, "{");

        for (mac_address_i = 0; mac_address_i < mac_address_n_items; mac_address_i++) {
            g_string_append_printf (printable, " [%u] = '", mac_address_i);

            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
                    g_string_append_printf (printable, "%u", (guint)tmp);
                }
            }
            g_string_append (printable, "'");
        }

        g_string_append (printable, "}");
    }
    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_get_mac_address_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_get_mac_address_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_get_mac_address_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        case QMI_MESSAGE_DMS_GET_MAC_ADDRESS_INPUT_TLV_DEVICE:
            tlv_type_str = "Device";
            translated_value = qmi_message_dms_get_mac_address_input_device_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_GET_MAC_ADDRESS_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_GET_MAC_ADDRESS_OUTPUT_TLV_MAC_ADDRESS:
            tlv_type_str = "MAC Address";
            translated_value = qmi_message_dms_get_mac_address_output_mac_address_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_get_mac_address_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Get MAC Address\" (0x005C)\n",
                            line_prefix);

    {
        struct message_get_mac_address_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_get_mac_address_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsGetMacAddressOutput *
qmi_message_dms_get_mac_address_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsGetMacAddressOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_GET_MAC_ADDRESS);

    self = g_slice_new0 (QmiMessageDmsGetMacAddressOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_MAC_ADDRESS_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_get_mac_address_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_get_mac_address_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_MAC_ADDRESS_OUTPUT_TLV_MAC_ADDRESS, NULL, NULL)) == 0) {
                goto qmi_message_dms_get_mac_address_output_mac_address_out;
            }
            {
                guint mac_address_i;
                guint8 mac_address_n_items;

                /* Read number of items in the array */
                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(mac_address_n_items), NULL))
                    goto qmi_message_dms_get_mac_address_output_mac_address_out;

                self->arg_mac_address = g_array_sized_new (
                    FALSE,
                    FALSE,
                    sizeof (guint8),
                    (guint)mac_address_n_items);

                for (mac_address_i = 0; mac_address_i < mac_address_n_items; mac_address_i++) {
                    guint8 mac_address_aux;

                    if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(mac_address_aux), NULL))
                        goto qmi_message_dms_get_mac_address_output_mac_address_out;
                    g_array_insert_val (self->arg_mac_address, mac_address_i, mac_address_aux);
                }
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'MAC Address' TLV", offset);
            }

            self->arg_mac_address_set = TRUE;

qmi_message_dms_get_mac_address_output_mac_address_out:
            ;

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS Get Supported Messages */


/* --- Input -- */

/* Note: no fields in the Input container */

static QmiMessage *
__qmi_message_dms_get_supported_messages_request_create (
    guint16 transaction_id,
    guint8 cid,
    gpointer unused,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_GET_SUPPORTED_MESSAGES);

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsGetSupportedMessagesOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* List */
    gboolean arg_list_set;
    GArray *arg_list;
};

#define QMI_MESSAGE_DMS_GET_SUPPORTED_MESSAGES_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_DMS_GET_SUPPORTED_MESSAGES_OUTPUT_TLV_LIST 0x10

gboolean
qmi_message_dms_get_supported_messages_output_get_result (
    QmiMessageDmsGetSupportedMessagesOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_dms_get_supported_messages_output_get_list (
    QmiMessageDmsGetSupportedMessagesOutput *self,
    GArray **value_list,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_list_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'List' was not found in the message");
        return FALSE;
    }

    if (value_list)
        *value_list = self->arg_list;

    return TRUE;
}

GType
qmi_message_dms_get_supported_messages_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsGetSupportedMessagesOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_get_supported_messages_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_get_supported_messages_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsGetSupportedMessagesOutput *
qmi_message_dms_get_supported_messages_output_ref (QmiMessageDmsGetSupportedMessagesOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_get_supported_messages_output_unref (QmiMessageDmsGetSupportedMessagesOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_list, (GDestroyNotify)g_array_unref);
        g_slice_free (QmiMessageDmsGetSupportedMessagesOutput, self);
    }
}

static gchar *
qmi_message_dms_get_supported_messages_output_list_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_SUPPORTED_MESSAGES_OUTPUT_TLV_LIST, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    {
        guint list_i;
        guint16 list_n_items;

        /* Read number of items in the array */
        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(list_n_items), &error))
            goto out;

        g_string_append (printable, "{");

        for (list_i = 0; list_i < list_n_items; list_i++) {
            g_string_append_printf (printable, " [%u] = '", list_i);

            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
                    g_string_append_printf (printable, "%u", (guint)tmp);
                }
            }
            g_string_append (printable, "'");
        }

        g_string_append (printable, "}");
    }
    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_get_supported_messages_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_get_supported_messages_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_get_supported_messages_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_GET_SUPPORTED_MESSAGES_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_GET_SUPPORTED_MESSAGES_OUTPUT_TLV_LIST:
            tlv_type_str = "List";
            translated_value = qmi_message_dms_get_supported_messages_output_list_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_get_supported_messages_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Get Supported Messages\" (0x001E)\n",
                            line_prefix);

    {
        struct message_get_supported_messages_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_get_supported_messages_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsGetSupportedMessagesOutput *
qmi_message_dms_get_supported_messages_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsGetSupportedMessagesOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_GET_SUPPORTED_MESSAGES);

    self = g_slice_new0 (QmiMessageDmsGetSupportedMessagesOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_SUPPORTED_MESSAGES_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_get_supported_messages_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_get_supported_messages_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_GET_SUPPORTED_MESSAGES_OUTPUT_TLV_LIST, NULL, NULL)) == 0) {
                goto qmi_message_dms_get_supported_messages_output_list_out;
            }
            {
                guint list_i;
                guint16 list_n_items;

                /* Read number of items in the array */
                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(list_n_items), NULL))
                    goto qmi_message_dms_get_supported_messages_output_list_out;

                self->arg_list = g_array_sized_new (
                    FALSE,
                    FALSE,
                    sizeof (guint8),
                    (guint)list_n_items);

                for (list_i = 0; list_i < list_n_items; list_i++) {
                    guint8 list_aux;

                    if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(list_aux), NULL))
                        goto qmi_message_dms_get_supported_messages_output_list_out;
                    g_array_insert_val (self->arg_list, list_i, list_aux);
                }
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'List' TLV", offset);
            }

            self->arg_list_set = TRUE;

qmi_message_dms_get_supported_messages_output_list_out:
            ;

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS HP Change Device Mode */


/* --- Input -- */

struct _QmiMessageDmsHpChangeDeviceModeInput {
    volatile gint ref_count;

    /* Mode */
    gboolean arg_mode_set;
    guint8 arg_mode;
};

#define QMI_MESSAGE_DMS_HP_CHANGE_DEVICE_MODE_INPUT_TLV_MODE 0x01

gboolean
qmi_message_dms_hp_change_device_mode_input_get_mode (
    QmiMessageDmsHpChangeDeviceModeInput *self,
    QmiDmsHpDeviceMode *value_mode,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_mode_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Mode' was not found in the message");
        return FALSE;
    }

    if (value_mode)
        *value_mode = (QmiDmsHpDeviceMode)(self->arg_mode);

    return TRUE;
}

gboolean
qmi_message_dms_hp_change_device_mode_input_set_mode (
    QmiMessageDmsHpChangeDeviceModeInput *self,
    QmiDmsHpDeviceMode value_mode,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_mode = (guint8)(value_mode);
    self->arg_mode_set = TRUE;

    return TRUE;
}

GType
qmi_message_dms_hp_change_device_mode_input_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsHpChangeDeviceModeInput"),
                                          (GBoxedCopyFunc) qmi_message_dms_hp_change_device_mode_input_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_hp_change_device_mode_input_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsHpChangeDeviceModeInput *
qmi_message_dms_hp_change_device_mode_input_ref (QmiMessageDmsHpChangeDeviceModeInput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_hp_change_device_mode_input_unref (QmiMessageDmsHpChangeDeviceModeInput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsHpChangeDeviceModeInput, self);
    }
}

QmiMessageDmsHpChangeDeviceModeInput *
qmi_message_dms_hp_change_device_mode_input_new (void)
{
    QmiMessageDmsHpChangeDeviceModeInput *self;

    self = g_slice_new0 (QmiMessageDmsHpChangeDeviceModeInput);
    self->ref_count = 1;
    return self;
}

static QmiMessage *
__qmi_message_dms_hp_change_device_mode_request_create (
    guint16 transaction_id,
    guint8 cid,
    QmiMessageDmsHpChangeDeviceModeInput *input,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_HP_CHANGE_DEVICE_MODE);

    /* There is at least one mandatory TLV, don't allow NULL input */
    if (!input) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Message 'HP Change Device Mode' has mandatory TLVs");
        return NULL;
    }

    /* Try to add the 'Mode' TLV */
    if (input->arg_mode_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_DMS_HP_CHANGE_DEVICE_MODE_INPUT_TLV_MODE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Mode': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_mode;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Mode': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Mode': ");
            return NULL;
        }
    } else {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Missing mandatory TLV 'Mode' in message 'HP Change Device Mode'");
        return NULL;
    }

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsHpChangeDeviceModeOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;
};

#define QMI_MESSAGE_DMS_HP_CHANGE_DEVICE_MODE_OUTPUT_TLV_RESULT 0x02

gboolean
qmi_message_dms_hp_change_device_mode_output_get_result (
    QmiMessageDmsHpChangeDeviceModeOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

GType
qmi_message_dms_hp_change_device_mode_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsHpChangeDeviceModeOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_hp_change_device_mode_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_hp_change_device_mode_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsHpChangeDeviceModeOutput *
qmi_message_dms_hp_change_device_mode_output_ref (QmiMessageDmsHpChangeDeviceModeOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_hp_change_device_mode_output_unref (QmiMessageDmsHpChangeDeviceModeOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageDmsHpChangeDeviceModeOutput, self);
    }
}

static gchar *
qmi_message_dms_hp_change_device_mode_input_mode_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_HP_CHANGE_DEVICE_MODE_INPUT_TLV_MODE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_DMS_HP_DEVICE_MODE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_dms_hp_device_mode_get_string ((QmiDmsHpDeviceMode)tmp));
#elif defined  __QMI_DMS_HP_DEVICE_MODE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_dms_hp_device_mode_build_string_from_mask ((QmiDmsHpDeviceMode)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiDmsHpDeviceMode
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_hp_change_device_mode_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_hp_change_device_mode_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_hp_change_device_mode_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        case QMI_MESSAGE_DMS_HP_CHANGE_DEVICE_MODE_INPUT_TLV_MODE:
            tlv_type_str = "Mode";
            translated_value = qmi_message_dms_hp_change_device_mode_input_mode_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_HP_CHANGE_DEVICE_MODE_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_hp_change_device_mode_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"HP Change Device Mode\" (0x5556)\n",
                            line_prefix);

    {
        struct message_hp_change_device_mode_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_hp_change_device_mode_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsHpChangeDeviceModeOutput *
qmi_message_dms_hp_change_device_mode_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsHpChangeDeviceModeOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_HP_CHANGE_DEVICE_MODE);

    self = g_slice_new0 (QmiMessageDmsHpChangeDeviceModeOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_HP_CHANGE_DEVICE_MODE_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_hp_change_device_mode_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_hp_change_device_mode_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS Swi Get Current Firmware */


/* --- Input -- */

/* Note: no fields in the Input container */

static QmiMessage *
__qmi_message_dms_swi_get_current_firmware_request_create (
    guint16 transaction_id,
    guint8 cid,
    gpointer unused,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_SWI_GET_CURRENT_FIRMWARE);

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsSwiGetCurrentFirmwareOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* Model */
    gboolean arg_model_set;
    gchar *arg_model;

    /* Boot version */
    gboolean arg_boot_version_set;
    gchar *arg_boot_version;

    /* AMSS version */
    gboolean arg_amss_version_set;
    gchar *arg_amss_version;

    /* SKU ID */
    gboolean arg_sku_id_set;
    gchar *arg_sku_id;

    /* Package ID */
    gboolean arg_package_id_set;
    gchar *arg_package_id;

    /* Carrier ID */
    gboolean arg_carrier_id_set;
    gchar *arg_carrier_id;

    /* PRI version */
    gboolean arg_pri_version_set;
    gchar *arg_pri_version;

    /* Carrier */
    gboolean arg_carrier_set;
    gchar *arg_carrier;

    /* Config version */
    gboolean arg_config_version_set;
    gchar *arg_config_version;
};

#define QMI_MESSAGE_DMS_SWI_GET_CURRENT_FIRMWARE_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_DMS_SWI_GET_CURRENT_FIRMWARE_OUTPUT_TLV_MODEL 0x10
#define QMI_MESSAGE_DMS_SWI_GET_CURRENT_FIRMWARE_OUTPUT_TLV_BOOT_VERSION 0x11
#define QMI_MESSAGE_DMS_SWI_GET_CURRENT_FIRMWARE_OUTPUT_TLV_AMSS_VERSION 0x12
#define QMI_MESSAGE_DMS_SWI_GET_CURRENT_FIRMWARE_OUTPUT_TLV_SKU_ID 0x13
#define QMI_MESSAGE_DMS_SWI_GET_CURRENT_FIRMWARE_OUTPUT_TLV_PACKAGE_ID 0x14
#define QMI_MESSAGE_DMS_SWI_GET_CURRENT_FIRMWARE_OUTPUT_TLV_CARRIER_ID 0x15
#define QMI_MESSAGE_DMS_SWI_GET_CURRENT_FIRMWARE_OUTPUT_TLV_PRI_VERSION 0x16
#define QMI_MESSAGE_DMS_SWI_GET_CURRENT_FIRMWARE_OUTPUT_TLV_CARRIER 0x17
#define QMI_MESSAGE_DMS_SWI_GET_CURRENT_FIRMWARE_OUTPUT_TLV_CONFIG_VERSION 0x18

gboolean
qmi_message_dms_swi_get_current_firmware_output_get_result (
    QmiMessageDmsSwiGetCurrentFirmwareOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_dms_swi_get_current_firmware_output_get_model (
    QmiMessageDmsSwiGetCurrentFirmwareOutput *self,
    const gchar **value_model,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_model_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Model' was not found in the message");
        return FALSE;
    }

    if (value_model)
        *value_model = self->arg_model;

    return TRUE;
}

gboolean
qmi_message_dms_swi_get_current_firmware_output_get_boot_version (
    QmiMessageDmsSwiGetCurrentFirmwareOutput *self,
    const gchar **value_boot_version,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_boot_version_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Boot version' was not found in the message");
        return FALSE;
    }

    if (value_boot_version)
        *value_boot_version = self->arg_boot_version;

    return TRUE;
}

gboolean
qmi_message_dms_swi_get_current_firmware_output_get_amss_version (
    QmiMessageDmsSwiGetCurrentFirmwareOutput *self,
    const gchar **value_amss_version,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_amss_version_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'AMSS version' was not found in the message");
        return FALSE;
    }

    if (value_amss_version)
        *value_amss_version = self->arg_amss_version;

    return TRUE;
}

gboolean
qmi_message_dms_swi_get_current_firmware_output_get_sku_id (
    QmiMessageDmsSwiGetCurrentFirmwareOutput *self,
    const gchar **value_sku_id,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_sku_id_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'SKU ID' was not found in the message");
        return FALSE;
    }

    if (value_sku_id)
        *value_sku_id = self->arg_sku_id;

    return TRUE;
}

gboolean
qmi_message_dms_swi_get_current_firmware_output_get_package_id (
    QmiMessageDmsSwiGetCurrentFirmwareOutput *self,
    const gchar **value_package_id,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_package_id_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Package ID' was not found in the message");
        return FALSE;
    }

    if (value_package_id)
        *value_package_id = self->arg_package_id;

    return TRUE;
}

gboolean
qmi_message_dms_swi_get_current_firmware_output_get_carrier_id (
    QmiMessageDmsSwiGetCurrentFirmwareOutput *self,
    const gchar **value_carrier_id,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_carrier_id_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Carrier ID' was not found in the message");
        return FALSE;
    }

    if (value_carrier_id)
        *value_carrier_id = self->arg_carrier_id;

    return TRUE;
}

gboolean
qmi_message_dms_swi_get_current_firmware_output_get_pri_version (
    QmiMessageDmsSwiGetCurrentFirmwareOutput *self,
    const gchar **value_pri_version,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_pri_version_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'PRI version' was not found in the message");
        return FALSE;
    }

    if (value_pri_version)
        *value_pri_version = self->arg_pri_version;

    return TRUE;
}

gboolean
qmi_message_dms_swi_get_current_firmware_output_get_carrier (
    QmiMessageDmsSwiGetCurrentFirmwareOutput *self,
    const gchar **value_carrier,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_carrier_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Carrier' was not found in the message");
        return FALSE;
    }

    if (value_carrier)
        *value_carrier = self->arg_carrier;

    return TRUE;
}

gboolean
qmi_message_dms_swi_get_current_firmware_output_get_config_version (
    QmiMessageDmsSwiGetCurrentFirmwareOutput *self,
    const gchar **value_config_version,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_config_version_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Config version' was not found in the message");
        return FALSE;
    }

    if (value_config_version)
        *value_config_version = self->arg_config_version;

    return TRUE;
}

GType
qmi_message_dms_swi_get_current_firmware_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsSwiGetCurrentFirmwareOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_swi_get_current_firmware_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_swi_get_current_firmware_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsSwiGetCurrentFirmwareOutput *
qmi_message_dms_swi_get_current_firmware_output_ref (QmiMessageDmsSwiGetCurrentFirmwareOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_swi_get_current_firmware_output_unref (QmiMessageDmsSwiGetCurrentFirmwareOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_model, (GDestroyNotify)g_free);
        g_clear_pointer (&self->arg_boot_version, (GDestroyNotify)g_free);
        g_clear_pointer (&self->arg_amss_version, (GDestroyNotify)g_free);
        g_clear_pointer (&self->arg_sku_id, (GDestroyNotify)g_free);
        g_clear_pointer (&self->arg_package_id, (GDestroyNotify)g_free);
        g_clear_pointer (&self->arg_carrier_id, (GDestroyNotify)g_free);
        g_clear_pointer (&self->arg_pri_version, (GDestroyNotify)g_free);
        g_clear_pointer (&self->arg_carrier, (GDestroyNotify)g_free);
        g_clear_pointer (&self->arg_config_version, (GDestroyNotify)g_free);
        g_slice_free (QmiMessageDmsSwiGetCurrentFirmwareOutput, self);
    }
}

static gchar *
qmi_message_dms_swi_get_current_firmware_output_model_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SWI_GET_CURRENT_FIRMWARE_OUTPUT_TLV_MODEL, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &tmp, &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_swi_get_current_firmware_output_boot_version_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SWI_GET_CURRENT_FIRMWARE_OUTPUT_TLV_BOOT_VERSION, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &tmp, &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_swi_get_current_firmware_output_amss_version_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SWI_GET_CURRENT_FIRMWARE_OUTPUT_TLV_AMSS_VERSION, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &tmp, &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_swi_get_current_firmware_output_sku_id_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SWI_GET_CURRENT_FIRMWARE_OUTPUT_TLV_SKU_ID, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &tmp, &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_swi_get_current_firmware_output_package_id_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SWI_GET_CURRENT_FIRMWARE_OUTPUT_TLV_PACKAGE_ID, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &tmp, &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_swi_get_current_firmware_output_carrier_id_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SWI_GET_CURRENT_FIRMWARE_OUTPUT_TLV_CARRIER_ID, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &tmp, &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_swi_get_current_firmware_output_pri_version_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SWI_GET_CURRENT_FIRMWARE_OUTPUT_TLV_PRI_VERSION, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &tmp, &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_swi_get_current_firmware_output_carrier_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SWI_GET_CURRENT_FIRMWARE_OUTPUT_TLV_CARRIER, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &tmp, &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_swi_get_current_firmware_output_config_version_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SWI_GET_CURRENT_FIRMWARE_OUTPUT_TLV_CONFIG_VERSION, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &tmp, &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_swi_get_current_firmware_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_swi_get_current_firmware_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_swi_get_current_firmware_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_SWI_GET_CURRENT_FIRMWARE_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_SWI_GET_CURRENT_FIRMWARE_OUTPUT_TLV_MODEL:
            tlv_type_str = "Model";
            translated_value = qmi_message_dms_swi_get_current_firmware_output_model_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_SWI_GET_CURRENT_FIRMWARE_OUTPUT_TLV_BOOT_VERSION:
            tlv_type_str = "Boot version";
            translated_value = qmi_message_dms_swi_get_current_firmware_output_boot_version_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_SWI_GET_CURRENT_FIRMWARE_OUTPUT_TLV_AMSS_VERSION:
            tlv_type_str = "AMSS version";
            translated_value = qmi_message_dms_swi_get_current_firmware_output_amss_version_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_SWI_GET_CURRENT_FIRMWARE_OUTPUT_TLV_SKU_ID:
            tlv_type_str = "SKU ID";
            translated_value = qmi_message_dms_swi_get_current_firmware_output_sku_id_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_SWI_GET_CURRENT_FIRMWARE_OUTPUT_TLV_PACKAGE_ID:
            tlv_type_str = "Package ID";
            translated_value = qmi_message_dms_swi_get_current_firmware_output_package_id_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_SWI_GET_CURRENT_FIRMWARE_OUTPUT_TLV_CARRIER_ID:
            tlv_type_str = "Carrier ID";
            translated_value = qmi_message_dms_swi_get_current_firmware_output_carrier_id_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_SWI_GET_CURRENT_FIRMWARE_OUTPUT_TLV_PRI_VERSION:
            tlv_type_str = "PRI version";
            translated_value = qmi_message_dms_swi_get_current_firmware_output_pri_version_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_SWI_GET_CURRENT_FIRMWARE_OUTPUT_TLV_CARRIER:
            tlv_type_str = "Carrier";
            translated_value = qmi_message_dms_swi_get_current_firmware_output_carrier_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_SWI_GET_CURRENT_FIRMWARE_OUTPUT_TLV_CONFIG_VERSION:
            tlv_type_str = "Config version";
            translated_value = qmi_message_dms_swi_get_current_firmware_output_config_version_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_swi_get_current_firmware_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Swi Get Current Firmware\" (0x5556)\n",
                            line_prefix);

    {
        struct message_swi_get_current_firmware_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_swi_get_current_firmware_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsSwiGetCurrentFirmwareOutput *
qmi_message_dms_swi_get_current_firmware_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsSwiGetCurrentFirmwareOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_SWI_GET_CURRENT_FIRMWARE);

    self = g_slice_new0 (QmiMessageDmsSwiGetCurrentFirmwareOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SWI_GET_CURRENT_FIRMWARE_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_swi_get_current_firmware_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_swi_get_current_firmware_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SWI_GET_CURRENT_FIRMWARE_OUTPUT_TLV_MODEL, NULL, NULL)) == 0) {
                goto qmi_message_dms_swi_get_current_firmware_output_model_out;
            }
            if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &(self->arg_model), NULL))
                goto qmi_message_dms_swi_get_current_firmware_output_model_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Model' TLV", offset);
            }

            self->arg_model_set = TRUE;

qmi_message_dms_swi_get_current_firmware_output_model_out:
            ;

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SWI_GET_CURRENT_FIRMWARE_OUTPUT_TLV_BOOT_VERSION, NULL, NULL)) == 0) {
                goto qmi_message_dms_swi_get_current_firmware_output_boot_version_out;
            }
            if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &(self->arg_boot_version), NULL))
                goto qmi_message_dms_swi_get_current_firmware_output_boot_version_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Boot version' TLV", offset);
            }

            self->arg_boot_version_set = TRUE;

qmi_message_dms_swi_get_current_firmware_output_boot_version_out:
            ;

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SWI_GET_CURRENT_FIRMWARE_OUTPUT_TLV_AMSS_VERSION, NULL, NULL)) == 0) {
                goto qmi_message_dms_swi_get_current_firmware_output_amss_version_out;
            }
            if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &(self->arg_amss_version), NULL))
                goto qmi_message_dms_swi_get_current_firmware_output_amss_version_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'AMSS version' TLV", offset);
            }

            self->arg_amss_version_set = TRUE;

qmi_message_dms_swi_get_current_firmware_output_amss_version_out:
            ;

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SWI_GET_CURRENT_FIRMWARE_OUTPUT_TLV_SKU_ID, NULL, NULL)) == 0) {
                goto qmi_message_dms_swi_get_current_firmware_output_sku_id_out;
            }
            if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &(self->arg_sku_id), NULL))
                goto qmi_message_dms_swi_get_current_firmware_output_sku_id_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'SKU ID' TLV", offset);
            }

            self->arg_sku_id_set = TRUE;

qmi_message_dms_swi_get_current_firmware_output_sku_id_out:
            ;

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SWI_GET_CURRENT_FIRMWARE_OUTPUT_TLV_PACKAGE_ID, NULL, NULL)) == 0) {
                goto qmi_message_dms_swi_get_current_firmware_output_package_id_out;
            }
            if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &(self->arg_package_id), NULL))
                goto qmi_message_dms_swi_get_current_firmware_output_package_id_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Package ID' TLV", offset);
            }

            self->arg_package_id_set = TRUE;

qmi_message_dms_swi_get_current_firmware_output_package_id_out:
            ;

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SWI_GET_CURRENT_FIRMWARE_OUTPUT_TLV_CARRIER_ID, NULL, NULL)) == 0) {
                goto qmi_message_dms_swi_get_current_firmware_output_carrier_id_out;
            }
            if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &(self->arg_carrier_id), NULL))
                goto qmi_message_dms_swi_get_current_firmware_output_carrier_id_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Carrier ID' TLV", offset);
            }

            self->arg_carrier_id_set = TRUE;

qmi_message_dms_swi_get_current_firmware_output_carrier_id_out:
            ;

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SWI_GET_CURRENT_FIRMWARE_OUTPUT_TLV_PRI_VERSION, NULL, NULL)) == 0) {
                goto qmi_message_dms_swi_get_current_firmware_output_pri_version_out;
            }
            if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &(self->arg_pri_version), NULL))
                goto qmi_message_dms_swi_get_current_firmware_output_pri_version_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'PRI version' TLV", offset);
            }

            self->arg_pri_version_set = TRUE;

qmi_message_dms_swi_get_current_firmware_output_pri_version_out:
            ;

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SWI_GET_CURRENT_FIRMWARE_OUTPUT_TLV_CARRIER, NULL, NULL)) == 0) {
                goto qmi_message_dms_swi_get_current_firmware_output_carrier_out;
            }
            if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &(self->arg_carrier), NULL))
                goto qmi_message_dms_swi_get_current_firmware_output_carrier_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Carrier' TLV", offset);
            }

            self->arg_carrier_set = TRUE;

qmi_message_dms_swi_get_current_firmware_output_carrier_out:
            ;

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SWI_GET_CURRENT_FIRMWARE_OUTPUT_TLV_CONFIG_VERSION, NULL, NULL)) == 0) {
                goto qmi_message_dms_swi_get_current_firmware_output_config_version_out;
            }
            if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &(self->arg_config_version), NULL))
                goto qmi_message_dms_swi_get_current_firmware_output_config_version_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Config version' TLV", offset);
            }

            self->arg_config_version_set = TRUE;

qmi_message_dms_swi_get_current_firmware_output_config_version_out:
            ;

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS Swi Get USB Composition */


/* --- Input -- */

/* Note: no fields in the Input container */

static QmiMessage *
__qmi_message_dms_swi_get_usb_composition_request_create (
    guint16 transaction_id,
    guint8 cid,
    gpointer unused,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_DMS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_DMS_SWI_GET_USB_COMPOSITION);

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageDmsSwiGetUsbCompositionOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* Current */
    gboolean arg_current_set;
    guint8 arg_current;

    /* Supported */
    gboolean arg_supported_set;
    GArray *arg_supported;
};

#define QMI_MESSAGE_DMS_SWI_GET_USB_COMPOSITION_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_DMS_SWI_GET_USB_COMPOSITION_OUTPUT_TLV_CURRENT 0x10
#define QMI_MESSAGE_DMS_SWI_GET_USB_COMPOSITION_OUTPUT_TLV_SUPPORTED 0x11

gboolean
qmi_message_dms_swi_get_usb_composition_output_get_result (
    QmiMessageDmsSwiGetUsbCompositionOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_dms_swi_get_usb_composition_output_get_current (
    QmiMessageDmsSwiGetUsbCompositionOutput *self,
    QmiDmsSwiUsbComposition *value_current,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_current_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Current' was not found in the message");
        return FALSE;
    }

    if (value_current)
        *value_current = (QmiDmsSwiUsbComposition)(self->arg_current);

    return TRUE;
}

gboolean
qmi_message_dms_swi_get_usb_composition_output_get_supported (
    QmiMessageDmsSwiGetUsbCompositionOutput *self,
    GArray **value_supported,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_supported_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Supported' was not found in the message");
        return FALSE;
    }

    if (value_supported)
        *value_supported = self->arg_supported;

    return TRUE;
}

GType
qmi_message_dms_swi_get_usb_composition_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageDmsSwiGetUsbCompositionOutput"),
                                          (GBoxedCopyFunc) qmi_message_dms_swi_get_usb_composition_output_ref,
                                          (GBoxedFreeFunc) qmi_message_dms_swi_get_usb_composition_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageDmsSwiGetUsbCompositionOutput *
qmi_message_dms_swi_get_usb_composition_output_ref (QmiMessageDmsSwiGetUsbCompositionOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_dms_swi_get_usb_composition_output_unref (QmiMessageDmsSwiGetUsbCompositionOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_supported, (GDestroyNotify)g_array_unref);
        g_slice_free (QmiMessageDmsSwiGetUsbCompositionOutput, self);
    }
}

static gchar *
qmi_message_dms_swi_get_usb_composition_output_current_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SWI_GET_USB_COMPOSITION_OUTPUT_TLV_CURRENT, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_DMS_SWI_USB_COMPOSITION_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_dms_swi_usb_composition_get_string ((QmiDmsSwiUsbComposition)tmp));
#elif defined  __QMI_DMS_SWI_USB_COMPOSITION_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_dms_swi_usb_composition_build_string_from_mask ((QmiDmsSwiUsbComposition)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiDmsSwiUsbComposition
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_dms_swi_get_usb_composition_output_supported_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SWI_GET_USB_COMPOSITION_OUTPUT_TLV_SUPPORTED, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    {
        guint supported_i;
        guint8 supported_n_items;

        /* Read number of items in the array */
        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(supported_n_items), &error))
            goto out;

        g_string_append (printable, "{");

        for (supported_i = 0; supported_i < supported_n_items; supported_i++) {
            g_string_append_printf (printable, " [%u] = '", supported_i);

            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
#if defined  __QMI_DMS_SWI_USB_COMPOSITION_IS_ENUM__
                    g_string_append_printf (printable, "%s", qmi_dms_swi_usb_composition_get_string ((QmiDmsSwiUsbComposition)tmp));
#elif defined  __QMI_DMS_SWI_USB_COMPOSITION_IS_FLAGS__
                    {
                        g_autofree gchar *flags_str = NULL;

                        flags_str = qmi_dms_swi_usb_composition_build_string_from_mask ((QmiDmsSwiUsbComposition)tmp);
                        g_string_append_printf (printable, "%s", flags_str);
                    }
#else
# error unexpected public format: QmiDmsSwiUsbComposition
#endif
                }
            }
            g_string_append (printable, "'");
        }

        g_string_append (printable, "}");
    }
    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_swi_get_usb_composition_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_swi_get_usb_composition_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_swi_get_usb_composition_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_DMS_SWI_GET_USB_COMPOSITION_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_SWI_GET_USB_COMPOSITION_OUTPUT_TLV_CURRENT:
            tlv_type_str = "Current";
            translated_value = qmi_message_dms_swi_get_usb_composition_output_current_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_DMS_SWI_GET_USB_COMPOSITION_OUTPUT_TLV_SUPPORTED:
            tlv_type_str = "Supported";
            translated_value = qmi_message_dms_swi_get_usb_composition_output_supported_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_swi_get_usb_composition_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Swi Get USB Composition\" (0x555B)\n",
                            line_prefix);

    {
        struct message_swi_get_usb_composition_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_swi_get_usb_composition_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageDmsSwiGetUsbCompositionOutput *
qmi_message_dms_swi_get_usb_composition_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageDmsSwiGetUsbCompositionOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_DMS_SWI_GET_USB_COMPOSITION);

    self = g_slice_new0 (QmiMessageDmsSwiGetUsbCompositionOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SWI_GET_USB_COMPOSITION_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_dms_swi_get_usb_composition_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_dms_swi_get_usb_composition_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SWI_GET_USB_COMPOSITION_OUTPUT_TLV_CURRENT, NULL, NULL)) == 0) {
                goto qmi_message_dms_swi_get_usb_composition_output_current_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_message_dms_swi_get_usb_composition_output_current_out;
                self->arg_current = (QmiDmsSwiUsbComposition)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Current' TLV", offset);
            }

            self->arg_current_set = TRUE;

qmi_message_dms_swi_get_usb_composition_output_current_out:
            ;

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_DMS_SWI_GET_USB_COMPOSITION_OUTPUT_TLV_SUPPORTED, NULL, NULL)) == 0) {
                goto qmi_message_dms_swi_get_usb_composition_output_supported_out;
            }
            {
                guint supported_i;
                guint8 supported_n_items;

                /* Read number of items in the array */
                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(supported_n_items), NULL))
                    goto qmi_message_dms_swi_get_usb_composition_output_supported_out;

                self->arg_supported = g_array_sized_new (
                    FALSE,
                    FALSE,
                    sizeof (QmiDmsSwiUsbComposition),
                    (guint)supported_n_items);

                for (supported_i = 0; supported_i < supported_n_items; supported_i++) {
                    QmiDmsSwiUsbComposition supported_aux;

                    {
                        guint8 tmp;

                        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                            goto qmi_message_dms_swi_get_usb_composition_output_supported_out;
                        supported_aux = (QmiDmsSwiUsbComposition)tmp;
                    }
                    g_array_insert_val (self->arg_supported, supported_i, supported_aux);
                }
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Supported' TLV", offset);
            }

            self->arg_supported_set = TRUE;

qmi_message_dms_swi_get_usb_composition_output_supported_out:
            ;

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message DMS Swi Set USB Composition */


/* --- Input -- */

struct _QmiMessageDmsSwiSetUsbCompositionInput {
    volatile gint ref_count;

    /* Current */
    gboolean arg_current_set;
    guint8 arg_current;
};

#define QMI_MESSAGE_DMS_SWI_SET_USB_COMPOSITION_INPUT_TLV_CURRENT 0x01

gboolean
qmi_message_dms_swi_set_usb_composition_input_get_current (
    QmiMessageDmsSwiSetUsbCompositionInput *self,
    QmiDmsSwiUsbComposition 