#pragma once

#include "nv_push_clcab5.h"
#include "nv_push_clc9b5.h"
#include "nv_push_clc8b5.h"
#include "nv_push_clc7b5.h"
#include "nv_push_clc6b5.h"
#include "nv_push_clc5b5.h"
#include "nv_push_clc3b5.h"
#include "nv_push_clc1b5.h"
#include "nv_push_clc0b5.h"
#include "nv_push_clb0b5.h"
#include "nv_push_cla0b5.h"
#include "nv_push_cl90b5.h"
#include "nv_push_cl85b5.h"
#include "nv_push_cl902d.h"
#include "nv_push_cl9039.h"
#include "nv_push_clca6f.h"
#include "nv_push_clc96f.h"
#include "nv_push_clc86f.h"
#include "nv_push_clc56f.h"
#include "nv_push_clc46f.h"
#include "nv_push_clc36f.h"
#include "nv_push_clc06f.h"
#include "nv_push_clb06f.h"
#include "nv_push_cla26f.h"
#include "nv_push_cla16f.h"
#include "nv_push_cla06f.h"
#include "nv_push_cl906f.h"
#include "nv_push_clce97.h"
#include "nv_push_clcd97.h"
#include "nv_push_clcb97.h"
#include "nv_push_clc997.h"
#include "nv_push_clc797.h"
#include "nv_push_clc697.h"
#include "nv_push_clc597.h"
#include "nv_push_clc397.h"
#include "nv_push_clc197.h"
#include "nv_push_clc097.h"
#include "nv_push_clb197.h"
#include "nv_push_clb097.h"
#include "nv_push_cla297.h"
#include "nv_push_cla197.h"
#include "nv_push_cla097.h"
#include "nv_push_cl9297.h"
#include "nv_push_cl9097.h"
#include "nv_push_clcec0.h"
#include "nv_push_clcdc0.h"
#include "nv_push_clcbc0.h"
#include "nv_push_clc9c0.h"
#include "nv_push_clc7c0.h"
#include "nv_push_clc6c0.h"
#include "nv_push_clc5c0.h"
#include "nv_push_clc3c0.h"
#include "nv_push_clc1c0.h"
#include "nv_push_clc0c0.h"
#include "nv_push_clb1c0.h"
#include "nv_push_clb0c0.h"
#include "nv_push_cla1c0.h"
#include "nv_push_cla0c0.h"
#include "nv_push_cl91c0.h"
#include "nv_push_cl90c0.h"
#include "nv_push_cla140.h"
#include "nv_push_cla040.h"
#include "nv_push_clc9b0.h"
#include "nv_push_clc7b0.h"
#include "nv_push_clc5b0.h"


static inline const char*
P_PARSE_NV_MTHD(uint16_t class_id, uint16_t idx)
{
    uint16_t cls_hi = (class_id & 0xff00) >> 8;
    uint16_t cls_lo = class_id & 0xff;

    if (idx < 0x100) {
        if (cls_hi >= 0xca)
            return P_PARSE_NVCA6F_MTHD(idx);
        else
        if (cls_hi >= 0xc9)
            return P_PARSE_NVC96F_MTHD(idx);
        else
        if (cls_hi >= 0xc8)
            return P_PARSE_NVC86F_MTHD(idx);
        else
        if (cls_hi >= 0xc5)
            return P_PARSE_NVC56F_MTHD(idx);
        else
        if (cls_hi >= 0xc4)
            return P_PARSE_NVC46F_MTHD(idx);
        else
        if (cls_hi >= 0xc3)
            return P_PARSE_NVC36F_MTHD(idx);
        else
        if (cls_hi >= 0xc0)
            return P_PARSE_NVC06F_MTHD(idx);
        else
        if (cls_hi >= 0xb0)
            return P_PARSE_NVB06F_MTHD(idx);
        else
        if (cls_hi >= 0xa2)
            return P_PARSE_NVA26F_MTHD(idx);
        else
        if (cls_hi >= 0xa1)
            return P_PARSE_NVA16F_MTHD(idx);
        else
        if (cls_hi >= 0xa0)
            return P_PARSE_NVA06F_MTHD(idx);
        else
        if (cls_hi >= 0x90)
            return P_PARSE_NV906F_MTHD(idx);
        else
        {
            assert(false && "unknown class id");
        }

    } else {
        switch (cls_lo) {
            case 0xb5:
                if (cls_hi >= 0xca)
                    return P_PARSE_NVCAB5_MTHD(idx);
                else
                if (cls_hi >= 0xc9)
                    return P_PARSE_NVC9B5_MTHD(idx);
                else
                if (cls_hi >= 0xc8)
                    return P_PARSE_NVC8B5_MTHD(idx);
                else
                if (cls_hi >= 0xc7)
                    return P_PARSE_NVC7B5_MTHD(idx);
                else
                if (cls_hi >= 0xc6)
                    return P_PARSE_NVC6B5_MTHD(idx);
                else
                if (cls_hi >= 0xc5)
                    return P_PARSE_NVC5B5_MTHD(idx);
                else
                if (cls_hi >= 0xc3)
                    return P_PARSE_NVC3B5_MTHD(idx);
                else
                if (cls_hi >= 0xc1)
                    return P_PARSE_NVC1B5_MTHD(idx);
                else
                if (cls_hi >= 0xc0)
                    return P_PARSE_NVC0B5_MTHD(idx);
                else
                if (cls_hi >= 0xb0)
                    return P_PARSE_NVB0B5_MTHD(idx);
                else
                if (cls_hi >= 0xa0)
                    return P_PARSE_NVA0B5_MTHD(idx);
                else
                if (cls_hi >= 0x90)
                    return P_PARSE_NV90B5_MTHD(idx);
                else
                if (cls_hi >= 0x85)
                    return P_PARSE_NV85B5_MTHD(idx);
                else
                {
                    assert(false && "unknown class id");
                }
                break;
            case 0x2d:
                return P_PARSE_NV902D_MTHD(idx);
            case 0x39:
                return P_PARSE_NV9039_MTHD(idx);
            case 0x6f:
                if (cls_hi >= 0xca)
                    return P_PARSE_NVCA6F_MTHD(idx);
                else
                if (cls_hi >= 0xc9)
                    return P_PARSE_NVC96F_MTHD(idx);
                else
                if (cls_hi >= 0xc8)
                    return P_PARSE_NVC86F_MTHD(idx);
                else
                if (cls_hi >= 0xc5)
                    return P_PARSE_NVC56F_MTHD(idx);
                else
                if (cls_hi >= 0xc4)
                    return P_PARSE_NVC46F_MTHD(idx);
                else
                if (cls_hi >= 0xc3)
                    return P_PARSE_NVC36F_MTHD(idx);
                else
                if (cls_hi >= 0xc0)
                    return P_PARSE_NVC06F_MTHD(idx);
                else
                if (cls_hi >= 0xb0)
                    return P_PARSE_NVB06F_MTHD(idx);
                else
                if (cls_hi >= 0xa2)
                    return P_PARSE_NVA26F_MTHD(idx);
                else
                if (cls_hi >= 0xa1)
                    return P_PARSE_NVA16F_MTHD(idx);
                else
                if (cls_hi >= 0xa0)
                    return P_PARSE_NVA06F_MTHD(idx);
                else
                if (cls_hi >= 0x90)
                    return P_PARSE_NV906F_MTHD(idx);
                else
                {
                    assert(false && "unknown class id");
                }
                break;
            case 0x97:
                if (cls_hi >= 0xce)
                    return P_PARSE_NVCE97_MTHD(idx);
                else
                if (cls_hi >= 0xcd)
                    return P_PARSE_NVCD97_MTHD(idx);
                else
                if (cls_hi >= 0xcb)
                    return P_PARSE_NVCB97_MTHD(idx);
                else
                if (cls_hi >= 0xc9)
                    return P_PARSE_NVC997_MTHD(idx);
                else
                if (cls_hi >= 0xc7)
                    return P_PARSE_NVC797_MTHD(idx);
                else
                if (cls_hi >= 0xc6)
                    return P_PARSE_NVC697_MTHD(idx);
                else
                if (cls_hi >= 0xc5)
                    return P_PARSE_NVC597_MTHD(idx);
                else
                if (cls_hi >= 0xc3)
                    return P_PARSE_NVC397_MTHD(idx);
                else
                if (cls_hi >= 0xc1)
                    return P_PARSE_NVC197_MTHD(idx);
                else
                if (cls_hi >= 0xc0)
                    return P_PARSE_NVC097_MTHD(idx);
                else
                if (cls_hi >= 0xb1)
                    return P_PARSE_NVB197_MTHD(idx);
                else
                if (cls_hi >= 0xb0)
                    return P_PARSE_NVB097_MTHD(idx);
                else
                if (cls_hi >= 0xa2)
                    return P_PARSE_NVA297_MTHD(idx);
                else
                if (cls_hi >= 0xa1)
                    return P_PARSE_NVA197_MTHD(idx);
                else
                if (cls_hi >= 0xa0)
                    return P_PARSE_NVA097_MTHD(idx);
                else
                if (cls_hi >= 0x92)
                    return P_PARSE_NV9297_MTHD(idx);
                else
                if (cls_hi >= 0x90)
                    return P_PARSE_NV9097_MTHD(idx);
                else
                {
                    assert(false && "unknown class id");
                }
                break;
            case 0xc0:
                if (cls_hi >= 0xce)
                    return P_PARSE_NVCEC0_MTHD(idx);
                else
                if (cls_hi >= 0xcd)
                    return P_PARSE_NVCDC0_MTHD(idx);
                else
                if (cls_hi >= 0xcb)
                    return P_PARSE_NVCBC0_MTHD(idx);
                else
                if (cls_hi >= 0xc9)
                    return P_PARSE_NVC9C0_MTHD(idx);
                else
                if (cls_hi >= 0xc7)
                    return P_PARSE_NVC7C0_MTHD(idx);
                else
                if (cls_hi >= 0xc6)
                    return P_PARSE_NVC6C0_MTHD(idx);
                else
                if (cls_hi >= 0xc5)
                    return P_PARSE_NVC5C0_MTHD(idx);
                else
                if (cls_hi >= 0xc3)
                    return P_PARSE_NVC3C0_MTHD(idx);
                else
                if (cls_hi >= 0xc1)
                    return P_PARSE_NVC1C0_MTHD(idx);
                else
                if (cls_hi >= 0xc0)
                    return P_PARSE_NVC0C0_MTHD(idx);
                else
                if (cls_hi >= 0xb1)
                    return P_PARSE_NVB1C0_MTHD(idx);
                else
                if (cls_hi >= 0xb0)
                    return P_PARSE_NVB0C0_MTHD(idx);
                else
                if (cls_hi >= 0xa1)
                    return P_PARSE_NVA1C0_MTHD(idx);
                else
                if (cls_hi >= 0xa0)
                    return P_PARSE_NVA0C0_MTHD(idx);
                else
                if (cls_hi >= 0x91)
                    return P_PARSE_NV91C0_MTHD(idx);
                else
                if (cls_hi >= 0x90)
                    return P_PARSE_NV90C0_MTHD(idx);
                else
                {
                    assert(false && "unknown class id");
                }
                break;
            case 0x40:
                if (cls_hi >= 0xa1)
                    return P_PARSE_NVA140_MTHD(idx);
                else
                if (cls_hi >= 0xa0)
                    return P_PARSE_NVA040_MTHD(idx);
                else
                {
                    assert(false && "unknown class id");
                }
                break;
            case 0xb0:
                if (cls_hi >= 0xc9)
                    return P_PARSE_NVC9B0_MTHD(idx);
                else
                if (cls_hi >= 0xc7)
                    return P_PARSE_NVC7B0_MTHD(idx);
                else
                if (cls_hi >= 0xc5)
                    return P_PARSE_NVC5B0_MTHD(idx);
                else
                {
                    assert(false && "unknown class id");
                }
                break;
            default:
                break;
        }
    }

    return "unknown method";
}

static inline void
P_DUMP_NV_MTHD_DATA(FILE *fp, uint16_t class_id, uint16_t idx, uint32_t data,
                    const char *prefix)
{
    uint16_t cls_hi = (class_id & 0xff00) >> 8;
    uint16_t cls_lo = class_id & 0xff;

    if (idx < 0x100) {
        if (cls_hi >= 0xca)
            P_DUMP_NVCA6F_MTHD_DATA(fp, idx, data, prefix);
        else
        if (cls_hi >= 0xc9)
            P_DUMP_NVC96F_MTHD_DATA(fp, idx, data, prefix);
        else
        if (cls_hi >= 0xc8)
            P_DUMP_NVC86F_MTHD_DATA(fp, idx, data, prefix);
        else
        if (cls_hi >= 0xc5)
            P_DUMP_NVC56F_MTHD_DATA(fp, idx, data, prefix);
        else
        if (cls_hi >= 0xc4)
            P_DUMP_NVC46F_MTHD_DATA(fp, idx, data, prefix);
        else
        if (cls_hi >= 0xc3)
            P_DUMP_NVC36F_MTHD_DATA(fp, idx, data, prefix);
        else
        if (cls_hi >= 0xc0)
            P_DUMP_NVC06F_MTHD_DATA(fp, idx, data, prefix);
        else
        if (cls_hi >= 0xb0)
            P_DUMP_NVB06F_MTHD_DATA(fp, idx, data, prefix);
        else
        if (cls_hi >= 0xa2)
            P_DUMP_NVA26F_MTHD_DATA(fp, idx, data, prefix);
        else
        if (cls_hi >= 0xa1)
            P_DUMP_NVA16F_MTHD_DATA(fp, idx, data, prefix);
        else
        if (cls_hi >= 0xa0)
            P_DUMP_NVA06F_MTHD_DATA(fp, idx, data, prefix);
        else
        if (cls_hi >= 0x90)
            P_DUMP_NV906F_MTHD_DATA(fp, idx, data, prefix);
        else
        {
            assert(false && "unknown class id");
        }
    } else {
        switch (cls_lo) {
            case 0xb5:
                if (cls_hi >= 0xca)
                    P_DUMP_NVCAB5_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xc9)
                    P_DUMP_NVC9B5_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xc8)
                    P_DUMP_NVC8B5_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xc7)
                    P_DUMP_NVC7B5_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xc6)
                    P_DUMP_NVC6B5_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xc5)
                    P_DUMP_NVC5B5_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xc3)
                    P_DUMP_NVC3B5_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xc1)
                    P_DUMP_NVC1B5_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xc0)
                    P_DUMP_NVC0B5_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xb0)
                    P_DUMP_NVB0B5_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xa0)
                    P_DUMP_NVA0B5_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0x90)
                    P_DUMP_NV90B5_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0x85)
                    P_DUMP_NV85B5_MTHD_DATA(fp, idx, data, prefix);
                else
                {
                    assert(false && "unknown class id");
                }
                break;
            case 0x2d:
                P_DUMP_NV902D_MTHD_DATA(fp, idx, data, prefix);
                break;
            case 0x39:
                P_DUMP_NV9039_MTHD_DATA(fp, idx, data, prefix);
                break;
            case 0x6f:
                if (cls_hi >= 0xca)
                    P_DUMP_NVCA6F_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xc9)
                    P_DUMP_NVC96F_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xc8)
                    P_DUMP_NVC86F_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xc5)
                    P_DUMP_NVC56F_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xc4)
                    P_DUMP_NVC46F_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xc3)
                    P_DUMP_NVC36F_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xc0)
                    P_DUMP_NVC06F_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xb0)
                    P_DUMP_NVB06F_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xa2)
                    P_DUMP_NVA26F_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xa1)
                    P_DUMP_NVA16F_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xa0)
                    P_DUMP_NVA06F_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0x90)
                    P_DUMP_NV906F_MTHD_DATA(fp, idx, data, prefix);
                else
                {
                    assert(false && "unknown class id");
                }
                break;
            case 0x97:
                if (cls_hi >= 0xce)
                    P_DUMP_NVCE97_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xcd)
                    P_DUMP_NVCD97_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xcb)
                    P_DUMP_NVCB97_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xc9)
                    P_DUMP_NVC997_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xc7)
                    P_DUMP_NVC797_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xc6)
                    P_DUMP_NVC697_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xc5)
                    P_DUMP_NVC597_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xc3)
                    P_DUMP_NVC397_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xc1)
                    P_DUMP_NVC197_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xc0)
                    P_DUMP_NVC097_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xb1)
                    P_DUMP_NVB197_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xb0)
                    P_DUMP_NVB097_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xa2)
                    P_DUMP_NVA297_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xa1)
                    P_DUMP_NVA197_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xa0)
                    P_DUMP_NVA097_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0x92)
                    P_DUMP_NV9297_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0x90)
                    P_DUMP_NV9097_MTHD_DATA(fp, idx, data, prefix);
                else
                {
                    assert(false && "unknown class id");
                }
                break;
            case 0xc0:
                if (cls_hi >= 0xce)
                    P_DUMP_NVCEC0_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xcd)
                    P_DUMP_NVCDC0_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xcb)
                    P_DUMP_NVCBC0_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xc9)
                    P_DUMP_NVC9C0_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xc7)
                    P_DUMP_NVC7C0_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xc6)
                    P_DUMP_NVC6C0_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xc5)
                    P_DUMP_NVC5C0_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xc3)
                    P_DUMP_NVC3C0_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xc1)
                    P_DUMP_NVC1C0_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xc0)
                    P_DUMP_NVC0C0_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xb1)
                    P_DUMP_NVB1C0_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xb0)
                    P_DUMP_NVB0C0_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xa1)
                    P_DUMP_NVA1C0_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xa0)
                    P_DUMP_NVA0C0_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0x91)
                    P_DUMP_NV91C0_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0x90)
                    P_DUMP_NV90C0_MTHD_DATA(fp, idx, data, prefix);
                else
                {
                    assert(false && "unknown class id");
                }
                break;
            case 0x40:
                if (cls_hi >= 0xa1)
                    P_DUMP_NVA140_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xa0)
                    P_DUMP_NVA040_MTHD_DATA(fp, idx, data, prefix);
                else
                {
                    assert(false && "unknown class id");
                }
                break;
            case 0xb0:
                if (cls_hi >= 0xc9)
                    P_DUMP_NVC9B0_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xc7)
                    P_DUMP_NVC7B0_MTHD_DATA(fp, idx, data, prefix);
                else
                if (cls_hi >= 0xc5)
                    P_DUMP_NVC5B0_MTHD_DATA(fp, idx, data, prefix);
                else
                {
                    assert(false && "unknown class id");
                }
                break;
            default:
                fprintf(fp, "%s.VALUE = 0x%x\n", prefix, data);
                break;
        }
    }
}
