/*
   Copyright The containerd Authors.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/

package checkpoint

import (
	"github.com/spf13/cobra"

	"github.com/containerd/nerdctl/v2/cmd/nerdctl/helpers"
)

func Command() *cobra.Command {
	cmd := &cobra.Command{
		Annotations:   map[string]string{helpers.Category: helpers.Management},
		Use:           "checkpoint",
		Short:         "Manage checkpoints.",
		RunE:          helpers.UnknownSubcommandAction,
		SilenceUsage:  true,
		SilenceErrors: true,
	}

	cmd.AddCommand(
		createCommand(),
		lsCommand(),
		rmCommand(),
	)

	return cmd
}

func lsCommand() *cobra.Command {
	x := listCommand()
	x.Use = "ls"
	x.Aliases = []string{"list"}
	return x
}
func rmCommand() *cobra.Command {
	x := removeCommand()
	x.Use = "rm"
	x.Aliases = []string{"remove"}
	return x
}
