/* Interfaces.c generated by valac 0.56.17, the Vala compiler
 * generated from Interfaces.vala, do not modify */

/*-
 * Copyright (c) 2017 elementary LLC.
 * Copyright (C) 2017 David Hewitt <davidmhewitt@gmail.com>   
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Authored by: David Hewitt <davidmhewitt@gmail.com>
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gclue-enums.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define AG_TYPE_GEO_CLUE2_MANAGER (ag_geo_clue2_manager_get_type ())
#define AG_GEO_CLUE2_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AG_TYPE_GEO_CLUE2_MANAGER, AgGeoClue2Manager))
#define AG_IS_GEO_CLUE2_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AG_TYPE_GEO_CLUE2_MANAGER))
#define AG_GEO_CLUE2_MANAGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), AG_TYPE_GEO_CLUE2_MANAGER, AgGeoClue2ManagerIface))

typedef struct _AgGeoClue2Manager AgGeoClue2Manager;
typedef struct _AgGeoClue2ManagerIface AgGeoClue2ManagerIface;

#define AG_TYPE_GEO_CLUE2_MANAGER_PROXY (ag_geo_clue2_manager_proxy_get_type ())
typedef GDBusProxy AgGeoClue2ManagerProxy;
typedef GDBusProxyClass AgGeoClue2ManagerProxyClass;
typedef struct _AgGeoClue2ManagerAddAgentReadyData AgGeoClue2ManagerAddAgentReadyData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _AgGeoClue2ManagerGetClientReadyData AgGeoClue2ManagerGetClientReadyData;

#define AG_TYPE_GEO_CLUE2_AGENT (ag_geo_clue2_agent_get_type ())
#define AG_GEO_CLUE2_AGENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AG_TYPE_GEO_CLUE2_AGENT, AgGeoClue2Agent))
#define AG_IS_GEO_CLUE2_AGENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AG_TYPE_GEO_CLUE2_AGENT))
#define AG_GEO_CLUE2_AGENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), AG_TYPE_GEO_CLUE2_AGENT, AgGeoClue2AgentIface))

typedef struct _AgGeoClue2Agent AgGeoClue2Agent;
typedef struct _AgGeoClue2AgentIface AgGeoClue2AgentIface;

#define AG_TYPE_GEO_CLUE2_AGENT_PROXY (ag_geo_clue2_agent_proxy_get_type ())
typedef GDBusProxy AgGeoClue2AgentProxy;
typedef GDBusProxyClass AgGeoClue2AgentProxyClass;
typedef struct _AgGeoClue2AgentAuthorizeAppReadyData AgGeoClue2AgentAuthorizeAppReadyData;

#define AG_TYPE_GEO_CLUE2_CLIENT (ag_geo_clue2_client_get_type ())
#define AG_GEO_CLUE2_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AG_TYPE_GEO_CLUE2_CLIENT, AgGeoClue2Client))
#define AG_IS_GEO_CLUE2_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AG_TYPE_GEO_CLUE2_CLIENT))
#define AG_GEO_CLUE2_CLIENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), AG_TYPE_GEO_CLUE2_CLIENT, AgGeoClue2ClientIface))

typedef struct _AgGeoClue2Client AgGeoClue2Client;
typedef struct _AgGeoClue2ClientIface AgGeoClue2ClientIface;

#define AG_TYPE_GEO_CLUE2_CLIENT_PROXY (ag_geo_clue2_client_proxy_get_type ())
typedef GDBusProxy AgGeoClue2ClientProxy;
typedef GDBusProxyClass AgGeoClue2ClientProxyClass;

struct _AgGeoClue2ManagerIface {
	GTypeInterface parent_iface;
	void (*add_agent) (AgGeoClue2Manager* self, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_agent_finish) (AgGeoClue2Manager* self, GAsyncResult* _res_, GError** error);
	void (*get_client) (AgGeoClue2Manager* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	char* (*get_client_finish) (AgGeoClue2Manager* self, GAsyncResult* _res_, GError** error);
};

struct _AgGeoClue2ManagerAddAgentReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar* id;
};

struct _AgGeoClue2ManagerGetClientReadyData {
	GDBusMethodInvocation* _invocation_;
};

struct _AgGeoClue2AgentIface {
	GTypeInterface parent_iface;
	void (*authorize_app) (AgGeoClue2Agent* self, const gchar* desktop_id, GClueAccuracyLevel req_accuracy_level, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*authorize_app_finish) (AgGeoClue2Agent* self, GAsyncResult* _res_, gboolean* authorized, GClueAccuracyLevel* allowed_accuracy_level, GError** error);
	GClueAccuracyLevel (*get_max_accuracy_level) (AgGeoClue2Agent* self);
};

struct _AgGeoClue2AgentAuthorizeAppReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar* desktop_id;
	GClueAccuracyLevel req_accuracy_level;
};

struct _AgGeoClue2ClientIface {
	GTypeInterface parent_iface;
	void (*start) (AgGeoClue2Client* self, GError** error);
	void (*stop) (AgGeoClue2Client* self, GError** error);
	gchar* (*get_desktop_id) (AgGeoClue2Client* self);
	void (*set_desktop_id) (AgGeoClue2Client* self, const gchar* value);
};

VALA_EXTERN GType ag_geo_clue2_manager_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint ag_geo_clue2_manager_register_object (void* object,
                                            GDBusConnection* connection,
                                            const gchar* path,
                                            GError** error);
VALA_EXTERN GType ag_geo_clue2_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AgGeoClue2Manager, g_object_unref)
VALA_EXTERN void ag_geo_clue2_manager_add_agent (AgGeoClue2Manager* self,
                                     const gchar* id,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
VALA_EXTERN void ag_geo_clue2_manager_add_agent_finish (AgGeoClue2Manager* self,
                                            GAsyncResult* _res_,
                                            GError** error);
VALA_EXTERN void ag_geo_clue2_manager_get_client (AgGeoClue2Manager* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
VALA_EXTERN char* ag_geo_clue2_manager_get_client_finish (AgGeoClue2Manager* self,
                                              GAsyncResult* _res_,
                                              GError** error);
static GType ag_geo_clue2_manager_get_type_once (void);
static void ag_geo_clue2_manager_proxy_g_signal (GDBusProxy* proxy,
                                          const gchar* sender_name,
                                          const gchar* signal_name,
                                          GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object,
                                   GAsyncResult *res,
                                   void *user_data);
static void ag_geo_clue2_manager_proxy_add_agent_async (AgGeoClue2Manager* self,
                                                 const gchar* id,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
static void ag_geo_clue2_manager_proxy_add_agent_finish (AgGeoClue2Manager* self,
                                                  GAsyncResult* _res_,
                                                  GError** error);
static void ag_geo_clue2_manager_proxy_get_client_async (AgGeoClue2Manager* self,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_);
static char* ag_geo_clue2_manager_proxy_get_client_finish (AgGeoClue2Manager* self,
                                                    GAsyncResult* _res_,
                                                    GError** error);
static void ag_geo_clue2_manager_proxy_ag_geo_clue2_manager_interface_init (AgGeoClue2ManagerIface* iface);
static void _dbus_ag_geo_clue2_manager_add_agent (AgGeoClue2Manager* self,
                                           GVariant* _parameters_,
                                           GDBusMethodInvocation* invocation);
static void _dbus_ag_geo_clue2_manager_add_agent_ready (GObject * source_object,
                                                 GAsyncResult * _res_,
                                                 gpointer _user_data_);
static void _dbus_ag_geo_clue2_manager_get_client (AgGeoClue2Manager* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation);
static void _dbus_ag_geo_clue2_manager_get_client_ready (GObject * source_object,
                                                  GAsyncResult * _res_,
                                                  gpointer _user_data_);
static void ag_geo_clue2_manager_dbus_interface_method_call (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* method_name,
                                                      GVariant* parameters,
                                                      GDBusMethodInvocation* invocation,
                                                      gpointer user_data);
static GVariant* ag_geo_clue2_manager_dbus_interface_get_property (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* property_name,
                                                            GError** error,
                                                            gpointer user_data);
static gboolean ag_geo_clue2_manager_dbus_interface_set_property (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* property_name,
                                                           GVariant* value,
                                                           GError** error,
                                                           gpointer user_data);
static void _ag_geo_clue2_manager_unregister_object (gpointer user_data);
VALA_EXTERN GType ag_geo_clue2_agent_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint ag_geo_clue2_agent_register_object (void* object,
                                          GDBusConnection* connection,
                                          const gchar* path,
                                          GError** error);
VALA_EXTERN GType ag_geo_clue2_agent_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AgGeoClue2Agent, g_object_unref)
VALA_EXTERN void ag_geo_clue2_agent_authorize_app (AgGeoClue2Agent* self,
                                       const gchar* desktop_id,
                                       GClueAccuracyLevel req_accuracy_level,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
VALA_EXTERN void ag_geo_clue2_agent_authorize_app_finish (AgGeoClue2Agent* self,
                                              GAsyncResult* _res_,
                                              gboolean* authorized,
                                              GClueAccuracyLevel* allowed_accuracy_level,
                                              GError** error);
VALA_EXTERN GClueAccuracyLevel ag_geo_clue2_agent_get_max_accuracy_level (AgGeoClue2Agent* self);
static GType ag_geo_clue2_agent_get_type_once (void);
static void ag_geo_clue2_agent_proxy_g_signal (GDBusProxy* proxy,
                                        const gchar* sender_name,
                                        const gchar* signal_name,
                                        GVariant* parameters);
static void ag_geo_clue2_agent_proxy_authorize_app_async (AgGeoClue2Agent* self,
                                                   const gchar* desktop_id,
                                                   GClueAccuracyLevel req_accuracy_level,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
static void ag_geo_clue2_agent_proxy_authorize_app_finish (AgGeoClue2Agent* self,
                                                    GAsyncResult* _res_,
                                                    gboolean* authorized,
                                                    GClueAccuracyLevel* allowed_accuracy_level,
                                                    GError** error);
static GClueAccuracyLevel ag_geo_clue2_agent_dbus_proxy_get_max_accuracy_level (AgGeoClue2Agent* self);
static void ag_geo_clue2_agent_proxy_ag_geo_clue2_agent_interface_init (AgGeoClue2AgentIface* iface);
static void _dbus_ag_geo_clue2_agent_authorize_app (AgGeoClue2Agent* self,
                                             GVariant* _parameters_,
                                             GDBusMethodInvocation* invocation);
static void _dbus_ag_geo_clue2_agent_authorize_app_ready (GObject * source_object,
                                                   GAsyncResult * _res_,
                                                   gpointer _user_data_);
static void ag_geo_clue2_agent_dbus_interface_method_call (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* method_name,
                                                    GVariant* parameters,
                                                    GDBusMethodInvocation* invocation,
                                                    gpointer user_data);
static GVariant* ag_geo_clue2_agent_dbus_interface_get_property (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* property_name,
                                                          GError** error,
                                                          gpointer user_data);
static GVariant* _dbus_ag_geo_clue2_agent_get_max_accuracy_level (AgGeoClue2Agent* self);
static gboolean ag_geo_clue2_agent_dbus_interface_set_property (GDBusConnection* connection,
                                                         const gchar* sender,
                                                         const gchar* object_path,
                                                         const gchar* interface_name,
                                                         const gchar* property_name,
                                                         GVariant* value,
                                                         GError** error,
                                                         gpointer user_data);
static void _ag_geo_clue2_agent_unregister_object (gpointer user_data);
VALA_EXTERN GType ag_geo_clue2_client_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint ag_geo_clue2_client_register_object (void* object,
                                           GDBusConnection* connection,
                                           const gchar* path,
                                           GError** error);
VALA_EXTERN GType ag_geo_clue2_client_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AgGeoClue2Client, g_object_unref)
VALA_EXTERN void ag_geo_clue2_client_start (AgGeoClue2Client* self,
                                GError** error);
VALA_EXTERN void ag_geo_clue2_client_stop (AgGeoClue2Client* self,
                               GError** error);
VALA_EXTERN gchar* ag_geo_clue2_client_get_desktop_id (AgGeoClue2Client* self);
VALA_EXTERN void ag_geo_clue2_client_set_desktop_id (AgGeoClue2Client* self,
                                         const gchar* value);
static GType ag_geo_clue2_client_get_type_once (void);
static void ag_geo_clue2_client_proxy_g_signal (GDBusProxy* proxy,
                                         const gchar* sender_name,
                                         const gchar* signal_name,
                                         GVariant* parameters);
static void ag_geo_clue2_client_proxy_start (AgGeoClue2Client* self,
                                      GError** error);
static void ag_geo_clue2_client_proxy_stop (AgGeoClue2Client* self,
                                     GError** error);
static gchar* ag_geo_clue2_client_dbus_proxy_get_desktop_id (AgGeoClue2Client* self);
static void ag_geo_clue2_client_dbus_proxy_set_desktop_id (AgGeoClue2Client* self,
                                                    const gchar* value);
static void ag_geo_clue2_client_proxy_ag_geo_clue2_client_interface_init (AgGeoClue2ClientIface* iface);
static void _dbus_ag_geo_clue2_client_start (AgGeoClue2Client* self,
                                      GVariant* _parameters_,
                                      GDBusMethodInvocation* invocation);
static void _dbus_ag_geo_clue2_client_stop (AgGeoClue2Client* self,
                                     GVariant* _parameters_,
                                     GDBusMethodInvocation* invocation);
static void ag_geo_clue2_client_dbus_interface_method_call (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* method_name,
                                                     GVariant* parameters,
                                                     GDBusMethodInvocation* invocation,
                                                     gpointer user_data);
static GVariant* ag_geo_clue2_client_dbus_interface_get_property (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* property_name,
                                                           GError** error,
                                                           gpointer user_data);
static GVariant* _dbus_ag_geo_clue2_client_get_desktop_id (AgGeoClue2Client* self);
static gboolean ag_geo_clue2_client_dbus_interface_set_property (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* property_name,
                                                          GVariant* value,
                                                          GError** error,
                                                          gpointer user_data);
static void _dbus_ag_geo_clue2_client_set_desktop_id (AgGeoClue2Client* self,
                                               GVariant* _value);
static void _ag_geo_clue2_client_unregister_object (gpointer user_data);

static const GDBusArgInfo _ag_geo_clue2_manager_dbus_arg_info_add_agent_id = {-1, "id", "s", NULL};
static const GDBusArgInfo * const _ag_geo_clue2_manager_dbus_arg_info_add_agent_in[] = {&_ag_geo_clue2_manager_dbus_arg_info_add_agent_id, NULL};
static const GDBusArgInfo * const _ag_geo_clue2_manager_dbus_arg_info_add_agent_out[] = {NULL};
static const GDBusMethodInfo _ag_geo_clue2_manager_dbus_method_info_add_agent = {-1, "AddAgent", (GDBusArgInfo **) (&_ag_geo_clue2_manager_dbus_arg_info_add_agent_in), (GDBusArgInfo **) (&_ag_geo_clue2_manager_dbus_arg_info_add_agent_out), NULL};
static const GDBusArgInfo _ag_geo_clue2_manager_dbus_arg_info_get_client_result = {-1, "result", "o", NULL};
static const GDBusArgInfo * const _ag_geo_clue2_manager_dbus_arg_info_get_client_in[] = {NULL};
static const GDBusArgInfo * const _ag_geo_clue2_manager_dbus_arg_info_get_client_out[] = {&_ag_geo_clue2_manager_dbus_arg_info_get_client_result, NULL};
static const GDBusMethodInfo _ag_geo_clue2_manager_dbus_method_info_get_client = {-1, "GetClient", (GDBusArgInfo **) (&_ag_geo_clue2_manager_dbus_arg_info_get_client_in), (GDBusArgInfo **) (&_ag_geo_clue2_manager_dbus_arg_info_get_client_out), NULL};
static const GDBusMethodInfo * const _ag_geo_clue2_manager_dbus_method_info[] = {&_ag_geo_clue2_manager_dbus_method_info_add_agent, &_ag_geo_clue2_manager_dbus_method_info_get_client, NULL};
static const GDBusSignalInfo * const _ag_geo_clue2_manager_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _ag_geo_clue2_manager_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _ag_geo_clue2_manager_dbus_interface_info = {-1, "org.freedesktop.GeoClue2.Manager", (GDBusMethodInfo **) (&_ag_geo_clue2_manager_dbus_method_info), (GDBusSignalInfo **) (&_ag_geo_clue2_manager_dbus_signal_info), (GDBusPropertyInfo **) (&_ag_geo_clue2_manager_dbus_property_info), NULL};
static const GDBusInterfaceVTable _ag_geo_clue2_manager_dbus_interface_vtable = {ag_geo_clue2_manager_dbus_interface_method_call, ag_geo_clue2_manager_dbus_interface_get_property, ag_geo_clue2_manager_dbus_interface_set_property};
static const GDBusArgInfo _ag_geo_clue2_agent_dbus_arg_info_authorize_app_desktop_id = {-1, "desktop_id", "s", NULL};
static const GDBusArgInfo _ag_geo_clue2_agent_dbus_arg_info_authorize_app_req_accuracy_level = {-1, "req_accuracy_level", "u", NULL};
static const GDBusArgInfo _ag_geo_clue2_agent_dbus_arg_info_authorize_app_authorized = {-1, "authorized", "b", NULL};
static const GDBusArgInfo _ag_geo_clue2_agent_dbus_arg_info_authorize_app_allowed_accuracy_level = {-1, "allowed_accuracy_level", "u", NULL};
static const GDBusArgInfo * const _ag_geo_clue2_agent_dbus_arg_info_authorize_app_in[] = {&_ag_geo_clue2_agent_dbus_arg_info_authorize_app_desktop_id, &_ag_geo_clue2_agent_dbus_arg_info_authorize_app_req_accuracy_level, NULL};
static const GDBusArgInfo * const _ag_geo_clue2_agent_dbus_arg_info_authorize_app_out[] = {&_ag_geo_clue2_agent_dbus_arg_info_authorize_app_authorized, &_ag_geo_clue2_agent_dbus_arg_info_authorize_app_allowed_accuracy_level, NULL};
static const GDBusMethodInfo _ag_geo_clue2_agent_dbus_method_info_authorize_app = {-1, "AuthorizeApp", (GDBusArgInfo **) (&_ag_geo_clue2_agent_dbus_arg_info_authorize_app_in), (GDBusArgInfo **) (&_ag_geo_clue2_agent_dbus_arg_info_authorize_app_out), NULL};
static const GDBusMethodInfo * const _ag_geo_clue2_agent_dbus_method_info[] = {&_ag_geo_clue2_agent_dbus_method_info_authorize_app, NULL};
static const GDBusSignalInfo * const _ag_geo_clue2_agent_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _ag_geo_clue2_agent_dbus_property_info_max_accuracy_level = {-1, "MaxAccuracyLevel", "u", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo * const _ag_geo_clue2_agent_dbus_property_info[] = {&_ag_geo_clue2_agent_dbus_property_info_max_accuracy_level, NULL};
static const GDBusInterfaceInfo _ag_geo_clue2_agent_dbus_interface_info = {-1, "org.freedesktop.GeoClue2.Agent", (GDBusMethodInfo **) (&_ag_geo_clue2_agent_dbus_method_info), (GDBusSignalInfo **) (&_ag_geo_clue2_agent_dbus_signal_info), (GDBusPropertyInfo **) (&_ag_geo_clue2_agent_dbus_property_info), NULL};
static const GDBusInterfaceVTable _ag_geo_clue2_agent_dbus_interface_vtable = {ag_geo_clue2_agent_dbus_interface_method_call, ag_geo_clue2_agent_dbus_interface_get_property, ag_geo_clue2_agent_dbus_interface_set_property};
static const GDBusArgInfo * const _ag_geo_clue2_client_dbus_arg_info_start_in[] = {NULL};
static const GDBusArgInfo * const _ag_geo_clue2_client_dbus_arg_info_start_out[] = {NULL};
static const GDBusMethodInfo _ag_geo_clue2_client_dbus_method_info_start = {-1, "Start", (GDBusArgInfo **) (&_ag_geo_clue2_client_dbus_arg_info_start_in), (GDBusArgInfo **) (&_ag_geo_clue2_client_dbus_arg_info_start_out), NULL};
static const GDBusArgInfo * const _ag_geo_clue2_client_dbus_arg_info_stop_in[] = {NULL};
static const GDBusArgInfo * const _ag_geo_clue2_client_dbus_arg_info_stop_out[] = {NULL};
static const GDBusMethodInfo _ag_geo_clue2_client_dbus_method_info_stop = {-1, "Stop", (GDBusArgInfo **) (&_ag_geo_clue2_client_dbus_arg_info_stop_in), (GDBusArgInfo **) (&_ag_geo_clue2_client_dbus_arg_info_stop_out), NULL};
static const GDBusMethodInfo * const _ag_geo_clue2_client_dbus_method_info[] = {&_ag_geo_clue2_client_dbus_method_info_start, &_ag_geo_clue2_client_dbus_method_info_stop, NULL};
static const GDBusSignalInfo * const _ag_geo_clue2_client_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _ag_geo_clue2_client_dbus_property_info_desktop_id = {-1, "DesktopId", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo * const _ag_geo_clue2_client_dbus_property_info[] = {&_ag_geo_clue2_client_dbus_property_info_desktop_id, NULL};
static const GDBusInterfaceInfo _ag_geo_clue2_client_dbus_interface_info = {-1, "org.freedesktop.GeoClue2.Client", (GDBusMethodInfo **) (&_ag_geo_clue2_client_dbus_method_info), (GDBusSignalInfo **) (&_ag_geo_clue2_client_dbus_signal_info), (GDBusPropertyInfo **) (&_ag_geo_clue2_client_dbus_property_info), NULL};
static const GDBusInterfaceVTable _ag_geo_clue2_client_dbus_interface_vtable = {ag_geo_clue2_client_dbus_interface_method_call, ag_geo_clue2_client_dbus_interface_get_property, ag_geo_clue2_client_dbus_interface_set_property};

void
ag_geo_clue2_manager_add_agent (AgGeoClue2Manager* self,
                                const gchar* id,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	AgGeoClue2ManagerIface* _iface_;
	_iface_ = AG_GEO_CLUE2_MANAGER_GET_INTERFACE (self);
	if (_iface_->add_agent) {
		_iface_->add_agent (self, id, _callback_, _user_data_);
	}
}

void
ag_geo_clue2_manager_add_agent_finish (AgGeoClue2Manager* self,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	AgGeoClue2ManagerIface* _iface_;
	_iface_ = AG_GEO_CLUE2_MANAGER_GET_INTERFACE (self);
	if (_iface_->add_agent_finish) {
		_iface_->add_agent_finish (self, _res_, error);
	}
}

void
ag_geo_clue2_manager_get_client (AgGeoClue2Manager* self,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	AgGeoClue2ManagerIface* _iface_;
	_iface_ = AG_GEO_CLUE2_MANAGER_GET_INTERFACE (self);
	if (_iface_->get_client) {
		_iface_->get_client (self, _callback_, _user_data_);
	}
}

char*
ag_geo_clue2_manager_get_client_finish (AgGeoClue2Manager* self,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	AgGeoClue2ManagerIface* _iface_;
	_iface_ = AG_GEO_CLUE2_MANAGER_GET_INTERFACE (self);
	if (_iface_->get_client_finish) {
		return _iface_->get_client_finish (self, _res_, error);
	}
	return NULL;
}

static void
ag_geo_clue2_manager_default_init (AgGeoClue2ManagerIface * iface,
                                   gpointer iface_data)
{
}

static GType
ag_geo_clue2_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AgGeoClue2ManagerIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ag_geo_clue2_manager_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType ag_geo_clue2_manager_type_id;
	ag_geo_clue2_manager_type_id = g_type_register_static (G_TYPE_INTERFACE, "AgGeoClue2Manager", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (ag_geo_clue2_manager_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (ag_geo_clue2_manager_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) ag_geo_clue2_manager_proxy_get_type);
	g_type_set_qdata (ag_geo_clue2_manager_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.GeoClue2.Manager");
	g_type_set_qdata (ag_geo_clue2_manager_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_ag_geo_clue2_manager_dbus_interface_info));
	g_type_set_qdata (ag_geo_clue2_manager_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) ag_geo_clue2_manager_register_object);
	return ag_geo_clue2_manager_type_id;
}

GType
ag_geo_clue2_manager_get_type (void)
{
	static volatile gsize ag_geo_clue2_manager_type_id__once = 0;
	if (g_once_init_enter (&ag_geo_clue2_manager_type_id__once)) {
		GType ag_geo_clue2_manager_type_id;
		ag_geo_clue2_manager_type_id = ag_geo_clue2_manager_get_type_once ();
		g_once_init_leave (&ag_geo_clue2_manager_type_id__once, ag_geo_clue2_manager_type_id);
	}
	return ag_geo_clue2_manager_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (AgGeoClue2ManagerProxy, ag_geo_clue2_manager_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (AG_TYPE_GEO_CLUE2_MANAGER, ag_geo_clue2_manager_proxy_ag_geo_clue2_manager_interface_init) )
static void
ag_geo_clue2_manager_proxy_class_init (AgGeoClue2ManagerProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = ag_geo_clue2_manager_proxy_g_signal;
}

static void
ag_geo_clue2_manager_proxy_g_signal (GDBusProxy* proxy,
                                     const gchar* sender_name,
                                     const gchar* signal_name,
                                     GVariant* parameters)
{
}

static void
ag_geo_clue2_manager_proxy_init (AgGeoClue2ManagerProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_ag_geo_clue2_manager_dbus_interface_info));
}

static void
_vala_g_async_ready_callback (GObject *source_object,
                              GAsyncResult *res,
                              void *user_data)
{
	g_task_return_pointer (user_data, g_object_ref (res), g_object_unref);
	g_object_unref (user_data);
}

static void
ag_geo_clue2_manager_proxy_add_agent_async (AgGeoClue2Manager* self,
                                            const gchar* id,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.GeoClue2.Manager", "AddAgent");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
ag_geo_clue2_manager_proxy_add_agent_finish (AgGeoClue2Manager* self,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
ag_geo_clue2_manager_proxy_get_client_async (AgGeoClue2Manager* self,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.GeoClue2.Manager", "GetClient");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static char*
ag_geo_clue2_manager_proxy_get_client_finish (AgGeoClue2Manager* self,
                                              GAsyncResult* _res_,
                                              GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	char* _result = NULL;
	GVariant* _tmp0_;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp0_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp0_, NULL);
	g_variant_unref (_tmp0_);
	g_object_unref (_reply_message);
	return _result;
}

static void
ag_geo_clue2_manager_proxy_ag_geo_clue2_manager_interface_init (AgGeoClue2ManagerIface* iface)
{
	iface->add_agent = ag_geo_clue2_manager_proxy_add_agent_async;
	iface->add_agent_finish = ag_geo_clue2_manager_proxy_add_agent_finish;
	iface->get_client = ag_geo_clue2_manager_proxy_get_client_async;
	iface->get_client_finish = ag_geo_clue2_manager_proxy_get_client_finish;
}

static void
_dbus_ag_geo_clue2_manager_add_agent (AgGeoClue2Manager* self,
                                      GVariant* _parameters_,
                                      GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	AgGeoClue2ManagerAddAgentReadyData* _ready_data;
	GVariant* _tmp1_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (AgGeoClue2ManagerAddAgentReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->id = g_variant_dup_string (_tmp1_, NULL);
	g_variant_unref (_tmp1_);
	ag_geo_clue2_manager_add_agent (self, _ready_data->id, (GAsyncReadyCallback) _dbus_ag_geo_clue2_manager_add_agent_ready, _ready_data);
	_error:
	;
}

static void
_dbus_ag_geo_clue2_manager_add_agent_ready (GObject * source_object,
                                            GAsyncResult * _res_,
                                            gpointer _user_data_)
{
	AgGeoClue2ManagerAddAgentReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	ag_geo_clue2_manager_add_agent_finish ((AgGeoClue2Manager*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->id);
	g_slice_free (AgGeoClue2ManagerAddAgentReadyData, _ready_data);
}

static void
_dbus_ag_geo_clue2_manager_get_client (AgGeoClue2Manager* self,
                                       GVariant* _parameters_,
                                       GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	AgGeoClue2ManagerGetClientReadyData* _ready_data;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (AgGeoClue2ManagerGetClientReadyData);
	_ready_data->_invocation_ = invocation;
	ag_geo_clue2_manager_get_client (self, (GAsyncReadyCallback) _dbus_ag_geo_clue2_manager_get_client_ready, _ready_data);
}

static void
_dbus_ag_geo_clue2_manager_get_client_ready (GObject * source_object,
                                             GAsyncResult * _res_,
                                             gpointer _user_data_)
{
	AgGeoClue2ManagerGetClientReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	char* result;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = ag_geo_clue2_manager_get_client_finish ((AgGeoClue2Manager*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_object_path (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (AgGeoClue2ManagerGetClientReadyData, _ready_data);
}

static void
ag_geo_clue2_manager_dbus_interface_method_call (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* method_name,
                                                 GVariant* parameters,
                                                 GDBusMethodInvocation* invocation,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "AddAgent") == 0) {
		_dbus_ag_geo_clue2_manager_add_agent (object, parameters, invocation);
	} else if (strcmp (method_name, "GetClient") == 0) {
		_dbus_ag_geo_clue2_manager_get_client (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
ag_geo_clue2_manager_dbus_interface_get_property (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* property_name,
                                                  GError** error,
                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
ag_geo_clue2_manager_dbus_interface_set_property (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* property_name,
                                                  GVariant* value,
                                                  GError** error,
                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
ag_geo_clue2_manager_register_object (gpointer object,
                                      GDBusConnection* connection,
                                      const gchar* path,
                                      GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_ag_geo_clue2_manager_dbus_interface_info), &_ag_geo_clue2_manager_dbus_interface_vtable, data, _ag_geo_clue2_manager_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_ag_geo_clue2_manager_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

void
ag_geo_clue2_agent_authorize_app (AgGeoClue2Agent* self,
                                  const gchar* desktop_id,
                                  GClueAccuracyLevel req_accuracy_level,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	AgGeoClue2AgentIface* _iface_;
	_iface_ = AG_GEO_CLUE2_AGENT_GET_INTERFACE (self);
	if (_iface_->authorize_app) {
		_iface_->authorize_app (self, desktop_id, req_accuracy_level, _callback_, _user_data_);
	}
}

void
ag_geo_clue2_agent_authorize_app_finish (AgGeoClue2Agent* self,
                                         GAsyncResult* _res_,
                                         gboolean* authorized,
                                         GClueAccuracyLevel* allowed_accuracy_level,
                                         GError** error)
{
	AgGeoClue2AgentIface* _iface_;
	_iface_ = AG_GEO_CLUE2_AGENT_GET_INTERFACE (self);
	if (_iface_->authorize_app_finish) {
		_iface_->authorize_app_finish (self, _res_, authorized, allowed_accuracy_level, error);
	}
}

GClueAccuracyLevel
ag_geo_clue2_agent_get_max_accuracy_level (AgGeoClue2Agent* self)
{
	AgGeoClue2AgentIface* _iface_;
	g_return_val_if_fail (self != NULL, 0);
	_iface_ = AG_GEO_CLUE2_AGENT_GET_INTERFACE (self);
	if (_iface_->get_max_accuracy_level) {
		return _iface_->get_max_accuracy_level (self);
	}
	return 0;
}

static void
ag_geo_clue2_agent_default_init (AgGeoClue2AgentIface * iface,
                                 gpointer iface_data)
{
}

static GType
ag_geo_clue2_agent_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AgGeoClue2AgentIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ag_geo_clue2_agent_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType ag_geo_clue2_agent_type_id;
	ag_geo_clue2_agent_type_id = g_type_register_static (G_TYPE_INTERFACE, "AgGeoClue2Agent", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (ag_geo_clue2_agent_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (ag_geo_clue2_agent_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) ag_geo_clue2_agent_proxy_get_type);
	g_type_set_qdata (ag_geo_clue2_agent_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.GeoClue2.Agent");
	g_type_set_qdata (ag_geo_clue2_agent_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_ag_geo_clue2_agent_dbus_interface_info));
	g_type_set_qdata (ag_geo_clue2_agent_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) ag_geo_clue2_agent_register_object);
	return ag_geo_clue2_agent_type_id;
}

GType
ag_geo_clue2_agent_get_type (void)
{
	static volatile gsize ag_geo_clue2_agent_type_id__once = 0;
	if (g_once_init_enter (&ag_geo_clue2_agent_type_id__once)) {
		GType ag_geo_clue2_agent_type_id;
		ag_geo_clue2_agent_type_id = ag_geo_clue2_agent_get_type_once ();
		g_once_init_leave (&ag_geo_clue2_agent_type_id__once, ag_geo_clue2_agent_type_id);
	}
	return ag_geo_clue2_agent_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (AgGeoClue2AgentProxy, ag_geo_clue2_agent_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (AG_TYPE_GEO_CLUE2_AGENT, ag_geo_clue2_agent_proxy_ag_geo_clue2_agent_interface_init) )
static void
ag_geo_clue2_agent_proxy_class_init (AgGeoClue2AgentProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = ag_geo_clue2_agent_proxy_g_signal;
}

static void
ag_geo_clue2_agent_proxy_g_signal (GDBusProxy* proxy,
                                   const gchar* sender_name,
                                   const gchar* signal_name,
                                   GVariant* parameters)
{
}

static void
ag_geo_clue2_agent_proxy_init (AgGeoClue2AgentProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_ag_geo_clue2_agent_dbus_interface_info));
}

static void
ag_geo_clue2_agent_proxy_authorize_app_async (AgGeoClue2Agent* self,
                                              const gchar* desktop_id,
                                              GClueAccuracyLevel req_accuracy_level,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.GeoClue2.Agent", "AuthorizeApp");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (desktop_id));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (req_accuracy_level));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
ag_geo_clue2_agent_proxy_authorize_app_finish (AgGeoClue2Agent* self,
                                               GAsyncResult* _res_,
                                               gboolean* authorized,
                                               GClueAccuracyLevel* allowed_accuracy_level,
                                               GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _vala_authorized = FALSE;
	GVariant* _tmp2_;
	GClueAccuracyLevel _vala_allowed_accuracy_level = 0;
	GVariant* _tmp3_;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp2_ = g_variant_iter_next_value (&_reply_iter);
	_vala_authorized = g_variant_get_boolean (_tmp2_);
	g_variant_unref (_tmp2_);
	*authorized = _vala_authorized;
	_tmp3_ = g_variant_iter_next_value (&_reply_iter);
	_vala_allowed_accuracy_level = g_variant_get_uint32 (_tmp3_);
	g_variant_unref (_tmp3_);
	*allowed_accuracy_level = _vala_allowed_accuracy_level;
	g_object_unref (_reply_message);
}

static GClueAccuracyLevel
ag_geo_clue2_agent_dbus_proxy_get_max_accuracy_level (AgGeoClue2Agent* self)
{
	GVariant *_inner_reply;
	GClueAccuracyLevel _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "MaxAccuracyLevel");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.GeoClue2.Agent"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("MaxAccuracyLevel"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return 0;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_uint32 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
ag_geo_clue2_agent_proxy_ag_geo_clue2_agent_interface_init (AgGeoClue2AgentIface* iface)
{
	iface->authorize_app = ag_geo_clue2_agent_proxy_authorize_app_async;
	iface->authorize_app_finish = ag_geo_clue2_agent_proxy_authorize_app_finish;
	iface->get_max_accuracy_level = ag_geo_clue2_agent_dbus_proxy_get_max_accuracy_level;
}

static void
_dbus_ag_geo_clue2_agent_authorize_app (AgGeoClue2Agent* self,
                                        GVariant* _parameters_,
                                        GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	AgGeoClue2AgentAuthorizeAppReadyData* _ready_data;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (AgGeoClue2AgentAuthorizeAppReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp4_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->desktop_id = g_variant_dup_string (_tmp4_, NULL);
	g_variant_unref (_tmp4_);
	_tmp5_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->req_accuracy_level = g_variant_get_uint32 (_tmp5_);
	g_variant_unref (_tmp5_);
	ag_geo_clue2_agent_authorize_app (self, _ready_data->desktop_id, _ready_data->req_accuracy_level, (GAsyncReadyCallback) _dbus_ag_geo_clue2_agent_authorize_app_ready, _ready_data);
	_error:
	;
}

static void
_dbus_ag_geo_clue2_agent_authorize_app_ready (GObject * source_object,
                                              GAsyncResult * _res_,
                                              gpointer _user_data_)
{
	AgGeoClue2AgentAuthorizeAppReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean authorized = FALSE;
	GClueAccuracyLevel allowed_accuracy_level = 0;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	ag_geo_clue2_agent_authorize_app_finish ((AgGeoClue2Agent*) source_object, _res_, &authorized, &allowed_accuracy_level, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (authorized));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_uint32 (allowed_accuracy_level));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->desktop_id);
	g_slice_free (AgGeoClue2AgentAuthorizeAppReadyData, _ready_data);
}

static void
ag_geo_clue2_agent_dbus_interface_method_call (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* method_name,
                                               GVariant* parameters,
                                               GDBusMethodInvocation* invocation,
                                               gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "AuthorizeApp") == 0) {
		_dbus_ag_geo_clue2_agent_authorize_app (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
_dbus_ag_geo_clue2_agent_get_max_accuracy_level (AgGeoClue2Agent* self)
{
	GClueAccuracyLevel result;
	GVariant* _reply;
	result = ag_geo_clue2_agent_get_max_accuracy_level (self);
	_reply = g_variant_new_uint32 (result);
	return _reply;
}

static GVariant*
ag_geo_clue2_agent_dbus_interface_get_property (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* property_name,
                                                GError** error,
                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "MaxAccuracyLevel") == 0) {
		return _dbus_ag_geo_clue2_agent_get_max_accuracy_level (object);
	}
	return NULL;
}

static gboolean
ag_geo_clue2_agent_dbus_interface_set_property (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* property_name,
                                                GVariant* value,
                                                GError** error,
                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
ag_geo_clue2_agent_register_object (gpointer object,
                                    GDBusConnection* connection,
                                    const gchar* path,
                                    GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_ag_geo_clue2_agent_dbus_interface_info), &_ag_geo_clue2_agent_dbus_interface_vtable, data, _ag_geo_clue2_agent_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_ag_geo_clue2_agent_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

void
ag_geo_clue2_client_start (AgGeoClue2Client* self,
                           GError** error)
{
	AgGeoClue2ClientIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = AG_GEO_CLUE2_CLIENT_GET_INTERFACE (self);
	if (_iface_->start) {
		_iface_->start (self, error);
	}
}

void
ag_geo_clue2_client_stop (AgGeoClue2Client* self,
                          GError** error)
{
	AgGeoClue2ClientIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = AG_GEO_CLUE2_CLIENT_GET_INTERFACE (self);
	if (_iface_->stop) {
		_iface_->stop (self, error);
	}
}

gchar*
ag_geo_clue2_client_get_desktop_id (AgGeoClue2Client* self)
{
	AgGeoClue2ClientIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = AG_GEO_CLUE2_CLIENT_GET_INTERFACE (self);
	if (_iface_->get_desktop_id) {
		return _iface_->get_desktop_id (self);
	}
	return NULL;
}

void
ag_geo_clue2_client_set_desktop_id (AgGeoClue2Client* self,
                                    const gchar* value)
{
	AgGeoClue2ClientIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = AG_GEO_CLUE2_CLIENT_GET_INTERFACE (self);
	if (_iface_->set_desktop_id) {
		_iface_->set_desktop_id (self, value);
	}
}

static void
ag_geo_clue2_client_default_init (AgGeoClue2ClientIface * iface,
                                  gpointer iface_data)
{
}

static GType
ag_geo_clue2_client_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AgGeoClue2ClientIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ag_geo_clue2_client_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType ag_geo_clue2_client_type_id;
	ag_geo_clue2_client_type_id = g_type_register_static (G_TYPE_INTERFACE, "AgGeoClue2Client", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (ag_geo_clue2_client_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (ag_geo_clue2_client_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) ag_geo_clue2_client_proxy_get_type);
	g_type_set_qdata (ag_geo_clue2_client_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.GeoClue2.Client");
	g_type_set_qdata (ag_geo_clue2_client_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_ag_geo_clue2_client_dbus_interface_info));
	g_type_set_qdata (ag_geo_clue2_client_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) ag_geo_clue2_client_register_object);
	return ag_geo_clue2_client_type_id;
}

GType
ag_geo_clue2_client_get_type (void)
{
	static volatile gsize ag_geo_clue2_client_type_id__once = 0;
	if (g_once_init_enter (&ag_geo_clue2_client_type_id__once)) {
		GType ag_geo_clue2_client_type_id;
		ag_geo_clue2_client_type_id = ag_geo_clue2_client_get_type_once ();
		g_once_init_leave (&ag_geo_clue2_client_type_id__once, ag_geo_clue2_client_type_id);
	}
	return ag_geo_clue2_client_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (AgGeoClue2ClientProxy, ag_geo_clue2_client_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (AG_TYPE_GEO_CLUE2_CLIENT, ag_geo_clue2_client_proxy_ag_geo_clue2_client_interface_init) )
static void
ag_geo_clue2_client_proxy_class_init (AgGeoClue2ClientProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = ag_geo_clue2_client_proxy_g_signal;
}

static void
ag_geo_clue2_client_proxy_g_signal (GDBusProxy* proxy,
                                    const gchar* sender_name,
                                    const gchar* signal_name,
                                    GVariant* parameters)
{
}

static void
ag_geo_clue2_client_proxy_init (AgGeoClue2ClientProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_ag_geo_clue2_client_dbus_interface_info));
}

static void
ag_geo_clue2_client_proxy_start (AgGeoClue2Client* self,
                                 GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.GeoClue2.Client", "Start");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
ag_geo_clue2_client_proxy_stop (AgGeoClue2Client* self,
                                GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.GeoClue2.Client", "Stop");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static gchar*
ag_geo_clue2_client_dbus_proxy_get_desktop_id (AgGeoClue2Client* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "DesktopId");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.GeoClue2.Client"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("DesktopId"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
ag_geo_clue2_client_dbus_proxy_set_desktop_id (AgGeoClue2Client* self,
                                               const gchar* value)
{
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.GeoClue2.Client"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("DesktopId"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}

static void
ag_geo_clue2_client_proxy_ag_geo_clue2_client_interface_init (AgGeoClue2ClientIface* iface)
{
	iface->start = ag_geo_clue2_client_proxy_start;
	iface->stop = ag_geo_clue2_client_proxy_stop;
	iface->get_desktop_id = ag_geo_clue2_client_dbus_proxy_get_desktop_id;
	iface->set_desktop_id = ag_geo_clue2_client_dbus_proxy_set_desktop_id;
}

static void
_dbus_ag_geo_clue2_client_start (AgGeoClue2Client* self,
                                 GVariant* _parameters_,
                                 GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	ag_geo_clue2_client_start (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_ag_geo_clue2_client_stop (AgGeoClue2Client* self,
                                GVariant* _parameters_,
                                GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	ag_geo_clue2_client_stop (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
ag_geo_clue2_client_dbus_interface_method_call (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* method_name,
                                                GVariant* parameters,
                                                GDBusMethodInvocation* invocation,
                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Start") == 0) {
		_dbus_ag_geo_clue2_client_start (object, parameters, invocation);
	} else if (strcmp (method_name, "Stop") == 0) {
		_dbus_ag_geo_clue2_client_stop (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
_dbus_ag_geo_clue2_client_get_desktop_id (AgGeoClue2Client* self)
{
	gchar* result;
	GVariant* _reply;
	result = ag_geo_clue2_client_get_desktop_id (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
ag_geo_clue2_client_dbus_interface_get_property (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* property_name,
                                                 GError** error,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "DesktopId") == 0) {
		return _dbus_ag_geo_clue2_client_get_desktop_id (object);
	}
	return NULL;
}

static void
_dbus_ag_geo_clue2_client_set_desktop_id (AgGeoClue2Client* self,
                                          GVariant* _value)
{
	gchar* value = NULL;
	value = g_variant_dup_string (_value, NULL);
	ag_geo_clue2_client_set_desktop_id (self, value);
	_g_free0 (value);
}

static gboolean
ag_geo_clue2_client_dbus_interface_set_property (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* property_name,
                                                 GVariant* value,
                                                 GError** error,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "DesktopId") == 0) {
		_dbus_ag_geo_clue2_client_set_desktop_id (object, value);
		return TRUE;
	}
	return FALSE;
}

guint
ag_geo_clue2_client_register_object (gpointer object,
                                     GDBusConnection* connection,
                                     const gchar* path,
                                     GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_ag_geo_clue2_client_dbus_interface_info), &_ag_geo_clue2_client_dbus_interface_vtable, data, _ag_geo_clue2_client_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_ag_geo_clue2_client_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

