#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkAMRBaseParticlesReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkAMRBaseReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkAMRDataSetCache_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkAMREnzoParticlesReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkAMREnzoReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkAMReXGridReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkAMReXParticlesReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkAMRFlashParticlesReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkAMRFlashReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkAMRVelodyneReader_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkIOAMRCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkAMRBaseParticlesReader_Init(csi);
  vtkAMRBaseReader_Init(csi);
  vtkAMRDataSetCache_Init(csi);
  vtkAMREnzoParticlesReader_Init(csi);
  vtkAMREnzoReader_Init(csi);
  vtkAMReXGridReader_Init(csi);
  vtkAMReXParticlesReader_Init(csi);
  vtkAMRFlashParticlesReader_Init(csi);
  vtkAMRFlashReader_Init(csi);
  vtkAMRVelodyneReader_Init(csi);
}
