// python wrapper for vtkMoleculeRepresentation
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkMoleculeRepresentation.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkMoleculeRepresentation(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkMoleculeRepresentation_ClassNew(); }

#ifndef DECLARED_PyvtkPVDataRepresentation_ClassNew
extern "C" { PyObject *PyvtkPVDataRepresentation_ClassNew(); }
#define DECLARED_PyvtkPVDataRepresentation_ClassNew
#endif

static PyObject *
PyvtkMoleculeRepresentation_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkMoleculeRepresentation::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMoleculeRepresentation_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMoleculeRepresentation *op = static_cast<vtkMoleculeRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkMoleculeRepresentation::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMoleculeRepresentation_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkMoleculeRepresentation *tempr = vtkMoleculeRepresentation::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMoleculeRepresentation_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMoleculeRepresentation *op = static_cast<vtkMoleculeRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkMoleculeRepresentation *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkMoleculeRepresentation::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMoleculeRepresentation_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkMoleculeRepresentation::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMoleculeRepresentation_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMoleculeRepresentation *op = static_cast<vtkMoleculeRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkMoleculeRepresentation::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMoleculeRepresentation_ProcessViewRequest(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ProcessViewRequest");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMoleculeRepresentation *op = static_cast<vtkMoleculeRepresentation *>(vp);

  vtkInformationRequestKey *temp0 = nullptr;
  vtkInformation *temp1 = nullptr;
  vtkInformation *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkInformationRequestKey") &&
      ap.GetVTKObject(temp1, "vtkInformation") &&
      ap.GetVTKObject(temp2, "vtkInformation"))
  {
    int tempr = (ap.IsBound() ?
      op->ProcessViewRequest(temp0, temp1, temp2) :
      op->vtkMoleculeRepresentation::ProcessViewRequest(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMoleculeRepresentation_SetVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMoleculeRepresentation *op = static_cast<vtkMoleculeRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetVisibility(temp0);
    }
    else
    {
      op->vtkMoleculeRepresentation::SetVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMoleculeRepresentation_GetMoleculeRenderMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMoleculeRenderMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMoleculeRepresentation *op = static_cast<vtkMoleculeRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetMoleculeRenderMode() :
      op->vtkMoleculeRepresentation::GetMoleculeRenderMode());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMoleculeRepresentation_SetMoleculeRenderMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMoleculeRenderMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMoleculeRepresentation *op = static_cast<vtkMoleculeRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMoleculeRenderMode(temp0);
    }
    else
    {
      op->vtkMoleculeRepresentation::SetMoleculeRenderMode(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMoleculeRepresentation_GetUseCustomRadii(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseCustomRadii");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMoleculeRepresentation *op = static_cast<vtkMoleculeRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseCustomRadii() :
      op->vtkMoleculeRepresentation::GetUseCustomRadii());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMoleculeRepresentation_SetUseCustomRadii(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseCustomRadii");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMoleculeRepresentation *op = static_cast<vtkMoleculeRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseCustomRadii(temp0);
    }
    else
    {
      op->vtkMoleculeRepresentation::SetUseCustomRadii(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMoleculeRepresentation_SetLookupTable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLookupTable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMoleculeRepresentation *op = static_cast<vtkMoleculeRepresentation *>(vp);

  vtkScalarsToColors *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkScalarsToColors"))
  {
    if (ap.IsBound())
    {
      op->SetLookupTable(temp0);
    }
    else
    {
      op->vtkMoleculeRepresentation::SetLookupTable(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMoleculeRepresentation_SetOpacity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOpacity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMoleculeRepresentation *op = static_cast<vtkMoleculeRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOpacity(temp0);
    }
    else
    {
      op->vtkMoleculeRepresentation::SetOpacity(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMoleculeRepresentation_SetSpecular(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSpecular");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMoleculeRepresentation *op = static_cast<vtkMoleculeRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSpecular(temp0);
    }
    else
    {
      op->vtkMoleculeRepresentation::SetSpecular(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMoleculeRepresentation_SetSpecularPower(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSpecularPower");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMoleculeRepresentation *op = static_cast<vtkMoleculeRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSpecularPower(temp0);
    }
    else
    {
      op->vtkMoleculeRepresentation::SetSpecularPower(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMoleculeRepresentation_SetMapScalars(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMapScalars");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMoleculeRepresentation *op = static_cast<vtkMoleculeRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMapScalars(temp0);
    }
    else
    {
      op->vtkMoleculeRepresentation::SetMapScalars(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMoleculeRepresentation_SetRepresentation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRepresentation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMoleculeRepresentation *op = static_cast<vtkMoleculeRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRepresentation(temp0);
    }
    else
    {
      op->vtkMoleculeRepresentation::SetRepresentation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMoleculeRepresentation_GetRenderedDataObject(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRenderedDataObject");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMoleculeRepresentation *op = static_cast<vtkMoleculeRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkDataObject *tempr = (ap.IsBound() ?
      op->GetRenderedDataObject(temp0) :
      op->vtkMoleculeRepresentation::GetRenderedDataObject(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMoleculeRepresentation_GetActor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetActor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMoleculeRepresentation *op = static_cast<vtkMoleculeRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkActor *tempr = (ap.IsBound() ?
      op->GetActor() :
      op->vtkMoleculeRepresentation::GetActor());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMoleculeRepresentation_SetAtomicRadiusType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAtomicRadiusType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMoleculeRepresentation *op = static_cast<vtkMoleculeRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAtomicRadiusType(temp0);
    }
    else
    {
      op->vtkMoleculeRepresentation::SetAtomicRadiusType(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMoleculeRepresentation_SetAtomicRadiusScaleFactor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAtomicRadiusScaleFactor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMoleculeRepresentation *op = static_cast<vtkMoleculeRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAtomicRadiusScaleFactor(temp0);
    }
    else
    {
      op->vtkMoleculeRepresentation::SetAtomicRadiusScaleFactor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMoleculeRepresentation_SetBondRadius(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBondRadius");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMoleculeRepresentation *op = static_cast<vtkMoleculeRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBondRadius(temp0);
    }
    else
    {
      op->vtkMoleculeRepresentation::SetBondRadius(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMoleculeRepresentation_SetBondColorMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBondColorMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMoleculeRepresentation *op = static_cast<vtkMoleculeRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBondColorMode(temp0);
    }
    else
    {
      op->vtkMoleculeRepresentation::SetBondColorMode(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMoleculeRepresentation_SetBondColor_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBondColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMoleculeRepresentation *op = static_cast<vtkMoleculeRepresentation *>(vp);

  const size_t size0 = 3;
  double temp0[3];
  double save0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->SetBondColor(temp0);
    }
    else
    {
      op->vtkMoleculeRepresentation::SetBondColor(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkMoleculeRepresentation_SetBondColor_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBondColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMoleculeRepresentation *op = static_cast<vtkMoleculeRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetBondColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkMoleculeRepresentation::SetBondColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkMoleculeRepresentation_SetBondColor(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkMoleculeRepresentation_SetBondColor_s1(self, args);
    case 3:
      return PyvtkMoleculeRepresentation_SetBondColor_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetBondColor");
  return nullptr;
}


static PyObject *
PyvtkMoleculeRepresentation_SetUseMultiCylindersForBonds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseMultiCylindersForBonds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMoleculeRepresentation *op = static_cast<vtkMoleculeRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseMultiCylindersForBonds(temp0);
    }
    else
    {
      op->vtkMoleculeRepresentation::SetUseMultiCylindersForBonds(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMoleculeRepresentation_SetRenderAtoms(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRenderAtoms");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMoleculeRepresentation *op = static_cast<vtkMoleculeRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRenderAtoms(temp0);
    }
    else
    {
      op->vtkMoleculeRepresentation::SetRenderAtoms(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMoleculeRepresentation_SetRenderBonds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRenderBonds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMoleculeRepresentation *op = static_cast<vtkMoleculeRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRenderBonds(temp0);
    }
    else
    {
      op->vtkMoleculeRepresentation::SetRenderBonds(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMoleculeRepresentation_SetAtomicRadiusArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAtomicRadiusArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMoleculeRepresentation *op = static_cast<vtkMoleculeRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAtomicRadiusArray(temp0);
    }
    else
    {
      op->vtkMoleculeRepresentation::SetAtomicRadiusArray(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkMoleculeRepresentation_Methods[] = {
  {"IsTypeOf", PyvtkMoleculeRepresentation_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkMoleculeRepresentation_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkMoleculeRepresentation_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkMoleculeRepresentation\nC++: static vtkMoleculeRepresentation *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkMoleculeRepresentation_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkMoleculeRepresentation\nC++: vtkMoleculeRepresentation *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkMoleculeRepresentation_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkMoleculeRepresentation_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"ProcessViewRequest", PyvtkMoleculeRepresentation_ProcessViewRequest, METH_VARARGS,
   "ProcessViewRequest(self, requestType:vtkInformationRequestKey,\n    inputInfo:vtkInformation, outputInfo:vtkInformation) -> int\nC++: int ProcessViewRequest(vtkInformationRequestKey *requestType,\n     vtkInformation *inputInfo, vtkInformation *outputInfo)\n    override;\n\nvtkAlgorithm::ProcessRequest() equivalent for rendering passes.\nThis is typically called by the vtkView to request meta-data from\nthe representations or ask them to perform certain tasks e.g.\nPrepareForRendering.\n\note Starting with ParaView 5.8, this method is no longer called\nfor hidden representation i.e. representations for which\n`vtkDataRepresentation::GetVisibility()` returns false.\n"},
  {"SetVisibility", PyvtkMoleculeRepresentation_SetVisibility, METH_VARARGS,
   "SetVisibility(self, value:bool) -> None\nC++: void SetVisibility(bool value) override;\n\nGet/Set the visibility for this representation. When the\nvisibility of representation of false, all view passes are\nignored.\n"},
  {"GetMoleculeRenderMode", PyvtkMoleculeRepresentation_GetMoleculeRenderMode, METH_VARARGS,
   "GetMoleculeRenderMode(self) -> int\nC++: virtual int GetMoleculeRenderMode()\n\n"},
  {"SetMoleculeRenderMode", PyvtkMoleculeRepresentation_SetMoleculeRenderMode, METH_VARARGS,
   "SetMoleculeRenderMode(self, mode:int) -> None\nC++: void SetMoleculeRenderMode(int mode)\n\n"},
  {"GetUseCustomRadii", PyvtkMoleculeRepresentation_GetUseCustomRadii, METH_VARARGS,
   "GetUseCustomRadii(self) -> bool\nC++: virtual bool GetUseCustomRadii()\n\n"},
  {"SetUseCustomRadii", PyvtkMoleculeRepresentation_SetUseCustomRadii, METH_VARARGS,
   "SetUseCustomRadii(self, val:bool) -> None\nC++: void SetUseCustomRadii(bool val)\n\n"},
  {"SetLookupTable", PyvtkMoleculeRepresentation_SetLookupTable, METH_VARARGS,
   "SetLookupTable(self, lut:vtkScalarsToColors) -> None\nC++: void SetLookupTable(vtkScalarsToColors *lut)\n\n"},
  {"SetOpacity", PyvtkMoleculeRepresentation_SetOpacity, METH_VARARGS,
   "SetOpacity(self, val:float) -> None\nC++: virtual void SetOpacity(double val)\n\nForward corresponding actor property controls down.\n"},
  {"SetSpecular", PyvtkMoleculeRepresentation_SetSpecular, METH_VARARGS,
   "SetSpecular(self, val:float) -> None\nC++: virtual void SetSpecular(double val)\n\n"},
  {"SetSpecularPower", PyvtkMoleculeRepresentation_SetSpecularPower, METH_VARARGS,
   "SetSpecularPower(self, val:float) -> None\nC++: virtual void SetSpecularPower(double val)\n\n"},
  {"SetMapScalars", PyvtkMoleculeRepresentation_SetMapScalars, METH_VARARGS,
   "SetMapScalars(self, map:bool) -> None\nC++: void SetMapScalars(bool map)\n\nSet if scalars are mapped through a color-map or are used\ndirectly as colors.@see vtkScalarsToColors::MapScalars\n"},
  {"SetRepresentation", PyvtkMoleculeRepresentation_SetRepresentation, METH_VARARGS,
   "SetRepresentation(self, __a:str) -> None\nC++: void SetRepresentation(const char *)\n\nNo-op. For compatibility with vtkPVCompositeRepresentation, which\ncalls SetRepresentation on it's subproxies.\n"},
  {"GetRenderedDataObject", PyvtkMoleculeRepresentation_GetRenderedDataObject, METH_VARARGS,
   "GetRenderedDataObject(self, port:int) -> vtkDataObject\nC++: vtkDataObject *GetRenderedDataObject(int port) override;\n\nReturn the data object that is rendered from the given input\nport.\n"},
  {"GetActor", PyvtkMoleculeRepresentation_GetActor, METH_VARARGS,
   "GetActor(self) -> vtkActor\nC++: virtual vtkActor *GetActor()\n\nReturn the actor.\n"},
  {"SetAtomicRadiusType", PyvtkMoleculeRepresentation_SetAtomicRadiusType, METH_VARARGS,
   "SetAtomicRadiusType(self, type:int) -> None\nC++: void SetAtomicRadiusType(int type)\n\nForward custom atom/bonds rendering parameters to the mapper.\n"},
  {"SetAtomicRadiusScaleFactor", PyvtkMoleculeRepresentation_SetAtomicRadiusScaleFactor, METH_VARARGS,
   "SetAtomicRadiusScaleFactor(self, factor:float) -> None\nC++: void SetAtomicRadiusScaleFactor(double factor)\n\n"},
  {"SetBondRadius", PyvtkMoleculeRepresentation_SetBondRadius, METH_VARARGS,
   "SetBondRadius(self, factor:float) -> None\nC++: void SetBondRadius(double factor)\n\n"},
  {"SetBondColorMode", PyvtkMoleculeRepresentation_SetBondColorMode, METH_VARARGS,
   "SetBondColorMode(self, mode:int) -> None\nC++: void SetBondColorMode(int mode)\n\n"},
  {"SetBondColor", PyvtkMoleculeRepresentation_SetBondColor, METH_VARARGS,
   "SetBondColor(self, color:[float, float, float]) -> None\nC++: void SetBondColor(double color[3])\nSetBondColor(self, r:float, g:float, b:float) -> None\nC++: void SetBondColor(double r, double g, double b)\n\n"},
  {"SetUseMultiCylindersForBonds", PyvtkMoleculeRepresentation_SetUseMultiCylindersForBonds, METH_VARARGS,
   "SetUseMultiCylindersForBonds(self, use:bool) -> None\nC++: void SetUseMultiCylindersForBonds(bool use)\n\n"},
  {"SetRenderAtoms", PyvtkMoleculeRepresentation_SetRenderAtoms, METH_VARARGS,
   "SetRenderAtoms(self, render:bool) -> None\nC++: void SetRenderAtoms(bool render)\n\n"},
  {"SetRenderBonds", PyvtkMoleculeRepresentation_SetRenderBonds, METH_VARARGS,
   "SetRenderBonds(self, render:bool) -> None\nC++: void SetRenderBonds(bool render)\n\n"},
  {"SetAtomicRadiusArray", PyvtkMoleculeRepresentation_SetAtomicRadiusArray, METH_VARARGS,
   "SetAtomicRadiusArray(self, name:str) -> None\nC++: void SetAtomicRadiusArray(const char *name)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkMoleculeRepresentation_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkMoleculeRepresentation_SetVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkMoleculeRepresentation_SetVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("molecule_render_mode"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkMoleculeRepresentation_GetMoleculeRenderMode(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkMoleculeRepresentation_SetMoleculeRenderMode(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkMoleculeRepresentation_SetMoleculeRenderMode(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMoleculeRenderMode/SetMoleculeRenderMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_custom_radii"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkMoleculeRepresentation_GetUseCustomRadii(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkMoleculeRepresentation_SetUseCustomRadii(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkMoleculeRepresentation_SetUseCustomRadii(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseCustomRadii/SetUseCustomRadii\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("lookup_table"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkMoleculeRepresentation_SetLookupTable(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkMoleculeRepresentation_SetLookupTable(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLookupTable\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("opacity"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkMoleculeRepresentation_SetOpacity(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkMoleculeRepresentation_SetOpacity(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetOpacity\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("specular"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkMoleculeRepresentation_SetSpecular(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkMoleculeRepresentation_SetSpecular(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetSpecular\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("specular_power"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkMoleculeRepresentation_SetSpecularPower(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkMoleculeRepresentation_SetSpecularPower(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetSpecularPower\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("map_scalars"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkMoleculeRepresentation_SetMapScalars(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkMoleculeRepresentation_SetMapScalars(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetMapScalars\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("representation"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkMoleculeRepresentation_SetRepresentation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkMoleculeRepresentation_SetRepresentation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRepresentation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("atomic_radius_type"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkMoleculeRepresentation_SetAtomicRadiusType(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkMoleculeRepresentation_SetAtomicRadiusType(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetAtomicRadiusType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("atomic_radius_scale_factor"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkMoleculeRepresentation_SetAtomicRadiusScaleFactor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkMoleculeRepresentation_SetAtomicRadiusScaleFactor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetAtomicRadiusScaleFactor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("bond_radius"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkMoleculeRepresentation_SetBondRadius(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkMoleculeRepresentation_SetBondRadius(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBondRadius\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("bond_color_mode"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkMoleculeRepresentation_SetBondColorMode(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkMoleculeRepresentation_SetBondColorMode(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBondColorMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("bond_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkMoleculeRepresentation_SetBondColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkMoleculeRepresentation_SetBondColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBondColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_multi_cylinders_for_bonds"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkMoleculeRepresentation_SetUseMultiCylindersForBonds(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkMoleculeRepresentation_SetUseMultiCylindersForBonds(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetUseMultiCylindersForBonds\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("render_atoms"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkMoleculeRepresentation_SetRenderAtoms(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkMoleculeRepresentation_SetRenderAtoms(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRenderAtoms\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("render_bonds"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkMoleculeRepresentation_SetRenderBonds(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkMoleculeRepresentation_SetRenderBonds(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRenderBonds\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("atomic_radius_array"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkMoleculeRepresentation_SetAtomicRadiusArray(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkMoleculeRepresentation_SetAtomicRadiusArray(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetAtomicRadiusArray\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("actor"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkMoleculeRepresentation_GetActor(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetActor\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkMoleculeRepresentation_Doc =
  "vtkMoleculeRepresentation - representation for showing vtkMolecules\n\n"
  "Superclass: vtkPVDataRepresentation\n\n"
;

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkMoleculeRepresentation_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkMoleculeRepresentation", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkMoleculeRepresentation_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkMoleculeRepresentation_StaticNew()
{
  return vtkMoleculeRepresentation::New();
}

PyObject *PyvtkMoleculeRepresentation_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkMoleculeRepresentation_Type, PyvtkMoleculeRepresentation_Methods,
    "vtkMoleculeRepresentation",
 &PyvtkMoleculeRepresentation_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkPVDataRepresentation_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkMoleculeRepresentation_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkMoleculeRepresentation(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkMoleculeRepresentation_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkMoleculeRepresentation", o) != 0)
  {
    Py_DECREF(o);
  }

}

