/* DeviceItem.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from DeviceItem.vala, do not modify */

/*-
 * Copyright (c) 2015-2019 elementary, Inc. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Adam Bieńkowski <donadigos159@gmail.com>
 */

#include "network.h"
#include <NetworkManager.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <switchboard.h>
#include <pango/pango.h>
#include <granite-7.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	NETWORK_WIDGETS_DEVICE_ITEM_0_PROPERTY,
	NETWORK_WIDGETS_DEVICE_ITEM_STATUS_TYPE_PROPERTY,
	NETWORK_WIDGETS_DEVICE_ITEM_DEVICE_PROPERTY,
	NETWORK_WIDGETS_DEVICE_ITEM_PAGE_PROPERTY,
	NETWORK_WIDGETS_DEVICE_ITEM_TITLE_PROPERTY,
	NETWORK_WIDGETS_DEVICE_ITEM_SUBTITLE_PROPERTY,
	NETWORK_WIDGETS_DEVICE_ITEM_ICON_PROPERTY,
	NETWORK_WIDGETS_DEVICE_ITEM_ITEM_TYPE_PROPERTY,
	NETWORK_WIDGETS_DEVICE_ITEM_NUM_PROPERTIES
};
static GParamSpec* network_widgets_device_item_properties[NETWORK_WIDGETS_DEVICE_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _NetworkWidgetsDeviceItemPrivate {
	NMDevice* _device;
	NetworkWidgetsPage* _page;
	gchar* _title;
	gchar* _subtitle;
	GIcon* _icon;
	NetworkUtilsItemType _item_type;
	GtkImage* status_image;
};

static gint NetworkWidgetsDeviceItem_private_offset;
static gpointer network_widgets_device_item_parent_class = NULL;

static GObject * network_widgets_device_item_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
static void network_widgets_device_item_finalize (GObject * obj);
static GType network_widgets_device_item_get_type_once (void);
static void _vala_network_widgets_device_item_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_network_widgets_device_item_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);

static inline gpointer
network_widgets_device_item_get_instance_private (NetworkWidgetsDeviceItem* self)
{
	return G_STRUCT_MEMBER_P (self, NetworkWidgetsDeviceItem_private_offset);
}

NetworkWidgetsDeviceItem*
network_widgets_device_item_construct_from_page (GType object_type,
                                                 NetworkWidgetsPage* page,
                                                 const gchar* icon_name)
{
	NetworkWidgetsDeviceItem * self = NULL;
	NMDevice* _tmp0_;
	NMDevice* _tmp1_;
	GThemedIcon* _tmp2_;
	GThemedIcon* _tmp3_;
	g_return_val_if_fail (page != NULL, NULL);
	g_return_val_if_fail (icon_name != NULL, NULL);
	_tmp0_ = network_widgets_page_get_device (page);
	_tmp1_ = _tmp0_;
	_tmp2_ = (GThemedIcon*) g_themed_icon_new (icon_name);
	_tmp3_ = _tmp2_;
	self = (NetworkWidgetsDeviceItem*) g_object_new (object_type, "device", _tmp1_, "icon", _tmp3_, "item-type", NETWORK_UTILS_ITEM_TYPE_DEVICE, "page", page, NULL);
	_g_object_unref0 (_tmp3_);
	g_object_bind_property_with_closures ((GObject*) page, "title", (GObject*) self, "title", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	g_object_bind_property_with_closures ((GObject*) page, "icon", (GObject*) self, "icon", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	g_object_bind_property_with_closures ((GObject*) page, "status-type", (GObject*) self, "status-type", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	g_object_bind_property_with_closures ((GObject*) page, "status", (GObject*) self, "subtitle", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	return self;
}

NetworkWidgetsDeviceItem*
network_widgets_device_item_new_from_page (NetworkWidgetsPage* page,
                                           const gchar* icon_name)
{
	return network_widgets_device_item_construct_from_page (NETWORK_WIDGETS_TYPE_DEVICE_ITEM, page, icon_name);
}

NetworkWidgetsDeviceItem*
network_widgets_device_item_construct (GType object_type)
{
	NetworkWidgetsDeviceItem * self = NULL;
	self = (NetworkWidgetsDeviceItem*) g_object_new (object_type, NULL);
	return self;
}

NetworkWidgetsDeviceItem*
network_widgets_device_item_new (void)
{
	return network_widgets_device_item_construct (NETWORK_WIDGETS_TYPE_DEVICE_ITEM);
}

void
network_widgets_device_item_set_status_type (NetworkWidgetsDeviceItem* self,
                                             SwitchboardSettingsPageStatusType value)
{
	g_return_if_fail (self != NULL);
	switch (value) {
		case SWITCHBOARD_SETTINGS_PAGE_STATUS_TYPE_ERROR:
		{
			GtkImage* _tmp0_;
			_tmp0_ = self->priv->status_image;
			g_object_set (_tmp0_, "icon-name", "emblem-error", NULL);
			break;
		}
		case SWITCHBOARD_SETTINGS_PAGE_STATUS_TYPE_OFFLINE:
		{
			GtkImage* _tmp1_;
			_tmp1_ = self->priv->status_image;
			g_object_set (_tmp1_, "icon-name", "emblem-disabled", NULL);
			break;
		}
		case SWITCHBOARD_SETTINGS_PAGE_STATUS_TYPE_SUCCESS:
		{
			GtkImage* _tmp2_;
			_tmp2_ = self->priv->status_image;
			g_object_set (_tmp2_, "icon-name", "emblem-enabled", NULL);
			break;
		}
		case SWITCHBOARD_SETTINGS_PAGE_STATUS_TYPE_WARNING:
		{
			GtkImage* _tmp3_;
			_tmp3_ = self->priv->status_image;
			g_object_set (_tmp3_, "icon-name", "emblem-warning", NULL);
			break;
		}
		case SWITCHBOARD_SETTINGS_PAGE_STATUS_TYPE_NONE:
		{
			GtkImage* _tmp4_;
			_tmp4_ = self->priv->status_image;
			gtk_image_clear (_tmp4_);
			break;
		}
		default:
		break;
	}
	g_object_notify_by_pspec ((GObject *) self, network_widgets_device_item_properties[NETWORK_WIDGETS_DEVICE_ITEM_STATUS_TYPE_PROPERTY]);
}

NMDevice*
network_widgets_device_item_get_device (NetworkWidgetsDeviceItem* self)
{
	NMDevice* result;
	NMDevice* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_device;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
network_widgets_device_item_set_device (NetworkWidgetsDeviceItem* self,
                                        NMDevice* value)
{
	NMDevice* old_value;
	g_return_if_fail (self != NULL);
	old_value = network_widgets_device_item_get_device (self);
	if (old_value != value) {
		NMDevice* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_device);
		self->priv->_device = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, network_widgets_device_item_properties[NETWORK_WIDGETS_DEVICE_ITEM_DEVICE_PROPERTY]);
	}
}

NetworkWidgetsPage*
network_widgets_device_item_get_page (NetworkWidgetsDeviceItem* self)
{
	NetworkWidgetsPage* result;
	NetworkWidgetsPage* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_page;
	result = _tmp0_;
	return result;
}

void
network_widgets_device_item_set_page (NetworkWidgetsDeviceItem* self,
                                      NetworkWidgetsPage* value)
{
	NetworkWidgetsPage* old_value;
	g_return_if_fail (self != NULL);
	old_value = network_widgets_device_item_get_page (self);
	if (old_value != value) {
		NetworkWidgetsPage* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_page);
		self->priv->_page = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, network_widgets_device_item_properties[NETWORK_WIDGETS_DEVICE_ITEM_PAGE_PROPERTY]);
	}
}

const gchar*
network_widgets_device_item_get_title (NetworkWidgetsDeviceItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_title;
	result = _tmp0_;
	return result;
}

void
network_widgets_device_item_set_title (NetworkWidgetsDeviceItem* self,
                                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = network_widgets_device_item_get_title (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_title);
		self->priv->_title = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, network_widgets_device_item_properties[NETWORK_WIDGETS_DEVICE_ITEM_TITLE_PROPERTY]);
	}
}

const gchar*
network_widgets_device_item_get_subtitle (NetworkWidgetsDeviceItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_subtitle;
	result = _tmp0_;
	return result;
}

void
network_widgets_device_item_set_subtitle (NetworkWidgetsDeviceItem* self,
                                          const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = network_widgets_device_item_get_subtitle (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_subtitle);
		self->priv->_subtitle = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, network_widgets_device_item_properties[NETWORK_WIDGETS_DEVICE_ITEM_SUBTITLE_PROPERTY]);
	}
}

GIcon*
network_widgets_device_item_get_icon (NetworkWidgetsDeviceItem* self)
{
	GIcon* result;
	GIcon* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon;
	result = _tmp0_;
	return result;
}

void
network_widgets_device_item_set_icon (NetworkWidgetsDeviceItem* self,
                                      GIcon* value)
{
	GIcon* old_value;
	g_return_if_fail (self != NULL);
	old_value = network_widgets_device_item_get_icon (self);
	if (old_value != value) {
		GIcon* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_icon);
		self->priv->_icon = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, network_widgets_device_item_properties[NETWORK_WIDGETS_DEVICE_ITEM_ICON_PROPERTY]);
	}
}

NetworkUtilsItemType
network_widgets_device_item_get_item_type (NetworkWidgetsDeviceItem* self)
{
	NetworkUtilsItemType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_item_type;
	return result;
}

void
network_widgets_device_item_set_item_type (NetworkWidgetsDeviceItem* self,
                                           NetworkUtilsItemType value)
{
	NetworkUtilsItemType old_value;
	g_return_if_fail (self != NULL);
	old_value = network_widgets_device_item_get_item_type (self);
	if (old_value != value) {
		self->priv->_item_type = value;
		g_object_notify_by_pspec ((GObject *) self, network_widgets_device_item_properties[NETWORK_WIDGETS_DEVICE_ITEM_ITEM_TYPE_PROPERTY]);
	}
}

static GObject *
network_widgets_device_item_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	NetworkWidgetsDeviceItem * self;
	GtkImage* row_image = NULL;
	GIcon* _tmp0_;
	GtkImage* _tmp1_ = NULL;
	GtkLabel* row_title = NULL;
	const gchar* _tmp2_;
	GtkLabel* _tmp3_ = NULL;
	GtkLabel* _tmp4_;
	GtkLabel* row_description = NULL;
	const gchar* _tmp5_;
	GtkLabel* _tmp6_ = NULL;
	GtkLabel* _tmp7_;
	GtkImage* _tmp8_ = NULL;
	GtkOverlay* overlay = NULL;
	GtkImage* _tmp9_;
	GtkWidget* _tmp10_;
	GtkOverlay* _tmp11_ = NULL;
	GtkOverlay* _tmp12_;
	GtkImage* _tmp13_;
	GtkGrid* row_grid = NULL;
	GtkGrid* _tmp14_;
	GtkGrid* _tmp15_;
	GtkOverlay* _tmp16_;
	GtkGrid* _tmp17_;
	GtkLabel* _tmp18_;
	GtkGrid* _tmp19_;
	GtkLabel* _tmp20_;
	GtkGrid* _tmp21_;
	GtkLabel* _tmp22_;
	GtkLabel* _tmp23_;
	GtkImage* _tmp24_;
	parent_class = G_OBJECT_CLASS (network_widgets_device_item_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_WIDGETS_TYPE_DEVICE_ITEM, NetworkWidgetsDeviceItem);
	_tmp0_ = self->priv->_icon;
	_tmp1_ = (GtkImage*) gtk_image_new_from_gicon (_tmp0_);
	gtk_image_set_icon_size (_tmp1_, GTK_ICON_SIZE_LARGE);
	g_object_ref_sink (_tmp1_);
	row_image = _tmp1_;
	_tmp2_ = self->priv->_title;
	_tmp3_ = (GtkLabel*) gtk_label_new (_tmp2_);
	gtk_label_set_ellipsize (_tmp3_, PANGO_ELLIPSIZE_END);
	gtk_widget_set_halign ((GtkWidget*) _tmp3_, GTK_ALIGN_START);
	gtk_widget_set_valign ((GtkWidget*) _tmp3_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp3_);
	row_title = _tmp3_;
	_tmp4_ = row_title;
	gtk_widget_add_css_class ((GtkWidget*) _tmp4_, GRANITE_STYLE_CLASS_H3_LABEL);
	_tmp5_ = self->priv->_subtitle;
	_tmp6_ = (GtkLabel*) gtk_label_new (_tmp5_);
	gtk_label_set_use_markup (_tmp6_, TRUE);
	gtk_label_set_ellipsize (_tmp6_, PANGO_ELLIPSIZE_END);
	gtk_widget_set_halign ((GtkWidget*) _tmp6_, GTK_ALIGN_START);
	gtk_widget_set_valign ((GtkWidget*) _tmp6_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp6_);
	row_description = _tmp6_;
	_tmp7_ = row_description;
	gtk_widget_add_css_class ((GtkWidget*) _tmp7_, GRANITE_STYLE_CLASS_SMALL_LABEL);
	_tmp8_ = (GtkImage*) gtk_image_new ();
	gtk_widget_set_halign ((GtkWidget*) _tmp8_, GTK_ALIGN_END);
	gtk_widget_set_valign ((GtkWidget*) _tmp8_, GTK_ALIGN_END);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->status_image);
	self->priv->status_image = _tmp8_;
	_tmp9_ = row_image;
	_tmp10_ = _g_object_ref0 ((GtkWidget*) _tmp9_);
	_tmp11_ = (GtkOverlay*) gtk_overlay_new ();
	gtk_overlay_set_child (_tmp11_, _tmp10_);
	_g_object_unref0 (_tmp10_);
	g_object_ref_sink (_tmp11_);
	overlay = _tmp11_;
	_tmp12_ = overlay;
	_tmp13_ = self->priv->status_image;
	gtk_overlay_add_overlay (_tmp12_, (GtkWidget*) _tmp13_);
	_tmp14_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp14_);
	row_grid = _tmp14_;
	_tmp15_ = row_grid;
	_tmp16_ = overlay;
	gtk_grid_attach (_tmp15_, (GtkWidget*) _tmp16_, 0, 0, 1, 2);
	_tmp17_ = row_grid;
	_tmp18_ = row_title;
	gtk_grid_attach (_tmp17_, (GtkWidget*) _tmp18_, 1, 0, 1, 1);
	_tmp19_ = row_grid;
	_tmp20_ = row_description;
	gtk_grid_attach (_tmp19_, (GtkWidget*) _tmp20_, 1, 1, 1, 1);
	_tmp21_ = row_grid;
	gtk_list_box_row_set_child ((GtkListBoxRow*) self, (GtkWidget*) _tmp21_);
	_tmp22_ = row_title;
	g_object_bind_property_with_closures ((GObject*) self, "title", (GObject*) _tmp22_, "label", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp23_ = row_description;
	g_object_bind_property_with_closures ((GObject*) self, "subtitle", (GObject*) _tmp23_, "label", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp24_ = row_image;
	g_object_bind_property_with_closures ((GObject*) self, "icon", (GObject*) _tmp24_, "gicon", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_g_object_unref0 (row_grid);
	_g_object_unref0 (overlay);
	_g_object_unref0 (row_description);
	_g_object_unref0 (row_title);
	_g_object_unref0 (row_image);
	return obj;
}

static void
network_widgets_device_item_class_init (NetworkWidgetsDeviceItemClass * klass,
                                        gpointer klass_data)
{
	network_widgets_device_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NetworkWidgetsDeviceItem_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_network_widgets_device_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_network_widgets_device_item_set_property;
	G_OBJECT_CLASS (klass)->constructor = network_widgets_device_item_constructor;
	G_OBJECT_CLASS (klass)->finalize = network_widgets_device_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_WIDGETS_DEVICE_ITEM_STATUS_TYPE_PROPERTY, network_widgets_device_item_properties[NETWORK_WIDGETS_DEVICE_ITEM_STATUS_TYPE_PROPERTY] = g_param_spec_enum ("status-type", "status-type", "status-type", SWITCHBOARD_SETTINGS_PAGE_TYPE_STATUS_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_WIDGETS_DEVICE_ITEM_DEVICE_PROPERTY, network_widgets_device_item_properties[NETWORK_WIDGETS_DEVICE_ITEM_DEVICE_PROPERTY] = g_param_spec_object ("device", "device", "device", nm_device_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_WIDGETS_DEVICE_ITEM_PAGE_PROPERTY, network_widgets_device_item_properties[NETWORK_WIDGETS_DEVICE_ITEM_PAGE_PROPERTY] = g_param_spec_object ("page", "page", "page", NETWORK_WIDGETS_TYPE_PAGE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_WIDGETS_DEVICE_ITEM_TITLE_PROPERTY, network_widgets_device_item_properties[NETWORK_WIDGETS_DEVICE_ITEM_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_WIDGETS_DEVICE_ITEM_SUBTITLE_PROPERTY, network_widgets_device_item_properties[NETWORK_WIDGETS_DEVICE_ITEM_SUBTITLE_PROPERTY] = g_param_spec_string ("subtitle", "subtitle", "subtitle", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_WIDGETS_DEVICE_ITEM_ICON_PROPERTY, network_widgets_device_item_properties[NETWORK_WIDGETS_DEVICE_ITEM_ICON_PROPERTY] = g_param_spec_object ("icon", "icon", "icon", g_icon_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_WIDGETS_DEVICE_ITEM_ITEM_TYPE_PROPERTY, network_widgets_device_item_properties[NETWORK_WIDGETS_DEVICE_ITEM_ITEM_TYPE_PROPERTY] = g_param_spec_enum ("item-type", "item-type", "item-type", NETWORK_UTILS_TYPE_ITEM_TYPE, NETWORK_UTILS_ITEM_TYPE_INVALID, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
network_widgets_device_item_instance_init (NetworkWidgetsDeviceItem * self,
                                           gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GThemedIcon* _tmp2_;
	self->priv = network_widgets_device_item_get_instance_private (self);
	self->priv->_device = NULL;
	self->priv->_page = NULL;
	_tmp0_ = g_strdup ("");
	self->priv->_title = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_subtitle = _tmp1_;
	_tmp2_ = (GThemedIcon*) g_themed_icon_new ("network-wired");
	self->priv->_icon = (GIcon*) _tmp2_;
	self->priv->_item_type = NETWORK_UTILS_ITEM_TYPE_INVALID;
}

static void
network_widgets_device_item_finalize (GObject * obj)
{
	NetworkWidgetsDeviceItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_WIDGETS_TYPE_DEVICE_ITEM, NetworkWidgetsDeviceItem);
	_g_object_unref0 (self->priv->_device);
	_g_object_unref0 (self->priv->_page);
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_subtitle);
	_g_object_unref0 (self->priv->_icon);
	_g_object_unref0 (self->priv->status_image);
	G_OBJECT_CLASS (network_widgets_device_item_parent_class)->finalize (obj);
}

static GType
network_widgets_device_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NetworkWidgetsDeviceItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) network_widgets_device_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetworkWidgetsDeviceItem), 0, (GInstanceInitFunc) network_widgets_device_item_instance_init, NULL };
	GType network_widgets_device_item_type_id;
	network_widgets_device_item_type_id = g_type_register_static (gtk_list_box_row_get_type (), "NetworkWidgetsDeviceItem", &g_define_type_info, 0);
	NetworkWidgetsDeviceItem_private_offset = g_type_add_instance_private (network_widgets_device_item_type_id, sizeof (NetworkWidgetsDeviceItemPrivate));
	return network_widgets_device_item_type_id;
}

GType
network_widgets_device_item_get_type (void)
{
	static volatile gsize network_widgets_device_item_type_id__once = 0;
	if (g_once_init_enter (&network_widgets_device_item_type_id__once)) {
		GType network_widgets_device_item_type_id;
		network_widgets_device_item_type_id = network_widgets_device_item_get_type_once ();
		g_once_init_leave (&network_widgets_device_item_type_id__once, network_widgets_device_item_type_id);
	}
	return network_widgets_device_item_type_id__once;
}

static void
_vala_network_widgets_device_item_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	NetworkWidgetsDeviceItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_WIDGETS_TYPE_DEVICE_ITEM, NetworkWidgetsDeviceItem);
	switch (property_id) {
		case NETWORK_WIDGETS_DEVICE_ITEM_DEVICE_PROPERTY:
		g_value_set_object (value, network_widgets_device_item_get_device (self));
		break;
		case NETWORK_WIDGETS_DEVICE_ITEM_PAGE_PROPERTY:
		g_value_set_object (value, network_widgets_device_item_get_page (self));
		break;
		case NETWORK_WIDGETS_DEVICE_ITEM_TITLE_PROPERTY:
		g_value_set_string (value, network_widgets_device_item_get_title (self));
		break;
		case NETWORK_WIDGETS_DEVICE_ITEM_SUBTITLE_PROPERTY:
		g_value_set_string (value, network_widgets_device_item_get_subtitle (self));
		break;
		case NETWORK_WIDGETS_DEVICE_ITEM_ICON_PROPERTY:
		g_value_set_object (value, network_widgets_device_item_get_icon (self));
		break;
		case NETWORK_WIDGETS_DEVICE_ITEM_ITEM_TYPE_PROPERTY:
		g_value_set_enum (value, network_widgets_device_item_get_item_type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_network_widgets_device_item_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	NetworkWidgetsDeviceItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_WIDGETS_TYPE_DEVICE_ITEM, NetworkWidgetsDeviceItem);
	switch (property_id) {
		case NETWORK_WIDGETS_DEVICE_ITEM_STATUS_TYPE_PROPERTY:
		network_widgets_device_item_set_status_type (self, g_value_get_enum (value));
		break;
		case NETWORK_WIDGETS_DEVICE_ITEM_DEVICE_PROPERTY:
		network_widgets_device_item_set_device (self, g_value_get_object (value));
		break;
		case NETWORK_WIDGETS_DEVICE_ITEM_PAGE_PROPERTY:
		network_widgets_device_item_set_page (self, g_value_get_object (value));
		break;
		case NETWORK_WIDGETS_DEVICE_ITEM_TITLE_PROPERTY:
		network_widgets_device_item_set_title (self, g_value_get_string (value));
		break;
		case NETWORK_WIDGETS_DEVICE_ITEM_SUBTITLE_PROPERTY:
		network_widgets_device_item_set_subtitle (self, g_value_get_string (value));
		break;
		case NETWORK_WIDGETS_DEVICE_ITEM_ICON_PROPERTY:
		network_widgets_device_item_set_icon (self, g_value_get_object (value));
		break;
		case NETWORK_WIDGETS_DEVICE_ITEM_ITEM_TYPE_PROPERTY:
		network_widgets_device_item_set_item_type (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

