/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(GEOLOCATION)

#include "JSGeolocationPosition.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSGeolocationCoordinates.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsGeolocationPositionPrototypeFunction_toJSON);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsGeolocationPositionConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsGeolocationPosition_coords);
static JSC_DECLARE_CUSTOM_GETTER(jsGeolocationPosition_timestamp);

class JSGeolocationPositionPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSGeolocationPositionPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSGeolocationPositionPrototype* ptr = new (NotNull, JSC::allocateCell<JSGeolocationPositionPrototype>(vm)) JSGeolocationPositionPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGeolocationPositionPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSGeolocationPositionPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGeolocationPositionPrototype, JSGeolocationPositionPrototype::Base);

using JSGeolocationPositionDOMConstructor = JSDOMConstructorNotConstructable<JSGeolocationPosition>;

template<> const ClassInfo JSGeolocationPositionDOMConstructor::s_info = { "GeolocationPosition"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGeolocationPositionDOMConstructor) };

template<> JSValue JSGeolocationPositionDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSGeolocationPositionDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "GeolocationPosition"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSGeolocationPosition::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 4> JSGeolocationPositionPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsGeolocationPositionConstructor, 0 } },
    HashTableValue { "coords"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGeolocationPosition_coords, 0 } },
    HashTableValue { "timestamp"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGeolocationPosition_timestamp, 0 } },
    HashTableValue { "toJSON"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGeolocationPositionPrototypeFunction_toJSON, 0 } },
};

const ClassInfo JSGeolocationPositionPrototype::s_info = { "GeolocationPosition"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGeolocationPositionPrototype) };

void JSGeolocationPositionPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSGeolocationPosition::info(), JSGeolocationPositionPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSGeolocationPosition::s_info = { "GeolocationPosition"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGeolocationPosition) };

JSGeolocationPosition::JSGeolocationPosition(Structure* structure, JSDOMGlobalObject& globalObject, Ref<GeolocationPosition>&& impl)
    : JSDOMWrapper<GeolocationPosition>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, GeolocationPosition>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSGeolocationPosition::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSGeolocationPositionPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSGeolocationPositionPrototype::create(vm, &globalObject, structure);
}

JSObject* JSGeolocationPosition::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSGeolocationPosition>(vm, globalObject);
}

JSValue JSGeolocationPosition::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSGeolocationPositionDOMConstructor, DOMConstructorID::GeolocationPosition>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSGeolocationPosition::destroy(JSC::JSCell* cell)
{
    JSGeolocationPosition* thisObject = static_cast<JSGeolocationPosition*>(cell);
    thisObject->JSGeolocationPosition::~JSGeolocationPosition();
}

JSC_DEFINE_CUSTOM_GETTER(jsGeolocationPositionConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSGeolocationPositionPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSGeolocationPosition::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsGeolocationPosition_coordsGetter(JSGlobalObject& lexicalGlobalObject, JSGeolocationPosition& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<GeolocationCoordinates>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.coords())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGeolocationPosition_coords, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGeolocationPosition>::get<jsGeolocationPosition_coordsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGeolocationPosition_timestampGetter(JSGlobalObject& lexicalGlobalObject, JSGeolocationPosition& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.timestamp())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGeolocationPosition_timestamp, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGeolocationPosition>::get<jsGeolocationPosition_timestampGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline EncodedJSValue jsGeolocationPositionPrototypeFunction_toJSONBody(JSGlobalObject* lexicalGlobalObject, CallFrame*, JSGeolocationPosition* castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    auto* result = constructEmptyObject(lexicalGlobalObject);
    auto coordsValue = toJS<IDLInterface<GeolocationCoordinates>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.coords());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "coords"_s), coordsValue);
    auto timestampValue = toJS<IDLUnsignedLongLong>(*lexicalGlobalObject, throwScope, impl.timestamp());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "timestamp"_s), timestampValue);
    return JSValue::encode(result);
}

JSC_DEFINE_HOST_FUNCTION(jsGeolocationPositionPrototypeFunction_toJSON, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGeolocationPosition>::call<jsGeolocationPositionPrototypeFunction_toJSONBody>(*lexicalGlobalObject, *callFrame, "toJSON");
}

JSC::GCClient::IsoSubspace* JSGeolocationPosition::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSGeolocationPosition, UseCustomHeapCellType::No>(vm, "JSGeolocationPosition"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForGeolocationPosition.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForGeolocationPosition = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForGeolocationPosition.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForGeolocationPosition = std::forward<decltype(space)>(space); }
    );
}

void JSGeolocationPosition::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSGeolocationPosition*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSGeolocationPositionOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSGeolocationPositionOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsGeolocationPosition = static_cast<JSGeolocationPosition*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsGeolocationPosition->protectedWrapped().ptr(), jsGeolocationPosition);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7GeolocationPosition@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore19GeolocationPositionE[]; }
#endif
template<std::same_as<GeolocationPosition> T>
static inline void verifyVTable(GeolocationPosition* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7GeolocationPosition@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore19GeolocationPositionE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // GeolocationPosition has subclasses. If GeolocationPosition has subclasses that get passed
        // to toJS() we currently require GeolocationPosition you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<GeolocationPosition>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<GeolocationPosition>(impl.ptr());
#endif
    return createWrapper<GeolocationPosition>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, GeolocationPosition& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

GeolocationPosition* JSGeolocationPosition::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSGeolocationPosition*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(GEOLOCATION)
