/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSURLPatternResult.h"

#include "IDLTypes.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertRecord.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMGlobalObject.h"
#include "JSURLPatternInit.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <wtf/Variant.h>
#include <wtf/Vector.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<URLPatternResult>> convertDictionary<URLPatternResult>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    URLPatternResult result;
    JSValue hashValue;
    if (isNullOrUndefined)
        hashValue = jsUndefined();
    else {
        hashValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "hash"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!hashValue.isUndefined()) {
        auto hashConversionResult = convert<IDLDictionary<URLPatternComponentResult>>(lexicalGlobalObject, hashValue);
        if (hashConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.hash = hashConversionResult.releaseReturnValue();
    }
    JSValue hostnameValue;
    if (isNullOrUndefined)
        hostnameValue = jsUndefined();
    else {
        hostnameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "hostname"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!hostnameValue.isUndefined()) {
        auto hostnameConversionResult = convert<IDLDictionary<URLPatternComponentResult>>(lexicalGlobalObject, hostnameValue);
        if (hostnameConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.hostname = hostnameConversionResult.releaseReturnValue();
    }
    JSValue inputsValue;
    if (isNullOrUndefined)
        inputsValue = jsUndefined();
    else {
        inputsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "inputs"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!inputsValue.isUndefined()) {
        auto inputsConversionResult = convert<IDLSequence<IDLUnion<IDLUSVString, IDLDictionary<URLPatternInit>>>>(lexicalGlobalObject, inputsValue);
        if (inputsConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.inputs = inputsConversionResult.releaseReturnValue();
    }
    JSValue passwordValue;
    if (isNullOrUndefined)
        passwordValue = jsUndefined();
    else {
        passwordValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "password"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!passwordValue.isUndefined()) {
        auto passwordConversionResult = convert<IDLDictionary<URLPatternComponentResult>>(lexicalGlobalObject, passwordValue);
        if (passwordConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.password = passwordConversionResult.releaseReturnValue();
    }
    JSValue pathnameValue;
    if (isNullOrUndefined)
        pathnameValue = jsUndefined();
    else {
        pathnameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "pathname"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!pathnameValue.isUndefined()) {
        auto pathnameConversionResult = convert<IDLDictionary<URLPatternComponentResult>>(lexicalGlobalObject, pathnameValue);
        if (pathnameConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.pathname = pathnameConversionResult.releaseReturnValue();
    }
    JSValue portValue;
    if (isNullOrUndefined)
        portValue = jsUndefined();
    else {
        portValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "port"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!portValue.isUndefined()) {
        auto portConversionResult = convert<IDLDictionary<URLPatternComponentResult>>(lexicalGlobalObject, portValue);
        if (portConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.port = portConversionResult.releaseReturnValue();
    }
    JSValue protocolValue;
    if (isNullOrUndefined)
        protocolValue = jsUndefined();
    else {
        protocolValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "protocol"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!protocolValue.isUndefined()) {
        auto protocolConversionResult = convert<IDLDictionary<URLPatternComponentResult>>(lexicalGlobalObject, protocolValue);
        if (protocolConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.protocol = protocolConversionResult.releaseReturnValue();
    }
    JSValue searchValue;
    if (isNullOrUndefined)
        searchValue = jsUndefined();
    else {
        searchValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "search"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!searchValue.isUndefined()) {
        auto searchConversionResult = convert<IDLDictionary<URLPatternComponentResult>>(lexicalGlobalObject, searchValue);
        if (searchConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.search = searchConversionResult.releaseReturnValue();
    }
    JSValue usernameValue;
    if (isNullOrUndefined)
        usernameValue = jsUndefined();
    else {
        usernameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "username"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!usernameValue.isUndefined()) {
        auto usernameConversionResult = convert<IDLDictionary<URLPatternComponentResult>>(lexicalGlobalObject, usernameValue);
        if (usernameConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.username = usernameConversionResult.releaseReturnValue();
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const URLPatternResult& dictionary)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLDictionary<URLPatternComponentResult>::isNullValue(dictionary.hash)) {
        auto hashValue = toJS<IDLDictionary<URLPatternComponentResult>>(lexicalGlobalObject, globalObject, throwScope, IDLDictionary<URLPatternComponentResult>::extractValueFromNullable(dictionary.hash));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "hash"_s), hashValue);
    }
    if (!IDLDictionary<URLPatternComponentResult>::isNullValue(dictionary.hostname)) {
        auto hostnameValue = toJS<IDLDictionary<URLPatternComponentResult>>(lexicalGlobalObject, globalObject, throwScope, IDLDictionary<URLPatternComponentResult>::extractValueFromNullable(dictionary.hostname));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "hostname"_s), hostnameValue);
    }
    if (!IDLSequence<IDLUnion<IDLUSVString, IDLDictionary<URLPatternInit>>>::isNullValue(dictionary.inputs)) {
        auto inputsValue = toJS<IDLSequence<IDLUnion<IDLUSVString, IDLDictionary<URLPatternInit>>>>(lexicalGlobalObject, globalObject, throwScope, IDLSequence<IDLUnion<IDLUSVString, IDLDictionary<URLPatternInit>>>::extractValueFromNullable(dictionary.inputs));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "inputs"_s), inputsValue);
    }
    if (!IDLDictionary<URLPatternComponentResult>::isNullValue(dictionary.password)) {
        auto passwordValue = toJS<IDLDictionary<URLPatternComponentResult>>(lexicalGlobalObject, globalObject, throwScope, IDLDictionary<URLPatternComponentResult>::extractValueFromNullable(dictionary.password));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "password"_s), passwordValue);
    }
    if (!IDLDictionary<URLPatternComponentResult>::isNullValue(dictionary.pathname)) {
        auto pathnameValue = toJS<IDLDictionary<URLPatternComponentResult>>(lexicalGlobalObject, globalObject, throwScope, IDLDictionary<URLPatternComponentResult>::extractValueFromNullable(dictionary.pathname));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "pathname"_s), pathnameValue);
    }
    if (!IDLDictionary<URLPatternComponentResult>::isNullValue(dictionary.port)) {
        auto portValue = toJS<IDLDictionary<URLPatternComponentResult>>(lexicalGlobalObject, globalObject, throwScope, IDLDictionary<URLPatternComponentResult>::extractValueFromNullable(dictionary.port));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "port"_s), portValue);
    }
    if (!IDLDictionary<URLPatternComponentResult>::isNullValue(dictionary.protocol)) {
        auto protocolValue = toJS<IDLDictionary<URLPatternComponentResult>>(lexicalGlobalObject, globalObject, throwScope, IDLDictionary<URLPatternComponentResult>::extractValueFromNullable(dictionary.protocol));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "protocol"_s), protocolValue);
    }
    if (!IDLDictionary<URLPatternComponentResult>::isNullValue(dictionary.search)) {
        auto searchValue = toJS<IDLDictionary<URLPatternComponentResult>>(lexicalGlobalObject, globalObject, throwScope, IDLDictionary<URLPatternComponentResult>::extractValueFromNullable(dictionary.search));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "search"_s), searchValue);
    }
    if (!IDLDictionary<URLPatternComponentResult>::isNullValue(dictionary.username)) {
        auto usernameValue = toJS<IDLDictionary<URLPatternComponentResult>>(lexicalGlobalObject, globalObject, throwScope, IDLDictionary<URLPatternComponentResult>::extractValueFromNullable(dictionary.username));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "username"_s), usernameValue);
    }
    return result;
}

template<> ConversionResult<IDLDictionary<URLPatternComponentResult>> convertDictionary<URLPatternComponentResult>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    URLPatternComponentResult result;
    JSValue groupsValue;
    if (isNullOrUndefined)
        groupsValue = jsUndefined();
    else {
        groupsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "groups"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!groupsValue.isUndefined()) {
        auto groupsConversionResult = convert<IDLRecord<IDLUSVString, IDLUnion<IDLUndefined, IDLUSVString>>>(lexicalGlobalObject, groupsValue);
        if (groupsConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.groups = groupsConversionResult.releaseReturnValue();
    }
    JSValue inputValue;
    if (isNullOrUndefined)
        inputValue = jsUndefined();
    else {
        inputValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "input"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!inputValue.isUndefined()) {
        auto inputConversionResult = convert<IDLUSVString>(lexicalGlobalObject, inputValue);
        if (inputConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.input = inputConversionResult.releaseReturnValue();
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const URLPatternComponentResult& dictionary)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLRecord<IDLUSVString, IDLUnion<IDLUndefined, IDLUSVString>>::isNullValue(dictionary.groups)) {
        auto groupsValue = toJS<IDLRecord<IDLUSVString, IDLUnion<IDLUndefined, IDLUSVString>>>(lexicalGlobalObject, globalObject, throwScope, IDLRecord<IDLUSVString, IDLUnion<IDLUndefined, IDLUSVString>>::extractValueFromNullable(dictionary.groups));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "groups"_s), groupsValue);
    }
    if (!IDLUSVString::isNullValue(dictionary.input)) {
        auto inputValue = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, IDLUSVString::extractValueFromNullable(dictionary.input));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "input"_s), inputValue);
    }
    return result;
}

} // namespace WebCore

