#include "nv_push_cla140.h"

#include <stdio.h>





const char *P_PARSE_NVA040_MTHD(uint16_t idx) ATTRIBUTE_COLD;
void P_DUMP_NVA040_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                                   const char *prefix) ATTRIBUTE_COLD;

const char*
P_PARSE_NVA140_MTHD(uint16_t idx)
{
    switch (idx) {

  
    default:

    return P_PARSE_NVA040_MTHD(idx);

            case NVA140_SET_NOTIFY_A:
        return "NVA140_SET_NOTIFY_A";
                                                        case NVA140_OFFSET_OUT_UPPER:
        return "NVA140_OFFSET_OUT_UPPER";
                                case NVA140_SET_DST_ORIGIN_BYTES_X:
        return "NVA140_SET_DST_ORIGIN_BYTES_X";
    case NVA140_SET_DST_ORIGIN_SAMPLES_Y:
        return "NVA140_SET_DST_ORIGIN_SAMPLES_Y";
            case NVA140_SET_I2M_SEMAPHORE_A:
        return "NVA140_SET_I2M_SEMAPHORE_A";
                                                                                                                                                                            
    }
}

void
P_DUMP_NVA140_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                         const char *prefix)
{
    UNUSED uint32_t parsed;
    switch (idx) {

  
    default:

    P_DUMP_NVA040_MTHD_DATA(fp, idx, data, prefix);
    break;

          
    case NVA140_SET_NOTIFY_A:

    
        parsed = (data >> 0) & ((1u << 25) - 1);
        fprintf(fp, "%s.ADDRESS_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                                                      
    case NVA140_OFFSET_OUT_UPPER:

    
        parsed = (data >> 0) & ((1u << 25) - 1);
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                              
    case NVA140_SET_DST_ORIGIN_BYTES_X:

    
        parsed = (data >> 0) & ((1u << 21) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVA140_SET_DST_ORIGIN_SAMPLES_Y:

    
        parsed = (data >> 0) & ((1u << 17) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
          
    case NVA140_SET_I2M_SEMAPHORE_A:

    
        parsed = (data >> 0) & ((1u << 25) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                                                                                                                                                                                }
}
