/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.syntaxpane;

import de.sciss.syntaxpane.SyntaxStyle;
import de.sciss.syntaxpane.Token;
import de.sciss.syntaxpane.TokenType;
import de.sciss.syntaxpane.util.Configuration;
import de.sciss.syntaxpane.util.JarServiceProvider;
import java.awt.Color;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;

public class SyntaxStyles {
    public static final Pattern STYLE_PATTERN = Pattern.compile("Style\\.(\\w+)");
    Map<TokenType, SyntaxStyle> styles;
    private static final Logger LOG = Logger.getLogger(SyntaxStyles.class.getName());
    private static SyntaxStyle DEFAULT_STYLE = new SyntaxStyle(Color.BLACK, 0);
    private static SyntaxStyles instance = SyntaxStyles.createInstance();

    public void mergeStyles(Properties styles) {
        for (Map.Entry<Object, Object> e : styles.entrySet()) {
            String tokenType = e.getKey().toString();
            String style = e.getValue().toString();
            try {
                TokenType tt = TokenType.valueOf(tokenType);
                SyntaxStyle tokenStyle = new SyntaxStyle(style);
                this.put(tt, tokenStyle);
            }
            catch (IllegalArgumentException ex) {
                LOG.warning("illegal token type or style for: " + tokenType);
            }
        }
    }

    private SyntaxStyles() {
    }

    private static SyntaxStyles createInstance() {
        SyntaxStyles syntaxstyles = new SyntaxStyles();
        Properties styles = JarServiceProvider.readProperties(SyntaxStyles.class);
        syntaxstyles.mergeStyles(styles);
        return syntaxstyles;
    }

    public static SyntaxStyles getInstance() {
        return instance;
    }

    public static SyntaxStyles read(Configuration config) {
        SyntaxStyles ss = SyntaxStyles.createInstance();
        for (Configuration.StringKeyMatcher m : config.getKeys(STYLE_PATTERN)) {
            String type = m.group1;
            try {
                ss.put(TokenType.valueOf(type), new SyntaxStyle(m.value));
            }
            catch (IllegalArgumentException e) {
                Logger.getLogger(SyntaxStyles.class.getName()).warning(String.format("Invalid Token Type [%s] for Style of ", type));
            }
        }
        return ss;
    }

    public void put(TokenType type, SyntaxStyle style) {
        if (this.styles == null) {
            this.styles = new HashMap<TokenType, SyntaxStyle>();
        }
        this.styles.put(type, style);
    }

    public SyntaxStyle getStyle(TokenType type) {
        if (this.styles != null && this.styles.containsKey((Object)type)) {
            return this.styles.get((Object)type);
        }
        return DEFAULT_STYLE;
    }

    public int drawText(Segment segment, int x, int y, Graphics graphics, TabExpander e, Token token) {
        SyntaxStyle s = this.getStyle(token.type);
        return s.drawText(segment, x, y, graphics, e, token.start);
    }
}

