/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.cc.impl.fingerprint;

import java.io.File;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.internal.configuration.problems.StructuredMessage;
import org.gradle.internal.file.FileType;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/gradle/internal/cc/impl/fingerprint/ConfigurationCacheInputFileChecker;", "", "host", "Lorg/gradle/internal/cc/impl/fingerprint/ConfigurationCacheInputFileChecker$Host;", "<init>", "(Lorg/gradle/internal/cc/impl/fingerprint/ConfigurationCacheInputFileChecker$Host;)V", "check", "Lorg/gradle/internal/configuration/problems/StructuredMessage$Builder;", "file", "Ljava/io/File;", "originalHash", "Lorg/gradle/internal/hash/HashCode;", "checkFileUpToDateStatus", "Lorg/gradle/internal/cc/impl/fingerprint/ConfigurationCacheInputFileChecker$FileUpToDateStatus;", "Host", "FileUpToDateStatus", "configuration-cache"})
public final class ConfigurationCacheInputFileChecker {
    @NotNull
    private final Host host;

    public ConfigurationCacheInputFileChecker(@NotNull Host host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.host = host;
    }

    @Nullable
    public final StructuredMessage.Builder check(@NotNull StructuredMessage.Builder $this$check, @NotNull File file, @NotNull HashCode originalHash) {
        StructuredMessage.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$check, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)originalHash, (String)"originalHash");
        switch (WhenMappings.$EnumSwitchMapping$0[this.checkFileUpToDateStatus(file, originalHash).ordinal()]) {
            case 1: {
                builder = $this$check.text("file ").reference(this.host.displayNameOf(file)).text(" has changed");
                break;
            }
            case 2: {
                builder = $this$check.text("file ").reference(this.host.displayNameOf(file)).text(" has been removed");
                break;
            }
            case 3: {
                builder = $this$check.text("file ").reference(this.host.displayNameOf(file)).text(" has been replaced by a directory");
                break;
            }
            case 4: {
                builder = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return builder;
    }

    @NotNull
    public final FileUpToDateStatus checkFileUpToDateStatus(@NotNull File file, @NotNull HashCode originalHash) {
        FileUpToDateStatus fileUpToDateStatus;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)originalHash, (String)"originalHash");
        Pair<HashCode, FileType> pair = this.host.hashCodeAndTypeOf(file);
        HashCode hash = (HashCode)pair.component1();
        FileType type = (FileType)pair.component2();
        if (Intrinsics.areEqual((Object)hash, (Object)originalHash)) {
            return FileUpToDateStatus.Unchanged;
        }
        switch (WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
            case 1: {
                fileUpToDateStatus = FileUpToDateStatus.ContentsChanged;
                break;
            }
            case 2: {
                fileUpToDateStatus = FileUpToDateStatus.TypeChanged;
                break;
            }
            case 3: {
                fileUpToDateStatus = FileUpToDateStatus.Removed;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return fileUpToDateStatus;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/gradle/internal/cc/impl/fingerprint/ConfigurationCacheInputFileChecker$FileUpToDateStatus;", "", "<init>", "(Ljava/lang/String;I)V", "Unchanged", "ContentsChanged", "TypeChanged", "Removed", "configuration-cache"})
    public static final class FileUpToDateStatus
    extends Enum<FileUpToDateStatus> {
        public static final /* enum */ FileUpToDateStatus Unchanged = new FileUpToDateStatus();
        public static final /* enum */ FileUpToDateStatus ContentsChanged = new FileUpToDateStatus();
        public static final /* enum */ FileUpToDateStatus TypeChanged = new FileUpToDateStatus();
        public static final /* enum */ FileUpToDateStatus Removed = new FileUpToDateStatus();
        private static final /* synthetic */ FileUpToDateStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static FileUpToDateStatus[] values() {
            return (FileUpToDateStatus[])$VALUES.clone();
        }

        public static FileUpToDateStatus valueOf(String value) {
            return Enum.valueOf(FileUpToDateStatus.class, value);
        }

        @NotNull
        public static EnumEntries<FileUpToDateStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = fileUpToDateStatusArray = new FileUpToDateStatus[]{FileUpToDateStatus.Unchanged, FileUpToDateStatus.ContentsChanged, FileUpToDateStatus.TypeChanged, FileUpToDateStatus.Removed};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @ServiceScope(value={Scope.BuildTree.class})
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\bg\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u001c\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H&\u00a8\u0006\f\u00c0\u0006\u0003"}, d2={"Lorg/gradle/internal/cc/impl/fingerprint/ConfigurationCacheInputFileChecker$Host;", "", "hashCodeOf", "Lorg/gradle/internal/hash/HashCode;", "file", "Ljava/io/File;", "hashCodeAndTypeOf", "Lkotlin/Pair;", "Lorg/gradle/internal/file/FileType;", "displayNameOf", "", "fileOrDirectory", "configuration-cache"})
    public static interface Host {
        @NotNull
        public HashCode hashCodeOf(@NotNull File var1);

        @NotNull
        public Pair<HashCode, FileType> hashCodeAndTypeOf(@NotNull File var1);

        @NotNull
        public String displayNameOf(@NotNull File var1);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[FileUpToDateStatus.values().length];
            try {
                nArray[FileUpToDateStatus.ContentsChanged.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FileUpToDateStatus.Removed.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FileUpToDateStatus.TypeChanged.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FileUpToDateStatus.Unchanged.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[FileType.values().length];
            try {
                nArray[FileType.RegularFile.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FileType.Directory.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FileType.Missing.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

