/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal;

import jakarta.persistence.MapKeyTemporal;
import jakarta.persistence.TemporalType;
import java.util.Locale;
import org.hibernate.MappingException;
import org.hibernate.boot.jaxb.mapping.spi.JaxbUserTypeImpl;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.annotations.internal.MapKeyJavaTypeAnnotation;
import org.hibernate.boot.models.annotations.internal.MapKeyTemporalJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.MapKeyTypeAnnotation;
import org.hibernate.boot.models.xml.internal.AbstractUserTypeCases;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.usertype.UserType;

public class UserTypeCasesMapKey
extends AbstractUserTypeCases {
    public static final UserTypeCasesMapKey MAP_KEY_USER_TYPE_CASES = new UserTypeCasesMapKey();

    public static void applyJavaTypeAnnotationStatic(MutableMemberDetails memberDetails, Class<? extends BasicJavaType<?>> descriptor, XmlDocumentContext xmlDocumentContext) {
        MapKeyJavaTypeAnnotation javaTypeAnnotation = (MapKeyJavaTypeAnnotation)memberDetails.applyAnnotationUsage(HibernateAnnotations.MAP_KEY_JAVA_TYPE, xmlDocumentContext.getModelBuildingContext());
        javaTypeAnnotation.value(descriptor);
    }

    @Override
    protected void applyJavaTypeAnnotation(MutableMemberDetails memberDetails, Class<? extends BasicJavaType<?>> descriptor, XmlDocumentContext xmlDocumentContext) {
        UserTypeCasesMapKey.applyJavaTypeAnnotationStatic(memberDetails, descriptor, xmlDocumentContext);
    }

    @Override
    protected void applyTemporalPrecision(MutableMemberDetails memberDetails, TemporalType temporalType, XmlDocumentContext xmlDocumentContext) {
        MapKeyTemporal directUsage = (MapKeyTemporal)memberDetails.getDirectAnnotationUsage(MapKeyTemporal.class);
        if (directUsage != null) {
            if (directUsage.value() != temporalType) {
                throw new MappingException(String.format(Locale.ROOT, "Mismatch in expected TemporalType on %s; found %s and %s", memberDetails, directUsage.value(), temporalType));
            }
            return;
        }
        MapKeyTemporalJpaAnnotation temporalAnnotation = (MapKeyTemporalJpaAnnotation)((Object)memberDetails.applyAnnotationUsage(JpaAnnotations.MAP_KEY_TEMPORAL, xmlDocumentContext.getModelBuildingContext()));
        temporalAnnotation.value(temporalType);
    }

    @Override
    public void handleGeneral(JaxbUserTypeImpl jaxbType, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        ClassDetails userTypeImpl = XmlAnnotationHelper.resolveJavaType(jaxbType.getValue(), xmlDocumentContext);
        assert (userTypeImpl.isImplementor(UserType.class));
        MapKeyTypeAnnotation typeAnn = (MapKeyTypeAnnotation)memberDetails.applyAnnotationUsage(HibernateAnnotations.MAP_KEY_TYPE, xmlDocumentContext.getModelBuildingContext());
        typeAnn.value(userTypeImpl.toJavaClass());
        typeAnn.parameters(XmlAnnotationHelper.collectParameters(jaxbType.getParameters(), xmlDocumentContext));
    }
}

