/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.InternalAggregations;
import org.opensearch.search.aggregations.InternalMultiBucketAggregation;
import org.opensearch.search.aggregations.bucket.LocalBucketCountThresholds;
import org.opensearch.search.aggregations.bucket.terms.BucketSignificancePriorityQueue;
import org.opensearch.search.aggregations.bucket.terms.SignificantTerms;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregator;
import org.opensearch.search.aggregations.bucket.terms.heuristic.SignificanceHeuristic;

public abstract class InternalSignificantTerms<A extends InternalSignificantTerms<A, B>, B extends Bucket<B>>
extends InternalMultiBucketAggregation<A, B>
implements SignificantTerms {
    public static final String SCORE = "score";
    public static final String BG_COUNT = "bg_count";
    protected final int requiredSize;
    protected final long minDocCount;
    protected final TermsAggregator.BucketCountThresholds bucketCountThresholds;

    protected InternalSignificantTerms(String name, TermsAggregator.BucketCountThresholds bucketCountThresholds, Map<String, Object> metadata) {
        super(name, metadata);
        this.requiredSize = bucketCountThresholds.getRequiredSize();
        this.minDocCount = bucketCountThresholds.getMinDocCount();
        this.bucketCountThresholds = bucketCountThresholds;
    }

    protected InternalSignificantTerms(StreamInput in) throws IOException {
        super(in);
        this.requiredSize = InternalSignificantTerms.readSize(in);
        this.minDocCount = in.readVLong();
        this.bucketCountThresholds = new TermsAggregator.CoordinatorBucketCountThresholds(this.minDocCount, -1L, this.requiredSize, -1);
    }

    @Override
    protected final void doWriteTo(StreamOutput out) throws IOException {
        InternalSignificantTerms.writeSize(this.requiredSize, out);
        out.writeVLong(this.minDocCount);
        this.writeTermTypeInfoTo(out);
    }

    protected abstract void writeTermTypeInfoTo(StreamOutput var1) throws IOException;

    @Override
    public abstract List<B> getBuckets();

    /*
     * WARNING - void declaration
     */
    @Override
    public InternalAggregation reduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        void var14_22;
        LocalBucketCountThresholds localBucketCountThresholds = reduceContext.asLocalBucketCountThresholds(this.bucketCountThresholds);
        long globalSubsetSize = 0L;
        long globalSupersetSize = 0L;
        for (InternalAggregation internalAggregation : aggregations) {
            InternalSignificantTerms terms = (InternalSignificantTerms)internalAggregation;
            globalSubsetSize += terms.getSubsetSize();
            if (reduceContext.isSliceLevel()) {
                globalSupersetSize = terms.getSupersetSize();
                continue;
            }
            globalSupersetSize += terms.getSupersetSize();
        }
        HashMap buckets = new HashMap();
        for (InternalAggregation aggregation : aggregations) {
            InternalSignificantTerms terms = (InternalSignificantTerms)aggregation;
            for (Object bucket : terms.getBuckets()) {
                void var14_16;
                List list = (List)buckets.get(bucket.getKeyAsString());
                if (list == null) {
                    ArrayList arrayList = new ArrayList(aggregations.size());
                    buckets.put(bucket.getKeyAsString(), arrayList);
                }
                var14_16.add(this.createBucket(((Bucket)bucket).getSubsetDf(), globalSubsetSize, ((Bucket)bucket).getSupersetDf(), globalSupersetSize, ((Bucket)bucket).aggregations, bucket));
            }
        }
        SignificanceHeuristic significanceHeuristic = this.getSignificanceHeuristic().rewrite(reduceContext);
        boolean isCoordinatorPartialReduce = !reduceContext.isFinalReduce() && !reduceContext.isSliceLevel();
        int size = !isCoordinatorPartialReduce ? Math.min(localBucketCountThresholds.getRequiredSize(), buckets.size()) : buckets.size();
        BucketSignificancePriorityQueue ordered = new BucketSignificancePriorityQueue(size);
        for (Map.Entry entry : buckets.entrySet()) {
            boolean meetsThresholds;
            List sameTermBuckets = (List)entry.getValue();
            InternalMultiBucketAggregation.InternalBucket b = this.reduceBucket(sameTermBuckets, reduceContext);
            ((Bucket)b).updateScore(significanceHeuristic);
            boolean bl = meetsThresholds = ((Bucket)b).subsetDf >= localBucketCountThresholds.getMinDocCount() && (((Bucket)b).score > 0.0 || reduceContext.isSliceLevel());
            if (isCoordinatorPartialReduce || meetsThresholds) {
                Bucket removed = (Bucket)ordered.insertWithOverflow(b);
                if (removed == null) {
                    reduceContext.consumeBucketsAndMaybeBreak(1);
                    continue;
                }
                reduceContext.consumeBucketsAndMaybeBreak(-InternalSignificantTerms.countInnerBucket(removed));
                continue;
            }
            reduceContext.consumeBucketsAndMaybeBreak(-InternalSignificantTerms.countInnerBucket(b));
        }
        Bucket[] list = this.createBucketsArray(ordered.size());
        int n = ordered.size() - 1;
        while (var14_22 >= 0) {
            list[var14_22] = (Bucket)ordered.pop();
            --var14_22;
        }
        return this.create(globalSubsetSize, globalSupersetSize, Arrays.asList(list));
    }

    @Override
    protected B reduceBucket(List<B> buckets, InternalAggregation.ReduceContext context) {
        assert (buckets.size() > 0);
        long subsetDf = 0L;
        long supersetDf = 0L;
        ArrayList<InternalAggregations> aggregationsList = new ArrayList<InternalAggregations>(buckets.size());
        for (Bucket bucket : buckets) {
            subsetDf += bucket.subsetDf;
            supersetDf = context.isSliceLevel() ? bucket.supersetDf : (supersetDf += bucket.supersetDf);
            aggregationsList.add(bucket.aggregations);
        }
        InternalAggregations aggs = InternalAggregations.reduce(aggregationsList, context);
        return (B)this.createBucket(subsetDf, ((Bucket)buckets.get((int)0)).subsetSize, supersetDf, ((Bucket)buckets.get((int)0)).supersetSize, aggs, (Bucket)buckets.get(0));
    }

    abstract B createBucket(long var1, long var3, long var5, long var7, InternalAggregations var9, B var10);

    protected abstract A create(long var1, long var3, List<B> var5);

    protected abstract B[] createBucketsArray(int var1);

    protected abstract long getSubsetSize();

    protected abstract long getSupersetSize();

    protected abstract SignificanceHeuristic getSignificanceHeuristic();

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.minDocCount, this.requiredSize);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalSignificantTerms that = (InternalSignificantTerms)obj;
        return Objects.equals(this.minDocCount, that.minDocCount) && Objects.equals(this.requiredSize, that.requiredSize);
    }

    public static abstract class Bucket<B extends Bucket<B>>
    extends InternalMultiBucketAggregation.InternalBucket
    implements SignificantTerms.Bucket {
        long subsetDf;
        long subsetSize;
        long supersetDf;
        long supersetSize;
        long bucketOrd;
        double score;
        InternalAggregations aggregations;
        final transient DocValueFormat format;

        protected Bucket(long subsetDf, long subsetSize, long supersetDf, long supersetSize, InternalAggregations aggregations, DocValueFormat format) {
            this.subsetSize = subsetSize;
            this.supersetSize = supersetSize;
            this.subsetDf = subsetDf;
            this.supersetDf = supersetDf;
            this.aggregations = aggregations;
            this.format = format;
        }

        protected Bucket(StreamInput in, long subsetSize, long supersetSize, DocValueFormat format) {
            this.subsetSize = subsetSize;
            this.supersetSize = supersetSize;
            this.format = format;
        }

        @Override
        public long getSubsetDf() {
            return this.subsetDf;
        }

        @Override
        public long getSupersetDf() {
            return this.supersetDf;
        }

        @Override
        public long getSupersetSize() {
            return this.supersetSize;
        }

        @Override
        public long getSubsetSize() {
            return this.subsetSize;
        }

        void updateScore(SignificanceHeuristic significanceHeuristic) {
            this.score = significanceHeuristic.getScore(this.subsetDf, this.subsetSize, this.supersetDf, this.supersetSize);
        }

        @Override
        public long getDocCount() {
            return this.subsetDf;
        }

        @Override
        public Aggregations getAggregations() {
            return this.aggregations;
        }

        @Override
        public double getSignificanceScore() {
            return this.score;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Bucket that = (Bucket)o;
            return this.bucketOrd == that.bucketOrd && Double.compare(that.score, this.score) == 0 && Objects.equals(this.aggregations, that.aggregations) && Objects.equals(this.format, that.format);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.bucketOrd, this.aggregations, this.score, this.format);
        }

        public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.keyToXContent(builder);
            builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.getDocCount());
            builder.field(InternalSignificantTerms.SCORE, this.score);
            builder.field(InternalSignificantTerms.BG_COUNT, this.supersetDf);
            this.aggregations.toXContentInternal(builder, params);
            builder.endObject();
            return builder;
        }

        protected abstract XContentBuilder keyToXContent(XContentBuilder var1) throws IOException;

        @FunctionalInterface
        public static interface Reader<B extends Bucket<B>> {
            public B read(StreamInput var1, long var2, long var4, DocValueFormat var6) throws IOException;
        }
    }
}

