function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) { o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) { if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } } return t; }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import React from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { OuiDescriptionListTitle } from './description_list_title';
import { OuiDescriptionListDescription } from './description_list_description';
import { keysOf } from '../common';
var typesToClassNameMap = {
  row: 'ouiDescriptionList--row',
  inline: 'ouiDescriptionList--inline',
  column: 'ouiDescriptionList--column',
  responsiveColumn: 'ouiDescriptionList--responsiveColumn'
};
export var TYPES = keysOf(typesToClassNameMap);
var alignmentsToClassNameMap = {
  center: 'ouiDescriptionList--center',
  left: ''
};
export var ALIGNMENTS = keysOf(alignmentsToClassNameMap);
var textStylesToClassNameMap = {
  normal: '',
  reverse: 'ouiDescriptionList--reverse'
};
export var TEXT_STYLES = keysOf(textStylesToClassNameMap);
export var OuiDescriptionList = function OuiDescriptionList(_ref) {
  var _ref$align = _ref.align,
    align = _ref$align === void 0 ? 'left' : _ref$align,
    children = _ref.children,
    className = _ref.className,
    _ref$compressed = _ref.compressed,
    compressed = _ref$compressed === void 0 ? false : _ref$compressed,
    descriptionProps = _ref.descriptionProps,
    listItems = _ref.listItems,
    _ref$textStyle = _ref.textStyle,
    textStyle = _ref$textStyle === void 0 ? 'normal' : _ref$textStyle,
    titleProps = _ref.titleProps,
    _ref$type = _ref.type,
    type = _ref$type === void 0 ? 'row' : _ref$type,
    rest = _objectWithoutProperties(_ref, ["align", "children", "className", "compressed", "descriptionProps", "listItems", "textStyle", "titleProps", "type"]);
  var classes = classNames('ouiDescriptionList', type ? typesToClassNameMap[type] : undefined, align ? alignmentsToClassNameMap[align] : undefined, textStyle ? textStylesToClassNameMap[textStyle] : undefined, {
    'ouiDescriptionList--compressed': compressed
  }, className);
  var childrenOrListItems = null;
  if (listItems) {
    childrenOrListItems = listItems.map(function (item, index) {
      return [/*#__PURE__*/React.createElement(OuiDescriptionListTitle, _extends({
        key: "title-".concat(index)
      }, titleProps), item.title), /*#__PURE__*/React.createElement(OuiDescriptionListDescription, _extends({
        key: "description-".concat(index)
      }, descriptionProps), item.description)];
    });
  } else {
    childrenOrListItems = children;
  }
  return /*#__PURE__*/React.createElement("dl", _extends({
    className: classes
  }, rest), childrenOrListItems);
};

/* OUI -> EUI Aliases: Build-Time */
OuiDescriptionList.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  listItems: PropTypes.arrayOf(PropTypes.shape({
    title: PropTypes.any.isRequired,
    description: PropTypes.any.isRequired
  }).isRequired),
  /**
     * Text alignment
     */
  align: PropTypes.oneOf(["center", "left"]),
  /**
     * Smaller text and condensed spacing
     */
  compressed: PropTypes.bool,
  /**
     * How should the content be styled, by default
     * this will emphasize the title
     */
  textStyle: PropTypes.oneOf(["normal", "reverse"]),
  /**
     * How each item should be laid out
     */
  type: PropTypes.oneOf(["row", "inline", "column", "responsiveColumn"]),
  /**
     * Props object to be passed to `OuiDescriptionListTitle`
     */
  titleProps: PropTypes.any,
  /**
     * Props object to be passed to `OuiDescriptionListDescription`
     */
  descriptionProps: PropTypes.any
};
/* OUI -> EUI Aliases: Build-Time */export { EuiDescriptionList } from '../../eui_components/description_list/description_list';