/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.RouteServerPeerLivenessMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteServerBgpOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteServerBgpOptions> {
    private static final SdkField<Long> PEER_ASN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("PeerAsn").getter(RouteServerBgpOptions.getter(RouteServerBgpOptions::peerAsn)).setter(RouteServerBgpOptions.setter(Builder::peerAsn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerAsn").unmarshallLocationName("peerAsn").build()}).build();
    private static final SdkField<String> PEER_LIVENESS_DETECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PeerLivenessDetection").getter(RouteServerBgpOptions.getter(RouteServerBgpOptions::peerLivenessDetectionAsString)).setter(RouteServerBgpOptions.setter(Builder::peerLivenessDetection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerLivenessDetection").unmarshallLocationName("peerLivenessDetection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PEER_ASN_FIELD, PEER_LIVENESS_DETECTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouteServerBgpOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long peerAsn;
    private final String peerLivenessDetection;

    private RouteServerBgpOptions(BuilderImpl builder) {
        this.peerAsn = builder.peerAsn;
        this.peerLivenessDetection = builder.peerLivenessDetection;
    }

    public final Long peerAsn() {
        return this.peerAsn;
    }

    public final RouteServerPeerLivenessMode peerLivenessDetection() {
        return RouteServerPeerLivenessMode.fromValue(this.peerLivenessDetection);
    }

    public final String peerLivenessDetectionAsString() {
        return this.peerLivenessDetection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.peerAsn());
        hashCode = 31 * hashCode + Objects.hashCode(this.peerLivenessDetectionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteServerBgpOptions)) {
            return false;
        }
        RouteServerBgpOptions other = (RouteServerBgpOptions)obj;
        return Objects.equals(this.peerAsn(), other.peerAsn()) && Objects.equals(this.peerLivenessDetectionAsString(), other.peerLivenessDetectionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RouteServerBgpOptions").add("PeerAsn", (Object)this.peerAsn()).add("PeerLivenessDetection", (Object)this.peerLivenessDetectionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PeerAsn": {
                return Optional.ofNullable(clazz.cast(this.peerAsn()));
            }
            case "PeerLivenessDetection": {
                return Optional.ofNullable(clazz.cast(this.peerLivenessDetectionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PeerAsn", PEER_ASN_FIELD);
        map.put("PeerLivenessDetection", PEER_LIVENESS_DETECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteServerBgpOptions, T> g) {
        return obj -> g.apply((RouteServerBgpOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long peerAsn;
        private String peerLivenessDetection;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteServerBgpOptions model) {
            this.peerAsn(model.peerAsn);
            this.peerLivenessDetection(model.peerLivenessDetection);
        }

        public final Long getPeerAsn() {
            return this.peerAsn;
        }

        public final void setPeerAsn(Long peerAsn) {
            this.peerAsn = peerAsn;
        }

        @Override
        public final Builder peerAsn(Long peerAsn) {
            this.peerAsn = peerAsn;
            return this;
        }

        public final String getPeerLivenessDetection() {
            return this.peerLivenessDetection;
        }

        public final void setPeerLivenessDetection(String peerLivenessDetection) {
            this.peerLivenessDetection = peerLivenessDetection;
        }

        @Override
        public final Builder peerLivenessDetection(String peerLivenessDetection) {
            this.peerLivenessDetection = peerLivenessDetection;
            return this;
        }

        @Override
        public final Builder peerLivenessDetection(RouteServerPeerLivenessMode peerLivenessDetection) {
            this.peerLivenessDetection(peerLivenessDetection == null ? null : peerLivenessDetection.toString());
            return this;
        }

        public RouteServerBgpOptions build() {
            return new RouteServerBgpOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteServerBgpOptions> {
        public Builder peerAsn(Long var1);

        public Builder peerLivenessDetection(String var1);

        public Builder peerLivenessDetection(RouteServerPeerLivenessMode var1);
    }
}

