/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.cache;

import com.google.common.annotations.VisibleForTesting;
import java.util.function.BiPredicate;
import lombok.Generated;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.neuralsearch.sparse.cache.CircuitBreakerManager;
import org.opensearch.neuralsearch.sparse.cache.RamBytesRecorder;

public class MemoryUsageManager {
    private static volatile MemoryUsageManager instance;
    private RamBytesRecorder memoryUsageTracker = new RamBytesRecorder();

    protected MemoryUsageManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MemoryUsageManager getInstance() {
        if (instance != null) return instance;
        Class<MemoryUsageManager> clazz = MemoryUsageManager.class;
        synchronized (MemoryUsageManager.class) {
            if (instance != null) return instance;
            instance = new MemoryUsageManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void setLimitAndOverhead(ByteSizeValue limit, double overhead) {
        this.memoryUsageTracker.setCanRecordIncrementChecker(this.getInternalAndCbPredicate(limit, overhead));
    }

    @VisibleForTesting
    BiPredicate<Long, Long> getInternalAndCbPredicate(ByteSizeValue limit, double overhead) {
        return (bytes, targetedTotalBytes) -> (long)((double)targetedTotalBytes.longValue() * overhead) <= limit.getBytes() && CircuitBreakerManager.addMemoryUsage(bytes, "seismic");
    }

    @Generated
    public void setMemoryUsageTracker(RamBytesRecorder memoryUsageTracker) {
        this.memoryUsageTracker = memoryUsageTracker;
    }

    @Generated
    public RamBytesRecorder getMemoryUsageTracker() {
        return this.memoryUsageTracker;
    }
}

