# coding: utf-8

"""
    NetHSM
    All endpoints expect exactly the specified JSON. Additional properties will cause a Bad Request Error (400). All HTTP errors contain a JSON structure with an explanation of type string. All [base64](https://tools.ietf.org/html/rfc4648#section-4) encoded values are Big Endian.   # noqa: E501
    The version of the OpenAPI document: v1
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

from __future__ import annotations
from nethsm.client.shared_imports.schema_imports import *  # pyright: ignore [reportWildcardImportFromLibrary]


from nethsm.client.components.schema import key_mechanisms
from nethsm.client.components.schema import key_restrictions
from nethsm.client.components.schema import pem_private_key
Properties = typing.TypedDict(
    'Properties',
    {
        "mechanisms": typing.Type[key_mechanisms.KeyMechanisms],
        "restrictions": typing.Type[key_restrictions.KeyRestrictions],
    }
)


class ArgumentsDict(schemas.immutabledict[str, schemas.OUTPUT_BASE_TYPES]):

    __required_keys__: typing.FrozenSet[str] = frozenset({
    })
    __optional_keys__: typing.FrozenSet[str] = frozenset({
        "mechanisms",
        "restrictions",
    })
    
    def __new__(
        cls,
        *,
        mechanisms: typing.Union[
            key_mechanisms.KeyMechanismsTupleInput,
            key_mechanisms.KeyMechanismsTuple,
            schemas.Unset
        ] = schemas.unset,
        restrictions: typing.Union[
            key_restrictions.KeyRestrictionsDictInput,
            key_restrictions.KeyRestrictionsDict,
            schemas.Unset
        ] = schemas.unset,
        configuration_: typing.Optional[schema_configuration.SchemaConfiguration] = None,
        **kwargs: schemas.INPUT_TYPES_ALL,
    ):
        arg_: typing.Dict[str, typing.Any] = {}
        for key_, val in (
            ("mechanisms", mechanisms),
            ("restrictions", restrictions),
        ):
            if isinstance(val, schemas.Unset):
                continue
            arg_[key_] = val
        arg_.update(kwargs)
        used_arg_ = typing.cast(ArgumentsDictInput, arg_)
        return Arguments.validate(used_arg_, configuration=configuration_)
    
    @staticmethod
    def from_dict_(
        arg: typing.Union[
            ArgumentsDictInput,
            ArgumentsDict
        ],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> ArgumentsDict:
        return Arguments.validate(arg, configuration=configuration)
    
    @property
    def mechanisms(self) -> typing.Union[key_mechanisms.KeyMechanismsTuple, schemas.Unset]:
        val = self.get("mechanisms", schemas.unset)
        if isinstance(val, schemas.Unset):
            return val
        return typing.cast(
            key_mechanisms.KeyMechanismsTuple,
            val
        )
    
    @property
    def restrictions(self) -> typing.Union[key_restrictions.KeyRestrictionsDict, schemas.Unset]:
        val = self.get("restrictions", schemas.unset)
        if isinstance(val, schemas.Unset):
            return val
        return typing.cast(
            key_restrictions.KeyRestrictionsDict,
            val
        )
    
    def get_additional_property_(self, name: str) -> typing.Union[schemas.OUTPUT_BASE_TYPES, schemas.Unset]:
        schemas.raise_if_key_known(name, self.__required_keys__, self.__optional_keys__)
        return self.get(name, schemas.unset)
ArgumentsDictInput = typing.Mapping[str, schemas.INPUT_TYPES_ALL]


@dataclasses.dataclass(frozen=True)
class Arguments(
    schemas.Schema[ArgumentsDict, tuple]
):
    types: typing.FrozenSet[typing.Type] = frozenset({schemas.immutabledict})
    properties: Properties = dataclasses.field(default_factory=lambda: schemas.typed_dict_to_instance(Properties)) # type: ignore
    type_to_output_cls: typing.Mapping[
        typing.Type,
        typing.Type
    ] = dataclasses.field(
        default_factory=lambda: {
            schemas.immutabledict: ArgumentsDict
        }
    )

    @classmethod
    def validate(
        cls,
        arg: typing.Union[
            ArgumentsDictInput,
            ArgumentsDict,
        ],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> ArgumentsDict:
        return super().validate_base(
            arg,
            configuration=configuration,
        )

Properties2 = typing.TypedDict(
    'Properties2',
    {
        "arguments": typing.Type[Arguments],
        "key_file": typing.Type[pem_private_key.PemPrivateKey],
    }
)


class PrivateKeyPemDict(schemas.immutabledict[str, schemas.OUTPUT_BASE_TYPES]):

    __required_keys__: typing.FrozenSet[str] = frozenset({
    })
    __optional_keys__: typing.FrozenSet[str] = frozenset({
        "arguments",
        "key_file",
    })
    
    def __new__(
        cls,
        *,
        arguments: typing.Union[
            ArgumentsDictInput,
            ArgumentsDict,
            schemas.Unset
        ] = schemas.unset,
        key_file: typing.Union[
            str,
            schemas.Unset
        ] = schemas.unset,
        configuration_: typing.Optional[schema_configuration.SchemaConfiguration] = None,
        **kwargs: schemas.INPUT_TYPES_ALL,
    ):
        arg_: typing.Dict[str, typing.Any] = {}
        for key_, val in (
            ("arguments", arguments),
            ("key_file", key_file),
        ):
            if isinstance(val, schemas.Unset):
                continue
            arg_[key_] = val
        arg_.update(kwargs)
        used_arg_ = typing.cast(PrivateKeyPemDictInput, arg_)
        return PrivateKeyPem.validate(used_arg_, configuration=configuration_)
    
    @staticmethod
    def from_dict_(
        arg: typing.Union[
            PrivateKeyPemDictInput,
            PrivateKeyPemDict
        ],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> PrivateKeyPemDict:
        return PrivateKeyPem.validate(arg, configuration=configuration)
    
    @property
    def arguments(self) -> typing.Union[ArgumentsDict, schemas.Unset]:
        val = self.get("arguments", schemas.unset)
        if isinstance(val, schemas.Unset):
            return val
        return typing.cast(
            ArgumentsDict,
            val
        )
    
    @property
    def key_file(self) -> typing.Union[str, schemas.Unset]:
        val = self.get("key_file", schemas.unset)
        if isinstance(val, schemas.Unset):
            return val
        return typing.cast(
            str,
            val
        )
    
    def get_additional_property_(self, name: str) -> typing.Union[schemas.OUTPUT_BASE_TYPES, schemas.Unset]:
        schemas.raise_if_key_known(name, self.__required_keys__, self.__optional_keys__)
        return self.get(name, schemas.unset)
PrivateKeyPemDictInput = typing.Mapping[str, schemas.INPUT_TYPES_ALL]


@dataclasses.dataclass(frozen=True)
class PrivateKeyPem(
    schemas.Schema[PrivateKeyPemDict, tuple]
):
    """NOTE: This class is auto generated by OpenAPI JSON Schema Generator.
    Ref: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator

    Do not edit the class manually.
    """
    types: typing.FrozenSet[typing.Type] = frozenset({schemas.immutabledict})
    properties: Properties2 = dataclasses.field(default_factory=lambda: schemas.typed_dict_to_instance(Properties2)) # type: ignore
    type_to_output_cls: typing.Mapping[
        typing.Type,
        typing.Type
    ] = dataclasses.field(
        default_factory=lambda: {
            schemas.immutabledict: PrivateKeyPemDict
        }
    )

    @classmethod
    def validate(
        cls,
        arg: typing.Union[
            PrivateKeyPemDictInput,
            PrivateKeyPemDict,
        ],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> PrivateKeyPemDict:
        return super().validate_base(
            arg,
            configuration=configuration,
        )

