#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdlib.h>

typedef struct ARCacheChar ARCacheChar;

typedef struct ARCacheCharRead ARCacheCharRead;

typedef struct ARCacheCharWrite ARCacheCharWrite;

uintptr_t do_nothing_rust(void);

void rust_free_string(char *s);

char *fernet_generate_new_key(void);

bool fernet_validate_key(const char *raw_key);

struct ARCacheChar *cache_char_create(uintptr_t max, uintptr_t read_max);

void cache_char_free(struct ARCacheChar *cache);

void cache_char_stats(struct ARCacheChar *cache,
                      uint64_t *reader_hits,
                      uint64_t *reader_includes,
                      uint64_t *write_hits,
                      uint64_t *write_inc_or_mod,
                      uint64_t *shared_max,
                      uint64_t *freq,
                      uint64_t *recent,
                      uint64_t *freq_evicts,
                      uint64_t *recent_evicts,
                      uint64_t *p_weight,
                      uint64_t *all_seen_keys);

struct ARCacheCharRead *cache_char_read_begin(struct ARCacheChar *cache);

void cache_char_read_complete(struct ARCacheCharRead *read_txn);

const char *cache_char_read_get(struct ARCacheCharRead *read_txn, const char *key);

void cache_char_read_include(struct ARCacheCharRead *read_txn, const char *key, const char *val);

struct ARCacheCharWrite *cache_char_write_begin(struct ARCacheChar *cache);

void cache_char_write_commit(struct ARCacheCharWrite *write_txn);

void cache_char_write_rollback(struct ARCacheCharWrite *write_txn);

void cache_char_write_include(struct ARCacheCharWrite *write_txn, const char *key, const char *val);
