/*
Copyright 2020 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	context "context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
	apisv1alpha1 "sigs.k8s.io/mcs-api/pkg/apis/v1alpha1"
	scheme "sigs.k8s.io/mcs-api/pkg/client/clientset/versioned/scheme"
)

// ServiceImportsGetter has a method to return a ServiceImportInterface.
// A group's client should implement this interface.
type ServiceImportsGetter interface {
	ServiceImports(namespace string) ServiceImportInterface
}

// ServiceImportInterface has methods to work with ServiceImport resources.
type ServiceImportInterface interface {
	Create(ctx context.Context, serviceImport *apisv1alpha1.ServiceImport, opts v1.CreateOptions) (*apisv1alpha1.ServiceImport, error)
	Update(ctx context.Context, serviceImport *apisv1alpha1.ServiceImport, opts v1.UpdateOptions) (*apisv1alpha1.ServiceImport, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, serviceImport *apisv1alpha1.ServiceImport, opts v1.UpdateOptions) (*apisv1alpha1.ServiceImport, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*apisv1alpha1.ServiceImport, error)
	List(ctx context.Context, opts v1.ListOptions) (*apisv1alpha1.ServiceImportList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *apisv1alpha1.ServiceImport, err error)
	ServiceImportExpansion
}

// serviceImports implements ServiceImportInterface
type serviceImports struct {
	*gentype.ClientWithList[*apisv1alpha1.ServiceImport, *apisv1alpha1.ServiceImportList]
}

// newServiceImports returns a ServiceImports
func newServiceImports(c *MulticlusterV1alpha1Client, namespace string) *serviceImports {
	return &serviceImports{
		gentype.NewClientWithList[*apisv1alpha1.ServiceImport, *apisv1alpha1.ServiceImportList](
			"serviceimports",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *apisv1alpha1.ServiceImport { return &apisv1alpha1.ServiceImport{} },
			func() *apisv1alpha1.ServiceImportList { return &apisv1alpha1.ServiceImportList{} },
		),
	}
}
