#ifndef _EFL_CANVAS_SURFACE_EO_H_
#define _EFL_CANVAS_SURFACE_EO_H_

#ifndef _EFL_CANVAS_SURFACE_EO_CLASS_TYPE
#define _EFL_CANVAS_SURFACE_EO_CLASS_TYPE

typedef Eo Efl_Canvas_Surface;

#endif

#ifndef _EFL_CANVAS_SURFACE_EO_TYPES
#define _EFL_CANVAS_SURFACE_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/**
 * @brief Native surfaces usually bound to an externally-managed buffer.
 *
 * The attached @ref efl_canvas_surface_native_buffer_get is entirely
 * platform-dependent, which means some of this mixin's subclasses will not
 * work (constructor returns @c null) on some platforms. This class is meant to
 * be used from native code only (C or C++), with direct access to the display
 * system or a buffer allocation system.
 *
 * @ingroup Efl_Canvas_Surface
 */
#define EFL_CANVAS_SURFACE_CLASS efl_canvas_surface_class_get()

EVAS_API EVAS_API_WEAK const Efl_Class *efl_canvas_surface_class_get(void) EINA_CONST;

/**
 * @brief External buffer attached to this native surface.
 *
 * Set to @c null to detach this surface from the external buffer.
 *
 * Set the buffer. If this fails, this function returns @c false, and the
 * surface is left without any attached buffer.
 *
 * @param[in] obj The object.
 * @param[in] buffer The external buffer, depends on its type.
 *
 * @return @c true on success, @c false otherwise
 *
 * @ingroup Efl_Canvas_Surface
 */
EVAS_API EVAS_API_WEAK Eina_Bool efl_canvas_surface_native_buffer_set(Eo *obj, void *buffer) EINA_WARN_UNUSED_RESULT;

/**
 * @brief External buffer attached to this native surface.
 *
 * Set to @c null to detach this surface from the external buffer.
 *
 * @param[in] obj The object.
 *
 * @return The external buffer, depends on its type.
 *
 * @ingroup Efl_Canvas_Surface
 */
EVAS_API EVAS_API_WEAK void *efl_canvas_surface_native_buffer_get(const Eo *obj);
#endif /* EFL_BETA_API_SUPPORT */

#endif
