/* gitg-diff.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-diff.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2012 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include "diff.h"
#include "libgitg-ext.h"
#include "libgitg.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "config.h"
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <libgit2-glib/ggit.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <libpeas/peas.h>

#define GITG_DIFF_PANEL_version VERSION
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GITG_DIFF_PANEL_0_PROPERTY,
	GITG_DIFF_PANEL_APPLICATION_PROPERTY,
	GITG_DIFF_PANEL_HISTORY_PROPERTY,
	GITG_DIFF_PANEL_ID_PROPERTY,
	GITG_DIFF_PANEL_AVAILABLE_PROPERTY,
	GITG_DIFF_PANEL_DISPLAY_NAME_PROPERTY,
	GITG_DIFF_PANEL_DESCRIPTION_PROPERTY,
	GITG_DIFF_PANEL_ICON_PROPERTY,
	GITG_DIFF_PANEL_WIDGET_PROPERTY,
	GITG_DIFF_PANEL_ENABLED_PROPERTY,
	GITG_DIFF_PANEL_NUM_PROPERTIES
};
static GParamSpec* gitg_diff_panel_properties[GITG_DIFF_PANEL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gitg_when_mapped_unref0(var) ((var == NULL) ? NULL : (var = (gitg_when_mapped_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GitgDiffPanelPrivate {
	GitgExtApplication* _application;
	GitgExtHistory* _history;
	GitgDiffView* d_diff;
	GitgWhenMapped* d_whenMapped;
	gulong d_selection_changed_id;
};

struct _Block1Data {
	int _ref_count_;
	GitgDiffPanel* self;
	gboolean hasset;
};

struct _Block2Data {
	int _ref_count_;
	Block1Data * _data1_;
	GitgCommit* c;
};

static gint GitgDiffPanel_private_offset;
static gpointer gitg_diff_panel_parent_class = NULL;
static GitgExtUIElementIface * gitg_diff_panel_gitg_ext_ui_element_parent_iface = NULL;
static GitgExtHistoryPanelIface * gitg_diff_panel_gitg_ext_history_panel_parent_iface = NULL;
static GType gitg_diff_panel_type_id = 0;

static void gitg_diff_panel_real_constructed (GObject* base);
static void gitg_diff_panel_on_selection_changed (GitgDiffPanel* self,
                                           GitgExtHistory* history);
static void _gitg_diff_panel_on_selection_changed_gitg_ext_history_selection_changed (GitgExtHistory* _sender,
                                                                               gpointer self);
static void gitg_diff_panel_real_dispose (GObject* base);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean __lambda4_ (Block1Data* _data1_,
                     GgitCommit* commit);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void ___lambda5_ (Block2Data* _data2_);
static void ____lambda5__gitg_when_mapped_on_mapped (gpointer self);
static gboolean ___lambda4__gitg_ext_foreach_commit_selection_func (GgitCommit* object,
                                                             gpointer self);
static gint gitg_diff_panel_real_negotiate_order (GitgExtUIElement* base,
                                           GitgExtUIElement* other);
static guint* _uint_dup (guint* self);
static void gitg_diff_panel_finalize (GObject * obj);
static void _vala_gitg_diff_panel_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_gitg_diff_panel_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);

static inline gpointer
gitg_diff_panel_get_instance_private (GitgDiffPanel* self)
{
	return G_STRUCT_MEMBER_P (self, GitgDiffPanel_private_offset);
}

static void
_gitg_diff_panel_on_selection_changed_gitg_ext_history_selection_changed (GitgExtHistory* _sender,
                                                                          gpointer self)
{
	gitg_diff_panel_on_selection_changed ((GitgDiffPanel*) self, _sender);
}

static void
gitg_diff_panel_real_constructed (GObject* base)
{
	GitgDiffPanel * self;
	GitgDiffView* _tmp0_;
	GitgDiffView* _tmp1_;
	GitgExtApplication* _tmp2_;
	GitgExtApplication* _tmp3_;
	GitgExtApplication* _tmp4_;
	GitgDiffView* _tmp5_;
	GitgDiffView* _tmp6_;
	GSettings* settings = NULL;
	GSettings* _tmp7_;
	GSettings* _tmp8_;
	GitgDiffView* _tmp9_;
	GSettings* _tmp10_;
	GitgDiffView* _tmp11_;
	GSettings* _tmp12_;
	GitgDiffView* _tmp13_;
	GSettings* _tmp14_;
	GitgDiffView* _tmp15_;
	GSettings* _tmp16_;
	GitgDiffView* _tmp17_;
	GSettings* _tmp18_;
	GSettings* _tmp19_;
	GitgDiffView* _tmp20_;
	GSettings* _tmp21_;
	GitgDiffView* _tmp22_;
	GitgDiffView* _tmp23_;
	GitgWhenMapped* _tmp24_;
	GitgExtHistory* _tmp25_;
	GitgExtHistory* _tmp26_;
	GitgExtHistory* _tmp27_;
	gulong _tmp28_;
	GitgExtHistory* _tmp29_;
	GitgExtHistory* _tmp30_;
	GitgExtHistory* _tmp31_;
	self = (GitgDiffPanel*) base;
	G_OBJECT_CLASS (gitg_diff_panel_parent_class)->constructed (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
	_tmp0_ = gitg_diff_view_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->d_diff);
	self->priv->d_diff = _tmp0_;
	_tmp1_ = self->priv->d_diff;
	gitg_diff_view_set_show_parents (_tmp1_, TRUE);
	_tmp2_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->d_diff;
	g_object_bind_property_with_closures ((GObject*) _tmp4_, "repository", (GObject*) _tmp5_, "repository", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_g_object_unref0 (_tmp4_);
	_tmp6_ = self->priv->d_diff;
	gtk_widget_show ((GtkWidget*) _tmp6_);
	_tmp7_ = g_settings_new (APPLICATION_ID ".preferences.diff");
	settings = _tmp7_;
	_tmp8_ = settings;
	_tmp9_ = self->priv->d_diff;
	g_settings_bind (_tmp8_, "ignore-whitespace", (GObject*) _tmp9_, "ignore-whitespace", G_SETTINGS_BIND_GET | G_SETTINGS_BIND_SET);
	_tmp10_ = settings;
	_tmp11_ = self->priv->d_diff;
	g_settings_bind (_tmp10_, "changes-inline", (GObject*) _tmp11_, "changes-inline", G_SETTINGS_BIND_GET | G_SETTINGS_BIND_SET);
	_tmp12_ = settings;
	_tmp13_ = self->priv->d_diff;
	g_settings_bind (_tmp12_, "context-lines", (GObject*) _tmp13_, "context-lines", G_SETTINGS_BIND_GET | G_SETTINGS_BIND_SET);
	_tmp14_ = settings;
	_tmp15_ = self->priv->d_diff;
	g_settings_bind (_tmp14_, "tab-width", (GObject*) _tmp15_, "tab-width", G_SETTINGS_BIND_GET | G_SETTINGS_BIND_SET);
	_tmp16_ = settings;
	_tmp17_ = self->priv->d_diff;
	g_settings_bind (_tmp16_, "wrap", (GObject*) _tmp17_, "wrap-lines", G_SETTINGS_BIND_GET | G_SETTINGS_BIND_SET);
	_tmp18_ = g_settings_new (APPLICATION_ID ".preferences.interface");
	_g_object_unref0 (settings);
	settings = _tmp18_;
	_tmp19_ = settings;
	_tmp20_ = self->priv->d_diff;
	g_settings_bind (_tmp19_, "use-gravatar", (GObject*) _tmp20_, "use-gravatar", G_SETTINGS_BIND_GET | G_SETTINGS_BIND_SET);
	_tmp21_ = settings;
	_tmp22_ = self->priv->d_diff;
	g_settings_bind (_tmp21_, "enable-diff-highlighting", (GObject*) _tmp22_, "highlight", G_SETTINGS_BIND_GET | G_SETTINGS_BIND_SET);
	_tmp23_ = self->priv->d_diff;
	_tmp24_ = gitg_when_mapped_new ((GtkWidget*) _tmp23_);
	_gitg_when_mapped_unref0 (self->priv->d_whenMapped);
	self->priv->d_whenMapped = _tmp24_;
	_tmp25_ = gitg_ext_history_panel_get_history ((GitgExtHistoryPanel*) self);
	_tmp26_ = _tmp25_;
	_tmp27_ = _tmp26_;
	_tmp28_ = g_signal_connect_object (_tmp27_, "selection-changed", (GCallback) _gitg_diff_panel_on_selection_changed_gitg_ext_history_selection_changed, self, 0);
	self->priv->d_selection_changed_id = _tmp28_;
	_g_object_unref0 (_tmp27_);
	_tmp29_ = gitg_ext_history_panel_get_history ((GitgExtHistoryPanel*) self);
	_tmp30_ = _tmp29_;
	_tmp31_ = _tmp30_;
	gitg_diff_panel_on_selection_changed (self, _tmp31_);
	_g_object_unref0 (_tmp31_);
	_g_object_unref0 (settings);
}

static void
gitg_diff_panel_real_dispose (GObject* base)
{
	GitgDiffPanel * self;
	gboolean _tmp0_ = FALSE;
	GitgExtHistory* _tmp1_;
	GitgExtHistory* _tmp2_;
	GitgExtHistory* _tmp3_;
	gboolean _tmp4_;
	self = (GitgDiffPanel*) base;
	_tmp1_ = gitg_ext_history_panel_get_history ((GitgExtHistoryPanel*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_ != NULL;
	_g_object_unref0 (_tmp3_);
	if (_tmp4_) {
		_tmp0_ = self->priv->d_selection_changed_id != ((gulong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GitgExtHistory* _tmp5_;
		GitgExtHistory* _tmp6_;
		GitgExtHistory* _tmp7_;
		_tmp5_ = gitg_ext_history_panel_get_history ((GitgExtHistoryPanel*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		g_signal_handler_disconnect ((GObject*) _tmp7_, self->priv->d_selection_changed_id);
		_g_object_unref0 (_tmp7_);
		self->priv->d_selection_changed_id = (gulong) 0;
	}
	G_OBJECT_CLASS (gitg_diff_panel_parent_class)->dispose (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		GitgDiffPanel* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		GitgDiffPanel* self;
		self = _data2_->_data1_->self;
		_g_object_unref0 (_data2_->c);
		block1_data_unref (_data2_->_data1_);
		_data2_->_data1_ = NULL;
		g_slice_free (Block2Data, _data2_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
___lambda5_ (Block2Data* _data2_)
{
	Block1Data* _data1_;
	GitgDiffPanel* self;
	GitgDiffView* _tmp0_;
	GitgCommit* _tmp1_;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	_tmp0_ = self->priv->d_diff;
	_tmp1_ = _data2_->c;
	gitg_diff_view_set_commit (_tmp0_, _tmp1_);
	_data1_->hasset = TRUE;
}

static void
____lambda5__gitg_when_mapped_on_mapped (gpointer self)
{
	___lambda5_ (self);
}

static gboolean
__lambda4_ (Block1Data* _data1_,
            GgitCommit* commit)
{
	GitgDiffPanel* self;
	Block2Data* _data2_;
	GitgCommit* _tmp0_;
	GitgCommit* _tmp1_;
	gboolean result;
	self = _data1_->self;
	g_return_val_if_fail (commit != NULL, FALSE);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->_data1_ = block1_data_ref (_data1_);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (commit, GITG_TYPE_COMMIT) ? ((GitgCommit*) commit) : NULL);
	_data2_->c = _tmp0_;
	_tmp1_ = _data2_->c;
	if (_tmp1_ != NULL) {
		GitgWhenMapped* _tmp2_;
		_tmp2_ = self->priv->d_whenMapped;
		gitg_when_mapped_update (_tmp2_, ____lambda5__gitg_when_mapped_on_mapped, block2_data_ref (_data2_), block2_data_unref, (GObject*) self);
		result = FALSE;
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return result;
	}
	result = TRUE;
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}

static gboolean
___lambda4__gitg_ext_foreach_commit_selection_func (GgitCommit* object,
                                                    gpointer self)
{
	gboolean result;
	result = __lambda4_ (self, object);
	return result;
}

static void
gitg_diff_panel_on_selection_changed (GitgDiffPanel* self,
                                      GitgExtHistory* history)
{
	Block1Data* _data1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (history != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_data1_->hasset = FALSE;
	gitg_ext_history_foreach_selected (history, ___lambda4__gitg_ext_foreach_commit_selection_func, _data1_);
	if (!_data1_->hasset) {
		GitgDiffView* _tmp0_;
		_tmp0_ = self->priv->d_diff;
		gitg_diff_view_set_commit (_tmp0_, NULL);
	}
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static gint
gitg_diff_panel_real_negotiate_order (GitgExtUIElement* base,
                                      GitgExtUIElement* other)
{
	GitgDiffPanel * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	gint result;
	self = (GitgDiffPanel*) base;
	g_return_val_if_fail (other != NULL, 0);
	_tmp0_ = gitg_ext_ui_element_get_id (other);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, "/org/gnome/gitg/Panels/Files") == 0;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		result = -1;
		return result;
	} else {
		result = 0;
		return result;
	}
}

GitgDiffPanel*
gitg_diff_panel_construct (GType object_type)
{
	GitgDiffPanel * self = NULL;
	self = (GitgDiffPanel*) g_object_new (object_type, NULL);
	return self;
}

GitgDiffPanel*
gitg_diff_panel_new (void)
{
	return gitg_diff_panel_construct (GITG_DIFF_TYPE_PANEL);
}

static GitgExtApplication*
gitg_diff_panel_real_get_application (GitgExtUIElement* base)
{
	GitgExtApplication* result;
	GitgDiffPanel* self;
	GitgExtApplication* _tmp0_;
	GitgExtApplication* _tmp1_;
	self = (GitgDiffPanel*) base;
	_tmp0_ = self->priv->_application;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
gitg_diff_panel_real_set_application (GitgExtUIElement* base,
                                      GitgExtApplication* value)
{
	GitgDiffPanel* self;
	GitgExtApplication* old_value;
	self = (GitgDiffPanel*) base;
	old_value = gitg_diff_panel_real_get_application (base);
	if (old_value != value) {
		GitgExtApplication* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_application);
		self->priv->_application = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_diff_panel_properties[GITG_DIFF_PANEL_APPLICATION_PROPERTY]);
	}
	_g_object_unref0 (old_value);
}

static GitgExtHistory*
gitg_diff_panel_real_get_history (GitgExtHistoryPanel* base)
{
	GitgExtHistory* result;
	GitgDiffPanel* self;
	GitgExtHistory* _tmp0_;
	GitgExtHistory* _tmp1_;
	self = (GitgDiffPanel*) base;
	_tmp0_ = self->priv->_history;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
gitg_diff_panel_real_set_history (GitgExtHistoryPanel* base,
                                  GitgExtHistory* value)
{
	GitgDiffPanel* self;
	GitgExtHistory* old_value;
	self = (GitgDiffPanel*) base;
	old_value = gitg_diff_panel_real_get_history (base);
	if (old_value != value) {
		GitgExtHistory* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_history);
		self->priv->_history = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_diff_panel_properties[GITG_DIFF_PANEL_HISTORY_PROPERTY]);
	}
	_g_object_unref0 (old_value);
}

guint*
gitg_diff_panel_get_shortcut (GitgDiffPanel* self)
{
	GitgDiffPanelClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = GITG_DIFF_PANEL_GET_CLASS (self);
	if (_klass_->get_shortcut) {
		return _klass_->get_shortcut (self);
	}
	return NULL;
}

static guint*
_uint_dup (guint* self)
{
	guint* dup;
	dup = g_new0 (guint, 1);
	memcpy (dup, self, sizeof (guint));
	return dup;
}

static gpointer
__uint_dup0 (gpointer self)
{
	return self ? _uint_dup (self) : NULL;
}

static guint*
gitg_diff_panel_real_get_shortcut (GitgDiffPanel* base)
{
	guint* result;
	GitgDiffPanel* self;
	guint _tmp0_;
	guint* _tmp1_;
	self = base;
	_tmp0_ = GDK_KEY_d;
	_tmp1_ = __uint_dup0 (&_tmp0_);
	result = _tmp1_;
	return result;
}

static gchar*
gitg_diff_panel_real_get_id (GitgExtUIElement* base)
{
	gchar* result;
	GitgDiffPanel* self;
	gchar* _tmp0_;
	self = (GitgDiffPanel*) base;
	_tmp0_ = g_strdup ("/org/gnome/gitg/Panels/Diff");
	result = _tmp0_;
	return result;
}

static gboolean
gitg_diff_panel_real_get_available (GitgExtUIElement* base)
{
	gboolean result;
	GitgDiffPanel* self;
	self = (GitgDiffPanel*) base;
	result = TRUE;
	return result;
}

static gchar*
gitg_diff_panel_real_get_display_name (GitgExtUIElement* base)
{
	gchar* result;
	GitgDiffPanel* self;
	gchar* _tmp0_;
	self = (GitgDiffPanel*) base;
	_tmp0_ = g_strdup (_ ("Diff"));
	result = _tmp0_;
	return result;
}

static gchar*
gitg_diff_panel_real_get_description (GitgExtUIElement* base)
{
	gchar* result;
	GitgDiffPanel* self;
	gchar* _tmp0_;
	self = (GitgDiffPanel*) base;
	_tmp0_ = g_strdup (_ ("Show the changes introduced by the selected commit"));
	result = _tmp0_;
	return result;
}

static gchar*
gitg_diff_panel_real_get_icon (GitgExtUIElement* base)
{
	gchar* result;
	GitgDiffPanel* self;
	gchar* _tmp0_;
	self = (GitgDiffPanel*) base;
	_tmp0_ = g_strdup ("diff-symbolic");
	result = _tmp0_;
	return result;
}

static GtkWidget*
gitg_diff_panel_real_get_widget (GitgExtUIElement* base)
{
	GtkWidget* result;
	GitgDiffPanel* self;
	GitgDiffView* _tmp0_;
	GtkWidget* _tmp1_;
	self = (GitgDiffPanel*) base;
	_tmp0_ = self->priv->d_diff;
	_tmp1_ = _g_object_ref0 ((GtkWidget*) _tmp0_);
	result = _tmp1_;
	return result;
}

static gboolean
gitg_diff_panel_real_get_enabled (GitgExtUIElement* base)
{
	gboolean result;
	GitgDiffPanel* self;
	self = (GitgDiffPanel*) base;
	result = TRUE;
	return result;
}

static void
gitg_diff_panel_class_init (GitgDiffPanelClass * klass,
                            gpointer klass_data)
{
	gitg_diff_panel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgDiffPanel_private_offset);
	((GObjectClass *) klass)->constructed = (void (*) (GObject*)) gitg_diff_panel_real_constructed;
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) gitg_diff_panel_real_dispose;
	GITG_DIFF_PANEL_CLASS (klass)->get_shortcut = (guint* (*) (GitgDiffPanel*)) gitg_diff_panel_real_get_shortcut;
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_diff_panel_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_diff_panel_set_property;
	G_OBJECT_CLASS (klass)->finalize = gitg_diff_panel_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_PANEL_APPLICATION_PROPERTY, gitg_diff_panel_properties[GITG_DIFF_PANEL_APPLICATION_PROPERTY] = g_param_spec_object ("application", "application", "application", GITG_EXT_TYPE_APPLICATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_PANEL_HISTORY_PROPERTY, gitg_diff_panel_properties[GITG_DIFF_PANEL_HISTORY_PROPERTY] = g_param_spec_object ("history", "history", "history", GITG_EXT_TYPE_HISTORY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_PANEL_ID_PROPERTY, gitg_diff_panel_properties[GITG_DIFF_PANEL_ID_PROPERTY] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_PANEL_AVAILABLE_PROPERTY, gitg_diff_panel_properties[GITG_DIFF_PANEL_AVAILABLE_PROPERTY] = g_param_spec_boolean ("available", "available", "available", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_PANEL_DISPLAY_NAME_PROPERTY, gitg_diff_panel_properties[GITG_DIFF_PANEL_DISPLAY_NAME_PROPERTY] = g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_PANEL_DESCRIPTION_PROPERTY, gitg_diff_panel_properties[GITG_DIFF_PANEL_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_PANEL_ICON_PROPERTY, gitg_diff_panel_properties[GITG_DIFF_PANEL_ICON_PROPERTY] = g_param_spec_string ("icon", "icon", "icon", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_PANEL_WIDGET_PROPERTY, gitg_diff_panel_properties[GITG_DIFF_PANEL_WIDGET_PROPERTY] = g_param_spec_object ("widget", "widget", "widget", gtk_widget_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_PANEL_ENABLED_PROPERTY, gitg_diff_panel_properties[GITG_DIFF_PANEL_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
gitg_diff_panel_gitg_ext_ui_element_interface_init (GitgExtUIElementIface * iface,
                                                    gpointer iface_data)
{
	gitg_diff_panel_gitg_ext_ui_element_parent_iface = g_type_interface_peek_parent (iface);
	iface->negotiate_order = (gint (*) (GitgExtUIElement*, GitgExtUIElement*)) gitg_diff_panel_real_negotiate_order;
	iface->get_application = gitg_diff_panel_real_get_application;
	iface->set_application = gitg_diff_panel_real_set_application;
	iface->get_shortcut = (guint* (*) (GitgExtUIElement*)) gitg_diff_panel_get_shortcut;
	iface->get_id = gitg_diff_panel_real_get_id;
	iface->get_available = gitg_diff_panel_real_get_available;
	iface->get_display_name = gitg_diff_panel_real_get_display_name;
	iface->get_description = gitg_diff_panel_real_get_description;
	iface->get_icon = gitg_diff_panel_real_get_icon;
	iface->get_widget = gitg_diff_panel_real_get_widget;
	iface->get_enabled = gitg_diff_panel_real_get_enabled;
}

static void
gitg_diff_panel_gitg_ext_history_panel_interface_init (GitgExtHistoryPanelIface * iface,
                                                       gpointer iface_data)
{
	gitg_diff_panel_gitg_ext_history_panel_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_history = gitg_diff_panel_real_get_history;
	iface->set_history = gitg_diff_panel_real_set_history;
}

static void
gitg_diff_panel_instance_init (GitgDiffPanel * self,
                               gpointer klass)
{
	self->priv = gitg_diff_panel_get_instance_private (self);
}

static void
gitg_diff_panel_finalize (GObject * obj)
{
	GitgDiffPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_DIFF_TYPE_PANEL, GitgDiffPanel);
	_g_object_unref0 (self->priv->_application);
	_g_object_unref0 (self->priv->_history);
	_g_object_unref0 (self->priv->d_diff);
	_gitg_when_mapped_unref0 (self->priv->d_whenMapped);
	G_OBJECT_CLASS (gitg_diff_panel_parent_class)->finalize (obj);
}

GType
gitg_diff_panel_get_type (void)
{
	return gitg_diff_panel_type_id;
}

GType
gitg_diff_panel_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgDiffPanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_diff_panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgDiffPanel), 0, (GInstanceInitFunc) gitg_diff_panel_instance_init, NULL };
	static const GInterfaceInfo gitg_ext_ui_element_info = { (GInterfaceInitFunc) gitg_diff_panel_gitg_ext_ui_element_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gitg_ext_history_panel_info = { (GInterfaceInitFunc) gitg_diff_panel_gitg_ext_history_panel_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	gitg_diff_panel_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GitgDiffPanel", &g_define_type_info, 0);
	g_type_module_add_interface (module, gitg_diff_panel_type_id, GITG_EXT_TYPE_UI_ELEMENT, &gitg_ext_ui_element_info);
	g_type_module_add_interface (module, gitg_diff_panel_type_id, GITG_EXT_TYPE_HISTORY_PANEL, &gitg_ext_history_panel_info);
	GitgDiffPanel_private_offset = sizeof (GitgDiffPanelPrivate);
	return gitg_diff_panel_type_id;
}

static void
_vala_gitg_diff_panel_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	GitgDiffPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_DIFF_TYPE_PANEL, GitgDiffPanel);
	switch (property_id) {
		case GITG_DIFF_PANEL_APPLICATION_PROPERTY:
		g_value_take_object (value, gitg_ext_ui_element_get_application ((GitgExtUIElement*) self));
		break;
		case GITG_DIFF_PANEL_HISTORY_PROPERTY:
		g_value_take_object (value, gitg_ext_history_panel_get_history ((GitgExtHistoryPanel*) self));
		break;
		case GITG_DIFF_PANEL_ID_PROPERTY:
		g_value_take_string (value, gitg_ext_ui_element_get_id ((GitgExtUIElement*) self));
		break;
		case GITG_DIFF_PANEL_AVAILABLE_PROPERTY:
		g_value_set_boolean (value, gitg_ext_ui_element_get_available ((GitgExtUIElement*) self));
		break;
		case GITG_DIFF_PANEL_DISPLAY_NAME_PROPERTY:
		g_value_take_string (value, gitg_ext_ui_element_get_display_name ((GitgExtUIElement*) self));
		break;
		case GITG_DIFF_PANEL_DESCRIPTION_PROPERTY:
		g_value_take_string (value, gitg_ext_ui_element_get_description ((GitgExtUIElement*) self));
		break;
		case GITG_DIFF_PANEL_ICON_PROPERTY:
		g_value_take_string (value, gitg_ext_ui_element_get_icon ((GitgExtUIElement*) self));
		break;
		case GITG_DIFF_PANEL_WIDGET_PROPERTY:
		g_value_take_object (value, gitg_ext_ui_element_get_widget ((GitgExtUIElement*) self));
		break;
		case GITG_DIFF_PANEL_ENABLED_PROPERTY:
		g_value_set_boolean (value, gitg_ext_ui_element_get_enabled ((GitgExtUIElement*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gitg_diff_panel_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	GitgDiffPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_DIFF_TYPE_PANEL, GitgDiffPanel);
	switch (property_id) {
		case GITG_DIFF_PANEL_APPLICATION_PROPERTY:
		gitg_ext_ui_element_set_application ((GitgExtUIElement*) self, g_value_get_object (value));
		break;
		case GITG_DIFF_PANEL_HISTORY_PROPERTY:
		gitg_ext_history_panel_set_history ((GitgExtHistoryPanel*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* mod = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	gitg_diff_panel_register_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	mod = _tmp0_;
	peas_object_module_register_extension_type (mod, GITG_EXT_TYPE_HISTORY_PANEL, GITG_DIFF_TYPE_PANEL);
	_g_object_unref0 (mod);
}

