{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A GMatchInfo is an opaque struct used to return information about
-- matches.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GLib.Structs.MatchInfo
    ( 

-- * Exported types
    MatchInfo(..)                           ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [expandReferences]("GI.GLib.Structs.MatchInfo#g:method:expandReferences"), [fetch]("GI.GLib.Structs.MatchInfo#g:method:fetch"), [fetchAll]("GI.GLib.Structs.MatchInfo#g:method:fetchAll"), [fetchNamed]("GI.GLib.Structs.MatchInfo#g:method:fetchNamed"), [fetchNamedPos]("GI.GLib.Structs.MatchInfo#g:method:fetchNamedPos"), [fetchPos]("GI.GLib.Structs.MatchInfo#g:method:fetchPos"), [free]("GI.GLib.Structs.MatchInfo#g:method:free"), [isPartialMatch]("GI.GLib.Structs.MatchInfo#g:method:isPartialMatch"), [matches]("GI.GLib.Structs.MatchInfo#g:method:matches"), [next]("GI.GLib.Structs.MatchInfo#g:method:next"), [ref]("GI.GLib.Structs.MatchInfo#g:method:ref"), [unref]("GI.GLib.Structs.MatchInfo#g:method:unref").
-- 
-- ==== Getters
-- [getMatchCount]("GI.GLib.Structs.MatchInfo#g:method:getMatchCount"), [getRegex]("GI.GLib.Structs.MatchInfo#g:method:getRegex"), [getString]("GI.GLib.Structs.MatchInfo#g:method:getString").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveMatchInfoMethod                  ,
#endif

-- ** expandReferences #method:expandReferences#

#if defined(ENABLE_OVERLOADING)
    MatchInfoExpandReferencesMethodInfo     ,
#endif
    matchInfoExpandReferences               ,


-- ** fetch #method:fetch#

#if defined(ENABLE_OVERLOADING)
    MatchInfoFetchMethodInfo                ,
#endif
    matchInfoFetch                          ,


-- ** fetchAll #method:fetchAll#

#if defined(ENABLE_OVERLOADING)
    MatchInfoFetchAllMethodInfo             ,
#endif
    matchInfoFetchAll                       ,


-- ** fetchNamed #method:fetchNamed#

#if defined(ENABLE_OVERLOADING)
    MatchInfoFetchNamedMethodInfo           ,
#endif
    matchInfoFetchNamed                     ,


-- ** fetchNamedPos #method:fetchNamedPos#

#if defined(ENABLE_OVERLOADING)
    MatchInfoFetchNamedPosMethodInfo        ,
#endif
    matchInfoFetchNamedPos                  ,


-- ** fetchPos #method:fetchPos#

#if defined(ENABLE_OVERLOADING)
    MatchInfoFetchPosMethodInfo             ,
#endif
    matchInfoFetchPos                       ,


-- ** free #method:free#

#if defined(ENABLE_OVERLOADING)
    MatchInfoFreeMethodInfo                 ,
#endif
    matchInfoFree                           ,


-- ** getMatchCount #method:getMatchCount#

#if defined(ENABLE_OVERLOADING)
    MatchInfoGetMatchCountMethodInfo        ,
#endif
    matchInfoGetMatchCount                  ,


-- ** getRegex #method:getRegex#

#if defined(ENABLE_OVERLOADING)
    MatchInfoGetRegexMethodInfo             ,
#endif
    matchInfoGetRegex                       ,


-- ** getString #method:getString#

#if defined(ENABLE_OVERLOADING)
    MatchInfoGetStringMethodInfo            ,
#endif
    matchInfoGetString                      ,


-- ** isPartialMatch #method:isPartialMatch#

#if defined(ENABLE_OVERLOADING)
    MatchInfoIsPartialMatchMethodInfo       ,
#endif
    matchInfoIsPartialMatch                 ,


-- ** matches #method:matches#

#if defined(ENABLE_OVERLOADING)
    MatchInfoMatchesMethodInfo              ,
#endif
    matchInfoMatches                        ,


-- ** next #method:next#

#if defined(ENABLE_OVERLOADING)
    MatchInfoNextMethodInfo                 ,
#endif
    matchInfoNext                           ,


-- ** ref #method:ref#

#if defined(ENABLE_OVERLOADING)
    MatchInfoRefMethodInfo                  ,
#endif
    matchInfoRef                            ,


-- ** unref #method:unref#

#if defined(ENABLE_OVERLOADING)
    MatchInfoUnrefMethodInfo                ,
#endif
    matchInfoUnref                          ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import {-# SOURCE #-} qualified GI.GLib.Flags as GLib.Flags
import {-# SOURCE #-} qualified GI.GLib.Structs.Regex as GLib.Regex

#else
import {-# SOURCE #-} qualified GI.GLib.Structs.Regex as GLib.Regex

#endif

-- | Memory-managed wrapper type.
newtype MatchInfo = MatchInfo (SP.ManagedPtr MatchInfo)
    deriving (Eq)

instance SP.ManagedPtrNewtype MatchInfo where
    toManagedPtr (MatchInfo p) = p

foreign import ccall "g_match_info_get_type" c_g_match_info_get_type :: 
    IO GType

type instance O.ParentTypes MatchInfo = '[]
instance O.HasParentTypes MatchInfo

instance B.Types.TypedObject MatchInfo where
    glibType = c_g_match_info_get_type

instance B.Types.GBoxed MatchInfo

-- | Convert t'MatchInfo' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe MatchInfo) where
    gvalueGType_ = c_g_match_info_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr MatchInfo)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr MatchInfo)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed MatchInfo ptr
        else return P.Nothing
        
    


#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList MatchInfo
type instance O.AttributeList MatchInfo = MatchInfoAttributeList
type MatchInfoAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method MatchInfo::expand_references
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "match_info"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MatchInfo" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMatchInfo or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "string_to_expand"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the string to expand"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : True
-- Skip return : False

foreign import ccall "g_match_info_expand_references" g_match_info_expand_references :: 
    Ptr MatchInfo ->                        -- match_info : TInterface (Name {namespace = "GLib", name = "MatchInfo"})
    CString ->                              -- string_to_expand : TBasicType TUTF8
    Ptr (Ptr GError) ->                     -- error
    IO CString

-- | Returns a new string containing the text in /@stringToExpand@/ with
-- references and escape sequences expanded. References refer to the last
-- match done with /@string@/ against /@regex@/ and have the same syntax used by
-- 'GI.GLib.Structs.Regex.regexReplace'.
-- 
-- The /@stringToExpand@/ must be UTF-8 encoded even if 'GI.GLib.Flags.RegexCompileFlagsRaw' was
-- passed to 'GI.GLib.Structs.Regex.regexNew'.
-- 
-- The backreferences are extracted from the string passed to the match
-- function, so you cannot call this function after freeing the string.
-- 
-- /@matchInfo@/ may be 'P.Nothing' in which case /@stringToExpand@/ must not
-- contain references. For instance \"foo\\n\" does not refer to an actual
-- pattern and \'\\n\' merely will be replaced with \\n character,
-- while to expand \"\\0\" (whole match) one needs the result of a match.
-- Use 'GI.GLib.Functions.regexCheckReplacement' to find out whether /@stringToExpand@/
-- contains references.
-- 
-- /Since: 2.14/
matchInfoExpandReferences ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (MatchInfo)
    -- ^ /@matchInfo@/: a t'GI.GLib.Structs.MatchInfo.MatchInfo' or 'P.Nothing'
    -> T.Text
    -- ^ /@stringToExpand@/: the string to expand
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the expanded string, or 'P.Nothing' if an error occurred /(Can throw 'Data.GI.Base.GError.GError')/
matchInfoExpandReferences matchInfo stringToExpand = liftIO $ do
    maybeMatchInfo <- case matchInfo of
        Nothing -> return FP.nullPtr
        Just jMatchInfo -> do
            jMatchInfo' <- unsafeManagedPtrGetPtr jMatchInfo
            return jMatchInfo'
    stringToExpand' <- textToCString stringToExpand
    onException (do
        result <- propagateGError $ g_match_info_expand_references maybeMatchInfo stringToExpand'
        maybeResult <- convertIfNonNull result $ \result' -> do
            result'' <- cstringToText result'
            freeMem result'
            return result''
        whenJust matchInfo touchManagedPtr
        freeMem stringToExpand'
        return maybeResult
     ) (do
        freeMem stringToExpand'
     )

#if defined(ENABLE_OVERLOADING)
data MatchInfoExpandReferencesMethodInfo
instance (signature ~ (T.Text -> m (Maybe T.Text)), MonadIO m) => O.OverloadedMethod MatchInfoExpandReferencesMethodInfo MatchInfo signature where
    overloadedMethod i = matchInfoExpandReferences (Just i)

instance O.OverloadedMethodInfo MatchInfoExpandReferencesMethodInfo MatchInfo where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MatchInfo.matchInfoExpandReferences",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-MatchInfo.html#v:matchInfoExpandReferences"
        })


#endif

-- method MatchInfo::fetch
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "match_info"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MatchInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#GMatchInfo structure"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "match_num"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "number of the sub expression"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_match_info_fetch" g_match_info_fetch :: 
    Ptr MatchInfo ->                        -- match_info : TInterface (Name {namespace = "GLib", name = "MatchInfo"})
    Int32 ->                                -- match_num : TBasicType TInt
    IO CString

-- | Retrieves the text matching the /@matchNum@/\'th capturing
-- parentheses. 0 is the full text of the match, 1 is the first paren
-- set, 2 the second, and so on.
-- 
-- If /@matchNum@/ is a valid sub pattern but it didn\'t match anything
-- (e.g. sub pattern 1, matching \"b\" against \"(a)?b\") then an empty
-- string is returned.
-- 
-- If the match was obtained using the DFA algorithm, that is using
-- 'GI.GLib.Structs.Regex.regexMatchAll' or 'GI.GLib.Structs.Regex.regexMatchAllFull', the retrieved
-- string is not that of a set of parentheses but that of a matched
-- substring. Substrings are matched in reverse order of length, so
-- 0 is the longest match.
-- 
-- The string is fetched from the string passed to the match function,
-- so you cannot call this function after freeing the string.
-- 
-- /Since: 2.14/
matchInfoFetch ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    MatchInfo
    -- ^ /@matchInfo@/: t'GI.GLib.Structs.MatchInfo.MatchInfo' structure
    -> Int32
    -- ^ /@matchNum@/: number of the sub expression
    -> m (Maybe T.Text)
    -- ^ __Returns:__ The matched substring, or 'P.Nothing' if an error
    --     occurred. You have to free the string yourself
matchInfoFetch matchInfo matchNum = liftIO $ do
    matchInfo' <- unsafeManagedPtrGetPtr matchInfo
    result <- g_match_info_fetch matchInfo' matchNum
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        freeMem result'
        return result''
    touchManagedPtr matchInfo
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data MatchInfoFetchMethodInfo
instance (signature ~ (Int32 -> m (Maybe T.Text)), MonadIO m) => O.OverloadedMethod MatchInfoFetchMethodInfo MatchInfo signature where
    overloadedMethod = matchInfoFetch

instance O.OverloadedMethodInfo MatchInfoFetchMethodInfo MatchInfo where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MatchInfo.matchInfoFetch",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-MatchInfo.html#v:matchInfoFetch"
        })


#endif

-- method MatchInfo::fetch_all
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "match_info"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MatchInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMatchInfo structure"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TCArray True (-1) (-1) (TBasicType TUTF8))
-- throws : False
-- Skip return : False

foreign import ccall "g_match_info_fetch_all" g_match_info_fetch_all :: 
    Ptr MatchInfo ->                        -- match_info : TInterface (Name {namespace = "GLib", name = "MatchInfo"})
    IO (Ptr CString)

-- | Bundles up pointers to each of the matching substrings from a match
-- and stores them in an array of gchar pointers. The first element in
-- the returned array is the match number 0, i.e. the entire matched
-- text.
-- 
-- If a sub pattern didn\'t match anything (e.g. sub pattern 1, matching
-- \"b\" against \"(a)?b\") then an empty string is inserted.
-- 
-- If the last match was obtained using the DFA algorithm, that is using
-- 'GI.GLib.Structs.Regex.regexMatchAll' or 'GI.GLib.Structs.Regex.regexMatchAllFull', the retrieved
-- strings are not that matched by sets of parentheses but that of the
-- matched substring. Substrings are matched in reverse order of length,
-- so the first one is the longest match.
-- 
-- The strings are fetched from the string passed to the match function,
-- so you cannot call this function after freeing the string.
-- 
-- /Since: 2.14/
matchInfoFetchAll ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    MatchInfo
    -- ^ /@matchInfo@/: a t'GI.GLib.Structs.MatchInfo.MatchInfo' structure
    -> m [T.Text]
    -- ^ __Returns:__ a 'P.Nothing'-terminated array of gchar *
    --     pointers.  It must be freed using 'GI.GLib.Functions.strfreev'. If the previous
    --     match failed 'P.Nothing' is returned
matchInfoFetchAll matchInfo = liftIO $ do
    matchInfo' <- unsafeManagedPtrGetPtr matchInfo
    result <- g_match_info_fetch_all matchInfo'
    checkUnexpectedReturnNULL "matchInfoFetchAll" result
    result' <- unpackZeroTerminatedUTF8CArray result
    mapZeroTerminatedCArray freeMem result
    freeMem result
    touchManagedPtr matchInfo
    return result'

#if defined(ENABLE_OVERLOADING)
data MatchInfoFetchAllMethodInfo
instance (signature ~ (m [T.Text]), MonadIO m) => O.OverloadedMethod MatchInfoFetchAllMethodInfo MatchInfo signature where
    overloadedMethod = matchInfoFetchAll

instance O.OverloadedMethodInfo MatchInfoFetchAllMethodInfo MatchInfo where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MatchInfo.matchInfoFetchAll",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-MatchInfo.html#v:matchInfoFetchAll"
        })


#endif

-- method MatchInfo::fetch_named
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "match_info"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MatchInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#GMatchInfo structure"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "name of the subexpression"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_match_info_fetch_named" g_match_info_fetch_named :: 
    Ptr MatchInfo ->                        -- match_info : TInterface (Name {namespace = "GLib", name = "MatchInfo"})
    CString ->                              -- name : TBasicType TUTF8
    IO CString

-- | Retrieves the text matching the capturing parentheses named /@name@/.
-- 
-- If /@name@/ is a valid sub pattern name but it didn\'t match anything
-- (e.g. sub pattern @\"X\"@, matching @\"b\"@ against @\"(?P\<X>a)?b\"@)
-- then an empty string is returned.
-- 
-- The string is fetched from the string passed to the match function,
-- so you cannot call this function after freeing the string.
-- 
-- /Since: 2.14/
matchInfoFetchNamed ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    MatchInfo
    -- ^ /@matchInfo@/: t'GI.GLib.Structs.MatchInfo.MatchInfo' structure
    -> T.Text
    -- ^ /@name@/: name of the subexpression
    -> m (Maybe T.Text)
    -- ^ __Returns:__ The matched substring, or 'P.Nothing' if an error
    --     occurred. You have to free the string yourself
matchInfoFetchNamed matchInfo name = liftIO $ do
    matchInfo' <- unsafeManagedPtrGetPtr matchInfo
    name' <- textToCString name
    result <- g_match_info_fetch_named matchInfo' name'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        freeMem result'
        return result''
    touchManagedPtr matchInfo
    freeMem name'
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data MatchInfoFetchNamedMethodInfo
instance (signature ~ (T.Text -> m (Maybe T.Text)), MonadIO m) => O.OverloadedMethod MatchInfoFetchNamedMethodInfo MatchInfo signature where
    overloadedMethod = matchInfoFetchNamed

instance O.OverloadedMethodInfo MatchInfoFetchNamedMethodInfo MatchInfo where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MatchInfo.matchInfoFetchNamed",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-MatchInfo.html#v:matchInfoFetchNamed"
        })


#endif

-- method MatchInfo::fetch_named_pos
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "match_info"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MatchInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#GMatchInfo structure"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "name of the subexpression"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "start_pos"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "pointer to location where to store\n    the start position, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "end_pos"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "pointer to location where to store\n    the end position (the byte after the final byte of the match), or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_match_info_fetch_named_pos" g_match_info_fetch_named_pos :: 
    Ptr MatchInfo ->                        -- match_info : TInterface (Name {namespace = "GLib", name = "MatchInfo"})
    CString ->                              -- name : TBasicType TUTF8
    Ptr Int32 ->                            -- start_pos : TBasicType TInt
    Ptr Int32 ->                            -- end_pos : TBasicType TInt
    IO CInt

-- | Retrieves the position in bytes of the capturing parentheses named /@name@/.
-- 
-- If /@name@/ is a valid sub pattern name but it didn\'t match anything
-- (e.g. sub pattern @\"X\"@, matching @\"b\"@ against @\"(?P\<X>a)?b\"@)
-- then /@startPos@/ and /@endPos@/ are set to -1 and 'P.True' is returned.
-- 
-- As /@endPos@/ is set to the byte after the final byte of the match (on success),
-- the length of the match can be calculated as @end_pos - start_pos@.
-- 
-- /Since: 2.14/
matchInfoFetchNamedPos ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    MatchInfo
    -- ^ /@matchInfo@/: t'GI.GLib.Structs.MatchInfo.MatchInfo' structure
    -> T.Text
    -- ^ /@name@/: name of the subexpression
    -> m ((Bool, Int32, Int32))
    -- ^ __Returns:__ 'P.True' if the position was fetched, 'P.False' otherwise.
    --     If the position cannot be fetched, /@startPos@/ and /@endPos@/
    --     are left unchanged.
matchInfoFetchNamedPos matchInfo name = liftIO $ do
    matchInfo' <- unsafeManagedPtrGetPtr matchInfo
    name' <- textToCString name
    startPos <- allocMem :: IO (Ptr Int32)
    endPos <- allocMem :: IO (Ptr Int32)
    result <- g_match_info_fetch_named_pos matchInfo' name' startPos endPos
    let result' = (/= 0) result
    startPos' <- peek startPos
    endPos' <- peek endPos
    touchManagedPtr matchInfo
    freeMem name'
    freeMem startPos
    freeMem endPos
    return (result', startPos', endPos')

#if defined(ENABLE_OVERLOADING)
data MatchInfoFetchNamedPosMethodInfo
instance (signature ~ (T.Text -> m ((Bool, Int32, Int32))), MonadIO m) => O.OverloadedMethod MatchInfoFetchNamedPosMethodInfo MatchInfo signature where
    overloadedMethod = matchInfoFetchNamedPos

instance O.OverloadedMethodInfo MatchInfoFetchNamedPosMethodInfo MatchInfo where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MatchInfo.matchInfoFetchNamedPos",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-MatchInfo.html#v:matchInfoFetchNamedPos"
        })


#endif

-- method MatchInfo::fetch_pos
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "match_info"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MatchInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#GMatchInfo structure"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "match_num"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "number of the capture parenthesis"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "start_pos"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "pointer to location where to store\n    the start position, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "end_pos"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "pointer to location where to store\n    the end position (the byte after the final byte of the match), or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_match_info_fetch_pos" g_match_info_fetch_pos :: 
    Ptr MatchInfo ->                        -- match_info : TInterface (Name {namespace = "GLib", name = "MatchInfo"})
    Int32 ->                                -- match_num : TBasicType TInt
    Ptr Int32 ->                            -- start_pos : TBasicType TInt
    Ptr Int32 ->                            -- end_pos : TBasicType TInt
    IO CInt

-- | Returns the start and end positions (in bytes) of a successfully matching
-- capture parenthesis.
-- 
-- Valid values for /@matchNum@/ are @0@ for the full text of the match,
-- @1@ for the first paren set, @2@ for the second, and so on.
-- 
-- As /@endPos@/ is set to the byte after the final byte of the match (on success),
-- the length of the match can be calculated as @end_pos - start_pos@.
-- 
-- As a best practice, initialize /@startPos@/ and /@endPos@/ to identifiable
-- values, such as @G_MAXINT@, so that you can test if
-- @g_match_info_fetch_pos()@ actually changed the value for a given
-- capture parenthesis.
-- 
-- The parameter /@matchNum@/ corresponds to a matched capture parenthesis. The
-- actual value you use for /@matchNum@/ depends on the method used to generate
-- /@matchInfo@/. The following sections describe those methods.
-- 
-- == Methods Using Non-deterministic Finite Automata Matching
-- 
-- The methods 'GI.GLib.Structs.Regex.regexMatch' and 'GI.GLib.Structs.Regex.regexMatchFull'
-- return a t'GI.GLib.Structs.MatchInfo.MatchInfo' using traditional (greedy) pattern
-- matching, also known as
-- <https://en.wikipedia.org/wiki/Nondeterministic_finite_automaton Non-deterministic Finite Automaton>
-- (NFA) matching. You pass the returned @GMatchInfo@ from these methods to
-- @g_match_info_fetch_pos()@ to determine the start and end positions
-- of capture parentheses. The values for /@matchNum@/ correspond to the capture
-- parentheses in order, with @0@ corresponding to the entire matched string.
-- 
-- /@matchNum@/ can refer to a capture parenthesis with no match. For example,
-- the string @b@ matches against the pattern @(a)?b@, but the capture
-- parenthesis @(a)@ has no match. In this case, @g_match_info_fetch_pos()@
-- returns true and sets /@startPos@/ and /@endPos@/ to @-1@ when called with
-- @match_num@ as @1@ (for @(a)@).
-- 
-- For an expanded example, a regex pattern is @(a)?(.*?)the (.*)@,
-- and a candidate string is @glib regexes are the best@. In this scenario
-- there are four capture parentheses numbered 0–3: an implicit one
-- for the entire string, and three explicitly declared in the regex pattern.
-- 
-- Given this example, the following table describes the return values
-- from @g_match_info_fetch_pos()@ for various values of /@matchNum@/.
-- 
-- @match_num@ | Contents | Return value | Returned @start_pos@ | Returned @end_pos@
-- ----------- | -------- | ------------ | -------------------- | ------------------
-- 0 | Matches entire string | True | 0 | 25
-- 1 | Does not match first character | True | -1 | -1
-- 2 | All text before @the @ | True | 0 | 17
-- 3 | All text after @the @ | True | 21 | 25
-- 4 | Capture paren out of range | False | Unchanged | Unchanged
-- 
-- The following code sample and output implements this example.
-- 
-- 
-- === /{ .c } code/
-- >#include <glib.h>
-- >
-- >int
-- >main (int argc, char *argv[])
-- >{
-- >  g_autoptr(GError) local_error = NULL;
-- >  const char *regex_pattern = "(a)?(.*?)the (.*)";
-- >  const char *test_string = "glib regexes are the best";
-- >  g_autoptr(GRegex) regex = NULL;
-- >
-- >  regex = g_regex_new (regex_pattern,
-- >                       G_REGEX_DEFAULT,
-- >                       G_REGEX_MATCH_DEFAULT,
-- >                       &local_error);
-- >  if (regex == NULL)
-- >    {
-- >      g_printerr ("Error creating regex: %s\n", local_error->message);
-- >      return 1;
-- >    }
-- >
-- >  g_autoptr(GMatchInfo) match_info = NULL;
-- >  g_regex_match (regex, test_string, G_REGEX_MATCH_DEFAULT, &match_info);
-- >
-- >  int n_matched_strings = g_match_info_get_match_count (match_info);
-- >
-- >  // Print header line
-- >  g_print ("match_num Contents                  Return value returned start_pos returned end_pos\n");
-- >
-- >  // Iterate over each capture paren, including one that is out of range as a demonstration.
-- >  for (int match_num = 0; match_num <= n_matched_strings; match_num++)
-- >    {
-- >      gboolean found_match;
-- >      g_autofree char *paren_string = NULL;
-- >      int start_pos = G_MAXINT;
-- >      int end_pos = G_MAXINT;
-- >
-- >      found_match = g_match_info_fetch_pos (match_info,
-- >                                            match_num,
-- >                                            &start_pos,
-- >                                            &end_pos);
-- >
-- >      // If no match, display N/A as the found string.
-- >      if (start_pos == G_MAXINT || start_pos == -1)
-- >        paren_string = g_strdup ("N/A");
-- >      else
-- >        paren_string = g_strndup (test_string + start_pos, end_pos - start_pos);
-- >
-- >      g_print ("%-9d %-25s %-12d %-18d %d\n", match_num, paren_string, found_match, start_pos, end_pos);
-- >    }
-- >
-- >  return 0;
-- >}
-- 
-- 
-- 
-- 	
-- >match_num Contents                  Return value returned start_pos returned end_pos
-- >0         glib regexes are the best 1            0                  25
-- >1         N/A                       1            -1                 -1
-- >2         glib regexes are          1            0                  17
-- >3         best                      1            21                 25
-- >4         N/A                       0            2147483647         2147483647
-- 
-- == Methods Using Deterministic Finite Automata Matching
-- 
-- The methods 'GI.GLib.Structs.Regex.regexMatchAll' and
-- 'GI.GLib.Structs.Regex.regexMatchAllFull'
-- return a @GMatchInfo@ using
-- <https://en.wikipedia.org/wiki/Deterministic_finite_automaton Deterministic Finite Automaton>
-- (DFA) pattern matching. This algorithm detects overlapping matches. You pass
-- the returned @GMatchInfo@ from these methods to @g_match_info_fetch_pos()@
-- to determine the start and end positions of each overlapping match. Use the
-- method 'GI.GLib.Structs.MatchInfo.matchInfoGetMatchCount' to determine the number
-- of overlapping matches.
-- 
-- For example, a regex pattern is @\<.*>@, and a candidate string is
-- @\<a> \<b> \<c>@. In this scenario there are three implicit capture
-- parentheses: one for the entire string, one for @\<a> \<b>@, and one for @\<a>@.
-- 
-- Given this example, the following table describes the return values from
-- @g_match_info_fetch_pos()@ for various values of /@matchNum@/.
-- 
-- @match_num@ | Contents | Return value | Returned @start_pos@ | Returned @end_pos@
-- ----------- | -------- | ------------ | -------------------- | ------------------
-- 0 | Matches entire string | True | 0 | 11
-- 1 | Matches @\<a> \<b>@ | True | 0 | 7
-- 2 | Matches @\<a>@ | True | 0 | 3
-- 3 | Capture paren out of range | False | Unchanged | Unchanged
-- 
-- The following code sample and output implements this example.
-- 
-- 
-- === /{ .c } code/
-- >#include <glib.h>
-- >
-- >int
-- >main (int argc, char *argv[])
-- >{
-- >  g_autoptr(GError) local_error = NULL;
-- >  const char *regex_pattern = "<.*>";
-- >  const char *test_string = "<a> <b> <c>";
-- >  g_autoptr(GRegex) regex = NULL;
-- >
-- >  regex = g_regex_new (regex_pattern,
-- >                       G_REGEX_DEFAULT,
-- >                       G_REGEX_MATCH_DEFAULT,
-- >                       &local_error);
-- >  if (regex == NULL)
-- >    {
-- >      g_printerr ("Error creating regex: %s\n", local_error->message);
-- >      return -1;
-- >    }
-- >
-- >  g_autoptr(GMatchInfo) match_info = NULL;
-- >  g_regex_match_all (regex, test_string, G_REGEX_MATCH_DEFAULT, &match_info);
-- >
-- >  int n_matched_strings = g_match_info_get_match_count (match_info);
-- >
-- >  // Print header line
-- >  g_print ("match_num Contents                  Return value returned start_pos returned end_pos\n");
-- >
-- >  // Iterate over each capture paren, including one that is out of range as a demonstration.
-- >  for (int match_num = 0; match_num <= n_matched_strings; match_num++)
-- >    {
-- >      gboolean found_match;
-- >      g_autofree char *paren_string = NULL;
-- >      int start_pos = G_MAXINT;
-- >      int end_pos = G_MAXINT;
-- >
-- >      found_match = g_match_info_fetch_pos (match_info, match_num, &start_pos, &end_pos);
-- >
-- >      // If no match, display N/A as the found string.
-- >      if (start_pos == G_MAXINT || start_pos == -1)
-- >        paren_string = g_strdup ("N/A");
-- >      else
-- >        paren_string = g_strndup (test_string + start_pos, end_pos - start_pos);
-- >
-- >      g_print ("%-9d %-25s %-12d %-18d %d\n", match_num, paren_string, found_match, start_pos, end_pos);
-- >    }
-- >
-- >  return 0;
-- >}
-- 
-- 
-- 
-- 	
-- >match_num Contents                  Return value returned start_pos returned end_pos
-- >0         <a> <b> <c>               1            0                  11
-- >1         <a> <b>                   1            0                  7
-- >2         <a>                       1            0                  3
-- >3         N/A                       0            2147483647         2147483647
-- 
-- 
-- /Since: 2.14/
matchInfoFetchPos ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    MatchInfo
    -- ^ /@matchInfo@/: t'GI.GLib.Structs.MatchInfo.MatchInfo' structure
    -> Int32
    -- ^ /@matchNum@/: number of the capture parenthesis
    -> m ((Bool, Int32, Int32))
    -- ^ __Returns:__ True if /@matchNum@/ is within range, false otherwise. If
    --   the capture paren has a match, /@startPos@/ and /@endPos@/ contain the
    --   start and end positions (in bytes) of the matching substring. If the
    --   capture paren has no match, /@startPos@/ and /@endPos@/ are @-1@. If
    --   /@matchNum@/ is out of range, /@startPos@/ and /@endPos@/ are left unchanged.
matchInfoFetchPos matchInfo matchNum = liftIO $ do
    matchInfo' <- unsafeManagedPtrGetPtr matchInfo
    startPos <- allocMem :: IO (Ptr Int32)
    endPos <- allocMem :: IO (Ptr Int32)
    result <- g_match_info_fetch_pos matchInfo' matchNum startPos endPos
    let result' = (/= 0) result
    startPos' <- peek startPos
    endPos' <- peek endPos
    touchManagedPtr matchInfo
    freeMem startPos
    freeMem endPos
    return (result', startPos', endPos')

#if defined(ENABLE_OVERLOADING)
data MatchInfoFetchPosMethodInfo
instance (signature ~ (Int32 -> m ((Bool, Int32, Int32))), MonadIO m) => O.OverloadedMethod MatchInfoFetchPosMethodInfo MatchInfo signature where
    overloadedMethod = matchInfoFetchPos

instance O.OverloadedMethodInfo MatchInfoFetchPosMethodInfo MatchInfo where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MatchInfo.matchInfoFetchPos",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-MatchInfo.html#v:matchInfoFetchPos"
        })


#endif

-- method MatchInfo::free
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "match_info"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MatchInfo" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMatchInfo, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_match_info_free" g_match_info_free :: 
    Ptr MatchInfo ->                        -- match_info : TInterface (Name {namespace = "GLib", name = "MatchInfo"})
    IO ()

-- | If /@matchInfo@/ is not 'P.Nothing', calls 'GI.GLib.Structs.MatchInfo.matchInfoUnref'; otherwise does
-- nothing.
-- 
-- /Since: 2.14/
matchInfoFree ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (MatchInfo)
    -- ^ /@matchInfo@/: a t'GI.GLib.Structs.MatchInfo.MatchInfo', or 'P.Nothing'
    -> m ()
matchInfoFree matchInfo = liftIO $ do
    maybeMatchInfo <- case matchInfo of
        Nothing -> return FP.nullPtr
        Just jMatchInfo -> do
            jMatchInfo' <- unsafeManagedPtrGetPtr jMatchInfo
            return jMatchInfo'
    g_match_info_free maybeMatchInfo
    whenJust matchInfo touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data MatchInfoFreeMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod MatchInfoFreeMethodInfo MatchInfo signature where
    overloadedMethod i = matchInfoFree (Just i)

instance O.OverloadedMethodInfo MatchInfoFreeMethodInfo MatchInfo where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MatchInfo.matchInfoFree",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-MatchInfo.html#v:matchInfoFree"
        })


#endif

-- method MatchInfo::get_match_count
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "match_info"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MatchInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMatchInfo structure"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_match_info_get_match_count" g_match_info_get_match_count :: 
    Ptr MatchInfo ->                        -- match_info : TInterface (Name {namespace = "GLib", name = "MatchInfo"})
    IO Int32

-- | Retrieves the number of matched substrings (including substring 0,
-- that is the whole matched text), so 1 is returned if the pattern
-- has no substrings in it and 0 is returned if the match failed.
-- 
-- If the last match was obtained using the DFA algorithm, that is
-- using 'GI.GLib.Structs.Regex.regexMatchAll' or 'GI.GLib.Structs.Regex.regexMatchAllFull', the retrieved
-- count is not that of the number of capturing parentheses but that of
-- the number of matched substrings.
-- 
-- /Since: 2.14/
matchInfoGetMatchCount ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    MatchInfo
    -- ^ /@matchInfo@/: a t'GI.GLib.Structs.MatchInfo.MatchInfo' structure
    -> m Int32
    -- ^ __Returns:__ Number of matched substrings, or -1 if an error occurred
matchInfoGetMatchCount matchInfo = liftIO $ do
    matchInfo' <- unsafeManagedPtrGetPtr matchInfo
    result <- g_match_info_get_match_count matchInfo'
    touchManagedPtr matchInfo
    return result

#if defined(ENABLE_OVERLOADING)
data MatchInfoGetMatchCountMethodInfo
instance (signature ~ (m Int32), MonadIO m) => O.OverloadedMethod MatchInfoGetMatchCountMethodInfo MatchInfo signature where
    overloadedMethod = matchInfoGetMatchCount

instance O.OverloadedMethodInfo MatchInfoGetMatchCountMethodInfo MatchInfo where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MatchInfo.matchInfoGetMatchCount",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-MatchInfo.html#v:matchInfoGetMatchCount"
        })


#endif

-- method MatchInfo::get_regex
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "match_info"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MatchInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMatchInfo" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "Regex" })
-- throws : False
-- Skip return : False

foreign import ccall "g_match_info_get_regex" g_match_info_get_regex :: 
    Ptr MatchInfo ->                        -- match_info : TInterface (Name {namespace = "GLib", name = "MatchInfo"})
    IO (Ptr GLib.Regex.Regex)

-- | Returns t'GI.GLib.Structs.Regex.Regex' object used in /@matchInfo@/. It belongs to Glib
-- and must not be freed. Use 'GI.GLib.Structs.Regex.regexRef' if you need to keep it
-- after you free /@matchInfo@/ object.
-- 
-- /Since: 2.14/
matchInfoGetRegex ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    MatchInfo
    -- ^ /@matchInfo@/: a t'GI.GLib.Structs.MatchInfo.MatchInfo'
    -> m GLib.Regex.Regex
    -- ^ __Returns:__ t'GI.GLib.Structs.Regex.Regex' object used in /@matchInfo@/
matchInfoGetRegex matchInfo = liftIO $ do
    matchInfo' <- unsafeManagedPtrGetPtr matchInfo
    result <- g_match_info_get_regex matchInfo'
    checkUnexpectedReturnNULL "matchInfoGetRegex" result
    result' <- (newBoxed GLib.Regex.Regex) result
    touchManagedPtr matchInfo
    return result'

#if defined(ENABLE_OVERLOADING)
data MatchInfoGetRegexMethodInfo
instance (signature ~ (m GLib.Regex.Regex), MonadIO m) => O.OverloadedMethod MatchInfoGetRegexMethodInfo MatchInfo signature where
    overloadedMethod = matchInfoGetRegex

instance O.OverloadedMethodInfo MatchInfoGetRegexMethodInfo MatchInfo where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MatchInfo.matchInfoGetRegex",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-MatchInfo.html#v:matchInfoGetRegex"
        })


#endif

-- method MatchInfo::get_string
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "match_info"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MatchInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMatchInfo" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_match_info_get_string" g_match_info_get_string :: 
    Ptr MatchInfo ->                        -- match_info : TInterface (Name {namespace = "GLib", name = "MatchInfo"})
    IO CString

-- | Returns the string searched with /@matchInfo@/. This is the
-- string passed to 'GI.GLib.Structs.Regex.regexMatch' or 'GI.GLib.Structs.Regex.regexReplace' so
-- you may not free it before calling this function.
-- 
-- /Since: 2.14/
matchInfoGetString ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    MatchInfo
    -- ^ /@matchInfo@/: a t'GI.GLib.Structs.MatchInfo.MatchInfo'
    -> m T.Text
    -- ^ __Returns:__ the string searched with /@matchInfo@/
matchInfoGetString matchInfo = liftIO $ do
    matchInfo' <- unsafeManagedPtrGetPtr matchInfo
    result <- g_match_info_get_string matchInfo'
    checkUnexpectedReturnNULL "matchInfoGetString" result
    result' <- cstringToText result
    touchManagedPtr matchInfo
    return result'

#if defined(ENABLE_OVERLOADING)
data MatchInfoGetStringMethodInfo
instance (signature ~ (m T.Text), MonadIO m) => O.OverloadedMethod MatchInfoGetStringMethodInfo MatchInfo signature where
    overloadedMethod = matchInfoGetString

instance O.OverloadedMethodInfo MatchInfoGetStringMethodInfo MatchInfo where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MatchInfo.matchInfoGetString",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-MatchInfo.html#v:matchInfoGetString"
        })


#endif

-- method MatchInfo::is_partial_match
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "match_info"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MatchInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMatchInfo structure"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_match_info_is_partial_match" g_match_info_is_partial_match :: 
    Ptr MatchInfo ->                        -- match_info : TInterface (Name {namespace = "GLib", name = "MatchInfo"})
    IO CInt

-- | Usually if the string passed to g_regex_match*() matches as far as
-- it goes, but is too short to match the entire pattern, 'P.False' is
-- returned. There are circumstances where it might be helpful to
-- distinguish this case from other cases in which there is no match.
-- 
-- Consider, for example, an application where a human is required to
-- type in data for a field with specific formatting requirements. An
-- example might be a date in the form ddmmmyy, defined by the pattern
-- \"^\\d?\\d(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)\\d\\d$\".
-- If the application sees the user’s keystrokes one by one, and can
-- check that what has been typed so far is potentially valid, it is
-- able to raise an error as soon as a mistake is made.
-- 
-- GRegex supports the concept of partial matching by means of the
-- 'GI.GLib.Flags.RegexMatchFlagsPartialSoft' and 'GI.GLib.Flags.RegexMatchFlagsPartialHard' flags.
-- When they are used, the return code for
-- 'GI.GLib.Structs.Regex.regexMatch' or 'GI.GLib.Structs.Regex.regexMatchFull' is, as usual, 'P.True'
-- for a complete match, 'P.False' otherwise. But, when these functions
-- return 'P.False', you can check if the match was partial calling
-- 'GI.GLib.Structs.MatchInfo.matchInfoIsPartialMatch'.
-- 
-- The difference between 'GI.GLib.Flags.RegexMatchFlagsPartialSoft' and
-- 'GI.GLib.Flags.RegexMatchFlagsPartialHard' is that when a partial match is encountered
-- with 'GI.GLib.Flags.RegexMatchFlagsPartialSoft', matching continues to search for a
-- possible complete match, while with 'GI.GLib.Flags.RegexMatchFlagsPartialHard' matching
-- stops at the partial match.
-- When both 'GI.GLib.Flags.RegexMatchFlagsPartialSoft' and 'GI.GLib.Flags.RegexMatchFlagsPartialHard'
-- are set, the latter takes precedence.
-- 
-- There were formerly some restrictions on the pattern for partial matching.
-- The restrictions no longer apply.
-- 
-- See pcrepartial(3) for more information on partial matching.
-- 
-- /Since: 2.14/
matchInfoIsPartialMatch ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    MatchInfo
    -- ^ /@matchInfo@/: a t'GI.GLib.Structs.MatchInfo.MatchInfo' structure
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the match was partial, 'P.False' otherwise
matchInfoIsPartialMatch matchInfo = liftIO $ do
    matchInfo' <- unsafeManagedPtrGetPtr matchInfo
    result <- g_match_info_is_partial_match matchInfo'
    let result' = (/= 0) result
    touchManagedPtr matchInfo
    return result'

#if defined(ENABLE_OVERLOADING)
data MatchInfoIsPartialMatchMethodInfo
instance (signature ~ (m Bool), MonadIO m) => O.OverloadedMethod MatchInfoIsPartialMatchMethodInfo MatchInfo signature where
    overloadedMethod = matchInfoIsPartialMatch

instance O.OverloadedMethodInfo MatchInfoIsPartialMatchMethodInfo MatchInfo where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MatchInfo.matchInfoIsPartialMatch",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-MatchInfo.html#v:matchInfoIsPartialMatch"
        })


#endif

-- method MatchInfo::matches
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "match_info"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MatchInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMatchInfo structure"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_match_info_matches" g_match_info_matches :: 
    Ptr MatchInfo ->                        -- match_info : TInterface (Name {namespace = "GLib", name = "MatchInfo"})
    IO CInt

-- | Returns whether the previous match operation succeeded.
-- 
-- /Since: 2.14/
matchInfoMatches ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    MatchInfo
    -- ^ /@matchInfo@/: a t'GI.GLib.Structs.MatchInfo.MatchInfo' structure
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the previous match operation succeeded,
    --   'P.False' otherwise
matchInfoMatches matchInfo = liftIO $ do
    matchInfo' <- unsafeManagedPtrGetPtr matchInfo
    result <- g_match_info_matches matchInfo'
    let result' = (/= 0) result
    touchManagedPtr matchInfo
    return result'

#if defined(ENABLE_OVERLOADING)
data MatchInfoMatchesMethodInfo
instance (signature ~ (m Bool), MonadIO m) => O.OverloadedMethod MatchInfoMatchesMethodInfo MatchInfo signature where
    overloadedMethod = matchInfoMatches

instance O.OverloadedMethodInfo MatchInfoMatchesMethodInfo MatchInfo where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MatchInfo.matchInfoMatches",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-MatchInfo.html#v:matchInfoMatches"
        })


#endif

-- method MatchInfo::next
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "match_info"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MatchInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMatchInfo structure"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_match_info_next" g_match_info_next :: 
    Ptr MatchInfo ->                        -- match_info : TInterface (Name {namespace = "GLib", name = "MatchInfo"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Scans for the next match using the same parameters of the previous
-- call to 'GI.GLib.Structs.Regex.regexMatchFull' or 'GI.GLib.Structs.Regex.regexMatch' that returned
-- /@matchInfo@/.
-- 
-- The match is done on the string passed to the match function, so you
-- cannot free it before calling this function.
-- 
-- /Since: 2.14/
matchInfoNext ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    MatchInfo
    -- ^ /@matchInfo@/: a t'GI.GLib.Structs.MatchInfo.MatchInfo' structure
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
matchInfoNext matchInfo = liftIO $ do
    matchInfo' <- unsafeManagedPtrGetPtr matchInfo
    onException (do
        _ <- propagateGError $ g_match_info_next matchInfo'
        touchManagedPtr matchInfo
        return ()
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data MatchInfoNextMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod MatchInfoNextMethodInfo MatchInfo signature where
    overloadedMethod = matchInfoNext

instance O.OverloadedMethodInfo MatchInfoNextMethodInfo MatchInfo where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MatchInfo.matchInfoNext",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-MatchInfo.html#v:matchInfoNext"
        })


#endif

-- method MatchInfo::ref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "match_info"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MatchInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMatchInfo" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "MatchInfo" })
-- throws : False
-- Skip return : False

foreign import ccall "g_match_info_ref" g_match_info_ref :: 
    Ptr MatchInfo ->                        -- match_info : TInterface (Name {namespace = "GLib", name = "MatchInfo"})
    IO (Ptr MatchInfo)

-- | Increases reference count of /@matchInfo@/ by 1.
-- 
-- /Since: 2.30/
matchInfoRef ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    MatchInfo
    -- ^ /@matchInfo@/: a t'GI.GLib.Structs.MatchInfo.MatchInfo'
    -> m MatchInfo
    -- ^ __Returns:__ /@matchInfo@/
matchInfoRef matchInfo = liftIO $ do
    matchInfo' <- unsafeManagedPtrGetPtr matchInfo
    result <- g_match_info_ref matchInfo'
    checkUnexpectedReturnNULL "matchInfoRef" result
    result' <- (wrapBoxed MatchInfo) result
    touchManagedPtr matchInfo
    return result'

#if defined(ENABLE_OVERLOADING)
data MatchInfoRefMethodInfo
instance (signature ~ (m MatchInfo), MonadIO m) => O.OverloadedMethod MatchInfoRefMethodInfo MatchInfo signature where
    overloadedMethod = matchInfoRef

instance O.OverloadedMethodInfo MatchInfoRefMethodInfo MatchInfo where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MatchInfo.matchInfoRef",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-MatchInfo.html#v:matchInfoRef"
        })


#endif

-- method MatchInfo::unref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "match_info"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MatchInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMatchInfo" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_match_info_unref" g_match_info_unref :: 
    Ptr MatchInfo ->                        -- match_info : TInterface (Name {namespace = "GLib", name = "MatchInfo"})
    IO ()

-- | Decreases reference count of /@matchInfo@/ by 1. When reference count drops
-- to zero, it frees all the memory associated with the match_info structure.
-- 
-- /Since: 2.30/
matchInfoUnref ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    MatchInfo
    -- ^ /@matchInfo@/: a t'GI.GLib.Structs.MatchInfo.MatchInfo'
    -> m ()
matchInfoUnref matchInfo = liftIO $ do
    matchInfo' <- unsafeManagedPtrGetPtr matchInfo
    g_match_info_unref matchInfo'
    touchManagedPtr matchInfo
    return ()

#if defined(ENABLE_OVERLOADING)
data MatchInfoUnrefMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod MatchInfoUnrefMethodInfo MatchInfo signature where
    overloadedMethod = matchInfoUnref

instance O.OverloadedMethodInfo MatchInfoUnrefMethodInfo MatchInfo where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MatchInfo.matchInfoUnref",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-MatchInfo.html#v:matchInfoUnref"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveMatchInfoMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveMatchInfoMethod "expandReferences" o = MatchInfoExpandReferencesMethodInfo
    ResolveMatchInfoMethod "fetch" o = MatchInfoFetchMethodInfo
    ResolveMatchInfoMethod "fetchAll" o = MatchInfoFetchAllMethodInfo
    ResolveMatchInfoMethod "fetchNamed" o = MatchInfoFetchNamedMethodInfo
    ResolveMatchInfoMethod "fetchNamedPos" o = MatchInfoFetchNamedPosMethodInfo
    ResolveMatchInfoMethod "fetchPos" o = MatchInfoFetchPosMethodInfo
    ResolveMatchInfoMethod "free" o = MatchInfoFreeMethodInfo
    ResolveMatchInfoMethod "isPartialMatch" o = MatchInfoIsPartialMatchMethodInfo
    ResolveMatchInfoMethod "matches" o = MatchInfoMatchesMethodInfo
    ResolveMatchInfoMethod "next" o = MatchInfoNextMethodInfo
    ResolveMatchInfoMethod "ref" o = MatchInfoRefMethodInfo
    ResolveMatchInfoMethod "unref" o = MatchInfoUnrefMethodInfo
    ResolveMatchInfoMethod "getMatchCount" o = MatchInfoGetMatchCountMethodInfo
    ResolveMatchInfoMethod "getRegex" o = MatchInfoGetRegexMethodInfo
    ResolveMatchInfoMethod "getString" o = MatchInfoGetStringMethodInfo
    ResolveMatchInfoMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveMatchInfoMethod t MatchInfo, O.OverloadedMethod info MatchInfo p) => OL.IsLabel t (MatchInfo -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveMatchInfoMethod t MatchInfo, O.OverloadedMethod info MatchInfo p, R.HasField t MatchInfo p) => R.HasField t MatchInfo p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveMatchInfoMethod t MatchInfo, O.OverloadedMethodInfo info MatchInfo) => OL.IsLabel t (O.MethodProxy info MatchInfo) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


