{-# LANGUAGE CPP #-}
{-# LANGUAGE NoRebindableSyntax #-}
{-# OPTIONS_GHC -fno-warn-missing-import-lists #-}
{-# OPTIONS_GHC -w #-}
module Paths_mockery (
    version,
    getBinDir, getLibDir, getDynLibDir, getDataDir, getLibexecDir,
    getDataFileName, getSysconfDir
  ) where


import qualified Control.Exception as Exception
import qualified Data.List as List
import Data.Version (Version(..))
import System.Environment (getEnv)
import Prelude


#if defined(VERSION_base)

#if MIN_VERSION_base(4,0,0)
catchIO :: IO a -> (Exception.IOException -> IO a) -> IO a
#else
catchIO :: IO a -> (Exception.Exception -> IO a) -> IO a
#endif

#else
catchIO :: IO a -> (Exception.IOException -> IO a) -> IO a
#endif
catchIO = Exception.catch

version :: Version
version = Version [0,3,5] []

getDataFileName :: FilePath -> IO FilePath
getDataFileName name = do
  dir <- getDataDir
  return (dir `joinFileName` name)

getBinDir, getLibDir, getDynLibDir, getDataDir, getLibexecDir, getSysconfDir :: IO FilePath



bindir, libdir, dynlibdir, datadir, libexecdir, sysconfdir :: FilePath
bindir     = "/usr/bin"
libdir     = "/usr/lib/ghc-9.4.8/site-local/mockery-0.3.5"
dynlibdir  = "/usr/lib"
datadir    = "/usr/share/haskell-mockery"
libexecdir = "/usr/libexec/x86_64-linux-ghc-9.4.8/mockery-0.3.5"
sysconfdir = "/usr/etc"

getBinDir     = catchIO (getEnv "mockery_bindir")     (\_ -> return bindir)
getLibDir     = catchIO (getEnv "mockery_libdir")     (\_ -> return libdir)
getDynLibDir  = catchIO (getEnv "mockery_dynlibdir")  (\_ -> return dynlibdir)
getDataDir    = catchIO (getEnv "mockery_datadir")    (\_ -> return datadir)
getLibexecDir = catchIO (getEnv "mockery_libexecdir") (\_ -> return libexecdir)
getSysconfDir = catchIO (getEnv "mockery_sysconfdir") (\_ -> return sysconfdir)




joinFileName :: String -> String -> FilePath
joinFileName ""  fname = fname
joinFileName "." fname = fname
joinFileName dir ""    = dir
joinFileName dir fname
  | isPathSeparator (List.last dir) = dir ++ fname
  | otherwise                       = dir ++ pathSeparator : fname

pathSeparator :: Char
pathSeparator = '/'

isPathSeparator :: Char -> Bool
isPathSeparator c = c == '/'
