// This file is @generated by prost-build.
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct SmartInterface {}
/// Nested message and enum types in `SMARTInterface`.
pub mod smart_interface {
    #[derive(serde::Serialize, serde::Deserialize)]
    #[serde(rename_all = "snake_case")]
    #[derive(strum::EnumIter)]
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Kind {
        Ata = 0,
        NvMe = 1,
    }
    impl Kind {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::Ata => "ATA",
                Self::NvMe => "NVMe",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "ATA" => Some(Self::Ata),
                "NVMe" => Some(Self::NvMe),
                _ => None,
            }
        }
    }
}
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Disk {
    #[prost(string, required, tag = "1")]
    pub id: ::prost::alloc::string::String,
    #[prost(string, optional, tag = "2")]
    pub model: ::core::option::Option<::prost::alloc::string::String>,
    #[prost(enumeration = "DiskKind", optional, tag = "3")]
    pub kind: ::core::option::Option<i32>,
    #[prost(enumeration = "smart_interface::Kind", optional, tag = "4")]
    pub smart_interface: ::core::option::Option<i32>,
    #[prost(uint64, required, tag = "5")]
    pub capacity_bytes: u64,
    #[prost(uint64, optional, tag = "6")]
    pub formatted_bytes: ::core::option::Option<u64>,
    #[prost(bool, required, tag = "7")]
    pub is_system: bool,
    #[prost(float, required, tag = "8")]
    pub busy_percent: f32,
    #[prost(float, required, tag = "9")]
    pub response_time_ms: f32,
    #[prost(uint64, required, tag = "10")]
    pub rx_speed_bytes_ps: u64,
    #[prost(uint64, required, tag = "11")]
    pub rx_bytes_total: u64,
    #[prost(uint64, required, tag = "12")]
    pub tx_speed_bytes_ps: u64,
    #[prost(uint64, required, tag = "13")]
    pub tx_bytes_total: u64,
    #[prost(bool, required, tag = "14")]
    pub ejectable: bool,
    #[prost(uint32, optional, tag = "15")]
    pub temperature_milli_k: ::core::option::Option<u32>,
}
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SmartData {
    #[prost(uint64, required, tag = "1")]
    pub powered_on_seconds: u64,
    #[prost(uint64, required, tag = "2")]
    pub last_update_time: u64,
    #[prost(enumeration = "smart_data::TestResult", optional, tag = "3")]
    pub test_result: ::core::option::Option<i32>,
    #[prost(oneof = "smart_data::Data", tags = "4, 5")]
    pub data: ::core::option::Option<smart_data::Data>,
}
/// Nested message and enum types in `SmartData`.
pub mod smart_data {
    #[derive(serde::Serialize, serde::Deserialize)]
    #[serde(rename_all = "snake_case")]
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Ata {
        #[prost(message, repeated, tag = "1")]
        pub attributes: ::prost::alloc::vec::Vec<ata::Attribute>,
    }
    /// Nested message and enum types in `Ata`.
    pub mod ata {
        #[derive(serde::Serialize, serde::Deserialize)]
        #[serde(rename_all = "snake_case")]
        #[derive(Clone, PartialEq, ::prost::Message)]
        pub struct Attribute {
            #[prost(uint32, required, tag = "1")]
            pub id: u32,
            #[prost(string, required, tag = "2")]
            pub name: ::prost::alloc::string::String,
            #[prost(uint32, required, tag = "3")]
            pub flags: u32,
            #[prost(int32, required, tag = "4")]
            pub value: i32,
            #[prost(int32, required, tag = "5")]
            pub worst: i32,
            #[prost(int32, required, tag = "6")]
            pub threshold: i32,
            #[prost(int64, required, tag = "7")]
            pub pretty: i64,
            #[prost(enumeration = "PrettyUnit", required, tag = "8")]
            pub pretty_unit: i32,
        }
        #[derive(serde::Serialize, serde::Deserialize)]
        #[serde(rename_all = "snake_case")]
        #[derive(strum::EnumIter)]
        #[derive(
            Clone,
            Copy,
            Debug,
            PartialEq,
            Eq,
            Hash,
            PartialOrd,
            Ord,
            ::prost::Enumeration
        )]
        #[repr(i32)]
        pub enum PrettyUnit {
            Unknown = 0,
            Dimentionless = 1,
            Milliseconds = 2,
            Sectors = 3,
            Millikelvin = 4,
        }
        impl PrettyUnit {
            /// String value of the enum field names used in the ProtoBuf definition.
            ///
            /// The values are not transformed in any way and thus are considered stable
            /// (if the ProtoBuf definition does not change) and safe for programmatic use.
            pub fn as_str_name(&self) -> &'static str {
                match self {
                    Self::Unknown => "Unknown",
                    Self::Dimentionless => "Dimentionless",
                    Self::Milliseconds => "Milliseconds",
                    Self::Sectors => "Sectors",
                    Self::Millikelvin => "Millikelvin",
                }
            }
            /// Creates an enum from field names used in the ProtoBuf definition.
            pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
                match value {
                    "Unknown" => Some(Self::Unknown),
                    "Dimentionless" => Some(Self::Dimentionless),
                    "Milliseconds" => Some(Self::Milliseconds),
                    "Sectors" => Some(Self::Sectors),
                    "Millikelvin" => Some(Self::Millikelvin),
                    _ => None,
                }
            }
        }
    }
    #[derive(serde::Serialize, serde::Deserialize)]
    #[serde(rename_all = "snake_case")]
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Nvme {
        #[prost(uint32, optional, tag = "1")]
        pub avail_spare: ::core::option::Option<u32>,
        #[prost(uint32, optional, tag = "2")]
        pub spare_thresh: ::core::option::Option<u32>,
        #[prost(uint32, optional, tag = "3")]
        pub percent_used: ::core::option::Option<u32>,
        #[prost(uint64, optional, tag = "4")]
        pub total_data_read: ::core::option::Option<u64>,
        #[prost(uint64, optional, tag = "5")]
        pub total_data_written: ::core::option::Option<u64>,
        #[prost(uint64, optional, tag = "6")]
        pub ctrl_busy_minutes: ::core::option::Option<u64>,
        #[prost(uint64, optional, tag = "7")]
        pub power_cycles: ::core::option::Option<u64>,
        #[prost(uint64, optional, tag = "8")]
        pub unsafe_shutdowns: ::core::option::Option<u64>,
        #[prost(uint64, optional, tag = "9")]
        pub media_errors: ::core::option::Option<u64>,
        #[prost(uint64, optional, tag = "10")]
        pub num_err_log_entries: ::core::option::Option<u64>,
        #[prost(uint32, repeated, packed = "false", tag = "11")]
        pub temp_sensors: ::prost::alloc::vec::Vec<u32>,
        #[prost(uint32, optional, tag = "12")]
        pub warn_composite_temp_thresh: ::core::option::Option<u32>,
        #[prost(uint32, optional, tag = "13")]
        pub crit_composite_temp_thresh: ::core::option::Option<u32>,
        #[prost(uint32, optional, tag = "14")]
        pub warn_composite_temp_time: ::core::option::Option<u32>,
        #[prost(uint32, optional, tag = "15")]
        pub crit_composite_temp_time: ::core::option::Option<u32>,
    }
    #[derive(serde::Serialize, serde::Deserialize)]
    #[serde(rename_all = "snake_case")]
    #[derive(strum::EnumIter)]
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum TestResult {
        Success = 0,
        Aborted = 1,
        FatalError = 2,
        InProgress = 3,
        /// ATA only
        Interrupted = 4,
        ErrorUnknown = 5,
        ErrorElectrical = 6,
        ErrorServo = 7,
        ErrorRead = 8,
        ErrorHandling = 9,
        /// NVMe only
        CtrlReset = 10,
        NsRemoved = 11,
        AbortedFormat = 12,
        UnknownSegmentFailed = 13,
        KnownSegmentFailed = 14,
        AbortedUnknown = 15,
        AbortedSanitize = 16,
    }
    impl TestResult {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::Success => "Success",
                Self::Aborted => "Aborted",
                Self::FatalError => "FatalError",
                Self::InProgress => "InProgress",
                Self::Interrupted => "Interrupted",
                Self::ErrorUnknown => "ErrorUnknown",
                Self::ErrorElectrical => "ErrorElectrical",
                Self::ErrorServo => "ErrorServo",
                Self::ErrorRead => "ErrorRead",
                Self::ErrorHandling => "ErrorHandling",
                Self::CtrlReset => "CtrlReset",
                Self::NsRemoved => "NsRemoved",
                Self::AbortedFormat => "AbortedFormat",
                Self::UnknownSegmentFailed => "UnknownSegmentFailed",
                Self::KnownSegmentFailed => "KnownSegmentFailed",
                Self::AbortedUnknown => "AbortedUnknown",
                Self::AbortedSanitize => "AbortedSanitize",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "Success" => Some(Self::Success),
                "Aborted" => Some(Self::Aborted),
                "FatalError" => Some(Self::FatalError),
                "InProgress" => Some(Self::InProgress),
                "Interrupted" => Some(Self::Interrupted),
                "ErrorUnknown" => Some(Self::ErrorUnknown),
                "ErrorElectrical" => Some(Self::ErrorElectrical),
                "ErrorServo" => Some(Self::ErrorServo),
                "ErrorRead" => Some(Self::ErrorRead),
                "ErrorHandling" => Some(Self::ErrorHandling),
                "CtrlReset" => Some(Self::CtrlReset),
                "NsRemoved" => Some(Self::NsRemoved),
                "AbortedFormat" => Some(Self::AbortedFormat),
                "UnknownSegmentFailed" => Some(Self::UnknownSegmentFailed),
                "KnownSegmentFailed" => Some(Self::KnownSegmentFailed),
                "AbortedUnknown" => Some(Self::AbortedUnknown),
                "AbortedSanitize" => Some(Self::AbortedSanitize),
                _ => None,
            }
        }
    }
    #[derive(serde::Serialize, serde::Deserialize)]
    #[serde(rename_all = "snake_case")]
    #[derive(strum::EnumIter)]
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Data {
        #[prost(message, tag = "4")]
        Ata(Ata),
        #[prost(message, tag = "5")]
        Nvme(Nvme),
    }
}
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct EjectRequest {
    #[prost(string, required, tag = "1")]
    pub id: ::prost::alloc::string::String,
}
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SmartRequest {
    #[prost(string, required, tag = "1")]
    pub id: ::prost::alloc::string::String,
}
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DisksRequest {
    #[prost(oneof = "disks_request::Request", tags = "1, 2, 3")]
    pub request: ::core::option::Option<disks_request::Request>,
}
/// Nested message and enum types in `DisksRequest`.
pub mod disks_request {
    #[derive(serde::Serialize, serde::Deserialize)]
    #[serde(rename_all = "snake_case")]
    #[derive(strum::EnumIter)]
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Request {
        #[prost(message, tag = "1")]
        Disks(super::super::common::Empty),
        #[prost(message, tag = "2")]
        Eject(super::EjectRequest),
        #[prost(message, tag = "3")]
        Smart(super::SmartRequest),
    }
}
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DisksResponse {
    #[prost(oneof = "disks_response::Response", tags = "2, 3, 4, 5")]
    pub response: ::core::option::Option<disks_response::Response>,
}
/// Nested message and enum types in `DisksResponse`.
pub mod disks_response {
    #[derive(serde::Serialize, serde::Deserialize)]
    #[serde(rename_all = "snake_case")]
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct DiskList {
        #[prost(message, repeated, tag = "1")]
        pub disks: ::prost::alloc::vec::Vec<super::Disk>,
    }
    #[derive(serde::Serialize, serde::Deserialize)]
    #[serde(rename_all = "snake_case")]
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct OptionalSmartData {
        #[prost(message, optional, tag = "1")]
        pub smart: ::core::option::Option<super::SmartData>,
    }
    #[derive(serde::Serialize, serde::Deserialize)]
    #[serde(rename_all = "snake_case")]
    #[derive(strum::EnumIter)]
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Response {
        #[prost(message, tag = "2")]
        Disks(DiskList),
        #[prost(message, tag = "3")]
        Smart(OptionalSmartData),
        #[prost(message, tag = "4")]
        Eject(super::super::common::Empty),
        #[prost(message, tag = "5")]
        Error(super::DisksResponseError),
    }
}
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ErrorEjectFailed {
    #[prost(message, repeated, tag = "2")]
    pub blockers: ::prost::alloc::vec::Vec<error_eject_failed::Blocker>,
}
/// Nested message and enum types in `ErrorEjectFailed`.
pub mod error_eject_failed {
    #[derive(serde::Serialize, serde::Deserialize)]
    #[serde(rename_all = "snake_case")]
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Blocker {
        #[prost(uint32, required, tag = "1")]
        pub pid: u32,
        #[prost(string, repeated, tag = "2")]
        pub files: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
        #[prost(string, repeated, tag = "3")]
        pub dirs: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    }
}
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DisksResponseError {
    #[prost(oneof = "disks_response_error::Error", tags = "1, 5")]
    pub error: ::core::option::Option<disks_response_error::Error>,
}
/// Nested message and enum types in `DisksResponseError`.
pub mod disks_response_error {
    #[derive(serde::Serialize, serde::Deserialize)]
    #[serde(rename_all = "snake_case")]
    #[derive(strum::EnumIter)]
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Error {
        #[prost(message, tag = "1")]
        Eject(super::ErrorEjectFailed),
        #[prost(message, tag = "5")]
        UnknownRequest(super::super::common::Empty),
    }
}
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(strum::EnumIter)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum DiskKind {
    Hdd = 0,
    Ssd = 1,
    NvMe = 2,
    EMmc = 3,
    Sd = 4,
    IScsi = 5,
    Floppy = 6,
    Optical = 7,
    ThumbDrive = 8,
}
impl DiskKind {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            Self::Hdd => "HDD",
            Self::Ssd => "SSD",
            Self::NvMe => "NVMe",
            Self::EMmc => "eMMC",
            Self::Sd => "SD",
            Self::IScsi => "iSCSI",
            Self::Floppy => "Floppy",
            Self::Optical => "Optical",
            Self::ThumbDrive => "ThumbDrive",
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "HDD" => Some(Self::Hdd),
            "SSD" => Some(Self::Ssd),
            "NVMe" => Some(Self::NvMe),
            "eMMC" => Some(Self::EMmc),
            "SD" => Some(Self::Sd),
            "iSCSI" => Some(Self::IScsi),
            "Floppy" => Some(Self::Floppy),
            "Optical" => Some(Self::Optical),
            "ThumbDrive" => Some(Self::ThumbDrive),
            _ => None,
        }
    }
}
