// components/services/storage/public/mojom/storage_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_STORAGE_SERVICE_MOJOM_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_STORAGE_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "components/services/storage/public/mojom/storage_service.mojom-shared.h"
#include "components/services/storage/public/mojom/storage_service.mojom-forward.h"
#include "components/services/storage/public/mojom/partition.mojom.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "components/services/storage/public/mojom/filesystem/directory.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace storage {
namespace mojom {

class StorageServiceProxy;

template <typename ImplRefTraits>
class StorageServiceStub;

class StorageServiceRequestValidator;


class  StorageService
    : public StorageServiceInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = StorageServiceInterfaceBase;
  using Proxy_ = StorageServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = StorageServiceStub<ImplRefTraits>;

  using RequestValidator_ = StorageServiceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kEnableAggressiveDomStorageFlushingMinVersion = 0,
    kSetDataDirectoryMinVersion = 0,
    kBindPartitionMinVersion = 0,
    kBindTestApiMinVersion = 0,
  };
  virtual ~StorageService() {}

  
  virtual void EnableAggressiveDomStorageFlushing() = 0;

  
  virtual void SetDataDirectory(const ::base::FilePath& path, ::mojo::PendingRemote<::storage::mojom::Directory> directory) = 0;

  
  virtual void BindPartition(const base::Optional<::base::FilePath>& path, ::mojo::PendingReceiver<::storage::mojom::Partition> receiver) = 0;

  
  virtual void BindTestApi(::mojo::ScopedMessagePipeHandle test_api_receiver) = 0;
};



class  StorageServiceProxy
    : public StorageService {
 public:
  using InterfaceType = StorageService;

  explicit StorageServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void EnableAggressiveDomStorageFlushing() final;
  
  void SetDataDirectory(const ::base::FilePath& path, ::mojo::PendingRemote<::storage::mojom::Directory> directory) final;
  
  void BindPartition(const base::Optional<::base::FilePath>& path, ::mojo::PendingReceiver<::storage::mojom::Partition> receiver) final;
  
  void BindTestApi(::mojo::ScopedMessagePipeHandle test_api_receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  StorageServiceStubDispatch {
 public:
  static bool Accept(StorageService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      StorageService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<StorageService>>
class StorageServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  StorageServiceStub() {}
  ~StorageServiceStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return StorageServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return StorageServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  StorageServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace mojom
}  // namespace storage

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_STORAGE_SERVICE_MOJOM_H_