// third_party/blink/public/mojom/direct_sockets/direct_sockets.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_DIRECT_SOCKETS_DIRECT_SOCKETS_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_DIRECT_SOCKETS_DIRECT_SOCKETS_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/direct_sockets/direct_sockets.mojom-shared.h"
#include "third_party/blink/public/mojom/direct_sockets/direct_sockets.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/renderer/platform/platform_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {
namespace blink {

class DirectSocketsServiceProxy;

template <typename ImplRefTraits>
class DirectSocketsServiceStub;

class DirectSocketsServiceRequestValidator;
class DirectSocketsServiceResponseValidator;


class PLATFORM_EXPORT DirectSocketsService
    : public DirectSocketsServiceInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = DirectSocketsServiceInterfaceBase;
  using Proxy_ = DirectSocketsServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = DirectSocketsServiceStub<ImplRefTraits>;

  using RequestValidator_ = DirectSocketsServiceRequestValidator;
  using ResponseValidator_ = DirectSocketsServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kOpenTcpSocketMinVersion = 0,
    kOpenUdpSocketMinVersion = 0,
  };
  virtual ~DirectSocketsService() {}


  using OpenTcpSocketCallback = base::OnceCallback<void(int32_t)>;
  
  virtual void OpenTcpSocket(DirectSocketOptionsPtr options, OpenTcpSocketCallback callback) = 0;


  using OpenUdpSocketCallback = base::OnceCallback<void(int32_t)>;
  
  virtual void OpenUdpSocket(DirectSocketOptionsPtr options, OpenUdpSocketCallback callback) = 0;
};



class PLATFORM_EXPORT DirectSocketsServiceProxy
    : public DirectSocketsService {
 public:
  using InterfaceType = DirectSocketsService;

  explicit DirectSocketsServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OpenTcpSocket(DirectSocketOptionsPtr options, OpenTcpSocketCallback callback) final;
  
  void OpenUdpSocket(DirectSocketOptionsPtr options, OpenUdpSocketCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT DirectSocketsServiceStubDispatch {
 public:
  static bool Accept(DirectSocketsService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DirectSocketsService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DirectSocketsService>>
class DirectSocketsServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DirectSocketsServiceStub() {}
  ~DirectSocketsServiceStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DirectSocketsServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DirectSocketsServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT DirectSocketsServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT DirectSocketsServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class PLATFORM_EXPORT DirectSocketOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DirectSocketOptions, T>::value>;
  using DataView = DirectSocketOptionsDataView;
  using Data_ = internal::DirectSocketOptions_Data;

  template <typename... Args>
  static DirectSocketOptionsPtr New(Args&&... args) {
    return DirectSocketOptionsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DirectSocketOptionsPtr From(const U& u) {
    return mojo::TypeConverter<DirectSocketOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DirectSocketOptions>::Convert(*this);
  }


  DirectSocketOptions();

  DirectSocketOptions(
      const WTF::String& local_hostname,
      uint16_t local_port,
      const WTF::String& remote_hostname,
      uint16_t remote_port,
      int32_t send_buffer_size,
      int32_t receive_buffer_size,
      bool keep_alive,
      bool no_delay);

  ~DirectSocketOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DirectSocketOptionsPtr>
  DirectSocketOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DirectSocketOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DirectSocketOptions::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DirectSocketOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DirectSocketOptions_UnserializedMessageContext<
            UserType, DirectSocketOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<DirectSocketOptions::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return DirectSocketOptions::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DirectSocketOptions_UnserializedMessageContext<
            UserType, DirectSocketOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DirectSocketOptions::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  WTF::String local_hostname;
  
  uint16_t local_port;
  
  WTF::String remote_hostname;
  
  uint16_t remote_port;
  
  int32_t send_buffer_size;
  
  int32_t receive_buffer_size;
  
  bool keep_alive;
  
  bool no_delay;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DirectSocketOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DirectSocketOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DirectSocketOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DirectSocketOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
DirectSocketOptionsPtr DirectSocketOptions::Clone() const {
  return New(
      mojo::Clone(local_hostname),
      mojo::Clone(local_port),
      mojo::Clone(remote_hostname),
      mojo::Clone(remote_port),
      mojo::Clone(send_buffer_size),
      mojo::Clone(receive_buffer_size),
      mojo::Clone(keep_alive),
      mojo::Clone(no_delay)
  );
}

template <typename T, DirectSocketOptions::EnableIfSame<T>*>
bool DirectSocketOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->local_hostname, other_struct.local_hostname))
    return false;
  if (!mojo::Equals(this->local_port, other_struct.local_port))
    return false;
  if (!mojo::Equals(this->remote_hostname, other_struct.remote_hostname))
    return false;
  if (!mojo::Equals(this->remote_port, other_struct.remote_port))
    return false;
  if (!mojo::Equals(this->send_buffer_size, other_struct.send_buffer_size))
    return false;
  if (!mojo::Equals(this->receive_buffer_size, other_struct.receive_buffer_size))
    return false;
  if (!mojo::Equals(this->keep_alive, other_struct.keep_alive))
    return false;
  if (!mojo::Equals(this->no_delay, other_struct.no_delay))
    return false;
  return true;
}

template <typename T, DirectSocketOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.local_hostname, rhs.local_hostname))
    return true;
  if (std::less<>{}(rhs.local_hostname, lhs.local_hostname))
    return false;
  if (std::less<>{}(lhs.local_port, rhs.local_port))
    return true;
  if (std::less<>{}(rhs.local_port, lhs.local_port))
    return false;
  if (std::less<>{}(lhs.remote_hostname, rhs.remote_hostname))
    return true;
  if (std::less<>{}(rhs.remote_hostname, lhs.remote_hostname))
    return false;
  if (std::less<>{}(lhs.remote_port, rhs.remote_port))
    return true;
  if (std::less<>{}(rhs.remote_port, lhs.remote_port))
    return false;
  if (std::less<>{}(lhs.send_buffer_size, rhs.send_buffer_size))
    return true;
  if (std::less<>{}(rhs.send_buffer_size, lhs.send_buffer_size))
    return false;
  if (std::less<>{}(lhs.receive_buffer_size, rhs.receive_buffer_size))
    return true;
  if (std::less<>{}(rhs.receive_buffer_size, lhs.receive_buffer_size))
    return false;
  if (std::less<>{}(lhs.keep_alive, rhs.keep_alive))
    return true;
  if (std::less<>{}(rhs.keep_alive, lhs.keep_alive))
    return false;
  if (std::less<>{}(lhs.no_delay, rhs.no_delay))
    return true;
  if (std::less<>{}(rhs.no_delay, lhs.no_delay))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::DirectSocketOptions::DataView,
                                         ::blink::mojom::blink::DirectSocketOptionsPtr> {
  static bool IsNull(const ::blink::mojom::blink::DirectSocketOptionsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::DirectSocketOptionsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::DirectSocketOptions::local_hostname)& local_hostname(
      const ::blink::mojom::blink::DirectSocketOptionsPtr& input) {
    return input->local_hostname;
  }

  static decltype(::blink::mojom::blink::DirectSocketOptions::local_port) local_port(
      const ::blink::mojom::blink::DirectSocketOptionsPtr& input) {
    return input->local_port;
  }

  static const decltype(::blink::mojom::blink::DirectSocketOptions::remote_hostname)& remote_hostname(
      const ::blink::mojom::blink::DirectSocketOptionsPtr& input) {
    return input->remote_hostname;
  }

  static decltype(::blink::mojom::blink::DirectSocketOptions::remote_port) remote_port(
      const ::blink::mojom::blink::DirectSocketOptionsPtr& input) {
    return input->remote_port;
  }

  static decltype(::blink::mojom::blink::DirectSocketOptions::send_buffer_size) send_buffer_size(
      const ::blink::mojom::blink::DirectSocketOptionsPtr& input) {
    return input->send_buffer_size;
  }

  static decltype(::blink::mojom::blink::DirectSocketOptions::receive_buffer_size) receive_buffer_size(
      const ::blink::mojom::blink::DirectSocketOptionsPtr& input) {
    return input->receive_buffer_size;
  }

  static decltype(::blink::mojom::blink::DirectSocketOptions::keep_alive) keep_alive(
      const ::blink::mojom::blink::DirectSocketOptionsPtr& input) {
    return input->keep_alive;
  }

  static decltype(::blink::mojom::blink::DirectSocketOptions::no_delay) no_delay(
      const ::blink::mojom::blink::DirectSocketOptionsPtr& input) {
    return input->no_delay;
  }

  static bool Read(::blink::mojom::blink::DirectSocketOptions::DataView input, ::blink::mojom::blink::DirectSocketOptionsPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_DIRECT_SOCKETS_DIRECT_SOCKETS_MOJOM_BLINK_H_