// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/spanner/v1/transaction.proto

package spannerpb

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// `IsolationLevel` is used when setting `isolation_level` for a transaction.
type TransactionOptions_IsolationLevel int32

const (
	// Default value.
	//
	// If the value is not specified, the `SERIALIZABLE` isolation level is
	// used.
	TransactionOptions_ISOLATION_LEVEL_UNSPECIFIED TransactionOptions_IsolationLevel = 0
	// All transactions appear as if they executed in a serial order, even if
	// some of the reads, writes, and other operations of distinct transactions
	// actually occurred in parallel. Spanner assigns commit timestamps that
	// reflect the order of committed transactions to implement this property.
	// Spanner offers a stronger guarantee than serializability called external
	// consistency. For more information, see
	// [TrueTime and external
	// consistency](https://cloud.google.com/spanner/docs/true-time-external-consistency#serializability).
	TransactionOptions_SERIALIZABLE TransactionOptions_IsolationLevel = 1
	// All reads performed during the transaction observe a consistent snapshot
	// of the database, and the transaction is only successfully committed in
	// the absence of conflicts between its updates and any concurrent updates
	// that have occurred since that snapshot. Consequently, in contrast to
	// `SERIALIZABLE` transactions, only write-write conflicts are detected in
	// snapshot transactions.
	//
	// This isolation level does not support Read-only and Partitioned DML
	// transactions.
	//
	// When `REPEATABLE_READ` is specified on a read-write transaction, the
	// locking semantics default to `OPTIMISTIC`.
	TransactionOptions_REPEATABLE_READ TransactionOptions_IsolationLevel = 2
)

// Enum value maps for TransactionOptions_IsolationLevel.
var (
	TransactionOptions_IsolationLevel_name = map[int32]string{
		0: "ISOLATION_LEVEL_UNSPECIFIED",
		1: "SERIALIZABLE",
		2: "REPEATABLE_READ",
	}
	TransactionOptions_IsolationLevel_value = map[string]int32{
		"ISOLATION_LEVEL_UNSPECIFIED": 0,
		"SERIALIZABLE":                1,
		"REPEATABLE_READ":             2,
	}
)

func (x TransactionOptions_IsolationLevel) Enum() *TransactionOptions_IsolationLevel {
	p := new(TransactionOptions_IsolationLevel)
	*p = x
	return p
}

func (x TransactionOptions_IsolationLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TransactionOptions_IsolationLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_spanner_v1_transaction_proto_enumTypes[0].Descriptor()
}

func (TransactionOptions_IsolationLevel) Type() protoreflect.EnumType {
	return &file_google_spanner_v1_transaction_proto_enumTypes[0]
}

func (x TransactionOptions_IsolationLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TransactionOptions_IsolationLevel.Descriptor instead.
func (TransactionOptions_IsolationLevel) EnumDescriptor() ([]byte, []int) {
	return file_google_spanner_v1_transaction_proto_rawDescGZIP(), []int{0, 0}
}

// `ReadLockMode` is used to set the read lock mode for read-write
// transactions.
type TransactionOptions_ReadWrite_ReadLockMode int32

const (
	// Default value.
	//
	//   - If isolation level is
	//     [REPEATABLE_READ][google.spanner.v1.TransactionOptions.IsolationLevel.REPEATABLE_READ],
	//     then it is an error to specify `read_lock_mode`. Locking semantics
	//     default to `OPTIMISTIC`. No validation checks are done for reads,
	//     except to validate that the data that was served at the snapshot time
	//     is unchanged at commit time in the following cases:
	//     1. reads done as part of queries that use `SELECT FOR UPDATE`
	//     2. reads done as part of statements with a `LOCK_SCANNED_RANGES`
	//     hint
	//     3. reads done as part of DML statements
	//   - At all other isolation levels, if `read_lock_mode` is the default
	//     value, then pessimistic read locks are used.
	TransactionOptions_ReadWrite_READ_LOCK_MODE_UNSPECIFIED TransactionOptions_ReadWrite_ReadLockMode = 0
	// Pessimistic lock mode.
	//
	// Read locks are acquired immediately on read.
	// Semantics described only applies to
	// [SERIALIZABLE][google.spanner.v1.TransactionOptions.IsolationLevel.SERIALIZABLE]
	// isolation.
	TransactionOptions_ReadWrite_PESSIMISTIC TransactionOptions_ReadWrite_ReadLockMode = 1
	// Optimistic lock mode.
	//
	// Locks for reads within the transaction are not acquired on read.
	// Instead the locks are acquired on a commit to validate that
	// read/queried data has not changed since the transaction started.
	// Semantics described only applies to
	// [SERIALIZABLE][google.spanner.v1.TransactionOptions.IsolationLevel.SERIALIZABLE]
	// isolation.
	TransactionOptions_ReadWrite_OPTIMISTIC TransactionOptions_ReadWrite_ReadLockMode = 2
)

// Enum value maps for TransactionOptions_ReadWrite_ReadLockMode.
var (
	TransactionOptions_ReadWrite_ReadLockMode_name = map[int32]string{
		0: "READ_LOCK_MODE_UNSPECIFIED",
		1: "PESSIMISTIC",
		2: "OPTIMISTIC",
	}
	TransactionOptions_ReadWrite_ReadLockMode_value = map[string]int32{
		"READ_LOCK_MODE_UNSPECIFIED": 0,
		"PESSIMISTIC":                1,
		"OPTIMISTIC":                 2,
	}
)

func (x TransactionOptions_ReadWrite_ReadLockMode) Enum() *TransactionOptions_ReadWrite_ReadLockMode {
	p := new(TransactionOptions_ReadWrite_ReadLockMode)
	*p = x
	return p
}

func (x TransactionOptions_ReadWrite_ReadLockMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TransactionOptions_ReadWrite_ReadLockMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_spanner_v1_transaction_proto_enumTypes[1].Descriptor()
}

func (TransactionOptions_ReadWrite_ReadLockMode) Type() protoreflect.EnumType {
	return &file_google_spanner_v1_transaction_proto_enumTypes[1]
}

func (x TransactionOptions_ReadWrite_ReadLockMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TransactionOptions_ReadWrite_ReadLockMode.Descriptor instead.
func (TransactionOptions_ReadWrite_ReadLockMode) EnumDescriptor() ([]byte, []int) {
	return file_google_spanner_v1_transaction_proto_rawDescGZIP(), []int{0, 0, 0}
}

// Options to use for transactions.
type TransactionOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The type of transaction.
	//
	// Types that are assignable to Mode:
	//
	//	*TransactionOptions_ReadWrite_
	//	*TransactionOptions_PartitionedDml_
	//	*TransactionOptions_ReadOnly_
	Mode isTransactionOptions_Mode `protobuf_oneof:"mode"`
	// When `exclude_txn_from_change_streams` is set to `true`, it prevents read
	// or write transactions from being tracked in change streams.
	//
	// * If the DDL option `allow_txn_exclusion` is set to `true`, then the
	// updates
	//
	//	made within this transaction aren't recorded in the change stream.
	//
	//   - If you don't set the DDL option `allow_txn_exclusion` or if it's
	//     set to `false`, then the updates made within this transaction are
	//     recorded in the change stream.
	//
	// When `exclude_txn_from_change_streams` is set to `false` or not set,
	// modifications from this transaction are recorded in all change streams
	// that are tracking columns modified by these transactions.
	//
	// The `exclude_txn_from_change_streams` option can only be specified
	// for read-write or partitioned DML transactions, otherwise the API returns
	// an `INVALID_ARGUMENT` error.
	ExcludeTxnFromChangeStreams bool `protobuf:"varint,5,opt,name=exclude_txn_from_change_streams,json=excludeTxnFromChangeStreams,proto3" json:"exclude_txn_from_change_streams,omitempty"`
	// Isolation level for the transaction.
	IsolationLevel TransactionOptions_IsolationLevel `protobuf:"varint,6,opt,name=isolation_level,json=isolationLevel,proto3,enum=google.spanner.v1.TransactionOptions_IsolationLevel" json:"isolation_level,omitempty"`
}

func (x *TransactionOptions) Reset() {
	*x = TransactionOptions{}
	mi := &file_google_spanner_v1_transaction_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TransactionOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransactionOptions) ProtoMessage() {}

func (x *TransactionOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_transaction_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransactionOptions.ProtoReflect.Descriptor instead.
func (*TransactionOptions) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_transaction_proto_rawDescGZIP(), []int{0}
}

func (m *TransactionOptions) GetMode() isTransactionOptions_Mode {
	if m != nil {
		return m.Mode
	}
	return nil
}

func (x *TransactionOptions) GetReadWrite() *TransactionOptions_ReadWrite {
	if x, ok := x.GetMode().(*TransactionOptions_ReadWrite_); ok {
		return x.ReadWrite
	}
	return nil
}

func (x *TransactionOptions) GetPartitionedDml() *TransactionOptions_PartitionedDml {
	if x, ok := x.GetMode().(*TransactionOptions_PartitionedDml_); ok {
		return x.PartitionedDml
	}
	return nil
}

func (x *TransactionOptions) GetReadOnly() *TransactionOptions_ReadOnly {
	if x, ok := x.GetMode().(*TransactionOptions_ReadOnly_); ok {
		return x.ReadOnly
	}
	return nil
}

func (x *TransactionOptions) GetExcludeTxnFromChangeStreams() bool {
	if x != nil {
		return x.ExcludeTxnFromChangeStreams
	}
	return false
}

func (x *TransactionOptions) GetIsolationLevel() TransactionOptions_IsolationLevel {
	if x != nil {
		return x.IsolationLevel
	}
	return TransactionOptions_ISOLATION_LEVEL_UNSPECIFIED
}

type isTransactionOptions_Mode interface {
	isTransactionOptions_Mode()
}

type TransactionOptions_ReadWrite_ struct {
	// Transaction may write.
	//
	// Authorization to begin a read-write transaction requires
	// `spanner.databases.beginOrRollbackReadWriteTransaction` permission
	// on the `session` resource.
	ReadWrite *TransactionOptions_ReadWrite `protobuf:"bytes,1,opt,name=read_write,json=readWrite,proto3,oneof"`
}

type TransactionOptions_PartitionedDml_ struct {
	// Partitioned DML transaction.
	//
	// Authorization to begin a Partitioned DML transaction requires
	// `spanner.databases.beginPartitionedDmlTransaction` permission
	// on the `session` resource.
	PartitionedDml *TransactionOptions_PartitionedDml `protobuf:"bytes,3,opt,name=partitioned_dml,json=partitionedDml,proto3,oneof"`
}

type TransactionOptions_ReadOnly_ struct {
	// Transaction does not write.
	//
	// Authorization to begin a read-only transaction requires
	// `spanner.databases.beginReadOnlyTransaction` permission
	// on the `session` resource.
	ReadOnly *TransactionOptions_ReadOnly `protobuf:"bytes,2,opt,name=read_only,json=readOnly,proto3,oneof"`
}

func (*TransactionOptions_ReadWrite_) isTransactionOptions_Mode() {}

func (*TransactionOptions_PartitionedDml_) isTransactionOptions_Mode() {}

func (*TransactionOptions_ReadOnly_) isTransactionOptions_Mode() {}

// A transaction.
type Transaction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// `id` may be used to identify the transaction in subsequent
	// [Read][google.spanner.v1.Spanner.Read],
	// [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql],
	// [Commit][google.spanner.v1.Spanner.Commit], or
	// [Rollback][google.spanner.v1.Spanner.Rollback] calls.
	//
	// Single-use read-only transactions do not have IDs, because
	// single-use transactions do not support multiple requests.
	Id []byte `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// For snapshot read-only transactions, the read timestamp chosen
	// for the transaction. Not returned by default: see
	// [TransactionOptions.ReadOnly.return_read_timestamp][google.spanner.v1.TransactionOptions.ReadOnly.return_read_timestamp].
	//
	// A timestamp in RFC3339 UTC \"Zulu\" format, accurate to nanoseconds.
	// Example: `"2014-10-02T15:01:23.045123456Z"`.
	ReadTimestamp *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=read_timestamp,json=readTimestamp,proto3" json:"read_timestamp,omitempty"`
	// A precommit token is included in the response of a BeginTransaction
	// request if the read-write transaction is on a multiplexed session and
	// a mutation_key was specified in the
	// [BeginTransaction][google.spanner.v1.BeginTransactionRequest].
	// The precommit token with the highest sequence number from this transaction
	// attempt should be passed to the [Commit][google.spanner.v1.Spanner.Commit]
	// request for this transaction.
	PrecommitToken *MultiplexedSessionPrecommitToken `protobuf:"bytes,3,opt,name=precommit_token,json=precommitToken,proto3" json:"precommit_token,omitempty"`
}

func (x *Transaction) Reset() {
	*x = Transaction{}
	mi := &file_google_spanner_v1_transaction_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Transaction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Transaction) ProtoMessage() {}

func (x *Transaction) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_transaction_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Transaction.ProtoReflect.Descriptor instead.
func (*Transaction) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_transaction_proto_rawDescGZIP(), []int{1}
}

func (x *Transaction) GetId() []byte {
	if x != nil {
		return x.Id
	}
	return nil
}

func (x *Transaction) GetReadTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.ReadTimestamp
	}
	return nil
}

func (x *Transaction) GetPrecommitToken() *MultiplexedSessionPrecommitToken {
	if x != nil {
		return x.PrecommitToken
	}
	return nil
}

// This message is used to select the transaction in which a
// [Read][google.spanner.v1.Spanner.Read] or
// [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql] call runs.
//
// See [TransactionOptions][google.spanner.v1.TransactionOptions] for more
// information about transactions.
type TransactionSelector struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If no fields are set, the default is a single use transaction
	// with strong concurrency.
	//
	// Types that are assignable to Selector:
	//
	//	*TransactionSelector_SingleUse
	//	*TransactionSelector_Id
	//	*TransactionSelector_Begin
	Selector isTransactionSelector_Selector `protobuf_oneof:"selector"`
}

func (x *TransactionSelector) Reset() {
	*x = TransactionSelector{}
	mi := &file_google_spanner_v1_transaction_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TransactionSelector) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransactionSelector) ProtoMessage() {}

func (x *TransactionSelector) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_transaction_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransactionSelector.ProtoReflect.Descriptor instead.
func (*TransactionSelector) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_transaction_proto_rawDescGZIP(), []int{2}
}

func (m *TransactionSelector) GetSelector() isTransactionSelector_Selector {
	if m != nil {
		return m.Selector
	}
	return nil
}

func (x *TransactionSelector) GetSingleUse() *TransactionOptions {
	if x, ok := x.GetSelector().(*TransactionSelector_SingleUse); ok {
		return x.SingleUse
	}
	return nil
}

func (x *TransactionSelector) GetId() []byte {
	if x, ok := x.GetSelector().(*TransactionSelector_Id); ok {
		return x.Id
	}
	return nil
}

func (x *TransactionSelector) GetBegin() *TransactionOptions {
	if x, ok := x.GetSelector().(*TransactionSelector_Begin); ok {
		return x.Begin
	}
	return nil
}

type isTransactionSelector_Selector interface {
	isTransactionSelector_Selector()
}

type TransactionSelector_SingleUse struct {
	// Execute the read or SQL query in a temporary transaction.
	// This is the most efficient way to execute a transaction that
	// consists of a single SQL query.
	SingleUse *TransactionOptions `protobuf:"bytes,1,opt,name=single_use,json=singleUse,proto3,oneof"`
}

type TransactionSelector_Id struct {
	// Execute the read or SQL query in a previously-started transaction.
	Id []byte `protobuf:"bytes,2,opt,name=id,proto3,oneof"`
}

type TransactionSelector_Begin struct {
	// Begin a new transaction and execute this read or SQL query in
	// it. The transaction ID of the new transaction is returned in
	// [ResultSetMetadata.transaction][google.spanner.v1.ResultSetMetadata.transaction],
	// which is a [Transaction][google.spanner.v1.Transaction].
	Begin *TransactionOptions `protobuf:"bytes,3,opt,name=begin,proto3,oneof"`
}

func (*TransactionSelector_SingleUse) isTransactionSelector_Selector() {}

func (*TransactionSelector_Id) isTransactionSelector_Selector() {}

func (*TransactionSelector_Begin) isTransactionSelector_Selector() {}

// When a read-write transaction is executed on a multiplexed session,
// this precommit token is sent back to the client
// as a part of the [Transaction][google.spanner.v1.Transaction] message in the
// [BeginTransaction][google.spanner.v1.BeginTransactionRequest] response and
// also as a part of the [ResultSet][google.spanner.v1.ResultSet] and
// [PartialResultSet][google.spanner.v1.PartialResultSet] responses.
type MultiplexedSessionPrecommitToken struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Opaque precommit token.
	PrecommitToken []byte `protobuf:"bytes,1,opt,name=precommit_token,json=precommitToken,proto3" json:"precommit_token,omitempty"`
	// An incrementing seq number is generated on every precommit token
	// that is returned. Clients should remember the precommit token with the
	// highest sequence number from the current transaction attempt.
	SeqNum int32 `protobuf:"varint,2,opt,name=seq_num,json=seqNum,proto3" json:"seq_num,omitempty"`
}

func (x *MultiplexedSessionPrecommitToken) Reset() {
	*x = MultiplexedSessionPrecommitToken{}
	mi := &file_google_spanner_v1_transaction_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MultiplexedSessionPrecommitToken) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MultiplexedSessionPrecommitToken) ProtoMessage() {}

func (x *MultiplexedSessionPrecommitToken) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_transaction_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MultiplexedSessionPrecommitToken.ProtoReflect.Descriptor instead.
func (*MultiplexedSessionPrecommitToken) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_transaction_proto_rawDescGZIP(), []int{3}
}

func (x *MultiplexedSessionPrecommitToken) GetPrecommitToken() []byte {
	if x != nil {
		return x.PrecommitToken
	}
	return nil
}

func (x *MultiplexedSessionPrecommitToken) GetSeqNum() int32 {
	if x != nil {
		return x.SeqNum
	}
	return 0
}

// Message type to initiate a read-write transaction. Currently this
// transaction type has no options.
type TransactionOptions_ReadWrite struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Read lock mode for the transaction.
	ReadLockMode TransactionOptions_ReadWrite_ReadLockMode `protobuf:"varint,1,opt,name=read_lock_mode,json=readLockMode,proto3,enum=google.spanner.v1.TransactionOptions_ReadWrite_ReadLockMode" json:"read_lock_mode,omitempty"`
	// Optional. Clients should pass the transaction ID of the previous
	// transaction attempt that was aborted if this transaction is being
	// executed on a multiplexed session.
	MultiplexedSessionPreviousTransactionId []byte `protobuf:"bytes,2,opt,name=multiplexed_session_previous_transaction_id,json=multiplexedSessionPreviousTransactionId,proto3" json:"multiplexed_session_previous_transaction_id,omitempty"`
}

func (x *TransactionOptions_ReadWrite) Reset() {
	*x = TransactionOptions_ReadWrite{}
	mi := &file_google_spanner_v1_transaction_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TransactionOptions_ReadWrite) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransactionOptions_ReadWrite) ProtoMessage() {}

func (x *TransactionOptions_ReadWrite) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_transaction_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransactionOptions_ReadWrite.ProtoReflect.Descriptor instead.
func (*TransactionOptions_ReadWrite) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_transaction_proto_rawDescGZIP(), []int{0, 0}
}

func (x *TransactionOptions_ReadWrite) GetReadLockMode() TransactionOptions_ReadWrite_ReadLockMode {
	if x != nil {
		return x.ReadLockMode
	}
	return TransactionOptions_ReadWrite_READ_LOCK_MODE_UNSPECIFIED
}

func (x *TransactionOptions_ReadWrite) GetMultiplexedSessionPreviousTransactionId() []byte {
	if x != nil {
		return x.MultiplexedSessionPreviousTransactionId
	}
	return nil
}

// Message type to initiate a Partitioned DML transaction.
type TransactionOptions_PartitionedDml struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *TransactionOptions_PartitionedDml) Reset() {
	*x = TransactionOptions_PartitionedDml{}
	mi := &file_google_spanner_v1_transaction_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TransactionOptions_PartitionedDml) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransactionOptions_PartitionedDml) ProtoMessage() {}

func (x *TransactionOptions_PartitionedDml) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_transaction_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransactionOptions_PartitionedDml.ProtoReflect.Descriptor instead.
func (*TransactionOptions_PartitionedDml) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_transaction_proto_rawDescGZIP(), []int{0, 1}
}

// Message type to initiate a read-only transaction.
type TransactionOptions_ReadOnly struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// How to choose the timestamp for the read-only transaction.
	//
	// Types that are assignable to TimestampBound:
	//
	//	*TransactionOptions_ReadOnly_Strong
	//	*TransactionOptions_ReadOnly_MinReadTimestamp
	//	*TransactionOptions_ReadOnly_MaxStaleness
	//	*TransactionOptions_ReadOnly_ReadTimestamp
	//	*TransactionOptions_ReadOnly_ExactStaleness
	TimestampBound isTransactionOptions_ReadOnly_TimestampBound `protobuf_oneof:"timestamp_bound"`
	// If true, the Cloud Spanner-selected read timestamp is included in
	// the [Transaction][google.spanner.v1.Transaction] message that describes
	// the transaction.
	ReturnReadTimestamp bool `protobuf:"varint,6,opt,name=return_read_timestamp,json=returnReadTimestamp,proto3" json:"return_read_timestamp,omitempty"`
}

func (x *TransactionOptions_ReadOnly) Reset() {
	*x = TransactionOptions_ReadOnly{}
	mi := &file_google_spanner_v1_transaction_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TransactionOptions_ReadOnly) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransactionOptions_ReadOnly) ProtoMessage() {}

func (x *TransactionOptions_ReadOnly) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_transaction_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransactionOptions_ReadOnly.ProtoReflect.Descriptor instead.
func (*TransactionOptions_ReadOnly) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_transaction_proto_rawDescGZIP(), []int{0, 2}
}

func (m *TransactionOptions_ReadOnly) GetTimestampBound() isTransactionOptions_ReadOnly_TimestampBound {
	if m != nil {
		return m.TimestampBound
	}
	return nil
}

func (x *TransactionOptions_ReadOnly) GetStrong() bool {
	if x, ok := x.GetTimestampBound().(*TransactionOptions_ReadOnly_Strong); ok {
		return x.Strong
	}
	return false
}

func (x *TransactionOptions_ReadOnly) GetMinReadTimestamp() *timestamppb.Timestamp {
	if x, ok := x.GetTimestampBound().(*TransactionOptions_ReadOnly_MinReadTimestamp); ok {
		return x.MinReadTimestamp
	}
	return nil
}

func (x *TransactionOptions_ReadOnly) GetMaxStaleness() *durationpb.Duration {
	if x, ok := x.GetTimestampBound().(*TransactionOptions_ReadOnly_MaxStaleness); ok {
		return x.MaxStaleness
	}
	return nil
}

func (x *TransactionOptions_ReadOnly) GetReadTimestamp() *timestamppb.Timestamp {
	if x, ok := x.GetTimestampBound().(*TransactionOptions_ReadOnly_ReadTimestamp); ok {
		return x.ReadTimestamp
	}
	return nil
}

func (x *TransactionOptions_ReadOnly) GetExactStaleness() *durationpb.Duration {
	if x, ok := x.GetTimestampBound().(*TransactionOptions_ReadOnly_ExactStaleness); ok {
		return x.ExactStaleness
	}
	return nil
}

func (x *TransactionOptions_ReadOnly) GetReturnReadTimestamp() bool {
	if x != nil {
		return x.ReturnReadTimestamp
	}
	return false
}

type isTransactionOptions_ReadOnly_TimestampBound interface {
	isTransactionOptions_ReadOnly_TimestampBound()
}

type TransactionOptions_ReadOnly_Strong struct {
	// Read at a timestamp where all previously committed transactions
	// are visible.
	Strong bool `protobuf:"varint,1,opt,name=strong,proto3,oneof"`
}

type TransactionOptions_ReadOnly_MinReadTimestamp struct {
	// Executes all reads at a timestamp >= `min_read_timestamp`.
	//
	// This is useful for requesting fresher data than some previous
	// read, or data that is fresh enough to observe the effects of some
	// previously committed transaction whose timestamp is known.
	//
	// Note that this option can only be used in single-use transactions.
	//
	// A timestamp in RFC3339 UTC \"Zulu\" format, accurate to nanoseconds.
	// Example: `"2014-10-02T15:01:23.045123456Z"`.
	MinReadTimestamp *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=min_read_timestamp,json=minReadTimestamp,proto3,oneof"`
}

type TransactionOptions_ReadOnly_MaxStaleness struct {
	// Read data at a timestamp >= `NOW - max_staleness`
	// seconds. Guarantees that all writes that have committed more
	// than the specified number of seconds ago are visible. Because
	// Cloud Spanner chooses the exact timestamp, this mode works even if
	// the client's local clock is substantially skewed from Cloud Spanner
	// commit timestamps.
	//
	// Useful for reading the freshest data available at a nearby
	// replica, while bounding the possible staleness if the local
	// replica has fallen behind.
	//
	// Note that this option can only be used in single-use
	// transactions.
	MaxStaleness *durationpb.Duration `protobuf:"bytes,3,opt,name=max_staleness,json=maxStaleness,proto3,oneof"`
}

type TransactionOptions_ReadOnly_ReadTimestamp struct {
	// Executes all reads at the given timestamp. Unlike other modes,
	// reads at a specific timestamp are repeatable; the same read at
	// the same timestamp always returns the same data. If the
	// timestamp is in the future, the read is blocked until the
	// specified timestamp, modulo the read's deadline.
	//
	// Useful for large scale consistent reads such as mapreduces, or
	// for coordinating many reads against a consistent snapshot of the
	// data.
	//
	// A timestamp in RFC3339 UTC \"Zulu\" format, accurate to nanoseconds.
	// Example: `"2014-10-02T15:01:23.045123456Z"`.
	ReadTimestamp *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=read_timestamp,json=readTimestamp,proto3,oneof"`
}

type TransactionOptions_ReadOnly_ExactStaleness struct {
	// Executes all reads at a timestamp that is `exact_staleness`
	// old. The timestamp is chosen soon after the read is started.
	//
	// Guarantees that all writes that have committed more than the
	// specified number of seconds ago are visible. Because Cloud Spanner
	// chooses the exact timestamp, this mode works even if the client's
	// local clock is substantially skewed from Cloud Spanner commit
	// timestamps.
	//
	// Useful for reading at nearby replicas without the distributed
	// timestamp negotiation overhead of `max_staleness`.
	ExactStaleness *durationpb.Duration `protobuf:"bytes,5,opt,name=exact_staleness,json=exactStaleness,proto3,oneof"`
}

func (*TransactionOptions_ReadOnly_Strong) isTransactionOptions_ReadOnly_TimestampBound() {}

func (*TransactionOptions_ReadOnly_MinReadTimestamp) isTransactionOptions_ReadOnly_TimestampBound() {}

func (*TransactionOptions_ReadOnly_MaxStaleness) isTransactionOptions_ReadOnly_TimestampBound() {}

func (*TransactionOptions_ReadOnly_ReadTimestamp) isTransactionOptions_ReadOnly_TimestampBound() {}

func (*TransactionOptions_ReadOnly_ExactStaleness) isTransactionOptions_ReadOnly_TimestampBound() {}

var File_google_spanner_v1_transaction_proto protoreflect.FileDescriptor

var file_google_spanner_v1_transaction_proto_rawDesc = []byte{
	0x0a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x2f, 0x76, 0x31, 0x2f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x11, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xdc, 0x09, 0x0a, 0x12, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x50, 0x0a, 0x0a, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x77, 0x72, 0x69, 0x74, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x52, 0x65, 0x61,
	0x64, 0x57, 0x72, 0x69, 0x74, 0x65, 0x48, 0x00, 0x52, 0x09, 0x72, 0x65, 0x61, 0x64, 0x57, 0x72,
	0x69, 0x74, 0x65, 0x12, 0x5f, 0x0a, 0x0f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x65, 0x64, 0x5f, 0x64, 0x6d, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x65, 0x64, 0x44,
	0x6d, 0x6c, 0x48, 0x00, 0x52, 0x0e, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x65,
	0x64, 0x44, 0x6d, 0x6c, 0x12, 0x4d, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6f, 0x6e, 0x6c,
	0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x52,
	0x65, 0x61, 0x64, 0x4f, 0x6e, 0x6c, 0x79, 0x48, 0x00, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x4f,
	0x6e, 0x6c, 0x79, 0x12, 0x44, 0x0a, 0x1f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x74,
	0x78, 0x6e, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1b, 0x65, 0x78,
	0x63, 0x6c, 0x75, 0x64, 0x65, 0x54, 0x78, 0x6e, 0x46, 0x72, 0x6f, 0x6d, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x12, 0x5d, 0x0a, 0x0f, 0x69, 0x73, 0x6f,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x49, 0x73, 0x6f, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x0e, 0x69, 0x73, 0x6f, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x1a, 0xa3, 0x02, 0x0a, 0x09, 0x52, 0x65, 0x61,
	0x64, 0x57, 0x72, 0x69, 0x74, 0x65, 0x12, 0x62, 0x0a, 0x0e, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6c,
	0x6f, 0x63, 0x6b, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x57, 0x72, 0x69, 0x74, 0x65, 0x2e,
	0x52, 0x65, 0x61, 0x64, 0x4c, 0x6f, 0x63, 0x6b, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x0c, 0x72, 0x65,
	0x61, 0x64, 0x4c, 0x6f, 0x63, 0x6b, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x61, 0x0a, 0x2b, 0x6d, 0x75,
	0x6c, 0x74, 0x69, 0x70, 0x6c, 0x65, 0x78, 0x65, 0x64, 0x5f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x5f, 0x70, 0x72, 0x65, 0x76, 0x69, 0x6f, 0x75, 0x73, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x27, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x70, 0x6c, 0x65, 0x78, 0x65,
	0x64, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x65, 0x76, 0x69, 0x6f, 0x75, 0x73,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0x4f, 0x0a,
	0x0c, 0x52, 0x65, 0x61, 0x64, 0x4c, 0x6f, 0x63, 0x6b, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x1e, 0x0a,
	0x1a, 0x52, 0x45, 0x41, 0x44, 0x5f, 0x4c, 0x4f, 0x43, 0x4b, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a,
	0x0b, 0x50, 0x45, 0x53, 0x53, 0x49, 0x4d, 0x49, 0x53, 0x54, 0x49, 0x43, 0x10, 0x01, 0x12, 0x0e,
	0x0a, 0x0a, 0x4f, 0x50, 0x54, 0x49, 0x4d, 0x49, 0x53, 0x54, 0x49, 0x43, 0x10, 0x02, 0x1a, 0x10,
	0x0a, 0x0e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x65, 0x64, 0x44, 0x6d, 0x6c,
	0x1a, 0x84, 0x03, 0x0a, 0x08, 0x52, 0x65, 0x61, 0x64, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x18, 0x0a,
	0x06, 0x73, 0x74, 0x72, 0x6f, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52,
	0x06, 0x73, 0x74, 0x72, 0x6f, 0x6e, 0x67, 0x12, 0x4a, 0x0a, 0x12, 0x6d, 0x69, 0x6e, 0x5f, 0x72,
	0x65, 0x61, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x48,
	0x00, 0x52, 0x10, 0x6d, 0x69, 0x6e, 0x52, 0x65, 0x61, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x12, 0x40, 0x0a, 0x0d, 0x6d, 0x61, 0x78, 0x5f, 0x73, 0x74, 0x61, 0x6c, 0x65,
	0x6e, 0x65, 0x73, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0c, 0x6d, 0x61, 0x78, 0x53, 0x74, 0x61, 0x6c,
	0x65, 0x6e, 0x65, 0x73, 0x73, 0x12, 0x43, 0x0a, 0x0e, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x48, 0x00, 0x52, 0x0d, 0x72, 0x65, 0x61,
	0x64, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x44, 0x0a, 0x0f, 0x65, 0x78,
	0x61, 0x63, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00,
	0x52, 0x0e, 0x65, 0x78, 0x61, 0x63, 0x74, 0x53, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x65, 0x73, 0x73,
	0x12, 0x32, 0x0a, 0x15, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x13, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x52, 0x65, 0x61, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x11, 0x0a, 0x0f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x22, 0x58, 0x0a, 0x0e, 0x49, 0x73, 0x6f, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x1f, 0x0a, 0x1b, 0x49, 0x53, 0x4f,
	0x4c, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x53, 0x45,
	0x52, 0x49, 0x41, 0x4c, 0x49, 0x5a, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f,
	0x52, 0x45, 0x50, 0x45, 0x41, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x52, 0x45, 0x41, 0x44, 0x10,
	0x02, 0x42, 0x06, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x22, 0xbe, 0x01, 0x0a, 0x0b, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x02, 0x69, 0x64, 0x12, 0x41, 0x0a, 0x0e, 0x72, 0x65, 0x61,
	0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0d, 0x72,
	0x65, 0x61, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x5c, 0x0a, 0x0f,
	0x70, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x70,
	0x6c, 0x65, 0x78, 0x65, 0x64, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x65, 0x63,
	0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x0e, 0x70, 0x72, 0x65, 0x63,
	0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xba, 0x01, 0x0a, 0x13, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x12, 0x46, 0x0a, 0x0a, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x5f, 0x75, 0x73, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52,
	0x09, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x55, 0x73, 0x65, 0x12, 0x10, 0x0a, 0x02, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x02, 0x69, 0x64, 0x12, 0x3d, 0x0a, 0x05,
	0x62, 0x65, 0x67, 0x69, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x48, 0x00, 0x52, 0x05, 0x62, 0x65, 0x67, 0x69, 0x6e, 0x42, 0x0a, 0x0a, 0x08, 0x73,
	0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x22, 0x64, 0x0a, 0x20, 0x4d, 0x75, 0x6c, 0x74, 0x69,
	0x70, 0x6c, 0x65, 0x78, 0x65, 0x64, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x65,
	0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x27, 0x0a, 0x0f, 0x70,
	0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x0e, 0x70, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x17, 0x0a, 0x07, 0x73, 0x65, 0x71, 0x5f, 0x6e, 0x75, 0x6d, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x73, 0x65, 0x71, 0x4e, 0x75, 0x6d, 0x42, 0xb3, 0x01,
	0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61,
	0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x42, 0x10, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x35, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f,
	0x2f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x73,
	0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x70, 0x62, 0x3b, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x70, 0x62, 0xaa, 0x02, 0x17, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x53, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x17, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x53, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a,
	0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x53, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x3a,
	0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_spanner_v1_transaction_proto_rawDescOnce sync.Once
	file_google_spanner_v1_transaction_proto_rawDescData = file_google_spanner_v1_transaction_proto_rawDesc
)

func file_google_spanner_v1_transaction_proto_rawDescGZIP() []byte {
	file_google_spanner_v1_transaction_proto_rawDescOnce.Do(func() {
		file_google_spanner_v1_transaction_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_spanner_v1_transaction_proto_rawDescData)
	})
	return file_google_spanner_v1_transaction_proto_rawDescData
}

var file_google_spanner_v1_transaction_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_spanner_v1_transaction_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_google_spanner_v1_transaction_proto_goTypes = []any{
	(TransactionOptions_IsolationLevel)(0),         // 0: google.spanner.v1.TransactionOptions.IsolationLevel
	(TransactionOptions_ReadWrite_ReadLockMode)(0), // 1: google.spanner.v1.TransactionOptions.ReadWrite.ReadLockMode
	(*TransactionOptions)(nil),                     // 2: google.spanner.v1.TransactionOptions
	(*Transaction)(nil),                            // 3: google.spanner.v1.Transaction
	(*TransactionSelector)(nil),                    // 4: google.spanner.v1.TransactionSelector
	(*MultiplexedSessionPrecommitToken)(nil),       // 5: google.spanner.v1.MultiplexedSessionPrecommitToken
	(*TransactionOptions_ReadWrite)(nil),           // 6: google.spanner.v1.TransactionOptions.ReadWrite
	(*TransactionOptions_PartitionedDml)(nil),      // 7: google.spanner.v1.TransactionOptions.PartitionedDml
	(*TransactionOptions_ReadOnly)(nil),            // 8: google.spanner.v1.TransactionOptions.ReadOnly
	(*timestamppb.Timestamp)(nil),                  // 9: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),                    // 10: google.protobuf.Duration
}
var file_google_spanner_v1_transaction_proto_depIdxs = []int32{
	6,  // 0: google.spanner.v1.TransactionOptions.read_write:type_name -> google.spanner.v1.TransactionOptions.ReadWrite
	7,  // 1: google.spanner.v1.TransactionOptions.partitioned_dml:type_name -> google.spanner.v1.TransactionOptions.PartitionedDml
	8,  // 2: google.spanner.v1.TransactionOptions.read_only:type_name -> google.spanner.v1.TransactionOptions.ReadOnly
	0,  // 3: google.spanner.v1.TransactionOptions.isolation_level:type_name -> google.spanner.v1.TransactionOptions.IsolationLevel
	9,  // 4: google.spanner.v1.Transaction.read_timestamp:type_name -> google.protobuf.Timestamp
	5,  // 5: google.spanner.v1.Transaction.precommit_token:type_name -> google.spanner.v1.MultiplexedSessionPrecommitToken
	2,  // 6: google.spanner.v1.TransactionSelector.single_use:type_name -> google.spanner.v1.TransactionOptions
	2,  // 7: google.spanner.v1.TransactionSelector.begin:type_name -> google.spanner.v1.TransactionOptions
	1,  // 8: google.spanner.v1.TransactionOptions.ReadWrite.read_lock_mode:type_name -> google.spanner.v1.TransactionOptions.ReadWrite.ReadLockMode
	9,  // 9: google.spanner.v1.TransactionOptions.ReadOnly.min_read_timestamp:type_name -> google.protobuf.Timestamp
	10, // 10: google.spanner.v1.TransactionOptions.ReadOnly.max_staleness:type_name -> google.protobuf.Duration
	9,  // 11: google.spanner.v1.TransactionOptions.ReadOnly.read_timestamp:type_name -> google.protobuf.Timestamp
	10, // 12: google.spanner.v1.TransactionOptions.ReadOnly.exact_staleness:type_name -> google.protobuf.Duration
	13, // [13:13] is the sub-list for method output_type
	13, // [13:13] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_google_spanner_v1_transaction_proto_init() }
func file_google_spanner_v1_transaction_proto_init() {
	if File_google_spanner_v1_transaction_proto != nil {
		return
	}
	file_google_spanner_v1_transaction_proto_msgTypes[0].OneofWrappers = []any{
		(*TransactionOptions_ReadWrite_)(nil),
		(*TransactionOptions_PartitionedDml_)(nil),
		(*TransactionOptions_ReadOnly_)(nil),
	}
	file_google_spanner_v1_transaction_proto_msgTypes[2].OneofWrappers = []any{
		(*TransactionSelector_SingleUse)(nil),
		(*TransactionSelector_Id)(nil),
		(*TransactionSelector_Begin)(nil),
	}
	file_google_spanner_v1_transaction_proto_msgTypes[6].OneofWrappers = []any{
		(*TransactionOptions_ReadOnly_Strong)(nil),
		(*TransactionOptions_ReadOnly_MinReadTimestamp)(nil),
		(*TransactionOptions_ReadOnly_MaxStaleness)(nil),
		(*TransactionOptions_ReadOnly_ReadTimestamp)(nil),
		(*TransactionOptions_ReadOnly_ExactStaleness)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_spanner_v1_transaction_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_spanner_v1_transaction_proto_goTypes,
		DependencyIndexes: file_google_spanner_v1_transaction_proto_depIdxs,
		EnumInfos:         file_google_spanner_v1_transaction_proto_enumTypes,
		MessageInfos:      file_google_spanner_v1_transaction_proto_msgTypes,
	}.Build()
	File_google_spanner_v1_transaction_proto = out.File
	file_google_spanner_v1_transaction_proto_rawDesc = nil
	file_google_spanner_v1_transaction_proto_goTypes = nil
	file_google_spanner_v1_transaction_proto_depIdxs = nil
}
