/* TabletView.c generated by valac 0.56.18, the Vala compiler
 * generated from TabletView.vala, do not modify */

/*
 * Copyright (c) 2019 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 */

#include "wacom.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>

#define WACOM_TABLET_VIEW_WACOM_TABLET_SCHEMA "org.gnome.desktop.peripherals.tablet"
#define WACOM_TABLET_VIEW_WACOM_SETTINGS_BASE "/org/gnome/desktop/peripherals/tablets/%s/"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	WACOM_TABLET_VIEW_0_PROPERTY,
	WACOM_TABLET_VIEW_DEVICE_KEY_PROPERTY,
	WACOM_TABLET_VIEW_NUM_PROPERTIES
};
static GParamSpec* wacom_tablet_view_properties[WACOM_TABLET_VIEW_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _WacomTabletViewPrivate {
	gchar* _device_key;
	GSettings* settings;
	GtkComboBoxText* tracking_mode_combo;
	GtkSwitch* left_handed_switch;
};

static gint WacomTabletView_private_offset;
static gpointer wacom_tablet_view_parent_class = NULL;

static GObject * wacom_tablet_view_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static void wacom_tablet_view_finalize (GObject * obj);
static GType wacom_tablet_view_get_type_once (void);
static void _vala_wacom_tablet_view_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_wacom_tablet_view_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);

static inline gpointer
wacom_tablet_view_get_instance_private (WacomTabletView* self)
{
	return G_STRUCT_MEMBER_P (self, WacomTabletView_private_offset);
}

WacomTabletView*
wacom_tablet_view_construct (GType object_type)
{
	WacomTabletView * self = NULL;
	self = (WacomTabletView*) g_object_new (object_type, NULL);
	return self;
}

WacomTabletView*
wacom_tablet_view_new (void)
{
	return wacom_tablet_view_construct (WACOM_TYPE_TABLET_VIEW);
}

const gchar*
wacom_tablet_view_get_device_key (WacomTabletView* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_device_key;
	result = _tmp0_;
	return result;
}

void
wacom_tablet_view_set_device_key (WacomTabletView* self,
                                  const gchar* value)
{
	gchar* _tmp0_;
	gchar* path = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	GtkComboBoxText* _tmp6_;
	GSettings* _tmp7_;
	GtkSwitch* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_device_key);
	self->priv->_device_key = _tmp0_;
	_tmp1_ = wacom_tablet_view_get_device_key (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf (WACOM_TABLET_VIEW_WACOM_SETTINGS_BASE, _tmp2_);
	path = _tmp3_;
	_tmp4_ = g_settings_new_with_path (WACOM_TABLET_VIEW_WACOM_TABLET_SCHEMA, path);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp4_;
	_tmp5_ = self->priv->settings;
	_tmp6_ = self->priv->tracking_mode_combo;
	g_settings_bind (_tmp5_, "mapping", (GObject*) _tmp6_, "active-id", G_SETTINGS_BIND_DEFAULT);
	_tmp7_ = self->priv->settings;
	_tmp8_ = self->priv->left_handed_switch;
	g_settings_bind (_tmp7_, "left-handed", (GObject*) _tmp8_, "active", G_SETTINGS_BIND_DEFAULT);
	_g_free0 (path);
	g_object_notify_by_pspec ((GObject *) self, wacom_tablet_view_properties[WACOM_TABLET_VIEW_DEVICE_KEY_PROPERTY]);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GObject *
wacom_tablet_view_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	WacomTabletView * self;
	GtkComboBoxText* _tmp0_;
	GtkComboBoxText* _tmp1_;
	GtkComboBoxText* _tmp2_;
	GtkComboBoxText* _tmp3_;
	GtkLabel* tracking_mode_label = NULL;
	GtkComboBoxText* _tmp4_;
	GtkWidget* _tmp5_;
	GtkLabel* _tmp6_ = NULL;
	GtkSwitch* _tmp7_;
	GtkSwitch* _tmp8_;
	GtkLabel* left_handed_label = NULL;
	GtkSwitch* _tmp9_;
	GtkWidget* _tmp10_;
	GtkLabel* _tmp11_ = NULL;
	GtkLabel* _tmp12_;
	GtkComboBoxText* _tmp13_;
	GtkLabel* _tmp14_;
	GtkSwitch* _tmp15_;
	parent_class = G_OBJECT_CLASS (wacom_tablet_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WACOM_TYPE_TABLET_VIEW, WacomTabletView);
	gtk_grid_set_row_spacing ((GtkGrid*) self, 12);
	gtk_grid_set_column_spacing ((GtkGrid*) self, 12);
	_tmp0_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->tracking_mode_combo);
	self->priv->tracking_mode_combo = _tmp0_;
	_tmp1_ = self->priv->tracking_mode_combo;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp1_, TRUE);
	_tmp2_ = self->priv->tracking_mode_combo;
	gtk_combo_box_text_append (_tmp2_, "absolute", _ ("Tablet (absolute)"));
	_tmp3_ = self->priv->tracking_mode_combo;
	gtk_combo_box_text_append (_tmp3_, "relative", _ ("Touchpad (relative)"));
	_tmp4_ = self->priv->tracking_mode_combo;
	_tmp5_ = _g_object_ref0 ((GtkWidget*) _tmp4_);
	_tmp6_ = (GtkLabel*) gtk_label_new (_ ("Tracking Mode"));
	gtk_label_set_mnemonic_widget (_tmp6_, _tmp5_);
	_g_object_unref0 (_tmp5_);
	gtk_label_set_xalign (_tmp6_, (gfloat) 0);
	g_object_ref_sink (_tmp6_);
	tracking_mode_label = _tmp6_;
	_tmp7_ = (GtkSwitch*) gtk_switch_new ();
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->left_handed_switch);
	self->priv->left_handed_switch = _tmp7_;
	_tmp8_ = self->priv->left_handed_switch;
	gtk_widget_set_halign ((GtkWidget*) _tmp8_, GTK_ALIGN_START);
	_tmp9_ = self->priv->left_handed_switch;
	_tmp10_ = _g_object_ref0 ((GtkWidget*) _tmp9_);
	_tmp11_ = (GtkLabel*) gtk_label_new (_ ("Left Hand Orientation"));
	gtk_label_set_mnemonic_widget (_tmp11_, _tmp10_);
	_g_object_unref0 (_tmp10_);
	gtk_label_set_xalign (_tmp11_, (gfloat) 0);
	g_object_ref_sink (_tmp11_);
	left_handed_label = _tmp11_;
	_tmp12_ = tracking_mode_label;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp12_, 0, 0, 1, 1);
	_tmp13_ = self->priv->tracking_mode_combo;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp13_, 1, 0, 1, 1);
	_tmp14_ = left_handed_label;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp14_, 0, 1, 1, 1);
	_tmp15_ = self->priv->left_handed_switch;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp15_, 1, 1, 1, 1);
	_g_object_unref0 (left_handed_label);
	_g_object_unref0 (tracking_mode_label);
	return obj;
}

static void
wacom_tablet_view_class_init (WacomTabletViewClass * klass,
                              gpointer klass_data)
{
	wacom_tablet_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &WacomTabletView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_wacom_tablet_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_wacom_tablet_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = wacom_tablet_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = wacom_tablet_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), WACOM_TABLET_VIEW_DEVICE_KEY_PROPERTY, wacom_tablet_view_properties[WACOM_TABLET_VIEW_DEVICE_KEY_PROPERTY] = g_param_spec_string ("device-key", "device-key", "device-key", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
wacom_tablet_view_instance_init (WacomTabletView * self,
                                 gpointer klass)
{
	self->priv = wacom_tablet_view_get_instance_private (self);
}

static void
wacom_tablet_view_finalize (GObject * obj)
{
	WacomTabletView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WACOM_TYPE_TABLET_VIEW, WacomTabletView);
	_g_free0 (self->priv->_device_key);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->tracking_mode_combo);
	_g_object_unref0 (self->priv->left_handed_switch);
	G_OBJECT_CLASS (wacom_tablet_view_parent_class)->finalize (obj);
}

static GType
wacom_tablet_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WacomTabletViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) wacom_tablet_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WacomTabletView), 0, (GInstanceInitFunc) wacom_tablet_view_instance_init, NULL };
	GType wacom_tablet_view_type_id;
	wacom_tablet_view_type_id = g_type_register_static (gtk_grid_get_type (), "WacomTabletView", &g_define_type_info, 0);
	WacomTabletView_private_offset = g_type_add_instance_private (wacom_tablet_view_type_id, sizeof (WacomTabletViewPrivate));
	return wacom_tablet_view_type_id;
}

GType
wacom_tablet_view_get_type (void)
{
	static volatile gsize wacom_tablet_view_type_id__once = 0;
	if (g_once_init_enter (&wacom_tablet_view_type_id__once)) {
		GType wacom_tablet_view_type_id;
		wacom_tablet_view_type_id = wacom_tablet_view_get_type_once ();
		g_once_init_leave (&wacom_tablet_view_type_id__once, wacom_tablet_view_type_id);
	}
	return wacom_tablet_view_type_id__once;
}

static void
_vala_wacom_tablet_view_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	WacomTabletView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, WACOM_TYPE_TABLET_VIEW, WacomTabletView);
	switch (property_id) {
		case WACOM_TABLET_VIEW_DEVICE_KEY_PROPERTY:
		g_value_set_string (value, wacom_tablet_view_get_device_key (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_wacom_tablet_view_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	WacomTabletView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, WACOM_TYPE_TABLET_VIEW, WacomTabletView);
	switch (property_id) {
		case WACOM_TABLET_VIEW_DEVICE_KEY_PROPERTY:
		wacom_tablet_view_set_device_key (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

