/* TeeJee.System.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from TeeJee.System.vala, do not modify */

/*
 * TeeJee.System.vala
 *
 * Copyright 2012-2018 Tony George <teejeetech@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 *
 */

#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <locale.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))

VALA_EXTERN gboolean tee_jee_system_user_is_admin (void);
VALA_EXTERN gint tee_jee_system_get_user_id_effective (void);
VALA_EXTERN gint tee_jee_system_get_user_id (void);
VALA_EXTERN gint tee_jee_system_get_user_id_from_username (const gchar* username);
VALA_EXTERN gint tee_jee_process_helper_exec_sync (const gchar* cmd,
                                       gchar** std_out,
                                       gchar** std_err);
VALA_EXTERN gchar* tee_jee_system_get_username (void);
VALA_EXTERN gchar* tee_jee_system_get_username_from_uid (gint user_id);
VALA_EXTERN gchar* tee_jee_system_get_username_effective (void);
VALA_EXTERN gchar* tee_jee_file_system_file_read (const gchar* file_path);
VALA_EXTERN void tee_jee_logging_log_error (const gchar* message,
                                gboolean highlight,
                                gboolean is_warning);
VALA_EXTERN gchar* tee_jee_system_get_user_home (const gchar* username);
VALA_EXTERN gchar* tee_jee_system_get_user_home_effective (void);
VALA_EXTERN gdouble tee_jee_system_get_system_uptime_seconds (void);
VALA_EXTERN gboolean tee_jee_system_xdg_open (const gchar* file,
                                  const gchar* user);
VALA_EXTERN gchar* tee_jee_process_helper_get_cmd_path (const gchar* cmd_tool);
VALA_EXTERN gchar* tee_jee_file_system_escape_single_quote (const gchar* file_path);
VALA_EXTERN void tee_jee_logging_log_debug (const gchar* message);
VALA_EXTERN gint tee_jee_process_helper_exec_script_async (const gchar* script);
VALA_EXTERN gboolean tee_jee_system_exo_open_folder (const gchar* dir_path,
                                         gboolean xdg_open_try_first);
VALA_EXTERN gboolean tee_jee_system_using_efi_boot (void);
VALA_EXTERN gboolean tee_jee_file_system_dir_exists (const gchar* dir_path);
VALA_EXTERN GTimer* tee_jee_system_timer_start (void);
VALA_EXTERN gulong tee_jee_system_timer_elapsed (GTimer* timer,
                                     gboolean stop);
VALA_EXTERN void tee_jee_system_sleep (gint milliseconds);
VALA_EXTERN gchar* tee_jee_system_timer_elapsed_string (GTimer* timer,
                                            gboolean stop);
VALA_EXTERN void tee_jee_system_set_numeric_locale (const gchar* type);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

gboolean
tee_jee_system_user_is_admin (void)
{
	gboolean result;
	result = tee_jee_system_get_user_id_effective () == 0;
	return result;
}

gint
tee_jee_system_get_user_id (void)
{
	gchar* pkexec_uid = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* sudo_user = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gint result;
	_tmp0_ = g_getenv ("PKEXEC_UID");
	_tmp1_ = g_strdup (_tmp0_);
	pkexec_uid = _tmp1_;
	_tmp2_ = pkexec_uid;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		_tmp3_ = pkexec_uid;
		result = atoi (_tmp3_);
		_g_free0 (pkexec_uid);
		return result;
	}
	_tmp4_ = g_getenv ("SUDO_USER");
	_tmp5_ = g_strdup (_tmp4_);
	sudo_user = _tmp5_;
	_tmp6_ = sudo_user;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_;
		_tmp7_ = sudo_user;
		result = tee_jee_system_get_user_id_from_username (_tmp7_);
		_g_free0 (sudo_user);
		_g_free0 (pkexec_uid);
		return result;
	}
	result = tee_jee_system_get_user_id_effective ();
	_g_free0 (sudo_user);
	_g_free0 (pkexec_uid);
	return result;
}

gint
tee_jee_system_get_user_id_effective (void)
{
	gint uid = 0;
	gchar* cmd = NULL;
	gchar* _tmp0_;
	gchar* std_out = NULL;
	gchar* std_err = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	gint result;
	uid = -1;
	_tmp0_ = g_strdup ("id -u");
	cmd = _tmp0_;
	_tmp1_ = cmd;
	tee_jee_process_helper_exec_sync (_tmp1_, &_tmp2_, &_tmp3_);
	_g_free0 (std_out);
	std_out = _tmp2_;
	_g_free0 (std_err);
	std_err = _tmp3_;
	_tmp5_ = std_out;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp6_ = std_out;
		_tmp7_ = strlen (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp4_ = _tmp8_ > 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		const gchar* _tmp9_;
		_tmp9_ = std_out;
		uid = atoi (_tmp9_);
	}
	result = uid;
	_g_free0 (std_err);
	_g_free0 (std_out);
	_g_free0 (cmd);
	return result;
}

gchar*
tee_jee_system_get_username (void)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = tee_jee_system_get_username_from_uid (tee_jee_system_get_user_id ());
	result = _tmp0_;
	return result;
}

gchar*
tee_jee_system_get_username_effective (void)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = tee_jee_system_get_username_from_uid (tee_jee_system_get_user_id_effective ());
	result = _tmp0_;
	return result;
}

gint
tee_jee_system_get_user_id_from_username (const gchar* username)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gint result;
	g_return_val_if_fail (username != NULL, 0);
	_tmp0_ = tee_jee_file_system_file_read ("/etc/passwd");
	_tmp1_ = _tmp0_;
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, "\n", 0);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _vala_array_length (_tmp2_);
	_g_free0 (_tmp1_);
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp4_;
		line_collection_length1 = _tmp4__length1;
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
			gchar* _tmp5_;
			gchar* line = NULL;
			_tmp5_ = g_strdup (line_collection[line_it]);
			line = _tmp5_;
			{
				gchar** arr = NULL;
				const gchar* _tmp6_;
				gchar** _tmp7_;
				gchar** _tmp8_;
				gint arr_length1;
				gint _arr_size_;
				gboolean _tmp9_ = FALSE;
				gchar** _tmp10_;
				gint _tmp10__length1;
				_tmp6_ = line;
				_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, ":", 0);
				arr = _tmp8_;
				arr_length1 = _vala_array_length (_tmp7_);
				_arr_size_ = arr_length1;
				_tmp10_ = arr;
				_tmp10__length1 = arr_length1;
				if (_tmp10__length1 >= 3) {
					gchar** _tmp11_;
					gint _tmp11__length1;
					const gchar* _tmp12_;
					_tmp11_ = arr;
					_tmp11__length1 = arr_length1;
					_tmp12_ = _tmp11_[0];
					_tmp9_ = g_strcmp0 (_tmp12_, username) == 0;
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					gchar** _tmp13_;
					gint _tmp13__length1;
					const gchar* _tmp14_;
					_tmp13_ = arr;
					_tmp13__length1 = arr_length1;
					_tmp14_ = _tmp13_[2];
					result = atoi (_tmp14_);
					arr = (_vala_array_free (arr, arr_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (line);
					line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				arr = (_vala_array_free (arr, arr_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (line);
			}
		}
		line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp15_ = g_strdup_printf ("UserId not found for userName: %s", username);
	_tmp16_ = _tmp15_;
	tee_jee_logging_log_error (_tmp16_, FALSE, FALSE);
	_g_free0 (_tmp16_);
	result = -1;
	return result;
}

gchar*
tee_jee_system_get_username_from_uid (gint user_id)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* result;
	_tmp0_ = tee_jee_file_system_file_read ("/etc/passwd");
	_tmp1_ = _tmp0_;
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, "\n", 0);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _vala_array_length (_tmp2_);
	_g_free0 (_tmp1_);
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp4_;
		line_collection_length1 = _tmp4__length1;
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
			gchar* _tmp5_;
			gchar* line = NULL;
			_tmp5_ = g_strdup (line_collection[line_it]);
			line = _tmp5_;
			{
				gchar** arr = NULL;
				const gchar* _tmp6_;
				gchar** _tmp7_;
				gchar** _tmp8_;
				gint arr_length1;
				gint _arr_size_;
				gboolean _tmp9_ = FALSE;
				gchar** _tmp10_;
				gint _tmp10__length1;
				_tmp6_ = line;
				_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, ":", 0);
				arr = _tmp8_;
				arr_length1 = _vala_array_length (_tmp7_);
				_arr_size_ = arr_length1;
				_tmp10_ = arr;
				_tmp10__length1 = arr_length1;
				if (_tmp10__length1 >= 3) {
					gchar** _tmp11_;
					gint _tmp11__length1;
					const gchar* _tmp12_;
					gchar* _tmp13_;
					gchar* _tmp14_;
					_tmp11_ = arr;
					_tmp11__length1 = arr_length1;
					_tmp12_ = _tmp11_[2];
					_tmp13_ = g_strdup_printf ("%i", user_id);
					_tmp14_ = _tmp13_;
					_tmp9_ = g_strcmp0 (_tmp12_, _tmp14_) == 0;
					_g_free0 (_tmp14_);
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					gchar** _tmp15_;
					gint _tmp15__length1;
					const gchar* _tmp16_;
					gchar* _tmp17_;
					_tmp15_ = arr;
					_tmp15__length1 = arr_length1;
					_tmp16_ = _tmp15_[0];
					_tmp17_ = g_strdup (_tmp16_);
					result = _tmp17_;
					arr = (_vala_array_free (arr, arr_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (line);
					line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				arr = (_vala_array_free (arr, arr_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (line);
			}
		}
		line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp18_ = g_strdup_printf ("Username not found for uid: %d", user_id);
	_tmp19_ = _tmp18_;
	tee_jee_logging_log_error (_tmp19_, FALSE, FALSE);
	_g_free0 (_tmp19_);
	_tmp20_ = g_strdup ("");
	result = _tmp20_;
	return result;
}

gchar*
tee_jee_system_get_user_home (const gchar* username)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* result;
	g_return_val_if_fail (username != NULL, NULL);
	_tmp0_ = tee_jee_file_system_file_read ("/etc/passwd");
	_tmp1_ = _tmp0_;
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, "\n", 0);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _vala_array_length (_tmp2_);
	_g_free0 (_tmp1_);
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp4_;
		line_collection_length1 = _tmp4__length1;
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
			gchar* _tmp5_;
			gchar* line = NULL;
			_tmp5_ = g_strdup (line_collection[line_it]);
			line = _tmp5_;
			{
				gchar** arr = NULL;
				const gchar* _tmp6_;
				gchar** _tmp7_;
				gchar** _tmp8_;
				gint arr_length1;
				gint _arr_size_;
				gboolean _tmp9_ = FALSE;
				gchar** _tmp10_;
				gint _tmp10__length1;
				_tmp6_ = line;
				_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, ":", 0);
				arr = _tmp8_;
				arr_length1 = _vala_array_length (_tmp7_);
				_arr_size_ = arr_length1;
				_tmp10_ = arr;
				_tmp10__length1 = arr_length1;
				if (_tmp10__length1 >= 6) {
					gchar** _tmp11_;
					gint _tmp11__length1;
					const gchar* _tmp12_;
					_tmp11_ = arr;
					_tmp11__length1 = arr_length1;
					_tmp12_ = _tmp11_[0];
					_tmp9_ = g_strcmp0 (_tmp12_, username) == 0;
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					gchar** _tmp13_;
					gint _tmp13__length1;
					const gchar* _tmp14_;
					gchar* _tmp15_;
					_tmp13_ = arr;
					_tmp13__length1 = arr_length1;
					_tmp14_ = _tmp13_[5];
					_tmp15_ = g_strdup (_tmp14_);
					result = _tmp15_;
					arr = (_vala_array_free (arr, arr_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (line);
					line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				arr = (_vala_array_free (arr, arr_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (line);
			}
		}
		line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp16_ = g_strdup_printf ("Home directory not found for user: %s", username);
	_tmp17_ = _tmp16_;
	tee_jee_logging_log_error (_tmp17_, FALSE, FALSE);
	_g_free0 (_tmp17_);
	_tmp18_ = g_strdup ("");
	result = _tmp18_;
	return result;
}

gchar*
tee_jee_system_get_user_home_effective (void)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	_tmp0_ = tee_jee_system_get_username_effective ();
	_tmp1_ = _tmp0_;
	_tmp2_ = tee_jee_system_get_user_home (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

gdouble
tee_jee_system_get_system_uptime_seconds (void)
{
	gchar* uptime = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gdouble secs = 0.0;
	gdouble result;
	_tmp0_ = tee_jee_file_system_file_read ("/proc/uptime");
	_tmp1_ = _tmp0_;
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, " ", 0);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _vala_array_length (_tmp2_);
	_tmp5_ = _tmp4_[0];
	_tmp6_ = g_strdup (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (_tmp1_);
	uptime = _tmp7_;
	secs = double_parse (uptime);
	result = secs;
	_g_free0 (uptime);
	return result;
}

gboolean
tee_jee_system_xdg_open (const gchar* file,
                         const gchar* user)
{
	gchar* path = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gboolean result;
	g_return_val_if_fail (file != NULL, FALSE);
	g_return_val_if_fail (user != NULL, FALSE);
	_tmp0_ = tee_jee_process_helper_get_cmd_path ("xdg-open");
	path = _tmp0_;
	_tmp2_ = path;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		_tmp3_ = path;
		_tmp1_ = g_strcmp0 (_tmp3_, "") != 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gchar* cmd = NULL;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		const gchar* _tmp14_;
		gint status = 0;
		const gchar* _tmp15_;
		_tmp4_ = tee_jee_file_system_escape_single_quote (file);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup_printf ("xdg-open '%s'", _tmp5_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		cmd = _tmp7_;
		_tmp8_ = strlen (user);
		_tmp9_ = _tmp8_;
		if (_tmp9_ > 0) {
			gchar* _tmp10_;
			gchar* _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp10_ = g_strdup_printf ("pkexec --user %s env DISPLAY=$DISPLAY XAUTHORITY=$XAUTHORITY ", user);
			_tmp11_ = _tmp10_;
			_tmp12_ = cmd;
			_tmp13_ = g_strconcat (_tmp11_, _tmp12_, NULL);
			_g_free0 (cmd);
			cmd = _tmp13_;
			_g_free0 (_tmp11_);
		}
		_tmp14_ = cmd;
		tee_jee_logging_log_debug (_tmp14_);
		_tmp15_ = cmd;
		status = tee_jee_process_helper_exec_script_async (_tmp15_);
		result = status == 0;
		_g_free0 (cmd);
		_g_free0 (path);
		return result;
	}
	result = FALSE;
	_g_free0 (path);
	return result;
}

gboolean
tee_jee_system_exo_open_folder (const gchar* dir_path,
                                gboolean xdg_open_try_first)
{
	gchar* path = NULL;
	gint status = 0;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar** _tmp16_;
	gboolean result;
	g_return_val_if_fail (dir_path != NULL, FALSE);
	if (xdg_open_try_first) {
		gchar* _tmp0_;
		gboolean _tmp1_ = FALSE;
		const gchar* _tmp2_;
		_tmp0_ = tee_jee_process_helper_get_cmd_path ("xdg-open");
		_g_free0 (path);
		path = _tmp0_;
		_tmp2_ = path;
		if (_tmp2_ != NULL) {
			const gchar* _tmp3_;
			_tmp3_ = path;
			_tmp1_ = g_strcmp0 (_tmp3_, "") != 0;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gchar* cmd = NULL;
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			const gchar* _tmp8_;
			_tmp4_ = tee_jee_file_system_escape_single_quote (dir_path);
			_tmp5_ = _tmp4_;
			_tmp6_ = g_strdup_printf ("xdg-open '%s'", _tmp5_);
			_tmp7_ = _tmp6_;
			_g_free0 (_tmp5_);
			cmd = _tmp7_;
			_tmp8_ = cmd;
			status = tee_jee_process_helper_exec_script_async (_tmp8_);
			result = status == 0;
			_g_free0 (cmd);
			_g_free0 (path);
			return result;
		}
	}
	_tmp9_ = g_strdup ("nemo");
	_tmp10_ = g_strdup ("nautilus");
	_tmp11_ = g_strdup ("thunar");
	_tmp12_ = g_strdup ("io.elementary.files");
	_tmp13_ = g_strdup ("pantheon-files");
	_tmp14_ = g_strdup ("marlin");
	_tmp15_ = g_strdup ("dolphin");
	_tmp16_ = g_new0 (gchar*, 7 + 1);
	_tmp16_[0] = _tmp9_;
	_tmp16_[1] = _tmp10_;
	_tmp16_[2] = _tmp11_;
	_tmp16_[3] = _tmp12_;
	_tmp16_[4] = _tmp13_;
	_tmp16_[5] = _tmp14_;
	_tmp16_[6] = _tmp15_;
	{
		gchar** app_name_collection = NULL;
		gint app_name_collection_length1 = 0;
		gint _app_name_collection_size_ = 0;
		gint app_name_it = 0;
		app_name_collection = _tmp16_;
		app_name_collection_length1 = 7;
		for (app_name_it = 0; app_name_it < app_name_collection_length1; app_name_it = app_name_it + 1) {
			gchar* _tmp17_;
			gchar* app_name = NULL;
			_tmp17_ = g_strdup (app_name_collection[app_name_it]);
			app_name = _tmp17_;
			{
				const gchar* _tmp18_;
				gchar* _tmp19_;
				gboolean _tmp20_ = FALSE;
				const gchar* _tmp21_;
				_tmp18_ = app_name;
				_tmp19_ = tee_jee_process_helper_get_cmd_path (_tmp18_);
				_g_free0 (path);
				path = _tmp19_;
				_tmp21_ = path;
				if (_tmp21_ != NULL) {
					const gchar* _tmp22_;
					_tmp22_ = path;
					_tmp20_ = g_strcmp0 (_tmp22_, "") != 0;
				} else {
					_tmp20_ = FALSE;
				}
				if (_tmp20_) {
					gchar* cmd = NULL;
					const gchar* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					gchar* _tmp26_;
					gchar* _tmp27_;
					const gchar* _tmp28_;
					_tmp23_ = app_name;
					_tmp24_ = tee_jee_file_system_escape_single_quote (dir_path);
					_tmp25_ = _tmp24_;
					_tmp26_ = g_strdup_printf ("%s '%s'", _tmp23_, _tmp25_);
					_tmp27_ = _tmp26_;
					_g_free0 (_tmp25_);
					cmd = _tmp27_;
					_tmp28_ = cmd;
					status = tee_jee_process_helper_exec_script_async (_tmp28_);
					result = status == 0;
					_g_free0 (cmd);
					_g_free0 (app_name);
					app_name_collection = (_vala_array_free (app_name_collection, app_name_collection_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (path);
					return result;
				}
				_g_free0 (app_name);
			}
		}
		app_name_collection = (_vala_array_free (app_name_collection, app_name_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	if (xdg_open_try_first == FALSE) {
		gchar* _tmp29_;
		gboolean _tmp30_ = FALSE;
		const gchar* _tmp31_;
		_tmp29_ = tee_jee_process_helper_get_cmd_path ("xdg-open");
		_g_free0 (path);
		path = _tmp29_;
		_tmp31_ = path;
		if (_tmp31_ != NULL) {
			const gchar* _tmp32_;
			_tmp32_ = path;
			_tmp30_ = g_strcmp0 (_tmp32_, "") != 0;
		} else {
			_tmp30_ = FALSE;
		}
		if (_tmp30_) {
			gchar* cmd = NULL;
			gchar* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			const gchar* _tmp37_;
			_tmp33_ = tee_jee_file_system_escape_single_quote (dir_path);
			_tmp34_ = _tmp33_;
			_tmp35_ = g_strdup_printf ("xdg-open '%s'", _tmp34_);
			_tmp36_ = _tmp35_;
			_g_free0 (_tmp34_);
			cmd = _tmp36_;
			_tmp37_ = cmd;
			status = tee_jee_process_helper_exec_script_async (_tmp37_);
			result = status == 0;
			_g_free0 (cmd);
			_g_free0 (path);
			return result;
		}
	}
	result = FALSE;
	_g_free0 (path);
	return result;
}

gboolean
tee_jee_system_using_efi_boot (void)
{
	gboolean result;
	result = tee_jee_file_system_dir_exists ("/sys/firmware/efi");
	return result;
}

GTimer*
tee_jee_system_timer_start (void)
{
	GTimer* timer = NULL;
	GTimer* _tmp0_;
	GTimer* result;
	_tmp0_ = g_timer_new ();
	timer = _tmp0_;
	g_timer_start (timer);
	result = timer;
	return result;
}

gulong
tee_jee_system_timer_elapsed (GTimer* timer,
                              gboolean stop)
{
	gulong microseconds = 0UL;
	gdouble seconds = 0.0;
	gulong _tmp0_ = 0UL;
	gdouble _tmp1_;
	gulong result;
	g_return_val_if_fail (timer != NULL, 0UL);
	_tmp1_ = g_timer_elapsed (timer, &_tmp0_);
	microseconds = _tmp0_;
	seconds = _tmp1_;
	if (stop) {
		g_timer_stop (timer);
	}
	result = (gulong) ((seconds * 1000) + (microseconds / 1000));
	return result;
}

void
tee_jee_system_sleep (gint milliseconds)
{
	g_usleep (((gulong) milliseconds) * 1000);
}

gchar*
tee_jee_system_timer_elapsed_string (GTimer* timer,
                                     gboolean stop)
{
	gulong microseconds = 0UL;
	gdouble seconds = 0.0;
	gulong _tmp0_ = 0UL;
	gdouble _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (timer != NULL, NULL);
	_tmp1_ = g_timer_elapsed (timer, &_tmp0_);
	microseconds = _tmp0_;
	seconds = _tmp1_;
	if (stop) {
		g_timer_stop (timer);
	}
	_tmp2_ = g_strdup_printf ("%.0f ms", (seconds * 1000) + (microseconds / 1000));
	result = _tmp2_;
	return result;
}

void
tee_jee_system_set_numeric_locale (const gchar* type)
{
	g_return_if_fail (type != NULL);
	setlocale (LC_NUMERIC, type);
	setlocale (LC_COLLATE, type);
	setlocale (LC_TIME, type);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

