/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSTrustedTypePolicy.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertVariadic.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSTrustedHTML.h"
#include "JSTrustedScript.h"
#include "JSTrustedScriptURL.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsTrustedTypePolicyPrototypeFunction_createHTML);
static JSC_DECLARE_HOST_FUNCTION(jsTrustedTypePolicyPrototypeFunction_createScript);
static JSC_DECLARE_HOST_FUNCTION(jsTrustedTypePolicyPrototypeFunction_createScriptURL);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsTrustedTypePolicyConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsTrustedTypePolicy_name);

class JSTrustedTypePolicyPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSTrustedTypePolicyPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSTrustedTypePolicyPrototype* ptr = new (NotNull, JSC::allocateCell<JSTrustedTypePolicyPrototype>(vm)) JSTrustedTypePolicyPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSTrustedTypePolicyPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSTrustedTypePolicyPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSTrustedTypePolicyPrototype, JSTrustedTypePolicyPrototype::Base);

using JSTrustedTypePolicyDOMConstructor = JSDOMConstructorNotConstructable<JSTrustedTypePolicy>;

template<> const ClassInfo JSTrustedTypePolicyDOMConstructor::s_info = { "TrustedTypePolicy"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTrustedTypePolicyDOMConstructor) };

template<> JSValue JSTrustedTypePolicyDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSTrustedTypePolicyDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "TrustedTypePolicy"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSTrustedTypePolicy::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 5> JSTrustedTypePolicyPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsTrustedTypePolicyConstructor, 0 } },
    HashTableValue { "name"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsTrustedTypePolicy_name, 0 } },
    HashTableValue { "createHTML"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsTrustedTypePolicyPrototypeFunction_createHTML, 1 } },
    HashTableValue { "createScript"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsTrustedTypePolicyPrototypeFunction_createScript, 1 } },
    HashTableValue { "createScriptURL"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsTrustedTypePolicyPrototypeFunction_createScriptURL, 1 } },
};

const ClassInfo JSTrustedTypePolicyPrototype::s_info = { "TrustedTypePolicy"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTrustedTypePolicyPrototype) };

void JSTrustedTypePolicyPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSTrustedTypePolicy::info(), JSTrustedTypePolicyPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSTrustedTypePolicy::s_info = { "TrustedTypePolicy"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTrustedTypePolicy) };

JSTrustedTypePolicy::JSTrustedTypePolicy(Structure* structure, JSDOMGlobalObject& globalObject, Ref<TrustedTypePolicy>&& impl)
    : JSDOMWrapper<TrustedTypePolicy>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, TrustedTypePolicy>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSTrustedTypePolicy::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSTrustedTypePolicyPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSTrustedTypePolicyPrototype::create(vm, &globalObject, structure);
}

JSObject* JSTrustedTypePolicy::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSTrustedTypePolicy>(vm, globalObject);
}

JSValue JSTrustedTypePolicy::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTrustedTypePolicyDOMConstructor, DOMConstructorID::TrustedTypePolicy>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSTrustedTypePolicy::destroy(JSC::JSCell* cell)
{
    JSTrustedTypePolicy* thisObject = static_cast<JSTrustedTypePolicy*>(cell);
    thisObject->JSTrustedTypePolicy::~JSTrustedTypePolicy();
}

JSC_DEFINE_CUSTOM_GETTER(jsTrustedTypePolicyConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSTrustedTypePolicyPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSTrustedTypePolicy::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsTrustedTypePolicy_nameGetter(JSGlobalObject& lexicalGlobalObject, JSTrustedTypePolicy& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.name())));
}

JSC_DEFINE_CUSTOM_GETTER(jsTrustedTypePolicy_name, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSTrustedTypePolicy>::get<jsTrustedTypePolicy_nameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsTrustedTypePolicyPrototypeFunction_createHTMLBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSTrustedTypePolicy>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto inputConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (inputConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto arguments = convertVariadicArguments<IDLAny>(*lexicalGlobalObject, *callFrame, 1);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<TrustedHTML>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createHTML(inputConversionResult.releaseReturnValue(), WTFMove(arguments)))));
}

JSC_DEFINE_HOST_FUNCTION(jsTrustedTypePolicyPrototypeFunction_createHTML, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSTrustedTypePolicy>::call<jsTrustedTypePolicyPrototypeFunction_createHTMLBody>(*lexicalGlobalObject, *callFrame, "createHTML");
}

static inline JSC::EncodedJSValue jsTrustedTypePolicyPrototypeFunction_createScriptBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSTrustedTypePolicy>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto inputConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (inputConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto arguments = convertVariadicArguments<IDLAny>(*lexicalGlobalObject, *callFrame, 1);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<TrustedScript>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createScript(inputConversionResult.releaseReturnValue(), WTFMove(arguments)))));
}

JSC_DEFINE_HOST_FUNCTION(jsTrustedTypePolicyPrototypeFunction_createScript, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSTrustedTypePolicy>::call<jsTrustedTypePolicyPrototypeFunction_createScriptBody>(*lexicalGlobalObject, *callFrame, "createScript");
}

static inline JSC::EncodedJSValue jsTrustedTypePolicyPrototypeFunction_createScriptURLBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSTrustedTypePolicy>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto inputConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (inputConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto arguments = convertVariadicArguments<IDLAny>(*lexicalGlobalObject, *callFrame, 1);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<TrustedScriptURL>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createScriptURL(inputConversionResult.releaseReturnValue(), WTFMove(arguments)))));
}

JSC_DEFINE_HOST_FUNCTION(jsTrustedTypePolicyPrototypeFunction_createScriptURL, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSTrustedTypePolicy>::call<jsTrustedTypePolicyPrototypeFunction_createScriptURLBody>(*lexicalGlobalObject, *callFrame, "createScriptURL");
}

JSC::GCClient::IsoSubspace* JSTrustedTypePolicy::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSTrustedTypePolicy, UseCustomHeapCellType::No>(vm, "JSTrustedTypePolicy"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForTrustedTypePolicy.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForTrustedTypePolicy = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForTrustedTypePolicy.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForTrustedTypePolicy = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSTrustedTypePolicy::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSTrustedTypePolicy*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

DEFINE_VISIT_CHILDREN(JSTrustedTypePolicy);

template<typename Visitor>
void JSTrustedTypePolicy::visitOutputConstraints(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSTrustedTypePolicy*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

template void JSTrustedTypePolicy::visitOutputConstraints(JSCell*, AbstractSlotVisitor&);
template void JSTrustedTypePolicy::visitOutputConstraints(JSCell*, SlotVisitor&);
void JSTrustedTypePolicy::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSTrustedTypePolicy*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSTrustedTypePolicyOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsTrustedTypePolicy = jsCast<JSTrustedTypePolicy*>(handle.slot()->asCell());
    TrustedTypePolicy* owner = &jsTrustedTypePolicy->wrapped();
    if (reason) [[unlikely]]
        *reason = "Reachable from TrustedTypePolicy"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSTrustedTypePolicyOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsTrustedTypePolicy = static_cast<JSTrustedTypePolicy*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsTrustedTypePolicy->protectedWrapped().ptr(), jsTrustedTypePolicy);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7TrustedTypePolicy@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore17TrustedTypePolicyE[]; }
#endif
template<std::same_as<TrustedTypePolicy> T>
static inline void verifyVTable(TrustedTypePolicy* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7TrustedTypePolicy@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore17TrustedTypePolicyE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // TrustedTypePolicy has subclasses. If TrustedTypePolicy has subclasses that get passed
        // to toJS() we currently require TrustedTypePolicy you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<TrustedTypePolicy>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<TrustedTypePolicy>(impl.ptr());
#endif
    return createWrapper<TrustedTypePolicy>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, TrustedTypePolicy& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

TrustedTypePolicy* JSTrustedTypePolicy::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSTrustedTypePolicy*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
