/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSAudioBufferOptions.h"

#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include <JavaScriptCore/JSCInlines.h>



namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_AUDIO)

template<> ConversionResult<IDLDictionary<AudioBufferOptions>> convertDictionary<AudioBufferOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    AudioBufferOptions result;
    JSValue lengthValue;
    if (isNullOrUndefined)
        lengthValue = jsUndefined();
    else {
        lengthValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "length"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (lengthValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "length"_s, "AudioBufferOptions"_s, "unsigned long"_s);
        return ConversionResultException { };
    }
    auto lengthConversionResult = convert<IDLUnsignedLong>(lexicalGlobalObject, lengthValue);
    if (lengthConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.length = lengthConversionResult.releaseReturnValue();
    JSValue numberOfChannelsValue;
    if (isNullOrUndefined)
        numberOfChannelsValue = jsUndefined();
    else {
        numberOfChannelsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "numberOfChannels"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto numberOfChannelsConversionResult = convertOptionalWithDefault<IDLUnsignedLong>(lexicalGlobalObject, numberOfChannelsValue, [&]() -> ConversionResult<IDLUnsignedLong> { return Converter<IDLUnsignedLong>::ReturnType { 1 }; });
    if (numberOfChannelsConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.numberOfChannels = numberOfChannelsConversionResult.releaseReturnValue();
    JSValue sampleRateValue;
    if (isNullOrUndefined)
        sampleRateValue = jsUndefined();
    else {
        sampleRateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sampleRate"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (sampleRateValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "sampleRate"_s, "AudioBufferOptions"_s, "float"_s);
        return ConversionResultException { };
    }
    auto sampleRateConversionResult = convert<IDLFloat>(lexicalGlobalObject, sampleRateValue);
    if (sampleRateConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.sampleRate = sampleRateConversionResult.releaseReturnValue();
    return result;
}

#endif

} // namespace WebCore


#endif // ENABLE(WEB_AUDIO)
