/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSpeechRecognitionErrorEvent.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSSpeechRecognitionErrorCode.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<SpeechRecognitionErrorEvent::Init>> convertDictionary<SpeechRecognitionErrorEvent::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    SpeechRecognitionErrorEvent::Init result;
    JSValue bubblesValue;
    if (isNullOrUndefined)
        bubblesValue = jsUndefined();
    else {
        bubblesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bubbles"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto bubblesConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, bubblesValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (bubblesConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.bubbles = bubblesConversionResult.releaseReturnValue();
    JSValue cancelableValue;
    if (isNullOrUndefined)
        cancelableValue = jsUndefined();
    else {
        cancelableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cancelable"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto cancelableConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, cancelableValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (cancelableConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.cancelable = cancelableConversionResult.releaseReturnValue();
    JSValue composedValue;
    if (isNullOrUndefined)
        composedValue = jsUndefined();
    else {
        composedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composed"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto composedConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, composedValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (composedConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.composed = composedConversionResult.releaseReturnValue();
    JSValue errorValue;
    if (isNullOrUndefined)
        errorValue = jsUndefined();
    else {
        errorValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "error"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (errorValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "error"_s, "SpeechRecognitionErrorEventInit"_s, "SpeechRecognitionErrorCode"_s);
        return ConversionResultException { };
    }
    auto errorConversionResult = convert<IDLEnumeration<SpeechRecognitionErrorCode>>(lexicalGlobalObject, errorValue);
    if (errorConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.error = errorConversionResult.releaseReturnValue();
    JSValue messageValue;
    if (isNullOrUndefined)
        messageValue = jsUndefined();
    else {
        messageValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "message"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto messageConversionResult = convertOptionalWithDefault<IDLDOMString>(lexicalGlobalObject, messageValue, [&]() -> ConversionResult<IDLDOMString> { return Converter<IDLDOMString>::ReturnType { emptyString() }; });
    if (messageConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.message = messageConversionResult.releaseReturnValue();
    return result;
}

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsSpeechRecognitionErrorEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSpeechRecognitionErrorEvent_error);
static JSC_DECLARE_CUSTOM_GETTER(jsSpeechRecognitionErrorEvent_message);

class JSSpeechRecognitionErrorEventPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSpeechRecognitionErrorEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSpeechRecognitionErrorEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSSpeechRecognitionErrorEventPrototype>(vm)) JSSpeechRecognitionErrorEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSpeechRecognitionErrorEventPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSpeechRecognitionErrorEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSpeechRecognitionErrorEventPrototype, JSSpeechRecognitionErrorEventPrototype::Base);

using JSSpeechRecognitionErrorEventDOMConstructor = JSDOMConstructor<JSSpeechRecognitionErrorEvent>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSSpeechRecognitionErrorEventDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSSpeechRecognitionErrorEventDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (callFrame->argumentCount() < 2) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto typeConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    if (typeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto eventInitDictConversionResult = convert<IDLDictionary<SpeechRecognitionErrorEvent::Init>>(*lexicalGlobalObject, argument1.value());
    if (eventInitDictConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto object = SpeechRecognitionErrorEvent::create(typeConversionResult.releaseReturnValue(), eventInitDictConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<SpeechRecognitionErrorEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<SpeechRecognitionErrorEvent>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSSpeechRecognitionErrorEventDOMConstructorConstruct, JSSpeechRecognitionErrorEventDOMConstructor::construct);

template<> const ClassInfo JSSpeechRecognitionErrorEventDOMConstructor::s_info = { "SpeechRecognitionErrorEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSpeechRecognitionErrorEventDOMConstructor) };

template<> JSValue JSSpeechRecognitionErrorEventDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEvent::getConstructor(vm, &globalObject);
}

template<> void JSSpeechRecognitionErrorEventDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(2), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "SpeechRecognitionErrorEvent"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSSpeechRecognitionErrorEvent::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 3> JSSpeechRecognitionErrorEventPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSpeechRecognitionErrorEventConstructor, 0 } },
    HashTableValue { "error"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSpeechRecognitionErrorEvent_error, 0 } },
    HashTableValue { "message"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSpeechRecognitionErrorEvent_message, 0 } },
};

const ClassInfo JSSpeechRecognitionErrorEventPrototype::s_info = { "SpeechRecognitionErrorEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSpeechRecognitionErrorEventPrototype) };

void JSSpeechRecognitionErrorEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSpeechRecognitionErrorEvent::info(), JSSpeechRecognitionErrorEventPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSSpeechRecognitionErrorEvent::s_info = { "SpeechRecognitionErrorEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSpeechRecognitionErrorEvent) };

JSSpeechRecognitionErrorEvent::JSSpeechRecognitionErrorEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SpeechRecognitionErrorEvent>&& impl)
    : JSEvent(structure, globalObject, WTFMove(impl))
{
}

Ref<SpeechRecognitionErrorEvent> JSSpeechRecognitionErrorEvent::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, SpeechRecognitionErrorEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSSpeechRecognitionErrorEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSSpeechRecognitionErrorEventPrototype::createStructure(vm, &globalObject, JSEvent::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSSpeechRecognitionErrorEventPrototype::create(vm, &globalObject, structure);
}

JSObject* JSSpeechRecognitionErrorEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSpeechRecognitionErrorEvent>(vm, globalObject);
}

JSValue JSSpeechRecognitionErrorEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSpeechRecognitionErrorEventDOMConstructor, DOMConstructorID::SpeechRecognitionErrorEvent>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSpeechRecognitionErrorEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSpeechRecognitionErrorEventPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSpeechRecognitionErrorEvent::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsSpeechRecognitionErrorEvent_errorGetter(JSGlobalObject& lexicalGlobalObject, JSSpeechRecognitionErrorEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<SpeechRecognitionErrorCode>>(lexicalGlobalObject, throwScope, impl.error())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSpeechRecognitionErrorEvent_error, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSpeechRecognitionErrorEvent>::get<jsSpeechRecognitionErrorEvent_errorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSpeechRecognitionErrorEvent_messageGetter(JSGlobalObject& lexicalGlobalObject, JSSpeechRecognitionErrorEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.message())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSpeechRecognitionErrorEvent_message, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSpeechRecognitionErrorEvent>::get<jsSpeechRecognitionErrorEvent_messageGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSSpeechRecognitionErrorEvent::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSSpeechRecognitionErrorEvent, UseCustomHeapCellType::No>(vm, "JSSpeechRecognitionErrorEvent"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForSpeechRecognitionErrorEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForSpeechRecognitionErrorEvent = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForSpeechRecognitionErrorEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForSpeechRecognitionErrorEvent = std::forward<decltype(space)>(space); }
    );
}

void JSSpeechRecognitionErrorEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSpeechRecognitionErrorEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7SpeechRecognitionErrorEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore27SpeechRecognitionErrorEventE[]; }
#endif
template<std::same_as<SpeechRecognitionErrorEvent> T>
static inline void verifyVTable(SpeechRecognitionErrorEvent* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7SpeechRecognitionErrorEvent@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore27SpeechRecognitionErrorEventE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // SpeechRecognitionErrorEvent has subclasses. If SpeechRecognitionErrorEvent has subclasses that get passed
        // to toJS() we currently require SpeechRecognitionErrorEvent you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<SpeechRecognitionErrorEvent>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<SpeechRecognitionErrorEvent>(impl.ptr());
#endif
    return createWrapper<SpeechRecognitionErrorEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, SpeechRecognitionErrorEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
