/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSStylePropertyMap.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "Document.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSCSSStyleValue.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMConvertVariadic.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsStylePropertyMapPrototypeFunction_set);
static JSC_DECLARE_HOST_FUNCTION(jsStylePropertyMapPrototypeFunction_append);
static JSC_DECLARE_HOST_FUNCTION(jsStylePropertyMapPrototypeFunction_delete);
static JSC_DECLARE_HOST_FUNCTION(jsStylePropertyMapPrototypeFunction_clear);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsStylePropertyMapConstructor);

class JSStylePropertyMapPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSStylePropertyMapPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSStylePropertyMapPrototype* ptr = new (NotNull, JSC::allocateCell<JSStylePropertyMapPrototype>(vm)) JSStylePropertyMapPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSStylePropertyMapPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSStylePropertyMapPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSStylePropertyMapPrototype, JSStylePropertyMapPrototype::Base);

using JSStylePropertyMapDOMConstructor = JSDOMConstructorNotConstructable<JSStylePropertyMap>;

template<> const ClassInfo JSStylePropertyMapDOMConstructor::s_info = { "StylePropertyMap"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSStylePropertyMapDOMConstructor) };

template<> JSValue JSStylePropertyMapDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSStylePropertyMapReadOnly::getConstructor(vm, &globalObject);
}

template<> void JSStylePropertyMapDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "StylePropertyMap"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSStylePropertyMap::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 5> JSStylePropertyMapPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsStylePropertyMapConstructor, 0 } },
    HashTableValue { "set"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsStylePropertyMapPrototypeFunction_set, 1 } },
    HashTableValue { "append"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsStylePropertyMapPrototypeFunction_append, 1 } },
    HashTableValue { "delete"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsStylePropertyMapPrototypeFunction_delete, 1 } },
    HashTableValue { "clear"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsStylePropertyMapPrototypeFunction_clear, 0 } },
};

const ClassInfo JSStylePropertyMapPrototype::s_info = { "StylePropertyMap"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSStylePropertyMapPrototype) };

void JSStylePropertyMapPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSStylePropertyMap::info(), JSStylePropertyMapPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSStylePropertyMap::s_info = { "StylePropertyMap"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSStylePropertyMap) };

JSStylePropertyMap::JSStylePropertyMap(Structure* structure, JSDOMGlobalObject& globalObject, Ref<StylePropertyMap>&& impl)
    : JSStylePropertyMapReadOnly(structure, globalObject, WTFMove(impl))
{
}

Ref<StylePropertyMap> JSStylePropertyMap::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, StylePropertyMap>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSStylePropertyMap::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSStylePropertyMapPrototype::createStructure(vm, &globalObject, JSStylePropertyMapReadOnly::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSStylePropertyMapPrototype::create(vm, &globalObject, structure);
}

JSObject* JSStylePropertyMap::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSStylePropertyMap>(vm, globalObject);
}

JSValue JSStylePropertyMap::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSStylePropertyMapDOMConstructor, DOMConstructorID::StylePropertyMap>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsStylePropertyMapConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSStylePropertyMapPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSStylePropertyMap::getConstructor(vm, prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsStylePropertyMapPrototypeFunction_setBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSStylePropertyMap>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    RefPtr context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (!context) [[unlikely]]
        return JSValue::encode(jsUndefined());
    Ref document = downcast<Document>(*context);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto propertyConversionResult = convert<IDLAtomStringAdaptor<IDLUSVString>>(*lexicalGlobalObject, argument0.value());
    if (propertyConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto values = convertVariadicArguments<IDLUnion<IDLInterface<CSSStyleValue>, IDLUSVString>>(*lexicalGlobalObject, *callFrame, 1);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.set(document.get(), propertyConversionResult.releaseReturnValue(), WTFMove(values)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsStylePropertyMapPrototypeFunction_set, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSStylePropertyMap>::call<jsStylePropertyMapPrototypeFunction_setBody>(*lexicalGlobalObject, *callFrame, "set");
}

static inline JSC::EncodedJSValue jsStylePropertyMapPrototypeFunction_appendBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSStylePropertyMap>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    RefPtr context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (!context) [[unlikely]]
        return JSValue::encode(jsUndefined());
    Ref document = downcast<Document>(*context);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto propertyConversionResult = convert<IDLAtomStringAdaptor<IDLUSVString>>(*lexicalGlobalObject, argument0.value());
    if (propertyConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto values = convertVariadicArguments<IDLUnion<IDLInterface<CSSStyleValue>, IDLUSVString>>(*lexicalGlobalObject, *callFrame, 1);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.append(document.get(), propertyConversionResult.releaseReturnValue(), WTFMove(values)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsStylePropertyMapPrototypeFunction_append, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSStylePropertyMap>::call<jsStylePropertyMapPrototypeFunction_appendBody>(*lexicalGlobalObject, *callFrame, "append");
}

static inline JSC::EncodedJSValue jsStylePropertyMapPrototypeFunction_deleteBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSStylePropertyMap>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    RefPtr context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (!context) [[unlikely]]
        return JSValue::encode(jsUndefined());
    Ref document = downcast<Document>(*context);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto propertyConversionResult = convert<IDLAtomStringAdaptor<IDLUSVString>>(*lexicalGlobalObject, argument0.value());
    if (propertyConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.remove(document.get(), propertyConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsStylePropertyMapPrototypeFunction_delete, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSStylePropertyMap>::call<jsStylePropertyMapPrototypeFunction_deleteBody>(*lexicalGlobalObject, *callFrame, "delete");
}

static inline JSC::EncodedJSValue jsStylePropertyMapPrototypeFunction_clearBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSStylePropertyMap>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.clear(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsStylePropertyMapPrototypeFunction_clear, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSStylePropertyMap>::call<jsStylePropertyMapPrototypeFunction_clearBody>(*lexicalGlobalObject, *callFrame, "clear");
}

JSC::GCClient::IsoSubspace* JSStylePropertyMap::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSStylePropertyMap, UseCustomHeapCellType::No>(vm, "JSStylePropertyMap"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForStylePropertyMap.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForStylePropertyMap = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForStylePropertyMap.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForStylePropertyMap = std::forward<decltype(space)>(space); }
    );
}

void JSStylePropertyMap::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSStylePropertyMap*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<StylePropertyMap>&& impl)
{
    return createWrapper<StylePropertyMap>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, StylePropertyMap& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
