/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.shaped.border;

import java.awt.Component;
import java.awt.Polygon;
import net.infonode.gui.colorprovider.ColorProvider;
import net.infonode.gui.shaped.border.AbstractPolygonBorder;

public class PolygonBorder
extends AbstractPolygonBorder {
    private static final long serialVersionUID = 1L;
    private int[] coords;
    private float[] widthFactors;
    private float[] heightFactors;

    public PolygonBorder(ColorProvider lineColor, int[] coords, float[] widthFactors, float[] heightFactors) {
        super(lineColor);
        this.coords = coords;
        this.widthFactors = widthFactors;
        this.heightFactors = heightFactors;
    }

    public PolygonBorder(ColorProvider lineColor, ColorProvider highlightColor, int[] coords, float[] widthFactors, float[] heightFactors) {
        super(lineColor, highlightColor);
        this.coords = coords;
        this.widthFactors = widthFactors;
        this.heightFactors = heightFactors;
    }

    public PolygonBorder(ColorProvider lineColor, ColorProvider highlightColor, ColorProvider middleColor, ColorProvider shadowColor, int[] coords, float[] widthFactors, float[] heightFactors) {
        super(lineColor, highlightColor, middleColor, shadowColor);
        this.coords = coords;
        this.widthFactors = widthFactors;
        this.heightFactors = heightFactors;
    }

    @Override
    protected Polygon createPolygon(Component c, int width, int height) {
        int[] xc = new int[this.coords.length / 2];
        int[] yc = new int[this.coords.length / 2];
        int n = 0;
        int i = 0;
        while (i < xc.length) {
            xc[i] = (int)(this.widthFactors[n] * (float)width) + (int)(this.heightFactors[n] * (float)height) + this.coords[n];
            yc[i] = (int)(this.widthFactors[++n] * (float)width) + (int)(this.heightFactors[n] * (float)height) + this.coords[n];
            ++n;
            ++i;
        }
        return new Polygon(xc, yc, xc.length);
    }
}

