/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.color.Illuminant;
import io.sf.carte.doc.color.Illuminants;
import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.LCHColor;
import io.sf.carte.doc.style.css.property.BaseColor;
import io.sf.carte.doc.style.css.property.ChromaticAdaption;
import io.sf.carte.doc.style.css.property.ColorUtil;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.LCHColorValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.OKLCHColorValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.SRGBColorProfile;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import io.sf.jclf.math.linear3.Matrices;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.w3c.dom.DOMException;

class LCHColorImpl
extends BaseColor
implements LCHColor {
    private static final long serialVersionUID = 2L;
    private final BaseColor.Space colorSpace;
    private final String strSpace;
    private PrimitiveValue lightness = null;
    private PrimitiveValue chroma = null;
    private PrimitiveValue hue = null;

    LCHColorImpl(BaseColor.Space space, String string) {
        this.colorSpace = space;
        this.strSpace = string;
    }

    @Override
    public CSSColorValue.ColorModel getColorModel() {
        return CSSColorValue.ColorModel.LCH;
    }

    @Override
    public String getColorSpace() {
        return this.strSpace;
    }

    @Override
    BaseColor.Space getSpace() {
        return this.colorSpace;
    }

    @Override
    void set(BaseColor baseColor) {
        super.set(baseColor);
        LCHColorImpl lCHColorImpl = (LCHColorImpl)baseColor;
        this.setLightness(lCHColorImpl.getLightness());
        this.setChroma(lCHColorImpl.getChroma());
        this.setHue(lCHColorImpl.getHue());
    }

    @Override
    public PrimitiveValue item(int n) {
        switch (n) {
            case 0: {
                return this.alpha;
            }
            case 1: {
                return this.getLightness();
            }
            case 2: {
                return this.getChroma();
            }
            case 3: {
                return this.getHue();
            }
        }
        return null;
    }

    @Override
    void setComponent(int n, PrimitiveValue primitiveValue) {
        switch (n) {
            case 0: {
                this.setAlpha(primitiveValue);
                break;
            }
            case 1: {
                this.setLightness(primitiveValue);
                break;
            }
            case 2: {
                this.setChroma(primitiveValue);
                break;
            }
            case 3: {
                this.setHue(primitiveValue);
            }
        }
    }

    @Override
    public PrimitiveValue getLightness() {
        return this.lightness;
    }

    public void setLightness(PrimitiveValue primitiveValue) {
        boolean bl;
        int n;
        float f;
        if (BaseColor.Space.OK_LCh.equals((Object)this.colorSpace)) {
            f = 0.01f;
            n = 6;
            bl = false;
        } else {
            f = 1.0f;
            n = 4;
            bl = true;
        }
        this.lightness = LCHColorImpl.normalizePcntToNumber(primitiveValue, f, n, bl);
    }

    @Override
    public PrimitiveValue getChroma() {
        return this.chroma;
    }

    public void setChroma(PrimitiveValue primitiveValue) {
        int n;
        float f;
        if (BaseColor.Space.OK_LCh.equals((Object)this.colorSpace)) {
            f = 0.004f;
            n = 5;
        } else {
            f = 1.5f;
            n = 4;
        }
        this.chroma = LCHColorImpl.normalizePcntToNumber(primitiveValue, f, n, false);
    }

    @Override
    public PrimitiveValue getHue() {
        return this.hue;
    }

    public void setHue(PrimitiveValue primitiveValue) {
        this.hue = LCHColorImpl.enforceHueComponent(primitiveValue);
    }

    @Override
    boolean hasConvertibleComponents() {
        return LCHColorImpl.isConvertibleComponent(this.getChroma()) && LCHColorImpl.isConvertibleComponent(this.getHue()) && LCHColorImpl.isConvertibleComponent(this.getLightness());
    }

    @Override
    void setColorComponents(double[] dArray) {
        NumberValue numberValue = NumberValue.createCSSNumberValue((short)0, (float)dArray[0]);
        numberValue.setSubproperty(true);
        numberValue.setAbsolutizedUnit();
        if (this.getSpace() == BaseColor.Space.OK_LCh) {
            numberValue.setMaximumFractionDigits(6);
        } else {
            numberValue.setMaximumFractionDigits(4);
        }
        this.setLightness(numberValue);
        NumberValue numberValue2 = NumberValue.createCSSNumberValue((short)0, (float)dArray[1]);
        numberValue2.setSubproperty(true);
        numberValue2.setAbsolutizedUnit();
        if (this.getSpace() == BaseColor.Space.OK_LCh) {
            numberValue2.setMaximumFractionDigits(5);
        } else {
            numberValue2.setMaximumFractionDigits(4);
        }
        this.setChroma(numberValue2);
        float f = (float)dArray[2];
        if (f < 0.0f) {
            f += 360.0f;
        }
        NumberValue numberValue3 = NumberValue.createCSSNumberValue((short)80, f);
        numberValue3.setSubproperty(true);
        numberValue3.setAbsolutizedUnit();
        numberValue3.setMaximumFractionDigits(4);
        this.setHue(numberValue3);
    }

    @Override
    public double[] toNumberArray() throws DOMException {
        if (!this.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        double[] dArray = new double[]{ColorUtil.floatNumber((CSSTypedValue)((Object)this.getLightness())), ColorUtil.floatNumber((CSSTypedValue)((Object)this.getChroma())), ColorUtil.hueDegrees((CSSTypedValue)((Object)this.getHue()))};
        return dArray;
    }

    @Override
    double[] toSRGB(boolean bl) {
        if (!this.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        float f = ColorUtil.floatNumber((CSSTypedValue)((Object)this.getChroma()));
        double d = ColorUtil.hueRadians((CSSTypedValue)((Object)this.getHue()));
        double d2 = (double)f * Math.cos(d);
        double d3 = (double)f * Math.sin(d);
        float f2 = ColorUtil.floatNumber((CSSTypedValue)((Object)this.getLightness()));
        double[] dArray = new double[3];
        SRGBColorProfile sRGBColorProfile = new SRGBColorProfile();
        if (this.colorSpace == BaseColor.Space.OK_LCh) {
            ColorUtil.oklabToRGB(f2, d2, d3, bl, sRGBColorProfile, dArray);
        } else {
            ColorUtil.labToClampedRGB(f2, d2, d3, bl, sRGBColorProfile, dArray);
        }
        return dArray;
    }

    @Override
    public double[] toXYZ(Illuminant illuminant) {
        double[] dArray;
        if (!this.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        CSSTypedValue cSSTypedValue = (CSSTypedValue)((Object)this.getHue());
        float f = ColorUtil.floatNumber((CSSTypedValue)((Object)this.getChroma()));
        double d = ColorUtil.hueRadians(cSSTypedValue);
        float f2 = (float)((double)f * Math.cos(d));
        float f3 = (float)((double)f * Math.sin(d));
        float f4 = ColorUtil.floatNumber((CSSTypedValue)((Object)this.getLightness()));
        if (this.colorSpace == BaseColor.Space.OK_LCh) {
            dArray = ColorUtil.oklabToXyzD65(f4, f2, f3);
            if (illuminant == Illuminant.D50) {
                dArray = ColorUtil.d65xyzToD50(dArray);
            }
        } else {
            dArray = ColorUtil.labToXYZd50(f4, f2, f3);
            if (illuminant == Illuminant.D65) {
                dArray = ColorUtil.d50xyzToD65(dArray);
            }
        }
        return dArray;
    }

    @Override
    public double[] toXYZ(double[] dArray) {
        double[] dArray2;
        double[] dArray3 = this.toLab();
        if (this.colorSpace == BaseColor.Space.OK_LCh) {
            dArray2 = ColorUtil.oklabToXyzD65(dArray3[0], dArray3[1], dArray3[2]);
            if (!Arrays.equals(Illuminants.whiteD65, dArray)) {
                double[][] dArray4 = new double[3][3];
                ChromaticAdaption.chromaticAdaptionMatrix(Illuminants.whiteD65, dArray, dArray4);
                double[] dArray5 = new double[3];
                Matrices.multiplyByVector3((double[][])dArray4, (double[])dArray2, (double[])dArray5);
                dArray2 = dArray5;
            }
        } else {
            dArray2 = ColorUtil.labToXYZd50(dArray3[0], dArray3[1], dArray3[2]);
            if (!Arrays.equals(Illuminants.whiteD50, dArray)) {
                double[][] dArray6 = new double[3][3];
                ChromaticAdaption.chromaticAdaptionMatrix(Illuminants.whiteD50, dArray, dArray6);
                double[] dArray7 = new double[3];
                Matrices.multiplyByVector3((double[][])dArray6, (double[])dArray2, (double[])dArray7);
                dArray2 = dArray7;
            }
        }
        return dArray2;
    }

    private double[] toLab() {
        if (!this.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        CSSTypedValue cSSTypedValue = (CSSTypedValue)((Object)this.getHue());
        float f = ColorUtil.floatNumber((CSSTypedValue)((Object)this.getChroma()));
        double d = ColorUtil.hueRadians(cSSTypedValue);
        double[] dArray = new double[3];
        dArray[1] = (float)((double)f * Math.cos(d));
        dArray[2] = (float)((double)f * Math.sin(d));
        dArray[0] = ColorUtil.floatNumber((CSSTypedValue)((Object)this.getLightness()));
        return dArray;
    }

    @Override
    public String toString() {
        BufferSimpleWriter bufferSimpleWriter = new BufferSimpleWriter();
        try {
            this.writeCssText((SimpleWriter)bufferSimpleWriter);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bufferSimpleWriter.toString();
    }

    void writeCssText(SimpleWriter simpleWriter) throws IOException {
        if (this.colorSpace == BaseColor.Space.OK_LCh) {
            simpleWriter.write((CharSequence)"oklch(");
        } else {
            simpleWriter.write((CharSequence)"lch(");
        }
        this.lightness.writeCssText(simpleWriter);
        simpleWriter.write(' ');
        this.chroma.writeCssText(simpleWriter);
        simpleWriter.write(' ');
        this.writeHue(simpleWriter, this.hue);
        if (this.isNonOpaque()) {
            simpleWriter.write((CharSequence)" / ");
            this.appendAlphaChannel(simpleWriter);
        }
        simpleWriter.write(')');
    }

    @Override
    public String toMinifiedString() {
        StringBuilder stringBuilder = new StringBuilder(20);
        if (this.colorSpace == BaseColor.Space.OK_LCh) {
            stringBuilder.append("oklch(");
        } else {
            stringBuilder.append("lch(");
        }
        stringBuilder.append(this.lightness.getMinifiedCssText("color"));
        stringBuilder.append(' ').append(this.chroma.getMinifiedCssText("color")).append(' ');
        this.appendMinifiedHue(stringBuilder, this.hue);
        if (this.isNonOpaque()) {
            stringBuilder.append('/');
            this.appendAlphaChannelMinified(stringBuilder);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = Objects.hash(new Object[]{this.getSpace()});
        n2 = 31 * n2 + (this.lightness == null ? 0 : this.lightness.hashCode());
        n2 = 31 * n2 + (this.chroma == null ? 0 : this.chroma.hashCode());
        n2 = 31 * n2 + (this.hue == null ? 0 : this.hue.hashCode());
        n2 = 31 * n2 + this.alpha.hashCode();
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        LCHColorImpl lCHColorImpl = (LCHColorImpl)object;
        if (this.colorSpace != lCHColorImpl.colorSpace) {
            return false;
        }
        if (this.lightness == null ? lCHColorImpl.lightness != null : !this.lightness.equals(lCHColorImpl.lightness)) {
            return false;
        }
        if (this.chroma == null ? lCHColorImpl.chroma != null : !this.chroma.equals(lCHColorImpl.chroma)) {
            return false;
        }
        if (this.hue == null ? lCHColorImpl.hue != null : !this.hue.equals(lCHColorImpl.hue)) {
            return false;
        }
        return this.alpha.equals(lCHColorImpl.alpha);
    }

    @Override
    public ColorValue packInValue() {
        if (BaseColor.Space.OK_LCh.equals((Object)this.colorSpace)) {
            return new OKLCHColorValue(this);
        }
        return new LCHColorValue(this);
    }

    @Override
    public LCHColorImpl clone() {
        LCHColorImpl lCHColorImpl = new LCHColorImpl(this.colorSpace, this.strSpace);
        lCHColorImpl.alpha = this.alpha.clone();
        if (this.lightness != null) {
            lCHColorImpl.lightness = this.lightness.clone();
        }
        if (this.chroma != null) {
            lCHColorImpl.chroma = this.chroma.clone();
        }
        if (this.hue != null) {
            lCHColorImpl.hue = this.hue.clone();
        }
        return lCHColorImpl;
    }
}

