/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.filesleuth;

import java.io.File;
import java.util.TimeZone;
import tim.prune.function.filesleuth.WorkerCoordinator;
import tim.prune.function.filesleuth.data.TrackContents;
import tim.prune.function.filesleuth.data.TrackFile;

public abstract class AbstractFileScanner {
    private final TrackFile _trackFile;
    private final WorkerCoordinator _parent;
    protected final TimeZone _timezone;

    public AbstractFileScanner(TrackFile trackFile, WorkerCoordinator workerCoordinator, TimeZone timeZone) {
        this._trackFile = trackFile;
        this._parent = workerCoordinator;
        this._timezone = timeZone;
    }

    protected File getFile() {
        return this._trackFile == null ? null : this._trackFile.getFile();
    }

    public void startScan() {
        new Thread(this::run).start();
    }

    protected abstract void run();

    protected void finished(TrackContents trackContents) {
        this._parent.informWorkComplete(this._trackFile, trackContents);
    }
}

