/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import javax.annotation.concurrent.ThreadSafe;
import org.gradle.api.Task;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.taskfactory.TaskIdentity;
import org.gradle.internal.id.ConfigurationCacheableIdFactory;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.BuildTree.class})
@ThreadSafe
public class TaskIdentityFactory {
    private final ConfigurationCacheableIdFactory idFactory;

    public TaskIdentityFactory(ConfigurationCacheableIdFactory idFactory) {
        this.idFactory = idFactory;
    }

    public <T extends Task> TaskIdentity<T> create(String name, Class<T> type, ProjectInternal project) {
        long id = this.idFactory.createId();
        return new TaskIdentity<T>(type, name, project.getProjectIdentity(), id);
    }

    public <T extends Task> TaskIdentity<T> recreate(String name, Class<T> type, ProjectInternal project, long uniqueId) {
        this.idFactory.idRecreated();
        return new TaskIdentity<T>(type, name, project.getProjectIdentity(), uniqueId);
    }
}

