/*
 * Decompiled with CFR 0.152.
 */
package net.sf.juife;

import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import net.sf.juife.Task;
import net.sf.juife.event.TaskEvent;
import net.sf.juife.event.TaskListener;

public abstract class AbstractTask<R>
implements Task<R>,
Runnable {
    public static int UNKNOWN_ERROR = -1;
    private int errorCode = UNKNOWN_ERROR;
    private String errorMessage = null;
    private String errorDetails = null;
    private boolean isDone = false;
    private boolean started = false;
    private boolean doneWithErrors = false;
    private String title = "net.sf.juife.AbstractTask";
    private String desc = null;
    private R result = null;
    private final EventListenerList listenerList = new EventListenerList();
    private TaskEvent taskEvent = null;

    @Override
    public boolean done() {
        return this.isDone;
    }

    public void setDone(boolean b) {
        this.isDone = true;
    }

    @Override
    public boolean doneWithErrors() {
        return this.doneWithErrors;
    }

    public void setDoneWithErrors(boolean b) {
        this.doneWithErrors = b;
    }

    @Override
    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int code) {
        this.errorCode = code;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String msg) {
        this.errorMessage = msg;
        this.setDoneWithErrors(true);
    }

    @Override
    public String getErrorDetails() {
        return this.errorDetails;
    }

    public void setErrorDetails(String details) {
        this.errorDetails = details;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    public void setDescription(String desc) {
        this.desc = desc;
    }

    @Override
    public void invoke() {
        new Thread(this.getTitle()){

            @Override
            public void run() {
                AbstractTask.this.invokeAndWait();
            }
        }.start();
    }

    @Override
    public void invokeAndWait() {
        if (this.isStarted()) {
            throw new IllegalStateException("Task already started");
        }
        this.started = true;
        this.run();
        this.setDone(true);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    AbstractTask.this.fireTaskPerformed();
                }
            });
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public R getResult() {
        return this.result;
    }

    public void setResult(R result) {
        this.result = result;
    }

    @Override
    public void addTaskListener(TaskListener l) {
        this.listenerList.add(TaskListener.class, l);
    }

    @Override
    public void removeTaskListener(TaskListener l) {
        this.listenerList.remove(TaskListener.class, l);
    }

    private void fireTaskPerformed() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TaskListener.class) continue;
            if (this.taskEvent == null) {
                this.taskEvent = new TaskEvent(this);
            }
            ((TaskListener)listeners[i + 1]).taskPerformed(this.taskEvent);
        }
    }
}

