/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security.mappers;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.infinispan.commons.api.Lifecycle;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.context.Flag;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.security.MutableRolePermissionMapper;
import org.infinispan.security.Role;
import org.infinispan.security.actions.SecurityActions;

@Scope(value=Scopes.GLOBAL)
public class ClusterPermissionMapper
implements MutableRolePermissionMapper,
Lifecycle {
    public static final String CLUSTER_PERMISSION_MAPPER_CACHE = "org.infinispan.PERMISSIONS";
    @Inject
    EmbeddedCacheManager cacheManager;
    @Inject
    InternalCacheRegistry internalCacheRegistry;
    private Cache<String, Role> clusterPermissionMap;
    private Cache<String, Role> clusterPermissionReadMap;

    public void start() {
        this.initializeInternalCache();
        this.clusterPermissionMap = this.cacheManager.getCache(CLUSTER_PERMISSION_MAPPER_CACHE);
        this.clusterPermissionReadMap = this.clusterPermissionMap.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD, Flag.CACHE_MODE_LOCAL);
    }

    public void stop() {
    }

    private void initializeInternalCache() {
        GlobalConfiguration globalConfiguration = SecurityActions.getCacheManagerConfiguration(this.cacheManager);
        CacheMode cacheMode = globalConfiguration.isClustered() ? CacheMode.REPL_SYNC : CacheMode.LOCAL;
        ConfigurationBuilder cfg = new ConfigurationBuilder();
        cfg.clustering().cacheMode(cacheMode).stateTransfer().fetchInMemoryState(true).awaitInitialTransfer(globalConfiguration.isClustered()).security().authorization().disable();
        this.internalCacheRegistry.registerInternalCache(CLUSTER_PERMISSION_MAPPER_CACHE, cfg.build(), EnumSet.of(InternalCacheRegistry.Flag.PERSISTENT));
    }

    @Override
    public CompletionStage<Void> addRole(Role role) {
        return this.clusterPermissionMap.putAsync(role.getName(), role).thenApply(ignore -> null);
    }

    @Override
    public CompletionStage<Boolean> removeRole(String name) {
        return this.clusterPermissionMap.removeAsync(name).thenApply(Objects::nonNull);
    }

    @Override
    public Map<String, Role> getAllRoles() {
        return this.isActive() ? this.clusterPermissionReadMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)) : Collections.emptyMap();
    }

    @Override
    public Role getRole(String name) {
        return this.isActive() ? (Role)this.clusterPermissionReadMap.get(name) : null;
    }

    @Override
    public boolean hasRole(String name) {
        return !this.isActive() || this.clusterPermissionReadMap.containsKey(name);
    }

    private boolean isActive() {
        return this.clusterPermissionReadMap != null && this.cacheManager.getStatus().allowInvocations();
    }
}

