/*
 * Decompiled with CFR 0.152.
 */
package com.github.lgooddatepicker.durationpicker_underconstruction;

import com.github.lgooddatepicker.durationpicker_underconstruction.DurationUnit;
import com.github.lgooddatepicker.zinternaltools.TranslationSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;

public class DurationConverterSettings {
    public DurationUnit smallestUsedUnit = DurationUnit.Minute;
    public DurationUnit largestUsedUnit = DurationUnit.Week;
    public HashMap<DurationUnit, Boolean> pluralUnitsMap = this.getSimplePluralUnitsMap(true);
    public boolean hoursCanUseThirtyMinuteDecimals = true;
    public int hoursMaximumValueForDecimalsInSeconds;
    public HashMap<DurationUnit, String> translationsUnitsSingular;
    public HashMap<DurationUnit, String> translationsUnitsPlural;
    public HashMap<DurationUnit, ArrayList<String>> translationsParsingPrefixes;
    private Locale locale;

    public DurationConverterSettings() {
        this(Locale.getDefault());
    }

    public DurationConverterSettings(Locale locale) {
        this.hoursMaximumValueForDecimalsInSeconds = 24 * DurationUnit.Hour.inSeconds;
        this.initializeSettingsFromLocale(locale);
    }

    private void initializeSettingsFromLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ("hi".equals(locale.getLanguage()) && locale.getCountry().isEmpty()) {
            locale = new Locale("hi", "IN");
        }
        this.locale = locale;
        this.translationsUnitsSingular = new HashMap();
        this.translationsUnitsSingular.put(DurationUnit.Second, TranslationSource.getTranslation(locale, "singular.Second", "sec"));
        this.translationsUnitsSingular.put(DurationUnit.Minute, TranslationSource.getTranslation(locale, "singular.Minute", "min"));
        this.translationsUnitsSingular.put(DurationUnit.Hour, TranslationSource.getTranslation(locale, "singular.Hour", "hour"));
        this.translationsUnitsSingular.put(DurationUnit.Day, TranslationSource.getTranslation(locale, "singular.Day", "day"));
        this.translationsUnitsSingular.put(DurationUnit.Week, TranslationSource.getTranslation(locale, "singular.Week", "week"));
        this.translationsUnitsSingular.put(DurationUnit.Month, TranslationSource.getTranslation(locale, "singular.Month", "month"));
        this.translationsUnitsSingular.put(DurationUnit.Year, TranslationSource.getTranslation(locale, "singular.Year", "year"));
        this.translationsUnitsPlural = new HashMap();
        this.translationsUnitsPlural.put(DurationUnit.Second, TranslationSource.getTranslation(locale, "plural.Second", "secs"));
        this.translationsUnitsPlural.put(DurationUnit.Minute, TranslationSource.getTranslation(locale, "plural.Minute", "mins"));
        this.translationsUnitsPlural.put(DurationUnit.Hour, TranslationSource.getTranslation(locale, "plural.Hour", "hours"));
        this.translationsUnitsPlural.put(DurationUnit.Day, TranslationSource.getTranslation(locale, "plural.Day", "days"));
        this.translationsUnitsPlural.put(DurationUnit.Week, TranslationSource.getTranslation(locale, "plural.Week", "weeks"));
        this.translationsUnitsPlural.put(DurationUnit.Month, TranslationSource.getTranslation(locale, "plural.Month", "months"));
        this.translationsUnitsPlural.put(DurationUnit.Year, TranslationSource.getTranslation(locale, "plural.Year", "years"));
        this.translationsParsingPrefixes = new HashMap();
        for (DurationUnit unit : DurationUnit.values()) {
            this.translationsParsingPrefixes.put(unit, new ArrayList());
        }
        String parseKey = "parsingprefixlist.";
        String[] prefixArray = TranslationSource.getTranslation(locale, parseKey + "Second", "s").split(";");
        this.translationsParsingPrefixes.get((Object)DurationUnit.Second).addAll(Arrays.asList(prefixArray));
        prefixArray = TranslationSource.getTranslation(locale, parseKey + "Minute", "m").split(";");
        this.translationsParsingPrefixes.get((Object)DurationUnit.Minute).addAll(Arrays.asList(prefixArray));
        prefixArray = TranslationSource.getTranslation(locale, parseKey + "Hour", "h").split(";");
        this.translationsParsingPrefixes.get((Object)DurationUnit.Hour).addAll(Arrays.asList(prefixArray));
        prefixArray = TranslationSource.getTranslation(locale, parseKey + "Day", "d").split(";");
        this.translationsParsingPrefixes.get((Object)DurationUnit.Day).addAll(Arrays.asList(prefixArray));
        prefixArray = TranslationSource.getTranslation(locale, parseKey + "Week", "w").split(";");
        this.translationsParsingPrefixes.get((Object)DurationUnit.Week).addAll(Arrays.asList(prefixArray));
        prefixArray = TranslationSource.getTranslation(locale, parseKey + "Month", "mo").split(";");
        this.translationsParsingPrefixes.get((Object)DurationUnit.Month).addAll(Arrays.asList(prefixArray));
        prefixArray = TranslationSource.getTranslation(locale, parseKey + "Year", "y").split(";");
        this.translationsParsingPrefixes.get((Object)DurationUnit.Year).addAll(Arrays.asList(prefixArray));
    }

    public HashMap<DurationUnit, Boolean> getSimplePluralUnitsMap(boolean settingForAllUnits) {
        HashMap<DurationUnit, Boolean> result = new HashMap<DurationUnit, Boolean>();
        result.put(DurationUnit.Second, settingForAllUnits);
        result.put(DurationUnit.Minute, settingForAllUnits);
        result.put(DurationUnit.Hour, settingForAllUnits);
        result.put(DurationUnit.Day, settingForAllUnits);
        result.put(DurationUnit.Week, settingForAllUnits);
        result.put(DurationUnit.Month, settingForAllUnits);
        result.put(DurationUnit.Year, settingForAllUnits);
        return result;
    }
}

